/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.inference.reader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.ignite.ml.inference.reader.ModelReader;

public class InMemoryModelReader
implements ModelReader {
    private static final long serialVersionUID = -5518861989758691500L;
    private final byte[] data;

    public InMemoryModelReader(byte[] data) {
        this.data = data;
    }

    public <T extends Serializable> InMemoryModelReader(T obj) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(obj);
            oos.flush();
            this.data = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] read() {
        return this.data;
    }
}

