/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.distances;

import org.apache.ignite.ml.math.distances.DistanceMeasure;
import org.apache.ignite.ml.math.exceptions.math.CardinalityException;
import org.apache.ignite.ml.math.primitives.vector.Vector;
import org.apache.ignite.ml.math.util.MatrixUtil;

public class BrayCurtisDistance
implements DistanceMeasure {
    private static final long serialVersionUID = 1771556549784040091L;

    @Override
    public double compute(Vector a, Vector b) throws CardinalityException {
        double diff = MatrixUtil.localCopyOf(a).minus(b).kNorm(1.0);
        double sum = MatrixUtil.localCopyOf(a).plus(b).kNorm(1.0);
        return diff / sum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "BrayCurtisDistance{}";
    }
}

