/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.math.primitives.vector.storage;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.ml.math.primitives.vector.VectorStorage;

public class DenseVectorStorage
implements VectorStorage {
    private Serializable[] rawData;
    private double[] data;

    public DenseVectorStorage() {
    }

    public DenseVectorStorage(int size) {
        assert (size >= 0);
        this.data = new double[size];
    }

    public DenseVectorStorage(double[] data) {
        assert (data != null);
        this.data = data;
    }

    public DenseVectorStorage(Serializable[] data) {
        assert (data != null);
        this.rawData = data;
    }

    @Override
    public int size() {
        if (this.data == null && this.rawData == null) {
            return 0;
        }
        return this.data != null ? this.data.length : this.rawData.length;
    }

    private void toNumericArray() {
        A.ensure((this.data == null || this.rawData == null ? 1 : 0) != 0, (String)"data == null || rawData == null");
        if (this.data == null && this.rawData == null) {
            return;
        }
        if (this.data == null) {
            this.data = new double[this.rawData.length];
            for (int i = 0; i < this.rawData.length; ++i) {
                this.data[i] = this.rawData[i] == null ? 0.0 : ((Number)this.rawData[i]).doubleValue();
            }
            this.rawData = null;
        }
    }

    private void toGenericArray() {
        A.ensure((this.data == null || this.rawData == null ? 1 : 0) != 0, (String)"data == null || rawData == null");
        if (this.data == null && this.rawData == null) {
            return;
        }
        if (this.rawData == null) {
            this.rawData = new Serializable[this.data.length];
            for (int i = 0; i < this.rawData.length; ++i) {
                this.rawData[i] = Double.valueOf(this.data[i]);
            }
            this.data = null;
        }
    }

    @Override
    public double get(int i) {
        if (this.data != null) {
            return this.data[i];
        }
        Serializable v = this.rawData[i];
        return v == null ? 0.0 : ((Number)this.rawData[i]).doubleValue();
    }

    @Override
    public <T extends Serializable> T getRaw(int i) {
        this.toGenericArray();
        return (T)this.rawData[i];
    }

    @Override
    public void set(int i, double v) {
        if (this.data != null) {
            this.data[i] = v;
        } else {
            this.rawData[i] = Double.valueOf(v);
        }
    }

    @Override
    public void setRaw(int i, Serializable v) {
        this.toGenericArray();
        this.rawData[i] = v;
    }

    @Override
    public boolean isArrayBased() {
        return true;
    }

    @Override
    public double[] data() {
        if (!this.isNumeric()) {
            throw new ClassCastException("Vector has not only numeric values.");
        }
        this.toNumericArray();
        return this.data;
    }

    @Override
    public Serializable[] rawData() {
        this.toGenericArray();
        return this.rawData;
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isNumeric() {
        if (this.data != null || this.rawData == null) {
            return true;
        }
        for (int i = 0; i < this.rawData.length; ++i) {
            if (this.rawData[i] == null || this.rawData[i] instanceof Number) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean isRawVector = this.data == null;
        out.writeBoolean(isRawVector);
        if (this.data != null) {
            out.writeObject(this.data);
        } else {
            out.writeObject(this.rawData);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isRawVector = in.readBoolean();
        if (isRawVector) {
            this.rawData = (Serializable[])in.readObject();
            this.data = null;
        } else {
            this.rawData = null;
            this.data = (double[])in.readObject();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenseVectorStorage storage = (DenseVectorStorage)o;
        return Arrays.equals(this.rawData, storage.rawData) && Arrays.equals(this.data, storage.data);
    }

    public int hashCode() {
        int res = Arrays.hashCode(this.rawData);
        res = 31 * res + Arrays.hashCode(this.data);
        return res;
    }

    Serializable[] getRawData() {
        return this.rawData;
    }

    double[] getData() {
        return this.data;
    }
}

