/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.nn;

import org.apache.ignite.ml.math.functions.IgniteDifferentiableDoubleToDoubleFunction;

public class Activators {
    public static final IgniteDifferentiableDoubleToDoubleFunction SIGMOID = new IgniteDifferentiableDoubleToDoubleFunction(){

        @Override
        public double differential(double pnt) {
            double v = this.apply(pnt);
            return v * (1.0 - v);
        }

        @Override
        public Double apply(double val) {
            return 1.0 / (1.0 + Math.exp(-val));
        }
    };
    public static final IgniteDifferentiableDoubleToDoubleFunction RELU = new IgniteDifferentiableDoubleToDoubleFunction(){

        @Override
        public double differential(double pnt) {
            return pnt > 0.0 ? 1.0 : 0.0;
        }

        @Override
        public Double apply(double val) {
            return Math.max(val, 0.0);
        }
    };
    public static final IgniteDifferentiableDoubleToDoubleFunction LINEAR = new IgniteDifferentiableDoubleToDoubleFunction(){

        @Override
        public double differential(double pnt) {
            return 1.0;
        }

        @Override
        public Double apply(double pnt) {
            return pnt;
        }
    };
}

