/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.ClassificationMetricsAggregator;
import org.apache.ignite.ml.selection.scoring.evaluator.context.EmptyContext;
import org.apache.ignite.ml.selection.scoring.metric.Metric;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;

public class Accuracy<L extends Serializable>
implements Metric<L, EmptyContext<L>, ClassificationMetricsAggregator<L>> {
    private static final long serialVersionUID = -7042505196665295151L;
    private Double accuracy = Double.NaN;

    public Accuracy<L> initBy(ClassificationMetricsAggregator<L> aggr) {
        this.accuracy = (double)aggr.getValidAnswersCount() / (double)Math.max(aggr.getTotalNumberOfExamples(), 1L);
        return this;
    }

    @Override
    public ClassificationMetricsAggregator<L> makeAggregator() {
        return new ClassificationMetricsAggregator();
    }

    @Override
    public double value() {
        return this.accuracy;
    }

    @Override
    public MetricName name() {
        return MetricName.ACCURACY;
    }
}

