/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.selection.scoring.metric.classification;

import java.io.Serializable;
import org.apache.ignite.ml.selection.scoring.evaluator.aggregator.BinaryClassificationPointwiseMetricStatsAggregator;
import org.apache.ignite.ml.selection.scoring.metric.MetricName;
import org.apache.ignite.ml.selection.scoring.metric.classification.BinaryClassificationMetric;

public class Specificity<L extends Serializable>
extends BinaryClassificationMetric<L> {
    private static final long serialVersionUID = -2644409083604699500L;
    private Double value = Double.NaN;

    public Specificity() {
    }

    public Specificity(L truthLabel, L falseLabel) {
        super(truthLabel, falseLabel);
    }

    public Specificity<L> initBy(BinaryClassificationPointwiseMetricStatsAggregator<L> aggr) {
        int n = aggr.getTrueNegative() + aggr.getFalsePositive();
        this.value = n == 0 ? 1.0 : (double)aggr.getTrueNegative() / (double)n;
        return this;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public MetricName name() {
        return MetricName.SPECIFICITY;
    }
}

