/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.ml.sql;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.ml.inference.IgniteModelStorageUtil;
import org.apache.ignite.ml.inference.Model;
import org.apache.ignite.ml.math.primitives.vector.VectorUtils;
import org.apache.ignite.ml.recommendation.ObjectSubjectPair;
import org.apache.ignite.ml.util.LRUCache;

public class SQLFunctions {
    private static final int LRU_CACHE_SIZE = 10;
    private static final long CACHE_CLEAR_INTERVAL_SEC = 60L;
    private static final Map<String, Model<Serializable, Serializable>> cache = new LRUCache<String, Model>(10, Model::close);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @QuerySqlFunction
    public static double predict(String mdl, Double ... x) {
        Model infMdl;
        Map<String, Model<Serializable, Serializable>> map = cache;
        synchronized (map) {
            infMdl = cache.computeIfAbsent(mdl, key -> IgniteModelStorageUtil.getModel(Ignition.ignite(), mdl));
        }
        return (Double)((Serializable)infMdl.predict(VectorUtils.of(x)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @QuerySqlFunction
    public static double predictRecommendation(String mdl, Integer objId, Integer subjId) {
        Model infMdl;
        Map<String, Model<Serializable, Serializable>> map = cache;
        synchronized (map) {
            infMdl = cache.computeIfAbsent(mdl, key -> IgniteModelStorageUtil.getModel(Ignition.ignite(), mdl));
        }
        return (Double)((Serializable)infMdl.predict(new ObjectSubjectPair<Integer, Integer>(objId, subjId)));
    }

    static {
        Thread invalidationThread = new Thread(() -> {
            while (Thread.currentThread().isInterrupted()) {
                LockSupport.parkNanos(60000000000L);
            }
            Map<String, Model<Serializable, Serializable>> map = cache;
            synchronized (map) {
                for (Model<Serializable, Serializable> mdl : cache.values()) {
                    mdl.close();
                }
                cache.clear();
            }
        });
        invalidationThread.setDaemon(true);
        invalidationThread.start();
    }
}

