/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequestImpl;

class ReadOnlyDirectSingleRowReplicaRequestSerializer
implements MessageSerializer<ReadOnlyDirectSingleRowReplicaRequest> {
    public static final ReadOnlyDirectSingleRowReplicaRequestSerializer INSTANCE = new ReadOnlyDirectSingleRowReplicaRequestSerializer();

    private ReadOnlyDirectSingleRowReplicaRequestSerializer() {
    }

    public boolean writeMessage(ReadOnlyDirectSingleRowReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadOnlyDirectSingleRowReplicaRequestImpl message = (ReadOnlyDirectSingleRowReplicaRequestImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)6)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoxedLong("enlistmentConsistencyToken", message.enlistmentConsistencyToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("groupId", (NetworkMessage)message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeByteBuffer("primaryKey", message.primaryKey());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                int ordinalShifted = message.requestType() == null ? 0 : message.requestType().ordinal() + 1;
                boolean written = writer.writeInt("requestType", ordinalShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

