/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.http.jetty;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.processors.cache.CacheConfigurationOverride;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.protocols.http.jetty.GridJettyObjectMapper;
import org.apache.ignite.internal.processors.rest.request.DataStructuresRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestChangeStateRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestLogRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTaskRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestTopologyRequest;
import org.apache.ignite.internal.processors.rest.request.RestQueryRequest;
import org.apache.ignite.internal.processors.rest.request.RestUserActionRequest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jetbrains.annotations.Nullable;

public class GridJettyRestHandler
extends AbstractHandler {
    private static final String CHARSET = StandardCharsets.UTF_8.name();
    private static final String USER_PARAM = "user";
    private static final String PWD_PARAM = "password";
    private static final String CACHE_NAME_PARAM = "cacheName";
    private static final String BACKUPS_PARAM = "backups";
    private static final String CACHE_GROUP_PARAM = "cacheGroup";
    private static final String DATA_REGION_PARAM = "dataRegion";
    private static final String WRITE_SYNCHRONIZATION_MODE_PARAM = "writeSynchronizationMode";
    private static final String IGNITE_LOGIN = "ignite.login";
    private static final String IGNITE_PASSWORD = "ignite.password";
    private static final String TEMPLATE_NAME_PARAM = "templateName";
    private static final NullOutputStream NULL_OUTPUT_STREAM = new NullOutputStream();
    private final IgniteLogger log;
    private final IgniteClosure<String, Boolean> authChecker;
    private GridRestProtocolHandler hnd;
    private volatile String dfltPage;
    private volatile byte[] favicon;
    private final ObjectMapper jsonMapper;

    GridJettyRestHandler(GridRestProtocolHandler hnd, IgniteClosure<String, Boolean> authChecker, IgniteLogger log) {
        assert (hnd != null);
        assert (log != null);
        this.hnd = hnd;
        this.log = log;
        this.authChecker = authChecker;
        this.jsonMapper = new GridJettyObjectMapper();
        try {
            this.initDefaultPage();
            if (log.isDebugEnabled()) {
                log.debug("Initialized default page.");
            }
        }
        catch (IOException e) {
            U.warn((IgniteLogger)log, (Object)("Failed to initialize default page: " + e.getMessage()));
        }
        try {
            this.initFavicon();
            if (log.isDebugEnabled()) {
                log.debug(this.favicon != null ? "Initialized favicon, size: " + this.favicon.length : "Favicon is null.");
            }
        }
        catch (IOException e) {
            U.warn((IgniteLogger)log, (Object)("Failed to initialize favicon: " + e.getMessage()));
        }
    }

    @Nullable
    private static Long longValue(String key, Map<String, Object> params, Long dfltVal) throws IgniteCheckedException {
        assert (key != null);
        String val = (String)params.get(key);
        try {
            return val == null ? dfltVal : Long.valueOf(val);
        }
        catch (NumberFormatException ignore) {
            throw new IgniteCheckedException("Failed to parse parameter of Long type [" + key + "=" + val + "]");
        }
    }

    private static int intValue(String key, Map<String, Object> params, int dfltVal) throws IgniteCheckedException {
        assert (key != null);
        String val = (String)params.get(key);
        try {
            return val == null ? dfltVal : Integer.parseInt(val);
        }
        catch (NumberFormatException ignore) {
            throw new IgniteCheckedException("Failed to parse parameter of Integer type [" + key + "=" + val + "]");
        }
    }

    @Nullable
    private static UUID uuidValue(String key, Map<String, Object> params) throws IgniteCheckedException {
        assert (key != null);
        String val = (String)params.get(key);
        try {
            return val == null ? null : UUID.fromString(val);
        }
        catch (NumberFormatException ignore) {
            throw new IgniteCheckedException("Failed to parse parameter of UUID type [" + key + "=" + val + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDefaultPage() throws IOException {
        assert (this.dfltPage == null);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("rest.html");
        if (in != null) {
            LineNumberReader rdr = new LineNumberReader(new InputStreamReader(in, CHARSET));
            try {
                StringBuilder buf = new StringBuilder(2048);
                String line = rdr.readLine();
                while (line != null) {
                    buf.append(line);
                    if (!line.endsWith(" ")) {
                        buf.append(' ');
                    }
                    line = rdr.readLine();
                }
                this.dfltPage = buf.toString();
            }
            finally {
                U.closeQuiet((AutoCloseable)rdr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFavicon() throws IOException {
        assert (this.favicon == null);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("favicon.ico");
        if (in != null) {
            BufferedInputStream bis = new BufferedInputStream(in);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int n;
                byte[] buf = new byte[2048];
                while ((n = bis.read(buf)) != -1) {
                    bos.write(buf, 0, n);
                }
                this.favicon = bos.toByteArray();
            }
            finally {
                U.closeQuiet((AutoCloseable)bis);
            }
        }
    }

    public void handle(String target, Request req, HttpServletRequest srvReq, HttpServletResponse res) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling request [target=" + target + ", req=" + req + ", srvReq=" + srvReq + ']');
        }
        if (target.startsWith("/ignite")) {
            this.processRequest(target, srvReq, res);
            req.setHandled(true);
        } else if (target.startsWith("/favicon.ico")) {
            if (this.favicon == null) {
                res.setStatus(404);
                req.setHandled(true);
                return;
            }
            res.setStatus(200);
            res.setContentType("image/x-icon");
            res.getOutputStream().write(this.favicon);
            res.getOutputStream().flush();
            req.setHandled(true);
        } else {
            if (this.dfltPage == null) {
                res.setStatus(404);
                req.setHandled(true);
                return;
            }
            res.setStatus(200);
            res.setContentType("text/html");
            res.getWriter().write(this.dfltPage);
            res.getWriter().flush();
            req.setHandled(true);
        }
    }

    private void processRequest(String act, HttpServletRequest req, HttpServletResponse res) {
        GridRestResponse cmdRes;
        res.setContentType("application/json");
        res.setCharacterEncoding("UTF-8");
        GridRestCommand cmd = this.command((ServletRequest)req);
        if (cmd == null) {
            res.setStatus(400);
            return;
        }
        if (!((Boolean)this.authChecker.apply((Object)req.getHeader("X-Signature"))).booleanValue()) {
            res.setStatus(401);
            return;
        }
        Map<String, Object> params = this.parameters((ServletRequest)req);
        try {
            GridRestRequest cmdReq = this.createRequest(cmd, params, req);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized command request: " + cmdReq);
            }
            if ((cmdRes = this.hnd.handle(cmdReq)) == null) {
                throw new IllegalStateException("Received null result from handler: " + this.hnd);
            }
            byte[] sesTok = cmdRes.sessionTokenBytes();
            if (sesTok != null) {
                cmdRes.setSessionToken(U.byteArray2HexString((byte[])sesTok));
            }
            res.setStatus(200);
        }
        catch (Throwable e) {
            res.setStatus(200);
            U.error((IgniteLogger)this.log, (Object)("Failed to process HTTP request [action=" + act + ", req=" + req + ']'), (Throwable)e);
            if (e instanceof Error) {
                throw (Error)e;
            }
            cmdRes = new GridRestResponse(1, e.getMessage());
        }
        try (ServletOutputStream os = res.getOutputStream();){
            try {
                this.jsonMapper.writeValue((OutputStream)NULL_OUTPUT_STREAM, (Object)cmdRes);
                this.jsonMapper.writeValue((OutputStream)os, (Object)cmdRes);
            }
            catch (JsonProcessingException e) {
                U.error((IgniteLogger)this.log, (Object)("Failed to convert response to JSON: " + cmdRes), (Throwable)e);
                this.jsonMapper.writeValue((OutputStream)os, (Object)new GridRestResponse(1, e.getMessage()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processed HTTP request [action=" + act + ", jsonRes=" + cmdRes + ", req=" + req + ']');
            }
        }
        catch (IOException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to send HTTP response: " + cmdRes), (Throwable)e);
        }
    }

    private Object convert(String type, Object obj) throws IgniteCheckedException {
        if (F.isEmpty((String)type) || obj == null) {
            return obj;
        }
        String s = (String)obj;
        try {
            switch (type.toLowerCase()) {
                case "boolean": 
                case "java.lang.boolean": {
                    return Boolean.valueOf(s);
                }
                case "byte": 
                case "java.lang.byte": {
                    return Byte.valueOf(s);
                }
                case "short": 
                case "java.lang.short": {
                    return Short.valueOf(s);
                }
                case "int": 
                case "integer": 
                case "java.lang.integer": {
                    return Integer.valueOf(s);
                }
                case "long": 
                case "java.lang.long": {
                    return Long.valueOf(s);
                }
                case "float": 
                case "java.lang.float": {
                    return Float.valueOf(s);
                }
                case "double": 
                case "java.lang.double": {
                    return Double.valueOf(s);
                }
                case "date": 
                case "java.sql.date": {
                    return Date.valueOf(s);
                }
                case "time": 
                case "java.sql.time": {
                    return Time.valueOf(s);
                }
                case "timestamp": 
                case "java.sql.timestamp": {
                    return Timestamp.valueOf(s);
                }
                case "uuid": 
                case "java.util.uuid": {
                    return UUID.fromString(s);
                }
                case "igniteuuid": 
                case "org.apache.ignite.lang.igniteuuid": {
                    return IgniteUuid.fromString((String)s);
                }
            }
        }
        catch (Throwable e) {
            throw new IgniteCheckedException("Failed to convert value to specified type [type=" + type + ", val=" + s + ", reason=" + e.getClass().getName() + ": " + e.getMessage() + "]");
        }
        return obj;
    }

    @Nullable
    private GridRestRequest createRequest(GridRestCommand cmd, Map<String, Object> params, HttpServletRequest req) throws IgniteCheckedException {
        GridRestRequest restReq;
        switch (cmd) {
            case GET_OR_CREATE_CACHE: {
                String wrtSyncMode;
                String dataRegion;
                String cacheGrp;
                GridRestCacheRequest restReq0 = new GridRestCacheRequest();
                restReq0.cacheName((String)params.get(CACHE_NAME_PARAM));
                String templateName = (String)params.get(TEMPLATE_NAME_PARAM);
                if (!F.isEmpty((String)templateName)) {
                    restReq0.templateName(templateName);
                }
                String backups = (String)params.get(BACKUPS_PARAM);
                CacheConfigurationOverride cfg = new CacheConfigurationOverride();
                if (!F.isEmpty((String)backups)) {
                    try {
                        cfg.backups(Integer.valueOf(Integer.parseInt(backups)));
                    }
                    catch (NumberFormatException e) {
                        throw new IgniteCheckedException("Failed to parse number of cache backups: " + backups, (Throwable)e);
                    }
                }
                if (!F.isEmpty((String)(cacheGrp = (String)params.get(CACHE_GROUP_PARAM)))) {
                    cfg.cacheGroup(cacheGrp);
                }
                if (!F.isEmpty((String)(dataRegion = (String)params.get(DATA_REGION_PARAM)))) {
                    cfg.dataRegion(dataRegion);
                }
                if (!F.isEmpty((String)(wrtSyncMode = (String)params.get(WRITE_SYNCHRONIZATION_MODE_PARAM)))) {
                    try {
                        cfg.writeSynchronizationMode(CacheWriteSynchronizationMode.valueOf((String)wrtSyncMode));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IgniteCheckedException("Failed to parse cache write synchronization mode: " + wrtSyncMode, (Throwable)e);
                    }
                }
                if (!cfg.isEmpty()) {
                    restReq0.configuration(cfg);
                }
                restReq = restReq0;
                break;
            }
            case DESTROY_CACHE: {
                GridRestCacheRequest restReq0 = new GridRestCacheRequest();
                restReq0.cacheName((String)params.get(CACHE_NAME_PARAM));
                restReq = restReq0;
                break;
            }
            case ATOMIC_DECREMENT: 
            case ATOMIC_INCREMENT: {
                GridRestCacheRequest restReq0 = new DataStructuresRequest();
                restReq0.key(params.get("key"));
                restReq0.initial(GridJettyRestHandler.longValue("init", params, null));
                restReq0.delta(GridJettyRestHandler.longValue("delta", params, null));
                restReq = restReq0;
                break;
            }
            case CACHE_CONTAINS_KEY: 
            case CACHE_CONTAINS_KEYS: 
            case CACHE_GET: 
            case CACHE_GET_ALL: 
            case CACHE_GET_AND_PUT: 
            case CACHE_GET_AND_REPLACE: 
            case CACHE_PUT_IF_ABSENT: 
            case CACHE_GET_AND_PUT_IF_ABSENT: 
            case CACHE_PUT: 
            case CACHE_PUT_ALL: 
            case CACHE_REMOVE: 
            case CACHE_REMOVE_VALUE: 
            case CACHE_REPLACE_VALUE: 
            case CACHE_GET_AND_REMOVE: 
            case CACHE_REMOVE_ALL: 
            case CACHE_CLEAR: 
            case CACHE_ADD: 
            case CACHE_CAS: 
            case CACHE_METRICS: 
            case CACHE_SIZE: 
            case CACHE_METADATA: 
            case CACHE_REPLACE: 
            case CACHE_APPEND: 
            case CACHE_PREPEND: {
                GridRestCacheRequest restReq0 = new GridRestCacheRequest();
                String cacheName = (String)params.get(CACHE_NAME_PARAM);
                restReq0.cacheName(F.isEmpty((String)cacheName) ? null : cacheName);
                String keyType = (String)params.get("keyType");
                String valType = (String)params.get("valueType");
                restReq0.key(this.convert(keyType, params.get("key")));
                restReq0.value(this.convert(valType, params.get("val")));
                restReq0.value2(this.convert(valType, params.get("val2")));
                Object val1 = this.convert(valType, params.get("val1"));
                if (val1 != null) {
                    restReq0.value(val1);
                }
                restReq0.cacheFlags(GridJettyRestHandler.intValue("cacheFlags", params, 2));
                restReq0.ttl(GridJettyRestHandler.longValue("exp", params, null));
                if (cmd == GridRestCommand.CACHE_GET_ALL || cmd == GridRestCommand.CACHE_PUT_ALL || cmd == GridRestCommand.CACHE_REMOVE_ALL || cmd == GridRestCommand.CACHE_CONTAINS_KEYS) {
                    List<Object> keys = this.values(keyType, "k", params);
                    List<Object> vals = this.values(valType, "v", params);
                    if (keys.size() < vals.size()) {
                        throw new IgniteCheckedException("Number of keys must be greater or equals to number of values.");
                    }
                    HashMap map = U.newHashMap((int)keys.size());
                    Iterator<Object> keyIt = keys.iterator();
                    Iterator<Object> valIt = vals.iterator();
                    while (keyIt.hasNext()) {
                        map.put(keyIt.next(), valIt.hasNext() ? valIt.next() : null);
                    }
                    restReq0.values((Map)map);
                }
                restReq = restReq0;
                break;
            }
            case TOPOLOGY: 
            case NODE: {
                GridRestCacheRequest restReq0 = new GridRestTopologyRequest();
                restReq0.includeMetrics(Boolean.parseBoolean((String)params.get("mtr")));
                restReq0.includeAttributes(Boolean.parseBoolean((String)params.get("attr")));
                restReq0.nodeIp((String)params.get("ip"));
                restReq0.nodeId(GridJettyRestHandler.uuidValue("id", params));
                restReq = restReq0;
                break;
            }
            case EXE: 
            case RESULT: 
            case NOOP: {
                GridRestCacheRequest restReq0 = new GridRestTaskRequest();
                restReq0.taskId((String)params.get("id"));
                restReq0.taskName((String)params.get("name"));
                restReq0.params(this.values(null, "p", params));
                restReq0.async(Boolean.parseBoolean((String)params.get("async")));
                restReq0.timeout(GridJettyRestHandler.longValue("timeout", params, 0L).longValue());
                restReq = restReq0;
                break;
            }
            case LOG: {
                GridRestCacheRequest restReq0 = new GridRestLogRequest();
                restReq0.path((String)params.get("path"));
                restReq0.from(GridJettyRestHandler.intValue("from", params, -1));
                restReq0.to(GridJettyRestHandler.intValue("to", params, -1));
                restReq = restReq0;
                break;
            }
            case NAME: 
            case VERSION: {
                restReq = new GridRestRequest();
                break;
            }
            case CLUSTER_ACTIVE: 
            case CLUSTER_INACTIVE: 
            case CLUSTER_CURRENT_STATE: {
                GridRestCacheRequest restReq0 = new GridRestChangeStateRequest();
                if (cmd == GridRestCommand.CLUSTER_CURRENT_STATE) {
                    restReq0.reqCurrentState();
                } else {
                    restReq0.active(cmd == GridRestCommand.CLUSTER_ACTIVE);
                }
                restReq = restReq0;
                break;
            }
            case AUTHENTICATE: {
                restReq = new GridRestRequest();
                break;
            }
            case ADD_USER: 
            case REMOVE_USER: 
            case UPDATE_USER: {
                GridRestCacheRequest restReq0 = new RestUserActionRequest();
                restReq0.user((String)params.get(USER_PARAM));
                restReq0.password((String)params.get(PWD_PARAM));
                restReq = restReq0;
                break;
            }
            case EXECUTE_SQL_QUERY: 
            case EXECUTE_SQL_FIELDS_QUERY: {
                String distributedJoins;
                GridRestCacheRequest restReq0 = new RestQueryRequest();
                restReq0.sqlQuery((String)params.get("qry"));
                restReq0.arguments(this.values(null, "arg", params).toArray());
                restReq0.typeName((String)params.get("type"));
                String pageSize = (String)params.get("pageSize");
                if (pageSize != null) {
                    restReq0.pageSize(Integer.valueOf(Integer.parseInt(pageSize)));
                }
                if ((distributedJoins = (String)params.get("distributedJoins")) != null) {
                    restReq0.distributedJoins(Boolean.parseBoolean(distributedJoins));
                }
                restReq0.cacheName((String)params.get(CACHE_NAME_PARAM));
                if (cmd == GridRestCommand.EXECUTE_SQL_QUERY) {
                    restReq0.queryType(RestQueryRequest.QueryType.SQL);
                } else {
                    restReq0.queryType(RestQueryRequest.QueryType.SQL_FIELDS);
                }
                restReq = restReq0;
                break;
            }
            case EXECUTE_SCAN_QUERY: {
                GridRestCacheRequest restReq0 = new RestQueryRequest();
                restReq0.sqlQuery((String)params.get("qry"));
                String pageSize = (String)params.get("pageSize");
                if (pageSize != null) {
                    restReq0.pageSize(Integer.valueOf(Integer.parseInt(pageSize)));
                }
                restReq0.cacheName((String)params.get(CACHE_NAME_PARAM));
                restReq0.className((String)params.get("className"));
                restReq0.queryType(RestQueryRequest.QueryType.SCAN);
                restReq = restReq0;
                break;
            }
            case FETCH_SQL_QUERY: {
                String pageSize;
                GridRestCacheRequest restReq0 = new RestQueryRequest();
                String qryId = (String)params.get("qryId");
                if (qryId != null) {
                    restReq0.queryId(Long.valueOf(Long.parseLong(qryId)));
                }
                if ((pageSize = (String)params.get("pageSize")) != null) {
                    restReq0.pageSize(Integer.valueOf(Integer.parseInt(pageSize)));
                }
                restReq0.cacheName((String)params.get(CACHE_NAME_PARAM));
                restReq = restReq0;
                break;
            }
            case CLOSE_SQL_QUERY: {
                GridRestCacheRequest restReq0 = new RestQueryRequest();
                String qryId = (String)params.get("qryId");
                if (qryId != null) {
                    restReq0.queryId(Long.valueOf(Long.parseLong(qryId)));
                }
                restReq0.cacheName((String)params.get(CACHE_NAME_PARAM));
                restReq = restReq0;
                break;
            }
            default: {
                throw new IgniteCheckedException("Invalid command: " + cmd);
            }
        }
        restReq.address(new InetSocketAddress(req.getRemoteAddr(), req.getRemotePort()));
        restReq.command(cmd);
        if (!this.credentials(params, IGNITE_LOGIN, IGNITE_PASSWORD, restReq)) {
            this.credentials(params, USER_PARAM, PWD_PARAM, restReq);
        }
        String clientId = (String)params.get("clientId");
        try {
            if (clientId != null) {
                restReq.clientId(UUID.fromString(clientId));
            }
        }
        catch (Exception qryId) {
            // empty catch block
        }
        String destId = (String)params.get("destId");
        try {
            if (destId != null) {
                restReq.destinationId(UUID.fromString(destId));
            }
        }
        catch (IllegalArgumentException pageSize) {
            // empty catch block
        }
        String sesTokStr = (String)params.get("sessionToken");
        try {
            byte[] bytes;
            if (sesTokStr != null && (bytes = U.hexString2ByteArray((String)sesTokStr)).length == 16) {
                restReq.sessionToken(bytes);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return restReq;
    }

    private boolean credentials(Map<String, Object> params, String userParam, String pwdParam, GridRestRequest restReq) {
        boolean hasCreds;
        boolean bl = hasCreds = params.containsKey(userParam) || params.containsKey(pwdParam);
        if (hasCreds) {
            SecurityCredentials cred = new SecurityCredentials((String)params.get(userParam), (String)params.get(pwdParam));
            restReq.credentials((Object)cred);
        }
        return hasCreds;
    }

    protected List<Object> values(String type, String keyPrefix, Map<String, Object> params) throws IgniteCheckedException {
        String key;
        assert (keyPrefix != null);
        LinkedList<Object> vals = new LinkedList<Object>();
        int i = 1;
        while (params.containsKey(key = keyPrefix + i)) {
            vals.add(this.convert(type, params.get(key)));
            ++i;
        }
        return vals;
    }

    @Nullable
    private GridRestCommand command(ServletRequest req) {
        String cmd = req.getParameter("cmd");
        return cmd == null ? null : GridRestCommand.fromKey((String)cmd.toLowerCase());
    }

    private Map<String, Object> parameters(ServletRequest req) {
        Map params = req.getParameterMap();
        if (F.isEmpty((Map)params)) {
            return Collections.emptyMap();
        }
        HashMap map = U.newHashMap((int)params.size());
        for (Map.Entry entry : params.entrySet()) {
            map.put(entry.getKey(), this.parameter(entry.getValue()));
        }
        return map;
    }

    @Nullable
    private String parameter(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof String[] && ((String[])obj).length > 0) {
            return ((String[])obj)[0];
        }
        return null;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }
    }
}

