/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata.proxy;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.springdata.proxy.IgniteCacheProxy;
import org.jetbrains.annotations.NotNull;

public class IgniteClientCacheProxy<K, V>
implements IgniteCacheProxy<K, V> {
    private final ClientCache<K, V> cache;

    public IgniteClientCacheProxy(ClientCache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public V get(K key) throws ClientException {
        return (V)this.cache.get(key);
    }

    @Override
    public void put(K key, V val) throws ClientException {
        this.cache.put(key, val);
    }

    @Override
    public int size(CachePeekMode ... peekModes) throws ClientException {
        return this.cache.size(peekModes);
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) throws ClientException {
        return this.cache.getAll(keys);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) throws ClientException {
        this.cache.putAll(map);
    }

    @Override
    public boolean remove(K key) throws ClientException {
        return this.cache.remove(key);
    }

    @Override
    public void removeAll(Set<? extends K> keys) throws ClientException {
        this.cache.removeAll(keys);
    }

    @Override
    public void clear() throws ClientException {
        this.cache.clear();
    }

    @Override
    public IgniteCacheProxy<K, V> withExpiryPolicy(ExpiryPolicy expirePlc) {
        return new IgniteClientCacheProxy<K, V>(this.cache.withExpirePolicy(expirePlc));
    }

    @Override
    public <R> QueryCursor<R> query(Query<R> qry) {
        return this.cache.query(qry);
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    @NotNull
    public Iterator<Cache.Entry<K, V>> iterator() {
        return this.cache.query((Query)new ScanQuery()).getAll().iterator();
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public IgniteCacheProxy<K, V> withSkipStore() {
        return this;
    }

    @Override
    public V getAndPutIfAbsent(K key, V val) {
        return (V)this.cache.getAndPutIfAbsent(key, val);
    }

    @Override
    public void removeAll() {
        this.cache.removeAll();
    }

    public ClientCache<K, V> delegate() {
        return this.cache;
    }
}

