/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.springdata22.repository.query;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class QueryUtils {
    public static final String COUNT_QUERY_STRING = "select count(%s) from %s x";
    public static final String DELETE_ALL_QUERY_STRING = "delete from %s x";
    private static final String IDENTIFIER = "[._[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{P}]]+";
    static final String COLON_NO_DOUBLE_COLON = "(?<![:\\\\]):";
    static final String IDENTIFIER_GROUP = String.format("(%s)", "[._[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{P}]]+");
    private static final String COUNT_REPLACEMENT_TEMPLATE = "select count(%s) $5$6$7";
    private static final String SIMPLE_COUNT_VALUE = "$2";
    private static final String COMPLEX_COUNT_VALUE = "$3$6";
    private static final String ORDER_BY_PART = "(?iu)\\s+order\\s+by\\s+.*$";
    private static final Pattern ALIAS_MATCH;
    private static final Pattern COUNT_MATCH;
    private static final Pattern PROJECTION_CLAUSE;
    private static final String JOIN;
    private static final Pattern JOIN_PATTERN;
    private static final String EQUALS_CONDITION_STRING = "%s.%s = :%s";
    private static final Pattern NAMED_PARAMETER;
    private static final Pattern CONSTRUCTOR_EXPRESSION;
    private static final int QUERY_JOIN_ALIAS_GROUP_INDEX = 3;
    private static final int VARIABLE_NAME_GROUP_INDEX = 4;
    private static final Pattern FUNCTION_PATTERN;

    private QueryUtils() {
    }

    public static String getExistsQueryString(String entityName, String cntQryPlaceHolder, Iterable<String> idAttrs) {
        String whereClause = Streamable.of(idAttrs).stream().map(idAttribute -> String.format(EQUALS_CONDITION_STRING, "x", idAttribute, idAttribute)).collect(Collectors.joining(" AND ", " WHERE ", ""));
        return String.format(COUNT_QUERY_STRING, cntQryPlaceHolder, entityName) + whereClause;
    }

    public static String getQueryString(String template, String entityName) {
        Assert.hasText((String)entityName, (String)"Entity name must not be null or empty!");
        return String.format(template, entityName);
    }

    static Set<String> getOuterJoinAliases(String qry) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = JOIN_PATTERN.matcher(qry);
        while (matcher.find()) {
            String alias = matcher.group(3);
            if (!StringUtils.hasText((String)alias)) continue;
            result.add(alias);
        }
        return result;
    }

    static Set<String> getFunctionAliases(String qry) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = FUNCTION_PATTERN.matcher(qry);
        while (matcher.find()) {
            String alias = matcher.group(1);
            if (!StringUtils.hasText((String)alias)) continue;
            result.add(alias);
        }
        return result;
    }

    @Nullable
    static String detectAlias(String qry) {
        Matcher matcher = ALIAS_MATCH.matcher(qry);
        return matcher.find() ? matcher.group(2) : null;
    }

    static String createCountQueryFor(String originalQry, @Nullable String cntProjection) {
        String countQuery;
        Assert.hasText((String)originalQry, (String)"OriginalQuery must not be null or empty!");
        Matcher matcher = COUNT_MATCH.matcher(originalQry);
        if (cntProjection == null) {
            String variable = matcher.matches() ? matcher.group(4) : null;
            boolean useVariable = variable != null && StringUtils.hasText((String)variable) && !variable.startsWith("new") && !variable.startsWith("count(") && !variable.contains(",");
            String replacement = useVariable ? SIMPLE_COUNT_VALUE : COMPLEX_COUNT_VALUE;
            countQuery = matcher.replaceFirst(String.format(COUNT_REPLACEMENT_TEMPLATE, replacement));
        } else {
            countQuery = matcher.replaceFirst(String.format(COUNT_REPLACEMENT_TEMPLATE, cntProjection));
        }
        return countQuery.replaceFirst(ORDER_BY_PART, "");
    }

    public static boolean hasConstructorExpression(String qry) {
        Assert.hasText((String)qry, (String)"Query must not be null or empty!");
        return CONSTRUCTOR_EXPRESSION.matcher(qry).find();
    }

    public static String getProjection(String qry) {
        Assert.hasText((String)qry, (String)"Query must not be null or empty!");
        Matcher matcher = PROJECTION_CLAUSE.matcher(qry);
        String projection = matcher.find() ? matcher.group(1) : "";
        return projection.trim();
    }

    static {
        PROJECTION_CLAUSE = Pattern.compile("select\\s+(.+)\\s+from", 2);
        JOIN = "join\\s+(fetch\\s+)?[._[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{P}]]+\\s+(as\\s+)?" + IDENTIFIER_GROUP;
        JOIN_PATTERN = Pattern.compile(JOIN, 2);
        NAMED_PARAMETER = Pattern.compile("(?<![:\\\\]):[._[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{P}]]+|\\#[._[\\P{Z}&&\\P{Cc}&&\\P{Cf}&&\\P{P}]]+", 2);
        StringBuilder builder = new StringBuilder();
        builder.append("(?<=from)");
        builder.append("(?:\\s)+");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(?:\\sas)*");
        builder.append("(?:\\s)+");
        builder.append("(?!(?:where))(\\w+)");
        ALIAS_MATCH = Pattern.compile(builder.toString(), 2);
        builder = new StringBuilder();
        builder.append("(select\\s+((distinct )?(.+?)?)\\s+)?(from\\s+");
        builder.append(IDENTIFIER);
        builder.append("(?:\\s+as)?\\s+)");
        builder.append(IDENTIFIER_GROUP);
        builder.append("(.*)");
        COUNT_MATCH = Pattern.compile(builder.toString(), 2);
        builder = new StringBuilder();
        builder.append("select");
        builder.append("\\s+");
        builder.append("(.*\\s+)?");
        builder.append("new");
        builder.append("\\s+");
        builder.append(IDENTIFIER);
        builder.append("\\s*");
        builder.append("\\(");
        builder.append(".*");
        builder.append("\\)");
        CONSTRUCTOR_EXPRESSION = Pattern.compile(builder.toString(), 34);
        builder = new StringBuilder();
        builder.append("\\w+\\s*\\([\\w\\.,\\s'=]+\\)");
        builder.append("\\s+[as|AS]+\\s+(([\\w\\.]+))");
        FUNCTION_PATTERN = Pattern.compile(builder.toString());
    }
}

