/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.transactions.spring;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.spring.IgniteTransactionHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
PlatformTransactionManager,
InitializingBean {
    private IgniteLogger log;
    private TransactionConcurrency transactionConcurrency;
    private String cfgPath;
    private IgniteConfiguration cfg;
    private String gridName;
    private Ignite ignite;

    public SpringTransactionManager() {
        this.setNestedTransactionAllowed(false);
    }

    public TransactionConcurrency getTransactionConcurrency() {
        return this.transactionConcurrency;
    }

    public void setTransactionConcurrency(TransactionConcurrency transactionConcurrency) {
        this.transactionConcurrency = transactionConcurrency;
    }

    public String getConfigurationPath() {
        return this.cfgPath;
    }

    public void setConfigurationPath(String cfgPath) {
        this.cfgPath = cfgPath;
    }

    public IgniteConfiguration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(IgniteConfiguration cfg) {
        this.cfg = cfg;
    }

    public String getGridName() {
        return this.gridName;
    }

    public void setGridName(String gridName) {
        this.gridName = gridName;
    }

    public void afterPropertiesSet() throws Exception {
        assert (this.ignite == null);
        if (this.cfgPath != null && this.cfg != null) {
            throw new IllegalArgumentException("Both 'configurationPath' and 'configuration' are provided. Set only one of these properties if you need to start a Ignite node inside of SpringCacheManager. If you already have a node running, omit both of them and set'gridName' property.");
        }
        this.ignite = this.cfgPath != null ? Ignition.start((String)this.cfgPath) : (this.cfg != null ? Ignition.start((IgniteConfiguration)this.cfg) : Ignition.ignite((String)this.gridName));
        if (this.transactionConcurrency == null) {
            this.transactionConcurrency = this.ignite.configuration().getTransactionConfiguration().getDefaultTxConcurrency();
        }
        this.log = this.ignite.log();
    }

    protected Object doGetTransaction() throws TransactionException {
        IgniteTransactionObject txObject = new IgniteTransactionObject();
        txObject.setTransactionHolder((IgniteTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.ignite)), false);
        return txObject;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        if (definition.getIsolationLevel() == 1) {
            throw new InvalidIsolationLevelException("Ignite does not support READ_UNCOMMITTED isolation level.");
        }
        IgniteTransactionObject txObject = (IgniteTransactionObject)transaction;
        Transaction tx = null;
        try {
            if (txObject.getTransactionHolder() == null || txObject.getTransactionHolder().isSynchronizedWithTransaction()) {
                long timeout = this.ignite.configuration().getTransactionConfiguration().getDefaultTxTimeout();
                if (definition.getTimeout() > 0) {
                    timeout = TimeUnit.SECONDS.toMillis(definition.getTimeout());
                }
                Transaction newTx = this.ignite.transactions().txStart(this.transactionConcurrency, this.convertToIgniteIsolationLevel(definition.getIsolationLevel()), timeout, 0);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Started Ignite transaction: " + newTx);
                }
                txObject.setTransactionHolder(new IgniteTransactionHolder(newTx), true);
            }
            txObject.getTransactionHolder().setSynchronizedWithTransaction(true);
            txObject.getTransactionHolder().setTransactionActive(true);
            tx = txObject.getTransactionHolder().getTransaction();
            if (txObject.isNewTransactionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.ignite, (Object)((Object)txObject.getTransactionHolder()));
            }
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.close();
            }
            throw new CannotCreateTransactionException("Could not create Ignite transaction", (Throwable)ex);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        IgniteTransactionObject txObject = (IgniteTransactionObject)status.getTransaction();
        Transaction tx = txObject.getTransactionHolder().getTransaction();
        if (status.isDebug() && this.log.isDebugEnabled()) {
            this.log.debug("Committing Ignite transaction: " + tx);
        }
        try {
            tx.commit();
        }
        catch (IgniteException e) {
            throw new TransactionSystemException("Could not commit Ignite transaction", (Throwable)e);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        IgniteTransactionObject txObject = (IgniteTransactionObject)status.getTransaction();
        Transaction tx = txObject.getTransactionHolder().getTransaction();
        if (status.isDebug() && this.log.isDebugEnabled()) {
            this.log.debug("Rolling back Ignite transaction: " + tx);
        }
        try {
            tx.rollback();
        }
        catch (IgniteException e) {
            throw new TransactionSystemException("Could not rollback Ignite transaction", (Throwable)e);
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        IgniteTransactionObject txObject = (IgniteTransactionObject)transaction;
        if (txObject.isNewTransactionHolder()) {
            Transaction tx = txObject.getTransactionHolder().getTransaction();
            TransactionSynchronizationManager.unbindResource((Object)this.ignite);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Releasing Ignite transaction: " + tx);
            }
        }
        txObject.getTransactionHolder().clear();
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        IgniteTransactionObject txObject = (IgniteTransactionObject)transaction;
        return txObject.getTransactionHolder() != null && txObject.getTransactionHolder().isTransactionActive();
    }

    public Object getResourceFactory() {
        return this.ignite;
    }

    private TransactionIsolation convertToIgniteIsolationLevel(int isolationLevel) {
        TransactionIsolation isolation = this.ignite.configuration().getTransactionConfiguration().getDefaultTxIsolation();
        switch (isolationLevel) {
            case 2: {
                isolation = TransactionIsolation.READ_COMMITTED;
                break;
            }
            case 4: {
                isolation = TransactionIsolation.REPEATABLE_READ;
                break;
            }
            case 8: {
                isolation = TransactionIsolation.SERIALIZABLE;
            }
        }
        return isolation;
    }

    private static class IgniteTransactionObject {
        private IgniteTransactionHolder transactionHolder;
        private boolean newTransactionHolder;

        private IgniteTransactionObject() {
        }

        private void setTransactionHolder(IgniteTransactionHolder transactionHolder, boolean newHolder) {
            this.transactionHolder = transactionHolder;
            this.newTransactionHolder = newHolder;
        }

        private IgniteTransactionHolder getTransactionHolder() {
            return this.transactionHolder;
        }

        private boolean isNewTransactionHolder() {
            return this.newTransactionHolder;
        }
    }
}

