/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import org.apache.ignite.IgniteCache;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

class SpringCache
implements Cache {
    private final IgniteCache<Object, Object> cache;

    SpringCache(IgniteCache<Object, Object> cache) {
        assert (cache != null);
        this.cache = cache;
    }

    public String getName() {
        return this.cache.getName();
    }

    public Object getNativeCache() {
        return this.cache;
    }

    public Cache.ValueWrapper get(Object key) {
        Object val = this.cache.get(key);
        return val != null ? new SimpleValueWrapper(val) : null;
    }

    public <T> T get(Object key, Class<T> type) {
        Object val = this.cache.get(key);
        if (val != null && type != null && !type.isInstance(val)) {
            throw new IllegalStateException("Cached value is not of required type [cacheName=" + this.cache.getName() + ", key=" + key + ", val=" + val + ", requiredType=" + type + ']');
        }
        return (T)val;
    }

    public void put(Object key, Object val) {
        this.cache.put(key, val);
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object val) {
        Boolean old = this.cache.putIfAbsent(key, val);
        return old != null ? new SimpleValueWrapper((Object)old) : null;
    }

    public void evict(Object key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.removeAll();
    }
}

