/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.transactions.spring;

import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.transactions.proxy.TransactionProxy;
import org.apache.ignite.internal.transactions.proxy.TransactionProxyFactory;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.spring.IgniteTransactionHolder;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;

public abstract class AbstractSpringTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
ApplicationListener<ContextRefreshedEvent> {
    private TransactionProxyFactory txFactory;
    private IgniteLogger log;
    private TransactionConcurrency txConcurrency;
    private TransactionIsolation dfltTxIsolation;
    private long dfltTxTimeout;

    public TransactionConcurrency getTransactionConcurrency() {
        return this.txConcurrency;
    }

    public void setTransactionConcurrency(TransactionConcurrency txConcurrency) {
        this.txConcurrency = txConcurrency;
    }

    public void onApplicationEvent(ContextRefreshedEvent evt) {
        if (this.txConcurrency == null) {
            this.txConcurrency = this.defaultTransactionConcurrency();
        }
        this.dfltTxIsolation = this.defaultTransactionIsolation();
        this.dfltTxTimeout = this.defaultTransactionTimeout();
        this.log = this.log();
        this.txFactory = this.createTransactionFactory();
    }

    protected Object doGetTransaction() throws TransactionException {
        IgniteTransactionObject txObj = new IgniteTransactionObject();
        txObj.setTransactionHolder((IgniteTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.txFactory)), false);
        return txObj;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        if (definition.getIsolationLevel() == 1) {
            throw new InvalidIsolationLevelException("Ignite does not support READ_UNCOMMITTED isolation level.");
        }
        IgniteTransactionObject txObj = (IgniteTransactionObject)transaction;
        TransactionProxy tx = null;
        try {
            if (txObj.getTransactionHolder() == null || txObj.getTransactionHolder().isSynchronizedWithTransaction()) {
                long timeout = this.dfltTxTimeout;
                if (definition.getTimeout() > 0) {
                    timeout = TimeUnit.SECONDS.toMillis(definition.getTimeout());
                }
                TransactionProxy newTx = this.txFactory.txStart(this.txConcurrency, this.convertToIgniteIsolationLevel(definition.getIsolationLevel()), timeout);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Started Ignite transaction: " + newTx);
                }
                txObj.setTransactionHolder(new IgniteTransactionHolder(newTx), true);
            }
            txObj.getTransactionHolder().setSynchronizedWithTransaction(true);
            txObj.getTransactionHolder().setTransactionActive(true);
            tx = txObj.getTransactionHolder().getTransaction();
            if (txObj.isNewTransactionHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.txFactory, (Object)((Object)txObj.getTransactionHolder()));
            }
        }
        catch (Exception ex) {
            if (tx != null) {
                tx.close();
            }
            throw new CannotCreateTransactionException("Could not create Ignite transaction", (Throwable)ex);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        IgniteTransactionObject txObj = (IgniteTransactionObject)status.getTransaction();
        TransactionProxy tx = txObj.getTransactionHolder().getTransaction();
        if (status.isDebug() && this.log.isDebugEnabled()) {
            this.log.debug("Committing Ignite transaction: " + tx);
        }
        try {
            tx.commit();
        }
        catch (Exception e) {
            throw new TransactionSystemException("Could not commit Ignite transaction", (Throwable)e);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        IgniteTransactionObject txObj = (IgniteTransactionObject)status.getTransaction();
        TransactionProxy tx = txObj.getTransactionHolder().getTransaction();
        if (status.isDebug() && this.log.isDebugEnabled()) {
            this.log.debug("Rolling back Ignite transaction: " + tx);
        }
        try {
            tx.rollback();
        }
        catch (Exception e) {
            throw new TransactionSystemException("Could not rollback Ignite transaction", (Throwable)e);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        IgniteTransactionObject txObj = (IgniteTransactionObject)status.getTransaction();
        TransactionProxy tx = txObj.getTransactionHolder().getTransaction();
        assert (tx != null);
        if (status.isDebug() && this.log.isDebugEnabled()) {
            this.log.debug("Setting Ignite transaction rollback-only: " + tx);
        }
        tx.setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        IgniteTransactionObject txObj = (IgniteTransactionObject)transaction;
        if (txObj.isNewTransactionHolder()) {
            TransactionProxy tx = txObj.getTransactionHolder().getTransaction();
            TransactionSynchronizationManager.unbindResource((Object)this.txFactory);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Releasing Ignite transaction: " + tx);
            }
        }
        txObj.getTransactionHolder().clear();
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        IgniteTransactionObject txObj = (IgniteTransactionObject)transaction;
        return txObj.getTransactionHolder() != null && txObj.getTransactionHolder().isTransactionActive();
    }

    public Object getResourceFactory() {
        return this.txFactory;
    }

    private TransactionIsolation convertToIgniteIsolationLevel(int isolationLevel) {
        TransactionIsolation isolation = this.dfltTxIsolation;
        switch (isolationLevel) {
            case 2: {
                isolation = TransactionIsolation.READ_COMMITTED;
                break;
            }
            case 4: {
                isolation = TransactionIsolation.REPEATABLE_READ;
                break;
            }
            case 8: {
                isolation = TransactionIsolation.SERIALIZABLE;
            }
        }
        return isolation;
    }

    protected abstract TransactionIsolation defaultTransactionIsolation();

    protected abstract long defaultTransactionTimeout();

    protected abstract TransactionConcurrency defaultTransactionConcurrency();

    protected abstract TransactionProxyFactory createTransactionFactory();

    protected abstract IgniteLogger log();

    protected static class IgniteTransactionObject
    implements SmartTransactionObject {
        private IgniteTransactionHolder txHolder;
        private boolean newTxHolder;

        protected IgniteTransactionObject() {
        }

        private void setTransactionHolder(IgniteTransactionHolder txHolder, boolean newTxHolder) {
            this.txHolder = txHolder;
            this.newTxHolder = newTxHolder;
        }

        protected IgniteTransactionHolder getTransactionHolder() {
            return this.txHolder;
        }

        private boolean isNewTransactionHolder() {
            return this.newTxHolder;
        }

        public boolean isRollbackOnly() {
            return this.txHolder.isRollbackOnly();
        }

        public void flush() {
            TransactionSynchronizationUtils.triggerFlush();
        }
    }
}

