/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.transactions.spring;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSpring;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.TransactionConfiguration;
import org.apache.ignite.internal.transactions.proxy.IgniteTransactionProxyFactory;
import org.apache.ignite.internal.transactions.proxy.TransactionProxyFactory;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.spring.AbstractSpringTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.ContextRefreshedEvent;

public class SpringTransactionManager
extends AbstractSpringTransactionManager
implements ApplicationContextAware,
DisposableBean {
    private String cfgPath;
    private IgniteConfiguration cfg;
    private String igniteInstanceName;
    private Ignite ignite;
    private boolean externalIgniteInstance;
    private TransactionConfiguration txCfg;
    private ApplicationContext springCtx;

    public String getConfigurationPath() {
        return this.cfgPath;
    }

    public void setConfigurationPath(String cfgPath) {
        this.cfgPath = cfgPath;
    }

    public IgniteConfiguration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(IgniteConfiguration cfg) {
        this.cfg = cfg;
    }

    @Deprecated
    public String getGridName() {
        return this.getIgniteInstanceName();
    }

    @Deprecated
    public void setGridName(String gridName) {
        this.setIgniteInstanceName(gridName);
    }

    public String getIgniteInstanceName() {
        return this.igniteInstanceName;
    }

    public void setIgniteInstanceName(String igniteInstanceName) {
        this.igniteInstanceName = igniteInstanceName;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent evt) {
        if (this.ignite == null) {
            if (this.cfgPath != null && this.cfg != null) {
                throw new IllegalArgumentException("Both 'configurationPath' and 'configuration' are provided. Set only one of these properties if you need to start a Ignite node inside of SpringTransactionManager. If you already have a node running, omit both of them and set'igniteInstanceName' property.");
            }
            try {
                if (this.cfgPath != null) {
                    this.ignite = IgniteSpring.start(this.cfgPath, this.springCtx);
                } else if (this.cfg != null) {
                    this.ignite = IgniteSpring.start(this.cfg, this.springCtx);
                } else {
                    this.ignite = Ignition.ignite((String)this.igniteInstanceName);
                    this.externalIgniteInstance = true;
                }
            }
            catch (IgniteCheckedException e) {
                throw U.convertException((IgniteCheckedException)e);
            }
            this.txCfg = this.ignite.configuration().getTransactionConfiguration();
        }
        super.onApplicationEvent(evt);
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.springCtx = ctx;
    }

    @Override
    protected TransactionIsolation defaultTransactionIsolation() {
        return this.txCfg.getDefaultTxIsolation();
    }

    @Override
    protected long defaultTransactionTimeout() {
        return this.txCfg.getDefaultTxTimeout();
    }

    @Override
    protected IgniteLogger log() {
        return this.ignite.log();
    }

    @Override
    protected TransactionConcurrency defaultTransactionConcurrency() {
        return this.txCfg.getDefaultTxConcurrency();
    }

    @Override
    protected TransactionProxyFactory createTransactionFactory() {
        return new IgniteTransactionProxyFactory(this.ignite.transactions());
    }

    public void destroy() {
        if (!this.externalIgniteInstance) {
            this.ignite.close();
        }
    }
}

