/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tools.ant.beautifier;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import jodd.jerry.Jerry;
import jodd.lagarto.dom.DOMBuilder;
import jodd.lagarto.dom.LagartoDOMBuilder;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class GridJavadocAntTask
extends MatchingTask {
    private File dir;
    private boolean verify = true;

    public void setDir(File dir) {
        assert (dir != null);
        this.dir = dir;
    }

    public void setVerify(Boolean verify) {
        assert (verify != null);
        this.verify = verify;
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.log("Failed closing [resource=" + closeable + ", message=" + e.getLocalizedMessage() + "]", 1);
            }
        }
    }

    public void execute() {
        if (this.dir == null) {
            throw new BuildException("'dir' attribute must be specified.");
        }
        this.log("dir=" + this.dir, 4);
        DirectoryScanner scanner = this.getDirectoryScanner(this.dir);
        boolean fail = false;
        ArrayList<String> errMsgs = new ArrayList<String>();
        for (String fileName : scanner.getIncludedFiles()) {
            String file = this.dir.getAbsolutePath() + "/" + fileName;
            try {
                this.processFile(file);
            }
            catch (IOException e) {
                throw new BuildException("IO error while processing: " + file, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                System.err.println("JavaDoc error: " + e.getMessage());
                errMsgs.add(e.getMessage());
                fail = true;
            }
        }
        if (fail) {
            throw new BuildException("Execution failed due to: " + this.prepareErrorSummary(errMsgs));
        }
    }

    private String prepareErrorSummary(ArrayList<String> errMsgs) {
        StringBuilder strBdr = new StringBuilder();
        for (String errMsg : errMsgs) {
            strBdr.append(errMsg).append(System.lineSeparator());
        }
        return strBdr.toString();
    }

    private void processFile(String fileName) throws IOException {
        assert (fileName != null);
        File file = new File(fileName);
        String fileContent = GridJavadocAntTask.readFileToString(file);
        if (this.verify) {
            Jerry descBlock;
            Jerry doc = Jerry.create((DOMBuilder)new LagartoDOMBuilder().enableHtmlMode().configure(cfg -> cfg.setErrorLogEnabled(false))).parse((CharSequence)fileContent);
            if (!"11".equals(System.getProperty("java.specification.version"))) {
                throw new IllegalArgumentException("GridJavadocAntTask isn't tested for java versions after 11. Please check html rendering of documentation package groups works correctly and remove this exception then.");
            }
            if ("index.html".equals(file.getName())) {
                Jerry otherPackages = doc.find("div.contentContainer table.overviewSummary caption span:contains('Other Packages')");
                if (otherPackages.size() > 0) {
                    System.err.println("[ERROR]: 'Other Packages' section should not be present, but found: " + doc.html());
                    throw new IllegalArgumentException("'Other Packages' section should not be present, all packages should have corresponding documentation groups: " + file + ";Please add packages description to parent/pom.xml into <plugin>(maven-javadoc-plugin) / <configuration> / <groups>");
                }
                int pkgGrps = doc.find("div.contentContainer table.overviewSummary caption span.tableTab").size();
                if (pkgGrps == 0) {
                    throw new IllegalArgumentException("Documentation package groups missed. Please add packages description to parent/pom.xml into <plugin>(maven-javadoc-plugin) / <configuration> / <groups>");
                }
                if (pkgGrps > 30) {
                    throw new IllegalArgumentException("Too many package groups: " + pkgGrps + ". The limit is 30 due to the javadoc limitations. Please reduce groups in parent/pom.xml inside <plugin>(maven-javadoc-plugin) / <configuration> / <groups>");
                }
            } else if (!this.isViewHtml(file) && (descBlock = doc.find("div.contentContainer .description")).size() == 0) {
                throw new IllegalArgumentException("Class doesn't have description in file: " + file);
            }
        }
        String s = fileContent.replaceFirst("</head>", "<link rel='shortcut icon' href='https://ignite.apache.org/favicon.ico'/>\n</head>\n");
        this.replaceFile(file, s);
    }

    private boolean isViewHtml(File file) {
        String baseName = file.getName();
        return "index.html".equals(baseName) || baseName.contains("-") || "allclasses.html".equals(baseName);
    }

    private void replaceFile(File file, String body) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            ((OutputStream)out).write(body.getBytes());
        }
    }

    public static String readFileToString(File file) throws IOException {
        int n;
        InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        StringWriter output = new StringWriter();
        char[] buf = new char[4096];
        while ((n = input.read(buf)) != -1) {
            output.write(buf, 0, n);
        }
        return output.toString();
    }
}

