/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.util.antgar;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.zip.ZipOutputStream;

public class IgniteDeploymentGarAntTask
extends Zip {
    public static final String DESC_NAME = "ignite.xml";
    private static final String DESC_PATH = "META-INF";
    private File descDir;
    private File descFile;
    private File baseDir;

    public IgniteDeploymentGarAntTask() {
        this.archiveType = "gar";
        this.emptyBehavior = "create";
    }

    public void setDescrdir(File descDir) {
        assert (descDir != null);
        this.descDir = descDir;
    }

    public void setBasedir(File baseDir) {
        super.setBasedir(baseDir);
        this.baseDir = baseDir;
    }

    public void execute() {
        this.setEncoding("UTF8");
        if (this.baseDir != null && this.baseDir.isDirectory()) {
            File[] files = this.baseDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().equals(IgniteDeploymentGarAntTask.DESC_PATH);
                }
            });
            if (files.length == 1) {
                files = files[0].listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return !pathname.isDirectory() && pathname.getName().equals(IgniteDeploymentGarAntTask.DESC_NAME);
                    }
                });
            }
            File desc = null;
            if (files.length == 1) {
                desc = files[0];
            }
            if (desc != null) {
                if (this.descDir != null) {
                    throw new BuildException("Ignite descriptor 'ignite.xml' is already defined in source folder.");
                }
            } else if (this.descDir != null) {
                if (!this.descDir.isDirectory()) {
                    throw new BuildException("'descrdir' attribute isn't folder [dir=" + this.descDir.getAbsolutePath() + "]");
                }
                this.descFile = new File(IgniteDeploymentGarAntTask.getFullPath(this.descDir.getAbsolutePath(), DESC_NAME));
                if (!this.descFile.exists()) {
                    throw new BuildException("Folder doesn't contain Ignite descriptor [path=" + this.descDir.getAbsolutePath() + "]");
                }
            }
        }
        super.execute();
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException {
        if (this.descFile != null) {
            this.zipFile(this.descFile, zOut, IgniteDeploymentGarAntTask.getFullPath(DESC_PATH, DESC_NAME), 33188);
        }
    }

    private static String getFullPath(String subPath1, String subPath2) {
        boolean b2;
        assert (subPath1 != null);
        assert (subPath2 != null);
        char c = subPath1.charAt(subPath1.length() - 1);
        boolean b1 = c == '/' || c == '\\';
        c = subPath2.charAt(0);
        boolean bl = b2 = c == '/' || c == '\\';
        return b1 != b2 ? subPath1 + subPath2 : (!b1 ? subPath1 + "/" + subPath2 : subPath1.substring(0, subPath1.length() - 1) + File.separatorChar + subPath2.substring(1));
    }
}

