/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.ShutdownPolicy;
import org.apache.ignite.SystemProperty;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CommunicationFailureContext;
import org.apache.ignite.configuration.CommunicationFailureResolver;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.NodeValidationFailedEvent;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpiInternalListener;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.SecurityUtils;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.io.GridByteArrayOutputStream;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerUtils;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoveryNotification;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.DiscoverySpiDataExchange;
import org.apache.ignite.spi.discovery.DiscoverySpiListener;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;
import org.apache.ignite.spi.discovery.zk.ZookeeperDiscoverySpi;
import org.apache.ignite.spi.discovery.zk.internal.ZkAbstractChildrenCallback;
import org.apache.ignite.spi.discovery.zk.internal.ZkAbstractWatcher;
import org.apache.ignite.spi.discovery.zk.internal.ZkAliveNodeData;
import org.apache.ignite.spi.discovery.zk.internal.ZkBulkJoinContext;
import org.apache.ignite.spi.discovery.zk.internal.ZkClusterNodes;
import org.apache.ignite.spi.discovery.zk.internal.ZkCommunicationErrorNodeState;
import org.apache.ignite.spi.discovery.zk.internal.ZkCommunicationErrorProcessFuture;
import org.apache.ignite.spi.discovery.zk.internal.ZkCommunicationErrorResolveFinishMessage;
import org.apache.ignite.spi.discovery.zk.internal.ZkCommunicationErrorResolveResult;
import org.apache.ignite.spi.discovery.zk.internal.ZkCommunicationErrorResolveStartMessage;
import org.apache.ignite.spi.discovery.zk.internal.ZkCommunicationFailureContext;
import org.apache.ignite.spi.discovery.zk.internal.ZkDiscoveryCustomEventData;
import org.apache.ignite.spi.discovery.zk.internal.ZkDiscoveryEventData;
import org.apache.ignite.spi.discovery.zk.internal.ZkDiscoveryEventsData;
import org.apache.ignite.spi.discovery.zk.internal.ZkDiscoveryNodeJoinEventData;
import org.apache.ignite.spi.discovery.zk.internal.ZkDiscoveryNodeLeaveEventData;
import org.apache.ignite.spi.discovery.zk.internal.ZkDistributedCollectDataFuture;
import org.apache.ignite.spi.discovery.zk.internal.ZkForceNodeFailMessage;
import org.apache.ignite.spi.discovery.zk.internal.ZkIgnitePaths;
import org.apache.ignite.spi.discovery.zk.internal.ZkInternalJoinErrorMessage;
import org.apache.ignite.spi.discovery.zk.internal.ZkInternalMessage;
import org.apache.ignite.spi.discovery.zk.internal.ZkJoinEventDataForJoined;
import org.apache.ignite.spi.discovery.zk.internal.ZkJoinedNodeEvtData;
import org.apache.ignite.spi.discovery.zk.internal.ZkJoiningNodeData;
import org.apache.ignite.spi.discovery.zk.internal.ZkNoServersMessage;
import org.apache.ignite.spi.discovery.zk.internal.ZkNodeValidateResult;
import org.apache.ignite.spi.discovery.zk.internal.ZkRunnable;
import org.apache.ignite.spi.discovery.zk.internal.ZkRuntimeState;
import org.apache.ignite.spi.discovery.zk.internal.ZkTimeoutObject;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClient;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClientFailedException;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoveryStatistics;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.jetbrains.annotations.Nullable;

public class ZookeeperDiscoveryImpl {
    public static final int DFLT_ZOOKEEPER_DISCOVERY_SPI_ACK_THRESHOLD = 5;
    public static final int DFLT_ZOOKEEPER_DISCOVERY_SPI_ACK_TIMEOUT = 60000;
    public static final int DFLT_ZOOKEEPER_DISCOVERY_SPI_MAX_EVTS = 100;
    public static final int DFLT_ZOOKEEPER_DISCOVERY_SPI_EVTS_THROTTLE = 0;
    @SystemProperty(value="Maximum count of unprocessed events", type=Long.class, defaults="5")
    public static final String IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_THRESHOLD = "IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_THRESHOLD";
    @SystemProperty(value="Timeout to update processed events", type=Long.class, defaults="60000")
    public static final String IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_TIMEOUT = "IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_TIMEOUT";
    @SystemProperty(value="Maximum count of unrpocessed events", type=Long.class, defaults="100")
    public static final String IGNITE_ZOOKEEPER_DISCOVERY_SPI_MAX_EVTS = "IGNITE_ZOOKEEPER_DISCOVERY_SPI_MAX_EVTS";
    @SystemProperty(value="Maximum count of events to delay alive nodes change process", type=Long.class, defaults="0")
    public static final String IGNITE_ZOOKEEPER_DISCOVERY_SPI_EVTS_THROTTLE = "IGNITE_ZOOKEEPER_DISCOVERY_SPI_EVTS_THROTTLE";
    final ZookeeperDiscoverySpi spi;
    private final String igniteInstanceName;
    private final String connectString;
    private final int sesTimeout;
    private final JdkMarshaller marsh = new JdkMarshaller();
    private final ZkIgnitePaths zkPaths;
    private final IgniteLogger log;
    final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final ZookeeperClusterNode locNode;
    private final DiscoverySpiListener lsnr;
    private final DiscoverySpiDataExchange exchange;
    private final boolean clientReconnectEnabled;
    private final GridFutureAdapter<Void> joinFut = new GridFutureAdapter();
    private final int evtsAckThreshold;
    private IgniteThreadPoolExecutor utilityPool;
    private volatile ZkRuntimeState rtState;
    private volatile ConnectionState connState = ConnectionState.STARTED;
    private final AtomicBoolean stop = new AtomicBoolean();
    private final Object stateMux = new Object();
    public volatile IgniteDiscoverySpiInternalListener internalLsnr;
    private final ConcurrentHashMap<Long, PingFuture> pingFuts = new ConcurrentHashMap();
    private final AtomicReference<ZkCommunicationErrorProcessFuture> commErrProcFut = new AtomicReference();
    private long prevSavedEvtsTopVer;
    private final ZookeeperDiscoveryStatistics stats;

    public ZookeeperDiscoveryImpl(ZookeeperDiscoverySpi spi, String igniteInstanceName, IgniteLogger log, String zkRootPath, ZookeeperClusterNode locNode, DiscoverySpiListener lsnr, DiscoverySpiDataExchange exchange, IgniteDiscoverySpiInternalListener internalLsnr, ZookeeperDiscoveryStatistics stats) {
        assert (locNode.id() != null && locNode.isLocal()) : locNode;
        MarshallerUtils.setNodeName((Marshaller)this.marsh, (String)igniteInstanceName);
        this.zkPaths = new ZkIgnitePaths(zkRootPath);
        this.spi = spi;
        this.igniteInstanceName = igniteInstanceName;
        this.connectString = spi.getZkConnectionString();
        this.sesTimeout = (int)spi.getSessionTimeout();
        this.log = log.getLogger(this.getClass());
        this.locNode = locNode;
        this.lsnr = lsnr;
        this.exchange = exchange;
        this.clientReconnectEnabled = locNode.isClient() && !spi.isClientReconnectDisabled();
        int evtsAckThreshold = IgniteSystemProperties.getInteger((String)IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_THRESHOLD, (int)5);
        if (evtsAckThreshold <= 0) {
            evtsAckThreshold = 1;
        }
        this.evtsAckThreshold = evtsAckThreshold;
        if (internalLsnr != null) {
            this.internalLsnr = internalLsnr;
        }
        this.stats = stats;
    }

    private static IgniteClientDisconnectedCheckedException disconnectError() {
        return new IgniteClientDisconnectedCheckedException(null, "Client node disconnected.");
    }

    IgniteLogger log() {
        return this.log;
    }

    public ClusterNode localNode() {
        return this.locNode;
    }

    @Nullable
    public ZookeeperClusterNode node(UUID nodeId) {
        assert (nodeId != null);
        ZkRuntimeState rtState0 = this.rtState;
        return rtState0 != null ? rtState0.top.nodesById.get(nodeId) : null;
    }

    @Nullable
    public ZookeeperClusterNode node(long nodeOrder) {
        assert (nodeOrder > 0L) : nodeOrder;
        ZkRuntimeState rtState0 = this.rtState;
        return rtState0 != null ? this.rtState.top.nodesByOrder.get(nodeOrder) : null;
    }

    void clearCommunicationErrorProcessFuture(ZkCommunicationErrorProcessFuture fut) {
        assert (fut.isDone()) : fut;
        this.commErrProcFut.compareAndSet(fut, null);
    }

    public void resolveCommunicationError(ClusterNode node0, Exception err) {
        IgniteInternalFuture<Boolean> nodeStatusFut;
        if (node0.isClient()) {
            return;
        }
        ZookeeperClusterNode node = this.node(node0.id());
        if (node == null) {
            throw new IgniteSpiException((Throwable)new ClusterTopologyCheckedException("Node failed: " + node0.id()));
        }
        while (true) {
            this.checkState();
            ZkCommunicationErrorProcessFuture fut = this.commErrProcFut.get();
            if (fut == null || fut.isDone()) {
                ZkCommunicationErrorProcessFuture newFut = ZkCommunicationErrorProcessFuture.createOnCommunicationError(this, node.sessionTimeout() + 1000L);
                this.stats.onCommunicationError();
                if (this.commErrProcFut.compareAndSet(fut, newFut)) {
                    fut = newFut;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Created new communication error process future [errNode=" + node0.id() + ", err=" + err + ']');
                    }
                    try {
                        this.checkState();
                    }
                    catch (Exception e) {
                        fut.onError(e);
                        throw e;
                    }
                    fut.scheduleCheckOnTimeout();
                } else {
                    fut = this.commErrProcFut.get();
                    if (fut == null) continue;
                }
            }
            if ((nodeStatusFut = fut.nodeStatusFuture((ClusterNode)node)) != null) break;
            try {
                fut.get();
            }
            catch (IgniteCheckedException e) {
                U.warn((IgniteLogger)this.log, (Object)("Previous communication error process future failed: " + (Object)((Object)e)));
            }
        }
        try {
            if (!((Boolean)nodeStatusFut.get()).booleanValue()) {
                throw new IgniteSpiException((Throwable)new ClusterTopologyCheckedException("Node failed: " + node0.id()));
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException((Throwable)e);
        }
    }

    public boolean pingNode(UUID nodeId) {
        this.checkState();
        ZkRuntimeState rtState = this.rtState;
        ZookeeperClusterNode node = rtState.top.nodesById.get(nodeId);
        if (node == null) {
            return false;
        }
        if (node.isLocal()) {
            return true;
        }
        PingFuture fut = this.pingFuts.get(node.order());
        if (fut == null) {
            fut = new PingFuture(rtState, node);
            PingFuture old = this.pingFuts.putIfAbsent(node.order(), fut);
            if (old == null) {
                if (fut.checkNodeAndState()) {
                    this.spi.getSpiContext().addTimeoutObject((IgniteSpiTimeoutObject)fut);
                } else assert (fut.isDone());
            } else {
                fut = old;
            }
        }
        try {
            return (Boolean)fut.get();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException((Throwable)e);
        }
    }

    public void failNode(UUID nodeId, @Nullable String warning) {
        ZookeeperClusterNode node = this.rtState.top.nodesById.get(nodeId);
        if (node == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignore forcible node fail request, node does not exist: " + nodeId);
            }
            return;
        }
        if (!node.isClient()) {
            U.warn((IgniteLogger)this.log, (Object)("Ignore forcible node fail request for non-client node: " + node));
            return;
        }
        this.sendCustomMessage(new ZkForceNodeFailMessage(node.internalId(), warning));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() {
        assert (this.clientReconnectEnabled);
        Object object = this.stateMux;
        synchronized (object) {
            if (this.connState != ConnectionState.STARTED) {
                return;
            }
            this.connState = ConnectionState.DISCONNECTED;
            this.rtState.onCloseStart((Exception)ZookeeperDiscoveryImpl.disconnectError());
        }
        this.busyLock.block();
        this.busyLock.unblock();
        this.rtState.zkClient.close();
        UUID newId = UUID.randomUUID();
        U.quietAndWarn((IgniteLogger)this.log, (Object)("Local node will try to reconnect to cluster with new id due to network problems [newId=" + newId + ", prevId=" + this.locNode.id() + ", locNode=" + this.locNode + ']'));
        this.runInWorkerThread(new ReconnectClosure(newId));
    }

    private void doReconnect(UUID newId) {
        if (this.rtState.joined) {
            assert (this.rtState.evtsData != null);
            this.lsnr.onDiscovery(new DiscoveryNotification(16, this.rtState.evtsData.topVer, (ClusterNode)this.locNode, this.rtState.top.topologySnapshot(), Collections.emptyMap(), null, null)).get();
        }
        try {
            this.locNode.onClientDisconnected(newId);
            this.joinTopology(this.rtState);
        }
        catch (Exception e) {
            if (this.stopping()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Reconnect failed, node is stopping [err=" + e + ']');
                }
                return;
            }
            U.error((IgniteLogger)this.log, (Object)("Failed to reconnect: " + e), (Throwable)e);
            this.onSegmented(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopping() {
        if (this.stop.get()) {
            return true;
        }
        Object object = this.stateMux;
        synchronized (object) {
            if (this.connState == ConnectionState.STOPPED) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSegmented(Exception e) {
        this.rtState.errForClose = e;
        if (this.rtState.joined || this.joinFut.isDone()) {
            Object object = this.stateMux;
            synchronized (object) {
                this.connState = ConnectionState.STOPPED;
            }
            this.notifySegmented();
        } else {
            this.joinFut.onDone((Throwable)e);
        }
    }

    private void notifySegmented() {
        List<Object> nodes = this.rtState.top.topologySnapshot();
        if (nodes.isEmpty()) {
            nodes = Collections.singletonList(this.locNode);
        }
        this.lsnr.onDiscovery(new DiscoveryNotification(14, this.rtState.evtsData != null ? this.rtState.evtsData.topVer : 1L, (ClusterNode)this.locNode, nodes, Collections.emptyMap(), null, null)).get();
    }

    public Collection<ClusterNode> remoteNodes() {
        this.checkState();
        return this.rtState.top.remoteNodes();
    }

    public boolean allNodesSupport(IgniteFeatures feature) {
        this.checkState();
        return this.rtState != null && this.rtState.top.isAllNodes((IgnitePredicate<ClusterNode>)(IgnitePredicate & Serializable)n -> IgniteFeatures.nodeSupports((ClusterNode)n, (IgniteFeatures)feature));
    }

    private void checkState() {
        switch (this.connState) {
            case STARTED: {
                break;
            }
            case STOPPED: {
                throw new IgniteSpiException("Node stopped.");
            }
            case DISCONNECTED: {
                throw new IgniteClientDisconnectedException(null, "Client is disconnected.");
            }
        }
    }

    public boolean knownNode(UUID nodeId) {
        while (!this.busyLock.enterBusy()) {
            this.checkState();
        }
        try {
            List<String> children = this.rtState.zkClient.getChildren(this.zkPaths.aliveNodesDir);
            for (int i = 0; i < children.size(); ++i) {
                UUID id = ZkIgnitePaths.aliveNodeId(children.get(i));
                if (!nodeId.equals(id)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (ZookeeperClientFailedException e) {
            if (this.clientReconnectEnabled) {
                throw new IgniteClientDisconnectedException(null, "Client is disconnected.");
            }
            throw new IgniteException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void sendCustomMessage(DiscoverySpiCustomMessage msg) {
        byte[] msgBytes;
        assert (msg != null);
        List<ClusterNode> nodes = this.rtState.top.topologySnapshot();
        boolean hasServerNode = false;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            ClusterNode node = nodes.get(i);
            if (node.isClient()) continue;
            hasServerNode = true;
        }
        if (!hasServerNode) {
            throw new IgniteException("Failed to send custom message: no server nodes in topology.");
        }
        try {
            msgBytes = this.marshalZip(msg);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal custom message: " + msg, (Throwable)e);
        }
        while (!this.busyLock.enterBusy()) {
            this.checkState();
        }
        try {
            ZookeeperClient zkClient = this.rtState.zkClient;
            this.saveCustomMessage(zkClient, msgBytes);
        }
        catch (ZookeeperClientFailedException e) {
            if (this.clientReconnectEnabled) {
                throw new IgniteClientDisconnectedException(null, "Client is disconnected.");
            }
            throw new IgniteException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException(e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void saveCustomMessage(ZookeeperClient zkClient, byte[] msgBytes) throws ZookeeperClientFailedException, InterruptedException {
        String prefix = UUID.randomUUID().toString();
        int partCnt = 1;
        int overhead = 10;
        UUID locId = this.locNode.id();
        String path = this.zkPaths.createCustomEventPath(prefix, locId, partCnt);
        if (zkClient.needSplitNodeData(path, msgBytes, overhead)) {
            List<byte[]> parts = zkClient.splitNodeData(path, msgBytes, overhead);
            String partsBasePath = this.zkPaths.customEventPartsBasePath(prefix, locId);
            this.saveMultipleParts(zkClient, partsBasePath, parts);
            msgBytes = null;
            partCnt = parts.size();
        }
        zkClient.createSequential(prefix, this.zkPaths.customEvtsDir, this.zkPaths.createCustomEventPath(prefix, locId, partCnt), msgBytes, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public long gridStartTime() {
        return this.rtState.gridStartTime;
    }

    public void startJoinAndWait() throws InterruptedException {
        this.joinTopology(null);
        while (true) {
            try {
                this.joinFut.get(10000L);
            }
            catch (IgniteFutureTimeoutCheckedException e) {
                U.warn((IgniteLogger)this.log, (Object)("Waiting for local join event [nodeId=" + this.locNode.id() + ", name=" + this.igniteInstanceName + ']'));
                continue;
            }
            catch (Exception e) {
                IgniteSpiException spiErr = (IgniteSpiException)X.cause((Throwable)e, IgniteSpiException.class);
                if (spiErr != null) {
                    throw spiErr;
                }
                throw new IgniteSpiException("Failed to join cluster", (Throwable)e);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinTopology(@Nullable ZkRuntimeState prevState) throws InterruptedException {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            byte[] joinDataBytes;
            boolean reconnect = this.locNode.isClient() && prevState != null && (prevState.joined || prevState.reconnect);
            IgniteDiscoverySpiInternalListener internalLsnr = this.internalLsnr;
            if (internalLsnr != null) {
                internalLsnr.beforeJoin((ClusterNode)this.locNode, this.log);
            }
            if (reconnect) {
                this.locNode.setAttributes(this.spi.getLocNodeAttrs());
            }
            this.marshalCredentialsOnJoin(this.locNode);
            Object object = this.stateMux;
            synchronized (object) {
                block15: {
                    if (this.connState != ConnectionState.STOPPED) break block15;
                    return;
                }
                this.connState = ConnectionState.STARTED;
            }
            ZkRuntimeState rtState = this.rtState = new ZkRuntimeState(reconnect);
            DiscoveryDataBag discoDataBag = new DiscoveryDataBag(this.locNode.id(), this.locNode.isClient());
            this.exchange.collect(discoDataBag);
            ZkJoiningNodeData joinData = new ZkJoiningNodeData(this.locNode, discoDataBag.joiningNodeData());
            try {
                joinDataBytes = this.marshalZip(joinData);
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to marshal joining node data", (Throwable)e);
            }
            try {
                rtState.zkClient = new ZookeeperClient(this.igniteInstanceName, this.log, this.connectString, this.sesTimeout, new ConnectionLossListener());
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to create Zookeeper client", (Throwable)e);
            }
            this.startJoin(rtState, prevState, joinDataBytes);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void initZkNodes() throws InterruptedException {
        try {
            ZookeeperClient client = this.rtState.zkClient;
            if (!client.exists(this.zkPaths.clusterDir)) {
                this.createRootPathParents(this.zkPaths.clusterDir, client);
                client.createIfNeeded(this.zkPaths.clusterDir, null, CreateMode.PERSISTENT);
            }
            List<String> createdDirs = client.getChildren(this.zkPaths.clusterDir);
            String[] requiredDirs = new String[]{this.zkPaths.evtsPath, this.zkPaths.joinDataDir, this.zkPaths.customEvtsDir, this.zkPaths.customEvtsPartsDir, this.zkPaths.customEvtsAcksDir, this.zkPaths.aliveNodesDir, this.zkPaths.stoppedNodesFlagsDir};
            ArrayList<String> dirs = new ArrayList<String>();
            for (String dir : requiredDirs) {
                String dir0 = dir.substring(this.zkPaths.clusterDir.length() + 1);
                if (createdDirs.contains(dir0)) continue;
                dirs.add(dir);
            }
            if (!dirs.isEmpty()) {
                client.createAll(dirs, CreateMode.PERSISTENT);
            }
        }
        catch (ZookeeperClientFailedException e) {
            throw new IgniteSpiException("Failed to initialize Zookeeper nodes", (Throwable)e);
        }
    }

    private void createRootPathParents(String rootDir, ZookeeperClient client) throws ZookeeperClientFailedException, InterruptedException {
        int separatorIdx;
        int startIdx = 0;
        while ((separatorIdx = rootDir.indexOf("/", startIdx)) != -1) {
            if (separatorIdx > 0) {
                String path = rootDir.substring(0, separatorIdx);
                client.createIfNeeded(path, null, CreateMode.PERSISTENT);
            }
            startIdx = separatorIdx + 1;
        }
    }

    private void deleteMultiplePartsAsync(ZookeeperClient zkClient, String basePath, int partCnt) {
        for (int i = 0; i < partCnt; ++i) {
            String path = ZookeeperDiscoveryImpl.multipartPathName(basePath, i);
            zkClient.deleteIfExistsAsync(path);
        }
    }

    private byte[] readMultipleParts(ZookeeperClient zkClient, String basePath, int partCnt) throws Exception {
        assert (partCnt >= 1);
        if (partCnt > 1) {
            ArrayList<byte[]> parts = new ArrayList<byte[]>(partCnt);
            int totSize = 0;
            for (int i = 0; i < partCnt; ++i) {
                byte[] part = zkClient.getData(ZookeeperDiscoveryImpl.multipartPathName(basePath, i));
                parts.add(part);
                totSize += part.length;
            }
            byte[] res = new byte[totSize];
            int pos = 0;
            for (int i = 0; i < partCnt; ++i) {
                byte[] part = (byte[])parts.get(i);
                System.arraycopy(part, 0, res, pos, part.length);
                pos += part.length;
            }
            return res;
        }
        return zkClient.getData(ZookeeperDiscoveryImpl.multipartPathName(basePath, 0));
    }

    private int saveMultipleParts(ZookeeperClient zkClient, String basePath, List<byte[]> parts) throws ZookeeperClientFailedException, InterruptedException {
        assert (parts.size() > 1);
        for (int i = 0; i < parts.size(); ++i) {
            byte[] part = parts.get(i);
            String path = ZookeeperDiscoveryImpl.multipartPathName(basePath, i);
            zkClient.createIfNeeded(path, part, CreateMode.PERSISTENT);
        }
        return parts.size();
    }

    private static String multipartPathName(String basePath, int part) {
        return basePath + String.format("%04d", part);
    }

    private void startJoin(ZkRuntimeState rtState, @Nullable ZkRuntimeState prevState, byte[] joinDataBytes) throws InterruptedException {
        try {
            long startTime = System.currentTimeMillis();
            this.initZkNodes();
            String prefix = UUID.randomUUID().toString();
            rtState.init(new ZkWatcher(rtState), new AliveNodeDataWatcher(rtState));
            ZookeeperClient zkClient = rtState.zkClient;
            int OVERHEAD = 5;
            String joinDataPath = ZkIgnitePaths.join(this.zkPaths.joinDataDir, prefix + ":" + this.locNode.id());
            if (zkClient.needSplitNodeData(joinDataPath, joinDataBytes, 5)) {
                List<byte[]> parts = zkClient.splitNodeData(joinDataPath, joinDataBytes, 5);
                rtState.joinDataPartCnt = parts.size();
                this.saveMultipleParts(zkClient, joinDataPath + ":", parts);
                joinDataPath = zkClient.createIfNeeded(joinDataPath, this.marshalZip(new ZkJoiningNodeData(parts.size())), CreateMode.PERSISTENT);
            } else {
                joinDataPath = zkClient.createIfNeeded(joinDataPath, joinDataBytes, CreateMode.PERSISTENT);
            }
            rtState.locNodeZkPath = zkClient.createSequential(prefix, this.zkPaths.aliveNodesDir, this.zkPaths.aliveNodePathForCreate(prefix, this.locNode), null, CreateMode.EPHEMERAL_SEQUENTIAL);
            rtState.internalOrder = ZkIgnitePaths.aliveInternalId(rtState.locNodeZkPath);
            if (this.log.isInfoEnabled()) {
                this.log.info("Node started join [nodeId=" + this.locNode.id() + ", instanceName=" + this.locNode.attribute("org.apache.ignite.ignite.name") + ", zkSessionId=0x" + Long.toHexString(rtState.zkClient.zk().getSessionId()) + ", joinDataSize=" + joinDataBytes.length + (rtState.joinDataPartCnt > 1 ? ", joinDataPartCnt=" + rtState.joinDataPartCnt : "") + ", consistentId=" + this.locNode.consistentId() + ", initTime=" + (System.currentTimeMillis() - startTime) + ", nodePath=" + rtState.locNodeZkPath + ']');
            }
            CheckJoinErrorWatcher joinErrorWatcher = new CheckJoinErrorWatcher(5000L, joinDataPath, rtState);
            rtState.joinErrTo = joinErrorWatcher.timeoutObj;
            if (this.locNode.isClient() && this.spi.getJoinTimeout() > 0L) {
                ZkTimeoutObject joinTimeoutObj;
                ZkTimeoutObject zkTimeoutObject = joinTimeoutObj = prevState != null ? prevState.joinTo : null;
                if (joinTimeoutObj == null) {
                    joinTimeoutObj = new JoinTimeoutObject(this.spi.getJoinTimeout());
                    this.spi.getSpiContext().addTimeoutObject((IgniteSpiTimeoutObject)joinTimeoutObj);
                }
                rtState.joinTo = joinTimeoutObj;
            }
            if (!this.locNode.isClient()) {
                zkClient.getChildrenAsync(this.zkPaths.aliveNodesDir, null, new CheckCoordinatorCallback(rtState));
            }
            zkClient.getDataAsync(this.zkPaths.evtsPath, rtState.watcher, rtState.watcher);
            this.spi.getSpiContext().addTimeoutObject((IgniteSpiTimeoutObject)rtState.joinErrTo);
        }
        catch (IgniteCheckedException | ZookeeperClientFailedException e) {
            throw new IgniteSpiException("Failed to initialize Zookeeper nodes", e);
        }
    }

    private void localAuthentication(DiscoverySpiNodeAuthenticator nodeAuth, SecurityCredentials locCred) {
        try {
            this.locNode.setAttributes(SecurityUtils.withSecurityContext((SecurityContext)SecurityUtils.authenticateLocalNode((ClusterNode)this.locNode, (SecurityCredentials)locCred, (DiscoverySpiNodeAuthenticator)nodeAuth), this.locNode.attributes(), (Marshaller)this.marsh));
        }
        catch (Exception e) {
            throw new IgniteSpiException("Failed to authenticate local node (will shutdown local node).", (Throwable)e);
        }
    }

    private void setNodeSecuritySubject(ZookeeperClusterNode node, byte[] zipBytes) throws Exception {
        assert (zipBytes != null);
        HashMap<String, Object> attrs = new HashMap<String, Object>(node.getAttributes());
        attrs.put("org.apache.ignite.security.subject.v2", ZookeeperDiscoveryImpl.unzip(zipBytes));
        node.setAttributes(attrs);
    }

    private SecurityCredentials unmarshalCredentials(ZookeeperClusterNode node) throws Exception {
        byte[] credBytes = (byte[])node.getAttributes().get("org.apache.ignite.security.cred");
        if (credBytes == null) {
            return null;
        }
        return (SecurityCredentials)this.unmarshalZip(credBytes);
    }

    private void marshalCredentialsOnJoin(ZookeeperClusterNode node) throws IgniteSpiException {
        try {
            Map<String, Object> attrs0 = node.getAttributes();
            Object creds = attrs0.get("org.apache.ignite.security.cred");
            if (creds != null) {
                HashMap<String, Object> attrs = new HashMap<String, Object>(attrs0);
                assert (!(creds instanceof byte[]));
                attrs.put("org.apache.ignite.security.cred", this.marshalZip(creds));
                node.setAttributes(attrs);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Failed to marshal node security credentials: " + node.id(), (Throwable)e);
        }
    }

    private void checkIsCoordinator(List<String> aliveNodes) throws Exception {
        assert (!this.locNode.isClient());
        TreeMap<Long, String> aliveSrvs = new TreeMap<Long, String>();
        long locInternalOrder = this.rtState.internalOrder;
        for (String aliveNodePath : aliveNodes) {
            if (ZkIgnitePaths.aliveNodeClientFlag(aliveNodePath)) continue;
            Long internalId = ZkIgnitePaths.aliveInternalId(aliveNodePath);
            aliveSrvs.put(internalId, aliveNodePath);
        }
        assert (!aliveSrvs.isEmpty());
        Map.Entry crdE = aliveSrvs.firstEntry();
        if (locInternalOrder == (Long)crdE.getKey()) {
            this.onBecomeCoordinator(aliveNodes);
        } else {
            assert (aliveSrvs.size() > 1) : aliveSrvs;
            Map.Entry prevE = aliveSrvs.floorEntry(locInternalOrder - 1L);
            assert (prevE != null);
            if (this.log.isInfoEnabled()) {
                this.log.info("Discovery coordinator already exists, watch for previous server node [locId=" + this.locNode.id() + ", watchPath=" + (String)prevE.getValue() + ']');
            }
            ServerPreviousNodeWatcher watcher = new ServerPreviousNodeWatcher(this.rtState);
            this.rtState.zkClient.existsAsync(ZkIgnitePaths.join(this.zkPaths.aliveNodesDir, (String)prevE.getValue()), watcher, watcher);
        }
    }

    private void checkClientsStatus(List<String> aliveNodes) throws Exception {
        boolean oldestClient;
        assert (this.locNode.isClient()) : this.locNode;
        assert (this.rtState.joined);
        assert (this.rtState.evtsData != null);
        TreeMap<Long, String> aliveClients = new TreeMap<Long, String>();
        String srvPath = null;
        Long srvInternalOrder = null;
        long locInternalOrder = this.rtState.internalOrder;
        for (String aliveNodePath : aliveNodes) {
            Long internalId = ZkIgnitePaths.aliveInternalId(aliveNodePath);
            if (ZkIgnitePaths.aliveNodeClientFlag(aliveNodePath)) {
                aliveClients.put(internalId, aliveNodePath);
                continue;
            }
            if (srvInternalOrder != null && internalId >= srvInternalOrder) continue;
            srvPath = aliveNodePath;
            srvInternalOrder = internalId;
        }
        if (!aliveClients.containsKey(locInternalOrder)) {
            return;
        }
        Map.Entry oldest = aliveClients.firstEntry();
        boolean bl = oldestClient = locInternalOrder == (Long)oldest.getKey();
        if (srvPath == null) {
            if (oldestClient) {
                Stat stat = new Stat();
                ZkDiscoveryEventsData prevEvts = this.rtState.evtsData;
                byte[] evtsBytes = this.rtState.zkClient.getData(this.zkPaths.evtsPath, stat);
                assert (evtsBytes.length > 0);
                ZkDiscoveryEventsData newEvts = (ZkDiscoveryEventsData)this.unmarshalZip(evtsBytes);
                if (prevEvts.clusterId.equals(newEvts.clusterId)) {
                    U.warn((IgniteLogger)this.log, (Object)("All server nodes failed, notify all clients [locId=" + this.locNode.id() + ']'));
                    try {
                        this.generateNoServersEvent(newEvts, stat);
                    }
                    catch (KeeperException.BadVersionException ignored) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to save no servers message. Path version changed.");
                        }
                        this.rtState.zkClient.getChildrenAsync(this.zkPaths.aliveNodesDir, null, new CheckClientsStatusCallback(this.rtState));
                    }
                } else {
                    U.warn((IgniteLogger)this.log, (Object)"All server nodes failed (received events from new cluster).");
                }
            }
        } else {
            String watchPath;
            if (oldestClient) {
                watchPath = srvPath;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Servers exists, watch for server node [locId=" + this.locNode.id() + ", watchPath=" + watchPath + ']');
                }
            } else {
                assert (aliveClients.size() > 1) : aliveClients;
                Map.Entry prevE = aliveClients.floorEntry(locInternalOrder - 1L);
                assert (prevE != null);
                watchPath = (String)prevE.getValue();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Servers exists, watch for previous node [locId=" + this.locNode.id() + ", watchPath=" + watchPath + ']');
                }
            }
            ClientPreviousNodeWatcher watcher = new ClientPreviousNodeWatcher(this.rtState);
            this.rtState.zkClient.existsAsync(ZkIgnitePaths.join(this.zkPaths.aliveNodesDir, watchPath), watcher, watcher);
        }
    }

    private void generateNoServersEvent(ZkDiscoveryEventsData evtsData, Stat evtsStat) throws Exception {
        ++evtsData.evtIdGen;
        ZkDiscoveryCustomEventData evtData = new ZkDiscoveryCustomEventData(evtsData.evtIdGen, 0L, evtsData.topVer, this.locNode.id(), new ZkNoServersMessage(), null);
        List<ZookeeperClusterNode> nodesToAck = Collections.emptyList();
        evtsData.addEvent(nodesToAck, evtData);
        byte[] newEvtsBytes = this.marshalZip(evtsData);
        this.rtState.zkClient.setData(this.zkPaths.evtsPath, newEvtsBytes, evtsStat.getVersion());
    }

    private void previousCoordinatorCleanup(ZkDiscoveryEventsData lastEvts) throws Exception {
        for (String stoppedFlagPath : this.rtState.zkClient.getChildren(this.zkPaths.stoppedNodesFlagsDir)) {
            long leftIntId = ZkIgnitePaths.stoppedFlagNodeInternalId(stoppedFlagPath);
            if (this.rtState.top.nodesByInternalId.containsKey(leftIntId)) continue;
            this.rtState.zkClient.deleteIfExistsAsync(ZkIgnitePaths.join(this.zkPaths.stoppedNodesFlagsDir, stoppedFlagPath));
        }
        for (ZkDiscoveryEventData evtData : lastEvts.evts.values()) {
            if (!(evtData instanceof ZkDiscoveryCustomEventData)) continue;
            ZkDiscoveryCustomEventData evtData0 = (ZkDiscoveryCustomEventData)evtData;
            if (evtData0.msg instanceof ZkCommunicationErrorResolveFinishMessage) {
                try {
                    ZkCommunicationErrorResolveFinishMessage msg = (ZkCommunicationErrorResolveFinishMessage)evtData0.msg;
                    ZkCommunicationErrorResolveResult res = (ZkCommunicationErrorResolveResult)this.unmarshalZip(ZkDistributedCollectDataFuture.readResult(this.rtState.zkClient, this.zkPaths, msg.futId));
                    this.deleteAliveNodes(res.killedNodes);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
                continue;
            }
            if (!(evtData0.resolvedMsg instanceof ZkForceNodeFailMessage)) continue;
            this.deleteAliveNode(((ZkForceNodeFailMessage)evtData0.resolvedMsg).nodeInternalId);
        }
    }

    private void onBecomeCoordinator(List<String> aliveNodes) throws Exception {
        ZkDiscoveryEventsData prevEvts = this.processNewEvents(this.rtState.zkClient.getData(this.zkPaths.evtsPath));
        this.rtState.crd = true;
        if (this.rtState.joined) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Node is new discovery coordinator [locId=" + this.locNode.id() + ']');
            }
            assert (this.locNode.order() > 0L) : this.locNode;
            assert (this.rtState.evtsData != null);
            this.previousCoordinatorCleanup(this.rtState.evtsData);
            UUID futId = this.rtState.evtsData.communicationErrorResolveFutureId();
            if (futId != null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("New discovery coordinator will handle already started cluster-wide communication error resolve [reqId=" + futId + ']');
                }
                ZkCommunicationErrorProcessFuture fut = this.commErrProcFut.get();
                ZkDistributedCollectDataFuture collectResFut = this.collectCommunicationStatusFuture(futId);
                if (fut != null) {
                    fut.nodeResultCollectFuture(collectResFut);
                }
            }
            for (ZkDiscoveryEventData evtData : this.rtState.evtsData.evts.values()) {
                evtData.initRemainingAcks(this.rtState.top.nodesByOrder.values());
            }
            this.handleProcessedEvents("crd");
        } else {
            String locAlivePath = this.rtState.locNodeZkPath.substring(this.rtState.locNodeZkPath.lastIndexOf(47) + 1);
            this.deleteJoiningNodeData(this.locNode.id(), ZkIgnitePaths.aliveNodePrefixId(locAlivePath), this.rtState.joinDataPartCnt);
            DiscoverySpiNodeAuthenticator nodeAuth = this.spi.getAuthenticator();
            if (nodeAuth != null) {
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Node is first server node in cluster, try authenticate local node [locId=" + this.locNode.id() + ']');
                    }
                    this.localAuthentication(nodeAuth, this.unmarshalCredentials(this.locNode));
                }
                catch (Exception e) {
                    U.warn((IgniteLogger)this.log, (Object)("Local node authentication failed: " + e), (Throwable)e);
                    this.onSegmented(e);
                    throw new ZookeeperClientFailedException("Local node authentication failed: " + e);
                }
            }
            this.newClusterStarted(prevEvts);
        }
        this.rtState.zkClient.getChildrenAsync(this.zkPaths.aliveNodesDir, this.rtState.watcher, this.rtState.watcher);
        this.rtState.zkClient.getChildrenAsync(this.zkPaths.customEvtsDir, this.rtState.watcher, this.rtState.watcher);
        for (String alivePath : aliveNodes) {
            this.watchAliveNodeData(alivePath);
        }
    }

    private void watchAliveNodeData(String alivePath) {
        assert (this.rtState.locNodeZkPath != null);
        String path = ZkIgnitePaths.join(this.zkPaths.aliveNodesDir, alivePath);
        if (!path.equals(this.rtState.locNodeZkPath)) {
            this.rtState.zkClient.getDataAsync(path, this.rtState.aliveNodeDataWatcher, this.rtState.aliveNodeDataWatcher);
        }
    }

    private void generateTopologyEvents(List<String> aliveNodes) throws Exception {
        assert (this.rtState.crd);
        if (this.log.isInfoEnabled()) {
            this.log.info("Process alive nodes change [alives=" + aliveNodes.size() + "]");
        }
        if (this.rtState.updateAlives) {
            aliveNodes = this.rtState.zkClient.getChildren(this.zkPaths.aliveNodesDir);
            this.rtState.updateAlives = false;
        }
        HashSet<Long> stoppedNodes = new HashSet<Long>();
        for (String string : this.rtState.zkClient.getChildren(this.zkPaths.stoppedNodesFlagsDir)) {
            stoppedNodes.add(ZkIgnitePaths.stoppedFlagNodeInternalId(string));
        }
        TreeMap<Long, String> alives = new TreeMap<Long, String>();
        for (String child : aliveNodes) {
            Long internalId = ZkIgnitePaths.aliveInternalId(child);
            String old = alives.put(internalId, child);
            assert (old == null);
        }
        TreeMap<Long, ZookeeperClusterNode> treeMap = new TreeMap<Long, ZookeeperClusterNode>((SortedMap<Long, ZookeeperClusterNode>)this.rtState.top.nodesByOrder);
        int newEvts = 0;
        int MAX_NEW_EVTS = IgniteSystemProperties.getInteger((String)IGNITE_ZOOKEEPER_DISCOVERY_SPI_MAX_EVTS, (int)100);
        ArrayList<ZookeeperClusterNode> failedNodes = null;
        for (Map.Entry<Long, ZookeeperClusterNode> e : this.rtState.top.nodesByInternalId.entrySet()) {
            if (alives.containsKey(e.getKey())) continue;
            ZookeeperClusterNode failedNode = e.getValue();
            if (failedNodes == null) {
                failedNodes = new ArrayList<ZookeeperClusterNode>();
            }
            failedNodes.add(failedNode);
            this.generateNodeLeave(treeMap, failedNode, !stoppedNodes.contains(failedNode.internalId()));
            if (++newEvts != MAX_NEW_EVTS) continue;
            this.saveAndProcessNewEvents();
            if (this.log.isInfoEnabled()) {
                this.log.info("Delay alive nodes change process, max event threshold reached [newEvts=" + newEvts + ", totalEvts=" + this.rtState.evtsData.evts.size() + ']');
            }
            this.handleProcessedEventsOnNodesFail(failedNodes);
            this.throttleNewEventsGeneration();
            this.rtState.zkClient.getChildrenAsync(this.zkPaths.aliveNodesDir, this.rtState.watcher, this.rtState.watcher);
            return;
        }
        if (newEvts > 0) {
            this.saveAndProcessNewEvents();
            this.handleProcessedEventsOnNodesFail(failedNodes);
            this.rtState.zkClient.getChildrenAsync(this.zkPaths.aliveNodesDir, this.rtState.watcher, this.rtState.watcher);
            return;
        }
        this.generateJoinEvents(treeMap, alives, MAX_NEW_EVTS);
        if (failedNodes != null) {
            this.handleProcessedEventsOnNodesFail(failedNodes);
        }
    }

    private void generateJoinEvents(TreeMap<Long, ZookeeperClusterNode> curTop, TreeMap<Long, String> alives, int MAX_NEW_EVTS) throws Exception {
        ZkBulkJoinContext joinCtx = new ZkBulkJoinContext();
        for (Map.Entry<Long, String> e : alives.entrySet()) {
            Long internalId = e.getKey();
            if (this.rtState.top.nodesByInternalId.containsKey(internalId)) continue;
            UUID rslvFutId = this.rtState.evtsData.communicationErrorResolveFutureId();
            if (rslvFutId != null) {
                if (!this.log.isInfoEnabled()) break;
                this.log.info("Delay alive nodes change process while communication error resolve is in progress [reqId=" + rslvFutId + ']');
                break;
            }
            this.processJoinOnCoordinator(joinCtx, curTop, internalId, e.getValue());
            if (joinCtx.nodes() != MAX_NEW_EVTS) continue;
            this.generateBulkJoinEvent(curTop, joinCtx);
            if (this.log.isInfoEnabled()) {
                this.log.info("Delay alive nodes change process, max event threshold reached [newEvts=" + joinCtx.nodes() + ", totalEvts=" + this.rtState.evtsData.evts.size() + ']');
            }
            this.throttleNewEventsGeneration();
            this.rtState.zkClient.getChildrenAsync(this.zkPaths.aliveNodesDir, this.rtState.watcher, this.rtState.watcher);
            return;
        }
        if (joinCtx.nodes() > 0) {
            this.generateBulkJoinEvent(curTop, joinCtx);
        }
    }

    private void generateBulkJoinEvent(TreeMap<Long, ZookeeperClusterNode> curTop, ZkBulkJoinContext joinCtx) throws Exception {
        ++this.rtState.evtsData.evtIdGen;
        long evtId = this.rtState.evtsData.evtIdGen;
        List<T2<ZkJoinedNodeEvtData, Map<Integer, Serializable>>> nodes = joinCtx.nodes;
        assert (nodes != null && !nodes.isEmpty());
        int nodeCnt = nodes.size();
        ArrayList<ZkJoinedNodeEvtData> joinedNodes = new ArrayList<ZkJoinedNodeEvtData>(nodeCnt);
        HashMap discoDataMap = U.newHashMap((int)nodeCnt);
        HashMap<Long, Long> dupDiscoData = null;
        for (int i = 0; i < nodeCnt; ++i) {
            T2<ZkJoinedNodeEvtData, Map<Integer, Serializable>> nodeEvtData = nodes.get(i);
            Map discoData = (Map)nodeEvtData.get2();
            byte[] discoDataBytes = U.marshal((Marshaller)this.marsh, (Object)discoData);
            Long dupDataNode = null;
            for (Map.Entry e : discoDataMap.entrySet()) {
                if (!Arrays.equals(discoDataBytes, (byte[])e.getValue())) continue;
                dupDataNode = (Long)e.getKey();
                break;
            }
            long nodeTopVer = ((ZkJoinedNodeEvtData)nodeEvtData.get1()).topVer;
            if (dupDataNode != null) {
                if (dupDiscoData == null) {
                    dupDiscoData = new HashMap<Long, Long>();
                }
                Long old = dupDiscoData.put(nodeTopVer, dupDataNode);
                assert (old == null) : old;
            } else {
                discoDataMap.put(nodeTopVer, discoDataBytes);
            }
            joinedNodes.add((ZkJoinedNodeEvtData)nodeEvtData.get1());
        }
        int overhead = 5;
        ZkJoinEventDataForJoined dataForJoined = new ZkJoinEventDataForJoined(new ArrayList<ZookeeperClusterNode>(curTop.values()), discoDataMap, dupDiscoData);
        byte[] dataForJoinedBytes = this.marshalZip(dataForJoined);
        long addDataStart = System.currentTimeMillis();
        int dataForJoinedPartCnt = this.saveData(this.zkPaths.joinEventDataPathForJoined(evtId), dataForJoinedBytes, overhead);
        long addDataTime = System.currentTimeMillis() - addDataStart;
        ZkDiscoveryNodeJoinEventData evtData = new ZkDiscoveryNodeJoinEventData(evtId, this.rtState.evtsData.topVer, joinedNodes, dataForJoinedPartCnt);
        this.rtState.evtsData.addEvent(curTop.values(), evtData);
        if (this.log.isInfoEnabled()) {
            if (nodeCnt > 1) {
                this.log.info("Generated NODE_JOINED bulk event [nodeCnt=" + nodeCnt + ", dataForJoinedSize=" + dataForJoinedBytes.length + ", dataForJoinedPartCnt=" + dataForJoinedPartCnt + ", addDataTime=" + addDataTime + ", evt=" + evtData + ']');
            } else {
                this.log.info("Generated NODE_JOINED event [dataForJoinedSize=" + dataForJoinedBytes.length + ", dataForJoinedPartCnt=" + dataForJoinedPartCnt + ", addDataTime=" + addDataTime + ", evt=" + evtData + ']');
            }
        }
        this.saveAndProcessNewEvents();
    }

    private void throttleNewEventsGeneration() {
        long delay = IgniteSystemProperties.getLong((String)IGNITE_ZOOKEEPER_DISCOVERY_SPI_EVTS_THROTTLE, (long)0L);
        if (delay > 0L) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Sleep delay before generate new events [delay=" + delay + ']');
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private ZkJoiningNodeData unmarshalJoinData(UUID nodeId, UUID prefixId) throws Exception {
        String joinDataPath = this.zkPaths.joiningNodeDataPath(nodeId, prefixId);
        byte[] joinData = this.rtState.zkClient.getData(joinDataPath);
        Object dataObj = this.unmarshalZip(joinData);
        if (!(dataObj instanceof ZkJoiningNodeData)) {
            throw new Exception("Invalid joined node data: " + dataObj);
        }
        ZkJoiningNodeData joiningNodeData = (ZkJoiningNodeData)dataObj;
        if (joiningNodeData.partCount() > 1) {
            joinData = this.readMultipleParts(this.rtState.zkClient, joinDataPath + ":", joiningNodeData.partCount());
            joiningNodeData = (ZkJoiningNodeData)this.unmarshalZip(joinData);
        }
        return joiningNodeData;
    }

    private Object unmarshalJoinDataOnCoordinator(UUID nodeId, UUID prefixId, String aliveNodePath) throws Exception {
        Object dataObj;
        String joinDataPath = this.zkPaths.joiningNodeDataPath(nodeId, prefixId);
        byte[] joinData = this.rtState.zkClient.getData(joinDataPath);
        try {
            dataObj = this.unmarshalZip(joinData);
            if (dataObj instanceof ZkInternalJoinErrorMessage) {
                return dataObj;
            }
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to unmarshal joining node data [nodePath=" + aliveNodePath + "']"), (Throwable)e);
            return new ZkInternalJoinErrorMessage(ZkIgnitePaths.aliveInternalId(aliveNodePath), "Failed to unmarshal join data: " + e);
        }
        assert (dataObj instanceof ZkJoiningNodeData) : dataObj;
        ZkJoiningNodeData joiningNodeData = (ZkJoiningNodeData)dataObj;
        if (joiningNodeData.partCount() > 1) {
            joinData = this.readMultipleParts(this.rtState.zkClient, joinDataPath + ":", joiningNodeData.partCount());
            try {
                joiningNodeData = (ZkJoiningNodeData)this.unmarshalZip(joinData);
            }
            catch (Exception e) {
                U.error((IgniteLogger)this.log, (Object)("Failed to unmarshal joining node data [nodePath=" + aliveNodePath + "']"), (Throwable)e);
                return new ZkInternalJoinErrorMessage(ZkIgnitePaths.aliveInternalId(aliveNodePath), "Failed to unmarshal join data: " + e);
            }
        }
        assert (joiningNodeData.node() != null) : joiningNodeData;
        return joiningNodeData;
    }

    private void processJoinOnCoordinator(ZkBulkJoinContext joinCtx, TreeMap<Long, ZookeeperClusterNode> curTop, long internalId, String aliveNodePath) throws Exception {
        UUID prefixId;
        UUID nodeId = ZkIgnitePaths.aliveNodeId(aliveNodePath);
        Object data = this.unmarshalJoinDataOnCoordinator(nodeId, prefixId = ZkIgnitePaths.aliveNodePrefixId(aliveNodePath), aliveNodePath);
        if (data instanceof ZkJoiningNodeData) {
            ZkJoiningNodeData joiningNodeData = (ZkJoiningNodeData)data;
            ZkNodeValidateResult validateRes = this.validateJoiningNode(joiningNodeData);
            if (validateRes.err == null) {
                ZookeeperClusterNode joinedNode = joiningNodeData.node();
                assert (nodeId.equals(joinedNode.id())) : joiningNodeData.node();
                this.addJoinedNode(joinCtx, curTop, joiningNodeData, internalId, prefixId, validateRes.secSubjZipBytes);
                this.watchAliveNodeData(aliveNodePath);
            } else {
                ZkInternalJoinErrorMessage joinErr = new ZkInternalJoinErrorMessage(ZkIgnitePaths.aliveInternalId(aliveNodePath), validateRes.err);
                this.processJoinError(aliveNodePath, nodeId, prefixId, joinErr);
            }
        } else {
            assert (data instanceof ZkInternalJoinErrorMessage) : data;
            this.processJoinError(aliveNodePath, nodeId, prefixId, (ZkInternalJoinErrorMessage)data);
        }
    }

    private void processJoinError(String aliveNodePath, UUID nodeId, UUID prefixId, ZkInternalJoinErrorMessage joinErr) throws Exception {
        ZookeeperClient client = this.rtState.zkClient;
        if (joinErr.notifyNode) {
            String joinDataPath = this.zkPaths.joiningNodeDataPath(nodeId, prefixId);
            client.setData(joinDataPath, this.marshalZip(joinErr), -1);
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Ignore join data, node was failed by previous coordinator: " + aliveNodePath);
        }
        client.deleteIfExists(ZkIgnitePaths.join(this.zkPaths.aliveNodesDir, aliveNodePath), -1);
    }

    private ZkNodeValidateResult validateJoiningNode(ZkJoiningNodeData joiningNodeData) {
        ZookeeperClusterNode node = joiningNodeData.node();
        ZookeeperClusterNode node0 = this.rtState.top.nodesById.get(node.id());
        if (node0 != null) {
            U.error((IgniteLogger)this.log, (Object)("Failed to include node in cluster, node with the same ID already exists [joiningNode=" + node + ", existingNode=" + node0 + ']'));
            return new ZkNodeValidateResult("Node with the same ID already exists: " + node0);
        }
        ZkNodeValidateResult res = this.authenticateNode(node);
        if (res.err != null) {
            return res;
        }
        IgniteNodeValidationResult err = this.spi.getSpiContext().validateNode((ClusterNode)node);
        if (err == null) {
            DiscoveryDataBag joiningNodeBag = new DiscoveryDataBag(node.id(), joiningNodeData.node().isClient());
            joiningNodeBag.joiningNodeData(joiningNodeData.discoveryData());
            err = this.spi.getSpiContext().validateNode((ClusterNode)node, joiningNodeBag);
        }
        if (err != null) {
            this.spi.getSpiContext().recordEvent((Event)new NodeValidationFailedEvent((ClusterNode)this.locNode, (ClusterNode)node, err));
            LT.warn((IgniteLogger)this.log, (String)err.message());
            res.err = err.sendMessage();
        }
        return res;
    }

    private ZkNodeValidateResult authenticateNode(ZookeeperClusterNode node) {
        byte[] secSubjZipBytes;
        SecurityCredentials cred;
        DiscoverySpiNodeAuthenticator nodeAuth = this.spi.getAuthenticator();
        if (nodeAuth == null) {
            return new ZkNodeValidateResult((byte[])null);
        }
        try {
            cred = this.unmarshalCredentials(node);
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to unmarshal node credentials: " + e), (Throwable)e);
            return new ZkNodeValidateResult("Failed to unmarshal node credentials");
        }
        SecurityContext subj = nodeAuth.authenticateNode((ClusterNode)node, cred);
        if (subj == null) {
            U.warn((IgniteLogger)this.log, (Object)("Authentication failed [nodeId=" + node.id() + ", addrs=" + U.addressesAsString((ClusterNode)node) + ']'));
            return new ZkNodeValidateResult("Authentication failed");
        }
        if (!(subj instanceof Serializable)) {
            U.warn((IgniteLogger)this.log, (Object)("Authentication subject is not Serializable [nodeId=" + node.id() + ", addrs=" + U.addressesAsString((ClusterNode)node) + ']'));
            return new ZkNodeValidateResult("Authentication subject is not serializable");
        }
        try {
            secSubjZipBytes = this.marshalZip(subj);
            node.setAttributes(SecurityUtils.withSecurityContext((SecurityContext)subj, node.getAttributes(), (Marshaller)this.marsh));
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to marshal node security subject: " + e), (Throwable)e);
            return new ZkNodeValidateResult("Failed to marshal node security subject");
        }
        return new ZkNodeValidateResult(secSubjZipBytes);
    }

    private void saveAndProcessNewEvents() throws Exception {
        if (this.stopping()) {
            return;
        }
        long start = System.currentTimeMillis();
        byte[] evtsBytes = this.marshalZip(this.rtState.evtsData);
        this.rtState.zkClient.setData(this.zkPaths.evtsPath, evtsBytes, -1);
        long time = System.currentTimeMillis() - start;
        if (this.prevSavedEvtsTopVer != this.rtState.evtsData.topVer) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Discovery coordinator saved new topology events [topVer=" + this.rtState.evtsData.topVer + ", size=" + evtsBytes.length + ", evts=" + this.rtState.evtsData.evts.size() + ", lastEvt=" + this.rtState.evtsData.evtIdGen + ", saveTime=" + time + ']');
            }
            this.prevSavedEvtsTopVer = this.rtState.evtsData.topVer;
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Discovery coordinator saved new topology events [topVer=" + this.rtState.evtsData.topVer + ", size=" + evtsBytes.length + ", evts=" + this.rtState.evtsData.evts.size() + ", lastEvt=" + this.rtState.evtsData.evtIdGen + ", saveTime=" + time + ']');
        }
        this.processNewEvents(this.rtState.evtsData);
    }

    private void generateNodeLeave(TreeMap<Long, ZookeeperClusterNode> curTop, ZookeeperClusterNode leftNode, boolean failed) {
        ZookeeperClusterNode rmvd = curTop.remove(leftNode.order());
        assert (rmvd != null);
        ++this.rtState.evtsData.topVer;
        ++this.rtState.evtsData.evtIdGen;
        ZkDiscoveryNodeLeaveEventData evtData = new ZkDiscoveryNodeLeaveEventData(this.rtState.evtsData.evtIdGen, this.rtState.evtsData.topVer, leftNode.internalId(), failed);
        this.rtState.evtsData.addEvent(curTop.values(), evtData);
        if (this.log.isInfoEnabled()) {
            String evtName = failed ? "NODE_FAILED" : "NODE_LEFT";
            this.log.info("Generated " + evtName + " event [evt=" + evtData + ']');
        }
    }

    private void addJoinedNode(ZkBulkJoinContext joinCtx, TreeMap<Long, ZookeeperClusterNode> curTop, ZkJoiningNodeData joiningNodeData, long internalId, UUID prefixId, @Nullable byte[] secSubjZipBytes) throws Exception {
        ZookeeperClusterNode joinedNode = joiningNodeData.node();
        UUID nodeId = joinedNode.id();
        ++this.rtState.evtsData.topVer;
        joinedNode.order(this.rtState.evtsData.topVer);
        joinedNode.internalId(internalId);
        DiscoveryDataBag joiningNodeBag = new DiscoveryDataBag(nodeId, joiningNodeData.node().isClient());
        joiningNodeBag.joiningNodeData(joiningNodeData.discoveryData());
        this.exchange.onExchange(joiningNodeBag);
        DiscoveryDataBag collectBag = new DiscoveryDataBag(nodeId, new HashSet(), joiningNodeData.node().isClient());
        collectBag.joiningNodeData(joiningNodeBag.joiningNodeData());
        this.exchange.collect(collectBag);
        Map commonData = collectBag.commonData();
        ZookeeperClusterNode old = curTop.put(joinedNode.order(), joinedNode);
        assert (old == null);
        int overhead = 5;
        int secSubjPartCnt = 0;
        if (secSubjZipBytes != null) {
            secSubjPartCnt = this.saveData(this.zkPaths.joinEventSecuritySubjectPath(joinedNode.order()), secSubjZipBytes, overhead);
            assert (secSubjPartCnt > 0) : secSubjPartCnt;
            if (this.spi.getAuthenticator() == null) {
                this.setNodeSecuritySubject(joinedNode, secSubjZipBytes);
            }
        }
        ZkJoinedNodeEvtData nodeEvtData = new ZkJoinedNodeEvtData(this.rtState.evtsData.topVer, joinedNode.id(), joinedNode.internalId(), prefixId, joiningNodeData.partCount(), secSubjPartCnt);
        nodeEvtData.joiningNodeData = joiningNodeData;
        joinCtx.addJoinedNode(nodeEvtData, commonData);
        this.rtState.evtsData.onNodeJoin(joinedNode);
    }

    private int saveData(String path, byte[] bytes, int overhead) throws Exception {
        int dataForJoinedPartCnt = 1;
        if (this.rtState.zkClient.needSplitNodeData(path, bytes, overhead)) {
            dataForJoinedPartCnt = this.saveMultipleParts(this.rtState.zkClient, path, this.rtState.zkClient.splitNodeData(path, bytes, overhead));
        } else {
            this.rtState.zkClient.createIfNeeded(ZookeeperDiscoveryImpl.multipartPathName(path, 0), bytes, CreateMode.PERSISTENT);
        }
        return dataForJoinedPartCnt;
    }

    private void newClusterStarted(@Nullable ZkDiscoveryEventsData prevEvts) throws Exception {
        assert (!this.locNode.isClient()) : this.locNode;
        long locInternalId = this.rtState.internalOrder;
        assert (prevEvts == null || prevEvts.maxInternalOrder < locInternalId);
        this.spi.getSpiContext().removeTimeoutObject((IgniteSpiTimeoutObject)this.rtState.joinErrTo);
        this.cleanupPreviousClusterData(prevEvts != null ? prevEvts.maxInternalOrder + 1L : -1L);
        this.rtState.joined = true;
        this.rtState.gridStartTime = System.currentTimeMillis();
        this.rtState.evtsData = ZkDiscoveryEventsData.createForNewCluster(this.rtState.gridStartTime);
        if (this.log.isInfoEnabled()) {
            this.log.info("New cluster started [locId=" + this.locNode.id() + ", clusterId=" + this.rtState.evtsData.clusterId + ", startTime=" + this.rtState.evtsData.clusterStartTime + ']');
        }
        this.locNode.internalId(locInternalId);
        this.locNode.order(1L);
        this.rtState.evtsData.onNodeJoin(this.locNode);
        this.rtState.top.addNode(this.locNode);
        List<ZookeeperClusterNode> topSnapshot = Collections.singletonList(this.locNode);
        try {
            this.lsnr.onDiscovery(new DiscoveryNotification(10, 1L, (ClusterNode)this.locNode, topSnapshot, Collections.emptyMap(), null, null)).get();
        }
        catch (IgniteException e) {
            this.joinFut.onDone((Throwable)e);
            throw new IgniteException("Failed to wait for discovery listener notification on node join", (Throwable)e);
        }
        this.rtState.zkClient.setData(this.zkPaths.evtsPath, this.marshalZip(this.rtState.evtsData), -1);
        this.joinFut.onDone();
    }

    private void cleanupPreviousClusterData(long startInternalOrder) throws Exception {
        long time;
        long start = System.currentTimeMillis();
        ZookeeperClient client = this.rtState.zkClient;
        LinkedList<String> batch = new LinkedList<String>();
        List<String> evtChildren = client.getChildrenPaths(this.zkPaths.evtsPath);
        for (String evtPath : evtChildren) {
            batch.addAll(client.getChildrenPaths(evtPath));
        }
        batch.addAll(evtChildren);
        batch.addAll(client.getChildrenPaths(this.zkPaths.customEvtsDir));
        batch.addAll(client.getChildrenPaths(this.zkPaths.customEvtsPartsDir));
        batch.addAll(client.getChildrenPaths(this.zkPaths.customEvtsAcksDir));
        batch.addAll(client.getChildrenPaths(this.zkPaths.stoppedNodesFlagsDir));
        client.deleteAll(batch, -1);
        if (startInternalOrder > 0L) {
            for (String alive : client.getChildren(this.zkPaths.aliveNodesDir)) {
                if (ZkIgnitePaths.aliveInternalId(alive) >= startInternalOrder) continue;
                client.deleteIfExists(ZkIgnitePaths.join(this.zkPaths.aliveNodesDir, alive), -1);
            }
        }
        if ((time = System.currentTimeMillis() - start) > 0L && this.log.isInfoEnabled()) {
            this.log.info("Previous cluster data cleanup time: " + time);
        }
    }

    private byte[] readCustomEventData(ZookeeperClient zkClient, String evtPath, UUID sndNodeId) throws Exception {
        int partCnt = ZkIgnitePaths.customEventPartsCount(evtPath);
        if (partCnt > 1) {
            String partsBasePath = this.zkPaths.customEventPartsBasePath(ZkIgnitePaths.customEventPrefix(evtPath), sndNodeId);
            return this.readMultipleParts(zkClient, partsBasePath, partCnt);
        }
        return zkClient.getData(ZkIgnitePaths.join(this.zkPaths.customEvtsDir, evtPath));
    }

    private void generateCustomEvents(List<String> customEvtNodes) throws Exception {
        assert (this.rtState.crd);
        ZookeeperClient zkClient = this.rtState.zkClient;
        ZkDiscoveryEventsData evtsData = this.rtState.evtsData;
        TreeMap<Integer, String> unprocessedEvts = null;
        for (int i = 0; i < customEvtNodes.size(); ++i) {
            String evtPath = customEvtNodes.get(i);
            int evtSeq = ZkIgnitePaths.customEventSequence(evtPath);
            if ((long)evtSeq <= evtsData.procCustEvt) continue;
            if (unprocessedEvts == null) {
                unprocessedEvts = new TreeMap<Integer, String>();
            }
            unprocessedEvts.put(evtSeq, evtPath);
        }
        if (unprocessedEvts == null) {
            return;
        }
        for (Map.Entry evtE : unprocessedEvts.entrySet()) {
            evtsData.procCustEvt = ((Integer)evtE.getKey()).intValue();
            String evtPath = (String)evtE.getValue();
            UUID sndNodeId = ZkIgnitePaths.customEventSendNodeId(evtPath);
            ZookeeperClusterNode sndNode = this.rtState.top.nodesById.get(sndNodeId);
            if (sndNode != null) {
                DiscoverySpiCustomMessage msg;
                byte[] evtBytes = this.readCustomEventData(zkClient, evtPath, sndNodeId);
                try {
                    msg = (DiscoverySpiCustomMessage)this.unmarshalZip(evtBytes);
                }
                catch (Exception e) {
                    U.error((IgniteLogger)this.log, (Object)("Failed to unmarshal custom discovery message: " + e), (Throwable)e);
                    this.deleteCustomEventDataAsync(this.rtState.zkClient, evtPath);
                    continue;
                }
                this.generateAndProcessCustomEventOnCoordinator(evtPath, sndNode, msg);
                continue;
            }
            U.warn((IgniteLogger)this.log, (Object)("Ignore custom event from unknown node: " + sndNodeId));
            this.deleteCustomEventDataAsync(this.rtState.zkClient, evtPath);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void generateAndProcessCustomEventOnCoordinator(String evtPath, ZookeeperClusterNode sndNode, DiscoverySpiCustomMessage msg) throws Exception {
        void var7_13;
        ZookeeperClusterNode failedNode;
        ZkDiscoveryEventsData evtsData;
        ZookeeperClient zkClient;
        block19: {
            zkClient = this.rtState.zkClient;
            evtsData = this.rtState.evtsData;
            failedNode = null;
            if (msg instanceof ZkForceNodeFailMessage) {
                ZkForceNodeFailMessage zkForceNodeFailMessage = (ZkForceNodeFailMessage)msg;
                failedNode = this.rtState.top.nodesByInternalId.get(zkForceNodeFailMessage.nodeInternalId);
                if (failedNode != null) {
                    ++evtsData.topVer;
                    break block19;
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Ignore forcible node fail request for unknown node: " + zkForceNodeFailMessage.nodeInternalId);
                    }
                    this.deleteCustomEventDataAsync(zkClient, evtPath);
                    return;
                }
            }
            if (msg instanceof ZkCommunicationErrorResolveStartMessage) {
                ZkCommunicationErrorResolveStartMessage zkCommunicationErrorResolveStartMessage = (ZkCommunicationErrorResolveStartMessage)msg;
                if (evtsData.communicationErrorResolveFutureId() != null) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Ignore communication error resolve message, resolve process already started [sndNode=" + sndNode + ']');
                    }
                    this.deleteCustomEventDataAsync(zkClient, evtPath);
                    return;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info("Start cluster-wide communication error resolve [sndNode=" + sndNode + ", reqId=" + zkCommunicationErrorResolveStartMessage.id + ", topVer=" + evtsData.topVer + ']');
                }
                zkClient.createIfNeeded(this.zkPaths.distributedFutureBasePath(zkCommunicationErrorResolveStartMessage.id), null, CreateMode.PERSISTENT);
                evtsData.communicationErrorResolveFutureId(zkCommunicationErrorResolveStartMessage.id);
            }
        }
        ++evtsData.evtIdGen;
        ZkDiscoveryCustomEventData zkDiscoveryCustomEventData = new ZkDiscoveryCustomEventData(evtsData.evtIdGen, 0L, evtsData.topVer, sndNode.id(), null, evtPath);
        zkDiscoveryCustomEventData.resolvedMsg = msg;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Generated CUSTOM event [evt=" + zkDiscoveryCustomEventData + ", msg=" + msg + ']');
        }
        boolean fastStopProcess = false;
        if (msg instanceof ZkInternalMessage) {
            this.processInternalMessage(zkDiscoveryCustomEventData, (ZkInternalMessage)msg);
        } else {
            this.notifyCustomEvent(zkDiscoveryCustomEventData, msg);
            if (msg.stopProcess()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Fast stop process custom event [evt=" + zkDiscoveryCustomEventData + ", msg=" + msg + ']');
                }
                fastStopProcess = true;
                evtsData.evts.remove(zkDiscoveryCustomEventData.eventId());
                --evtsData.evtIdGen;
                DiscoverySpiCustomMessage ack = msg.ackMessage();
                if (ack != null) {
                    ZkDiscoveryCustomEventData zkDiscoveryCustomEventData2 = this.createAckEvent(ack, zkDiscoveryCustomEventData);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Generated CUSTOM event (ack for fast stop process) [evt=" + zkDiscoveryCustomEventData2 + ", msg=" + msg + ']');
                    }
                    this.notifyCustomEvent(zkDiscoveryCustomEventData2, ack);
                } else {
                    Object var7_12 = null;
                }
            }
        }
        if (var7_13 != null) {
            evtsData.addEvent(this.rtState.top.nodesByOrder.values(), (ZkDiscoveryEventData)var7_13);
            this.rtState.locNodeInfo.lastProcEvt = var7_13.eventId();
            this.saveAndProcessNewEvents();
            if (fastStopProcess) {
                this.deleteCustomEventDataAsync(zkClient, evtPath);
            }
            if (failedNode != null) {
                this.deleteAliveNode(failedNode.internalId());
                this.handleProcessedEventsOnNodesFail(Collections.singletonList(failedNode));
                this.rtState.updateAlives = true;
            }
        }
    }

    private void deleteAliveNode(long internalId) throws Exception {
        for (String child : this.rtState.zkClient.getChildren(this.zkPaths.aliveNodesDir)) {
            if (ZkIgnitePaths.aliveInternalId(child) != internalId) continue;
            this.rtState.zkClient.deleteIfExists(ZkIgnitePaths.join(this.zkPaths.aliveNodesDir, child), -1);
            return;
        }
    }

    private void deleteCustomEventDataAsync(ZookeeperClient zkClient, String evtPath) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delete custom event data: " + evtPath);
        }
        String prefix = ZkIgnitePaths.customEventPrefix(evtPath);
        UUID sndNodeId = ZkIgnitePaths.customEventSendNodeId(evtPath);
        int partCnt = ZkIgnitePaths.customEventPartsCount(evtPath);
        assert (partCnt >= 1) : partCnt;
        if (partCnt > 1) {
            for (int i = 0; i < partCnt; ++i) {
                String path0 = this.zkPaths.customEventPartPath(prefix, sndNodeId, i);
                zkClient.deleteIfExistsAsync(path0);
            }
        }
        zkClient.deleteIfExistsAsync(ZkIgnitePaths.join(this.zkPaths.customEvtsDir, evtPath));
    }

    @Nullable
    private ZkDiscoveryEventsData processNewEvents(byte[] data) throws Exception {
        ZkDiscoveryEventsData newEvts;
        ZkDiscoveryEventsData zkDiscoveryEventsData = newEvts = data.length > 0 ? (ZkDiscoveryEventsData)this.unmarshalZip(data) : null;
        if (this.rtState.joined && (newEvts == null || !this.rtState.evtsData.clusterId.equals(newEvts.clusterId))) {
            assert (this.locNode.isClient()) : this.locNode;
            throw this.localNodeFail("All server nodes failed, client node disconnected (received events from new custer) [locId=" + this.locNode.id() + ']', true);
        }
        if (newEvts == null) {
            return null;
        }
        assert (!this.rtState.crd);
        if (!this.locNode.isClient() && this.rtState.evtsData != null) {
            for (Map.Entry<Long, ZkDiscoveryEventData> e : this.rtState.evtsData.evts.entrySet()) {
                ZkDiscoveryCustomEventData evtData0;
                ZkDiscoveryEventData evtData = e.getValue();
                if (evtData.eventType() != 3 || (evtData0 = (ZkDiscoveryCustomEventData)newEvts.evts.get(evtData.eventId())) == null) continue;
                evtData0.resolvedMsg = ((ZkDiscoveryCustomEventData)evtData).resolvedMsg;
            }
        }
        this.processNewEvents(newEvts);
        return newEvts;
    }

    private void processNewEvents(ZkDiscoveryEventsData evtsData) throws Exception {
        TreeMap<Long, ZkDiscoveryEventData> evts = evtsData.evts;
        ZookeeperClient zkClient = this.rtState.zkClient;
        boolean evtProcessed = false;
        boolean updateNodeInfo = false;
        try {
            for (ZkDiscoveryEventData evtData : evts.tailMap(this.rtState.locNodeInfo.lastProcEvt, false).values()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("New discovery event data [evt=" + evtData + ", evtsHist=" + evts.size() + ']');
                }
                switch (evtData.eventType()) {
                    case 1: {
                        evtProcessed = this.processBulkJoin(evtsData, (ZkDiscoveryNodeJoinEventData)evtData);
                        break;
                    }
                    case 2: {
                        if (!this.rtState.joined) break;
                        evtProcessed = true;
                        this.notifyNodeLeave((ZkDiscoveryNodeLeaveEventData)evtData);
                        break;
                    }
                    case 3: {
                        DiscoverySpiCustomMessage msg;
                        if (!this.rtState.joined) break;
                        evtProcessed = true;
                        ZkDiscoveryCustomEventData evtData0 = (ZkDiscoveryCustomEventData)evtData;
                        if (evtData0.ackEvent() && evtData0.topologyVersion() < this.locNode.order()) break;
                        if (this.rtState.crd) {
                            assert (evtData0.resolvedMsg != null) : evtData0;
                            msg = evtData0.resolvedMsg;
                        } else {
                            if (evtData0.msg == null) {
                                if (evtData0.ackEvent()) {
                                    String path = this.zkPaths.ackEventDataPath(evtData0.origEvtId);
                                    msg = (DiscoverySpiCustomMessage)this.unmarshalZip(zkClient.getData(path));
                                } else {
                                    assert (evtData0.evtPath != null) : evtData0;
                                    byte[] msgBytes = this.readCustomEventData(zkClient, evtData0.evtPath, evtData0.sndNodeId);
                                    msg = (DiscoverySpiCustomMessage)this.unmarshalZip(msgBytes);
                                }
                            } else {
                                msg = evtData0.msg;
                            }
                            evtData0.resolvedMsg = msg;
                        }
                        if (msg instanceof ZkInternalMessage) {
                            this.processInternalMessage(evtData0, (ZkInternalMessage)msg);
                            break;
                        }
                        this.notifyCustomEvent(evtData0, msg);
                        if (evtData0.ackEvent()) break;
                        updateNodeInfo = true;
                        break;
                    }
                    default: {
                        assert (false) : "Invalid event: " + evtData;
                        break;
                    }
                }
                if (!this.rtState.joined) continue;
                this.rtState.locNodeInfo.lastProcEvt = evtData.eventId();
                ++this.rtState.procEvtCnt;
                if (this.rtState.procEvtCnt % this.evtsAckThreshold != 0) continue;
                updateNodeInfo = true;
            }
        }
        catch (KeeperException.NoNodeException e) {
            boolean exists;
            try {
                exists = this.rtState.zkClient.exists(this.rtState.locNodeZkPath);
            }
            catch (Exception e0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to check is local node is alive:" + e0);
                }
                exists = true;
            }
            if (!exists) {
                U.warn((IgniteLogger)this.log, (Object)"Failed to process discovery event, local node was forced to stop.", (Throwable)e);
                throw this.localNodeFail("Local node was forced to stop.", true);
            }
            throw e;
        }
        if (this.rtState.joined) {
            this.rtState.evtsData = evtsData;
            this.stats.onTopologyChanged(this.rtState.evtsData.topVer);
        }
        if (this.rtState.crd) {
            this.handleProcessedEvents("procEvt");
        } else {
            this.onEventProcessed(this.rtState, updateNodeInfo, evtProcessed);
        }
        ZkCommunicationErrorProcessFuture commErrFut = this.commErrProcFut.get();
        if (commErrFut != null) {
            commErrFut.onTopologyChange(this.rtState.top);
        }
    }

    private boolean processBulkJoin(ZkDiscoveryEventsData evtsData, ZkDiscoveryNodeJoinEventData evtData) throws Exception {
        boolean evtProcessed = false;
        for (int i = 0; i < evtData.joinedNodes.size(); ++i) {
            ZkJoiningNodeData joiningData;
            ZkJoinedNodeEvtData joinedEvtData = evtData.joinedNodes.get(i);
            if (!this.rtState.joined) {
                boolean locJoin;
                UUID joinedId = joinedEvtData.nodeId;
                boolean bl = locJoin = joinedEvtData.joinedInternalId == this.rtState.internalOrder;
                if (!locJoin) continue;
                assert (this.locNode.id().equals(joinedId));
                this.processLocalJoin(evtsData, joinedEvtData, evtData);
                evtProcessed = true;
                continue;
            }
            if (this.rtState.crd) {
                assert (joinedEvtData.joiningNodeData != null);
                joiningData = joinedEvtData.joiningNodeData;
            } else {
                joiningData = this.unmarshalJoinData(joinedEvtData.nodeId, joinedEvtData.joinDataPrefixId);
                DiscoveryDataBag dataBag = new DiscoveryDataBag(joinedEvtData.nodeId, joiningData.node().isClient());
                dataBag.joiningNodeData(joiningData.discoveryData());
                this.exchange.onExchange(dataBag);
            }
            if (joinedEvtData.secSubjPartCnt > 0 && joiningData.node().attribute("org.apache.ignite.security.subject.v2") == null) {
                this.readAndInitSecuritySubject(joiningData.node(), joinedEvtData);
            }
            this.notifyNodeJoin(joinedEvtData, joiningData);
        }
        return evtProcessed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEventProcessed(ZkRuntimeState rtState, boolean updateNodeInfo, boolean evtProcessed) throws Exception {
        Object object = this.stateMux;
        synchronized (object) {
            if (updateNodeInfo) {
                assert (rtState.locNodeZkPath != null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Update processed events: " + rtState.locNodeInfo.lastProcEvt);
                }
                this.updateProcessedEvents(rtState);
                if (rtState.procEvtsUpdateTo != null) {
                    this.spi.getSpiContext().removeTimeoutObject((IgniteSpiTimeoutObject)rtState.procEvtsUpdateTo);
                    rtState.procEvtsUpdateTo = null;
                }
            } else if (evtProcessed) {
                long updateTimeout;
                rtState.locNodeInfo.needUpdate = true;
                if (rtState.procEvtsUpdateTo == null && (updateTimeout = IgniteSystemProperties.getLong((String)IGNITE_ZOOKEEPER_DISCOVERY_SPI_ACK_TIMEOUT, (long)60000L)) > 0L) {
                    rtState.procEvtsUpdateTo = new UpdateProcessedEventsTimeoutObject(rtState, updateTimeout);
                    this.spi.getSpiContext().addTimeoutObject((IgniteSpiTimeoutObject)rtState.procEvtsUpdateTo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProcessedEventsOnTimeout(ZkRuntimeState rtState, ZkTimeoutObject procEvtsUpdateTo) throws Exception {
        Object object = this.stateMux;
        synchronized (object) {
            if (rtState.procEvtsUpdateTo == procEvtsUpdateTo && rtState.locNodeInfo.needUpdate) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Update processed events on timeout: " + rtState.locNodeInfo.lastProcEvt);
                }
                this.updateProcessedEvents(rtState);
            }
        }
    }

    private void updateProcessedEvents(ZkRuntimeState rtState) throws Exception {
        block2: {
            try {
                rtState.zkClient.setData(rtState.locNodeZkPath, this.marshalZip(rtState.locNodeInfo), -1);
                rtState.locNodeInfo.needUpdate = false;
            }
            catch (KeeperException.NoNodeException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("Failed to update processed events, no node: " + rtState.locNodeInfo.lastProcEvt);
            }
        }
    }

    private void readAndInitSecuritySubject(ZookeeperClusterNode node, ZkJoinedNodeEvtData joinedEvtData) throws Exception {
        if (joinedEvtData.secSubjPartCnt > 0) {
            byte[] zipBytes = this.readMultipleParts(this.rtState.zkClient, this.zkPaths.joinEventSecuritySubjectPath(joinedEvtData.topVer), joinedEvtData.secSubjPartCnt);
            this.setNodeSecuritySubject(node, zipBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalJoin(ZkDiscoveryEventsData evtsData, ZkJoinedNodeEvtData joinedEvtData, ZkDiscoveryNodeJoinEventData evtData) throws Exception {
        Object object = this.stateMux;
        synchronized (object) {
            ZookeeperClusterNode node;
            if (this.connState == ConnectionState.STOPPED) {
                return;
            }
            if (this.rtState.joinTo != null) {
                this.spi.getSpiContext().removeTimeoutObject((IgniteSpiTimeoutObject)this.rtState.joinTo);
                this.rtState.joinTo.cancelled = true;
                this.rtState.joinTo = null;
            }
            this.spi.getSpiContext().removeTimeoutObject((IgniteSpiTimeoutObject)this.rtState.joinErrTo);
            if (this.log.isInfoEnabled()) {
                this.log.info("Local join event data: " + joinedEvtData + ']');
            }
            String path = this.zkPaths.joinEventDataPathForJoined(evtData.eventId());
            byte[] dataForJoinedBytes = this.readMultipleParts(this.rtState.zkClient, path, evtData.dataForJoinedPartCnt);
            ZkJoinEventDataForJoined dataForJoined = (ZkJoinEventDataForJoined)this.unmarshalZip(dataForJoinedBytes);
            this.rtState.gridStartTime = evtsData.clusterStartTime;
            this.locNode.internalId(joinedEvtData.joinedInternalId);
            this.locNode.order(joinedEvtData.topVer);
            this.readAndInitSecuritySubject(this.locNode, joinedEvtData);
            byte[] discoDataBytes = dataForJoined.discoveryDataForNode(this.locNode.order());
            Map commonDiscoData = (Map)this.marsh.unmarshal(discoDataBytes, U.resolveClassLoader((IgniteConfiguration)this.spi.ignite().configuration()));
            DiscoveryDataBag dataBag = new DiscoveryDataBag(this.locNode.id(), this.locNode.isClient());
            dataBag.commonData(commonDiscoData);
            this.exchange.onExchange(dataBag);
            List<ZookeeperClusterNode> allNodes = dataForJoined.topology();
            for (int i = 0; i < allNodes.size() && (node = allNodes.get(i)).order() < this.locNode.order(); ++i) {
                this.rtState.top.addNode(node);
            }
            this.rtState.top.addNode(this.locNode);
            List<ClusterNode> topSnapshot = this.rtState.top.topologySnapshot();
            this.lsnr.onDiscovery(new DiscoveryNotification(10, joinedEvtData.topVer, (ClusterNode)this.locNode, topSnapshot, Collections.emptyMap(), null, null)).get();
            if (this.rtState.reconnect) {
                this.lsnr.onDiscovery(new DiscoveryNotification(17, joinedEvtData.topVer, (ClusterNode)this.locNode, topSnapshot, Collections.emptyMap(), null, null)).get();
                U.quietAndWarn((IgniteLogger)this.log, (Object)("Client node was reconnected after it was already considered failed [locId=" + this.locNode.id() + ']'));
            }
            this.rtState.joined = true;
        }
        this.joinFut.onDone();
        if (this.locNode.isClient()) {
            this.rtState.zkClient.getChildrenAsync(this.zkPaths.aliveNodesDir, null, new CheckClientsStatusCallback(this.rtState));
        }
    }

    private void processInternalMessage(ZkDiscoveryCustomEventData evtData, ZkInternalMessage msg) throws Exception {
        if (msg instanceof ZkForceNodeFailMessage) {
            this.processForceNodeFailMessage((ZkForceNodeFailMessage)msg, evtData);
        } else if (msg instanceof ZkCommunicationErrorResolveStartMessage) {
            this.processCommunicationErrorResolveStartMessage((ZkCommunicationErrorResolveStartMessage)msg, evtData);
        } else if (msg instanceof ZkCommunicationErrorResolveFinishMessage) {
            this.processCommunicationErrorResolveFinishMessage((ZkCommunicationErrorResolveFinishMessage)msg);
        } else if (msg instanceof ZkNoServersMessage) {
            this.processNoServersMessage((ZkNoServersMessage)msg);
        }
    }

    private void processNoServersMessage(ZkNoServersMessage msg) throws Exception {
        assert (this.locNode.isClient()) : this.locNode;
        throw this.localNodeFail("All server nodes failed, client node disconnected (received 'no-servers' message) [locId=" + this.locNode.id() + ']', true);
    }

    private void processForceNodeFailMessage(ZkForceNodeFailMessage msg, ZkDiscoveryCustomEventData evtData) throws Exception {
        ClusterNode creatorNode = (ClusterNode)this.rtState.top.nodesById.get(evtData.sndNodeId);
        ZookeeperClusterNode node = this.rtState.top.nodesByInternalId.get(msg.nodeInternalId);
        assert (node != null) : msg.nodeInternalId;
        if (msg.warning != null) {
            U.warn((IgniteLogger)this.log, (Object)("Received force EVT_NODE_FAILED event with warning [nodeId=" + node.id() + ", msg=" + msg.warning + ", nodeInitiatedEvt=" + (creatorNode != null ? creatorNode : evtData.sndNodeId) + ']'));
        } else {
            U.warn((IgniteLogger)this.log, (Object)("Received force EVT_NODE_FAILED event [nodeId=" + node.id() + ", nodeInitiatedEvt=" + (creatorNode != null ? creatorNode : evtData.sndNodeId) + ']'));
        }
        if (node.isLocal()) {
            throw this.localNodeFail("Received force EVT_NODE_FAILED event for local node.", true);
        }
        this.notifyNodeFail(node.internalId(), evtData.topologyVersion());
    }

    private void processCommunicationErrorResolveFinishMessage(ZkCommunicationErrorResolveFinishMessage msg) throws Exception {
        UUID futId = msg.futId;
        assert (futId != null);
        if (this.log.isInfoEnabled()) {
            this.log.info("Received communication error resolve finish message [reqId=" + futId + ']');
        }
        this.rtState.commErrProcNodes = null;
        ZkCommunicationErrorResolveResult res = msg.res;
        if (res == null) {
            res = (ZkCommunicationErrorResolveResult)this.unmarshalZip(ZkDistributedCollectDataFuture.readResult(this.rtState.zkClient, this.zkPaths, futId));
        }
        ZkCommunicationErrorProcessFuture fut = this.commErrProcFut.get();
        assert (fut != null);
        HashSet failedNodes = null;
        if (res.err != null) {
            U.error((IgniteLogger)this.log, (Object)("Communication error resolve failed: " + res.err), (Throwable)res.err);
        } else if (res.killedNodes != null) {
            failedNodes = U.newHashSet((int)res.killedNodes.size());
            for (int i = 0; i < res.killedNodes.size(); ++i) {
                long internalId = res.killedNodes.get(i);
                if (internalId == this.locNode.internalId()) {
                    fut.onError((Exception)((Object)new IgniteCheckedException("Local node is forced to stop by communication error resolver")));
                    if (this.rtState.crd) {
                        this.deleteAliveNodes(res.killedNodes);
                    }
                    throw this.localNodeFail("Local node is forced to stop by communication error resolver [nodeId=" + this.locNode.id() + ']', false);
                }
                ZookeeperClusterNode node = this.rtState.top.nodesByInternalId.get(internalId);
                assert (node != null) : internalId;
                failedNodes.add(node.order());
            }
            long topVer = msg.topVer;
            for (int i = 0; i < res.killedNodes.size(); ++i) {
                long nodeInternalId = res.killedNodes.get(i);
                ClusterNode node = (ClusterNode)this.rtState.top.nodesByInternalId.get(nodeInternalId);
                assert (node != null) : nodeInternalId;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Node stop is forced by communication error resolver [nodeId=" + node.id() + ']');
                }
                this.notifyNodeFail(nodeInternalId, ++topVer);
            }
        }
        fut.onFinishResolve(failedNodes);
        if (this.rtState.crd) {
            this.deleteAliveNodes(res.killedNodes);
        }
    }

    private void deleteAliveNodes(@Nullable GridLongList internalIds) throws Exception {
        if (internalIds == null) {
            return;
        }
        List<String> alives = this.rtState.zkClient.getChildren(this.zkPaths.aliveNodesDir);
        for (int i = 0; i < alives.size(); ++i) {
            String alive = alives.get(i);
            if (!internalIds.contains(ZkIgnitePaths.aliveInternalId(alive))) continue;
            this.rtState.zkClient.deleteIfExistsAsync(ZkIgnitePaths.join(this.zkPaths.aliveNodesDir, alive));
        }
    }

    private void processCommunicationErrorResolveStartMessage(ZkCommunicationErrorResolveStartMessage msg, ZkDiscoveryCustomEventData evtData) throws Exception {
        ZkCommunicationErrorProcessFuture fut;
        while (true) {
            if ((fut = this.commErrProcFut.get()) == null || fut.isDone()) {
                ZkCommunicationErrorProcessFuture newFut = ZkCommunicationErrorProcessFuture.createOnStartResolveRequest(this);
                fut = this.commErrProcFut.compareAndSet(fut, newFut) ? newFut : this.commErrProcFut.get();
            }
            if (fut.onStartResolveRequest(evtData.topologyVersion())) break;
            try {
                fut.get();
            }
            catch (Exception e) {
                U.warn((IgniteLogger)this.log, (Object)("Previous communication error process future failed: " + e));
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Received communication error resolve request [reqId=" + msg.id + ", topVer=" + this.rtState.top.topologySnapshot() + ']');
        }
        assert (!fut.isDone()) : fut;
        final String futPath = this.zkPaths.distributedFutureBasePath(msg.id);
        final ZkCommunicationErrorProcessFuture fut0 = fut;
        this.rtState.commErrProcNodes = this.rtState.top.topologySnapshot();
        if (this.rtState.crd) {
            ZkDistributedCollectDataFuture nodeResFut = this.collectCommunicationStatusFuture(msg.id);
            fut.nodeResultCollectFuture(nodeResFut);
        }
        this.runInWorkerThread(new ZkRunnable(this.rtState, this){

            @Override
            protected void run0() throws Exception {
                fut0.checkConnection(this.rtState, futPath, this.rtState.commErrProcNodes);
            }
        });
    }

    private ZkDistributedCollectDataFuture collectCommunicationStatusFuture(UUID futId) throws Exception {
        return new ZkDistributedCollectDataFuture(this, this.rtState, this.zkPaths.distributedFutureBasePath(futId), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ZookeeperDiscoveryImpl.this.onCommunicationErrorResolveStatusReceived(ZookeeperDiscoveryImpl.this.rtState);
                return null;
            }
        });
    }

    private void onCommunicationErrorResolveStatusReceived(ZkRuntimeState rtState) throws Exception {
        ZkDiscoveryEventsData evtsData = rtState.evtsData;
        UUID futId = evtsData.communicationErrorResolveFutureId();
        if (this.log.isInfoEnabled()) {
            this.log.info("Received communication status from all nodes [reqId=" + futId + ']');
        }
        assert (futId != null);
        String futPath = this.zkPaths.distributedFutureBasePath(futId);
        List<ClusterNode> initialNodes = rtState.commErrProcNodes;
        assert (initialNodes != null);
        rtState.commErrProcNodes = null;
        List<ClusterNode> topSnapshot = rtState.top.topologySnapshot();
        HashMap nodesRes = U.newHashMap((int)topSnapshot.size());
        Throwable err = null;
        for (ClusterNode node : topSnapshot) {
            byte[] stateBytes = ZkDistributedCollectDataFuture.readNodeResult(futPath, rtState.zkClient, node.order());
            ZkCommunicationErrorNodeState nodeState = (ZkCommunicationErrorNodeState)this.unmarshalZip(stateBytes);
            if (nodeState.err != null) {
                if (err == null) {
                    err = new Exception("Failed to resolve communication error.");
                }
                err.addSuppressed(nodeState.err);
                continue;
            }
            assert (nodeState.commState != null);
            nodesRes.put(node.id(), nodeState.commState);
        }
        long topVer = evtsData.topVer;
        GridLongList killedNodesList = null;
        if (err == null) {
            boolean fullyConnected = true;
            for (Map.Entry e : nodesRes.entrySet()) {
                if (this.checkFullyConnected((BitSet)e.getValue(), initialNodes, rtState.top)) continue;
                fullyConnected = false;
                break;
            }
            if (fullyConnected) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Finish communication error resolve process automatically, there are no communication errors [reqId=" + futId + ']');
                }
            } else {
                CommunicationFailureResolver rslvr = this.spi.ignite().configuration().getCommunicationFailureResolver();
                if (rslvr != null) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Call communication error resolver [reqId=" + futId + ", rslvr=" + rslvr.getClass().getSimpleName() + ']');
                    }
                    ZkCommunicationFailureContext ctx = new ZkCommunicationFailureContext(((IgniteKernal)this.spi.ignite()).context().cache().context(), topSnapshot, initialNodes, nodesRes);
                    try {
                        rslvr.resolve((CommunicationFailureContext)ctx);
                        Set<ClusterNode> killedNodes = ctx.killedNodes();
                        if (killedNodes != null) {
                            if (this.log.isInfoEnabled()) {
                                this.log.info("Communication error resolver forced nodes stop [reqId=" + futId + ", killNodeCnt=" + killedNodes.size() + ", nodeIds=" + U.nodeIds(killedNodes) + ']');
                            }
                            killedNodesList = new GridLongList(killedNodes.size());
                            for (ClusterNode killedNode : killedNodes) {
                                killedNodesList.add(((ZookeeperClusterNode)killedNode).internalId());
                                ++evtsData.topVer;
                            }
                        }
                    }
                    catch (Exception e) {
                        err = e;
                        U.error((IgniteLogger)this.log, (Object)("Failed to resolve communication error with configured resolver [reqId=" + futId + ']'), (Throwable)e);
                    }
                }
            }
        }
        evtsData.communicationErrorResolveFutureId(null);
        ZkCommunicationErrorResolveResult res = new ZkCommunicationErrorResolveResult(killedNodesList, (Exception)err);
        ZkCommunicationErrorResolveFinishMessage msg = new ZkCommunicationErrorResolveFinishMessage(futId, topVer);
        msg.res = res;
        ZkDistributedCollectDataFuture.saveResult(this.zkPaths.distributedFutureResultPath(futId), rtState.zkClient, this.marshalZip(res));
        ++evtsData.evtIdGen;
        ZkDiscoveryCustomEventData evtData = new ZkDiscoveryCustomEventData(evtsData.evtIdGen, 0L, topVer, this.locNode.id(), msg, null);
        evtData.resolvedMsg = msg;
        evtsData.addEvent(rtState.top.nodesByOrder.values(), evtData);
        this.saveAndProcessNewEvents();
        rtState.zkClient.getChildrenAsync(this.zkPaths.aliveNodesDir, rtState.watcher, rtState.watcher);
    }

    private boolean checkFullyConnected(BitSet commState, List<ClusterNode> initialNodes, ZkClusterNodes top) {
        int startIdx = 0;
        int idx;
        while ((idx = commState.nextClearBit(startIdx)) < initialNodes.size()) {
            ClusterNode node = initialNodes.get(idx);
            if (top.nodesById.containsKey(node.id())) {
                return false;
            }
            startIdx = idx + 1;
        }
        return true;
    }

    public void simulateNodeFailure() {
        ZkRuntimeState rtState = this.rtState;
        ZookeeperClient client = rtState.zkClient;
        client.deleteIfExistsAsync(this.zkPaths.aliveNodesDir);
        rtState.onCloseStart((Exception)((Object)new IgniteCheckedException("Simulate node failure error.")));
        rtState.zkClient.close();
    }

    private void notifyCustomEvent(ZkDiscoveryCustomEventData evtData, DiscoverySpiCustomMessage msg) {
        assert (!(msg instanceof ZkInternalMessage)) : msg;
        if (this.log.isDebugEnabled()) {
            this.log.debug(" [topVer=" + evtData.topologyVersion() + ", msg=" + msg + ']');
        }
        ZookeeperClusterNode sndNode = this.rtState.top.nodesById.get(evtData.sndNodeId);
        assert (sndNode != null) : evtData;
        List<ClusterNode> topSnapshot = this.rtState.top.topologySnapshot();
        IgniteFuture fut = this.lsnr.onDiscovery(new DiscoveryNotification(18, evtData.topologyVersion(), (ClusterNode)sndNode, topSnapshot, Collections.emptyMap(), msg, null));
        if (msg != null && msg.isMutable()) {
            fut.get();
        }
    }

    private void notifyNodeJoin(ZkJoinedNodeEvtData joinedEvtData, ZkJoiningNodeData joiningData) {
        ZookeeperClusterNode joinedNode = joiningData.node();
        joinedNode.order(joinedEvtData.topVer);
        joinedNode.internalId(joinedEvtData.joinedInternalId);
        this.rtState.top.addNode(joinedNode);
        List<ClusterNode> topSnapshot = this.rtState.top.topologySnapshot();
        this.lsnr.onDiscovery(new DiscoveryNotification(10, joinedEvtData.topVer, (ClusterNode)joinedNode, topSnapshot, Collections.emptyMap(), null, null)).get();
        this.stats.onNodeJoined();
    }

    private void notifyNodeLeave(ZkDiscoveryNodeLeaveEventData evtData) {
        this.notifyNodeLeave(evtData.leftNodeInternalId(), evtData.topologyVersion(), evtData.failed());
    }

    private void notifyNodeFail(long nodeInternalOrder, long topVer) {
        this.notifyNodeLeave(nodeInternalOrder, topVer, true);
    }

    private void notifyNodeLeave(long nodeInternalOrder, long topVer, boolean failed) {
        PingFuture pingFut;
        ZookeeperClusterNode leftNode = this.rtState.top.removeNode(nodeInternalOrder);
        assert (leftNode != null && !leftNode.isLocal()) : leftNode;
        if (!failed && this.rtState.crd) {
            this.rtState.zkClient.deleteIfExistsAsync(this.zkPaths.nodeStoppedFlag(leftNode));
        }
        if ((pingFut = this.pingFuts.get(leftNode.order())) != null) {
            pingFut.onDone(false);
        }
        List<ClusterNode> topSnapshot = this.rtState.top.topologySnapshot();
        this.lsnr.onDiscovery(new DiscoveryNotification(failed ? 12 : 11, topVer, (ClusterNode)leftNode, topSnapshot, Collections.emptyMap(), null, null)).get();
        if (failed) {
            this.stats.onNodeFailed();
        } else {
            this.stats.onNodeLeft();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZookeeperClientFailedException localNodeFail(String msg, boolean clientReconnect) {
        U.warn((IgniteLogger)this.log, (Object)msg);
        if (this.rtState.zkClient.connected()) {
            this.rtState.zkClient.close();
        }
        if (clientReconnect && this.clientReconnectEnabled) {
            assert (this.locNode.isClient()) : this.locNode;
            boolean reconnect = false;
            Object object = this.stateMux;
            synchronized (object) {
                if (this.connState == ConnectionState.STARTED) {
                    reconnect = true;
                    this.connState = ConnectionState.DISCONNECTED;
                    this.rtState.onCloseStart((Exception)ZookeeperDiscoveryImpl.disconnectError());
                }
            }
            if (reconnect) {
                UUID newId = UUID.randomUUID();
                U.quietAndWarn((IgniteLogger)this.log, (Object)("Client node will try to reconnect with new id [newId=" + newId + ", prevId=" + this.locNode.id() + ", locNode=" + this.locNode + ']'));
                this.runInWorkerThread(new ReconnectClosure(newId));
            }
        } else {
            this.rtState.errForClose = new IgniteCheckedException(msg);
            this.notifySegmented();
        }
        return new ZookeeperClientFailedException(msg);
    }

    private void handleProcessedEvents(String ctx) throws Exception {
        Iterator<ZkDiscoveryEventData> it = this.rtState.evtsData.evts.values().iterator();
        ArrayList<ZkDiscoveryCustomEventData> newEvts = null;
        ZkDiscoveryEventData prevEvtData = null;
        while (it.hasNext()) {
            ZkDiscoveryEventData evtData = it.next();
            if (evtData.allAcksReceived()) {
                if (prevEvtData != null && this.log.isInfoEnabled()) {
                    this.log.info("Previous event is not acked [evtId=" + evtData.eventId() + ", prevEvtData=" + prevEvtData + ", remaining=" + prevEvtData.remainingAcks() + ']');
                }
                prevEvtData = null;
                switch (evtData.eventType()) {
                    case 1: {
                        this.handleProcessedJoinEventAsync((ZkDiscoveryNodeJoinEventData)evtData);
                        break;
                    }
                    case 3: {
                        DiscoverySpiCustomMessage ack = this.handleProcessedCustomEvent(ctx, (ZkDiscoveryCustomEventData)evtData);
                        if (ack == null) break;
                        ZkDiscoveryCustomEventData ackEvtData = this.createAckEvent(ack, (ZkDiscoveryCustomEventData)evtData);
                        if (newEvts == null) {
                            newEvts = new ArrayList<ZkDiscoveryCustomEventData>();
                        }
                        newEvts.add(ackEvtData);
                        break;
                    }
                    case 2: {
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug("All nodes processed node left [evtData=" + evtData + ']');
                    }
                }
                it.remove();
                continue;
            }
            prevEvtData = evtData;
        }
        if (newEvts != null) {
            Collection<ZookeeperClusterNode> nodes = this.rtState.top.nodesByOrder.values();
            for (int i = 0; i < newEvts.size(); ++i) {
                this.rtState.evtsData.addEvent(nodes, (ZkDiscoveryEventData)newEvts.get(i));
            }
            this.saveAndProcessNewEvents();
        }
    }

    private ZkDiscoveryCustomEventData createAckEvent(DiscoverySpiCustomMessage ack, ZkDiscoveryCustomEventData origEvt) throws Exception {
        assert (ack != null);
        ++this.rtState.evtsData.evtIdGen;
        long evtId = this.rtState.evtsData.evtIdGen;
        byte[] ackBytes = this.marshalZip(ack);
        String path = this.zkPaths.ackEventDataPath(origEvt.eventId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Create ack event: " + path);
        }
        this.rtState.zkClient.createIfNeeded(path, ackBytes, CreateMode.PERSISTENT);
        ZkDiscoveryCustomEventData ackEvtData = new ZkDiscoveryCustomEventData(evtId, origEvt.eventId(), this.rtState.evtsData.topVer, this.locNode.id(), null, null);
        ackEvtData.resolvedMsg = ack;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Generated CUSTOM event ack [origEvtId=" + origEvt.eventId() + ", evt=" + ackEvtData + ", evtSize=" + ackBytes.length + ", msg=" + ack + ']');
        }
        return ackEvtData;
    }

    private void handleProcessedEventsOnNodesFail(List<ZookeeperClusterNode> failedNodes) throws Exception {
        boolean processed = false;
        for (Map.Entry<Long, ZkDiscoveryEventData> e : this.rtState.evtsData.evts.entrySet()) {
            ZkDiscoveryEventData evtData = e.getValue();
            for (int i = 0; i < failedNodes.size(); ++i) {
                ZookeeperClusterNode failedNode = failedNodes.get(i);
                if (!evtData.onNodeFail(failedNode)) continue;
                processed = true;
            }
        }
        if (processed) {
            this.handleProcessedEvents("fail-" + U.nodeIds(failedNodes));
        }
    }

    private void handleProcessedJoinEventAsync(ZkDiscoveryNodeJoinEventData evtData) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("All nodes processed node join [evtData=" + evtData + ']');
        }
        for (int i = 0; i < evtData.joinedNodes.size(); ++i) {
            ZkJoinedNodeEvtData joinedEvtData = evtData.joinedNodes.get(i);
            this.deleteJoiningNodeData(joinedEvtData.nodeId, joinedEvtData.joinDataPrefixId, joinedEvtData.joinDataPartCnt);
            if (joinedEvtData.secSubjPartCnt <= 0) continue;
            this.deleteMultiplePartsAsync(this.rtState.zkClient, this.zkPaths.joinEventSecuritySubjectPath(evtData.eventId()), joinedEvtData.secSubjPartCnt);
        }
        this.deleteDataForJoinedAsync(evtData);
    }

    private void deleteJoiningNodeData(UUID nodeId, UUID joinDataPrefixId, int partCnt) {
        String evtDataPath = this.zkPaths.joiningNodeDataPath(nodeId, joinDataPrefixId);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delete joining node data [path=" + evtDataPath + ']');
        }
        this.rtState.zkClient.deleteIfExistsAsync(evtDataPath);
        if (partCnt > 1) {
            this.deleteMultiplePartsAsync(this.rtState.zkClient, evtDataPath + ":", partCnt);
        }
    }

    private void deleteDataForJoinedAsync(ZkDiscoveryNodeJoinEventData evtData) {
        String dataForJoinedPath = this.zkPaths.joinEventDataPathForJoined(evtData.eventId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delete data for joined node [path=" + dataForJoinedPath + ']');
        }
        this.deleteMultiplePartsAsync(this.rtState.zkClient, dataForJoinedPath, evtData.dataForJoinedPartCnt);
    }

    @Nullable
    private DiscoverySpiCustomMessage handleProcessedCustomEvent(String ctx, ZkDiscoveryCustomEventData evtData) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("All nodes processed custom event [ctx=" + ctx + ", evtData=" + evtData + ']');
        }
        if (!evtData.ackEvent()) {
            if (evtData.evtPath != null) {
                this.deleteCustomEventDataAsync(this.rtState.zkClient, evtData.evtPath);
            } else if (evtData.resolvedMsg instanceof ZkCommunicationErrorResolveFinishMessage) {
                UUID futId = ((ZkCommunicationErrorResolveFinishMessage)evtData.resolvedMsg).futId;
                ZkDistributedCollectDataFuture.deleteFutureData(this.rtState.zkClient, this.zkPaths, futId, this.log);
            }
            assert (evtData.resolvedMsg != null || this.locNode.order() > evtData.topologyVersion()) : evtData;
            if (evtData.resolvedMsg != null) {
                return evtData.resolvedMsg.ackMessage();
            }
        } else {
            String path = this.zkPaths.ackEventDataPath(evtData.origEvtId);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Delete path: " + path);
            }
            this.rtState.zkClient.deleteIfExistsAsync(path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runInWorkerThread(Runnable c) {
        IgniteThreadPoolExecutor pool;
        Object object = this.stateMux;
        synchronized (object) {
            if (this.connState == ConnectionState.STOPPED) {
                LT.warn((IgniteLogger)this.log, (String)"Do not run closure, node is stopped.");
                return;
            }
            if (this.utilityPool == null) {
                this.utilityPool = new IgniteThreadPoolExecutor("zk-discovery-pool", this.igniteInstanceName, 0, 1, 2000L, new LinkedBlockingQueue());
            }
            pool = this.utilityPool;
        }
        pool.submit(c);
    }

    public void stop() {
        this.stop0(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop0(Throwable e) {
        ZkRuntimeState rtState;
        block9: {
            if (!this.stop.compareAndSet(false, true)) {
                return;
            }
            rtState = this.rtState;
            if (rtState.zkClient != null && rtState.locNodeZkPath != null && rtState.zkClient.connected()) {
                try {
                    if (e == null && rtState.joined) {
                        rtState.zkClient.createIfNeededNoRetry(this.zkPaths.nodeStoppedFlag(this.locNode), null, CreateMode.PERSISTENT);
                    }
                    rtState.zkClient.deleteIfExistsNoRetry(rtState.locNodeZkPath, -1);
                }
                catch (Exception err) {
                    if (!this.log.isDebugEnabled()) break block9;
                    this.log.debug("Failed to delete local node's znode on stop: " + err);
                }
            }
        }
        IgniteCheckedException err = new IgniteCheckedException("Node stopped.");
        Object object = this.stateMux;
        synchronized (object) {
            this.connState = ConnectionState.STOPPED;
            rtState.onCloseStart((Exception)((Object)err));
        }
        IgniteUtils.shutdownNow(ZookeeperDiscoveryImpl.class, (ExecutorService)this.utilityPool, (IgniteLogger)this.log);
        this.busyLock.block();
        this.busyLock.unblock();
        this.joinFut.onDone(e);
        ZookeeperClient zkClient = rtState.zkClient;
        if (zkClient != null) {
            zkClient.close();
        }
        this.finishFutures(err);
    }

    private void finishFutures(IgniteCheckedException err) {
        ZkCommunicationErrorProcessFuture commErrFut = this.commErrProcFut.get();
        if (commErrFut != null) {
            commErrFut.onError((Exception)((Object)err));
        }
        for (PingFuture fut : this.pingFuts.values()) {
            fut.onDone(err);
        }
    }

    void onFatalError(GridSpinBusyLock busyLock, Throwable err) {
        busyLock.leaveBusy();
        if (err instanceof ZookeeperClientFailedException) {
            return;
        }
        Ignite ignite = this.spi.ignite();
        if (this.stopping() || ignite == null) {
            return;
        }
        U.error((IgniteLogger)this.log, (Object)"Fatal error in ZookeeperDiscovery. Stopping the node in order to prevent cluster wide instability.", (Throwable)err);
        this.stop0(err);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IgnitionEx.stop((String)ZookeeperDiscoveryImpl.this.igniteInstanceName, (boolean)true, (ShutdownPolicy)ShutdownPolicy.IMMEDIATE, (boolean)true);
                    U.log((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)"Stopped the node successfully in response to fatal error in ZookeeperDiscoverySpi.");
                }
                catch (Throwable e) {
                    U.error((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)"Failed to stop the node successfully in response to fatal error in ZookeeperDiscoverySpi.", (Throwable)e);
                }
            }
        }, "node-stop-thread").start();
        if (err instanceof Error) {
            throw (Error)err;
        }
    }

    private <T> T unmarshalZip(byte[] zipBytes) throws Exception {
        assert (zipBytes != null && zipBytes.length > 0);
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(zipBytes));
        return (T)this.marsh.unmarshal((InputStream)in, U.resolveClassLoader((IgniteConfiguration)this.spi.ignite().configuration()));
    }

    byte[] marshalZip(Object obj) throws IgniteCheckedException {
        assert (obj != null);
        return ZookeeperDiscoveryImpl.zip(U.marshal((Marshaller)this.marsh, (Object)obj));
    }

    private static byte[] zip(byte[] bytes) {
        Deflater deflater = new Deflater();
        deflater.setInput(bytes);
        deflater.finish();
        GridByteArrayOutputStream out = new GridByteArrayOutputStream(bytes.length);
        byte[] buf = new byte[bytes.length];
        while (!deflater.finished()) {
            int cnt = deflater.deflate(buf);
            out.write(buf, 0, cnt);
        }
        return out.toByteArray();
    }

    public static byte[] unzip(byte[] zipBytes) throws DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(zipBytes);
        GridByteArrayOutputStream out = new GridByteArrayOutputStream(zipBytes.length * 2);
        byte[] buf = new byte[zipBytes.length];
        while (!inflater.finished()) {
            int cnt = inflater.inflate(buf);
            out.write(buf, 0, cnt);
        }
        return out.toByteArray();
    }

    public UUID getCoordinator() {
        ZkRuntimeState rtState0 = this.rtState;
        if (rtState0 == null) {
            return null;
        }
        return rtState0.top.nodesByOrder.values().stream().filter(n -> !n.isClient()).map(ZookeeperClusterNode::id).findFirst().orElse(null);
    }

    public String getSpiState() {
        return this.connState.toString();
    }

    public String getZkSessionId() {
        ZkRuntimeState rtState0 = this.rtState;
        if (rtState0 != null && rtState0.zkClient != null) {
            return Long.toHexString(this.rtState.zkClient.zk().getSessionId());
        }
        return null;
    }

    static enum ConnectionState {
        STARTED,
        DISCONNECTED,
        STOPPED;

    }

    private class PingFuture
    extends GridFutureAdapter<Boolean>
    implements IgniteSpiTimeoutObject {
        private final ZookeeperClusterNode node;
        private final long endTime;
        private final IgniteUuid id;
        private final ZkRuntimeState rtState;

        PingFuture(ZkRuntimeState rtState, ZookeeperClusterNode node) {
            this.rtState = rtState;
            this.node = node;
            this.id = IgniteUuid.fromUuid((UUID)node.id());
            this.endTime = System.currentTimeMillis() + node.sessionTimeout() + 1000L;
        }

        public IgniteUuid id() {
            return this.id;
        }

        public long endTime() {
            return this.endTime;
        }

        public void onTimeout() {
            if (this.checkNodeAndState()) {
                ZookeeperDiscoveryImpl.this.runInWorkerThread(new ZkRunnable(this.rtState, ZookeeperDiscoveryImpl.this){

                    @Override
                    protected void run0() throws Exception {
                        if (PingFuture.this.checkNodeAndState()) {
                            try {
                                for (String path : this.rtState.zkClient.getChildren(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.aliveNodesDir)) {
                                    if (PingFuture.this.node.internalId() != ZkIgnitePaths.aliveInternalId(path)) continue;
                                    PingFuture.this.onDone(true);
                                    return;
                                }
                                PingFuture.this.onDone(false);
                            }
                            catch (Exception e) {
                                PingFuture.this.onDone(e);
                                throw e;
                            }
                        }
                    }

                    @Override
                    void onStartFailed() {
                        PingFuture.this.onDone(this.rtState.errForClose);
                    }
                });
            }
        }

        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err) {
            if (super.onDone((Object)res, err)) {
                ZookeeperDiscoveryImpl.this.pingFuts.remove(this.node.order(), (Object)this);
                return true;
            }
            return false;
        }

        boolean checkNodeAndState() {
            if (this.isDone()) {
                return false;
            }
            Exception err = this.rtState.errForClose;
            if (err != null) {
                this.onDone(err);
                return false;
            }
            ConnectionState connState = ZookeeperDiscoveryImpl.this.connState;
            if (connState == ConnectionState.DISCONNECTED) {
                this.onDone((Throwable)new IgniteClientDisconnectedException(null, "Client is disconnected."));
                return false;
            }
            if (connState == ConnectionState.STOPPED) {
                this.onDone((Throwable)new IgniteException("Node stopped."));
                return false;
            }
            if (ZookeeperDiscoveryImpl.this.node(this.node.id()) == null) {
                this.onDone(false);
                return false;
            }
            return true;
        }
    }

    class CheckClientsStatusCallback
    extends ZkAbstractChildrenCallback {
        CheckClientsStatusCallback(ZkRuntimeState rtState) {
            super(rtState, ZookeeperDiscoveryImpl.this);
        }

        @Override
        void processResult0(int rc, String path, Object ctx, List<String> children, Stat stat) throws Exception {
            assert (rc == 0) : KeeperException.Code.get((int)rc);
            ZookeeperDiscoveryImpl.this.checkClientsStatus(children);
        }
    }

    class CheckCoordinatorCallback
    extends ZkAbstractChildrenCallback {
        CheckCoordinatorCallback(ZkRuntimeState rtState) {
            super(rtState, ZookeeperDiscoveryImpl.this);
        }

        @Override
        public void processResult0(int rc, String path, Object ctx, List<String> children, Stat stat) throws Exception {
            assert (rc == 0) : KeeperException.Code.get((int)rc);
            ZookeeperDiscoveryImpl.this.checkIsCoordinator(children);
        }
    }

    private class ClientLocalNodeWatcher
    extends PreviousNodeWatcher {
        final CheckJoinErrorWatcher joinErrorWatcher;

        ClientLocalNodeWatcher(ZkRuntimeState rtState, CheckJoinErrorWatcher joinErrorWatcher) {
            super(rtState);
            assert (ZookeeperDiscoveryImpl.this.locNode.isClient()) : ZookeeperDiscoveryImpl.access$900(zookeeperDiscoveryImpl);
            this.joinErrorWatcher = joinErrorWatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void onPreviousNodeFail() {
            this.joinErrorWatcher.checkJoinError();
            if (this.rtState.errForClose != null || this.rtState.joined) {
                return;
            }
            Object object = ZookeeperDiscoveryImpl.this.stateMux;
            synchronized (object) {
                if (ZookeeperDiscoveryImpl.this.connState != ConnectionState.STARTED) {
                    return;
                }
            }
            if (ZookeeperDiscoveryImpl.this.log.isInfoEnabled()) {
                ZookeeperDiscoveryImpl.this.log.info("Watched local node failed [locId=" + ZookeeperDiscoveryImpl.this.locNode.id() + ']');
            }
            ZookeeperDiscoveryImpl.this.localNodeFail("Local node was forced to stop.", true);
        }
    }

    private class ClientPreviousNodeWatcher
    extends PreviousNodeWatcher {
        ClientPreviousNodeWatcher(ZkRuntimeState rtState) {
            super(rtState);
            assert (ZookeeperDiscoveryImpl.this.locNode.isClient()) : ZookeeperDiscoveryImpl.access$900(zookeeperDiscoveryImpl);
        }

        @Override
        void onPreviousNodeFail() {
            if (ZookeeperDiscoveryImpl.this.log.isInfoEnabled()) {
                ZookeeperDiscoveryImpl.this.log.info("Watched node failed, check if there are alive servers [locId=" + ZookeeperDiscoveryImpl.this.locNode.id() + ']');
            }
            this.rtState.zkClient.getChildrenAsync(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.aliveNodesDir, null, new CheckClientsStatusCallback(this.rtState));
        }
    }

    private class ServerPreviousNodeWatcher
    extends PreviousNodeWatcher {
        ServerPreviousNodeWatcher(ZkRuntimeState rtState) {
            super(rtState);
            assert (!ZookeeperDiscoveryImpl.this.locNode.isClient()) : ZookeeperDiscoveryImpl.access$900(zookeeperDiscoveryImpl);
        }

        @Override
        void onPreviousNodeFail() {
            if (ZookeeperDiscoveryImpl.this.log.isInfoEnabled()) {
                ZookeeperDiscoveryImpl.this.log.info("Previous server node failed, check is node new coordinator [locId=" + ZookeeperDiscoveryImpl.this.locNode.id() + ']');
            }
            this.rtState.zkClient.getChildrenAsync(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.aliveNodesDir, null, new CheckCoordinatorCallback(this.rtState));
        }
    }

    private abstract class PreviousNodeWatcher
    extends ZkAbstractWatcher
    implements AsyncCallback.StatCallback {
        PreviousNodeWatcher(ZkRuntimeState rtState) {
            super(rtState, ZookeeperDiscoveryImpl.this);
        }

        @Override
        public void process0(WatchedEvent evt) {
            if (evt.getType() == Watcher.Event.EventType.NodeDeleted) {
                this.onPreviousNodeFail();
            } else if (evt.getType() != Watcher.Event.EventType.None) {
                this.rtState.zkClient.existsAsync(evt.getPath(), this, this);
            }
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (!this.onProcessStart()) {
                return;
            }
            try {
                assert (rc == 0 || rc == KeeperException.Code.NONODE.intValue()) : KeeperException.Code.get((int)rc);
                if (rc == KeeperException.Code.NONODE.intValue() || stat == null) {
                    this.onPreviousNodeFail();
                }
                this.onProcessEnd();
            }
            catch (Throwable e) {
                this.onProcessError(e);
            }
        }

        abstract void onPreviousNodeFail();
    }

    private class AliveNodeDataWatcher
    extends ZkAbstractWatcher
    implements ZkRuntimeState.ZkAliveNodeDataWatcher {
        AliveNodeDataWatcher(ZkRuntimeState rtState) {
            super(rtState, ZookeeperDiscoveryImpl.this);
        }

        @Override
        public void process0(WatchedEvent evt) {
            if (evt.getType() == Watcher.Event.EventType.NodeDataChanged) {
                this.rtState.zkClient.getDataAsync(evt.getPath(), this, this);
            }
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            if (!this.onProcessStart()) {
                return;
            }
            try {
                assert (this.rtState.crd);
                this.processResult0(rc, path, data);
                this.onProcessEnd();
            }
            catch (Throwable e) {
                this.onProcessError(e);
            }
        }

        private void processResult0(int rc, String path, byte[] data) throws Exception {
            if (rc == KeeperException.Code.NONODE.intValue()) {
                if (ZookeeperDiscoveryImpl.this.log.isDebugEnabled()) {
                    ZookeeperDiscoveryImpl.this.log.debug("Alive node callaback, no node: " + path);
                }
                return;
            }
            assert (rc == 0) : KeeperException.Code.get((int)rc);
            if (data.length > 0) {
                ZkAliveNodeData nodeData = (ZkAliveNodeData)ZookeeperDiscoveryImpl.this.unmarshalZip(data);
                Long nodeInternalId = ZkIgnitePaths.aliveInternalId(path);
                Iterator<ZkDiscoveryEventData> it = this.rtState.evtsData.evts.values().iterator();
                boolean processed = false;
                while (it.hasNext()) {
                    ZkDiscoveryEventData evtData = it.next();
                    if (!evtData.onAckReceived(nodeInternalId, nodeData.lastProcEvt)) continue;
                    processed = true;
                }
                if (processed) {
                    ZookeeperDiscoveryImpl.this.handleProcessedEvents("ack-" + nodeInternalId);
                }
            }
        }
    }

    private class ZkWatcher
    extends ZkAbstractWatcher
    implements ZkRuntimeState.ZkWatcher {
        ZkWatcher(ZkRuntimeState rtState) {
            super(rtState, ZookeeperDiscoveryImpl.this);
        }

        @Override
        public void process0(WatchedEvent evt) {
            if (evt.getType() == Watcher.Event.EventType.NodeDataChanged) {
                if (evt.getPath().equals(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.evtsPath)) {
                    if (!this.rtState.crd) {
                        this.rtState.zkClient.getDataAsync(evt.getPath(), this, this);
                    }
                } else {
                    U.warn((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)("Received NodeDataChanged for unexpected path: " + evt.getPath()));
                }
            } else if (evt.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                if (evt.getPath().equals(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.aliveNodesDir)) {
                    this.rtState.zkClient.getChildrenAsync(evt.getPath(), this, this);
                } else if (evt.getPath().equals(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.customEvtsDir)) {
                    this.rtState.zkClient.getChildrenAsync(evt.getPath(), this, this);
                } else {
                    U.warn((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)("Received NodeChildrenChanged for unexpected path: " + evt.getPath()));
                }
            }
        }

        public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
            if (!this.onProcessStart()) {
                return;
            }
            try {
                assert (rc == 0) : KeeperException.Code.get((int)rc);
                if (path.equals(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.aliveNodesDir)) {
                    ZookeeperDiscoveryImpl.this.generateTopologyEvents(children);
                } else if (path.equals(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.customEvtsDir)) {
                    ZookeeperDiscoveryImpl.this.generateCustomEvents(children);
                } else {
                    U.warn((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)("Children callback for unexpected path: " + path));
                }
                this.onProcessEnd();
            }
            catch (Throwable e) {
                this.onProcessError(e);
            }
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            if (!this.onProcessStart()) {
                return;
            }
            try {
                assert (rc == 0) : KeeperException.Code.get((int)rc);
                if (path.equals(((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).zkPaths.evtsPath)) {
                    if (!this.rtState.crd) {
                        ZookeeperDiscoveryImpl.this.processNewEvents(data);
                    }
                } else {
                    U.warn((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)("Data callback for unknown path: " + path));
                }
                this.onProcessEnd();
            }
            catch (Throwable e) {
                this.onProcessError(e);
            }
        }
    }

    private class ConnectionLossListener
    implements IgniteRunnable {
        private static final long serialVersionUID = 0L;

        private ConnectionLossListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ZookeeperDiscoveryImpl.this.clientReconnectEnabled) {
                Object object = ZookeeperDiscoveryImpl.this.stateMux;
                synchronized (object) {
                    if (ZookeeperDiscoveryImpl.this.connState != ConnectionState.STARTED) {
                        return;
                    }
                    ZookeeperDiscoveryImpl.this.connState = ConnectionState.DISCONNECTED;
                    ZookeeperDiscoveryImpl.this.rtState.onCloseStart((Exception)ZookeeperDiscoveryImpl.disconnectError());
                }
                UUID newId = UUID.randomUUID();
                U.quietAndWarn((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)("Connection to Zookeeper server is lost, local node will try to reconnect with new id [newId=" + newId + ", prevId=" + ZookeeperDiscoveryImpl.this.locNode.id() + ", locNode=" + ZookeeperDiscoveryImpl.this.locNode + ']'));
                ZookeeperDiscoveryImpl.this.runInWorkerThread(new ReconnectClosure(newId));
            } else {
                U.warn((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)"Connection to Zookeeper server is lost, local node SEGMENTED.");
                ZookeeperDiscoveryImpl.this.onSegmented((Exception)new IgniteSpiException("Zookeeper connection loss."));
            }
        }
    }

    private class ReconnectClosure
    implements Runnable {
        private final UUID newId;

        ReconnectClosure(UUID newId) {
            assert (newId != null);
            this.newId = newId;
        }

        @Override
        public void run() {
            ZookeeperDiscoveryImpl.this.finishFutures((IgniteCheckedException)ZookeeperDiscoveryImpl.disconnectError());
            ZookeeperDiscoveryImpl.this.busyLock.block();
            ZookeeperDiscoveryImpl.this.busyLock.unblock();
            ZookeeperDiscoveryImpl.this.doReconnect(this.newId);
        }
    }

    private class CheckJoinErrorWatcher
    extends ZkAbstractWatcher
    implements AsyncCallback.DataCallback {
        private final String joinDataPath;
        private ZkTimeoutObject timeoutObj;

        CheckJoinErrorWatcher(long timeout, String joinDataPath0, ZkRuntimeState rtState0) {
            super(rtState0, ZookeeperDiscoveryImpl.this);
            this.joinDataPath = joinDataPath0;
            this.timeoutObj = new ZkTimeoutObject(timeout){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onTimeout() {
                    if (CheckJoinErrorWatcher.this.rtState.errForClose != null || CheckJoinErrorWatcher.this.rtState.joined) {
                        return;
                    }
                    Object object = ZookeeperDiscoveryImpl.this.stateMux;
                    synchronized (object) {
                        if (ZookeeperDiscoveryImpl.this.connState != ConnectionState.STARTED) {
                            return;
                        }
                    }
                    CheckJoinErrorWatcher.this.rtState.zkClient.getDataAsync(CheckJoinErrorWatcher.this.joinDataPath, CheckJoinErrorWatcher.this, CheckJoinErrorWatcher.this);
                    if (ZookeeperDiscoveryImpl.this.locNode.isClient()) {
                        ClientLocalNodeWatcher watcher = new ClientLocalNodeWatcher(CheckJoinErrorWatcher.this.rtState, CheckJoinErrorWatcher.this);
                        CheckJoinErrorWatcher.this.rtState.zkClient.existsAsync(CheckJoinErrorWatcher.this.rtState.locNodeZkPath, watcher, watcher);
                    }
                }
            };
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            if (rc != 0) {
                return;
            }
            this.processData(data);
        }

        void checkJoinError() {
            try {
                byte[] data = this.rtState.zkClient.getData(this.joinDataPath);
                this.processData(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void processData(byte[] data) {
            if (!this.onProcessStart()) {
                return;
            }
            try {
                Object obj = ZookeeperDiscoveryImpl.this.unmarshalZip(data);
                if (obj instanceof ZkInternalJoinErrorMessage) {
                    ZkInternalJoinErrorMessage joinErr = (ZkInternalJoinErrorMessage)obj;
                    ZookeeperDiscoveryImpl.this.onSegmented((Exception)new IgniteSpiException(joinErr.err));
                }
                this.onProcessEnd();
            }
            catch (Throwable e) {
                this.onProcessError(e);
            }
        }

        @Override
        public void process0(WatchedEvent evt) {
            if (this.rtState.errForClose != null || this.rtState.joined) {
                return;
            }
            if (evt.getType() == Watcher.Event.EventType.NodeDataChanged) {
                this.rtState.zkClient.getDataAsync(evt.getPath(), this, this);
            }
        }
    }

    private class JoinTimeoutObject
    extends ZkTimeoutObject {
        JoinTimeoutObject(long timeout) {
            super(timeout);
        }

        public void onTimeout() {
            if (this.cancelled || ((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).rtState.joined) {
                return;
            }
            ZookeeperDiscoveryImpl.this.runInWorkerThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ZookeeperDiscoveryImpl.this.stateMux;
                    synchronized (object) {
                        if (JoinTimeoutObject.this.cancelled || ((ZookeeperDiscoveryImpl)ZookeeperDiscoveryImpl.this).rtState.joined) {
                            return;
                        }
                        if (ZookeeperDiscoveryImpl.this.connState == ConnectionState.STOPPED) {
                            return;
                        }
                        ZookeeperDiscoveryImpl.this.connState = ConnectionState.STOPPED;
                    }
                    U.warn((IgniteLogger)ZookeeperDiscoveryImpl.this.log, (Object)("Failed to connect to cluster, either connection to ZooKeeper can not be established or there are no alive server nodes (consider increasing 'joinTimeout' configuration  property) [joinTimeout=" + ZookeeperDiscoveryImpl.this.spi.getJoinTimeout() + ']'));
                    ZookeeperDiscoveryImpl.this.onSegmented((Exception)new IgniteSpiException("Failed to connect to cluster within configured timeout"));
                }
            });
        }
    }

    private class UpdateProcessedEventsTimeoutObject
    extends ZkTimeoutObject {
        private final ZkRuntimeState rtState;

        UpdateProcessedEventsTimeoutObject(ZkRuntimeState rtState, long timeout) {
            super(timeout);
            this.rtState = rtState;
        }

        public void onTimeout() {
            ZookeeperDiscoveryImpl.this.runInWorkerThread(new ZkRunnable(this.rtState, ZookeeperDiscoveryImpl.this){

                @Override
                protected void run0() throws Exception {
                    ZookeeperDiscoveryImpl.this.updateProcessedEventsOnTimeout(this.rtState, UpdateProcessedEventsTimeoutObject.this);
                }
            });
        }
    }
}

