/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.config;

import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.corerpc.RpcConfig;

public class TubeClientConfigUtils {
    public static RpcConfig getRpcConfigByClientConfig(TubeClientConfig tubeClientConfig, boolean isSingleSession) {
        RpcConfig config = new RpcConfig();
        config.put("tcp.tls", (Object)tubeClientConfig.isTlsEnable());
        if (tubeClientConfig.isTlsEnable()) {
            config.put("tls.truststore.path", (Object)tubeClientConfig.getTrustStorePath());
            config.put("tls.truststore.password", (Object)tubeClientConfig.getTrustStorePassword());
            config.put("tls.twoway.authentic", (Object)tubeClientConfig.isEnableTLSTwoWayAuthentic());
            if (tubeClientConfig.isEnableTLSTwoWayAuthentic()) {
                config.put("tls.keystore.path", (Object)tubeClientConfig.getKeyStorePath());
                config.put("tls.keystore.password", (Object)tubeClientConfig.getKeyStorePassword());
            }
        }
        config.put("rpc.connect.timeout", (Object)3000);
        config.put("rpc.request.timeout", (Object)tubeClientConfig.getRpcTimeoutMs());
        config.put("rpc.netty.write.highmark", (Object)tubeClientConfig.getNettyWriteBufferHighWaterMark());
        config.put("rpc.netty.write.lowmark", (Object)tubeClientConfig.getNettyWriteBufferLowWaterMark());
        config.put("rpc.netty.worker.count", (Object)tubeClientConfig.getRpcConnProcessorCnt());
        if (isSingleSession) {
            config.put("rpc.netty.worker.thread.name", (Object)"tube_single_netty_worker-");
        } else {
            config.put("rpc.netty.worker.thread.name", (Object)"tube_multi_netty_worker-");
        }
        config.put("rpc.netty.callback.count", (Object)tubeClientConfig.getRpcRspCallBackThreadCnt());
        return config;
    }
}

