/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.producer;

import java.lang.management.ManagementFactory;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.inlong.tubemq.client.common.ClientStatsInfo;
import org.apache.inlong.tubemq.client.config.TubeClientConfig;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.client.factory.InnerSessionFactory;
import org.apache.inlong.tubemq.client.producer.MaxMsgSizeHolder;
import org.apache.inlong.tubemq.corebase.aaaclient.ClientAuthenticateHandler;
import org.apache.inlong.tubemq.corebase.aaaclient.SimpleClientAuthenticateHandler;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corebase.utils.DataConverterUtil;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcServiceFactory;
import org.apache.inlong.tubemq.corerpc.exception.ClientClosedException;
import org.apache.inlong.tubemq.corerpc.exception.LocalConnException;
import org.apache.inlong.tubemq.corerpc.service.MasterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerManager {
    private static final Logger logger = LoggerFactory.getLogger(ProducerManager.class);
    private static final int BROKER_UPDATED_TIME_AFTER_RETRY_FAIL = 0x6DDD00;
    private static final AtomicInteger producerCounter = new AtomicInteger(0);
    private final String producerId;
    private final int producerAddrId;
    private final TubeClientConfig tubeClientConfig;
    private final InnerSessionFactory sessionFactory;
    private final RpcServiceFactory rpcServiceFactory;
    private final ConcurrentHashMap<String, AtomicInteger> publishTopics = new ConcurrentHashMap();
    private final RpcConfig rpcConfig = new RpcConfig();
    private final ScheduledExecutorService heartbeatService;
    private final AtomicLong visitToken = new AtomicLong(-2L);
    private final MaxMsgSizeHolder msgSizeHolder = new MaxMsgSizeHolder();
    private final AtomicReference<String> authAuthorizedTokenRef = new AtomicReference<String>("");
    private final ClientAuthenticateHandler authenticateHandler = new SimpleClientAuthenticateHandler();
    private final MasterService masterService;
    private Map<Integer, BrokerInfo> brokersMap = new ConcurrentHashMap<Integer, BrokerInfo>();
    private long brokerInfoCheckSum = -1L;
    private long lastBrokerUpdatedTime = System.currentTimeMillis();
    private long lastEmptyBrokerPrintTime = 0L;
    private long lastEmptyTopicPrintTime = 0L;
    private int heartbeatRetryTimes = 0;
    private final AtomicBoolean isStartHeart = new AtomicBoolean(false);
    private final AtomicInteger heartBeatStatus = new AtomicInteger(-1);
    private volatile long lastHeartbeatTime = System.currentTimeMillis();
    private final AtomicInteger nodeStatus = new AtomicInteger(-1);
    private Map<String, Map<Integer, List<Partition>>> topicPartitionMap = new ConcurrentHashMap<String, Map<Integer, List<Partition>>>();
    private final AtomicBoolean nextWithAuthInfo2M = new AtomicBoolean(false);
    private final ClientStatsInfo clientStatsInfo;

    public ProducerManager(InnerSessionFactory sessionFactory, TubeClientConfig tubeClientConfig) throws TubeClientException {
        Security.setProperty("networkaddress.cache.ttl", "3");
        Security.setProperty("networkaddress.cache.negative.ttl", "1");
        if (sessionFactory == null || tubeClientConfig == null) {
            throw new TubeClientException("Illegal parameter: messageSessionFactory or tubeClientConfig is null!");
        }
        this.tubeClientConfig = tubeClientConfig;
        this.sessionFactory = sessionFactory;
        try {
            this.producerId = this.generateProducerID();
            this.producerAddrId = AddressUtils.ipToInt((String)AddressUtils.getLocalAddress());
        }
        catch (Exception e) {
            throw new TubeClientException("Generate producer id failed!", e);
        }
        this.rpcServiceFactory = this.sessionFactory.getRpcServiceFactory();
        this.rpcConfig.put("rpc.connect.timeout", (Object)3000);
        this.rpcConfig.put("rpc.request.timeout", (Object)tubeClientConfig.getRpcTimeoutMs());
        this.rpcConfig.put("rpc.netty.write.highmark", (Object)tubeClientConfig.getNettyWriteBufferHighWaterMark());
        this.rpcConfig.put("rpc.netty.write.lowmark", (Object)tubeClientConfig.getNettyWriteBufferLowWaterMark());
        this.rpcConfig.put("rpc.netty.worker.count", (Object)tubeClientConfig.getRpcConnProcessorCnt());
        this.rpcConfig.put("rpc.netty.worker.thread.name", (Object)"tube_netty_worker-");
        this.rpcConfig.put("rpc.netty.callback.count", (Object)tubeClientConfig.getRpcRspCallBackThreadCnt());
        this.clientStatsInfo = new ClientStatsInfo(true, this.producerId, this.tubeClientConfig.getStatsConfig());
        this.heartBeatStatus.set(0);
        this.masterService = (MasterService)this.rpcServiceFactory.getFailoverService(MasterService.class, tubeClientConfig.getMasterInfo(), this.rpcConfig);
        this.heartbeatService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, new StringBuilder(256).append("Producer-Heartbeat-Thread-").append(ProducerManager.this.producerId).toString());
                t.setPriority(10);
                return t;
            }
        });
    }

    public String getClientVersion() {
        return "1.7.0";
    }

    public void start() throws Throwable {
        if (this.nodeStatus.get() <= 0 && this.nodeStatus.compareAndSet(-1, 0)) {
            this.register2Master();
            logger.info("[Producer] Producer status from ready to running!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String topic) throws TubeClientException {
        this.checkServiceStatus();
        StringBuilder sBuilder = new StringBuilder(512);
        try {
            AtomicInteger tmpPubCnt;
            logger.info(sBuilder.append("[Publish begin 1] publish topic ").append(topic).append(", address = ").append(this.toString()).toString());
            sBuilder.delete(0, sBuilder.length());
            AtomicInteger curPubCnt = this.publishTopics.get(topic);
            if (curPubCnt == null && (curPubCnt = this.publishTopics.putIfAbsent(topic, tmpPubCnt = new AtomicInteger(0))) == null) {
                curPubCnt = tmpPubCnt;
            }
            if (curPubCnt.incrementAndGet() == 1) {
                long curTime = System.currentTimeMillis();
                new ProducerHeartbeatTask().run();
                logger.info(sBuilder.append("[Publish begin 1] already get meta info, topic: ").append(topic).append(", waste time ").append(System.currentTimeMillis() - curTime).append(" Ms").toString());
                sBuilder.delete(0, sBuilder.length());
            }
            if (this.topicPartitionMap.get(topic) == null) {
                throw new TubeClientException(sBuilder.append("Publish topic failure, make sure the topic ").append(topic).append(" exist or acceptPublish and try later!").toString());
            }
        }
        finally {
            if (this.isStartHeart.compareAndSet(false, true)) {
                this.heartbeatService.scheduleWithFixedDelay(new ProducerHeartbeatTask(), 5L, this.tubeClientConfig.getHeartbeatPeriodMs(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> publish(Set<String> topicSet) throws TubeClientException {
        this.checkServiceStatus();
        StringBuilder sBuilder = new StringBuilder(512);
        HashSet<String> failTopicSet = new HashSet<String>();
        HashSet<String> successTopicSet = new HashSet<String>();
        try {
            logger.info(sBuilder.append("[Publish begin 2] publish topicSet ").append(topicSet).append(", address = ").append(this.toString()).toString());
            sBuilder.delete(0, sBuilder.length());
            boolean hasNewTopic = false;
            for (String topicItem : topicSet) {
                AtomicInteger tmpPubCnt;
                AtomicInteger curPubCnt = this.publishTopics.get(topicItem);
                if (curPubCnt == null && (curPubCnt = this.publishTopics.putIfAbsent(topicItem, tmpPubCnt = new AtomicInteger(0))) == null) {
                    curPubCnt = tmpPubCnt;
                }
                if (curPubCnt.incrementAndGet() != 1) continue;
                hasNewTopic = true;
            }
            if (hasNewTopic) {
                long curTime = System.currentTimeMillis();
                new ProducerHeartbeatTask().run();
                logger.info(sBuilder.append("[Publish begin 2] already get meta info, topicSet: ").append(topicSet).append(", waste time ").append(System.currentTimeMillis() - curTime).append(" Ms").toString());
                sBuilder.delete(0, sBuilder.length());
            }
            for (String topicItem : topicSet) {
                if (this.topicPartitionMap.containsKey(topicItem)) {
                    successTopicSet.add(topicItem);
                    continue;
                }
                failTopicSet.add(topicItem);
            }
            if (!failTopicSet.isEmpty()) {
                logger.info(sBuilder.append("Publish topic failure, make sure the topics ").append(failTopicSet).append(" exist or acceptPublish and try later!").toString());
                sBuilder.delete(0, sBuilder.length());
            }
        }
        finally {
            if (this.isStartHeart.compareAndSet(false, true)) {
                this.heartbeatService.scheduleWithFixedDelay(new ProducerHeartbeatTask(), 5L, this.tubeClientConfig.getHeartbeatPeriodMs(), TimeUnit.MILLISECONDS);
            }
        }
        return successTopicSet;
    }

    public void shutdown() throws Throwable {
        StringBuilder strBuff = new StringBuilder(512);
        logger.info("[ShutDown Producer] Shutting down heartbeat...");
        if (this.nodeStatus.get() != 0) {
            if (this.isShutdown()) {
                logger.info(strBuff.append("[ShutDown Producer] Producer ").append(this.producerId).append("has been shutdown,please do not make a duplicated invocation.").toString());
                strBuff.delete(0, strBuff.length());
            }
            return;
        }
        this.clientStatsInfo.selfPrintStatsInfo(true, true, strBuff);
        if (this.nodeStatus.compareAndSet(0, 1)) {
            this.heartbeatService.shutdownNow();
            this.topicPartitionMap.clear();
            this.masterService.producerCloseClientP2M(this.createCloseProducerRequest(), AddressUtils.getLocalAddress(), this.tubeClientConfig.isTlsEnable());
            logger.info("[SHUTDOWN_TUBE] tube heartbeat was shutdown.");
        }
    }

    public ClientStatsInfo getClientMetrics() {
        return this.clientStatsInfo;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public int getProducerAddrId() {
        return this.producerAddrId;
    }

    public int getMaxMsgSize(String topicName) {
        return this.msgSizeHolder.getDefMaxMsgSize(topicName);
    }

    public boolean isShutdown() {
        return this.nodeStatus.get() > 0;
    }

    public ClientBroker.SendMessageRequestP2B.Builder setAuthorizedTokenInfo(ClientBroker.SendMessageRequestP2B.Builder builder) {
        ClientBroker.AuthorizedInfo.Builder authInfoBuilder = ClientBroker.AuthorizedInfo.newBuilder();
        authInfoBuilder.setVisitAuthorizedToken(this.visitToken.get());
        String authAuthorizedToken = this.authAuthorizedTokenRef.get();
        if (TStringUtils.isNotBlank((String)authAuthorizedToken)) {
            authInfoBuilder.setAuthAuthorizedToken(authAuthorizedToken);
        }
        builder.setAuthInfo(authInfoBuilder.build());
        return builder;
    }

    public void removeTopic(Set<String> topicSet) {
        for (String topic : topicSet) {
            if (topic == null) continue;
            AtomicInteger subCnt = this.publishTopics.get(topic);
            if (subCnt == null) {
                return;
            }
            if (subCnt.decrementAndGet() != 0) continue;
            this.publishTopics.remove(topic);
        }
    }

    public Map<Integer, List<Partition>> getTopicPartition(String topic) {
        return this.topicPartitionMap.get(topic);
    }

    private void checkServiceStatus() throws TubeClientException {
        if (this.nodeStatus.get() < 0) {
            throw new TubeClientException("Status error: please call start function first!");
        }
        if (this.nodeStatus.get() > 0) {
            throw new TubeClientException("Status error: producer service has been shutdown!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void register2Master() throws Throwable {
        int remainingRetry = this.tubeClientConfig.getMaxRegisterRetryTimes();
        StringBuilder sBuilder = new StringBuilder(512);
        while (true) {
            if (this.isShutdown()) {
                logger.error("Producer service has been shutdown, exit register to master!");
                return;
            }
            --remainingRetry;
            try {
                ClientMaster.RegisterResponseM2P response = this.masterService.producerRegisterP2M(this.createRegisterRequest(), AddressUtils.getLocalAddress(), this.tubeClientConfig.isTlsEnable());
                if (response == null) {
                    this.clientStatsInfo.bookReg2Master(true);
                } else {
                    if (response.getSuccess()) {
                        if (response.getBrokerCheckSum() != this.brokerInfoCheckSum) {
                            this.updateBrokerInfoList(true, (List<String>)response.getBrokerInfosList(), response.getBrokerCheckSum(), sBuilder);
                        }
                        this.clientStatsInfo.bookReg2Master(false);
                        this.processRegSyncInfo(response);
                        return;
                    }
                    this.clientStatsInfo.bookReg2Master(true);
                }
                if (remainingRetry <= 0) {
                    if (response != null) throw new TubeClientException(sBuilder.append("Register producer failure, error is ").append(response.getErrMsg()).toString());
                    throw new TubeClientException("Register producer failure, response is null!");
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Throwable e) {
                sBuilder.delete(0, sBuilder.length());
                if (e instanceof LocalConnException) {
                    logger.warn("register2Master error, retry... exception: ", e);
                }
                ThreadUtils.sleep((long)1200L);
                if (remainingRetry <= 0) throw e;
                continue;
            }
            break;
        }
    }

    private ClientMaster.RegisterRequestP2M createRegisterRequest() throws Exception {
        ClientMaster.RegisterRequestP2M.Builder builder = ClientMaster.RegisterRequestP2M.newBuilder();
        builder.setClientId(this.producerId);
        builder.addAllTopicList((Iterable)this.publishTopics.keySet());
        builder.setBrokerCheckSum(this.brokerInfoCheckSum);
        builder.setHostName(AddressUtils.getLocalAddress());
        builder.setJdkVersion(MixedUtils.getJavaVersion());
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = this.genMasterCertificateInfo(true);
        if (authInfoBuilder != null) {
            builder.setAuthInfo(authInfoBuilder.build());
        }
        builder.setAppdConfig(this.buildAllowedConfig4P());
        return builder.build();
    }

    private ClientMaster.HeartRequestP2M createHeartbeatRequest() throws Exception {
        ClientMaster.HeartRequestP2M.Builder builder = ClientMaster.HeartRequestP2M.newBuilder();
        builder.setClientId(this.producerId);
        builder.addAllTopicList((Iterable)this.publishTopics.keySet());
        builder.setBrokerCheckSum(this.brokerInfoCheckSum);
        if (System.currentTimeMillis() - this.lastBrokerUpdatedTime > 0x6DDD00L) {
            builder.setBrokerCheckSum(-1L);
            this.lastBrokerUpdatedTime = System.currentTimeMillis();
        }
        builder.setHostName(AddressUtils.getLocalAddress());
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = this.genMasterCertificateInfo(false);
        if (authInfoBuilder != null) {
            builder.setAuthInfo(authInfoBuilder.build());
        }
        builder.setAppdConfig(this.buildAllowedConfig4P());
        return builder.build();
    }

    private ClientMaster.CloseRequestP2M createCloseProducerRequest() {
        ClientMaster.CloseRequestP2M.Builder builder = ClientMaster.CloseRequestP2M.newBuilder();
        builder.setClientId(this.producerId);
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = this.genMasterCertificateInfo(true);
        if (authInfoBuilder != null) {
            builder.setAuthInfo(authInfoBuilder);
        }
        return builder.build();
    }

    private void updateTopicConfigure(Tuple2<Map<String, Integer>, List<TopicInfo>> topicInfoTuple) {
        this.msgSizeHolder.updTopicMaxSizeInB((Map)topicInfoTuple.getF0());
        ConcurrentHashMap<String, Map<Integer, List<Partition>>> partitionListMap = new ConcurrentHashMap<String, Map<Integer, List<Partition>>>();
        for (TopicInfo topicInfo : (List)topicInfoTuple.getF1()) {
            ConcurrentHashMap<Integer, List> brokerPartList = (ConcurrentHashMap<Integer, List>)partitionListMap.get(topicInfo.getTopic());
            if (brokerPartList == null) {
                brokerPartList = new ConcurrentHashMap<Integer, List>();
                partitionListMap.put(topicInfo.getTopic(), brokerPartList);
            }
            for (int j = 0; j < topicInfo.getTopicStoreNum(); ++j) {
                int baseValue = j * 10000;
                for (int i = 0; i < topicInfo.getPartitionNum(); ++i) {
                    Partition tmpPart = new Partition(topicInfo.getBroker(), topicInfo.getTopic(), baseValue + i);
                    List partList = brokerPartList.computeIfAbsent(tmpPart.getBrokerId(), k -> new ArrayList());
                    partList.add(tmpPart);
                }
            }
        }
        this.topicPartitionMap = partitionListMap;
    }

    private String generateProducerID() throws Exception {
        String pidName = ManagementFactory.getRuntimeMXBean().getName();
        if (pidName != null && pidName.contains("@")) {
            pidName = pidName.split("@")[0];
        }
        return new StringBuilder(256).append(AddressUtils.getLocalAddress()).append("-").append(pidName).append("-").append(System.currentTimeMillis()).append("-").append(producerCounter.incrementAndGet()).append("-").append("1.7.0").toString();
    }

    private void updateBrokerInfoList(boolean isRegister, List<String> pkgBrokerInfos, long pkgCheckSum, StringBuilder sBuilder) {
        if (pkgCheckSum != this.brokerInfoCheckSum && pkgBrokerInfos != null) {
            this.brokersMap = DataConverterUtil.convertBrokerInfo(pkgBrokerInfos, (boolean)this.tubeClientConfig.isTlsEnable());
            this.brokerInfoCheckSum = pkgCheckSum;
            this.lastBrokerUpdatedTime = System.currentTimeMillis();
            if (pkgBrokerInfos.isEmpty()) {
                if (System.currentTimeMillis() - this.lastEmptyBrokerPrintTime > 60000L) {
                    if (isRegister) {
                        logger.warn(sBuilder.append("[Register Update] Found empty brokerList, changed checksum is ").append(this.brokerInfoCheckSum).toString());
                    } else {
                        logger.warn(sBuilder.append("[Heartbeat Update] Found empty brokerList, changed checksum is ").append(this.brokerInfoCheckSum).toString());
                    }
                    sBuilder.delete(0, sBuilder.length());
                    this.lastEmptyBrokerPrintTime = System.currentTimeMillis();
                }
            } else if (!isRegister) {
                logger.info(sBuilder.append("[Heartbeat Update] Found brokerList changed checksum is ").append(this.brokerInfoCheckSum).toString());
                sBuilder.delete(0, sBuilder.length());
            }
        }
    }

    private void processRegSyncInfo(ClientMaster.RegisterResponseM2P response) {
        if (response.hasAuthorizedInfo()) {
            this.processAuthorizedToken(response.getAuthorizedInfo());
        }
        if (response.hasAppdConfig()) {
            this.msgSizeHolder.updAllowedSetting(response.getAppdConfig());
        }
    }

    private void processHeartBeatSyncInfo(ClientMaster.HeartResponseM2P response, StringBuilder strBuff) {
        if (response.hasRequireAuth()) {
            this.nextWithAuthInfo2M.set(response.getRequireAuth());
        }
        if (response.hasAppdConfig()) {
            this.msgSizeHolder.updAllowedSetting(response.getAppdConfig());
        }
        if (response.hasAuthorizedInfo()) {
            this.processAuthorizedToken(response.getAuthorizedInfo());
        }
        if (response.getErrCode() == 201) {
            this.lastHeartbeatTime = System.currentTimeMillis();
            return;
        }
        if (response.getBrokerCheckSum() != this.brokerInfoCheckSum) {
            this.updateBrokerInfoList(false, (List<String>)response.getBrokerInfosList(), response.getBrokerCheckSum(), strBuff);
        }
        if (response.getTopicInfosList().isEmpty() && System.currentTimeMillis() - this.lastEmptyTopicPrintTime > 60000L) {
            logger.warn("[Heartbeat Update] found empty topicList update!");
            this.lastEmptyTopicPrintTime = System.currentTimeMillis();
        }
        this.updateTopicConfigure((Tuple2<Map<String, Integer>, List<TopicInfo>>)DataConverterUtil.convertTopicInfo(this.brokersMap, (List)response.getTopicInfosList()));
    }

    private void processAuthorizedToken(ClientMaster.MasterAuthorizedInfo inAuthorizedTokenInfo) {
        if (inAuthorizedTokenInfo != null) {
            String curAuthAuthorizedToken;
            String inAuthAuthorizedToken;
            this.visitToken.set(inAuthorizedTokenInfo.getVisitAuthorizedToken());
            if (inAuthorizedTokenInfo.hasAuthAuthorizedToken() && TStringUtils.isNotBlank((String)(inAuthAuthorizedToken = inAuthorizedTokenInfo.getAuthAuthorizedToken())) && !inAuthAuthorizedToken.equals(curAuthAuthorizedToken = this.authAuthorizedTokenRef.get())) {
                this.authAuthorizedTokenRef.set(inAuthAuthorizedToken);
            }
        }
    }

    private ClientMaster.MasterCertificateInfo.Builder genMasterCertificateInfo(boolean force) {
        boolean needAdd = false;
        ClientMaster.MasterCertificateInfo.Builder authInfoBuilder = null;
        if (this.tubeClientConfig.isEnableUserAuthentic()) {
            authInfoBuilder = ClientMaster.MasterCertificateInfo.newBuilder();
            if (force) {
                needAdd = true;
                this.nextWithAuthInfo2M.set(false);
            } else if (this.nextWithAuthInfo2M.get() && this.nextWithAuthInfo2M.compareAndSet(true, false)) {
                needAdd = true;
            }
            if (needAdd) {
                authInfoBuilder.setAuthInfo(this.authenticateHandler.genMasterAuthenticateToken(this.tubeClientConfig.getUsrName(), this.tubeClientConfig.getUsrPassWord()));
            } else {
                authInfoBuilder.setAuthorizedToken(this.authAuthorizedTokenRef.get());
            }
        }
        return authInfoBuilder;
    }

    private ClientMaster.ApprovedClientConfig.Builder buildAllowedConfig4P() {
        ClientMaster.ApprovedClientConfig.Builder appdConfig = ClientMaster.ApprovedClientConfig.newBuilder();
        appdConfig.setConfigId(this.msgSizeHolder.getConfigId());
        return appdConfig;
    }

    private class ProducerHeartbeatTask
    implements Runnable {
        private ProducerHeartbeatTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder strBuff = new StringBuilder(512);
            while (!ProducerManager.this.heartBeatStatus.compareAndSet(0, 1)) {
                ThreadUtils.sleep((long)100L);
            }
            ProducerManager.this.clientStatsInfo.selfPrintStatsInfo(false, true, strBuff);
            if (ProducerManager.this.publishTopics.isEmpty()) {
                return;
            }
            try {
                ClientMaster.HeartResponseM2P response = ProducerManager.this.masterService.producerHeartbeatP2M(ProducerManager.this.createHeartbeatRequest(), AddressUtils.getLocalAddress(), ProducerManager.this.tubeClientConfig.isTlsEnable());
                if (response == null || !response.getSuccess()) {
                    ProducerManager.this.heartbeatRetryTimes++;
                    if (response == null) {
                        ProducerManager.this.clientStatsInfo.bookHB2MasterException();
                        logger.error("[Heartbeat Failed] receive null HeartResponseM2P response!");
                    } else {
                        logger.error(strBuff.append("[Heartbeat Failed] ").append(response.getErrMsg()).toString());
                        strBuff.delete(0, strBuff.length());
                        if (response.getErrCode() == 411) {
                            ProducerManager.this.clientStatsInfo.bookHB2MasterTimeout();
                            try {
                                ProducerManager.this.register2Master();
                            }
                            catch (Throwable ee) {
                                logger.error(strBuff.append("[Heartbeat Failed] re-register failure, error is ").append(ee.getMessage()).toString());
                                strBuff.delete(0, strBuff.length());
                            }
                        } else {
                            ProducerManager.this.clientStatsInfo.bookHB2MasterException();
                            if (response.getErrCode() == 415) {
                                this.adjustHeartBeatPeriod("certificate failure", strBuff);
                            }
                        }
                    }
                    return;
                }
                ProducerManager.this.processHeartBeatSyncInfo(response, strBuff);
                ProducerManager.this.heartbeatRetryTimes = 0;
                long currentTime = System.currentTimeMillis();
                if (currentTime - ProducerManager.this.lastHeartbeatTime > ProducerManager.this.tubeClientConfig.getHeartbeatPeriodMs() * 4L) {
                    logger.warn(strBuff.append(ProducerManager.this.producerId).append(" heartbeat interval is too long, please check! Total time : ").append(currentTime - ProducerManager.this.lastHeartbeatTime).toString());
                    strBuff.delete(0, strBuff.length());
                }
                ProducerManager.this.lastHeartbeatTime = currentTime;
            }
            catch (Throwable e) {
                strBuff.delete(0, strBuff.length());
                if (e.getCause() == null || !(e.getCause() instanceof ClientClosedException)) {
                    logger.error("Heartbeat failed,retry later.Reason:{}", (Object)strBuff.append(e.getClass().getSimpleName()).append("#").append(e.getMessage()).toString());
                    strBuff.delete(0, strBuff.length());
                }
                this.adjustHeartBeatPeriod("heartbeat exception", strBuff);
            }
            finally {
                ProducerManager.this.heartBeatStatus.compareAndSet(1, 0);
            }
        }

        private void adjustHeartBeatPeriod(String reason, StringBuilder sBuilder) {
            ProducerManager.this.lastHeartbeatTime = System.currentTimeMillis();
            ProducerManager.this.heartbeatRetryTimes++;
            if (ProducerManager.this.nodeStatus.get() != 1 && ProducerManager.this.heartbeatRetryTimes > ProducerManager.this.tubeClientConfig.getMaxHeartBeatRetryTimes()) {
                logger.warn(sBuilder.append("Adjust HeartbeatPeriod for ").append(reason).append(", sleep ").append(ProducerManager.this.tubeClientConfig.getHeartbeatPeriodAfterFail()).append(" Ms").toString());
                sBuilder.delete(0, sBuilder.length());
                try {
                    Thread.sleep(ProducerManager.this.tubeClientConfig.getHeartbeatPeriodAfterFail());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

