// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package influxdb

import(
	"bytes"
	"context"
	"fmt"
	"time"
	"github.com/apache/thrift/lib/go/thrift"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = time.Now
var _ = bytes.Equal

// Attributes:
//  - IP
//  - Port
type EndPoint struct {
  IP string `thrift:"ip,1,required" db:"ip" json:"ip"`
  Port int32 `thrift:"port,2,required" db:"port" json:"port"`
}

func NewEndPoint() *EndPoint {
  return &EndPoint{}
}


func (p *EndPoint) GetIP() string {
  return p.IP
}

func (p *EndPoint) GetPort() int32 {
  return p.Port
}
func (p *EndPoint) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetIP bool = false;
  var issetPort bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetIP = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPort = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetIP{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IP is not set"));
  }
  if !issetPort{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Port is not set"));
  }
  return nil
}

func (p *EndPoint)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.IP = v
}
  return nil
}

func (p *EndPoint)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Port = v
}
  return nil
}

func (p *EndPoint) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "EndPoint"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *EndPoint) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "ip", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:ip: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.IP)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.ip (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:ip: ", p), err) }
  return err
}

func (p *EndPoint) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "port", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:port: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Port)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.port (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:port: ", p), err) }
  return err
}

func (p *EndPoint) Equals(other *EndPoint) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.IP != other.IP { return false }
  if p.Port != other.Port { return false }
  return true
}

func (p *EndPoint) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("EndPoint(%+v)", *p)
}

// Attributes:
//  - Code
//  - Message
//  - SubStatus
//  - RedirectNode
type TSStatus struct {
  Code int32 `thrift:"code,1,required" db:"code" json:"code"`
  Message *string `thrift:"message,2" db:"message" json:"message,omitempty"`
  SubStatus []*TSStatus `thrift:"subStatus,3" db:"subStatus" json:"subStatus,omitempty"`
  RedirectNode *EndPoint `thrift:"redirectNode,4" db:"redirectNode" json:"redirectNode,omitempty"`
}

func NewTSStatus() *TSStatus {
  return &TSStatus{}
}


func (p *TSStatus) GetCode() int32 {
  return p.Code
}
var TSStatus_Message_DEFAULT string
func (p *TSStatus) GetMessage() string {
  if !p.IsSetMessage() {
    return TSStatus_Message_DEFAULT
  }
return *p.Message
}
var TSStatus_SubStatus_DEFAULT []*TSStatus

func (p *TSStatus) GetSubStatus() []*TSStatus {
  return p.SubStatus
}
var TSStatus_RedirectNode_DEFAULT *EndPoint
func (p *TSStatus) GetRedirectNode() *EndPoint {
  if !p.IsSetRedirectNode() {
    return TSStatus_RedirectNode_DEFAULT
  }
return p.RedirectNode
}
func (p *TSStatus) IsSetMessage() bool {
  return p.Message != nil
}

func (p *TSStatus) IsSetSubStatus() bool {
  return p.SubStatus != nil
}

func (p *TSStatus) IsSetRedirectNode() bool {
  return p.RedirectNode != nil
}

func (p *TSStatus) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetCode bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetCode = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetCode{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Code is not set"));
  }
  return nil
}

func (p *TSStatus)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Code = v
}
  return nil
}

func (p *TSStatus)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Message = &v
}
  return nil
}

func (p *TSStatus)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]*TSStatus, 0, size)
  p.SubStatus =  tSlice
  for i := 0; i < size; i ++ {
    _elem0 := &TSStatus{}
    if err := _elem0.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem0), err)
    }
    p.SubStatus = append(p.SubStatus, _elem0)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSStatus)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  p.RedirectNode = &EndPoint{}
  if err := p.RedirectNode.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.RedirectNode), err)
  }
  return nil
}

func (p *TSStatus) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSStatus"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSStatus) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "code", thrift.I32, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:code: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Code)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.code (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:code: ", p), err) }
  return err
}

func (p *TSStatus) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMessage() {
    if err := oprot.WriteFieldBegin(ctx, "message", thrift.STRING, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:message: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Message)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.message (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:message: ", p), err) }
  }
  return err
}

func (p *TSStatus) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSubStatus() {
    if err := oprot.WriteFieldBegin(ctx, "subStatus", thrift.LIST, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:subStatus: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.SubStatus)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.SubStatus {
      if err := v.Write(ctx, oprot); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:subStatus: ", p), err) }
  }
  return err
}

func (p *TSStatus) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetRedirectNode() {
    if err := oprot.WriteFieldBegin(ctx, "redirectNode", thrift.STRUCT, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:redirectNode: ", p), err) }
    if err := p.RedirectNode.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.RedirectNode), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:redirectNode: ", p), err) }
  }
  return err
}

func (p *TSStatus) Equals(other *TSStatus) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Code != other.Code { return false }
  if p.Message != other.Message {
    if p.Message == nil || other.Message == nil {
      return false
    }
    if (*p.Message) != (*other.Message) { return false }
  }
  if len(p.SubStatus) != len(other.SubStatus) { return false }
  for i, _tgt := range p.SubStatus {
    _src1 := other.SubStatus[i]
    if !_tgt.Equals(_src1) { return false }
  }
  if !p.RedirectNode.Equals(other.RedirectNode) { return false }
  return true
}

func (p *TSStatus) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSStatus(%+v)", *p)
}

// Attributes:
//  - Status
//  - SessionId
//  - Configuration
type TSOpenSessionResp struct {
  Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  SessionId *int64 `thrift:"sessionId,2" db:"sessionId" json:"sessionId,omitempty"`
  Configuration map[string]string `thrift:"configuration,3" db:"configuration" json:"configuration,omitempty"`
}

func NewTSOpenSessionResp() *TSOpenSessionResp {
  return &TSOpenSessionResp{}
}

var TSOpenSessionResp_Status_DEFAULT *TSStatus
func (p *TSOpenSessionResp) GetStatus() *TSStatus {
  if !p.IsSetStatus() {
    return TSOpenSessionResp_Status_DEFAULT
  }
return p.Status
}
var TSOpenSessionResp_SessionId_DEFAULT int64
func (p *TSOpenSessionResp) GetSessionId() int64 {
  if !p.IsSetSessionId() {
    return TSOpenSessionResp_SessionId_DEFAULT
  }
return *p.SessionId
}
var TSOpenSessionResp_Configuration_DEFAULT map[string]string

func (p *TSOpenSessionResp) GetConfiguration() map[string]string {
  return p.Configuration
}
func (p *TSOpenSessionResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSOpenSessionResp) IsSetSessionId() bool {
  return p.SessionId != nil
}

func (p *TSOpenSessionResp) IsSetConfiguration() bool {
  return p.Configuration != nil
}

func (p *TSOpenSessionResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  return nil
}

func (p *TSOpenSessionResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSOpenSessionResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.SessionId = &v
}
  return nil
}

func (p *TSOpenSessionResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Configuration =  tMap
  for i := 0; i < size; i ++ {
var _key2 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key2 = v
}
var _val3 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val3 = v
}
    p.Configuration[_key2] = _val3
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSOpenSessionResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSOpenSessionResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSOpenSessionResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSOpenSessionResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSessionId() {
    if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:sessionId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.SessionId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.sessionId (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:sessionId: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetConfiguration() {
    if err := oprot.WriteFieldBegin(ctx, "configuration", thrift.MAP, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:configuration: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Configuration)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Configuration {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:configuration: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionResp) Equals(other *TSOpenSessionResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.SessionId != other.SessionId {
    if p.SessionId == nil || other.SessionId == nil {
      return false
    }
    if (*p.SessionId) != (*other.SessionId) { return false }
  }
  if len(p.Configuration) != len(other.Configuration) { return false }
  for k, _tgt := range p.Configuration {
    _src4 := other.Configuration[k]
    if _tgt != _src4 { return false }
  }
  return true
}

func (p *TSOpenSessionResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSOpenSessionResp(%+v)", *p)
}

// Attributes:
//  - ZoneId
//  - Username
//  - Password
//  - Configuration
type TSOpenSessionReq struct {
  // unused field # 1
  ZoneId string `thrift:"zoneId,2,required" db:"zoneId" json:"zoneId"`
  Username *string `thrift:"username,3" db:"username" json:"username,omitempty"`
  Password *string `thrift:"password,4" db:"password" json:"password,omitempty"`
  Configuration map[string]string `thrift:"configuration,5" db:"configuration" json:"configuration,omitempty"`
}

func NewTSOpenSessionReq() *TSOpenSessionReq {
  return &TSOpenSessionReq{}
}


func (p *TSOpenSessionReq) GetZoneId() string {
  return p.ZoneId
}
var TSOpenSessionReq_Username_DEFAULT string
func (p *TSOpenSessionReq) GetUsername() string {
  if !p.IsSetUsername() {
    return TSOpenSessionReq_Username_DEFAULT
  }
return *p.Username
}
var TSOpenSessionReq_Password_DEFAULT string
func (p *TSOpenSessionReq) GetPassword() string {
  if !p.IsSetPassword() {
    return TSOpenSessionReq_Password_DEFAULT
  }
return *p.Password
}
var TSOpenSessionReq_Configuration_DEFAULT map[string]string

func (p *TSOpenSessionReq) GetConfiguration() map[string]string {
  return p.Configuration
}
func (p *TSOpenSessionReq) IsSetUsername() bool {
  return p.Username != nil
}

func (p *TSOpenSessionReq) IsSetPassword() bool {
  return p.Password != nil
}

func (p *TSOpenSessionReq) IsSetConfiguration() bool {
  return p.Configuration != nil
}

func (p *TSOpenSessionReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetZoneId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetZoneId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetZoneId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ZoneId is not set"));
  }
  return nil
}

func (p *TSOpenSessionReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.ZoneId = v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Username = &v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Password = &v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Configuration =  tMap
  for i := 0; i < size; i ++ {
var _key5 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key5 = v
}
var _val6 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val6 = v
}
    p.Configuration[_key5] = _val6
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSOpenSessionReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSOpenSessionReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSOpenSessionReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "zoneId", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:zoneId: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ZoneId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.zoneId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:zoneId: ", p), err) }
  return err
}

func (p *TSOpenSessionReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetUsername() {
    if err := oprot.WriteFieldBegin(ctx, "username", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:username: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Username)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.username (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:username: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetPassword() {
    if err := oprot.WriteFieldBegin(ctx, "password", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:password: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Password)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.password (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:password: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetConfiguration() {
    if err := oprot.WriteFieldBegin(ctx, "configuration", thrift.MAP, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:configuration: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Configuration)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Configuration {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:configuration: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionReq) Equals(other *TSOpenSessionReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.ZoneId != other.ZoneId { return false }
  if p.Username != other.Username {
    if p.Username == nil || other.Username == nil {
      return false
    }
    if (*p.Username) != (*other.Username) { return false }
  }
  if p.Password != other.Password {
    if p.Password == nil || other.Password == nil {
      return false
    }
    if (*p.Password) != (*other.Password) { return false }
  }
  if len(p.Configuration) != len(other.Configuration) { return false }
  for k, _tgt := range p.Configuration {
    _src7 := other.Configuration[k]
    if _tgt != _src7 { return false }
  }
  return true
}

func (p *TSOpenSessionReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSOpenSessionReq(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSCloseSessionReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
}

func NewTSCloseSessionReq() *TSCloseSessionReq {
  return &TSCloseSessionReq{}
}


func (p *TSCloseSessionReq) GetSessionId() int64 {
  return p.SessionId
}
func (p *TSCloseSessionReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  return nil
}

func (p *TSCloseSessionReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCloseSessionReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCloseSessionReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCloseSessionReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCloseSessionReq) Equals(other *TSCloseSessionReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  return true
}

func (p *TSCloseSessionReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCloseSessionReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Database
//  - RetentionPolicy
//  - Precision
//  - Consistency
//  - LineProtocol
type TSWritePointsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Database string `thrift:"database,2,required" db:"database" json:"database"`
  RetentionPolicy *string `thrift:"retentionPolicy,3" db:"retentionPolicy" json:"retentionPolicy,omitempty"`
  Precision *string `thrift:"precision,4" db:"precision" json:"precision,omitempty"`
  Consistency *string `thrift:"consistency,5" db:"consistency" json:"consistency,omitempty"`
  LineProtocol *string `thrift:"lineProtocol,6" db:"lineProtocol" json:"lineProtocol,omitempty"`
}

func NewTSWritePointsReq() *TSWritePointsReq {
  return &TSWritePointsReq{}
}


func (p *TSWritePointsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSWritePointsReq) GetDatabase() string {
  return p.Database
}
var TSWritePointsReq_RetentionPolicy_DEFAULT string
func (p *TSWritePointsReq) GetRetentionPolicy() string {
  if !p.IsSetRetentionPolicy() {
    return TSWritePointsReq_RetentionPolicy_DEFAULT
  }
return *p.RetentionPolicy
}
var TSWritePointsReq_Precision_DEFAULT string
func (p *TSWritePointsReq) GetPrecision() string {
  if !p.IsSetPrecision() {
    return TSWritePointsReq_Precision_DEFAULT
  }
return *p.Precision
}
var TSWritePointsReq_Consistency_DEFAULT string
func (p *TSWritePointsReq) GetConsistency() string {
  if !p.IsSetConsistency() {
    return TSWritePointsReq_Consistency_DEFAULT
  }
return *p.Consistency
}
var TSWritePointsReq_LineProtocol_DEFAULT string
func (p *TSWritePointsReq) GetLineProtocol() string {
  if !p.IsSetLineProtocol() {
    return TSWritePointsReq_LineProtocol_DEFAULT
  }
return *p.LineProtocol
}
func (p *TSWritePointsReq) IsSetRetentionPolicy() bool {
  return p.RetentionPolicy != nil
}

func (p *TSWritePointsReq) IsSetPrecision() bool {
  return p.Precision != nil
}

func (p *TSWritePointsReq) IsSetConsistency() bool {
  return p.Consistency != nil
}

func (p *TSWritePointsReq) IsSetLineProtocol() bool {
  return p.LineProtocol != nil
}

func (p *TSWritePointsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetDatabase bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetDatabase = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetDatabase{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Database is not set"));
  }
  return nil
}

func (p *TSWritePointsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSWritePointsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Database = v
}
  return nil
}

func (p *TSWritePointsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.RetentionPolicy = &v
}
  return nil
}

func (p *TSWritePointsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Precision = &v
}
  return nil
}

func (p *TSWritePointsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Consistency = &v
}
  return nil
}

func (p *TSWritePointsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.LineProtocol = &v
}
  return nil
}

func (p *TSWritePointsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSWritePointsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSWritePointsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSWritePointsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "database", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:database: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Database)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.database (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:database: ", p), err) }
  return err
}

func (p *TSWritePointsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetRetentionPolicy() {
    if err := oprot.WriteFieldBegin(ctx, "retentionPolicy", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:retentionPolicy: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.RetentionPolicy)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.retentionPolicy (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:retentionPolicy: ", p), err) }
  }
  return err
}

func (p *TSWritePointsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetPrecision() {
    if err := oprot.WriteFieldBegin(ctx, "precision", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:precision: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Precision)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.precision (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:precision: ", p), err) }
  }
  return err
}

func (p *TSWritePointsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetConsistency() {
    if err := oprot.WriteFieldBegin(ctx, "consistency", thrift.STRING, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:consistency: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Consistency)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.consistency (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:consistency: ", p), err) }
  }
  return err
}

func (p *TSWritePointsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetLineProtocol() {
    if err := oprot.WriteFieldBegin(ctx, "lineProtocol", thrift.STRING, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:lineProtocol: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.LineProtocol)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.lineProtocol (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:lineProtocol: ", p), err) }
  }
  return err
}

func (p *TSWritePointsReq) Equals(other *TSWritePointsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Database != other.Database { return false }
  if p.RetentionPolicy != other.RetentionPolicy {
    if p.RetentionPolicy == nil || other.RetentionPolicy == nil {
      return false
    }
    if (*p.RetentionPolicy) != (*other.RetentionPolicy) { return false }
  }
  if p.Precision != other.Precision {
    if p.Precision == nil || other.Precision == nil {
      return false
    }
    if (*p.Precision) != (*other.Precision) { return false }
  }
  if p.Consistency != other.Consistency {
    if p.Consistency == nil || other.Consistency == nil {
      return false
    }
    if (*p.Consistency) != (*other.Consistency) { return false }
  }
  if p.LineProtocol != other.LineProtocol {
    if p.LineProtocol == nil || other.LineProtocol == nil {
      return false
    }
    if (*p.LineProtocol) != (*other.LineProtocol) { return false }
  }
  return true
}

func (p *TSWritePointsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSWritePointsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Database
type TSCreateDatabaseReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Database string `thrift:"database,2,required" db:"database" json:"database"`
}

func NewTSCreateDatabaseReq() *TSCreateDatabaseReq {
  return &TSCreateDatabaseReq{}
}


func (p *TSCreateDatabaseReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateDatabaseReq) GetDatabase() string {
  return p.Database
}
func (p *TSCreateDatabaseReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetDatabase bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetDatabase = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetDatabase{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Database is not set"));
  }
  return nil
}

func (p *TSCreateDatabaseReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateDatabaseReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Database = v
}
  return nil
}

func (p *TSCreateDatabaseReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateDatabaseReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateDatabaseReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateDatabaseReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "database", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:database: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Database)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.database (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:database: ", p), err) }
  return err
}

func (p *TSCreateDatabaseReq) Equals(other *TSCreateDatabaseReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Database != other.Database { return false }
  return true
}

func (p *TSCreateDatabaseReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateDatabaseReq(%+v)", *p)
}

type InfluxDBService interface {
  // Parameters:
  //  - Req
  OpenSession(ctx context.Context, req *TSOpenSessionReq) (_r *TSOpenSessionResp, _err error)
  // Parameters:
  //  - Req
  CloseSession(ctx context.Context, req *TSCloseSessionReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  WritePoints(ctx context.Context, req *TSWritePointsReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  CreateDatabase(ctx context.Context, req *TSCreateDatabaseReq) (_r *TSStatus, _err error)
}

type InfluxDBServiceClient struct {
  c thrift.TClient
  meta thrift.ResponseMeta
}

func NewInfluxDBServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *InfluxDBServiceClient {
  return &InfluxDBServiceClient{
    c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
  }
}

func NewInfluxDBServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *InfluxDBServiceClient {
  return &InfluxDBServiceClient{
    c: thrift.NewTStandardClient(iprot, oprot),
  }
}

func NewInfluxDBServiceClient(c thrift.TClient) *InfluxDBServiceClient {
  return &InfluxDBServiceClient{
    c: c,
  }
}

func (p *InfluxDBServiceClient) Client_() thrift.TClient {
  return p.c
}

func (p *InfluxDBServiceClient) LastResponseMeta_() thrift.ResponseMeta {
  return p.meta
}

func (p *InfluxDBServiceClient) SetLastResponseMeta_(meta thrift.ResponseMeta) {
  p.meta = meta
}

// Parameters:
//  - Req
func (p *InfluxDBServiceClient) OpenSession(ctx context.Context, req *TSOpenSessionReq) (_r *TSOpenSessionResp, _err error) {
  var _args8 InfluxDBServiceOpenSessionArgs
  _args8.Req = req
  var _result10 InfluxDBServiceOpenSessionResult
  var _meta9 thrift.ResponseMeta
  _meta9, _err = p.Client_().Call(ctx, "openSession", &_args8, &_result10)
  p.SetLastResponseMeta_(_meta9)
  if _err != nil {
    return
  }
  return _result10.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *InfluxDBServiceClient) CloseSession(ctx context.Context, req *TSCloseSessionReq) (_r *TSStatus, _err error) {
  var _args11 InfluxDBServiceCloseSessionArgs
  _args11.Req = req
  var _result13 InfluxDBServiceCloseSessionResult
  var _meta12 thrift.ResponseMeta
  _meta12, _err = p.Client_().Call(ctx, "closeSession", &_args11, &_result13)
  p.SetLastResponseMeta_(_meta12)
  if _err != nil {
    return
  }
  return _result13.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *InfluxDBServiceClient) WritePoints(ctx context.Context, req *TSWritePointsReq) (_r *TSStatus, _err error) {
  var _args14 InfluxDBServiceWritePointsArgs
  _args14.Req = req
  var _result16 InfluxDBServiceWritePointsResult
  var _meta15 thrift.ResponseMeta
  _meta15, _err = p.Client_().Call(ctx, "writePoints", &_args14, &_result16)
  p.SetLastResponseMeta_(_meta15)
  if _err != nil {
    return
  }
  return _result16.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *InfluxDBServiceClient) CreateDatabase(ctx context.Context, req *TSCreateDatabaseReq) (_r *TSStatus, _err error) {
  var _args17 InfluxDBServiceCreateDatabaseArgs
  _args17.Req = req
  var _result19 InfluxDBServiceCreateDatabaseResult
  var _meta18 thrift.ResponseMeta
  _meta18, _err = p.Client_().Call(ctx, "createDatabase", &_args17, &_result19)
  p.SetLastResponseMeta_(_meta18)
  if _err != nil {
    return
  }
  return _result19.GetSuccess(), nil
}

type InfluxDBServiceProcessor struct {
  processorMap map[string]thrift.TProcessorFunction
  handler InfluxDBService
}

func (p *InfluxDBServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
  p.processorMap[key] = processor
}

func (p *InfluxDBServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
  processor, ok = p.processorMap[key]
  return processor, ok
}

func (p *InfluxDBServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
  return p.processorMap
}

func NewInfluxDBServiceProcessor(handler InfluxDBService) *InfluxDBServiceProcessor {

  self20 := &InfluxDBServiceProcessor{handler:handler, processorMap:make(map[string]thrift.TProcessorFunction)}
  self20.processorMap["openSession"] = &influxDBServiceProcessorOpenSession{handler:handler}
  self20.processorMap["closeSession"] = &influxDBServiceProcessorCloseSession{handler:handler}
  self20.processorMap["writePoints"] = &influxDBServiceProcessorWritePoints{handler:handler}
  self20.processorMap["createDatabase"] = &influxDBServiceProcessorCreateDatabase{handler:handler}
return self20
}

func (p *InfluxDBServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  name, _, seqId, err2 := iprot.ReadMessageBegin(ctx)
  if err2 != nil { return false, thrift.WrapTException(err2) }
  if processor, ok := p.GetProcessorFunction(name); ok {
    return processor.Process(ctx, seqId, iprot, oprot)
  }
  iprot.Skip(ctx, thrift.STRUCT)
  iprot.ReadMessageEnd(ctx)
  x21 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function " + name)
  oprot.WriteMessageBegin(ctx, name, thrift.EXCEPTION, seqId)
  x21.Write(ctx, oprot)
  oprot.WriteMessageEnd(ctx)
  oprot.Flush(ctx)
  return false, x21

}

type influxDBServiceProcessorOpenSession struct {
  handler InfluxDBService
}

func (p *influxDBServiceProcessorOpenSession) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := InfluxDBServiceOpenSessionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "openSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := InfluxDBServiceOpenSessionResult{}
  var retval *TSOpenSessionResp
  if retval, err2 = p.handler.OpenSession(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing openSession: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "openSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "openSession", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type influxDBServiceProcessorCloseSession struct {
  handler InfluxDBService
}

func (p *influxDBServiceProcessorCloseSession) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := InfluxDBServiceCloseSessionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "closeSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := InfluxDBServiceCloseSessionResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CloseSession(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing closeSession: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "closeSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "closeSession", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type influxDBServiceProcessorWritePoints struct {
  handler InfluxDBService
}

func (p *influxDBServiceProcessorWritePoints) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := InfluxDBServiceWritePointsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "writePoints", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := InfluxDBServiceWritePointsResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.WritePoints(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing writePoints: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "writePoints", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "writePoints", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type influxDBServiceProcessorCreateDatabase struct {
  handler InfluxDBService
}

func (p *influxDBServiceProcessorCreateDatabase) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := InfluxDBServiceCreateDatabaseArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createDatabase", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := InfluxDBServiceCreateDatabaseResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CreateDatabase(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createDatabase: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createDatabase", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createDatabase", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Req
type InfluxDBServiceOpenSessionArgs struct {
  Req *TSOpenSessionReq `thrift:"req,1" db:"req" json:"req"`
}

func NewInfluxDBServiceOpenSessionArgs() *InfluxDBServiceOpenSessionArgs {
  return &InfluxDBServiceOpenSessionArgs{}
}

var InfluxDBServiceOpenSessionArgs_Req_DEFAULT *TSOpenSessionReq
func (p *InfluxDBServiceOpenSessionArgs) GetReq() *TSOpenSessionReq {
  if !p.IsSetReq() {
    return InfluxDBServiceOpenSessionArgs_Req_DEFAULT
  }
return p.Req
}
func (p *InfluxDBServiceOpenSessionArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *InfluxDBServiceOpenSessionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *InfluxDBServiceOpenSessionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSOpenSessionReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *InfluxDBServiceOpenSessionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "openSession_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *InfluxDBServiceOpenSessionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *InfluxDBServiceOpenSessionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("InfluxDBServiceOpenSessionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type InfluxDBServiceOpenSessionResult struct {
  Success *TSOpenSessionResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewInfluxDBServiceOpenSessionResult() *InfluxDBServiceOpenSessionResult {
  return &InfluxDBServiceOpenSessionResult{}
}

var InfluxDBServiceOpenSessionResult_Success_DEFAULT *TSOpenSessionResp
func (p *InfluxDBServiceOpenSessionResult) GetSuccess() *TSOpenSessionResp {
  if !p.IsSetSuccess() {
    return InfluxDBServiceOpenSessionResult_Success_DEFAULT
  }
return p.Success
}
func (p *InfluxDBServiceOpenSessionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *InfluxDBServiceOpenSessionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *InfluxDBServiceOpenSessionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSOpenSessionResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *InfluxDBServiceOpenSessionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "openSession_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *InfluxDBServiceOpenSessionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *InfluxDBServiceOpenSessionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("InfluxDBServiceOpenSessionResult(%+v)", *p)
}

// Attributes:
//  - Req
type InfluxDBServiceCloseSessionArgs struct {
  Req *TSCloseSessionReq `thrift:"req,1" db:"req" json:"req"`
}

func NewInfluxDBServiceCloseSessionArgs() *InfluxDBServiceCloseSessionArgs {
  return &InfluxDBServiceCloseSessionArgs{}
}

var InfluxDBServiceCloseSessionArgs_Req_DEFAULT *TSCloseSessionReq
func (p *InfluxDBServiceCloseSessionArgs) GetReq() *TSCloseSessionReq {
  if !p.IsSetReq() {
    return InfluxDBServiceCloseSessionArgs_Req_DEFAULT
  }
return p.Req
}
func (p *InfluxDBServiceCloseSessionArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *InfluxDBServiceCloseSessionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *InfluxDBServiceCloseSessionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCloseSessionReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *InfluxDBServiceCloseSessionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeSession_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *InfluxDBServiceCloseSessionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *InfluxDBServiceCloseSessionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("InfluxDBServiceCloseSessionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type InfluxDBServiceCloseSessionResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewInfluxDBServiceCloseSessionResult() *InfluxDBServiceCloseSessionResult {
  return &InfluxDBServiceCloseSessionResult{}
}

var InfluxDBServiceCloseSessionResult_Success_DEFAULT *TSStatus
func (p *InfluxDBServiceCloseSessionResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return InfluxDBServiceCloseSessionResult_Success_DEFAULT
  }
return p.Success
}
func (p *InfluxDBServiceCloseSessionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *InfluxDBServiceCloseSessionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *InfluxDBServiceCloseSessionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *InfluxDBServiceCloseSessionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeSession_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *InfluxDBServiceCloseSessionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *InfluxDBServiceCloseSessionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("InfluxDBServiceCloseSessionResult(%+v)", *p)
}

// Attributes:
//  - Req
type InfluxDBServiceWritePointsArgs struct {
  Req *TSWritePointsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewInfluxDBServiceWritePointsArgs() *InfluxDBServiceWritePointsArgs {
  return &InfluxDBServiceWritePointsArgs{}
}

var InfluxDBServiceWritePointsArgs_Req_DEFAULT *TSWritePointsReq
func (p *InfluxDBServiceWritePointsArgs) GetReq() *TSWritePointsReq {
  if !p.IsSetReq() {
    return InfluxDBServiceWritePointsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *InfluxDBServiceWritePointsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *InfluxDBServiceWritePointsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *InfluxDBServiceWritePointsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSWritePointsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *InfluxDBServiceWritePointsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "writePoints_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *InfluxDBServiceWritePointsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *InfluxDBServiceWritePointsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("InfluxDBServiceWritePointsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type InfluxDBServiceWritePointsResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewInfluxDBServiceWritePointsResult() *InfluxDBServiceWritePointsResult {
  return &InfluxDBServiceWritePointsResult{}
}

var InfluxDBServiceWritePointsResult_Success_DEFAULT *TSStatus
func (p *InfluxDBServiceWritePointsResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return InfluxDBServiceWritePointsResult_Success_DEFAULT
  }
return p.Success
}
func (p *InfluxDBServiceWritePointsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *InfluxDBServiceWritePointsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *InfluxDBServiceWritePointsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *InfluxDBServiceWritePointsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "writePoints_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *InfluxDBServiceWritePointsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *InfluxDBServiceWritePointsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("InfluxDBServiceWritePointsResult(%+v)", *p)
}

// Attributes:
//  - Req
type InfluxDBServiceCreateDatabaseArgs struct {
  Req *TSCreateDatabaseReq `thrift:"req,1" db:"req" json:"req"`
}

func NewInfluxDBServiceCreateDatabaseArgs() *InfluxDBServiceCreateDatabaseArgs {
  return &InfluxDBServiceCreateDatabaseArgs{}
}

var InfluxDBServiceCreateDatabaseArgs_Req_DEFAULT *TSCreateDatabaseReq
func (p *InfluxDBServiceCreateDatabaseArgs) GetReq() *TSCreateDatabaseReq {
  if !p.IsSetReq() {
    return InfluxDBServiceCreateDatabaseArgs_Req_DEFAULT
  }
return p.Req
}
func (p *InfluxDBServiceCreateDatabaseArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *InfluxDBServiceCreateDatabaseArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *InfluxDBServiceCreateDatabaseArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCreateDatabaseReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *InfluxDBServiceCreateDatabaseArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createDatabase_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *InfluxDBServiceCreateDatabaseArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *InfluxDBServiceCreateDatabaseArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("InfluxDBServiceCreateDatabaseArgs(%+v)", *p)
}

// Attributes:
//  - Success
type InfluxDBServiceCreateDatabaseResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewInfluxDBServiceCreateDatabaseResult() *InfluxDBServiceCreateDatabaseResult {
  return &InfluxDBServiceCreateDatabaseResult{}
}

var InfluxDBServiceCreateDatabaseResult_Success_DEFAULT *TSStatus
func (p *InfluxDBServiceCreateDatabaseResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return InfluxDBServiceCreateDatabaseResult_Success_DEFAULT
  }
return p.Success
}
func (p *InfluxDBServiceCreateDatabaseResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *InfluxDBServiceCreateDatabaseResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *InfluxDBServiceCreateDatabaseResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *InfluxDBServiceCreateDatabaseResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createDatabase_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *InfluxDBServiceCreateDatabaseResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *InfluxDBServiceCreateDatabaseResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("InfluxDBServiceCreateDatabaseResult(%+v)", *p)
}


