/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.iotdb.isession.ISessionDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class SubscriptionSessionDataSet
implements ISessionDataSet {
    private Tablet tablet;
    private List<String> columnNameList;
    private List<String> columnTypeList;
    private Iterator<Map.Entry<Long, Integer>> rowIterator;

    public Tablet getTablet() {
        return this.tablet;
    }

    public SubscriptionSessionDataSet(Tablet tablet) {
        this.tablet = tablet;
        this.generateRowIterator();
    }

    public List<String> getColumnNames() {
        if (Objects.nonNull(this.columnNameList)) {
            return this.columnNameList;
        }
        this.columnNameList = new ArrayList<String>();
        this.columnNameList.add("Time");
        String deviceId = this.tablet.deviceId;
        List schemas = this.tablet.getSchemas();
        this.columnNameList.addAll(schemas.stream().map(schema -> deviceId + "." + schema.getMeasurementId()).collect(Collectors.toList()));
        return this.columnNameList;
    }

    public List<String> getColumnTypes() {
        if (Objects.nonNull(this.columnTypeList)) {
            return this.columnTypeList;
        }
        this.columnTypeList = new ArrayList<String>();
        this.columnTypeList.add(TSDataType.INT64.toString());
        List schemas = this.tablet.getSchemas();
        this.columnTypeList.addAll(schemas.stream().map(schema -> schema.getType().toString()).collect(Collectors.toList()));
        return this.columnTypeList;
    }

    public boolean hasNext() {
        return this.rowIterator.hasNext();
    }

    public RowRecord next() {
        Map.Entry<Long, Integer> entry = this.rowIterator.next();
        int columnSize = this.getColumnSize();
        ArrayList<Field> fields = new ArrayList<Field>();
        long timestamp = entry.getKey();
        int rowIndex = entry.getValue();
        for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            Field field;
            if (this.tablet.bitMaps[columnIndex].isMarked(rowIndex)) {
                field = new Field(null);
            } else {
                TSDataType dataType = ((MeasurementSchema)this.tablet.getSchemas().get(columnIndex)).getType();
                field = SubscriptionSessionDataSet.generateFieldFromTabletValue(dataType, this.tablet.values[columnIndex], rowIndex);
            }
            fields.add(field);
        }
        return new RowRecord(timestamp, fields);
    }

    public void close() throws Exception {
        this.tablet = null;
    }

    private int getColumnSize() {
        return this.tablet.getSchemas().size();
    }

    private void generateRowIterator() {
        long[] timestamps = this.tablet.timestamps;
        TreeMap<Long, Integer> timestampToRowIndex = new TreeMap<Long, Integer>();
        int rowSize = timestamps.length;
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            Long timestamp = timestamps[rowIndex];
            timestampToRowIndex.put(timestamp, rowIndex);
        }
        this.rowIterator = timestampToRowIndex.entrySet().iterator();
    }

    private static Field generateFieldFromTabletValue(TSDataType dataType, Object value, int index) {
        Field field = new Field(dataType);
        switch (dataType) {
            case BOOLEAN: {
                boolean booleanValue = ((boolean[])value)[index];
                field.setBoolV(booleanValue);
                break;
            }
            case INT32: {
                int intValue = ((int[])value)[index];
                field.setIntV(intValue);
                break;
            }
            case INT64: {
                long longValue = ((long[])value)[index];
                field.setLongV(longValue);
                break;
            }
            case FLOAT: {
                float floatValue = ((float[])value)[index];
                field.setFloatV(floatValue);
                break;
            }
            case DOUBLE: {
                double doubleValue = ((double[])value)[index];
                field.setDoubleV(doubleValue);
                break;
            }
            case TEXT: {
                Binary binaryValue = new Binary(((Binary[])value)[index].getValues());
                field.setBinaryV(binaryValue);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
            }
        }
        return field;
    }
}

