// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package rpc

import(
	"bytes"
	"context"
	"database/sql/driver"
	"errors"
	"fmt"
	"time"
	"github.com/apache/thrift/lib/go/thrift"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = time.Now
var _ = bytes.Equal

type TSProtocolVersion int64
const (
  TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1 TSProtocolVersion = 0
  TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2 TSProtocolVersion = 1
  TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3 TSProtocolVersion = 2
)

func (p TSProtocolVersion) String() string {
  switch p {
  case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1: return "IOTDB_SERVICE_PROTOCOL_V1"
  case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2: return "IOTDB_SERVICE_PROTOCOL_V2"
  case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3: return "IOTDB_SERVICE_PROTOCOL_V3"
  }
  return "<UNSET>"
}

func TSProtocolVersionFromString(s string) (TSProtocolVersion, error) {
  switch s {
  case "IOTDB_SERVICE_PROTOCOL_V1": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1, nil 
  case "IOTDB_SERVICE_PROTOCOL_V2": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2, nil 
  case "IOTDB_SERVICE_PROTOCOL_V3": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3, nil 
  }
  return TSProtocolVersion(0), fmt.Errorf("not a valid TSProtocolVersion string")
}


func TSProtocolVersionPtr(v TSProtocolVersion) *TSProtocolVersion { return &v }

func (p TSProtocolVersion) MarshalText() ([]byte, error) {
return []byte(p.String()), nil
}

func (p *TSProtocolVersion) UnmarshalText(text []byte) error {
q, err := TSProtocolVersionFromString(string(text))
if (err != nil) {
return err
}
*p = q
return nil
}

func (p *TSProtocolVersion) Scan(value interface{}) error {
v, ok := value.(int64)
if !ok {
return errors.New("Scan value is not int64")
}
*p = TSProtocolVersion(v)
return nil
}

func (p * TSProtocolVersion) Value() (driver.Value, error) {
  if p == nil {
    return nil, nil
  }
return int64(*p), nil
}
// Attributes:
//  - IP
//  - Port
type EndPoint struct {
  IP string `thrift:"ip,1,required" db:"ip" json:"ip"`
  Port int32 `thrift:"port,2,required" db:"port" json:"port"`
}

func NewEndPoint() *EndPoint {
  return &EndPoint{}
}


func (p *EndPoint) GetIP() string {
  return p.IP
}

func (p *EndPoint) GetPort() int32 {
  return p.Port
}
func (p *EndPoint) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetIP bool = false;
  var issetPort bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetIP = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPort = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetIP{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IP is not set"));
  }
  if !issetPort{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Port is not set"));
  }
  return nil
}

func (p *EndPoint)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.IP = v
}
  return nil
}

func (p *EndPoint)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Port = v
}
  return nil
}

func (p *EndPoint) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "EndPoint"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *EndPoint) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "ip", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:ip: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.IP)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.ip (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:ip: ", p), err) }
  return err
}

func (p *EndPoint) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "port", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:port: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Port)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.port (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:port: ", p), err) }
  return err
}

func (p *EndPoint) Equals(other *EndPoint) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.IP != other.IP { return false }
  if p.Port != other.Port { return false }
  return true
}

func (p *EndPoint) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("EndPoint(%+v)", *p)
}

// Attributes:
//  - Code
//  - Message
//  - SubStatus
//  - RedirectNode
type TSStatus struct {
  Code int32 `thrift:"code,1,required" db:"code" json:"code"`
  Message *string `thrift:"message,2" db:"message" json:"message,omitempty"`
  SubStatus []*TSStatus `thrift:"subStatus,3" db:"subStatus" json:"subStatus,omitempty"`
  RedirectNode *EndPoint `thrift:"redirectNode,4" db:"redirectNode" json:"redirectNode,omitempty"`
}

func NewTSStatus() *TSStatus {
  return &TSStatus{}
}


func (p *TSStatus) GetCode() int32 {
  return p.Code
}
var TSStatus_Message_DEFAULT string
func (p *TSStatus) GetMessage() string {
  if !p.IsSetMessage() {
    return TSStatus_Message_DEFAULT
  }
return *p.Message
}
var TSStatus_SubStatus_DEFAULT []*TSStatus

func (p *TSStatus) GetSubStatus() []*TSStatus {
  return p.SubStatus
}
var TSStatus_RedirectNode_DEFAULT *EndPoint
func (p *TSStatus) GetRedirectNode() *EndPoint {
  if !p.IsSetRedirectNode() {
    return TSStatus_RedirectNode_DEFAULT
  }
return p.RedirectNode
}
func (p *TSStatus) IsSetMessage() bool {
  return p.Message != nil
}

func (p *TSStatus) IsSetSubStatus() bool {
  return p.SubStatus != nil
}

func (p *TSStatus) IsSetRedirectNode() bool {
  return p.RedirectNode != nil
}

func (p *TSStatus) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetCode bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetCode = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetCode{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Code is not set"));
  }
  return nil
}

func (p *TSStatus)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Code = v
}
  return nil
}

func (p *TSStatus)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Message = &v
}
  return nil
}

func (p *TSStatus)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]*TSStatus, 0, size)
  p.SubStatus =  tSlice
  for i := 0; i < size; i ++ {
    _elem0 := &TSStatus{}
    if err := _elem0.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem0), err)
    }
    p.SubStatus = append(p.SubStatus, _elem0)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSStatus)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  p.RedirectNode = &EndPoint{}
  if err := p.RedirectNode.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.RedirectNode), err)
  }
  return nil
}

func (p *TSStatus) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSStatus"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSStatus) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "code", thrift.I32, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:code: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Code)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.code (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:code: ", p), err) }
  return err
}

func (p *TSStatus) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMessage() {
    if err := oprot.WriteFieldBegin(ctx, "message", thrift.STRING, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:message: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Message)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.message (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:message: ", p), err) }
  }
  return err
}

func (p *TSStatus) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSubStatus() {
    if err := oprot.WriteFieldBegin(ctx, "subStatus", thrift.LIST, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:subStatus: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.SubStatus)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.SubStatus {
      if err := v.Write(ctx, oprot); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:subStatus: ", p), err) }
  }
  return err
}

func (p *TSStatus) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetRedirectNode() {
    if err := oprot.WriteFieldBegin(ctx, "redirectNode", thrift.STRUCT, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:redirectNode: ", p), err) }
    if err := p.RedirectNode.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.RedirectNode), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:redirectNode: ", p), err) }
  }
  return err
}

func (p *TSStatus) Equals(other *TSStatus) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Code != other.Code { return false }
  if p.Message != other.Message {
    if p.Message == nil || other.Message == nil {
      return false
    }
    if (*p.Message) != (*other.Message) { return false }
  }
  if len(p.SubStatus) != len(other.SubStatus) { return false }
  for i, _tgt := range p.SubStatus {
    _src1 := other.SubStatus[i]
    if !_tgt.Equals(_src1) { return false }
  }
  if !p.RedirectNode.Equals(other.RedirectNode) { return false }
  return true
}

func (p *TSStatus) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSStatus(%+v)", *p)
}

// Attributes:
//  - Time
//  - ValueList
//  - BitmapList
type TSQueryDataSet struct {
  Time []byte `thrift:"time,1,required" db:"time" json:"time"`
  ValueList [][]byte `thrift:"valueList,2,required" db:"valueList" json:"valueList"`
  BitmapList [][]byte `thrift:"bitmapList,3,required" db:"bitmapList" json:"bitmapList"`
}

func NewTSQueryDataSet() *TSQueryDataSet {
  return &TSQueryDataSet{}
}


func (p *TSQueryDataSet) GetTime() []byte {
  return p.Time
}

func (p *TSQueryDataSet) GetValueList() [][]byte {
  return p.ValueList
}

func (p *TSQueryDataSet) GetBitmapList() [][]byte {
  return p.BitmapList
}
func (p *TSQueryDataSet) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTime bool = false;
  var issetValueList bool = false;
  var issetBitmapList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetValueList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetBitmapList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Time is not set"));
  }
  if !issetValueList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValueList is not set"));
  }
  if !issetBitmapList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field BitmapList is not set"));
  }
  return nil
}

func (p *TSQueryDataSet)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Time = v
}
  return nil
}

func (p *TSQueryDataSet)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValueList =  tSlice
  for i := 0; i < size; i ++ {
var _elem2 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem2 = v
}
    p.ValueList = append(p.ValueList, _elem2)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryDataSet)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.BitmapList =  tSlice
  for i := 0; i < size; i ++ {
var _elem3 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem3 = v
}
    p.BitmapList = append(p.BitmapList, _elem3)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryDataSet) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSQueryDataSet"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSQueryDataSet) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "time", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:time: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Time); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.time (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:time: ", p), err) }
  return err
}

func (p *TSQueryDataSet) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valueList", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:valueList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValueList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValueList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:valueList: ", p), err) }
  return err
}

func (p *TSQueryDataSet) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "bitmapList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:bitmapList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.BitmapList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.BitmapList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:bitmapList: ", p), err) }
  return err
}

func (p *TSQueryDataSet) Equals(other *TSQueryDataSet) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if bytes.Compare(p.Time, other.Time) != 0 { return false }
  if len(p.ValueList) != len(other.ValueList) { return false }
  for i, _tgt := range p.ValueList {
    _src4 := other.ValueList[i]
    if bytes.Compare(_tgt, _src4) != 0 { return false }
  }
  if len(p.BitmapList) != len(other.BitmapList) { return false }
  for i, _tgt := range p.BitmapList {
    _src5 := other.BitmapList[i]
    if bytes.Compare(_tgt, _src5) != 0 { return false }
  }
  return true
}

func (p *TSQueryDataSet) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSQueryDataSet(%+v)", *p)
}

// Attributes:
//  - TimeList
//  - ValueList
type TSQueryNonAlignDataSet struct {
  TimeList [][]byte `thrift:"timeList,1,required" db:"timeList" json:"timeList"`
  ValueList [][]byte `thrift:"valueList,2,required" db:"valueList" json:"valueList"`
}

func NewTSQueryNonAlignDataSet() *TSQueryNonAlignDataSet {
  return &TSQueryNonAlignDataSet{}
}


func (p *TSQueryNonAlignDataSet) GetTimeList() [][]byte {
  return p.TimeList
}

func (p *TSQueryNonAlignDataSet) GetValueList() [][]byte {
  return p.ValueList
}
func (p *TSQueryNonAlignDataSet) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTimeList bool = false;
  var issetValueList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTimeList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetValueList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTimeList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeList is not set"));
  }
  if !issetValueList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValueList is not set"));
  }
  return nil
}

func (p *TSQueryNonAlignDataSet)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.TimeList =  tSlice
  for i := 0; i < size; i ++ {
var _elem6 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem6 = v
}
    p.TimeList = append(p.TimeList, _elem6)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryNonAlignDataSet)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValueList =  tSlice
  for i := 0; i < size; i ++ {
var _elem7 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem7 = v
}
    p.ValueList = append(p.ValueList, _elem7)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryNonAlignDataSet) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSQueryNonAlignDataSet"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSQueryNonAlignDataSet) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timeList", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:timeList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.TimeList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.TimeList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:timeList: ", p), err) }
  return err
}

func (p *TSQueryNonAlignDataSet) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valueList", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:valueList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValueList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValueList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:valueList: ", p), err) }
  return err
}

func (p *TSQueryNonAlignDataSet) Equals(other *TSQueryNonAlignDataSet) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.TimeList) != len(other.TimeList) { return false }
  for i, _tgt := range p.TimeList {
    _src8 := other.TimeList[i]
    if bytes.Compare(_tgt, _src8) != 0 { return false }
  }
  if len(p.ValueList) != len(other.ValueList) { return false }
  for i, _tgt := range p.ValueList {
    _src9 := other.ValueList[i]
    if bytes.Compare(_tgt, _src9) != 0 { return false }
  }
  return true
}

func (p *TSQueryNonAlignDataSet) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSQueryNonAlignDataSet(%+v)", *p)
}

// Attributes:
//  - ActivityList
//  - ElapsedTimeList
//  - SeriesPathNum
//  - SeqFileNum
//  - UnSeqFileNum
//  - SequenceChunkNum
//  - SequenceChunkPointNum
//  - UnsequenceChunkNum
//  - UnsequenceChunkPointNum
//  - TotalPageNum
//  - OverlappedPageNum
type TSTracingInfo struct {
  ActivityList []string `thrift:"activityList,1,required" db:"activityList" json:"activityList"`
  ElapsedTimeList []int64 `thrift:"elapsedTimeList,2,required" db:"elapsedTimeList" json:"elapsedTimeList"`
  SeriesPathNum *int32 `thrift:"seriesPathNum,3" db:"seriesPathNum" json:"seriesPathNum,omitempty"`
  SeqFileNum *int32 `thrift:"seqFileNum,4" db:"seqFileNum" json:"seqFileNum,omitempty"`
  UnSeqFileNum *int32 `thrift:"unSeqFileNum,5" db:"unSeqFileNum" json:"unSeqFileNum,omitempty"`
  SequenceChunkNum *int32 `thrift:"sequenceChunkNum,6" db:"sequenceChunkNum" json:"sequenceChunkNum,omitempty"`
  SequenceChunkPointNum *int64 `thrift:"sequenceChunkPointNum,7" db:"sequenceChunkPointNum" json:"sequenceChunkPointNum,omitempty"`
  UnsequenceChunkNum *int32 `thrift:"unsequenceChunkNum,8" db:"unsequenceChunkNum" json:"unsequenceChunkNum,omitempty"`
  UnsequenceChunkPointNum *int64 `thrift:"unsequenceChunkPointNum,9" db:"unsequenceChunkPointNum" json:"unsequenceChunkPointNum,omitempty"`
  TotalPageNum *int32 `thrift:"totalPageNum,10" db:"totalPageNum" json:"totalPageNum,omitempty"`
  OverlappedPageNum *int32 `thrift:"overlappedPageNum,11" db:"overlappedPageNum" json:"overlappedPageNum,omitempty"`
}

func NewTSTracingInfo() *TSTracingInfo {
  return &TSTracingInfo{}
}


func (p *TSTracingInfo) GetActivityList() []string {
  return p.ActivityList
}

func (p *TSTracingInfo) GetElapsedTimeList() []int64 {
  return p.ElapsedTimeList
}
var TSTracingInfo_SeriesPathNum_DEFAULT int32
func (p *TSTracingInfo) GetSeriesPathNum() int32 {
  if !p.IsSetSeriesPathNum() {
    return TSTracingInfo_SeriesPathNum_DEFAULT
  }
return *p.SeriesPathNum
}
var TSTracingInfo_SeqFileNum_DEFAULT int32
func (p *TSTracingInfo) GetSeqFileNum() int32 {
  if !p.IsSetSeqFileNum() {
    return TSTracingInfo_SeqFileNum_DEFAULT
  }
return *p.SeqFileNum
}
var TSTracingInfo_UnSeqFileNum_DEFAULT int32
func (p *TSTracingInfo) GetUnSeqFileNum() int32 {
  if !p.IsSetUnSeqFileNum() {
    return TSTracingInfo_UnSeqFileNum_DEFAULT
  }
return *p.UnSeqFileNum
}
var TSTracingInfo_SequenceChunkNum_DEFAULT int32
func (p *TSTracingInfo) GetSequenceChunkNum() int32 {
  if !p.IsSetSequenceChunkNum() {
    return TSTracingInfo_SequenceChunkNum_DEFAULT
  }
return *p.SequenceChunkNum
}
var TSTracingInfo_SequenceChunkPointNum_DEFAULT int64
func (p *TSTracingInfo) GetSequenceChunkPointNum() int64 {
  if !p.IsSetSequenceChunkPointNum() {
    return TSTracingInfo_SequenceChunkPointNum_DEFAULT
  }
return *p.SequenceChunkPointNum
}
var TSTracingInfo_UnsequenceChunkNum_DEFAULT int32
func (p *TSTracingInfo) GetUnsequenceChunkNum() int32 {
  if !p.IsSetUnsequenceChunkNum() {
    return TSTracingInfo_UnsequenceChunkNum_DEFAULT
  }
return *p.UnsequenceChunkNum
}
var TSTracingInfo_UnsequenceChunkPointNum_DEFAULT int64
func (p *TSTracingInfo) GetUnsequenceChunkPointNum() int64 {
  if !p.IsSetUnsequenceChunkPointNum() {
    return TSTracingInfo_UnsequenceChunkPointNum_DEFAULT
  }
return *p.UnsequenceChunkPointNum
}
var TSTracingInfo_TotalPageNum_DEFAULT int32
func (p *TSTracingInfo) GetTotalPageNum() int32 {
  if !p.IsSetTotalPageNum() {
    return TSTracingInfo_TotalPageNum_DEFAULT
  }
return *p.TotalPageNum
}
var TSTracingInfo_OverlappedPageNum_DEFAULT int32
func (p *TSTracingInfo) GetOverlappedPageNum() int32 {
  if !p.IsSetOverlappedPageNum() {
    return TSTracingInfo_OverlappedPageNum_DEFAULT
  }
return *p.OverlappedPageNum
}
func (p *TSTracingInfo) IsSetSeriesPathNum() bool {
  return p.SeriesPathNum != nil
}

func (p *TSTracingInfo) IsSetSeqFileNum() bool {
  return p.SeqFileNum != nil
}

func (p *TSTracingInfo) IsSetUnSeqFileNum() bool {
  return p.UnSeqFileNum != nil
}

func (p *TSTracingInfo) IsSetSequenceChunkNum() bool {
  return p.SequenceChunkNum != nil
}

func (p *TSTracingInfo) IsSetSequenceChunkPointNum() bool {
  return p.SequenceChunkPointNum != nil
}

func (p *TSTracingInfo) IsSetUnsequenceChunkNum() bool {
  return p.UnsequenceChunkNum != nil
}

func (p *TSTracingInfo) IsSetUnsequenceChunkPointNum() bool {
  return p.UnsequenceChunkPointNum != nil
}

func (p *TSTracingInfo) IsSetTotalPageNum() bool {
  return p.TotalPageNum != nil
}

func (p *TSTracingInfo) IsSetOverlappedPageNum() bool {
  return p.OverlappedPageNum != nil
}

func (p *TSTracingInfo) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetActivityList bool = false;
  var issetElapsedTimeList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetActivityList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetElapsedTimeList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 11:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField11(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetActivityList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ActivityList is not set"));
  }
  if !issetElapsedTimeList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ElapsedTimeList is not set"));
  }
  return nil
}

func (p *TSTracingInfo)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.ActivityList =  tSlice
  for i := 0; i < size; i ++ {
var _elem10 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem10 = v
}
    p.ActivityList = append(p.ActivityList, _elem10)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSTracingInfo)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.ElapsedTimeList =  tSlice
  for i := 0; i < size; i ++ {
var _elem11 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem11 = v
}
    p.ElapsedTimeList = append(p.ElapsedTimeList, _elem11)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSTracingInfo)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.SeriesPathNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.SeqFileNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.UnSeqFileNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.SequenceChunkNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.SequenceChunkPointNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.UnsequenceChunkNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.UnsequenceChunkPointNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 10: ", err)
} else {
  p.TotalPageNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 11: ", err)
} else {
  p.OverlappedPageNum = &v
}
  return nil
}

func (p *TSTracingInfo) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSTracingInfo"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
    if err := p.writeField11(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSTracingInfo) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "activityList", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:activityList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ActivityList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ActivityList {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:activityList: ", p), err) }
  return err
}

func (p *TSTracingInfo) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "elapsedTimeList", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:elapsedTimeList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.ElapsedTimeList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ElapsedTimeList {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:elapsedTimeList: ", p), err) }
  return err
}

func (p *TSTracingInfo) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSeriesPathNum() {
    if err := oprot.WriteFieldBegin(ctx, "seriesPathNum", thrift.I32, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:seriesPathNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.SeriesPathNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.seriesPathNum (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:seriesPathNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSeqFileNum() {
    if err := oprot.WriteFieldBegin(ctx, "seqFileNum", thrift.I32, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:seqFileNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.SeqFileNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.seqFileNum (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:seqFileNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetUnSeqFileNum() {
    if err := oprot.WriteFieldBegin(ctx, "unSeqFileNum", thrift.I32, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:unSeqFileNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.UnSeqFileNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.unSeqFileNum (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:unSeqFileNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSequenceChunkNum() {
    if err := oprot.WriteFieldBegin(ctx, "sequenceChunkNum", thrift.I32, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:sequenceChunkNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.SequenceChunkNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.sequenceChunkNum (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:sequenceChunkNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSequenceChunkPointNum() {
    if err := oprot.WriteFieldBegin(ctx, "sequenceChunkPointNum", thrift.I64, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:sequenceChunkPointNum: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.SequenceChunkPointNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.sequenceChunkPointNum (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:sequenceChunkPointNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetUnsequenceChunkNum() {
    if err := oprot.WriteFieldBegin(ctx, "unsequenceChunkNum", thrift.I32, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:unsequenceChunkNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.UnsequenceChunkNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.unsequenceChunkNum (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:unsequenceChunkNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetUnsequenceChunkPointNum() {
    if err := oprot.WriteFieldBegin(ctx, "unsequenceChunkPointNum", thrift.I64, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:unsequenceChunkPointNum: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.UnsequenceChunkPointNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.unsequenceChunkPointNum (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:unsequenceChunkPointNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTotalPageNum() {
    if err := oprot.WriteFieldBegin(ctx, "totalPageNum", thrift.I32, 10); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:totalPageNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.TotalPageNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.totalPageNum (10) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 10:totalPageNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetOverlappedPageNum() {
    if err := oprot.WriteFieldBegin(ctx, "overlappedPageNum", thrift.I32, 11); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:overlappedPageNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.OverlappedPageNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.overlappedPageNum (11) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 11:overlappedPageNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) Equals(other *TSTracingInfo) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.ActivityList) != len(other.ActivityList) { return false }
  for i, _tgt := range p.ActivityList {
    _src12 := other.ActivityList[i]
    if _tgt != _src12 { return false }
  }
  if len(p.ElapsedTimeList) != len(other.ElapsedTimeList) { return false }
  for i, _tgt := range p.ElapsedTimeList {
    _src13 := other.ElapsedTimeList[i]
    if _tgt != _src13 { return false }
  }
  if p.SeriesPathNum != other.SeriesPathNum {
    if p.SeriesPathNum == nil || other.SeriesPathNum == nil {
      return false
    }
    if (*p.SeriesPathNum) != (*other.SeriesPathNum) { return false }
  }
  if p.SeqFileNum != other.SeqFileNum {
    if p.SeqFileNum == nil || other.SeqFileNum == nil {
      return false
    }
    if (*p.SeqFileNum) != (*other.SeqFileNum) { return false }
  }
  if p.UnSeqFileNum != other.UnSeqFileNum {
    if p.UnSeqFileNum == nil || other.UnSeqFileNum == nil {
      return false
    }
    if (*p.UnSeqFileNum) != (*other.UnSeqFileNum) { return false }
  }
  if p.SequenceChunkNum != other.SequenceChunkNum {
    if p.SequenceChunkNum == nil || other.SequenceChunkNum == nil {
      return false
    }
    if (*p.SequenceChunkNum) != (*other.SequenceChunkNum) { return false }
  }
  if p.SequenceChunkPointNum != other.SequenceChunkPointNum {
    if p.SequenceChunkPointNum == nil || other.SequenceChunkPointNum == nil {
      return false
    }
    if (*p.SequenceChunkPointNum) != (*other.SequenceChunkPointNum) { return false }
  }
  if p.UnsequenceChunkNum != other.UnsequenceChunkNum {
    if p.UnsequenceChunkNum == nil || other.UnsequenceChunkNum == nil {
      return false
    }
    if (*p.UnsequenceChunkNum) != (*other.UnsequenceChunkNum) { return false }
  }
  if p.UnsequenceChunkPointNum != other.UnsequenceChunkPointNum {
    if p.UnsequenceChunkPointNum == nil || other.UnsequenceChunkPointNum == nil {
      return false
    }
    if (*p.UnsequenceChunkPointNum) != (*other.UnsequenceChunkPointNum) { return false }
  }
  if p.TotalPageNum != other.TotalPageNum {
    if p.TotalPageNum == nil || other.TotalPageNum == nil {
      return false
    }
    if (*p.TotalPageNum) != (*other.TotalPageNum) { return false }
  }
  if p.OverlappedPageNum != other.OverlappedPageNum {
    if p.OverlappedPageNum == nil || other.OverlappedPageNum == nil {
      return false
    }
    if (*p.OverlappedPageNum) != (*other.OverlappedPageNum) { return false }
  }
  return true
}

func (p *TSTracingInfo) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSTracingInfo(%+v)", *p)
}

// Attributes:
//  - Status
//  - QueryId
//  - Columns
//  - OperationType
//  - IgnoreTimeStamp
//  - DataTypeList
//  - QueryDataSet
//  - NonAlignQueryDataSet
//  - ColumnNameIndexMap
//  - SgColumns
//  - AliasColumns
//  - TracingInfo
type TSExecuteStatementResp struct {
  Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  QueryId *int64 `thrift:"queryId,2" db:"queryId" json:"queryId,omitempty"`
  Columns []string `thrift:"columns,3" db:"columns" json:"columns,omitempty"`
  OperationType *string `thrift:"operationType,4" db:"operationType" json:"operationType,omitempty"`
  IgnoreTimeStamp *bool `thrift:"ignoreTimeStamp,5" db:"ignoreTimeStamp" json:"ignoreTimeStamp,omitempty"`
  DataTypeList []string `thrift:"dataTypeList,6" db:"dataTypeList" json:"dataTypeList,omitempty"`
  QueryDataSet *TSQueryDataSet `thrift:"queryDataSet,7" db:"queryDataSet" json:"queryDataSet,omitempty"`
  NonAlignQueryDataSet *TSQueryNonAlignDataSet `thrift:"nonAlignQueryDataSet,8" db:"nonAlignQueryDataSet" json:"nonAlignQueryDataSet,omitempty"`
  ColumnNameIndexMap map[string]int32 `thrift:"columnNameIndexMap,9" db:"columnNameIndexMap" json:"columnNameIndexMap,omitempty"`
  SgColumns []string `thrift:"sgColumns,10" db:"sgColumns" json:"sgColumns,omitempty"`
  AliasColumns []int8 `thrift:"aliasColumns,11" db:"aliasColumns" json:"aliasColumns,omitempty"`
  TracingInfo *TSTracingInfo `thrift:"tracingInfo,12" db:"tracingInfo" json:"tracingInfo,omitempty"`
}

func NewTSExecuteStatementResp() *TSExecuteStatementResp {
  return &TSExecuteStatementResp{}
}

var TSExecuteStatementResp_Status_DEFAULT *TSStatus
func (p *TSExecuteStatementResp) GetStatus() *TSStatus {
  if !p.IsSetStatus() {
    return TSExecuteStatementResp_Status_DEFAULT
  }
return p.Status
}
var TSExecuteStatementResp_QueryId_DEFAULT int64
func (p *TSExecuteStatementResp) GetQueryId() int64 {
  if !p.IsSetQueryId() {
    return TSExecuteStatementResp_QueryId_DEFAULT
  }
return *p.QueryId
}
var TSExecuteStatementResp_Columns_DEFAULT []string

func (p *TSExecuteStatementResp) GetColumns() []string {
  return p.Columns
}
var TSExecuteStatementResp_OperationType_DEFAULT string
func (p *TSExecuteStatementResp) GetOperationType() string {
  if !p.IsSetOperationType() {
    return TSExecuteStatementResp_OperationType_DEFAULT
  }
return *p.OperationType
}
var TSExecuteStatementResp_IgnoreTimeStamp_DEFAULT bool
func (p *TSExecuteStatementResp) GetIgnoreTimeStamp() bool {
  if !p.IsSetIgnoreTimeStamp() {
    return TSExecuteStatementResp_IgnoreTimeStamp_DEFAULT
  }
return *p.IgnoreTimeStamp
}
var TSExecuteStatementResp_DataTypeList_DEFAULT []string

func (p *TSExecuteStatementResp) GetDataTypeList() []string {
  return p.DataTypeList
}
var TSExecuteStatementResp_QueryDataSet_DEFAULT *TSQueryDataSet
func (p *TSExecuteStatementResp) GetQueryDataSet() *TSQueryDataSet {
  if !p.IsSetQueryDataSet() {
    return TSExecuteStatementResp_QueryDataSet_DEFAULT
  }
return p.QueryDataSet
}
var TSExecuteStatementResp_NonAlignQueryDataSet_DEFAULT *TSQueryNonAlignDataSet
func (p *TSExecuteStatementResp) GetNonAlignQueryDataSet() *TSQueryNonAlignDataSet {
  if !p.IsSetNonAlignQueryDataSet() {
    return TSExecuteStatementResp_NonAlignQueryDataSet_DEFAULT
  }
return p.NonAlignQueryDataSet
}
var TSExecuteStatementResp_ColumnNameIndexMap_DEFAULT map[string]int32

func (p *TSExecuteStatementResp) GetColumnNameIndexMap() map[string]int32 {
  return p.ColumnNameIndexMap
}
var TSExecuteStatementResp_SgColumns_DEFAULT []string

func (p *TSExecuteStatementResp) GetSgColumns() []string {
  return p.SgColumns
}
var TSExecuteStatementResp_AliasColumns_DEFAULT []int8

func (p *TSExecuteStatementResp) GetAliasColumns() []int8 {
  return p.AliasColumns
}
var TSExecuteStatementResp_TracingInfo_DEFAULT *TSTracingInfo
func (p *TSExecuteStatementResp) GetTracingInfo() *TSTracingInfo {
  if !p.IsSetTracingInfo() {
    return TSExecuteStatementResp_TracingInfo_DEFAULT
  }
return p.TracingInfo
}
func (p *TSExecuteStatementResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSExecuteStatementResp) IsSetQueryId() bool {
  return p.QueryId != nil
}

func (p *TSExecuteStatementResp) IsSetColumns() bool {
  return p.Columns != nil
}

func (p *TSExecuteStatementResp) IsSetOperationType() bool {
  return p.OperationType != nil
}

func (p *TSExecuteStatementResp) IsSetIgnoreTimeStamp() bool {
  return p.IgnoreTimeStamp != nil
}

func (p *TSExecuteStatementResp) IsSetDataTypeList() bool {
  return p.DataTypeList != nil
}

func (p *TSExecuteStatementResp) IsSetQueryDataSet() bool {
  return p.QueryDataSet != nil
}

func (p *TSExecuteStatementResp) IsSetNonAlignQueryDataSet() bool {
  return p.NonAlignQueryDataSet != nil
}

func (p *TSExecuteStatementResp) IsSetColumnNameIndexMap() bool {
  return p.ColumnNameIndexMap != nil
}

func (p *TSExecuteStatementResp) IsSetSgColumns() bool {
  return p.SgColumns != nil
}

func (p *TSExecuteStatementResp) IsSetAliasColumns() bool {
  return p.AliasColumns != nil
}

func (p *TSExecuteStatementResp) IsSetTracingInfo() bool {
  return p.TracingInfo != nil
}

func (p *TSExecuteStatementResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 11:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField11(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 12:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField12(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryId = &v
}
  return nil
}

func (p *TSExecuteStatementResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Columns =  tSlice
  for i := 0; i < size; i ++ {
var _elem14 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem14 = v
}
    p.Columns = append(p.Columns, _elem14)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.OperationType = &v
}
  return nil
}

func (p *TSExecuteStatementResp)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.IgnoreTimeStamp = &v
}
  return nil
}

func (p *TSExecuteStatementResp)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.DataTypeList =  tSlice
  for i := 0; i < size; i ++ {
var _elem15 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem15 = v
}
    p.DataTypeList = append(p.DataTypeList, _elem15)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  p.QueryDataSet = &TSQueryDataSet{}
  if err := p.QueryDataSet.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.QueryDataSet), err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  p.NonAlignQueryDataSet = &TSQueryNonAlignDataSet{}
  if err := p.NonAlignQueryDataSet.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.NonAlignQueryDataSet), err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]int32, size)
  p.ColumnNameIndexMap =  tMap
  for i := 0; i < size; i ++ {
var _key16 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key16 = v
}
var _val17 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val17 = v
}
    p.ColumnNameIndexMap[_key16] = _val17
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.SgColumns =  tSlice
  for i := 0; i < size; i ++ {
var _elem18 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem18 = v
}
    p.SgColumns = append(p.SgColumns, _elem18)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int8, 0, size)
  p.AliasColumns =  tSlice
  for i := 0; i < size; i ++ {
var _elem19 int8
    if v, err := iprot.ReadByte(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := int8(v)
    _elem19 = temp
}
    p.AliasColumns = append(p.AliasColumns, _elem19)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField12(ctx context.Context, iprot thrift.TProtocol) error {
  p.TracingInfo = &TSTracingInfo{}
  if err := p.TracingInfo.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.TracingInfo), err)
  }
  return nil
}

func (p *TSExecuteStatementResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSExecuteStatementResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
    if err := p.writeField11(ctx, oprot); err != nil { return err }
    if err := p.writeField12(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSExecuteStatementResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSExecuteStatementResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryId() {
    if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.QueryId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetColumns() {
    if err := oprot.WriteFieldBegin(ctx, "columns", thrift.LIST, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columns: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Columns)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Columns {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columns: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetOperationType() {
    if err := oprot.WriteFieldBegin(ctx, "operationType", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:operationType: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.OperationType)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.operationType (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:operationType: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIgnoreTimeStamp() {
    if err := oprot.WriteFieldBegin(ctx, "ignoreTimeStamp", thrift.BOOL, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:ignoreTimeStamp: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IgnoreTimeStamp)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.ignoreTimeStamp (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:ignoreTimeStamp: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetDataTypeList() {
    if err := oprot.WriteFieldBegin(ctx, "dataTypeList", thrift.LIST, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:dataTypeList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.DataTypeList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.DataTypeList {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:dataTypeList: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryDataSet() {
    if err := oprot.WriteFieldBegin(ctx, "queryDataSet", thrift.STRUCT, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:queryDataSet: ", p), err) }
    if err := p.QueryDataSet.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.QueryDataSet), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:queryDataSet: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetNonAlignQueryDataSet() {
    if err := oprot.WriteFieldBegin(ctx, "nonAlignQueryDataSet", thrift.STRUCT, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:nonAlignQueryDataSet: ", p), err) }
    if err := p.NonAlignQueryDataSet.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.NonAlignQueryDataSet), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:nonAlignQueryDataSet: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetColumnNameIndexMap() {
    if err := oprot.WriteFieldBegin(ctx, "columnNameIndexMap", thrift.MAP, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:columnNameIndexMap: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.I32, len(p.ColumnNameIndexMap)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.ColumnNameIndexMap {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteI32(ctx, int32(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:columnNameIndexMap: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSgColumns() {
    if err := oprot.WriteFieldBegin(ctx, "sgColumns", thrift.LIST, 10); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:sgColumns: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.SgColumns)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.SgColumns {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 10:sgColumns: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetAliasColumns() {
    if err := oprot.WriteFieldBegin(ctx, "aliasColumns", thrift.LIST, 11); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:aliasColumns: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.BYTE, len(p.AliasColumns)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.AliasColumns {
      if err := oprot.WriteByte(ctx, int8(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 11:aliasColumns: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField12(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTracingInfo() {
    if err := oprot.WriteFieldBegin(ctx, "tracingInfo", thrift.STRUCT, 12); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 12:tracingInfo: ", p), err) }
    if err := p.TracingInfo.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.TracingInfo), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 12:tracingInfo: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) Equals(other *TSExecuteStatementResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.QueryId != other.QueryId {
    if p.QueryId == nil || other.QueryId == nil {
      return false
    }
    if (*p.QueryId) != (*other.QueryId) { return false }
  }
  if len(p.Columns) != len(other.Columns) { return false }
  for i, _tgt := range p.Columns {
    _src20 := other.Columns[i]
    if _tgt != _src20 { return false }
  }
  if p.OperationType != other.OperationType {
    if p.OperationType == nil || other.OperationType == nil {
      return false
    }
    if (*p.OperationType) != (*other.OperationType) { return false }
  }
  if p.IgnoreTimeStamp != other.IgnoreTimeStamp {
    if p.IgnoreTimeStamp == nil || other.IgnoreTimeStamp == nil {
      return false
    }
    if (*p.IgnoreTimeStamp) != (*other.IgnoreTimeStamp) { return false }
  }
  if len(p.DataTypeList) != len(other.DataTypeList) { return false }
  for i, _tgt := range p.DataTypeList {
    _src21 := other.DataTypeList[i]
    if _tgt != _src21 { return false }
  }
  if !p.QueryDataSet.Equals(other.QueryDataSet) { return false }
  if !p.NonAlignQueryDataSet.Equals(other.NonAlignQueryDataSet) { return false }
  if len(p.ColumnNameIndexMap) != len(other.ColumnNameIndexMap) { return false }
  for k, _tgt := range p.ColumnNameIndexMap {
    _src22 := other.ColumnNameIndexMap[k]
    if _tgt != _src22 { return false }
  }
  if len(p.SgColumns) != len(other.SgColumns) { return false }
  for i, _tgt := range p.SgColumns {
    _src23 := other.SgColumns[i]
    if _tgt != _src23 { return false }
  }
  if len(p.AliasColumns) != len(other.AliasColumns) { return false }
  for i, _tgt := range p.AliasColumns {
    _src24 := other.AliasColumns[i]
    if _tgt != _src24 { return false }
  }
  if !p.TracingInfo.Equals(other.TracingInfo) { return false }
  return true
}

func (p *TSExecuteStatementResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSExecuteStatementResp(%+v)", *p)
}

// Attributes:
//  - Status
//  - ServerProtocolVersion
//  - SessionId
//  - Configuration
type TSOpenSessionResp struct {
  Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  ServerProtocolVersion TSProtocolVersion `thrift:"serverProtocolVersion,2,required" db:"serverProtocolVersion" json:"serverProtocolVersion"`
  SessionId *int64 `thrift:"sessionId,3" db:"sessionId" json:"sessionId,omitempty"`
  Configuration map[string]string `thrift:"configuration,4" db:"configuration" json:"configuration,omitempty"`
}

func NewTSOpenSessionResp() *TSOpenSessionResp {
  return &TSOpenSessionResp{
ServerProtocolVersion: 0,
}
}

var TSOpenSessionResp_Status_DEFAULT *TSStatus
func (p *TSOpenSessionResp) GetStatus() *TSStatus {
  if !p.IsSetStatus() {
    return TSOpenSessionResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSOpenSessionResp) GetServerProtocolVersion() TSProtocolVersion {
  return p.ServerProtocolVersion
}
var TSOpenSessionResp_SessionId_DEFAULT int64
func (p *TSOpenSessionResp) GetSessionId() int64 {
  if !p.IsSetSessionId() {
    return TSOpenSessionResp_SessionId_DEFAULT
  }
return *p.SessionId
}
var TSOpenSessionResp_Configuration_DEFAULT map[string]string

func (p *TSOpenSessionResp) GetConfiguration() map[string]string {
  return p.Configuration
}
func (p *TSOpenSessionResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSOpenSessionResp) IsSetSessionId() bool {
  return p.SessionId != nil
}

func (p *TSOpenSessionResp) IsSetConfiguration() bool {
  return p.Configuration != nil
}

func (p *TSOpenSessionResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetServerProtocolVersion bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetServerProtocolVersion = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetServerProtocolVersion{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ServerProtocolVersion is not set"));
  }
  return nil
}

func (p *TSOpenSessionResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSOpenSessionResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := TSProtocolVersion(v)
  p.ServerProtocolVersion = temp
}
  return nil
}

func (p *TSOpenSessionResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.SessionId = &v
}
  return nil
}

func (p *TSOpenSessionResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Configuration =  tMap
  for i := 0; i < size; i ++ {
var _key25 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key25 = v
}
var _val26 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val26 = v
}
    p.Configuration[_key25] = _val26
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSOpenSessionResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSOpenSessionResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSOpenSessionResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSOpenSessionResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "serverProtocolVersion", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:serverProtocolVersion: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.ServerProtocolVersion)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.serverProtocolVersion (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:serverProtocolVersion: ", p), err) }
  return err
}

func (p *TSOpenSessionResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSessionId() {
    if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:sessionId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.SessionId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.sessionId (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:sessionId: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetConfiguration() {
    if err := oprot.WriteFieldBegin(ctx, "configuration", thrift.MAP, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:configuration: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Configuration)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Configuration {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:configuration: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionResp) Equals(other *TSOpenSessionResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.ServerProtocolVersion != other.ServerProtocolVersion { return false }
  if p.SessionId != other.SessionId {
    if p.SessionId == nil || other.SessionId == nil {
      return false
    }
    if (*p.SessionId) != (*other.SessionId) { return false }
  }
  if len(p.Configuration) != len(other.Configuration) { return false }
  for k, _tgt := range p.Configuration {
    _src27 := other.Configuration[k]
    if _tgt != _src27 { return false }
  }
  return true
}

func (p *TSOpenSessionResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSOpenSessionResp(%+v)", *p)
}

// Attributes:
//  - ClientProtocol
//  - ZoneId
//  - Username
//  - Password
//  - Configuration
type TSOpenSessionReq struct {
  ClientProtocol TSProtocolVersion `thrift:"client_protocol,1,required" db:"client_protocol" json:"client_protocol"`
  ZoneId string `thrift:"zoneId,2,required" db:"zoneId" json:"zoneId"`
  Username *string `thrift:"username,3" db:"username" json:"username,omitempty"`
  Password *string `thrift:"password,4" db:"password" json:"password,omitempty"`
  Configuration map[string]string `thrift:"configuration,5" db:"configuration" json:"configuration,omitempty"`
}

func NewTSOpenSessionReq() *TSOpenSessionReq {
  return &TSOpenSessionReq{
ClientProtocol: 2,
}
}


func (p *TSOpenSessionReq) GetClientProtocol() TSProtocolVersion {
  return p.ClientProtocol
}

func (p *TSOpenSessionReq) GetZoneId() string {
  return p.ZoneId
}
var TSOpenSessionReq_Username_DEFAULT string
func (p *TSOpenSessionReq) GetUsername() string {
  if !p.IsSetUsername() {
    return TSOpenSessionReq_Username_DEFAULT
  }
return *p.Username
}
var TSOpenSessionReq_Password_DEFAULT string
func (p *TSOpenSessionReq) GetPassword() string {
  if !p.IsSetPassword() {
    return TSOpenSessionReq_Password_DEFAULT
  }
return *p.Password
}
var TSOpenSessionReq_Configuration_DEFAULT map[string]string

func (p *TSOpenSessionReq) GetConfiguration() map[string]string {
  return p.Configuration
}
func (p *TSOpenSessionReq) IsSetUsername() bool {
  return p.Username != nil
}

func (p *TSOpenSessionReq) IsSetPassword() bool {
  return p.Password != nil
}

func (p *TSOpenSessionReq) IsSetConfiguration() bool {
  return p.Configuration != nil
}

func (p *TSOpenSessionReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetClientProtocol bool = false;
  var issetZoneId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetClientProtocol = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetZoneId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetClientProtocol{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ClientProtocol is not set"));
  }
  if !issetZoneId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ZoneId is not set"));
  }
  return nil
}

func (p *TSOpenSessionReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := TSProtocolVersion(v)
  p.ClientProtocol = temp
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.ZoneId = v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Username = &v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Password = &v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Configuration =  tMap
  for i := 0; i < size; i ++ {
var _key28 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key28 = v
}
var _val29 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val29 = v
}
    p.Configuration[_key28] = _val29
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSOpenSessionReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSOpenSessionReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSOpenSessionReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "client_protocol", thrift.I32, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:client_protocol: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.ClientProtocol)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.client_protocol (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:client_protocol: ", p), err) }
  return err
}

func (p *TSOpenSessionReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "zoneId", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:zoneId: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ZoneId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.zoneId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:zoneId: ", p), err) }
  return err
}

func (p *TSOpenSessionReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetUsername() {
    if err := oprot.WriteFieldBegin(ctx, "username", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:username: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Username)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.username (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:username: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetPassword() {
    if err := oprot.WriteFieldBegin(ctx, "password", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:password: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Password)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.password (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:password: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetConfiguration() {
    if err := oprot.WriteFieldBegin(ctx, "configuration", thrift.MAP, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:configuration: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Configuration)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Configuration {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:configuration: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionReq) Equals(other *TSOpenSessionReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.ClientProtocol != other.ClientProtocol { return false }
  if p.ZoneId != other.ZoneId { return false }
  if p.Username != other.Username {
    if p.Username == nil || other.Username == nil {
      return false
    }
    if (*p.Username) != (*other.Username) { return false }
  }
  if p.Password != other.Password {
    if p.Password == nil || other.Password == nil {
      return false
    }
    if (*p.Password) != (*other.Password) { return false }
  }
  if len(p.Configuration) != len(other.Configuration) { return false }
  for k, _tgt := range p.Configuration {
    _src30 := other.Configuration[k]
    if _tgt != _src30 { return false }
  }
  return true
}

func (p *TSOpenSessionReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSOpenSessionReq(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSCloseSessionReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
}

func NewTSCloseSessionReq() *TSCloseSessionReq {
  return &TSCloseSessionReq{}
}


func (p *TSCloseSessionReq) GetSessionId() int64 {
  return p.SessionId
}
func (p *TSCloseSessionReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  return nil
}

func (p *TSCloseSessionReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCloseSessionReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCloseSessionReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCloseSessionReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCloseSessionReq) Equals(other *TSCloseSessionReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  return true
}

func (p *TSCloseSessionReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCloseSessionReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statement
//  - StatementId
//  - FetchSize
//  - Timeout
//  - EnableRedirectQuery
//  - JdbcQuery
type TSExecuteStatementReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Statement string `thrift:"statement,2,required" db:"statement" json:"statement"`
  StatementId int64 `thrift:"statementId,3,required" db:"statementId" json:"statementId"`
  FetchSize *int32 `thrift:"fetchSize,4" db:"fetchSize" json:"fetchSize,omitempty"`
  Timeout *int64 `thrift:"timeout,5" db:"timeout" json:"timeout,omitempty"`
  EnableRedirectQuery *bool `thrift:"enableRedirectQuery,6" db:"enableRedirectQuery" json:"enableRedirectQuery,omitempty"`
  JdbcQuery *bool `thrift:"jdbcQuery,7" db:"jdbcQuery" json:"jdbcQuery,omitempty"`
}

func NewTSExecuteStatementReq() *TSExecuteStatementReq {
  return &TSExecuteStatementReq{}
}


func (p *TSExecuteStatementReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSExecuteStatementReq) GetStatement() string {
  return p.Statement
}

func (p *TSExecuteStatementReq) GetStatementId() int64 {
  return p.StatementId
}
var TSExecuteStatementReq_FetchSize_DEFAULT int32
func (p *TSExecuteStatementReq) GetFetchSize() int32 {
  if !p.IsSetFetchSize() {
    return TSExecuteStatementReq_FetchSize_DEFAULT
  }
return *p.FetchSize
}
var TSExecuteStatementReq_Timeout_DEFAULT int64
func (p *TSExecuteStatementReq) GetTimeout() int64 {
  if !p.IsSetTimeout() {
    return TSExecuteStatementReq_Timeout_DEFAULT
  }
return *p.Timeout
}
var TSExecuteStatementReq_EnableRedirectQuery_DEFAULT bool
func (p *TSExecuteStatementReq) GetEnableRedirectQuery() bool {
  if !p.IsSetEnableRedirectQuery() {
    return TSExecuteStatementReq_EnableRedirectQuery_DEFAULT
  }
return *p.EnableRedirectQuery
}
var TSExecuteStatementReq_JdbcQuery_DEFAULT bool
func (p *TSExecuteStatementReq) GetJdbcQuery() bool {
  if !p.IsSetJdbcQuery() {
    return TSExecuteStatementReq_JdbcQuery_DEFAULT
  }
return *p.JdbcQuery
}
func (p *TSExecuteStatementReq) IsSetFetchSize() bool {
  return p.FetchSize != nil
}

func (p *TSExecuteStatementReq) IsSetTimeout() bool {
  return p.Timeout != nil
}

func (p *TSExecuteStatementReq) IsSetEnableRedirectQuery() bool {
  return p.EnableRedirectQuery != nil
}

func (p *TSExecuteStatementReq) IsSetJdbcQuery() bool {
  return p.JdbcQuery != nil
}

func (p *TSExecuteStatementReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetStatement bool = false;
  var issetStatementId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetStatement = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetStatementId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetStatement{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statement is not set"));
  }
  if !issetStatementId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
  }
  return nil
}

func (p *TSExecuteStatementReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Statement = v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.StatementId = v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.FetchSize = &v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Timeout = &v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.EnableRedirectQuery = &v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.JdbcQuery = &v
}
  return nil
}

func (p *TSExecuteStatementReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSExecuteStatementReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSExecuteStatementReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSExecuteStatementReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statement", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statement: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Statement)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statement (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statement: ", p), err) }
  return err
}

func (p *TSExecuteStatementReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:statementId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statementId (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:statementId: ", p), err) }
  return err
}

func (p *TSExecuteStatementReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFetchSize() {
    if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:fetchSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.fetchSize (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:fetchSize: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeout() {
    if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timeout: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeout (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timeout: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetEnableRedirectQuery() {
    if err := oprot.WriteFieldBegin(ctx, "enableRedirectQuery", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:enableRedirectQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.EnableRedirectQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.enableRedirectQuery (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:enableRedirectQuery: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetJdbcQuery() {
    if err := oprot.WriteFieldBegin(ctx, "jdbcQuery", thrift.BOOL, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:jdbcQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.JdbcQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.jdbcQuery (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:jdbcQuery: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementReq) Equals(other *TSExecuteStatementReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Statement != other.Statement { return false }
  if p.StatementId != other.StatementId { return false }
  if p.FetchSize != other.FetchSize {
    if p.FetchSize == nil || other.FetchSize == nil {
      return false
    }
    if (*p.FetchSize) != (*other.FetchSize) { return false }
  }
  if p.Timeout != other.Timeout {
    if p.Timeout == nil || other.Timeout == nil {
      return false
    }
    if (*p.Timeout) != (*other.Timeout) { return false }
  }
  if p.EnableRedirectQuery != other.EnableRedirectQuery {
    if p.EnableRedirectQuery == nil || other.EnableRedirectQuery == nil {
      return false
    }
    if (*p.EnableRedirectQuery) != (*other.EnableRedirectQuery) { return false }
  }
  if p.JdbcQuery != other.JdbcQuery {
    if p.JdbcQuery == nil || other.JdbcQuery == nil {
      return false
    }
    if (*p.JdbcQuery) != (*other.JdbcQuery) { return false }
  }
  return true
}

func (p *TSExecuteStatementReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSExecuteStatementReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statements
type TSExecuteBatchStatementReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Statements []string `thrift:"statements,2,required" db:"statements" json:"statements"`
}

func NewTSExecuteBatchStatementReq() *TSExecuteBatchStatementReq {
  return &TSExecuteBatchStatementReq{}
}


func (p *TSExecuteBatchStatementReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSExecuteBatchStatementReq) GetStatements() []string {
  return p.Statements
}
func (p *TSExecuteBatchStatementReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetStatements bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetStatements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetStatements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statements is not set"));
  }
  return nil
}

func (p *TSExecuteBatchStatementReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSExecuteBatchStatementReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Statements =  tSlice
  for i := 0; i < size; i ++ {
var _elem31 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem31 = v
}
    p.Statements = append(p.Statements, _elem31)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteBatchStatementReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSExecuteBatchStatementReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSExecuteBatchStatementReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSExecuteBatchStatementReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statements", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Statements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Statements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statements: ", p), err) }
  return err
}

func (p *TSExecuteBatchStatementReq) Equals(other *TSExecuteBatchStatementReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Statements) != len(other.Statements) { return false }
  for i, _tgt := range p.Statements {
    _src32 := other.Statements[i]
    if _tgt != _src32 { return false }
  }
  return true
}

func (p *TSExecuteBatchStatementReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSExecuteBatchStatementReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
type TSGetOperationStatusReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  QueryId int64 `thrift:"queryId,2,required" db:"queryId" json:"queryId"`
}

func NewTSGetOperationStatusReq() *TSGetOperationStatusReq {
  return &TSGetOperationStatusReq{}
}


func (p *TSGetOperationStatusReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSGetOperationStatusReq) GetQueryId() int64 {
  return p.QueryId
}
func (p *TSGetOperationStatusReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetQueryId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  return nil
}

func (p *TSGetOperationStatusReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSGetOperationStatusReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryId = v
}
  return nil
}

func (p *TSGetOperationStatusReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSGetOperationStatusReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSGetOperationStatusReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSGetOperationStatusReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
  return err
}

func (p *TSGetOperationStatusReq) Equals(other *TSGetOperationStatusReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.QueryId != other.QueryId { return false }
  return true
}

func (p *TSGetOperationStatusReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSGetOperationStatusReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
type TSCancelOperationReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  QueryId int64 `thrift:"queryId,2,required" db:"queryId" json:"queryId"`
}

func NewTSCancelOperationReq() *TSCancelOperationReq {
  return &TSCancelOperationReq{}
}


func (p *TSCancelOperationReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCancelOperationReq) GetQueryId() int64 {
  return p.QueryId
}
func (p *TSCancelOperationReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetQueryId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  return nil
}

func (p *TSCancelOperationReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCancelOperationReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryId = v
}
  return nil
}

func (p *TSCancelOperationReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCancelOperationReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCancelOperationReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCancelOperationReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
  return err
}

func (p *TSCancelOperationReq) Equals(other *TSCancelOperationReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.QueryId != other.QueryId { return false }
  return true
}

func (p *TSCancelOperationReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCancelOperationReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
//  - StatementId
type TSCloseOperationReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  QueryId *int64 `thrift:"queryId,2" db:"queryId" json:"queryId,omitempty"`
  StatementId *int64 `thrift:"statementId,3" db:"statementId" json:"statementId,omitempty"`
}

func NewTSCloseOperationReq() *TSCloseOperationReq {
  return &TSCloseOperationReq{}
}


func (p *TSCloseOperationReq) GetSessionId() int64 {
  return p.SessionId
}
var TSCloseOperationReq_QueryId_DEFAULT int64
func (p *TSCloseOperationReq) GetQueryId() int64 {
  if !p.IsSetQueryId() {
    return TSCloseOperationReq_QueryId_DEFAULT
  }
return *p.QueryId
}
var TSCloseOperationReq_StatementId_DEFAULT int64
func (p *TSCloseOperationReq) GetStatementId() int64 {
  if !p.IsSetStatementId() {
    return TSCloseOperationReq_StatementId_DEFAULT
  }
return *p.StatementId
}
func (p *TSCloseOperationReq) IsSetQueryId() bool {
  return p.QueryId != nil
}

func (p *TSCloseOperationReq) IsSetStatementId() bool {
  return p.StatementId != nil
}

func (p *TSCloseOperationReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  return nil
}

func (p *TSCloseOperationReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCloseOperationReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryId = &v
}
  return nil
}

func (p *TSCloseOperationReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.StatementId = &v
}
  return nil
}

func (p *TSCloseOperationReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCloseOperationReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCloseOperationReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCloseOperationReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryId() {
    if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.QueryId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
  }
  return err
}

func (p *TSCloseOperationReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetStatementId() {
    if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:statementId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.StatementId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.statementId (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:statementId: ", p), err) }
  }
  return err
}

func (p *TSCloseOperationReq) Equals(other *TSCloseOperationReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.QueryId != other.QueryId {
    if p.QueryId == nil || other.QueryId == nil {
      return false
    }
    if (*p.QueryId) != (*other.QueryId) { return false }
  }
  if p.StatementId != other.StatementId {
    if p.StatementId == nil || other.StatementId == nil {
      return false
    }
    if (*p.StatementId) != (*other.StatementId) { return false }
  }
  return true
}

func (p *TSCloseOperationReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCloseOperationReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statement
//  - FetchSize
//  - QueryId
//  - IsAlign
//  - Timeout
type TSFetchResultsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Statement string `thrift:"statement,2,required" db:"statement" json:"statement"`
  FetchSize int32 `thrift:"fetchSize,3,required" db:"fetchSize" json:"fetchSize"`
  QueryId int64 `thrift:"queryId,4,required" db:"queryId" json:"queryId"`
  IsAlign bool `thrift:"isAlign,5,required" db:"isAlign" json:"isAlign"`
  Timeout *int64 `thrift:"timeout,6" db:"timeout" json:"timeout,omitempty"`
}

func NewTSFetchResultsReq() *TSFetchResultsReq {
  return &TSFetchResultsReq{}
}


func (p *TSFetchResultsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSFetchResultsReq) GetStatement() string {
  return p.Statement
}

func (p *TSFetchResultsReq) GetFetchSize() int32 {
  return p.FetchSize
}

func (p *TSFetchResultsReq) GetQueryId() int64 {
  return p.QueryId
}

func (p *TSFetchResultsReq) GetIsAlign() bool {
  return p.IsAlign
}
var TSFetchResultsReq_Timeout_DEFAULT int64
func (p *TSFetchResultsReq) GetTimeout() int64 {
  if !p.IsSetTimeout() {
    return TSFetchResultsReq_Timeout_DEFAULT
  }
return *p.Timeout
}
func (p *TSFetchResultsReq) IsSetTimeout() bool {
  return p.Timeout != nil
}

func (p *TSFetchResultsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetStatement bool = false;
  var issetFetchSize bool = false;
  var issetQueryId bool = false;
  var issetIsAlign bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetStatement = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetFetchSize = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetIsAlign = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetStatement{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statement is not set"));
  }
  if !issetFetchSize{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FetchSize is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetIsAlign{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAlign is not set"));
  }
  return nil
}

func (p *TSFetchResultsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Statement = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.FetchSize = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.QueryId = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.IsAlign = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.Timeout = &v
}
  return nil
}

func (p *TSFetchResultsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSFetchResultsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSFetchResultsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statement", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statement: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Statement)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statement (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statement: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:fetchSize: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.FetchSize)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.fetchSize (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:fetchSize: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryId: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "isAlign", thrift.BOOL, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:isAlign: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.IsAlign)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.isAlign (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:isAlign: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeout() {
    if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:timeout: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeout (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:timeout: ", p), err) }
  }
  return err
}

func (p *TSFetchResultsReq) Equals(other *TSFetchResultsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Statement != other.Statement { return false }
  if p.FetchSize != other.FetchSize { return false }
  if p.QueryId != other.QueryId { return false }
  if p.IsAlign != other.IsAlign { return false }
  if p.Timeout != other.Timeout {
    if p.Timeout == nil || other.Timeout == nil {
      return false
    }
    if (*p.Timeout) != (*other.Timeout) { return false }
  }
  return true
}

func (p *TSFetchResultsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSFetchResultsReq(%+v)", *p)
}

// Attributes:
//  - Status
//  - HasResultSet
//  - IsAlign
//  - QueryDataSet
//  - NonAlignQueryDataSet
type TSFetchResultsResp struct {
  Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  HasResultSet bool `thrift:"hasResultSet,2,required" db:"hasResultSet" json:"hasResultSet"`
  IsAlign bool `thrift:"isAlign,3,required" db:"isAlign" json:"isAlign"`
  QueryDataSet *TSQueryDataSet `thrift:"queryDataSet,4" db:"queryDataSet" json:"queryDataSet,omitempty"`
  NonAlignQueryDataSet *TSQueryNonAlignDataSet `thrift:"nonAlignQueryDataSet,5" db:"nonAlignQueryDataSet" json:"nonAlignQueryDataSet,omitempty"`
}

func NewTSFetchResultsResp() *TSFetchResultsResp {
  return &TSFetchResultsResp{}
}

var TSFetchResultsResp_Status_DEFAULT *TSStatus
func (p *TSFetchResultsResp) GetStatus() *TSStatus {
  if !p.IsSetStatus() {
    return TSFetchResultsResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSFetchResultsResp) GetHasResultSet() bool {
  return p.HasResultSet
}

func (p *TSFetchResultsResp) GetIsAlign() bool {
  return p.IsAlign
}
var TSFetchResultsResp_QueryDataSet_DEFAULT *TSQueryDataSet
func (p *TSFetchResultsResp) GetQueryDataSet() *TSQueryDataSet {
  if !p.IsSetQueryDataSet() {
    return TSFetchResultsResp_QueryDataSet_DEFAULT
  }
return p.QueryDataSet
}
var TSFetchResultsResp_NonAlignQueryDataSet_DEFAULT *TSQueryNonAlignDataSet
func (p *TSFetchResultsResp) GetNonAlignQueryDataSet() *TSQueryNonAlignDataSet {
  if !p.IsSetNonAlignQueryDataSet() {
    return TSFetchResultsResp_NonAlignQueryDataSet_DEFAULT
  }
return p.NonAlignQueryDataSet
}
func (p *TSFetchResultsResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSFetchResultsResp) IsSetQueryDataSet() bool {
  return p.QueryDataSet != nil
}

func (p *TSFetchResultsResp) IsSetNonAlignQueryDataSet() bool {
  return p.NonAlignQueryDataSet != nil
}

func (p *TSFetchResultsResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetHasResultSet bool = false;
  var issetIsAlign bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetHasResultSet = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetIsAlign = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetHasResultSet{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field HasResultSet is not set"));
  }
  if !issetIsAlign{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAlign is not set"));
  }
  return nil
}

func (p *TSFetchResultsResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSFetchResultsResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.HasResultSet = v
}
  return nil
}

func (p *TSFetchResultsResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.IsAlign = v
}
  return nil
}

func (p *TSFetchResultsResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  p.QueryDataSet = &TSQueryDataSet{}
  if err := p.QueryDataSet.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.QueryDataSet), err)
  }
  return nil
}

func (p *TSFetchResultsResp)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  p.NonAlignQueryDataSet = &TSQueryNonAlignDataSet{}
  if err := p.NonAlignQueryDataSet.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.NonAlignQueryDataSet), err)
  }
  return nil
}

func (p *TSFetchResultsResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSFetchResultsResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSFetchResultsResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSFetchResultsResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "hasResultSet", thrift.BOOL, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:hasResultSet: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.HasResultSet)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.hasResultSet (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:hasResultSet: ", p), err) }
  return err
}

func (p *TSFetchResultsResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "isAlign", thrift.BOOL, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:isAlign: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.IsAlign)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.isAlign (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:isAlign: ", p), err) }
  return err
}

func (p *TSFetchResultsResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryDataSet() {
    if err := oprot.WriteFieldBegin(ctx, "queryDataSet", thrift.STRUCT, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryDataSet: ", p), err) }
    if err := p.QueryDataSet.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.QueryDataSet), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryDataSet: ", p), err) }
  }
  return err
}

func (p *TSFetchResultsResp) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetNonAlignQueryDataSet() {
    if err := oprot.WriteFieldBegin(ctx, "nonAlignQueryDataSet", thrift.STRUCT, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:nonAlignQueryDataSet: ", p), err) }
    if err := p.NonAlignQueryDataSet.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.NonAlignQueryDataSet), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:nonAlignQueryDataSet: ", p), err) }
  }
  return err
}

func (p *TSFetchResultsResp) Equals(other *TSFetchResultsResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.HasResultSet != other.HasResultSet { return false }
  if p.IsAlign != other.IsAlign { return false }
  if !p.QueryDataSet.Equals(other.QueryDataSet) { return false }
  if !p.NonAlignQueryDataSet.Equals(other.NonAlignQueryDataSet) { return false }
  return true
}

func (p *TSFetchResultsResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSFetchResultsResp(%+v)", *p)
}

// Attributes:
//  - Status
//  - MetadataInJson
//  - ColumnsList
//  - DataType
type TSFetchMetadataResp struct {
  Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  MetadataInJson *string `thrift:"metadataInJson,2" db:"metadataInJson" json:"metadataInJson,omitempty"`
  ColumnsList []string `thrift:"columnsList,3" db:"columnsList" json:"columnsList,omitempty"`
  DataType *string `thrift:"dataType,4" db:"dataType" json:"dataType,omitempty"`
}

func NewTSFetchMetadataResp() *TSFetchMetadataResp {
  return &TSFetchMetadataResp{}
}

var TSFetchMetadataResp_Status_DEFAULT *TSStatus
func (p *TSFetchMetadataResp) GetStatus() *TSStatus {
  if !p.IsSetStatus() {
    return TSFetchMetadataResp_Status_DEFAULT
  }
return p.Status
}
var TSFetchMetadataResp_MetadataInJson_DEFAULT string
func (p *TSFetchMetadataResp) GetMetadataInJson() string {
  if !p.IsSetMetadataInJson() {
    return TSFetchMetadataResp_MetadataInJson_DEFAULT
  }
return *p.MetadataInJson
}
var TSFetchMetadataResp_ColumnsList_DEFAULT []string

func (p *TSFetchMetadataResp) GetColumnsList() []string {
  return p.ColumnsList
}
var TSFetchMetadataResp_DataType_DEFAULT string
func (p *TSFetchMetadataResp) GetDataType() string {
  if !p.IsSetDataType() {
    return TSFetchMetadataResp_DataType_DEFAULT
  }
return *p.DataType
}
func (p *TSFetchMetadataResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSFetchMetadataResp) IsSetMetadataInJson() bool {
  return p.MetadataInJson != nil
}

func (p *TSFetchMetadataResp) IsSetColumnsList() bool {
  return p.ColumnsList != nil
}

func (p *TSFetchMetadataResp) IsSetDataType() bool {
  return p.DataType != nil
}

func (p *TSFetchMetadataResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  return nil
}

func (p *TSFetchMetadataResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSFetchMetadataResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.MetadataInJson = &v
}
  return nil
}

func (p *TSFetchMetadataResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.ColumnsList =  tSlice
  for i := 0; i < size; i ++ {
var _elem33 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem33 = v
}
    p.ColumnsList = append(p.ColumnsList, _elem33)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSFetchMetadataResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.DataType = &v
}
  return nil
}

func (p *TSFetchMetadataResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSFetchMetadataResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSFetchMetadataResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSFetchMetadataResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMetadataInJson() {
    if err := oprot.WriteFieldBegin(ctx, "metadataInJson", thrift.STRING, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:metadataInJson: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.MetadataInJson)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.metadataInJson (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:metadataInJson: ", p), err) }
  }
  return err
}

func (p *TSFetchMetadataResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetColumnsList() {
    if err := oprot.WriteFieldBegin(ctx, "columnsList", thrift.LIST, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columnsList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ColumnsList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.ColumnsList {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columnsList: ", p), err) }
  }
  return err
}

func (p *TSFetchMetadataResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetDataType() {
    if err := oprot.WriteFieldBegin(ctx, "dataType", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:dataType: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.DataType)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.dataType (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:dataType: ", p), err) }
  }
  return err
}

func (p *TSFetchMetadataResp) Equals(other *TSFetchMetadataResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.MetadataInJson != other.MetadataInJson {
    if p.MetadataInJson == nil || other.MetadataInJson == nil {
      return false
    }
    if (*p.MetadataInJson) != (*other.MetadataInJson) { return false }
  }
  if len(p.ColumnsList) != len(other.ColumnsList) { return false }
  for i, _tgt := range p.ColumnsList {
    _src34 := other.ColumnsList[i]
    if _tgt != _src34 { return false }
  }
  if p.DataType != other.DataType {
    if p.DataType == nil || other.DataType == nil {
      return false
    }
    if (*p.DataType) != (*other.DataType) { return false }
  }
  return true
}

func (p *TSFetchMetadataResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSFetchMetadataResp(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Type
//  - ColumnPath
type TSFetchMetadataReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Type string `thrift:"type,2,required" db:"type" json:"type"`
  ColumnPath *string `thrift:"columnPath,3" db:"columnPath" json:"columnPath,omitempty"`
}

func NewTSFetchMetadataReq() *TSFetchMetadataReq {
  return &TSFetchMetadataReq{}
}


func (p *TSFetchMetadataReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSFetchMetadataReq) GetType() string {
  return p.Type
}
var TSFetchMetadataReq_ColumnPath_DEFAULT string
func (p *TSFetchMetadataReq) GetColumnPath() string {
  if !p.IsSetColumnPath() {
    return TSFetchMetadataReq_ColumnPath_DEFAULT
  }
return *p.ColumnPath
}
func (p *TSFetchMetadataReq) IsSetColumnPath() bool {
  return p.ColumnPath != nil
}

func (p *TSFetchMetadataReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetType bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Type is not set"));
  }
  return nil
}

func (p *TSFetchMetadataReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSFetchMetadataReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Type = v
}
  return nil
}

func (p *TSFetchMetadataReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.ColumnPath = &v
}
  return nil
}

func (p *TSFetchMetadataReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSFetchMetadataReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSFetchMetadataReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSFetchMetadataReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "type", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:type: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Type)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.type (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:type: ", p), err) }
  return err
}

func (p *TSFetchMetadataReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetColumnPath() {
    if err := oprot.WriteFieldBegin(ctx, "columnPath", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columnPath: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.ColumnPath)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.columnPath (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columnPath: ", p), err) }
  }
  return err
}

func (p *TSFetchMetadataReq) Equals(other *TSFetchMetadataReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Type != other.Type { return false }
  if p.ColumnPath != other.ColumnPath {
    if p.ColumnPath == nil || other.ColumnPath == nil {
      return false
    }
    if (*p.ColumnPath) != (*other.ColumnPath) { return false }
  }
  return true
}

func (p *TSFetchMetadataReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSFetchMetadataReq(%+v)", *p)
}

// Attributes:
//  - Status
//  - SystemStatus
type TSGetSystemStatusResp struct {
  Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  SystemStatus string `thrift:"systemStatus,2,required" db:"systemStatus" json:"systemStatus"`
}

func NewTSGetSystemStatusResp() *TSGetSystemStatusResp {
  return &TSGetSystemStatusResp{}
}

var TSGetSystemStatusResp_Status_DEFAULT *TSStatus
func (p *TSGetSystemStatusResp) GetStatus() *TSStatus {
  if !p.IsSetStatus() {
    return TSGetSystemStatusResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSGetSystemStatusResp) GetSystemStatus() string {
  return p.SystemStatus
}
func (p *TSGetSystemStatusResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSGetSystemStatusResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetSystemStatus bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetSystemStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetSystemStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SystemStatus is not set"));
  }
  return nil
}

func (p *TSGetSystemStatusResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSGetSystemStatusResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.SystemStatus = v
}
  return nil
}

func (p *TSGetSystemStatusResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSGetSystemStatusResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSGetSystemStatusResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSGetSystemStatusResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "systemStatus", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:systemStatus: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.SystemStatus)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.systemStatus (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:systemStatus: ", p), err) }
  return err
}

func (p *TSGetSystemStatusResp) Equals(other *TSGetSystemStatusResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.SystemStatus != other.SystemStatus { return false }
  return true
}

func (p *TSGetSystemStatusResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSGetSystemStatusResp(%+v)", *p)
}

// Attributes:
//  - Status
//  - TimeZone
type TSGetTimeZoneResp struct {
  Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  TimeZone string `thrift:"timeZone,2,required" db:"timeZone" json:"timeZone"`
}

func NewTSGetTimeZoneResp() *TSGetTimeZoneResp {
  return &TSGetTimeZoneResp{}
}

var TSGetTimeZoneResp_Status_DEFAULT *TSStatus
func (p *TSGetTimeZoneResp) GetStatus() *TSStatus {
  if !p.IsSetStatus() {
    return TSGetTimeZoneResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSGetTimeZoneResp) GetTimeZone() string {
  return p.TimeZone
}
func (p *TSGetTimeZoneResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSGetTimeZoneResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetTimeZone bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetTimeZone = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetTimeZone{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeZone is not set"));
  }
  return nil
}

func (p *TSGetTimeZoneResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSGetTimeZoneResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TimeZone = v
}
  return nil
}

func (p *TSGetTimeZoneResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSGetTimeZoneResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSGetTimeZoneResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSGetTimeZoneResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timeZone", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeZone: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TimeZone)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timeZone (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeZone: ", p), err) }
  return err
}

func (p *TSGetTimeZoneResp) Equals(other *TSGetTimeZoneResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.TimeZone != other.TimeZone { return false }
  return true
}

func (p *TSGetTimeZoneResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSGetTimeZoneResp(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - TimeZone
type TSSetTimeZoneReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  TimeZone string `thrift:"timeZone,2,required" db:"timeZone" json:"timeZone"`
}

func NewTSSetTimeZoneReq() *TSSetTimeZoneReq {
  return &TSSetTimeZoneReq{}
}


func (p *TSSetTimeZoneReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSSetTimeZoneReq) GetTimeZone() string {
  return p.TimeZone
}
func (p *TSSetTimeZoneReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetTimeZone bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetTimeZone = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetTimeZone{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeZone is not set"));
  }
  return nil
}

func (p *TSSetTimeZoneReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSSetTimeZoneReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TimeZone = v
}
  return nil
}

func (p *TSSetTimeZoneReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSSetTimeZoneReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSSetTimeZoneReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSSetTimeZoneReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timeZone", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeZone: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TimeZone)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timeZone (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeZone: ", p), err) }
  return err
}

func (p *TSSetTimeZoneReq) Equals(other *TSSetTimeZoneReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.TimeZone != other.TimeZone { return false }
  return true
}

func (p *TSSetTimeZoneReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSSetTimeZoneReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - Measurements
//  - Values
//  - Timestamp
//  - IsAligned
type TSInsertRecordReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
  Values []byte `thrift:"values,4,required" db:"values" json:"values"`
  Timestamp int64 `thrift:"timestamp,5,required" db:"timestamp" json:"timestamp"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertRecordReq() *TSInsertRecordReq {
  return &TSInsertRecordReq{}
}


func (p *TSInsertRecordReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertRecordReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertRecordReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSInsertRecordReq) GetValues() []byte {
  return p.Values
}

func (p *TSInsertRecordReq) GetTimestamp() int64 {
  return p.Timestamp
}
var TSInsertRecordReq_IsAligned_DEFAULT bool
func (p *TSInsertRecordReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertRecordReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertRecordReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertRecordReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurements bool = false;
  var issetValues bool = false;
  var issetTimestamp bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValues = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamp = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetValues{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
  }
  if !issetTimestamp{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamp is not set"));
  }
  return nil
}

func (p *TSInsertRecordReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertRecordReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertRecordReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem35 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem35 = v
}
    p.Measurements = append(p.Measurements, _elem35)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Values = v
}
  return nil
}

func (p *TSInsertRecordReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Timestamp = v
}
  return nil
}

func (p *TSInsertRecordReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertRecordReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertRecordReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertRecordReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "values", thrift.STRING, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Values); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.values (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamp", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamp: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Timestamp)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timestamp (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamp: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertRecordReq) Equals(other *TSInsertRecordReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src36 := other.Measurements[i]
    if _tgt != _src36 { return false }
  }
  if bytes.Compare(p.Values, other.Values) != 0 { return false }
  if p.Timestamp != other.Timestamp { return false }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertRecordReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertRecordReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - Measurements
//  - Values
//  - Timestamp
//  - IsAligned
type TSInsertStringRecordReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
  Values []string `thrift:"values,4,required" db:"values" json:"values"`
  Timestamp int64 `thrift:"timestamp,5,required" db:"timestamp" json:"timestamp"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertStringRecordReq() *TSInsertStringRecordReq {
  return &TSInsertStringRecordReq{}
}


func (p *TSInsertStringRecordReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertStringRecordReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertStringRecordReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSInsertStringRecordReq) GetValues() []string {
  return p.Values
}

func (p *TSInsertStringRecordReq) GetTimestamp() int64 {
  return p.Timestamp
}
var TSInsertStringRecordReq_IsAligned_DEFAULT bool
func (p *TSInsertStringRecordReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertStringRecordReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertStringRecordReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertStringRecordReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurements bool = false;
  var issetValues bool = false;
  var issetTimestamp bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValues = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamp = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetValues{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
  }
  if !issetTimestamp{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamp is not set"));
  }
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem37 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem37 = v
}
    p.Measurements = append(p.Measurements, _elem37)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Values =  tSlice
  for i := 0; i < size; i ++ {
var _elem38 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem38 = v
}
    p.Values = append(p.Values, _elem38)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Timestamp = v
}
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertStringRecordReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertStringRecordReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertStringRecordReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "values", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Values)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Values {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamp", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamp: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Timestamp)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timestamp (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamp: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertStringRecordReq) Equals(other *TSInsertStringRecordReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src39 := other.Measurements[i]
    if _tgt != _src39 { return false }
  }
  if len(p.Values) != len(other.Values) { return false }
  for i, _tgt := range p.Values {
    _src40 := other.Values[i]
    if _tgt != _src40 { return false }
  }
  if p.Timestamp != other.Timestamp { return false }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertStringRecordReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertStringRecordReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - Measurements
//  - Values
//  - Timestamps
//  - Types
//  - Size
//  - IsAligned
type TSInsertTabletReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
  Values []byte `thrift:"values,4,required" db:"values" json:"values"`
  Timestamps []byte `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  Types []int32 `thrift:"types,6,required" db:"types" json:"types"`
  Size int32 `thrift:"size,7,required" db:"size" json:"size"`
  IsAligned *bool `thrift:"isAligned,8" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertTabletReq() *TSInsertTabletReq {
  return &TSInsertTabletReq{}
}


func (p *TSInsertTabletReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertTabletReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertTabletReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSInsertTabletReq) GetValues() []byte {
  return p.Values
}

func (p *TSInsertTabletReq) GetTimestamps() []byte {
  return p.Timestamps
}

func (p *TSInsertTabletReq) GetTypes() []int32 {
  return p.Types
}

func (p *TSInsertTabletReq) GetSize() int32 {
  return p.Size
}
var TSInsertTabletReq_IsAligned_DEFAULT bool
func (p *TSInsertTabletReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertTabletReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertTabletReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertTabletReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurements bool = false;
  var issetValues bool = false;
  var issetTimestamps bool = false;
  var issetTypes bool = false;
  var issetSize bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValues = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetSize = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetValues{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  if !issetTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Types is not set"));
  }
  if !issetSize{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Size is not set"));
  }
  return nil
}

func (p *TSInsertTabletReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem41 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem41 = v
}
    p.Measurements = append(p.Measurements, _elem41)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Values = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Timestamps = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Types =  tSlice
  for i := 0; i < size; i ++ {
var _elem42 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem42 = v
}
    p.Types = append(p.Types, _elem42)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.Size = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertTabletReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertTabletReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertTabletReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "values", thrift.STRING, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Values); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.values (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.STRING, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Timestamps); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timestamps (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "types", thrift.LIST, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:types: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Types)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Types {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:types: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "size", thrift.I32, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:size: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Size)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.size (7) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:size: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertTabletReq) Equals(other *TSInsertTabletReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src43 := other.Measurements[i]
    if _tgt != _src43 { return false }
  }
  if bytes.Compare(p.Values, other.Values) != 0 { return false }
  if bytes.Compare(p.Timestamps, other.Timestamps) != 0 { return false }
  if len(p.Types) != len(other.Types) { return false }
  for i, _tgt := range p.Types {
    _src44 := other.Types[i]
    if _tgt != _src44 { return false }
  }
  if p.Size != other.Size { return false }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertTabletReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertTabletReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPaths
//  - MeasurementsList
//  - ValuesList
//  - TimestampsList
//  - TypesList
//  - SizeList
//  - IsAligned
type TSInsertTabletsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPaths []string `thrift:"prefixPaths,2,required" db:"prefixPaths" json:"prefixPaths"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  TimestampsList [][]byte `thrift:"timestampsList,5,required" db:"timestampsList" json:"timestampsList"`
  TypesList [][]int32 `thrift:"typesList,6,required" db:"typesList" json:"typesList"`
  SizeList []int32 `thrift:"sizeList,7,required" db:"sizeList" json:"sizeList"`
  IsAligned *bool `thrift:"isAligned,8" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertTabletsReq() *TSInsertTabletsReq {
  return &TSInsertTabletsReq{}
}


func (p *TSInsertTabletsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertTabletsReq) GetPrefixPaths() []string {
  return p.PrefixPaths
}

func (p *TSInsertTabletsReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertTabletsReq) GetValuesList() [][]byte {
  return p.ValuesList
}

func (p *TSInsertTabletsReq) GetTimestampsList() [][]byte {
  return p.TimestampsList
}

func (p *TSInsertTabletsReq) GetTypesList() [][]int32 {
  return p.TypesList
}

func (p *TSInsertTabletsReq) GetSizeList() []int32 {
  return p.SizeList
}
var TSInsertTabletsReq_IsAligned_DEFAULT bool
func (p *TSInsertTabletsReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertTabletsReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertTabletsReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertTabletsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPaths bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestampsList bool = false;
  var issetTypesList bool = false;
  var issetSizeList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestampsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetTypesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetSizeList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPaths is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestampsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimestampsList is not set"));
  }
  if !issetTypesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TypesList is not set"));
  }
  if !issetSizeList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SizeList is not set"));
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertTabletsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PrefixPaths =  tSlice
  for i := 0; i < size; i ++ {
var _elem45 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem45 = v
}
    p.PrefixPaths = append(p.PrefixPaths, _elem45)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem46 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem47 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem47 = v
}
      _elem46 = append(_elem46, _elem47)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem46)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
var _elem48 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem48 = v
}
    p.ValuesList = append(p.ValuesList, _elem48)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.TimestampsList =  tSlice
  for i := 0; i < size; i ++ {
var _elem49 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem49 = v
}
    p.TimestampsList = append(p.TimestampsList, _elem49)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]int32, 0, size)
  p.TypesList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]int32, 0, size)
    _elem50 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem51 int32
      if v, err := iprot.ReadI32(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem51 = v
}
      _elem50 = append(_elem50, _elem51)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.TypesList = append(p.TypesList, _elem50)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.SizeList =  tSlice
  for i := 0; i < size; i ++ {
var _elem52 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem52 = v
}
    p.SizeList = append(p.SizeList, _elem52)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertTabletsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertTabletsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertTabletsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPaths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPaths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PrefixPaths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PrefixPaths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPaths: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestampsList", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestampsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.TimestampsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.TimestampsList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestampsList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "typesList", thrift.LIST, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:typesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.TypesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.TypesList {
    if err := oprot.WriteListBegin(ctx, thrift.I32, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteI32(ctx, int32(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:typesList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sizeList", thrift.LIST, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:sizeList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.SizeList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.SizeList {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:sizeList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertTabletsReq) Equals(other *TSInsertTabletsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.PrefixPaths) != len(other.PrefixPaths) { return false }
  for i, _tgt := range p.PrefixPaths {
    _src53 := other.PrefixPaths[i]
    if _tgt != _src53 { return false }
  }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src54 := other.MeasurementsList[i]
    if len(_tgt) != len(_src54) { return false }
    for i, _tgt := range _tgt {
      _src55 := _src54[i]
      if _tgt != _src55 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src56 := other.ValuesList[i]
    if bytes.Compare(_tgt, _src56) != 0 { return false }
  }
  if len(p.TimestampsList) != len(other.TimestampsList) { return false }
  for i, _tgt := range p.TimestampsList {
    _src57 := other.TimestampsList[i]
    if bytes.Compare(_tgt, _src57) != 0 { return false }
  }
  if len(p.TypesList) != len(other.TypesList) { return false }
  for i, _tgt := range p.TypesList {
    _src58 := other.TypesList[i]
    if len(_tgt) != len(_src58) { return false }
    for i, _tgt := range _tgt {
      _src59 := _src58[i]
      if _tgt != _src59 { return false }
    }
  }
  if len(p.SizeList) != len(other.SizeList) { return false }
  for i, _tgt := range p.SizeList {
    _src60 := other.SizeList[i]
    if _tgt != _src60 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertTabletsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertTabletsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPaths
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
//  - IsAligned
type TSInsertRecordsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPaths []string `thrift:"prefixPaths,2,required" db:"prefixPaths" json:"prefixPaths"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertRecordsReq() *TSInsertRecordsReq {
  return &TSInsertRecordsReq{}
}


func (p *TSInsertRecordsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertRecordsReq) GetPrefixPaths() []string {
  return p.PrefixPaths
}

func (p *TSInsertRecordsReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertRecordsReq) GetValuesList() [][]byte {
  return p.ValuesList
}

func (p *TSInsertRecordsReq) GetTimestamps() []int64 {
  return p.Timestamps
}
var TSInsertRecordsReq_IsAligned_DEFAULT bool
func (p *TSInsertRecordsReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertRecordsReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertRecordsReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertRecordsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPaths bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestamps bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPaths is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertRecordsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PrefixPaths =  tSlice
  for i := 0; i < size; i ++ {
var _elem61 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem61 = v
}
    p.PrefixPaths = append(p.PrefixPaths, _elem61)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem62 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem63 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem63 = v
}
      _elem62 = append(_elem62, _elem63)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem62)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
var _elem64 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem64 = v
}
    p.ValuesList = append(p.ValuesList, _elem64)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem65 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem65 = v
}
    p.Timestamps = append(p.Timestamps, _elem65)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertRecordsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertRecordsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertRecordsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPaths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPaths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PrefixPaths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PrefixPaths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPaths: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertRecordsReq) Equals(other *TSInsertRecordsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.PrefixPaths) != len(other.PrefixPaths) { return false }
  for i, _tgt := range p.PrefixPaths {
    _src66 := other.PrefixPaths[i]
    if _tgt != _src66 { return false }
  }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src67 := other.MeasurementsList[i]
    if len(_tgt) != len(_src67) { return false }
    for i, _tgt := range _tgt {
      _src68 := _src67[i]
      if _tgt != _src68 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src69 := other.ValuesList[i]
    if bytes.Compare(_tgt, _src69) != 0 { return false }
  }
  if len(p.Timestamps) != len(other.Timestamps) { return false }
  for i, _tgt := range p.Timestamps {
    _src70 := other.Timestamps[i]
    if _tgt != _src70 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertRecordsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertRecordsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
//  - IsAligned
type TSInsertRecordsOfOneDeviceReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertRecordsOfOneDeviceReq() *TSInsertRecordsOfOneDeviceReq {
  return &TSInsertRecordsOfOneDeviceReq{}
}


func (p *TSInsertRecordsOfOneDeviceReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertRecordsOfOneDeviceReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertRecordsOfOneDeviceReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertRecordsOfOneDeviceReq) GetValuesList() [][]byte {
  return p.ValuesList
}

func (p *TSInsertRecordsOfOneDeviceReq) GetTimestamps() []int64 {
  return p.Timestamps
}
var TSInsertRecordsOfOneDeviceReq_IsAligned_DEFAULT bool
func (p *TSInsertRecordsOfOneDeviceReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertRecordsOfOneDeviceReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertRecordsOfOneDeviceReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertRecordsOfOneDeviceReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestamps bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem71 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem72 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem72 = v
}
      _elem71 = append(_elem71, _elem72)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem71)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
var _elem73 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem73 = v
}
    p.ValuesList = append(p.ValuesList, _elem73)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem74 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem74 = v
}
    p.Timestamps = append(p.Timestamps, _elem74)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertRecordsOfOneDeviceReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) Equals(other *TSInsertRecordsOfOneDeviceReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src75 := other.MeasurementsList[i]
    if len(_tgt) != len(_src75) { return false }
    for i, _tgt := range _tgt {
      _src76 := _src75[i]
      if _tgt != _src76 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src77 := other.ValuesList[i]
    if bytes.Compare(_tgt, _src77) != 0 { return false }
  }
  if len(p.Timestamps) != len(other.Timestamps) { return false }
  for i, _tgt := range p.Timestamps {
    _src78 := other.Timestamps[i]
    if _tgt != _src78 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertRecordsOfOneDeviceReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertRecordsOfOneDeviceReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
//  - IsAligned
type TSInsertStringRecordsOfOneDeviceReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]string `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertStringRecordsOfOneDeviceReq() *TSInsertStringRecordsOfOneDeviceReq {
  return &TSInsertStringRecordsOfOneDeviceReq{}
}


func (p *TSInsertStringRecordsOfOneDeviceReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertStringRecordsOfOneDeviceReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertStringRecordsOfOneDeviceReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertStringRecordsOfOneDeviceReq) GetValuesList() [][]string {
  return p.ValuesList
}

func (p *TSInsertStringRecordsOfOneDeviceReq) GetTimestamps() []int64 {
  return p.Timestamps
}
var TSInsertStringRecordsOfOneDeviceReq_IsAligned_DEFAULT bool
func (p *TSInsertStringRecordsOfOneDeviceReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertStringRecordsOfOneDeviceReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertStringRecordsOfOneDeviceReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestamps bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem79 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem80 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem80 = v
}
      _elem79 = append(_elem79, _elem80)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem79)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem81 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem82 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem82 = v
}
      _elem81 = append(_elem81, _elem82)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.ValuesList = append(p.ValuesList, _elem81)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem83 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem83 = v
}
    p.Timestamps = append(p.Timestamps, _elem83)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertStringRecordsOfOneDeviceReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) Equals(other *TSInsertStringRecordsOfOneDeviceReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src84 := other.MeasurementsList[i]
    if len(_tgt) != len(_src84) { return false }
    for i, _tgt := range _tgt {
      _src85 := _src84[i]
      if _tgt != _src85 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src86 := other.ValuesList[i]
    if len(_tgt) != len(_src86) { return false }
    for i, _tgt := range _tgt {
      _src87 := _src86[i]
      if _tgt != _src87 { return false }
    }
  }
  if len(p.Timestamps) != len(other.Timestamps) { return false }
  for i, _tgt := range p.Timestamps {
    _src88 := other.Timestamps[i]
    if _tgt != _src88 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertStringRecordsOfOneDeviceReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertStringRecordsOfOneDeviceReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPaths
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
//  - IsAligned
type TSInsertStringRecordsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPaths []string `thrift:"prefixPaths,2,required" db:"prefixPaths" json:"prefixPaths"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]string `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertStringRecordsReq() *TSInsertStringRecordsReq {
  return &TSInsertStringRecordsReq{}
}


func (p *TSInsertStringRecordsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertStringRecordsReq) GetPrefixPaths() []string {
  return p.PrefixPaths
}

func (p *TSInsertStringRecordsReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertStringRecordsReq) GetValuesList() [][]string {
  return p.ValuesList
}

func (p *TSInsertStringRecordsReq) GetTimestamps() []int64 {
  return p.Timestamps
}
var TSInsertStringRecordsReq_IsAligned_DEFAULT bool
func (p *TSInsertStringRecordsReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertStringRecordsReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertStringRecordsReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertStringRecordsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPaths bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestamps bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPaths is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PrefixPaths =  tSlice
  for i := 0; i < size; i ++ {
var _elem89 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem89 = v
}
    p.PrefixPaths = append(p.PrefixPaths, _elem89)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem90 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem91 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem91 = v
}
      _elem90 = append(_elem90, _elem91)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem90)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem92 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem93 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem93 = v
}
      _elem92 = append(_elem92, _elem93)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.ValuesList = append(p.ValuesList, _elem92)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem94 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem94 = v
}
    p.Timestamps = append(p.Timestamps, _elem94)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertStringRecordsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertStringRecordsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertStringRecordsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPaths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPaths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PrefixPaths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PrefixPaths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPaths: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertStringRecordsReq) Equals(other *TSInsertStringRecordsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.PrefixPaths) != len(other.PrefixPaths) { return false }
  for i, _tgt := range p.PrefixPaths {
    _src95 := other.PrefixPaths[i]
    if _tgt != _src95 { return false }
  }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src96 := other.MeasurementsList[i]
    if len(_tgt) != len(_src96) { return false }
    for i, _tgt := range _tgt {
      _src97 := _src96[i]
      if _tgt != _src97 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src98 := other.ValuesList[i]
    if len(_tgt) != len(_src98) { return false }
    for i, _tgt := range _tgt {
      _src99 := _src98[i]
      if _tgt != _src99 { return false }
    }
  }
  if len(p.Timestamps) != len(other.Timestamps) { return false }
  for i, _tgt := range p.Timestamps {
    _src100 := other.Timestamps[i]
    if _tgt != _src100 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertStringRecordsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertStringRecordsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - StartTime
//  - EndTime
type TSDeleteDataReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
  StartTime int64 `thrift:"startTime,3,required" db:"startTime" json:"startTime"`
  EndTime int64 `thrift:"endTime,4,required" db:"endTime" json:"endTime"`
}

func NewTSDeleteDataReq() *TSDeleteDataReq {
  return &TSDeleteDataReq{}
}


func (p *TSDeleteDataReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSDeleteDataReq) GetPaths() []string {
  return p.Paths
}

func (p *TSDeleteDataReq) GetStartTime() int64 {
  return p.StartTime
}

func (p *TSDeleteDataReq) GetEndTime() int64 {
  return p.EndTime
}
func (p *TSDeleteDataReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPaths bool = false;
  var issetStartTime bool = false;
  var issetEndTime bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetStartTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetEndTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetStartTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StartTime is not set"));
  }
  if !issetEndTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EndTime is not set"));
  }
  return nil
}

func (p *TSDeleteDataReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSDeleteDataReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem101 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem101 = v
}
    p.Paths = append(p.Paths, _elem101)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDeleteDataReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.StartTime = v
}
  return nil
}

func (p *TSDeleteDataReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.EndTime = v
}
  return nil
}

func (p *TSDeleteDataReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSDeleteDataReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDeleteDataReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSDeleteDataReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSDeleteDataReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:startTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startTime (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:startTime: ", p), err) }
  return err
}

func (p *TSDeleteDataReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:endTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.endTime (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:endTime: ", p), err) }
  return err
}

func (p *TSDeleteDataReq) Equals(other *TSDeleteDataReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src102 := other.Paths[i]
    if _tgt != _src102 { return false }
  }
  if p.StartTime != other.StartTime { return false }
  if p.EndTime != other.EndTime { return false }
  return true
}

func (p *TSDeleteDataReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDeleteDataReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Path
//  - DataType
//  - Encoding
//  - Compressor
//  - Props
//  - Tags
//  - Attributes
//  - MeasurementAlias
type TSCreateTimeseriesReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Path string `thrift:"path,2,required" db:"path" json:"path"`
  DataType int32 `thrift:"dataType,3,required" db:"dataType" json:"dataType"`
  Encoding int32 `thrift:"encoding,4,required" db:"encoding" json:"encoding"`
  Compressor int32 `thrift:"compressor,5,required" db:"compressor" json:"compressor"`
  Props map[string]string `thrift:"props,6" db:"props" json:"props,omitempty"`
  Tags map[string]string `thrift:"tags,7" db:"tags" json:"tags,omitempty"`
  Attributes map[string]string `thrift:"attributes,8" db:"attributes" json:"attributes,omitempty"`
  MeasurementAlias *string `thrift:"measurementAlias,9" db:"measurementAlias" json:"measurementAlias,omitempty"`
}

func NewTSCreateTimeseriesReq() *TSCreateTimeseriesReq {
  return &TSCreateTimeseriesReq{}
}


func (p *TSCreateTimeseriesReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateTimeseriesReq) GetPath() string {
  return p.Path
}

func (p *TSCreateTimeseriesReq) GetDataType() int32 {
  return p.DataType
}

func (p *TSCreateTimeseriesReq) GetEncoding() int32 {
  return p.Encoding
}

func (p *TSCreateTimeseriesReq) GetCompressor() int32 {
  return p.Compressor
}
var TSCreateTimeseriesReq_Props_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetProps() map[string]string {
  return p.Props
}
var TSCreateTimeseriesReq_Tags_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetTags() map[string]string {
  return p.Tags
}
var TSCreateTimeseriesReq_Attributes_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetAttributes() map[string]string {
  return p.Attributes
}
var TSCreateTimeseriesReq_MeasurementAlias_DEFAULT string
func (p *TSCreateTimeseriesReq) GetMeasurementAlias() string {
  if !p.IsSetMeasurementAlias() {
    return TSCreateTimeseriesReq_MeasurementAlias_DEFAULT
  }
return *p.MeasurementAlias
}
func (p *TSCreateTimeseriesReq) IsSetProps() bool {
  return p.Props != nil
}

func (p *TSCreateTimeseriesReq) IsSetTags() bool {
  return p.Tags != nil
}

func (p *TSCreateTimeseriesReq) IsSetAttributes() bool {
  return p.Attributes != nil
}

func (p *TSCreateTimeseriesReq) IsSetMeasurementAlias() bool {
  return p.MeasurementAlias != nil
}

func (p *TSCreateTimeseriesReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPath bool = false;
  var issetDataType bool = false;
  var issetEncoding bool = false;
  var issetCompressor bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetDataType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetEncoding = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetCompressor = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  if !issetDataType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataType is not set"));
  }
  if !issetEncoding{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encoding is not set"));
  }
  if !issetCompressor{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressor is not set"));
  }
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.DataType = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Encoding = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Compressor = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Props =  tMap
  for i := 0; i < size; i ++ {
var _key103 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key103 = v
}
var _val104 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val104 = v
}
    p.Props[_key103] = _val104
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Tags =  tMap
  for i := 0; i < size; i ++ {
var _key105 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key105 = v
}
var _val106 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val106 = v
}
    p.Tags[_key105] = _val106
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Attributes =  tMap
  for i := 0; i < size; i ++ {
var _key107 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key107 = v
}
var _val108 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val108 = v
}
    p.Attributes[_key107] = _val108
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.MeasurementAlias = &v
}
  return nil
}

func (p *TSCreateTimeseriesReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateTimeseriesReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateTimeseriesReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataType", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:dataType: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DataType)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.dataType (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:dataType: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "encoding", thrift.I32, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:encoding: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Encoding)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.encoding (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:encoding: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "compressor", thrift.I32, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:compressor: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Compressor)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.compressor (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:compressor: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetProps() {
    if err := oprot.WriteFieldBegin(ctx, "props", thrift.MAP, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:props: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Props)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Props {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:props: ", p), err) }
  }
  return err
}

func (p *TSCreateTimeseriesReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTags() {
    if err := oprot.WriteFieldBegin(ctx, "tags", thrift.MAP, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:tags: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Tags)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Tags {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:tags: ", p), err) }
  }
  return err
}

func (p *TSCreateTimeseriesReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetAttributes() {
    if err := oprot.WriteFieldBegin(ctx, "attributes", thrift.MAP, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:attributes: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Attributes)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Attributes {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:attributes: ", p), err) }
  }
  return err
}

func (p *TSCreateTimeseriesReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurementAlias() {
    if err := oprot.WriteFieldBegin(ctx, "measurementAlias", thrift.STRING, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:measurementAlias: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.MeasurementAlias)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.measurementAlias (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:measurementAlias: ", p), err) }
  }
  return err
}

func (p *TSCreateTimeseriesReq) Equals(other *TSCreateTimeseriesReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Path != other.Path { return false }
  if p.DataType != other.DataType { return false }
  if p.Encoding != other.Encoding { return false }
  if p.Compressor != other.Compressor { return false }
  if len(p.Props) != len(other.Props) { return false }
  for k, _tgt := range p.Props {
    _src109 := other.Props[k]
    if _tgt != _src109 { return false }
  }
  if len(p.Tags) != len(other.Tags) { return false }
  for k, _tgt := range p.Tags {
    _src110 := other.Tags[k]
    if _tgt != _src110 { return false }
  }
  if len(p.Attributes) != len(other.Attributes) { return false }
  for k, _tgt := range p.Attributes {
    _src111 := other.Attributes[k]
    if _tgt != _src111 { return false }
  }
  if p.MeasurementAlias != other.MeasurementAlias {
    if p.MeasurementAlias == nil || other.MeasurementAlias == nil {
      return false
    }
    if (*p.MeasurementAlias) != (*other.MeasurementAlias) { return false }
  }
  return true
}

func (p *TSCreateTimeseriesReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateTimeseriesReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - Measurements
//  - DataTypes
//  - Encodings
//  - Compressors
//  - MeasurementAlias
type TSCreateAlignedTimeseriesReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
  DataTypes []int32 `thrift:"dataTypes,4,required" db:"dataTypes" json:"dataTypes"`
  Encodings []int32 `thrift:"encodings,5,required" db:"encodings" json:"encodings"`
  Compressors []int32 `thrift:"compressors,6,required" db:"compressors" json:"compressors"`
  MeasurementAlias []string `thrift:"measurementAlias,7" db:"measurementAlias" json:"measurementAlias,omitempty"`
}

func NewTSCreateAlignedTimeseriesReq() *TSCreateAlignedTimeseriesReq {
  return &TSCreateAlignedTimeseriesReq{}
}


func (p *TSCreateAlignedTimeseriesReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateAlignedTimeseriesReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSCreateAlignedTimeseriesReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSCreateAlignedTimeseriesReq) GetDataTypes() []int32 {
  return p.DataTypes
}

func (p *TSCreateAlignedTimeseriesReq) GetEncodings() []int32 {
  return p.Encodings
}

func (p *TSCreateAlignedTimeseriesReq) GetCompressors() []int32 {
  return p.Compressors
}
var TSCreateAlignedTimeseriesReq_MeasurementAlias_DEFAULT []string

func (p *TSCreateAlignedTimeseriesReq) GetMeasurementAlias() []string {
  return p.MeasurementAlias
}
func (p *TSCreateAlignedTimeseriesReq) IsSetMeasurementAlias() bool {
  return p.MeasurementAlias != nil
}

func (p *TSCreateAlignedTimeseriesReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurements bool = false;
  var issetDataTypes bool = false;
  var issetEncodings bool = false;
  var issetCompressors bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetDataTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetEncodings = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetCompressors = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetDataTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypes is not set"));
  }
  if !issetEncodings{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encodings is not set"));
  }
  if !issetCompressors{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressors is not set"));
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem112 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem112 = v
}
    p.Measurements = append(p.Measurements, _elem112)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.DataTypes =  tSlice
  for i := 0; i < size; i ++ {
var _elem113 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem113 = v
}
    p.DataTypes = append(p.DataTypes, _elem113)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Encodings =  tSlice
  for i := 0; i < size; i ++ {
var _elem114 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem114 = v
}
    p.Encodings = append(p.Encodings, _elem114)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Compressors =  tSlice
  for i := 0; i < size; i ++ {
var _elem115 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem115 = v
}
    p.Compressors = append(p.Compressors, _elem115)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.MeasurementAlias =  tSlice
  for i := 0; i < size; i ++ {
var _elem116 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem116 = v
}
    p.MeasurementAlias = append(p.MeasurementAlias, _elem116)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateAlignedTimeseriesReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypes", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:dataTypes: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypes)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypes {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:dataTypes: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "encodings", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:encodings: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Encodings)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Encodings {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:encodings: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "compressors", thrift.LIST, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:compressors: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Compressors)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Compressors {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:compressors: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurementAlias() {
    if err := oprot.WriteFieldBegin(ctx, "measurementAlias", thrift.LIST, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:measurementAlias: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.MeasurementAlias)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.MeasurementAlias {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:measurementAlias: ", p), err) }
  }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) Equals(other *TSCreateAlignedTimeseriesReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src117 := other.Measurements[i]
    if _tgt != _src117 { return false }
  }
  if len(p.DataTypes) != len(other.DataTypes) { return false }
  for i, _tgt := range p.DataTypes {
    _src118 := other.DataTypes[i]
    if _tgt != _src118 { return false }
  }
  if len(p.Encodings) != len(other.Encodings) { return false }
  for i, _tgt := range p.Encodings {
    _src119 := other.Encodings[i]
    if _tgt != _src119 { return false }
  }
  if len(p.Compressors) != len(other.Compressors) { return false }
  for i, _tgt := range p.Compressors {
    _src120 := other.Compressors[i]
    if _tgt != _src120 { return false }
  }
  if len(p.MeasurementAlias) != len(other.MeasurementAlias) { return false }
  for i, _tgt := range p.MeasurementAlias {
    _src121 := other.MeasurementAlias[i]
    if _tgt != _src121 { return false }
  }
  return true
}

func (p *TSCreateAlignedTimeseriesReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateAlignedTimeseriesReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - FetchSize
//  - StartTime
//  - EndTime
//  - StatementId
//  - EnableRedirectQuery
//  - JdbcQuery
type TSRawDataQueryReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
  FetchSize *int32 `thrift:"fetchSize,3" db:"fetchSize" json:"fetchSize,omitempty"`
  StartTime int64 `thrift:"startTime,4,required" db:"startTime" json:"startTime"`
  EndTime int64 `thrift:"endTime,5,required" db:"endTime" json:"endTime"`
  StatementId int64 `thrift:"statementId,6,required" db:"statementId" json:"statementId"`
  EnableRedirectQuery *bool `thrift:"enableRedirectQuery,7" db:"enableRedirectQuery" json:"enableRedirectQuery,omitempty"`
  JdbcQuery *bool `thrift:"jdbcQuery,8" db:"jdbcQuery" json:"jdbcQuery,omitempty"`
}

func NewTSRawDataQueryReq() *TSRawDataQueryReq {
  return &TSRawDataQueryReq{}
}


func (p *TSRawDataQueryReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSRawDataQueryReq) GetPaths() []string {
  return p.Paths
}
var TSRawDataQueryReq_FetchSize_DEFAULT int32
func (p *TSRawDataQueryReq) GetFetchSize() int32 {
  if !p.IsSetFetchSize() {
    return TSRawDataQueryReq_FetchSize_DEFAULT
  }
return *p.FetchSize
}

func (p *TSRawDataQueryReq) GetStartTime() int64 {
  return p.StartTime
}

func (p *TSRawDataQueryReq) GetEndTime() int64 {
  return p.EndTime
}

func (p *TSRawDataQueryReq) GetStatementId() int64 {
  return p.StatementId
}
var TSRawDataQueryReq_EnableRedirectQuery_DEFAULT bool
func (p *TSRawDataQueryReq) GetEnableRedirectQuery() bool {
  if !p.IsSetEnableRedirectQuery() {
    return TSRawDataQueryReq_EnableRedirectQuery_DEFAULT
  }
return *p.EnableRedirectQuery
}
var TSRawDataQueryReq_JdbcQuery_DEFAULT bool
func (p *TSRawDataQueryReq) GetJdbcQuery() bool {
  if !p.IsSetJdbcQuery() {
    return TSRawDataQueryReq_JdbcQuery_DEFAULT
  }
return *p.JdbcQuery
}
func (p *TSRawDataQueryReq) IsSetFetchSize() bool {
  return p.FetchSize != nil
}

func (p *TSRawDataQueryReq) IsSetEnableRedirectQuery() bool {
  return p.EnableRedirectQuery != nil
}

func (p *TSRawDataQueryReq) IsSetJdbcQuery() bool {
  return p.JdbcQuery != nil
}

func (p *TSRawDataQueryReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPaths bool = false;
  var issetStartTime bool = false;
  var issetEndTime bool = false;
  var issetStatementId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetStartTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetEndTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetStatementId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetStartTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StartTime is not set"));
  }
  if !issetEndTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EndTime is not set"));
  }
  if !issetStatementId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
  }
  return nil
}

func (p *TSRawDataQueryReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem122 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem122 = v
}
    p.Paths = append(p.Paths, _elem122)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSRawDataQueryReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.FetchSize = &v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.StartTime = v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.EndTime = v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.StatementId = v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.EnableRedirectQuery = &v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.JdbcQuery = &v
}
  return nil
}

func (p *TSRawDataQueryReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSRawDataQueryReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSRawDataQueryReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFetchSize() {
    if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:fetchSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.fetchSize (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:fetchSize: ", p), err) }
  }
  return err
}

func (p *TSRawDataQueryReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:startTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startTime (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:startTime: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:endTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.endTime (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:endTime: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:statementId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statementId (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:statementId: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetEnableRedirectQuery() {
    if err := oprot.WriteFieldBegin(ctx, "enableRedirectQuery", thrift.BOOL, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:enableRedirectQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.EnableRedirectQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.enableRedirectQuery (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:enableRedirectQuery: ", p), err) }
  }
  return err
}

func (p *TSRawDataQueryReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetJdbcQuery() {
    if err := oprot.WriteFieldBegin(ctx, "jdbcQuery", thrift.BOOL, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:jdbcQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.JdbcQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.jdbcQuery (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:jdbcQuery: ", p), err) }
  }
  return err
}

func (p *TSRawDataQueryReq) Equals(other *TSRawDataQueryReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src123 := other.Paths[i]
    if _tgt != _src123 { return false }
  }
  if p.FetchSize != other.FetchSize {
    if p.FetchSize == nil || other.FetchSize == nil {
      return false
    }
    if (*p.FetchSize) != (*other.FetchSize) { return false }
  }
  if p.StartTime != other.StartTime { return false }
  if p.EndTime != other.EndTime { return false }
  if p.StatementId != other.StatementId { return false }
  if p.EnableRedirectQuery != other.EnableRedirectQuery {
    if p.EnableRedirectQuery == nil || other.EnableRedirectQuery == nil {
      return false
    }
    if (*p.EnableRedirectQuery) != (*other.EnableRedirectQuery) { return false }
  }
  if p.JdbcQuery != other.JdbcQuery {
    if p.JdbcQuery == nil || other.JdbcQuery == nil {
      return false
    }
    if (*p.JdbcQuery) != (*other.JdbcQuery) { return false }
  }
  return true
}

func (p *TSRawDataQueryReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSRawDataQueryReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - FetchSize
//  - Time
//  - StatementId
//  - EnableRedirectQuery
//  - JdbcQuery
type TSLastDataQueryReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
  FetchSize *int32 `thrift:"fetchSize,3" db:"fetchSize" json:"fetchSize,omitempty"`
  Time int64 `thrift:"time,4,required" db:"time" json:"time"`
  StatementId int64 `thrift:"statementId,5,required" db:"statementId" json:"statementId"`
  EnableRedirectQuery *bool `thrift:"enableRedirectQuery,6" db:"enableRedirectQuery" json:"enableRedirectQuery,omitempty"`
  JdbcQuery *bool `thrift:"jdbcQuery,7" db:"jdbcQuery" json:"jdbcQuery,omitempty"`
}

func NewTSLastDataQueryReq() *TSLastDataQueryReq {
  return &TSLastDataQueryReq{}
}


func (p *TSLastDataQueryReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSLastDataQueryReq) GetPaths() []string {
  return p.Paths
}
var TSLastDataQueryReq_FetchSize_DEFAULT int32
func (p *TSLastDataQueryReq) GetFetchSize() int32 {
  if !p.IsSetFetchSize() {
    return TSLastDataQueryReq_FetchSize_DEFAULT
  }
return *p.FetchSize
}

func (p *TSLastDataQueryReq) GetTime() int64 {
  return p.Time
}

func (p *TSLastDataQueryReq) GetStatementId() int64 {
  return p.StatementId
}
var TSLastDataQueryReq_EnableRedirectQuery_DEFAULT bool
func (p *TSLastDataQueryReq) GetEnableRedirectQuery() bool {
  if !p.IsSetEnableRedirectQuery() {
    return TSLastDataQueryReq_EnableRedirectQuery_DEFAULT
  }
return *p.EnableRedirectQuery
}
var TSLastDataQueryReq_JdbcQuery_DEFAULT bool
func (p *TSLastDataQueryReq) GetJdbcQuery() bool {
  if !p.IsSetJdbcQuery() {
    return TSLastDataQueryReq_JdbcQuery_DEFAULT
  }
return *p.JdbcQuery
}
func (p *TSLastDataQueryReq) IsSetFetchSize() bool {
  return p.FetchSize != nil
}

func (p *TSLastDataQueryReq) IsSetEnableRedirectQuery() bool {
  return p.EnableRedirectQuery != nil
}

func (p *TSLastDataQueryReq) IsSetJdbcQuery() bool {
  return p.JdbcQuery != nil
}

func (p *TSLastDataQueryReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPaths bool = false;
  var issetTime bool = false;
  var issetStatementId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetStatementId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Time is not set"));
  }
  if !issetStatementId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
  }
  return nil
}

func (p *TSLastDataQueryReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem124 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem124 = v
}
    p.Paths = append(p.Paths, _elem124)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSLastDataQueryReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.FetchSize = &v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Time = v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.StatementId = v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.EnableRedirectQuery = &v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.JdbcQuery = &v
}
  return nil
}

func (p *TSLastDataQueryReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSLastDataQueryReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSLastDataQueryReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSLastDataQueryReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSLastDataQueryReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFetchSize() {
    if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:fetchSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.fetchSize (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:fetchSize: ", p), err) }
  }
  return err
}

func (p *TSLastDataQueryReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "time", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:time: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Time)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.time (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:time: ", p), err) }
  return err
}

func (p *TSLastDataQueryReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:statementId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statementId (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:statementId: ", p), err) }
  return err
}

func (p *TSLastDataQueryReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetEnableRedirectQuery() {
    if err := oprot.WriteFieldBegin(ctx, "enableRedirectQuery", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:enableRedirectQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.EnableRedirectQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.enableRedirectQuery (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:enableRedirectQuery: ", p), err) }
  }
  return err
}

func (p *TSLastDataQueryReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetJdbcQuery() {
    if err := oprot.WriteFieldBegin(ctx, "jdbcQuery", thrift.BOOL, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:jdbcQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.JdbcQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.jdbcQuery (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:jdbcQuery: ", p), err) }
  }
  return err
}

func (p *TSLastDataQueryReq) Equals(other *TSLastDataQueryReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src125 := other.Paths[i]
    if _tgt != _src125 { return false }
  }
  if p.FetchSize != other.FetchSize {
    if p.FetchSize == nil || other.FetchSize == nil {
      return false
    }
    if (*p.FetchSize) != (*other.FetchSize) { return false }
  }
  if p.Time != other.Time { return false }
  if p.StatementId != other.StatementId { return false }
  if p.EnableRedirectQuery != other.EnableRedirectQuery {
    if p.EnableRedirectQuery == nil || other.EnableRedirectQuery == nil {
      return false
    }
    if (*p.EnableRedirectQuery) != (*other.EnableRedirectQuery) { return false }
  }
  if p.JdbcQuery != other.JdbcQuery {
    if p.JdbcQuery == nil || other.JdbcQuery == nil {
      return false
    }
    if (*p.JdbcQuery) != (*other.JdbcQuery) { return false }
  }
  return true
}

func (p *TSLastDataQueryReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSLastDataQueryReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - DataTypes
//  - Encodings
//  - Compressors
//  - PropsList
//  - TagsList
//  - AttributesList
//  - MeasurementAliasList
type TSCreateMultiTimeseriesReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
  DataTypes []int32 `thrift:"dataTypes,3,required" db:"dataTypes" json:"dataTypes"`
  Encodings []int32 `thrift:"encodings,4,required" db:"encodings" json:"encodings"`
  Compressors []int32 `thrift:"compressors,5,required" db:"compressors" json:"compressors"`
  PropsList []map[string]string `thrift:"propsList,6" db:"propsList" json:"propsList,omitempty"`
  TagsList []map[string]string `thrift:"tagsList,7" db:"tagsList" json:"tagsList,omitempty"`
  AttributesList []map[string]string `thrift:"attributesList,8" db:"attributesList" json:"attributesList,omitempty"`
  MeasurementAliasList []string `thrift:"measurementAliasList,9" db:"measurementAliasList" json:"measurementAliasList,omitempty"`
}

func NewTSCreateMultiTimeseriesReq() *TSCreateMultiTimeseriesReq {
  return &TSCreateMultiTimeseriesReq{}
}


func (p *TSCreateMultiTimeseriesReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateMultiTimeseriesReq) GetPaths() []string {
  return p.Paths
}

func (p *TSCreateMultiTimeseriesReq) GetDataTypes() []int32 {
  return p.DataTypes
}

func (p *TSCreateMultiTimeseriesReq) GetEncodings() []int32 {
  return p.Encodings
}

func (p *TSCreateMultiTimeseriesReq) GetCompressors() []int32 {
  return p.Compressors
}
var TSCreateMultiTimeseriesReq_PropsList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetPropsList() []map[string]string {
  return p.PropsList
}
var TSCreateMultiTimeseriesReq_TagsList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetTagsList() []map[string]string {
  return p.TagsList
}
var TSCreateMultiTimeseriesReq_AttributesList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetAttributesList() []map[string]string {
  return p.AttributesList
}
var TSCreateMultiTimeseriesReq_MeasurementAliasList_DEFAULT []string

func (p *TSCreateMultiTimeseriesReq) GetMeasurementAliasList() []string {
  return p.MeasurementAliasList
}
func (p *TSCreateMultiTimeseriesReq) IsSetPropsList() bool {
  return p.PropsList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetTagsList() bool {
  return p.TagsList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetAttributesList() bool {
  return p.AttributesList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetMeasurementAliasList() bool {
  return p.MeasurementAliasList != nil
}

func (p *TSCreateMultiTimeseriesReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPaths bool = false;
  var issetDataTypes bool = false;
  var issetEncodings bool = false;
  var issetCompressors bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetDataTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetEncodings = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetCompressors = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetDataTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypes is not set"));
  }
  if !issetEncodings{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encodings is not set"));
  }
  if !issetCompressors{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressors is not set"));
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem126 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem126 = v
}
    p.Paths = append(p.Paths, _elem126)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.DataTypes =  tSlice
  for i := 0; i < size; i ++ {
var _elem127 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem127 = v
}
    p.DataTypes = append(p.DataTypes, _elem127)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Encodings =  tSlice
  for i := 0; i < size; i ++ {
var _elem128 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem128 = v
}
    p.Encodings = append(p.Encodings, _elem128)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Compressors =  tSlice
  for i := 0; i < size; i ++ {
var _elem129 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem129 = v
}
    p.Compressors = append(p.Compressors, _elem129)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]map[string]string, 0, size)
  p.PropsList =  tSlice
  for i := 0; i < size; i ++ {
    _, _, size, err := iprot.ReadMapBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading map begin: ", err)
    }
    tMap := make(map[string]string, size)
    _elem130 :=  tMap
    for i := 0; i < size; i ++ {
var _key131 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _key131 = v
}
var _val132 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _val132 = v
}
      _elem130[_key131] = _val132
    }
    if err := iprot.ReadMapEnd(ctx); err != nil {
      return thrift.PrependError("error reading map end: ", err)
    }
    p.PropsList = append(p.PropsList, _elem130)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]map[string]string, 0, size)
  p.TagsList =  tSlice
  for i := 0; i < size; i ++ {
    _, _, size, err := iprot.ReadMapBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading map begin: ", err)
    }
    tMap := make(map[string]string, size)
    _elem133 :=  tMap
    for i := 0; i < size; i ++ {
var _key134 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _key134 = v
}
var _val135 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _val135 = v
}
      _elem133[_key134] = _val135
    }
    if err := iprot.ReadMapEnd(ctx); err != nil {
      return thrift.PrependError("error reading map end: ", err)
    }
    p.TagsList = append(p.TagsList, _elem133)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]map[string]string, 0, size)
  p.AttributesList =  tSlice
  for i := 0; i < size; i ++ {
    _, _, size, err := iprot.ReadMapBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading map begin: ", err)
    }
    tMap := make(map[string]string, size)
    _elem136 :=  tMap
    for i := 0; i < size; i ++ {
var _key137 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _key137 = v
}
var _val138 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _val138 = v
}
      _elem136[_key137] = _val138
    }
    if err := iprot.ReadMapEnd(ctx); err != nil {
      return thrift.PrependError("error reading map end: ", err)
    }
    p.AttributesList = append(p.AttributesList, _elem136)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.MeasurementAliasList =  tSlice
  for i := 0; i < size; i ++ {
var _elem139 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem139 = v
}
    p.MeasurementAliasList = append(p.MeasurementAliasList, _elem139)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateMultiTimeseriesReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateMultiTimeseriesReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypes", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:dataTypes: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypes)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypes {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:dataTypes: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "encodings", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:encodings: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Encodings)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Encodings {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:encodings: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "compressors", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:compressors: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Compressors)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Compressors {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:compressors: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetPropsList() {
    if err := oprot.WriteFieldBegin(ctx, "propsList", thrift.LIST, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:propsList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.PropsList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.PropsList {
      if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
        return thrift.PrependError("error writing map begin: ", err)
      }
      for k, v := range v {
        if err := oprot.WriteString(ctx, string(k)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
        if err := oprot.WriteString(ctx, string(v)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      }
      if err := oprot.WriteMapEnd(ctx); err != nil {
        return thrift.PrependError("error writing map end: ", err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:propsList: ", p), err) }
  }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTagsList() {
    if err := oprot.WriteFieldBegin(ctx, "tagsList", thrift.LIST, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:tagsList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.TagsList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.TagsList {
      if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
        return thrift.PrependError("error writing map begin: ", err)
      }
      for k, v := range v {
        if err := oprot.WriteString(ctx, string(k)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
        if err := oprot.WriteString(ctx, string(v)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      }
      if err := oprot.WriteMapEnd(ctx); err != nil {
        return thrift.PrependError("error writing map end: ", err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:tagsList: ", p), err) }
  }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetAttributesList() {
    if err := oprot.WriteFieldBegin(ctx, "attributesList", thrift.LIST, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:attributesList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.AttributesList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.AttributesList {
      if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
        return thrift.PrependError("error writing map begin: ", err)
      }
      for k, v := range v {
        if err := oprot.WriteString(ctx, string(k)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
        if err := oprot.WriteString(ctx, string(v)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      }
      if err := oprot.WriteMapEnd(ctx); err != nil {
        return thrift.PrependError("error writing map end: ", err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:attributesList: ", p), err) }
  }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurementAliasList() {
    if err := oprot.WriteFieldBegin(ctx, "measurementAliasList", thrift.LIST, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:measurementAliasList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.MeasurementAliasList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.MeasurementAliasList {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:measurementAliasList: ", p), err) }
  }
  return err
}

func (p *TSCreateMultiTimeseriesReq) Equals(other *TSCreateMultiTimeseriesReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src140 := other.Paths[i]
    if _tgt != _src140 { return false }
  }
  if len(p.DataTypes) != len(other.DataTypes) { return false }
  for i, _tgt := range p.DataTypes {
    _src141 := other.DataTypes[i]
    if _tgt != _src141 { return false }
  }
  if len(p.Encodings) != len(other.Encodings) { return false }
  for i, _tgt := range p.Encodings {
    _src142 := other.Encodings[i]
    if _tgt != _src142 { return false }
  }
  if len(p.Compressors) != len(other.Compressors) { return false }
  for i, _tgt := range p.Compressors {
    _src143 := other.Compressors[i]
    if _tgt != _src143 { return false }
  }
  if len(p.PropsList) != len(other.PropsList) { return false }
  for i, _tgt := range p.PropsList {
    _src144 := other.PropsList[i]
    if len(_tgt) != len(_src144) { return false }
    for k, _tgt := range _tgt {
      _src145 := _src144[k]
      if _tgt != _src145 { return false }
    }
  }
  if len(p.TagsList) != len(other.TagsList) { return false }
  for i, _tgt := range p.TagsList {
    _src146 := other.TagsList[i]
    if len(_tgt) != len(_src146) { return false }
    for k, _tgt := range _tgt {
      _src147 := _src146[k]
      if _tgt != _src147 { return false }
    }
  }
  if len(p.AttributesList) != len(other.AttributesList) { return false }
  for i, _tgt := range p.AttributesList {
    _src148 := other.AttributesList[i]
    if len(_tgt) != len(_src148) { return false }
    for k, _tgt := range _tgt {
      _src149 := _src148[k]
      if _tgt != _src149 { return false }
    }
  }
  if len(p.MeasurementAliasList) != len(other.MeasurementAliasList) { return false }
  for i, _tgt := range p.MeasurementAliasList {
    _src150 := other.MeasurementAliasList[i]
    if _tgt != _src150 { return false }
  }
  return true
}

func (p *TSCreateMultiTimeseriesReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateMultiTimeseriesReq(%+v)", *p)
}

// Attributes:
//  - Version
//  - SupportedTimeAggregationOperations
//  - TimestampPrecision
//  - MaxConcurrentClientNum
//  - WatermarkSecretKey
//  - WatermarkBitString
//  - WatermarkParamMarkRate
//  - WatermarkParamMaxRightBit
//  - ThriftMaxFrameSize
//  - IsReadOnly
type ServerProperties struct {
  Version string `thrift:"version,1,required" db:"version" json:"version"`
  SupportedTimeAggregationOperations []string `thrift:"supportedTimeAggregationOperations,2,required" db:"supportedTimeAggregationOperations" json:"supportedTimeAggregationOperations"`
  TimestampPrecision string `thrift:"timestampPrecision,3,required" db:"timestampPrecision" json:"timestampPrecision"`
  MaxConcurrentClientNum int32 `thrift:"maxConcurrentClientNum,4" db:"maxConcurrentClientNum" json:"maxConcurrentClientNum"`
  WatermarkSecretKey *string `thrift:"watermarkSecretKey,5" db:"watermarkSecretKey" json:"watermarkSecretKey,omitempty"`
  WatermarkBitString *string `thrift:"watermarkBitString,6" db:"watermarkBitString" json:"watermarkBitString,omitempty"`
  WatermarkParamMarkRate *int32 `thrift:"watermarkParamMarkRate,7" db:"watermarkParamMarkRate" json:"watermarkParamMarkRate,omitempty"`
  WatermarkParamMaxRightBit *int32 `thrift:"watermarkParamMaxRightBit,8" db:"watermarkParamMaxRightBit" json:"watermarkParamMaxRightBit,omitempty"`
  ThriftMaxFrameSize *int32 `thrift:"thriftMaxFrameSize,9" db:"thriftMaxFrameSize" json:"thriftMaxFrameSize,omitempty"`
  IsReadOnly *bool `thrift:"isReadOnly,10" db:"isReadOnly" json:"isReadOnly,omitempty"`
}

func NewServerProperties() *ServerProperties {
  return &ServerProperties{}
}


func (p *ServerProperties) GetVersion() string {
  return p.Version
}

func (p *ServerProperties) GetSupportedTimeAggregationOperations() []string {
  return p.SupportedTimeAggregationOperations
}

func (p *ServerProperties) GetTimestampPrecision() string {
  return p.TimestampPrecision
}

func (p *ServerProperties) GetMaxConcurrentClientNum() int32 {
  return p.MaxConcurrentClientNum
}
var ServerProperties_WatermarkSecretKey_DEFAULT string
func (p *ServerProperties) GetWatermarkSecretKey() string {
  if !p.IsSetWatermarkSecretKey() {
    return ServerProperties_WatermarkSecretKey_DEFAULT
  }
return *p.WatermarkSecretKey
}
var ServerProperties_WatermarkBitString_DEFAULT string
func (p *ServerProperties) GetWatermarkBitString() string {
  if !p.IsSetWatermarkBitString() {
    return ServerProperties_WatermarkBitString_DEFAULT
  }
return *p.WatermarkBitString
}
var ServerProperties_WatermarkParamMarkRate_DEFAULT int32
func (p *ServerProperties) GetWatermarkParamMarkRate() int32 {
  if !p.IsSetWatermarkParamMarkRate() {
    return ServerProperties_WatermarkParamMarkRate_DEFAULT
  }
return *p.WatermarkParamMarkRate
}
var ServerProperties_WatermarkParamMaxRightBit_DEFAULT int32
func (p *ServerProperties) GetWatermarkParamMaxRightBit() int32 {
  if !p.IsSetWatermarkParamMaxRightBit() {
    return ServerProperties_WatermarkParamMaxRightBit_DEFAULT
  }
return *p.WatermarkParamMaxRightBit
}
var ServerProperties_ThriftMaxFrameSize_DEFAULT int32
func (p *ServerProperties) GetThriftMaxFrameSize() int32 {
  if !p.IsSetThriftMaxFrameSize() {
    return ServerProperties_ThriftMaxFrameSize_DEFAULT
  }
return *p.ThriftMaxFrameSize
}
var ServerProperties_IsReadOnly_DEFAULT bool
func (p *ServerProperties) GetIsReadOnly() bool {
  if !p.IsSetIsReadOnly() {
    return ServerProperties_IsReadOnly_DEFAULT
  }
return *p.IsReadOnly
}
func (p *ServerProperties) IsSetWatermarkSecretKey() bool {
  return p.WatermarkSecretKey != nil
}

func (p *ServerProperties) IsSetWatermarkBitString() bool {
  return p.WatermarkBitString != nil
}

func (p *ServerProperties) IsSetWatermarkParamMarkRate() bool {
  return p.WatermarkParamMarkRate != nil
}

func (p *ServerProperties) IsSetWatermarkParamMaxRightBit() bool {
  return p.WatermarkParamMaxRightBit != nil
}

func (p *ServerProperties) IsSetThriftMaxFrameSize() bool {
  return p.ThriftMaxFrameSize != nil
}

func (p *ServerProperties) IsSetIsReadOnly() bool {
  return p.IsReadOnly != nil
}

func (p *ServerProperties) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetVersion bool = false;
  var issetSupportedTimeAggregationOperations bool = false;
  var issetTimestampPrecision bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetVersion = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetSupportedTimeAggregationOperations = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetTimestampPrecision = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetVersion{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Version is not set"));
  }
  if !issetSupportedTimeAggregationOperations{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SupportedTimeAggregationOperations is not set"));
  }
  if !issetTimestampPrecision{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimestampPrecision is not set"));
  }
  return nil
}

func (p *ServerProperties)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Version = v
}
  return nil
}

func (p *ServerProperties)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.SupportedTimeAggregationOperations =  tSlice
  for i := 0; i < size; i ++ {
var _elem151 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem151 = v
}
    p.SupportedTimeAggregationOperations = append(p.SupportedTimeAggregationOperations, _elem151)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *ServerProperties)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.TimestampPrecision = v
}
  return nil
}

func (p *ServerProperties)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.MaxConcurrentClientNum = v
}
  return nil
}

func (p *ServerProperties)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.WatermarkSecretKey = &v
}
  return nil
}

func (p *ServerProperties)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.WatermarkBitString = &v
}
  return nil
}

func (p *ServerProperties)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.WatermarkParamMarkRate = &v
}
  return nil
}

func (p *ServerProperties)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.WatermarkParamMaxRightBit = &v
}
  return nil
}

func (p *ServerProperties)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.ThriftMaxFrameSize = &v
}
  return nil
}

func (p *ServerProperties)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 10: ", err)
} else {
  p.IsReadOnly = &v
}
  return nil
}

func (p *ServerProperties) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "ServerProperties"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ServerProperties) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "version", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:version: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Version)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.version (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:version: ", p), err) }
  return err
}

func (p *ServerProperties) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "supportedTimeAggregationOperations", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:supportedTimeAggregationOperations: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.SupportedTimeAggregationOperations)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.SupportedTimeAggregationOperations {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:supportedTimeAggregationOperations: ", p), err) }
  return err
}

func (p *ServerProperties) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestampPrecision", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:timestampPrecision: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TimestampPrecision)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timestampPrecision (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:timestampPrecision: ", p), err) }
  return err
}

func (p *ServerProperties) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "maxConcurrentClientNum", thrift.I32, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:maxConcurrentClientNum: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.MaxConcurrentClientNum)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.maxConcurrentClientNum (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:maxConcurrentClientNum: ", p), err) }
  return err
}

func (p *ServerProperties) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetWatermarkSecretKey() {
    if err := oprot.WriteFieldBegin(ctx, "watermarkSecretKey", thrift.STRING, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:watermarkSecretKey: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.WatermarkSecretKey)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.watermarkSecretKey (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:watermarkSecretKey: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetWatermarkBitString() {
    if err := oprot.WriteFieldBegin(ctx, "watermarkBitString", thrift.STRING, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:watermarkBitString: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.WatermarkBitString)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.watermarkBitString (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:watermarkBitString: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetWatermarkParamMarkRate() {
    if err := oprot.WriteFieldBegin(ctx, "watermarkParamMarkRate", thrift.I32, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:watermarkParamMarkRate: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.WatermarkParamMarkRate)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.watermarkParamMarkRate (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:watermarkParamMarkRate: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetWatermarkParamMaxRightBit() {
    if err := oprot.WriteFieldBegin(ctx, "watermarkParamMaxRightBit", thrift.I32, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:watermarkParamMaxRightBit: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.WatermarkParamMaxRightBit)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.watermarkParamMaxRightBit (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:watermarkParamMaxRightBit: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetThriftMaxFrameSize() {
    if err := oprot.WriteFieldBegin(ctx, "thriftMaxFrameSize", thrift.I32, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:thriftMaxFrameSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.ThriftMaxFrameSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.thriftMaxFrameSize (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:thriftMaxFrameSize: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsReadOnly() {
    if err := oprot.WriteFieldBegin(ctx, "isReadOnly", thrift.BOOL, 10); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:isReadOnly: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsReadOnly)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isReadOnly (10) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 10:isReadOnly: ", p), err) }
  }
  return err
}

func (p *ServerProperties) Equals(other *ServerProperties) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Version != other.Version { return false }
  if len(p.SupportedTimeAggregationOperations) != len(other.SupportedTimeAggregationOperations) { return false }
  for i, _tgt := range p.SupportedTimeAggregationOperations {
    _src152 := other.SupportedTimeAggregationOperations[i]
    if _tgt != _src152 { return false }
  }
  if p.TimestampPrecision != other.TimestampPrecision { return false }
  if p.MaxConcurrentClientNum != other.MaxConcurrentClientNum { return false }
  if p.WatermarkSecretKey != other.WatermarkSecretKey {
    if p.WatermarkSecretKey == nil || other.WatermarkSecretKey == nil {
      return false
    }
    if (*p.WatermarkSecretKey) != (*other.WatermarkSecretKey) { return false }
  }
  if p.WatermarkBitString != other.WatermarkBitString {
    if p.WatermarkBitString == nil || other.WatermarkBitString == nil {
      return false
    }
    if (*p.WatermarkBitString) != (*other.WatermarkBitString) { return false }
  }
  if p.WatermarkParamMarkRate != other.WatermarkParamMarkRate {
    if p.WatermarkParamMarkRate == nil || other.WatermarkParamMarkRate == nil {
      return false
    }
    if (*p.WatermarkParamMarkRate) != (*other.WatermarkParamMarkRate) { return false }
  }
  if p.WatermarkParamMaxRightBit != other.WatermarkParamMaxRightBit {
    if p.WatermarkParamMaxRightBit == nil || other.WatermarkParamMaxRightBit == nil {
      return false
    }
    if (*p.WatermarkParamMaxRightBit) != (*other.WatermarkParamMaxRightBit) { return false }
  }
  if p.ThriftMaxFrameSize != other.ThriftMaxFrameSize {
    if p.ThriftMaxFrameSize == nil || other.ThriftMaxFrameSize == nil {
      return false
    }
    if (*p.ThriftMaxFrameSize) != (*other.ThriftMaxFrameSize) { return false }
  }
  if p.IsReadOnly != other.IsReadOnly {
    if p.IsReadOnly == nil || other.IsReadOnly == nil {
      return false
    }
    if (*p.IsReadOnly) != (*other.IsReadOnly) { return false }
  }
  return true
}

func (p *ServerProperties) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ServerProperties(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - TemplateName
//  - PrefixPath
type TSSetSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  TemplateName string `thrift:"templateName,2,required" db:"templateName" json:"templateName"`
  PrefixPath string `thrift:"prefixPath,3,required" db:"prefixPath" json:"prefixPath"`
}

func NewTSSetSchemaTemplateReq() *TSSetSchemaTemplateReq {
  return &TSSetSchemaTemplateReq{}
}


func (p *TSSetSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSSetSchemaTemplateReq) GetTemplateName() string {
  return p.TemplateName
}

func (p *TSSetSchemaTemplateReq) GetPrefixPath() string {
  return p.PrefixPath
}
func (p *TSSetSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetTemplateName bool = false;
  var issetPrefixPath bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetTemplateName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetTemplateName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TemplateName is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  return nil
}

func (p *TSSetSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSSetSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TemplateName = v
}
  return nil
}

func (p *TSSetSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSSetSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSSetSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSSetSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSSetSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "templateName", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:templateName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TemplateName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.templateName (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:templateName: ", p), err) }
  return err
}

func (p *TSSetSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:prefixPath: ", p), err) }
  return err
}

func (p *TSSetSchemaTemplateReq) Equals(other *TSSetSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.TemplateName != other.TemplateName { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  return true
}

func (p *TSSetSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSSetSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Name
//  - SerializedTemplate
type TSCreateSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Name string `thrift:"name,2,required" db:"name" json:"name"`
  SerializedTemplate []byte `thrift:"serializedTemplate,3,required" db:"serializedTemplate" json:"serializedTemplate"`
}

func NewTSCreateSchemaTemplateReq() *TSCreateSchemaTemplateReq {
  return &TSCreateSchemaTemplateReq{}
}


func (p *TSCreateSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateSchemaTemplateReq) GetName() string {
  return p.Name
}

func (p *TSCreateSchemaTemplateReq) GetSerializedTemplate() []byte {
  return p.SerializedTemplate
}
func (p *TSCreateSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetName bool = false;
  var issetSerializedTemplate bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetSerializedTemplate = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"));
  }
  if !issetSerializedTemplate{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SerializedTemplate is not set"));
  }
  return nil
}

func (p *TSCreateSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Name = v
}
  return nil
}

func (p *TSCreateSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.SerializedTemplate = v
}
  return nil
}

func (p *TSCreateSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:name: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.name (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:name: ", p), err) }
  return err
}

func (p *TSCreateSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "serializedTemplate", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:serializedTemplate: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.SerializedTemplate); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.serializedTemplate (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:serializedTemplate: ", p), err) }
  return err
}

func (p *TSCreateSchemaTemplateReq) Equals(other *TSCreateSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Name != other.Name { return false }
  if bytes.Compare(p.SerializedTemplate, other.SerializedTemplate) != 0 { return false }
  return true
}

func (p *TSCreateSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Name
//  - IsAligned
//  - Measurements
//  - DataTypes
//  - Encodings
//  - Compressors
type TSAppendSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Name string `thrift:"name,2,required" db:"name" json:"name"`
  IsAligned bool `thrift:"isAligned,3,required" db:"isAligned" json:"isAligned"`
  Measurements []string `thrift:"measurements,4,required" db:"measurements" json:"measurements"`
  DataTypes []int32 `thrift:"dataTypes,5,required" db:"dataTypes" json:"dataTypes"`
  Encodings []int32 `thrift:"encodings,6,required" db:"encodings" json:"encodings"`
  Compressors []int32 `thrift:"compressors,7,required" db:"compressors" json:"compressors"`
}

func NewTSAppendSchemaTemplateReq() *TSAppendSchemaTemplateReq {
  return &TSAppendSchemaTemplateReq{}
}


func (p *TSAppendSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSAppendSchemaTemplateReq) GetName() string {
  return p.Name
}

func (p *TSAppendSchemaTemplateReq) GetIsAligned() bool {
  return p.IsAligned
}

func (p *TSAppendSchemaTemplateReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSAppendSchemaTemplateReq) GetDataTypes() []int32 {
  return p.DataTypes
}

func (p *TSAppendSchemaTemplateReq) GetEncodings() []int32 {
  return p.Encodings
}

func (p *TSAppendSchemaTemplateReq) GetCompressors() []int32 {
  return p.Compressors
}
func (p *TSAppendSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetName bool = false;
  var issetIsAligned bool = false;
  var issetMeasurements bool = false;
  var issetDataTypes bool = false;
  var issetEncodings bool = false;
  var issetCompressors bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetIsAligned = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetDataTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetEncodings = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetCompressors = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"));
  }
  if !issetIsAligned{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAligned is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetDataTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypes is not set"));
  }
  if !issetEncodings{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encodings is not set"));
  }
  if !issetCompressors{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressors is not set"));
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Name = v
}
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.IsAligned = v
}
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem153 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem153 = v
}
    p.Measurements = append(p.Measurements, _elem153)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.DataTypes =  tSlice
  for i := 0; i < size; i ++ {
var _elem154 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem154 = v
}
    p.DataTypes = append(p.DataTypes, _elem154)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Encodings =  tSlice
  for i := 0; i < size; i ++ {
var _elem155 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem155 = v
}
    p.Encodings = append(p.Encodings, _elem155)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Compressors =  tSlice
  for i := 0; i < size; i ++ {
var _elem156 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem156 = v
}
    p.Compressors = append(p.Compressors, _elem156)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSAppendSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSAppendSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:name: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.name (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:name: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:isAligned: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.IsAligned)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.isAligned (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:isAligned: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:measurements: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypes", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:dataTypes: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypes)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypes {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:dataTypes: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "encodings", thrift.LIST, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:encodings: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Encodings)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Encodings {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:encodings: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "compressors", thrift.LIST, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:compressors: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Compressors)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Compressors {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:compressors: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) Equals(other *TSAppendSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Name != other.Name { return false }
  if p.IsAligned != other.IsAligned { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src157 := other.Measurements[i]
    if _tgt != _src157 { return false }
  }
  if len(p.DataTypes) != len(other.DataTypes) { return false }
  for i, _tgt := range p.DataTypes {
    _src158 := other.DataTypes[i]
    if _tgt != _src158 { return false }
  }
  if len(p.Encodings) != len(other.Encodings) { return false }
  for i, _tgt := range p.Encodings {
    _src159 := other.Encodings[i]
    if _tgt != _src159 { return false }
  }
  if len(p.Compressors) != len(other.Compressors) { return false }
  for i, _tgt := range p.Compressors {
    _src160 := other.Compressors[i]
    if _tgt != _src160 { return false }
  }
  return true
}

func (p *TSAppendSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSAppendSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Name
//  - Path
type TSPruneSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Name string `thrift:"name,2,required" db:"name" json:"name"`
  Path string `thrift:"path,3,required" db:"path" json:"path"`
}

func NewTSPruneSchemaTemplateReq() *TSPruneSchemaTemplateReq {
  return &TSPruneSchemaTemplateReq{}
}


func (p *TSPruneSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSPruneSchemaTemplateReq) GetName() string {
  return p.Name
}

func (p *TSPruneSchemaTemplateReq) GetPath() string {
  return p.Path
}
func (p *TSPruneSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetName bool = false;
  var issetPath bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"));
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  return nil
}

func (p *TSPruneSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSPruneSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Name = v
}
  return nil
}

func (p *TSPruneSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *TSPruneSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSPruneSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSPruneSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSPruneSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:name: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.name (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:name: ", p), err) }
  return err
}

func (p *TSPruneSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:path: ", p), err) }
  return err
}

func (p *TSPruneSchemaTemplateReq) Equals(other *TSPruneSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Name != other.Name { return false }
  if p.Path != other.Path { return false }
  return true
}

func (p *TSPruneSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSPruneSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Name
//  - QueryType
//  - Measurement
type TSQueryTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Name string `thrift:"name,2,required" db:"name" json:"name"`
  QueryType int32 `thrift:"queryType,3,required" db:"queryType" json:"queryType"`
  Measurement *string `thrift:"measurement,4" db:"measurement" json:"measurement,omitempty"`
}

func NewTSQueryTemplateReq() *TSQueryTemplateReq {
  return &TSQueryTemplateReq{}
}


func (p *TSQueryTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSQueryTemplateReq) GetName() string {
  return p.Name
}

func (p *TSQueryTemplateReq) GetQueryType() int32 {
  return p.QueryType
}
var TSQueryTemplateReq_Measurement_DEFAULT string
func (p *TSQueryTemplateReq) GetMeasurement() string {
  if !p.IsSetMeasurement() {
    return TSQueryTemplateReq_Measurement_DEFAULT
  }
return *p.Measurement
}
func (p *TSQueryTemplateReq) IsSetMeasurement() bool {
  return p.Measurement != nil
}

func (p *TSQueryTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetName bool = false;
  var issetQueryType bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetQueryType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"));
  }
  if !issetQueryType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryType is not set"));
  }
  return nil
}

func (p *TSQueryTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSQueryTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Name = v
}
  return nil
}

func (p *TSQueryTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.QueryType = v
}
  return nil
}

func (p *TSQueryTemplateReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Measurement = &v
}
  return nil
}

func (p *TSQueryTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSQueryTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSQueryTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSQueryTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:name: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.name (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:name: ", p), err) }
  return err
}

func (p *TSQueryTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryType", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:queryType: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.QueryType)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryType (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:queryType: ", p), err) }
  return err
}

func (p *TSQueryTemplateReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurement() {
    if err := oprot.WriteFieldBegin(ctx, "measurement", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:measurement: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Measurement)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.measurement (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:measurement: ", p), err) }
  }
  return err
}

func (p *TSQueryTemplateReq) Equals(other *TSQueryTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Name != other.Name { return false }
  if p.QueryType != other.QueryType { return false }
  if p.Measurement != other.Measurement {
    if p.Measurement == nil || other.Measurement == nil {
      return false
    }
    if (*p.Measurement) != (*other.Measurement) { return false }
  }
  return true
}

func (p *TSQueryTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSQueryTemplateReq(%+v)", *p)
}

// Attributes:
//  - Status
//  - QueryType
//  - Result_
//  - Count
//  - Measurements
type TSQueryTemplateResp struct {
  Status *TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  QueryType int32 `thrift:"queryType,2,required" db:"queryType" json:"queryType"`
  Result_ *bool `thrift:"result,3" db:"result" json:"result,omitempty"`
  Count *int32 `thrift:"count,4" db:"count" json:"count,omitempty"`
  Measurements []string `thrift:"measurements,5" db:"measurements" json:"measurements,omitempty"`
}

func NewTSQueryTemplateResp() *TSQueryTemplateResp {
  return &TSQueryTemplateResp{}
}

var TSQueryTemplateResp_Status_DEFAULT *TSStatus
func (p *TSQueryTemplateResp) GetStatus() *TSStatus {
  if !p.IsSetStatus() {
    return TSQueryTemplateResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSQueryTemplateResp) GetQueryType() int32 {
  return p.QueryType
}
var TSQueryTemplateResp_Result__DEFAULT bool
func (p *TSQueryTemplateResp) GetResult_() bool {
  if !p.IsSetResult_() {
    return TSQueryTemplateResp_Result__DEFAULT
  }
return *p.Result_
}
var TSQueryTemplateResp_Count_DEFAULT int32
func (p *TSQueryTemplateResp) GetCount() int32 {
  if !p.IsSetCount() {
    return TSQueryTemplateResp_Count_DEFAULT
  }
return *p.Count
}
var TSQueryTemplateResp_Measurements_DEFAULT []string

func (p *TSQueryTemplateResp) GetMeasurements() []string {
  return p.Measurements
}
func (p *TSQueryTemplateResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSQueryTemplateResp) IsSetResult_() bool {
  return p.Result_ != nil
}

func (p *TSQueryTemplateResp) IsSetCount() bool {
  return p.Count != nil
}

func (p *TSQueryTemplateResp) IsSetMeasurements() bool {
  return p.Measurements != nil
}

func (p *TSQueryTemplateResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetQueryType bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetQueryType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetQueryType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryType is not set"));
  }
  return nil
}

func (p *TSQueryTemplateResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSQueryTemplateResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryType = v
}
  return nil
}

func (p *TSQueryTemplateResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Result_ = &v
}
  return nil
}

func (p *TSQueryTemplateResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Count = &v
}
  return nil
}

func (p *TSQueryTemplateResp)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem161 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem161 = v
}
    p.Measurements = append(p.Measurements, _elem161)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryTemplateResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSQueryTemplateResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSQueryTemplateResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSQueryTemplateResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryType", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryType: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.QueryType)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryType (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryType: ", p), err) }
  return err
}

func (p *TSQueryTemplateResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetResult_() {
    if err := oprot.WriteFieldBegin(ctx, "result", thrift.BOOL, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:result: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.Result_)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.result (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:result: ", p), err) }
  }
  return err
}

func (p *TSQueryTemplateResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetCount() {
    if err := oprot.WriteFieldBegin(ctx, "count", thrift.I32, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:count: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.Count)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.count (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:count: ", p), err) }
  }
  return err
}

func (p *TSQueryTemplateResp) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurements() {
    if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:measurements: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Measurements {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:measurements: ", p), err) }
  }
  return err
}

func (p *TSQueryTemplateResp) Equals(other *TSQueryTemplateResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.QueryType != other.QueryType { return false }
  if p.Result_ != other.Result_ {
    if p.Result_ == nil || other.Result_ == nil {
      return false
    }
    if (*p.Result_) != (*other.Result_) { return false }
  }
  if p.Count != other.Count {
    if p.Count == nil || other.Count == nil {
      return false
    }
    if (*p.Count) != (*other.Count) { return false }
  }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src162 := other.Measurements[i]
    if _tgt != _src162 { return false }
  }
  return true
}

func (p *TSQueryTemplateResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSQueryTemplateResp(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - TemplateName
type TSUnsetSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  TemplateName string `thrift:"templateName,3,required" db:"templateName" json:"templateName"`
}

func NewTSUnsetSchemaTemplateReq() *TSUnsetSchemaTemplateReq {
  return &TSUnsetSchemaTemplateReq{}
}


func (p *TSUnsetSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSUnsetSchemaTemplateReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSUnsetSchemaTemplateReq) GetTemplateName() string {
  return p.TemplateName
}
func (p *TSUnsetSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetTemplateName bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetTemplateName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetTemplateName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TemplateName is not set"));
  }
  return nil
}

func (p *TSUnsetSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSUnsetSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSUnsetSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.TemplateName = v
}
  return nil
}

func (p *TSUnsetSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSUnsetSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSUnsetSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSUnsetSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSUnsetSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "templateName", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:templateName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TemplateName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.templateName (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:templateName: ", p), err) }
  return err
}

func (p *TSUnsetSchemaTemplateReq) Equals(other *TSUnsetSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if p.TemplateName != other.TemplateName { return false }
  return true
}

func (p *TSUnsetSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSUnsetSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DstPath
type TSSetUsingTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  DstPath string `thrift:"dstPath,2,required" db:"dstPath" json:"dstPath"`
}

func NewTSSetUsingTemplateReq() *TSSetUsingTemplateReq {
  return &TSSetUsingTemplateReq{}
}


func (p *TSSetUsingTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSSetUsingTemplateReq) GetDstPath() string {
  return p.DstPath
}
func (p *TSSetUsingTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetDstPath bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetDstPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetDstPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DstPath is not set"));
  }
  return nil
}

func (p *TSSetUsingTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSSetUsingTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.DstPath = v
}
  return nil
}

func (p *TSSetUsingTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSSetUsingTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSSetUsingTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSSetUsingTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dstPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:dstPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.DstPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.dstPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:dstPath: ", p), err) }
  return err
}

func (p *TSSetUsingTemplateReq) Equals(other *TSSetUsingTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.DstPath != other.DstPath { return false }
  return true
}

func (p *TSSetUsingTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSSetUsingTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - TemplateName
type TSDropSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  TemplateName string `thrift:"templateName,2,required" db:"templateName" json:"templateName"`
}

func NewTSDropSchemaTemplateReq() *TSDropSchemaTemplateReq {
  return &TSDropSchemaTemplateReq{}
}


func (p *TSDropSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSDropSchemaTemplateReq) GetTemplateName() string {
  return p.TemplateName
}
func (p *TSDropSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetTemplateName bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetTemplateName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetTemplateName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TemplateName is not set"));
  }
  return nil
}

func (p *TSDropSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSDropSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TemplateName = v
}
  return nil
}

func (p *TSDropSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSDropSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDropSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSDropSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "templateName", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:templateName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TemplateName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.templateName (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:templateName: ", p), err) }
  return err
}

func (p *TSDropSchemaTemplateReq) Equals(other *TSDropSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.TemplateName != other.TemplateName { return false }
  return true
}

func (p *TSDropSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDropSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - OperationSyncType
//  - PhysicalPlan
type TSOperationSyncWriteReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  OperationSyncType int8 `thrift:"operationSyncType,2,required" db:"operationSyncType" json:"operationSyncType"`
  PhysicalPlan []byte `thrift:"physicalPlan,3,required" db:"physicalPlan" json:"physicalPlan"`
}

func NewTSOperationSyncWriteReq() *TSOperationSyncWriteReq {
  return &TSOperationSyncWriteReq{}
}


func (p *TSOperationSyncWriteReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSOperationSyncWriteReq) GetOperationSyncType() int8 {
  return p.OperationSyncType
}

func (p *TSOperationSyncWriteReq) GetPhysicalPlan() []byte {
  return p.PhysicalPlan
}
func (p *TSOperationSyncWriteReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetOperationSyncType bool = false;
  var issetPhysicalPlan bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.BYTE {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetOperationSyncType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetPhysicalPlan = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetOperationSyncType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field OperationSyncType is not set"));
  }
  if !issetPhysicalPlan{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PhysicalPlan is not set"));
  }
  return nil
}

func (p *TSOperationSyncWriteReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSOperationSyncWriteReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadByte(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := int8(v)
  p.OperationSyncType = temp
}
  return nil
}

func (p *TSOperationSyncWriteReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.PhysicalPlan = v
}
  return nil
}

func (p *TSOperationSyncWriteReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSOperationSyncWriteReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSOperationSyncWriteReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSOperationSyncWriteReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "operationSyncType", thrift.BYTE, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:operationSyncType: ", p), err) }
  if err := oprot.WriteByte(ctx, int8(p.OperationSyncType)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.operationSyncType (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:operationSyncType: ", p), err) }
  return err
}

func (p *TSOperationSyncWriteReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "physicalPlan", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:physicalPlan: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.PhysicalPlan); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.physicalPlan (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:physicalPlan: ", p), err) }
  return err
}

func (p *TSOperationSyncWriteReq) Equals(other *TSOperationSyncWriteReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.OperationSyncType != other.OperationSyncType { return false }
  if bytes.Compare(p.PhysicalPlan, other.PhysicalPlan) != 0 { return false }
  return true
}

func (p *TSOperationSyncWriteReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSOperationSyncWriteReq(%+v)", *p)
}

type TSIService interface {
  // Parameters:
  //  - Req
  OpenSession(ctx context.Context, req *TSOpenSessionReq) (_r *TSOpenSessionResp, _err error)
  // Parameters:
  //  - Req
  CloseSession(ctx context.Context, req *TSCloseSessionReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  ExecuteStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteBatchStatement(ctx context.Context, req *TSExecuteBatchStatementReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  ExecuteQueryStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteUpdateStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  FetchResults(ctx context.Context, req *TSFetchResultsReq) (_r *TSFetchResultsResp, _err error)
  // Parameters:
  //  - Req
  FetchMetadata(ctx context.Context, req *TSFetchMetadataReq) (_r *TSFetchMetadataResp, _err error)
  // Parameters:
  //  - Req
  CancelOperation(ctx context.Context, req *TSCancelOperationReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  CloseOperation(ctx context.Context, req *TSCloseOperationReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - SessionId
  GetSystemStatus(ctx context.Context, sessionId int64) (_r *TSGetSystemStatusResp, _err error)
  // Parameters:
  //  - SessionId
  GetTimeZone(ctx context.Context, sessionId int64) (_r *TSGetTimeZoneResp, _err error)
  // Parameters:
  //  - Req
  SetTimeZone(ctx context.Context, req *TSSetTimeZoneReq) (_r *TSStatus, _err error)
  GetProperties(ctx context.Context) (_r *ServerProperties, _err error)
  // Parameters:
  //  - SessionId
  //  - StorageGroup
  SetStorageGroup(ctx context.Context, sessionId int64, storageGroup string) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  CreateTimeseries(ctx context.Context, req *TSCreateTimeseriesReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  CreateAlignedTimeseries(ctx context.Context, req *TSCreateAlignedTimeseriesReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  CreateMultiTimeseries(ctx context.Context, req *TSCreateMultiTimeseriesReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - SessionId
  //  - Path
  DeleteTimeseries(ctx context.Context, sessionId int64, path []string) (_r *TSStatus, _err error)
  // Parameters:
  //  - SessionId
  //  - StorageGroup
  DeleteStorageGroups(ctx context.Context, sessionId int64, storageGroup []string) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertStringRecordsOfOneDevice(ctx context.Context, req *TSInsertStringRecordsOfOneDeviceReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  DeleteData(ctx context.Context, req *TSDeleteDataReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  ExecuteRawDataQuery(ctx context.Context, req *TSRawDataQueryReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteLastDataQuery(ctx context.Context, req *TSLastDataQueryReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - SessionId
  RequestStatementId(ctx context.Context, sessionId int64) (_r int64, _err error)
  // Parameters:
  //  - Req
  CreateSchemaTemplate(ctx context.Context, req *TSCreateSchemaTemplateReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  AppendSchemaTemplate(ctx context.Context, req *TSAppendSchemaTemplateReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  PruneSchemaTemplate(ctx context.Context, req *TSPruneSchemaTemplateReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  QuerySchemaTemplate(ctx context.Context, req *TSQueryTemplateReq) (_r *TSQueryTemplateResp, _err error)
  // Parameters:
  //  - Req
  SetSchemaTemplate(ctx context.Context, req *TSSetSchemaTemplateReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  UnsetSchemaTemplate(ctx context.Context, req *TSUnsetSchemaTemplateReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  SetUsingTemplate(ctx context.Context, req *TSSetUsingTemplateReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - SessionId
  //  - TemplateName
  //  - PrefixPath
  UnsetUsingTemplate(ctx context.Context, sessionId int64, templateName string, prefixPath string) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  DropSchemaTemplate(ctx context.Context, req *TSDropSchemaTemplateReq) (_r *TSStatus, _err error)
  // Parameters:
  //  - Req
  ExecuteOperationSync(ctx context.Context, req *TSOperationSyncWriteReq) (_r *TSStatus, _err error)
}

type TSIServiceClient struct {
  c thrift.TClient
  meta thrift.ResponseMeta
}

func NewTSIServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *TSIServiceClient {
  return &TSIServiceClient{
    c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
  }
}

func NewTSIServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *TSIServiceClient {
  return &TSIServiceClient{
    c: thrift.NewTStandardClient(iprot, oprot),
  }
}

func NewTSIServiceClient(c thrift.TClient) *TSIServiceClient {
  return &TSIServiceClient{
    c: c,
  }
}

func (p *TSIServiceClient) Client_() thrift.TClient {
  return p.c
}

func (p *TSIServiceClient) LastResponseMeta_() thrift.ResponseMeta {
  return p.meta
}

func (p *TSIServiceClient) SetLastResponseMeta_(meta thrift.ResponseMeta) {
  p.meta = meta
}

// Parameters:
//  - Req
func (p *TSIServiceClient) OpenSession(ctx context.Context, req *TSOpenSessionReq) (_r *TSOpenSessionResp, _err error) {
  var _args163 TSIServiceOpenSessionArgs
  _args163.Req = req
  var _result165 TSIServiceOpenSessionResult
  var _meta164 thrift.ResponseMeta
  _meta164, _err = p.Client_().Call(ctx, "openSession", &_args163, &_result165)
  p.SetLastResponseMeta_(_meta164)
  if _err != nil {
    return
  }
  return _result165.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CloseSession(ctx context.Context, req *TSCloseSessionReq) (_r *TSStatus, _err error) {
  var _args166 TSIServiceCloseSessionArgs
  _args166.Req = req
  var _result168 TSIServiceCloseSessionResult
  var _meta167 thrift.ResponseMeta
  _meta167, _err = p.Client_().Call(ctx, "closeSession", &_args166, &_result168)
  p.SetLastResponseMeta_(_meta167)
  if _err != nil {
    return
  }
  return _result168.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args169 TSIServiceExecuteStatementArgs
  _args169.Req = req
  var _result171 TSIServiceExecuteStatementResult
  var _meta170 thrift.ResponseMeta
  _meta170, _err = p.Client_().Call(ctx, "executeStatement", &_args169, &_result171)
  p.SetLastResponseMeta_(_meta170)
  if _err != nil {
    return
  }
  return _result171.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteBatchStatement(ctx context.Context, req *TSExecuteBatchStatementReq) (_r *TSStatus, _err error) {
  var _args172 TSIServiceExecuteBatchStatementArgs
  _args172.Req = req
  var _result174 TSIServiceExecuteBatchStatementResult
  var _meta173 thrift.ResponseMeta
  _meta173, _err = p.Client_().Call(ctx, "executeBatchStatement", &_args172, &_result174)
  p.SetLastResponseMeta_(_meta173)
  if _err != nil {
    return
  }
  return _result174.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteQueryStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args175 TSIServiceExecuteQueryStatementArgs
  _args175.Req = req
  var _result177 TSIServiceExecuteQueryStatementResult
  var _meta176 thrift.ResponseMeta
  _meta176, _err = p.Client_().Call(ctx, "executeQueryStatement", &_args175, &_result177)
  p.SetLastResponseMeta_(_meta176)
  if _err != nil {
    return
  }
  return _result177.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteUpdateStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args178 TSIServiceExecuteUpdateStatementArgs
  _args178.Req = req
  var _result180 TSIServiceExecuteUpdateStatementResult
  var _meta179 thrift.ResponseMeta
  _meta179, _err = p.Client_().Call(ctx, "executeUpdateStatement", &_args178, &_result180)
  p.SetLastResponseMeta_(_meta179)
  if _err != nil {
    return
  }
  return _result180.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) FetchResults(ctx context.Context, req *TSFetchResultsReq) (_r *TSFetchResultsResp, _err error) {
  var _args181 TSIServiceFetchResultsArgs
  _args181.Req = req
  var _result183 TSIServiceFetchResultsResult
  var _meta182 thrift.ResponseMeta
  _meta182, _err = p.Client_().Call(ctx, "fetchResults", &_args181, &_result183)
  p.SetLastResponseMeta_(_meta182)
  if _err != nil {
    return
  }
  return _result183.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) FetchMetadata(ctx context.Context, req *TSFetchMetadataReq) (_r *TSFetchMetadataResp, _err error) {
  var _args184 TSIServiceFetchMetadataArgs
  _args184.Req = req
  var _result186 TSIServiceFetchMetadataResult
  var _meta185 thrift.ResponseMeta
  _meta185, _err = p.Client_().Call(ctx, "fetchMetadata", &_args184, &_result186)
  p.SetLastResponseMeta_(_meta185)
  if _err != nil {
    return
  }
  return _result186.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CancelOperation(ctx context.Context, req *TSCancelOperationReq) (_r *TSStatus, _err error) {
  var _args187 TSIServiceCancelOperationArgs
  _args187.Req = req
  var _result189 TSIServiceCancelOperationResult
  var _meta188 thrift.ResponseMeta
  _meta188, _err = p.Client_().Call(ctx, "cancelOperation", &_args187, &_result189)
  p.SetLastResponseMeta_(_meta188)
  if _err != nil {
    return
  }
  return _result189.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CloseOperation(ctx context.Context, req *TSCloseOperationReq) (_r *TSStatus, _err error) {
  var _args190 TSIServiceCloseOperationArgs
  _args190.Req = req
  var _result192 TSIServiceCloseOperationResult
  var _meta191 thrift.ResponseMeta
  _meta191, _err = p.Client_().Call(ctx, "closeOperation", &_args190, &_result192)
  p.SetLastResponseMeta_(_meta191)
  if _err != nil {
    return
  }
  return _result192.GetSuccess(), nil
}

// Parameters:
//  - SessionId
func (p *TSIServiceClient) GetSystemStatus(ctx context.Context, sessionId int64) (_r *TSGetSystemStatusResp, _err error) {
  var _args193 TSIServiceGetSystemStatusArgs
  _args193.SessionId = sessionId
  var _result195 TSIServiceGetSystemStatusResult
  var _meta194 thrift.ResponseMeta
  _meta194, _err = p.Client_().Call(ctx, "getSystemStatus", &_args193, &_result195)
  p.SetLastResponseMeta_(_meta194)
  if _err != nil {
    return
  }
  return _result195.GetSuccess(), nil
}

// Parameters:
//  - SessionId
func (p *TSIServiceClient) GetTimeZone(ctx context.Context, sessionId int64) (_r *TSGetTimeZoneResp, _err error) {
  var _args196 TSIServiceGetTimeZoneArgs
  _args196.SessionId = sessionId
  var _result198 TSIServiceGetTimeZoneResult
  var _meta197 thrift.ResponseMeta
  _meta197, _err = p.Client_().Call(ctx, "getTimeZone", &_args196, &_result198)
  p.SetLastResponseMeta_(_meta197)
  if _err != nil {
    return
  }
  return _result198.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) SetTimeZone(ctx context.Context, req *TSSetTimeZoneReq) (_r *TSStatus, _err error) {
  var _args199 TSIServiceSetTimeZoneArgs
  _args199.Req = req
  var _result201 TSIServiceSetTimeZoneResult
  var _meta200 thrift.ResponseMeta
  _meta200, _err = p.Client_().Call(ctx, "setTimeZone", &_args199, &_result201)
  p.SetLastResponseMeta_(_meta200)
  if _err != nil {
    return
  }
  return _result201.GetSuccess(), nil
}

func (p *TSIServiceClient) GetProperties(ctx context.Context) (_r *ServerProperties, _err error) {
  var _args202 TSIServiceGetPropertiesArgs
  var _result204 TSIServiceGetPropertiesResult
  var _meta203 thrift.ResponseMeta
  _meta203, _err = p.Client_().Call(ctx, "getProperties", &_args202, &_result204)
  p.SetLastResponseMeta_(_meta203)
  if _err != nil {
    return
  }
  return _result204.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - StorageGroup
func (p *TSIServiceClient) SetStorageGroup(ctx context.Context, sessionId int64, storageGroup string) (_r *TSStatus, _err error) {
  var _args205 TSIServiceSetStorageGroupArgs
  _args205.SessionId = sessionId
  _args205.StorageGroup = storageGroup
  var _result207 TSIServiceSetStorageGroupResult
  var _meta206 thrift.ResponseMeta
  _meta206, _err = p.Client_().Call(ctx, "setStorageGroup", &_args205, &_result207)
  p.SetLastResponseMeta_(_meta206)
  if _err != nil {
    return
  }
  return _result207.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CreateTimeseries(ctx context.Context, req *TSCreateTimeseriesReq) (_r *TSStatus, _err error) {
  var _args208 TSIServiceCreateTimeseriesArgs
  _args208.Req = req
  var _result210 TSIServiceCreateTimeseriesResult
  var _meta209 thrift.ResponseMeta
  _meta209, _err = p.Client_().Call(ctx, "createTimeseries", &_args208, &_result210)
  p.SetLastResponseMeta_(_meta209)
  if _err != nil {
    return
  }
  return _result210.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CreateAlignedTimeseries(ctx context.Context, req *TSCreateAlignedTimeseriesReq) (_r *TSStatus, _err error) {
  var _args211 TSIServiceCreateAlignedTimeseriesArgs
  _args211.Req = req
  var _result213 TSIServiceCreateAlignedTimeseriesResult
  var _meta212 thrift.ResponseMeta
  _meta212, _err = p.Client_().Call(ctx, "createAlignedTimeseries", &_args211, &_result213)
  p.SetLastResponseMeta_(_meta212)
  if _err != nil {
    return
  }
  return _result213.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CreateMultiTimeseries(ctx context.Context, req *TSCreateMultiTimeseriesReq) (_r *TSStatus, _err error) {
  var _args214 TSIServiceCreateMultiTimeseriesArgs
  _args214.Req = req
  var _result216 TSIServiceCreateMultiTimeseriesResult
  var _meta215 thrift.ResponseMeta
  _meta215, _err = p.Client_().Call(ctx, "createMultiTimeseries", &_args214, &_result216)
  p.SetLastResponseMeta_(_meta215)
  if _err != nil {
    return
  }
  return _result216.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - Path
func (p *TSIServiceClient) DeleteTimeseries(ctx context.Context, sessionId int64, path []string) (_r *TSStatus, _err error) {
  var _args217 TSIServiceDeleteTimeseriesArgs
  _args217.SessionId = sessionId
  _args217.Path = path
  var _result219 TSIServiceDeleteTimeseriesResult
  var _meta218 thrift.ResponseMeta
  _meta218, _err = p.Client_().Call(ctx, "deleteTimeseries", &_args217, &_result219)
  p.SetLastResponseMeta_(_meta218)
  if _err != nil {
    return
  }
  return _result219.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - StorageGroup
func (p *TSIServiceClient) DeleteStorageGroups(ctx context.Context, sessionId int64, storageGroup []string) (_r *TSStatus, _err error) {
  var _args220 TSIServiceDeleteStorageGroupsArgs
  _args220.SessionId = sessionId
  _args220.StorageGroup = storageGroup
  var _result222 TSIServiceDeleteStorageGroupsResult
  var _meta221 thrift.ResponseMeta
  _meta221, _err = p.Client_().Call(ctx, "deleteStorageGroups", &_args220, &_result222)
  p.SetLastResponseMeta_(_meta221)
  if _err != nil {
    return
  }
  return _result222.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *TSStatus, _err error) {
  var _args223 TSIServiceInsertRecordArgs
  _args223.Req = req
  var _result225 TSIServiceInsertRecordResult
  var _meta224 thrift.ResponseMeta
  _meta224, _err = p.Client_().Call(ctx, "insertRecord", &_args223, &_result225)
  p.SetLastResponseMeta_(_meta224)
  if _err != nil {
    return
  }
  return _result225.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *TSStatus, _err error) {
  var _args226 TSIServiceInsertStringRecordArgs
  _args226.Req = req
  var _result228 TSIServiceInsertStringRecordResult
  var _meta227 thrift.ResponseMeta
  _meta227, _err = p.Client_().Call(ctx, "insertStringRecord", &_args226, &_result228)
  p.SetLastResponseMeta_(_meta227)
  if _err != nil {
    return
  }
  return _result228.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *TSStatus, _err error) {
  var _args229 TSIServiceInsertTabletArgs
  _args229.Req = req
  var _result231 TSIServiceInsertTabletResult
  var _meta230 thrift.ResponseMeta
  _meta230, _err = p.Client_().Call(ctx, "insertTablet", &_args229, &_result231)
  p.SetLastResponseMeta_(_meta230)
  if _err != nil {
    return
  }
  return _result231.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *TSStatus, _err error) {
  var _args232 TSIServiceInsertTabletsArgs
  _args232.Req = req
  var _result234 TSIServiceInsertTabletsResult
  var _meta233 thrift.ResponseMeta
  _meta233, _err = p.Client_().Call(ctx, "insertTablets", &_args232, &_result234)
  p.SetLastResponseMeta_(_meta233)
  if _err != nil {
    return
  }
  return _result234.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *TSStatus, _err error) {
  var _args235 TSIServiceInsertRecordsArgs
  _args235.Req = req
  var _result237 TSIServiceInsertRecordsResult
  var _meta236 thrift.ResponseMeta
  _meta236, _err = p.Client_().Call(ctx, "insertRecords", &_args235, &_result237)
  p.SetLastResponseMeta_(_meta236)
  if _err != nil {
    return
  }
  return _result237.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *TSStatus, _err error) {
  var _args238 TSIServiceInsertRecordsOfOneDeviceArgs
  _args238.Req = req
  var _result240 TSIServiceInsertRecordsOfOneDeviceResult
  var _meta239 thrift.ResponseMeta
  _meta239, _err = p.Client_().Call(ctx, "insertRecordsOfOneDevice", &_args238, &_result240)
  p.SetLastResponseMeta_(_meta239)
  if _err != nil {
    return
  }
  return _result240.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertStringRecordsOfOneDevice(ctx context.Context, req *TSInsertStringRecordsOfOneDeviceReq) (_r *TSStatus, _err error) {
  var _args241 TSIServiceInsertStringRecordsOfOneDeviceArgs
  _args241.Req = req
  var _result243 TSIServiceInsertStringRecordsOfOneDeviceResult
  var _meta242 thrift.ResponseMeta
  _meta242, _err = p.Client_().Call(ctx, "insertStringRecordsOfOneDevice", &_args241, &_result243)
  p.SetLastResponseMeta_(_meta242)
  if _err != nil {
    return
  }
  return _result243.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) InsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *TSStatus, _err error) {
  var _args244 TSIServiceInsertStringRecordsArgs
  _args244.Req = req
  var _result246 TSIServiceInsertStringRecordsResult
  var _meta245 thrift.ResponseMeta
  _meta245, _err = p.Client_().Call(ctx, "insertStringRecords", &_args244, &_result246)
  p.SetLastResponseMeta_(_meta245)
  if _err != nil {
    return
  }
  return _result246.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *TSStatus, _err error) {
  var _args247 TSIServiceTestInsertTabletArgs
  _args247.Req = req
  var _result249 TSIServiceTestInsertTabletResult
  var _meta248 thrift.ResponseMeta
  _meta248, _err = p.Client_().Call(ctx, "testInsertTablet", &_args247, &_result249)
  p.SetLastResponseMeta_(_meta248)
  if _err != nil {
    return
  }
  return _result249.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *TSStatus, _err error) {
  var _args250 TSIServiceTestInsertTabletsArgs
  _args250.Req = req
  var _result252 TSIServiceTestInsertTabletsResult
  var _meta251 thrift.ResponseMeta
  _meta251, _err = p.Client_().Call(ctx, "testInsertTablets", &_args250, &_result252)
  p.SetLastResponseMeta_(_meta251)
  if _err != nil {
    return
  }
  return _result252.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *TSStatus, _err error) {
  var _args253 TSIServiceTestInsertRecordArgs
  _args253.Req = req
  var _result255 TSIServiceTestInsertRecordResult
  var _meta254 thrift.ResponseMeta
  _meta254, _err = p.Client_().Call(ctx, "testInsertRecord", &_args253, &_result255)
  p.SetLastResponseMeta_(_meta254)
  if _err != nil {
    return
  }
  return _result255.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *TSStatus, _err error) {
  var _args256 TSIServiceTestInsertStringRecordArgs
  _args256.Req = req
  var _result258 TSIServiceTestInsertStringRecordResult
  var _meta257 thrift.ResponseMeta
  _meta257, _err = p.Client_().Call(ctx, "testInsertStringRecord", &_args256, &_result258)
  p.SetLastResponseMeta_(_meta257)
  if _err != nil {
    return
  }
  return _result258.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *TSStatus, _err error) {
  var _args259 TSIServiceTestInsertRecordsArgs
  _args259.Req = req
  var _result261 TSIServiceTestInsertRecordsResult
  var _meta260 thrift.ResponseMeta
  _meta260, _err = p.Client_().Call(ctx, "testInsertRecords", &_args259, &_result261)
  p.SetLastResponseMeta_(_meta260)
  if _err != nil {
    return
  }
  return _result261.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *TSStatus, _err error) {
  var _args262 TSIServiceTestInsertRecordsOfOneDeviceArgs
  _args262.Req = req
  var _result264 TSIServiceTestInsertRecordsOfOneDeviceResult
  var _meta263 thrift.ResponseMeta
  _meta263, _err = p.Client_().Call(ctx, "testInsertRecordsOfOneDevice", &_args262, &_result264)
  p.SetLastResponseMeta_(_meta263)
  if _err != nil {
    return
  }
  return _result264.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) TestInsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *TSStatus, _err error) {
  var _args265 TSIServiceTestInsertStringRecordsArgs
  _args265.Req = req
  var _result267 TSIServiceTestInsertStringRecordsResult
  var _meta266 thrift.ResponseMeta
  _meta266, _err = p.Client_().Call(ctx, "testInsertStringRecords", &_args265, &_result267)
  p.SetLastResponseMeta_(_meta266)
  if _err != nil {
    return
  }
  return _result267.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) DeleteData(ctx context.Context, req *TSDeleteDataReq) (_r *TSStatus, _err error) {
  var _args268 TSIServiceDeleteDataArgs
  _args268.Req = req
  var _result270 TSIServiceDeleteDataResult
  var _meta269 thrift.ResponseMeta
  _meta269, _err = p.Client_().Call(ctx, "deleteData", &_args268, &_result270)
  p.SetLastResponseMeta_(_meta269)
  if _err != nil {
    return
  }
  return _result270.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteRawDataQuery(ctx context.Context, req *TSRawDataQueryReq) (_r *TSExecuteStatementResp, _err error) {
  var _args271 TSIServiceExecuteRawDataQueryArgs
  _args271.Req = req
  var _result273 TSIServiceExecuteRawDataQueryResult
  var _meta272 thrift.ResponseMeta
  _meta272, _err = p.Client_().Call(ctx, "executeRawDataQuery", &_args271, &_result273)
  p.SetLastResponseMeta_(_meta272)
  if _err != nil {
    return
  }
  return _result273.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteLastDataQuery(ctx context.Context, req *TSLastDataQueryReq) (_r *TSExecuteStatementResp, _err error) {
  var _args274 TSIServiceExecuteLastDataQueryArgs
  _args274.Req = req
  var _result276 TSIServiceExecuteLastDataQueryResult
  var _meta275 thrift.ResponseMeta
  _meta275, _err = p.Client_().Call(ctx, "executeLastDataQuery", &_args274, &_result276)
  p.SetLastResponseMeta_(_meta275)
  if _err != nil {
    return
  }
  return _result276.GetSuccess(), nil
}

// Parameters:
//  - SessionId
func (p *TSIServiceClient) RequestStatementId(ctx context.Context, sessionId int64) (_r int64, _err error) {
  var _args277 TSIServiceRequestStatementIdArgs
  _args277.SessionId = sessionId
  var _result279 TSIServiceRequestStatementIdResult
  var _meta278 thrift.ResponseMeta
  _meta278, _err = p.Client_().Call(ctx, "requestStatementId", &_args277, &_result279)
  p.SetLastResponseMeta_(_meta278)
  if _err != nil {
    return
  }
  return _result279.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) CreateSchemaTemplate(ctx context.Context, req *TSCreateSchemaTemplateReq) (_r *TSStatus, _err error) {
  var _args280 TSIServiceCreateSchemaTemplateArgs
  _args280.Req = req
  var _result282 TSIServiceCreateSchemaTemplateResult
  var _meta281 thrift.ResponseMeta
  _meta281, _err = p.Client_().Call(ctx, "createSchemaTemplate", &_args280, &_result282)
  p.SetLastResponseMeta_(_meta281)
  if _err != nil {
    return
  }
  return _result282.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) AppendSchemaTemplate(ctx context.Context, req *TSAppendSchemaTemplateReq) (_r *TSStatus, _err error) {
  var _args283 TSIServiceAppendSchemaTemplateArgs
  _args283.Req = req
  var _result285 TSIServiceAppendSchemaTemplateResult
  var _meta284 thrift.ResponseMeta
  _meta284, _err = p.Client_().Call(ctx, "appendSchemaTemplate", &_args283, &_result285)
  p.SetLastResponseMeta_(_meta284)
  if _err != nil {
    return
  }
  return _result285.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) PruneSchemaTemplate(ctx context.Context, req *TSPruneSchemaTemplateReq) (_r *TSStatus, _err error) {
  var _args286 TSIServicePruneSchemaTemplateArgs
  _args286.Req = req
  var _result288 TSIServicePruneSchemaTemplateResult
  var _meta287 thrift.ResponseMeta
  _meta287, _err = p.Client_().Call(ctx, "pruneSchemaTemplate", &_args286, &_result288)
  p.SetLastResponseMeta_(_meta287)
  if _err != nil {
    return
  }
  return _result288.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) QuerySchemaTemplate(ctx context.Context, req *TSQueryTemplateReq) (_r *TSQueryTemplateResp, _err error) {
  var _args289 TSIServiceQuerySchemaTemplateArgs
  _args289.Req = req
  var _result291 TSIServiceQuerySchemaTemplateResult
  var _meta290 thrift.ResponseMeta
  _meta290, _err = p.Client_().Call(ctx, "querySchemaTemplate", &_args289, &_result291)
  p.SetLastResponseMeta_(_meta290)
  if _err != nil {
    return
  }
  return _result291.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) SetSchemaTemplate(ctx context.Context, req *TSSetSchemaTemplateReq) (_r *TSStatus, _err error) {
  var _args292 TSIServiceSetSchemaTemplateArgs
  _args292.Req = req
  var _result294 TSIServiceSetSchemaTemplateResult
  var _meta293 thrift.ResponseMeta
  _meta293, _err = p.Client_().Call(ctx, "setSchemaTemplate", &_args292, &_result294)
  p.SetLastResponseMeta_(_meta293)
  if _err != nil {
    return
  }
  return _result294.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) UnsetSchemaTemplate(ctx context.Context, req *TSUnsetSchemaTemplateReq) (_r *TSStatus, _err error) {
  var _args295 TSIServiceUnsetSchemaTemplateArgs
  _args295.Req = req
  var _result297 TSIServiceUnsetSchemaTemplateResult
  var _meta296 thrift.ResponseMeta
  _meta296, _err = p.Client_().Call(ctx, "unsetSchemaTemplate", &_args295, &_result297)
  p.SetLastResponseMeta_(_meta296)
  if _err != nil {
    return
  }
  return _result297.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) SetUsingTemplate(ctx context.Context, req *TSSetUsingTemplateReq) (_r *TSStatus, _err error) {
  var _args298 TSIServiceSetUsingTemplateArgs
  _args298.Req = req
  var _result300 TSIServiceSetUsingTemplateResult
  var _meta299 thrift.ResponseMeta
  _meta299, _err = p.Client_().Call(ctx, "setUsingTemplate", &_args298, &_result300)
  p.SetLastResponseMeta_(_meta299)
  if _err != nil {
    return
  }
  return _result300.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - TemplateName
//  - PrefixPath
func (p *TSIServiceClient) UnsetUsingTemplate(ctx context.Context, sessionId int64, templateName string, prefixPath string) (_r *TSStatus, _err error) {
  var _args301 TSIServiceUnsetUsingTemplateArgs
  _args301.SessionId = sessionId
  _args301.TemplateName = templateName
  _args301.PrefixPath = prefixPath
  var _result303 TSIServiceUnsetUsingTemplateResult
  var _meta302 thrift.ResponseMeta
  _meta302, _err = p.Client_().Call(ctx, "unsetUsingTemplate", &_args301, &_result303)
  p.SetLastResponseMeta_(_meta302)
  if _err != nil {
    return
  }
  return _result303.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) DropSchemaTemplate(ctx context.Context, req *TSDropSchemaTemplateReq) (_r *TSStatus, _err error) {
  var _args304 TSIServiceDropSchemaTemplateArgs
  _args304.Req = req
  var _result306 TSIServiceDropSchemaTemplateResult
  var _meta305 thrift.ResponseMeta
  _meta305, _err = p.Client_().Call(ctx, "dropSchemaTemplate", &_args304, &_result306)
  p.SetLastResponseMeta_(_meta305)
  if _err != nil {
    return
  }
  return _result306.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *TSIServiceClient) ExecuteOperationSync(ctx context.Context, req *TSOperationSyncWriteReq) (_r *TSStatus, _err error) {
  var _args307 TSIServiceExecuteOperationSyncArgs
  _args307.Req = req
  var _result309 TSIServiceExecuteOperationSyncResult
  var _meta308 thrift.ResponseMeta
  _meta308, _err = p.Client_().Call(ctx, "executeOperationSync", &_args307, &_result309)
  p.SetLastResponseMeta_(_meta308)
  if _err != nil {
    return
  }
  return _result309.GetSuccess(), nil
}

type TSIServiceProcessor struct {
  processorMap map[string]thrift.TProcessorFunction
  handler TSIService
}

func (p *TSIServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
  p.processorMap[key] = processor
}

func (p *TSIServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
  processor, ok = p.processorMap[key]
  return processor, ok
}

func (p *TSIServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
  return p.processorMap
}

func NewTSIServiceProcessor(handler TSIService) *TSIServiceProcessor {

  self310 := &TSIServiceProcessor{handler:handler, processorMap:make(map[string]thrift.TProcessorFunction)}
  self310.processorMap["openSession"] = &tSIServiceProcessorOpenSession{handler:handler}
  self310.processorMap["closeSession"] = &tSIServiceProcessorCloseSession{handler:handler}
  self310.processorMap["executeStatement"] = &tSIServiceProcessorExecuteStatement{handler:handler}
  self310.processorMap["executeBatchStatement"] = &tSIServiceProcessorExecuteBatchStatement{handler:handler}
  self310.processorMap["executeQueryStatement"] = &tSIServiceProcessorExecuteQueryStatement{handler:handler}
  self310.processorMap["executeUpdateStatement"] = &tSIServiceProcessorExecuteUpdateStatement{handler:handler}
  self310.processorMap["fetchResults"] = &tSIServiceProcessorFetchResults{handler:handler}
  self310.processorMap["fetchMetadata"] = &tSIServiceProcessorFetchMetadata{handler:handler}
  self310.processorMap["cancelOperation"] = &tSIServiceProcessorCancelOperation{handler:handler}
  self310.processorMap["closeOperation"] = &tSIServiceProcessorCloseOperation{handler:handler}
  self310.processorMap["getSystemStatus"] = &tSIServiceProcessorGetSystemStatus{handler:handler}
  self310.processorMap["getTimeZone"] = &tSIServiceProcessorGetTimeZone{handler:handler}
  self310.processorMap["setTimeZone"] = &tSIServiceProcessorSetTimeZone{handler:handler}
  self310.processorMap["getProperties"] = &tSIServiceProcessorGetProperties{handler:handler}
  self310.processorMap["setStorageGroup"] = &tSIServiceProcessorSetStorageGroup{handler:handler}
  self310.processorMap["createTimeseries"] = &tSIServiceProcessorCreateTimeseries{handler:handler}
  self310.processorMap["createAlignedTimeseries"] = &tSIServiceProcessorCreateAlignedTimeseries{handler:handler}
  self310.processorMap["createMultiTimeseries"] = &tSIServiceProcessorCreateMultiTimeseries{handler:handler}
  self310.processorMap["deleteTimeseries"] = &tSIServiceProcessorDeleteTimeseries{handler:handler}
  self310.processorMap["deleteStorageGroups"] = &tSIServiceProcessorDeleteStorageGroups{handler:handler}
  self310.processorMap["insertRecord"] = &tSIServiceProcessorInsertRecord{handler:handler}
  self310.processorMap["insertStringRecord"] = &tSIServiceProcessorInsertStringRecord{handler:handler}
  self310.processorMap["insertTablet"] = &tSIServiceProcessorInsertTablet{handler:handler}
  self310.processorMap["insertTablets"] = &tSIServiceProcessorInsertTablets{handler:handler}
  self310.processorMap["insertRecords"] = &tSIServiceProcessorInsertRecords{handler:handler}
  self310.processorMap["insertRecordsOfOneDevice"] = &tSIServiceProcessorInsertRecordsOfOneDevice{handler:handler}
  self310.processorMap["insertStringRecordsOfOneDevice"] = &tSIServiceProcessorInsertStringRecordsOfOneDevice{handler:handler}
  self310.processorMap["insertStringRecords"] = &tSIServiceProcessorInsertStringRecords{handler:handler}
  self310.processorMap["testInsertTablet"] = &tSIServiceProcessorTestInsertTablet{handler:handler}
  self310.processorMap["testInsertTablets"] = &tSIServiceProcessorTestInsertTablets{handler:handler}
  self310.processorMap["testInsertRecord"] = &tSIServiceProcessorTestInsertRecord{handler:handler}
  self310.processorMap["testInsertStringRecord"] = &tSIServiceProcessorTestInsertStringRecord{handler:handler}
  self310.processorMap["testInsertRecords"] = &tSIServiceProcessorTestInsertRecords{handler:handler}
  self310.processorMap["testInsertRecordsOfOneDevice"] = &tSIServiceProcessorTestInsertRecordsOfOneDevice{handler:handler}
  self310.processorMap["testInsertStringRecords"] = &tSIServiceProcessorTestInsertStringRecords{handler:handler}
  self310.processorMap["deleteData"] = &tSIServiceProcessorDeleteData{handler:handler}
  self310.processorMap["executeRawDataQuery"] = &tSIServiceProcessorExecuteRawDataQuery{handler:handler}
  self310.processorMap["executeLastDataQuery"] = &tSIServiceProcessorExecuteLastDataQuery{handler:handler}
  self310.processorMap["requestStatementId"] = &tSIServiceProcessorRequestStatementId{handler:handler}
  self310.processorMap["createSchemaTemplate"] = &tSIServiceProcessorCreateSchemaTemplate{handler:handler}
  self310.processorMap["appendSchemaTemplate"] = &tSIServiceProcessorAppendSchemaTemplate{handler:handler}
  self310.processorMap["pruneSchemaTemplate"] = &tSIServiceProcessorPruneSchemaTemplate{handler:handler}
  self310.processorMap["querySchemaTemplate"] = &tSIServiceProcessorQuerySchemaTemplate{handler:handler}
  self310.processorMap["setSchemaTemplate"] = &tSIServiceProcessorSetSchemaTemplate{handler:handler}
  self310.processorMap["unsetSchemaTemplate"] = &tSIServiceProcessorUnsetSchemaTemplate{handler:handler}
  self310.processorMap["setUsingTemplate"] = &tSIServiceProcessorSetUsingTemplate{handler:handler}
  self310.processorMap["unsetUsingTemplate"] = &tSIServiceProcessorUnsetUsingTemplate{handler:handler}
  self310.processorMap["dropSchemaTemplate"] = &tSIServiceProcessorDropSchemaTemplate{handler:handler}
  self310.processorMap["executeOperationSync"] = &tSIServiceProcessorExecuteOperationSync{handler:handler}
return self310
}

func (p *TSIServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  name, _, seqId, err2 := iprot.ReadMessageBegin(ctx)
  if err2 != nil { return false, thrift.WrapTException(err2) }
  if processor, ok := p.GetProcessorFunction(name); ok {
    return processor.Process(ctx, seqId, iprot, oprot)
  }
  iprot.Skip(ctx, thrift.STRUCT)
  iprot.ReadMessageEnd(ctx)
  x311 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function " + name)
  oprot.WriteMessageBegin(ctx, name, thrift.EXCEPTION, seqId)
  x311.Write(ctx, oprot)
  oprot.WriteMessageEnd(ctx)
  oprot.Flush(ctx)
  return false, x311

}

type tSIServiceProcessorOpenSession struct {
  handler TSIService
}

func (p *tSIServiceProcessorOpenSession) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceOpenSessionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "openSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceOpenSessionResult{}
  var retval *TSOpenSessionResp
  if retval, err2 = p.handler.OpenSession(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing openSession: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "openSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "openSession", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorCloseSession struct {
  handler TSIService
}

func (p *tSIServiceProcessorCloseSession) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceCloseSessionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "closeSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceCloseSessionResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CloseSession(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing closeSession: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "closeSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "closeSession", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorExecuteStatement struct {
  handler TSIService
}

func (p *tSIServiceProcessorExecuteStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceExecuteStatementArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceExecuteStatementResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteStatement(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeStatement: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeStatement", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorExecuteBatchStatement struct {
  handler TSIService
}

func (p *tSIServiceProcessorExecuteBatchStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceExecuteBatchStatementArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceExecuteBatchStatementResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.ExecuteBatchStatement(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeBatchStatement: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorExecuteQueryStatement struct {
  handler TSIService
}

func (p *tSIServiceProcessorExecuteQueryStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceExecuteQueryStatementArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceExecuteQueryStatementResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteQueryStatement(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeQueryStatement: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorExecuteUpdateStatement struct {
  handler TSIService
}

func (p *tSIServiceProcessorExecuteUpdateStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceExecuteUpdateStatementArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceExecuteUpdateStatementResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteUpdateStatement(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeUpdateStatement: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorFetchResults struct {
  handler TSIService
}

func (p *tSIServiceProcessorFetchResults) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceFetchResultsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchResults", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceFetchResultsResult{}
  var retval *TSFetchResultsResp
  if retval, err2 = p.handler.FetchResults(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchResults: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchResults", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchResults", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorFetchMetadata struct {
  handler TSIService
}

func (p *tSIServiceProcessorFetchMetadata) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceFetchMetadataArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceFetchMetadataResult{}
  var retval *TSFetchMetadataResp
  if retval, err2 = p.handler.FetchMetadata(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchMetadata: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorCancelOperation struct {
  handler TSIService
}

func (p *tSIServiceProcessorCancelOperation) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceCancelOperationArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceCancelOperationResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CancelOperation(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing cancelOperation: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorCloseOperation struct {
  handler TSIService
}

func (p *tSIServiceProcessorCloseOperation) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceCloseOperationArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "closeOperation", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceCloseOperationResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CloseOperation(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing closeOperation: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "closeOperation", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "closeOperation", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorGetSystemStatus struct {
  handler TSIService
}

func (p *tSIServiceProcessorGetSystemStatus) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceGetSystemStatusArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getSystemStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceGetSystemStatusResult{}
  var retval *TSGetSystemStatusResp
  if retval, err2 = p.handler.GetSystemStatus(ctx, args.SessionId); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getSystemStatus: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getSystemStatus", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getSystemStatus", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorGetTimeZone struct {
  handler TSIService
}

func (p *tSIServiceProcessorGetTimeZone) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceGetTimeZoneArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceGetTimeZoneResult{}
  var retval *TSGetTimeZoneResp
  if retval, err2 = p.handler.GetTimeZone(ctx, args.SessionId); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getTimeZone: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorSetTimeZone struct {
  handler TSIService
}

func (p *tSIServiceProcessorSetTimeZone) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceSetTimeZoneArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceSetTimeZoneResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.SetTimeZone(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setTimeZone: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorGetProperties struct {
  handler TSIService
}

func (p *tSIServiceProcessorGetProperties) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceGetPropertiesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getProperties", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceGetPropertiesResult{}
  var retval *ServerProperties
  if retval, err2 = p.handler.GetProperties(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getProperties: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getProperties", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getProperties", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorSetStorageGroup struct {
  handler TSIService
}

func (p *tSIServiceProcessorSetStorageGroup) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceSetStorageGroupArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceSetStorageGroupResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.SetStorageGroup(ctx, args.SessionId, args.StorageGroup); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setStorageGroup: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorCreateTimeseries struct {
  handler TSIService
}

func (p *tSIServiceProcessorCreateTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceCreateTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceCreateTimeseriesResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CreateTimeseries(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorCreateAlignedTimeseries struct {
  handler TSIService
}

func (p *tSIServiceProcessorCreateAlignedTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceCreateAlignedTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createAlignedTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceCreateAlignedTimeseriesResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CreateAlignedTimeseries(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createAlignedTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createAlignedTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createAlignedTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorCreateMultiTimeseries struct {
  handler TSIService
}

func (p *tSIServiceProcessorCreateMultiTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceCreateMultiTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceCreateMultiTimeseriesResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CreateMultiTimeseries(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createMultiTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorDeleteTimeseries struct {
  handler TSIService
}

func (p *tSIServiceProcessorDeleteTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceDeleteTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceDeleteTimeseriesResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.DeleteTimeseries(ctx, args.SessionId, args.Path); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorDeleteStorageGroups struct {
  handler TSIService
}

func (p *tSIServiceProcessorDeleteStorageGroups) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceDeleteStorageGroupsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceDeleteStorageGroupsResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.DeleteStorageGroups(ctx, args.SessionId, args.StorageGroup); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteStorageGroups: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorInsertRecord struct {
  handler TSIService
}

func (p *tSIServiceProcessorInsertRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceInsertRecordArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceInsertRecordResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.InsertRecord(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecord: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertRecord", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorInsertStringRecord struct {
  handler TSIService
}

func (p *tSIServiceProcessorInsertStringRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceInsertStringRecordArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceInsertStringRecordResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.InsertStringRecord(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertStringRecord: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorInsertTablet struct {
  handler TSIService
}

func (p *tSIServiceProcessorInsertTablet) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceInsertTabletArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertTablet", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceInsertTabletResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.InsertTablet(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertTablet: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertTablet", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertTablet", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorInsertTablets struct {
  handler TSIService
}

func (p *tSIServiceProcessorInsertTablets) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceInsertTabletsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertTablets", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceInsertTabletsResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.InsertTablets(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertTablets: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertTablets", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertTablets", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorInsertRecords struct {
  handler TSIService
}

func (p *tSIServiceProcessorInsertRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceInsertRecordsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceInsertRecordsResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.InsertRecords(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecords: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertRecords", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorInsertRecordsOfOneDevice struct {
  handler TSIService
}

func (p *tSIServiceProcessorInsertRecordsOfOneDevice) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceInsertRecordsOfOneDeviceArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceInsertRecordsOfOneDeviceResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.InsertRecordsOfOneDevice(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecordsOfOneDevice: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorInsertStringRecordsOfOneDevice struct {
  handler TSIService
}

func (p *tSIServiceProcessorInsertStringRecordsOfOneDevice) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceInsertStringRecordsOfOneDeviceArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceInsertStringRecordsOfOneDeviceResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.InsertStringRecordsOfOneDevice(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertStringRecordsOfOneDevice: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertStringRecordsOfOneDevice", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorInsertStringRecords struct {
  handler TSIService
}

func (p *tSIServiceProcessorInsertStringRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceInsertStringRecordsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceInsertStringRecordsResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.InsertStringRecords(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertStringRecords: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorTestInsertTablet struct {
  handler TSIService
}

func (p *tSIServiceProcessorTestInsertTablet) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceTestInsertTabletArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceTestInsertTabletResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.TestInsertTablet(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertTablet: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorTestInsertTablets struct {
  handler TSIService
}

func (p *tSIServiceProcessorTestInsertTablets) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceTestInsertTabletsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceTestInsertTabletsResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.TestInsertTablets(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertTablets: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorTestInsertRecord struct {
  handler TSIService
}

func (p *tSIServiceProcessorTestInsertRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceTestInsertRecordArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceTestInsertRecordResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.TestInsertRecord(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecord: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorTestInsertStringRecord struct {
  handler TSIService
}

func (p *tSIServiceProcessorTestInsertStringRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceTestInsertStringRecordArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceTestInsertStringRecordResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.TestInsertStringRecord(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertStringRecord: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorTestInsertRecords struct {
  handler TSIService
}

func (p *tSIServiceProcessorTestInsertRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceTestInsertRecordsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceTestInsertRecordsResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.TestInsertRecords(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecords: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorTestInsertRecordsOfOneDevice struct {
  handler TSIService
}

func (p *tSIServiceProcessorTestInsertRecordsOfOneDevice) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceTestInsertRecordsOfOneDeviceArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceTestInsertRecordsOfOneDeviceResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.TestInsertRecordsOfOneDevice(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecordsOfOneDevice: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorTestInsertStringRecords struct {
  handler TSIService
}

func (p *tSIServiceProcessorTestInsertStringRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceTestInsertStringRecordsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceTestInsertStringRecordsResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.TestInsertStringRecords(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertStringRecords: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorDeleteData struct {
  handler TSIService
}

func (p *tSIServiceProcessorDeleteData) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceDeleteDataArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteData", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceDeleteDataResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.DeleteData(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteData: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteData", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "deleteData", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorExecuteRawDataQuery struct {
  handler TSIService
}

func (p *tSIServiceProcessorExecuteRawDataQuery) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceExecuteRawDataQueryArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceExecuteRawDataQueryResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteRawDataQuery(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeRawDataQuery: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorExecuteLastDataQuery struct {
  handler TSIService
}

func (p *tSIServiceProcessorExecuteLastDataQuery) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceExecuteLastDataQueryArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeLastDataQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceExecuteLastDataQueryResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteLastDataQuery(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeLastDataQuery: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeLastDataQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeLastDataQuery", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorRequestStatementId struct {
  handler TSIService
}

func (p *tSIServiceProcessorRequestStatementId) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceRequestStatementIdArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceRequestStatementIdResult{}
  var retval int64
  if retval, err2 = p.handler.RequestStatementId(ctx, args.SessionId); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing requestStatementId: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorCreateSchemaTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorCreateSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceCreateSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceCreateSchemaTemplateResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.CreateSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorAppendSchemaTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorAppendSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceAppendSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "appendSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceAppendSchemaTemplateResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.AppendSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing appendSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "appendSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "appendSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorPruneSchemaTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorPruneSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServicePruneSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "pruneSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServicePruneSchemaTemplateResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.PruneSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing pruneSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "pruneSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "pruneSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorQuerySchemaTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorQuerySchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceQuerySchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "querySchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceQuerySchemaTemplateResult{}
  var retval *TSQueryTemplateResp
  if retval, err2 = p.handler.QuerySchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing querySchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "querySchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "querySchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorSetSchemaTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorSetSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceSetSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "setSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceSetSchemaTemplateResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.SetSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "setSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "setSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorUnsetSchemaTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorUnsetSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceUnsetSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "unsetSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceUnsetSchemaTemplateResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.UnsetSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing unsetSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "unsetSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "unsetSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorSetUsingTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorSetUsingTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceSetUsingTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "setUsingTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceSetUsingTemplateResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.SetUsingTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setUsingTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "setUsingTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "setUsingTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorUnsetUsingTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorUnsetUsingTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceUnsetUsingTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "unsetUsingTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceUnsetUsingTemplateResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.UnsetUsingTemplate(ctx, args.SessionId, args.TemplateName, args.PrefixPath); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing unsetUsingTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "unsetUsingTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "unsetUsingTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorDropSchemaTemplate struct {
  handler TSIService
}

func (p *tSIServiceProcessorDropSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceDropSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "dropSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceDropSchemaTemplateResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.DropSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing dropSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "dropSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "dropSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type tSIServiceProcessorExecuteOperationSync struct {
  handler TSIService
}

func (p *tSIServiceProcessorExecuteOperationSync) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := TSIServiceExecuteOperationSyncArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeOperationSync", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := TSIServiceExecuteOperationSyncResult{}
  var retval *TSStatus
  if retval, err2 = p.handler.ExecuteOperationSync(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeOperationSync: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeOperationSync", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeOperationSync", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Req
type TSIServiceOpenSessionArgs struct {
  Req *TSOpenSessionReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceOpenSessionArgs() *TSIServiceOpenSessionArgs {
  return &TSIServiceOpenSessionArgs{}
}

var TSIServiceOpenSessionArgs_Req_DEFAULT *TSOpenSessionReq
func (p *TSIServiceOpenSessionArgs) GetReq() *TSOpenSessionReq {
  if !p.IsSetReq() {
    return TSIServiceOpenSessionArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceOpenSessionArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceOpenSessionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceOpenSessionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSOpenSessionReq{
  ClientProtocol:   2,
}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceOpenSessionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "openSession_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceOpenSessionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceOpenSessionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceOpenSessionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceOpenSessionResult struct {
  Success *TSOpenSessionResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceOpenSessionResult() *TSIServiceOpenSessionResult {
  return &TSIServiceOpenSessionResult{}
}

var TSIServiceOpenSessionResult_Success_DEFAULT *TSOpenSessionResp
func (p *TSIServiceOpenSessionResult) GetSuccess() *TSOpenSessionResp {
  if !p.IsSetSuccess() {
    return TSIServiceOpenSessionResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceOpenSessionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceOpenSessionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceOpenSessionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSOpenSessionResp{
  ServerProtocolVersion:   0,
}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceOpenSessionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "openSession_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceOpenSessionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceOpenSessionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceOpenSessionResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCloseSessionArgs struct {
  Req *TSCloseSessionReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCloseSessionArgs() *TSIServiceCloseSessionArgs {
  return &TSIServiceCloseSessionArgs{}
}

var TSIServiceCloseSessionArgs_Req_DEFAULT *TSCloseSessionReq
func (p *TSIServiceCloseSessionArgs) GetReq() *TSCloseSessionReq {
  if !p.IsSetReq() {
    return TSIServiceCloseSessionArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceCloseSessionArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceCloseSessionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCloseSessionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCloseSessionReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceCloseSessionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeSession_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCloseSessionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceCloseSessionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCloseSessionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCloseSessionResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCloseSessionResult() *TSIServiceCloseSessionResult {
  return &TSIServiceCloseSessionResult{}
}

var TSIServiceCloseSessionResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCloseSessionResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceCloseSessionResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceCloseSessionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceCloseSessionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCloseSessionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceCloseSessionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeSession_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCloseSessionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceCloseSessionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCloseSessionResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteStatementArgs struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteStatementArgs() *TSIServiceExecuteStatementArgs {
  return &TSIServiceExecuteStatementArgs{}
}

var TSIServiceExecuteStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *TSIServiceExecuteStatementArgs) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return TSIServiceExecuteStatementArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceExecuteStatementArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceExecuteStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceExecuteStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeStatement_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceExecuteStatementArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteStatementResult struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteStatementResult() *TSIServiceExecuteStatementResult {
  return &TSIServiceExecuteStatementResult{}
}

var TSIServiceExecuteStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteStatementResult) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return TSIServiceExecuteStatementResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceExecuteStatementResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceExecuteStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceExecuteStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeStatement_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceExecuteStatementResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteBatchStatementArgs struct {
  Req *TSExecuteBatchStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteBatchStatementArgs() *TSIServiceExecuteBatchStatementArgs {
  return &TSIServiceExecuteBatchStatementArgs{}
}

var TSIServiceExecuteBatchStatementArgs_Req_DEFAULT *TSExecuteBatchStatementReq
func (p *TSIServiceExecuteBatchStatementArgs) GetReq() *TSExecuteBatchStatementReq {
  if !p.IsSetReq() {
    return TSIServiceExecuteBatchStatementArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceExecuteBatchStatementArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceExecuteBatchStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteBatchStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteBatchStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceExecuteBatchStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeBatchStatement_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteBatchStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceExecuteBatchStatementArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteBatchStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteBatchStatementResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteBatchStatementResult() *TSIServiceExecuteBatchStatementResult {
  return &TSIServiceExecuteBatchStatementResult{}
}

var TSIServiceExecuteBatchStatementResult_Success_DEFAULT *TSStatus
func (p *TSIServiceExecuteBatchStatementResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceExecuteBatchStatementResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceExecuteBatchStatementResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceExecuteBatchStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteBatchStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceExecuteBatchStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeBatchStatement_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteBatchStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceExecuteBatchStatementResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteBatchStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteQueryStatementArgs struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteQueryStatementArgs() *TSIServiceExecuteQueryStatementArgs {
  return &TSIServiceExecuteQueryStatementArgs{}
}

var TSIServiceExecuteQueryStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *TSIServiceExecuteQueryStatementArgs) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return TSIServiceExecuteQueryStatementArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceExecuteQueryStatementArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceExecuteQueryStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteQueryStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceExecuteQueryStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeQueryStatement_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteQueryStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceExecuteQueryStatementArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteQueryStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteQueryStatementResult struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteQueryStatementResult() *TSIServiceExecuteQueryStatementResult {
  return &TSIServiceExecuteQueryStatementResult{}
}

var TSIServiceExecuteQueryStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteQueryStatementResult) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return TSIServiceExecuteQueryStatementResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceExecuteQueryStatementResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceExecuteQueryStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteQueryStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceExecuteQueryStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeQueryStatement_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteQueryStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceExecuteQueryStatementResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteQueryStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteUpdateStatementArgs struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteUpdateStatementArgs() *TSIServiceExecuteUpdateStatementArgs {
  return &TSIServiceExecuteUpdateStatementArgs{}
}

var TSIServiceExecuteUpdateStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *TSIServiceExecuteUpdateStatementArgs) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return TSIServiceExecuteUpdateStatementArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceExecuteUpdateStatementArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceExecuteUpdateStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteUpdateStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceExecuteUpdateStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeUpdateStatement_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteUpdateStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceExecuteUpdateStatementArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteUpdateStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteUpdateStatementResult struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteUpdateStatementResult() *TSIServiceExecuteUpdateStatementResult {
  return &TSIServiceExecuteUpdateStatementResult{}
}

var TSIServiceExecuteUpdateStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteUpdateStatementResult) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return TSIServiceExecuteUpdateStatementResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceExecuteUpdateStatementResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceExecuteUpdateStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteUpdateStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceExecuteUpdateStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeUpdateStatement_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteUpdateStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceExecuteUpdateStatementResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteUpdateStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceFetchResultsArgs struct {
  Req *TSFetchResultsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceFetchResultsArgs() *TSIServiceFetchResultsArgs {
  return &TSIServiceFetchResultsArgs{}
}

var TSIServiceFetchResultsArgs_Req_DEFAULT *TSFetchResultsReq
func (p *TSIServiceFetchResultsArgs) GetReq() *TSFetchResultsReq {
  if !p.IsSetReq() {
    return TSIServiceFetchResultsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceFetchResultsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceFetchResultsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceFetchResultsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSFetchResultsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceFetchResultsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchResults_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceFetchResultsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceFetchResultsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceFetchResultsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceFetchResultsResult struct {
  Success *TSFetchResultsResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceFetchResultsResult() *TSIServiceFetchResultsResult {
  return &TSIServiceFetchResultsResult{}
}

var TSIServiceFetchResultsResult_Success_DEFAULT *TSFetchResultsResp
func (p *TSIServiceFetchResultsResult) GetSuccess() *TSFetchResultsResp {
  if !p.IsSetSuccess() {
    return TSIServiceFetchResultsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceFetchResultsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceFetchResultsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceFetchResultsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSFetchResultsResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceFetchResultsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchResults_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceFetchResultsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceFetchResultsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceFetchResultsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceFetchMetadataArgs struct {
  Req *TSFetchMetadataReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceFetchMetadataArgs() *TSIServiceFetchMetadataArgs {
  return &TSIServiceFetchMetadataArgs{}
}

var TSIServiceFetchMetadataArgs_Req_DEFAULT *TSFetchMetadataReq
func (p *TSIServiceFetchMetadataArgs) GetReq() *TSFetchMetadataReq {
  if !p.IsSetReq() {
    return TSIServiceFetchMetadataArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceFetchMetadataArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceFetchMetadataArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceFetchMetadataArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSFetchMetadataReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceFetchMetadataArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchMetadata_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceFetchMetadataArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceFetchMetadataArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceFetchMetadataArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceFetchMetadataResult struct {
  Success *TSFetchMetadataResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceFetchMetadataResult() *TSIServiceFetchMetadataResult {
  return &TSIServiceFetchMetadataResult{}
}

var TSIServiceFetchMetadataResult_Success_DEFAULT *TSFetchMetadataResp
func (p *TSIServiceFetchMetadataResult) GetSuccess() *TSFetchMetadataResp {
  if !p.IsSetSuccess() {
    return TSIServiceFetchMetadataResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceFetchMetadataResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceFetchMetadataResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceFetchMetadataResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSFetchMetadataResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceFetchMetadataResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchMetadata_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceFetchMetadataResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceFetchMetadataResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceFetchMetadataResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCancelOperationArgs struct {
  Req *TSCancelOperationReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCancelOperationArgs() *TSIServiceCancelOperationArgs {
  return &TSIServiceCancelOperationArgs{}
}

var TSIServiceCancelOperationArgs_Req_DEFAULT *TSCancelOperationReq
func (p *TSIServiceCancelOperationArgs) GetReq() *TSCancelOperationReq {
  if !p.IsSetReq() {
    return TSIServiceCancelOperationArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceCancelOperationArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceCancelOperationArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCancelOperationArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCancelOperationReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceCancelOperationArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "cancelOperation_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCancelOperationArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceCancelOperationArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCancelOperationArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCancelOperationResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCancelOperationResult() *TSIServiceCancelOperationResult {
  return &TSIServiceCancelOperationResult{}
}

var TSIServiceCancelOperationResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCancelOperationResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceCancelOperationResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceCancelOperationResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceCancelOperationResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCancelOperationResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceCancelOperationResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "cancelOperation_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCancelOperationResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceCancelOperationResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCancelOperationResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCloseOperationArgs struct {
  Req *TSCloseOperationReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCloseOperationArgs() *TSIServiceCloseOperationArgs {
  return &TSIServiceCloseOperationArgs{}
}

var TSIServiceCloseOperationArgs_Req_DEFAULT *TSCloseOperationReq
func (p *TSIServiceCloseOperationArgs) GetReq() *TSCloseOperationReq {
  if !p.IsSetReq() {
    return TSIServiceCloseOperationArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceCloseOperationArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceCloseOperationArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCloseOperationArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCloseOperationReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceCloseOperationArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeOperation_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCloseOperationArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceCloseOperationArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCloseOperationArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCloseOperationResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCloseOperationResult() *TSIServiceCloseOperationResult {
  return &TSIServiceCloseOperationResult{}
}

var TSIServiceCloseOperationResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCloseOperationResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceCloseOperationResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceCloseOperationResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceCloseOperationResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCloseOperationResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceCloseOperationResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeOperation_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCloseOperationResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceCloseOperationResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCloseOperationResult(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSIServiceGetSystemStatusArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
}

func NewTSIServiceGetSystemStatusArgs() *TSIServiceGetSystemStatusArgs {
  return &TSIServiceGetSystemStatusArgs{}
}


func (p *TSIServiceGetSystemStatusArgs) GetSessionId() int64 {
  return p.SessionId
}
func (p *TSIServiceGetSystemStatusArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceGetSystemStatusArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSIServiceGetSystemStatusArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getSystemStatus_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceGetSystemStatusArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSIServiceGetSystemStatusArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceGetSystemStatusArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceGetSystemStatusResult struct {
  Success *TSGetSystemStatusResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceGetSystemStatusResult() *TSIServiceGetSystemStatusResult {
  return &TSIServiceGetSystemStatusResult{}
}

var TSIServiceGetSystemStatusResult_Success_DEFAULT *TSGetSystemStatusResp
func (p *TSIServiceGetSystemStatusResult) GetSuccess() *TSGetSystemStatusResp {
  if !p.IsSetSuccess() {
    return TSIServiceGetSystemStatusResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceGetSystemStatusResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceGetSystemStatusResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceGetSystemStatusResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSGetSystemStatusResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceGetSystemStatusResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getSystemStatus_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceGetSystemStatusResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceGetSystemStatusResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceGetSystemStatusResult(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSIServiceGetTimeZoneArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
}

func NewTSIServiceGetTimeZoneArgs() *TSIServiceGetTimeZoneArgs {
  return &TSIServiceGetTimeZoneArgs{}
}


func (p *TSIServiceGetTimeZoneArgs) GetSessionId() int64 {
  return p.SessionId
}
func (p *TSIServiceGetTimeZoneArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceGetTimeZoneArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSIServiceGetTimeZoneArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getTimeZone_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceGetTimeZoneArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSIServiceGetTimeZoneArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceGetTimeZoneArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceGetTimeZoneResult struct {
  Success *TSGetTimeZoneResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceGetTimeZoneResult() *TSIServiceGetTimeZoneResult {
  return &TSIServiceGetTimeZoneResult{}
}

var TSIServiceGetTimeZoneResult_Success_DEFAULT *TSGetTimeZoneResp
func (p *TSIServiceGetTimeZoneResult) GetSuccess() *TSGetTimeZoneResp {
  if !p.IsSetSuccess() {
    return TSIServiceGetTimeZoneResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceGetTimeZoneResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceGetTimeZoneResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceGetTimeZoneResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSGetTimeZoneResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceGetTimeZoneResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getTimeZone_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceGetTimeZoneResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceGetTimeZoneResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceGetTimeZoneResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceSetTimeZoneArgs struct {
  Req *TSSetTimeZoneReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceSetTimeZoneArgs() *TSIServiceSetTimeZoneArgs {
  return &TSIServiceSetTimeZoneArgs{}
}

var TSIServiceSetTimeZoneArgs_Req_DEFAULT *TSSetTimeZoneReq
func (p *TSIServiceSetTimeZoneArgs) GetReq() *TSSetTimeZoneReq {
  if !p.IsSetReq() {
    return TSIServiceSetTimeZoneArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceSetTimeZoneArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceSetTimeZoneArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceSetTimeZoneArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSSetTimeZoneReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceSetTimeZoneArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setTimeZone_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceSetTimeZoneArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceSetTimeZoneArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceSetTimeZoneArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceSetTimeZoneResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceSetTimeZoneResult() *TSIServiceSetTimeZoneResult {
  return &TSIServiceSetTimeZoneResult{}
}

var TSIServiceSetTimeZoneResult_Success_DEFAULT *TSStatus
func (p *TSIServiceSetTimeZoneResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceSetTimeZoneResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceSetTimeZoneResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceSetTimeZoneResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceSetTimeZoneResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceSetTimeZoneResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setTimeZone_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceSetTimeZoneResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceSetTimeZoneResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceSetTimeZoneResult(%+v)", *p)
}

type TSIServiceGetPropertiesArgs struct {
}

func NewTSIServiceGetPropertiesArgs() *TSIServiceGetPropertiesArgs {
  return &TSIServiceGetPropertiesArgs{}
}

func (p *TSIServiceGetPropertiesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceGetPropertiesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getProperties_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceGetPropertiesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceGetPropertiesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceGetPropertiesResult struct {
  Success *ServerProperties `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceGetPropertiesResult() *TSIServiceGetPropertiesResult {
  return &TSIServiceGetPropertiesResult{}
}

var TSIServiceGetPropertiesResult_Success_DEFAULT *ServerProperties
func (p *TSIServiceGetPropertiesResult) GetSuccess() *ServerProperties {
  if !p.IsSetSuccess() {
    return TSIServiceGetPropertiesResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceGetPropertiesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceGetPropertiesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceGetPropertiesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &ServerProperties{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceGetPropertiesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getProperties_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceGetPropertiesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceGetPropertiesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceGetPropertiesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - StorageGroup
type TSIServiceSetStorageGroupArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
  StorageGroup string `thrift:"storageGroup,2" db:"storageGroup" json:"storageGroup"`
}

func NewTSIServiceSetStorageGroupArgs() *TSIServiceSetStorageGroupArgs {
  return &TSIServiceSetStorageGroupArgs{}
}


func (p *TSIServiceSetStorageGroupArgs) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSIServiceSetStorageGroupArgs) GetStorageGroup() string {
  return p.StorageGroup
}
func (p *TSIServiceSetStorageGroupArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceSetStorageGroupArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSIServiceSetStorageGroupArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.StorageGroup = v
}
  return nil
}

func (p *TSIServiceSetStorageGroupArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setStorageGroup_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceSetStorageGroupArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSIServiceSetStorageGroupArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "storageGroup", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:storageGroup: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.StorageGroup)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.storageGroup (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:storageGroup: ", p), err) }
  return err
}

func (p *TSIServiceSetStorageGroupArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceSetStorageGroupArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceSetStorageGroupResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceSetStorageGroupResult() *TSIServiceSetStorageGroupResult {
  return &TSIServiceSetStorageGroupResult{}
}

var TSIServiceSetStorageGroupResult_Success_DEFAULT *TSStatus
func (p *TSIServiceSetStorageGroupResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceSetStorageGroupResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceSetStorageGroupResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceSetStorageGroupResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceSetStorageGroupResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceSetStorageGroupResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setStorageGroup_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceSetStorageGroupResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceSetStorageGroupResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceSetStorageGroupResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCreateTimeseriesArgs struct {
  Req *TSCreateTimeseriesReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCreateTimeseriesArgs() *TSIServiceCreateTimeseriesArgs {
  return &TSIServiceCreateTimeseriesArgs{}
}

var TSIServiceCreateTimeseriesArgs_Req_DEFAULT *TSCreateTimeseriesReq
func (p *TSIServiceCreateTimeseriesArgs) GetReq() *TSCreateTimeseriesReq {
  if !p.IsSetReq() {
    return TSIServiceCreateTimeseriesArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceCreateTimeseriesArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceCreateTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCreateTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCreateTimeseriesReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceCreateTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCreateTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceCreateTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCreateTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCreateTimeseriesResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCreateTimeseriesResult() *TSIServiceCreateTimeseriesResult {
  return &TSIServiceCreateTimeseriesResult{}
}

var TSIServiceCreateTimeseriesResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCreateTimeseriesResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceCreateTimeseriesResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceCreateTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceCreateTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCreateTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceCreateTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCreateTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceCreateTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCreateTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCreateAlignedTimeseriesArgs struct {
  Req *TSCreateAlignedTimeseriesReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCreateAlignedTimeseriesArgs() *TSIServiceCreateAlignedTimeseriesArgs {
  return &TSIServiceCreateAlignedTimeseriesArgs{}
}

var TSIServiceCreateAlignedTimeseriesArgs_Req_DEFAULT *TSCreateAlignedTimeseriesReq
func (p *TSIServiceCreateAlignedTimeseriesArgs) GetReq() *TSCreateAlignedTimeseriesReq {
  if !p.IsSetReq() {
    return TSIServiceCreateAlignedTimeseriesArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceCreateAlignedTimeseriesArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceCreateAlignedTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCreateAlignedTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCreateAlignedTimeseriesReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceCreateAlignedTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createAlignedTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCreateAlignedTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceCreateAlignedTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCreateAlignedTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCreateAlignedTimeseriesResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCreateAlignedTimeseriesResult() *TSIServiceCreateAlignedTimeseriesResult {
  return &TSIServiceCreateAlignedTimeseriesResult{}
}

var TSIServiceCreateAlignedTimeseriesResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCreateAlignedTimeseriesResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceCreateAlignedTimeseriesResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceCreateAlignedTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceCreateAlignedTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCreateAlignedTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceCreateAlignedTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createAlignedTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCreateAlignedTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceCreateAlignedTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCreateAlignedTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCreateMultiTimeseriesArgs struct {
  Req *TSCreateMultiTimeseriesReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCreateMultiTimeseriesArgs() *TSIServiceCreateMultiTimeseriesArgs {
  return &TSIServiceCreateMultiTimeseriesArgs{}
}

var TSIServiceCreateMultiTimeseriesArgs_Req_DEFAULT *TSCreateMultiTimeseriesReq
func (p *TSIServiceCreateMultiTimeseriesArgs) GetReq() *TSCreateMultiTimeseriesReq {
  if !p.IsSetReq() {
    return TSIServiceCreateMultiTimeseriesArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceCreateMultiTimeseriesArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceCreateMultiTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCreateMultiTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCreateMultiTimeseriesReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceCreateMultiTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createMultiTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCreateMultiTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceCreateMultiTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCreateMultiTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCreateMultiTimeseriesResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCreateMultiTimeseriesResult() *TSIServiceCreateMultiTimeseriesResult {
  return &TSIServiceCreateMultiTimeseriesResult{}
}

var TSIServiceCreateMultiTimeseriesResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCreateMultiTimeseriesResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceCreateMultiTimeseriesResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceCreateMultiTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceCreateMultiTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCreateMultiTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceCreateMultiTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createMultiTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCreateMultiTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceCreateMultiTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCreateMultiTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Path
type TSIServiceDeleteTimeseriesArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
  Path []string `thrift:"path,2" db:"path" json:"path"`
}

func NewTSIServiceDeleteTimeseriesArgs() *TSIServiceDeleteTimeseriesArgs {
  return &TSIServiceDeleteTimeseriesArgs{}
}


func (p *TSIServiceDeleteTimeseriesArgs) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSIServiceDeleteTimeseriesArgs) GetPath() []string {
  return p.Path
}
func (p *TSIServiceDeleteTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceDeleteTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSIServiceDeleteTimeseriesArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Path =  tSlice
  for i := 0; i < size; i ++ {
var _elem312 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem312 = v
}
    p.Path = append(p.Path, _elem312)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSIServiceDeleteTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceDeleteTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSIServiceDeleteTimeseriesArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Path)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Path {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
  return err
}

func (p *TSIServiceDeleteTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceDeleteTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceDeleteTimeseriesResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceDeleteTimeseriesResult() *TSIServiceDeleteTimeseriesResult {
  return &TSIServiceDeleteTimeseriesResult{}
}

var TSIServiceDeleteTimeseriesResult_Success_DEFAULT *TSStatus
func (p *TSIServiceDeleteTimeseriesResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceDeleteTimeseriesResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceDeleteTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceDeleteTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceDeleteTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceDeleteTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceDeleteTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceDeleteTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceDeleteTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - StorageGroup
type TSIServiceDeleteStorageGroupsArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
  StorageGroup []string `thrift:"storageGroup,2" db:"storageGroup" json:"storageGroup"`
}

func NewTSIServiceDeleteStorageGroupsArgs() *TSIServiceDeleteStorageGroupsArgs {
  return &TSIServiceDeleteStorageGroupsArgs{}
}


func (p *TSIServiceDeleteStorageGroupsArgs) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSIServiceDeleteStorageGroupsArgs) GetStorageGroup() []string {
  return p.StorageGroup
}
func (p *TSIServiceDeleteStorageGroupsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceDeleteStorageGroupsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSIServiceDeleteStorageGroupsArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.StorageGroup =  tSlice
  for i := 0; i < size; i ++ {
var _elem313 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem313 = v
}
    p.StorageGroup = append(p.StorageGroup, _elem313)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSIServiceDeleteStorageGroupsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteStorageGroups_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceDeleteStorageGroupsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSIServiceDeleteStorageGroupsArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "storageGroup", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:storageGroup: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.StorageGroup)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.StorageGroup {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:storageGroup: ", p), err) }
  return err
}

func (p *TSIServiceDeleteStorageGroupsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceDeleteStorageGroupsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceDeleteStorageGroupsResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceDeleteStorageGroupsResult() *TSIServiceDeleteStorageGroupsResult {
  return &TSIServiceDeleteStorageGroupsResult{}
}

var TSIServiceDeleteStorageGroupsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceDeleteStorageGroupsResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceDeleteStorageGroupsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceDeleteStorageGroupsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceDeleteStorageGroupsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceDeleteStorageGroupsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceDeleteStorageGroupsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteStorageGroups_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceDeleteStorageGroupsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceDeleteStorageGroupsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceDeleteStorageGroupsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertRecordArgs struct {
  Req *TSInsertRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertRecordArgs() *TSIServiceInsertRecordArgs {
  return &TSIServiceInsertRecordArgs{}
}

var TSIServiceInsertRecordArgs_Req_DEFAULT *TSInsertRecordReq
func (p *TSIServiceInsertRecordArgs) GetReq() *TSInsertRecordReq {
  if !p.IsSetReq() {
    return TSIServiceInsertRecordArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceInsertRecordArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceInsertRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertRecordReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertRecord_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceInsertRecordArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertRecordResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertRecordResult() *TSIServiceInsertRecordResult {
  return &TSIServiceInsertRecordResult{}
}

var TSIServiceInsertRecordResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertRecordResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceInsertRecordResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceInsertRecordResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceInsertRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertRecord_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceInsertRecordResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertStringRecordArgs struct {
  Req *TSInsertStringRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertStringRecordArgs() *TSIServiceInsertStringRecordArgs {
  return &TSIServiceInsertStringRecordArgs{}
}

var TSIServiceInsertStringRecordArgs_Req_DEFAULT *TSInsertStringRecordReq
func (p *TSIServiceInsertStringRecordArgs) GetReq() *TSInsertStringRecordReq {
  if !p.IsSetReq() {
    return TSIServiceInsertStringRecordArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceInsertStringRecordArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceInsertStringRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertStringRecordReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertStringRecord_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertStringRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceInsertStringRecordArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertStringRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertStringRecordResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertStringRecordResult() *TSIServiceInsertStringRecordResult {
  return &TSIServiceInsertStringRecordResult{}
}

var TSIServiceInsertStringRecordResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertStringRecordResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceInsertStringRecordResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceInsertStringRecordResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceInsertStringRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertStringRecord_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertStringRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceInsertStringRecordResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertStringRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertTabletArgs struct {
  Req *TSInsertTabletReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertTabletArgs() *TSIServiceInsertTabletArgs {
  return &TSIServiceInsertTabletArgs{}
}

var TSIServiceInsertTabletArgs_Req_DEFAULT *TSInsertTabletReq
func (p *TSIServiceInsertTabletArgs) GetReq() *TSInsertTabletReq {
  if !p.IsSetReq() {
    return TSIServiceInsertTabletArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceInsertTabletArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceInsertTabletArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertTabletArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertTabletReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceInsertTabletArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertTablet_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertTabletArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceInsertTabletArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertTabletArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertTabletResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertTabletResult() *TSIServiceInsertTabletResult {
  return &TSIServiceInsertTabletResult{}
}

var TSIServiceInsertTabletResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertTabletResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceInsertTabletResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceInsertTabletResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceInsertTabletResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertTabletResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceInsertTabletResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertTablet_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertTabletResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceInsertTabletResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertTabletResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertTabletsArgs struct {
  Req *TSInsertTabletsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertTabletsArgs() *TSIServiceInsertTabletsArgs {
  return &TSIServiceInsertTabletsArgs{}
}

var TSIServiceInsertTabletsArgs_Req_DEFAULT *TSInsertTabletsReq
func (p *TSIServiceInsertTabletsArgs) GetReq() *TSInsertTabletsReq {
  if !p.IsSetReq() {
    return TSIServiceInsertTabletsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceInsertTabletsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceInsertTabletsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertTabletsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertTabletsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceInsertTabletsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertTablets_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertTabletsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceInsertTabletsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertTabletsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertTabletsResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertTabletsResult() *TSIServiceInsertTabletsResult {
  return &TSIServiceInsertTabletsResult{}
}

var TSIServiceInsertTabletsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertTabletsResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceInsertTabletsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceInsertTabletsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceInsertTabletsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertTabletsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceInsertTabletsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertTablets_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertTabletsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceInsertTabletsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertTabletsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertRecordsArgs struct {
  Req *TSInsertRecordsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertRecordsArgs() *TSIServiceInsertRecordsArgs {
  return &TSIServiceInsertRecordsArgs{}
}

var TSIServiceInsertRecordsArgs_Req_DEFAULT *TSInsertRecordsReq
func (p *TSIServiceInsertRecordsArgs) GetReq() *TSInsertRecordsReq {
  if !p.IsSetReq() {
    return TSIServiceInsertRecordsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceInsertRecordsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceInsertRecordsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertRecordsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertRecords_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertRecordsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceInsertRecordsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertRecordsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertRecordsResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertRecordsResult() *TSIServiceInsertRecordsResult {
  return &TSIServiceInsertRecordsResult{}
}

var TSIServiceInsertRecordsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertRecordsResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceInsertRecordsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceInsertRecordsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceInsertRecordsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertRecords_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertRecordsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceInsertRecordsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertRecordsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertRecordsOfOneDeviceArgs struct {
  Req *TSInsertRecordsOfOneDeviceReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertRecordsOfOneDeviceArgs() *TSIServiceInsertRecordsOfOneDeviceArgs {
  return &TSIServiceInsertRecordsOfOneDeviceArgs{}
}

var TSIServiceInsertRecordsOfOneDeviceArgs_Req_DEFAULT *TSInsertRecordsOfOneDeviceReq
func (p *TSIServiceInsertRecordsOfOneDeviceArgs) GetReq() *TSInsertRecordsOfOneDeviceReq {
  if !p.IsSetReq() {
    return TSIServiceInsertRecordsOfOneDeviceArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceInsertRecordsOfOneDeviceArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertRecordsOfOneDeviceReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertRecordsOfOneDevice_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceInsertRecordsOfOneDeviceArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertRecordsOfOneDeviceArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertRecordsOfOneDeviceResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertRecordsOfOneDeviceResult() *TSIServiceInsertRecordsOfOneDeviceResult {
  return &TSIServiceInsertRecordsOfOneDeviceResult{}
}

var TSIServiceInsertRecordsOfOneDeviceResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertRecordsOfOneDeviceResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceInsertRecordsOfOneDeviceResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceInsertRecordsOfOneDeviceResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertRecordsOfOneDevice_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceInsertRecordsOfOneDeviceResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertRecordsOfOneDeviceResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertStringRecordsOfOneDeviceArgs struct {
  Req *TSInsertStringRecordsOfOneDeviceReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertStringRecordsOfOneDeviceArgs() *TSIServiceInsertStringRecordsOfOneDeviceArgs {
  return &TSIServiceInsertStringRecordsOfOneDeviceArgs{}
}

var TSIServiceInsertStringRecordsOfOneDeviceArgs_Req_DEFAULT *TSInsertStringRecordsOfOneDeviceReq
func (p *TSIServiceInsertStringRecordsOfOneDeviceArgs) GetReq() *TSInsertStringRecordsOfOneDeviceReq {
  if !p.IsSetReq() {
    return TSIServiceInsertStringRecordsOfOneDeviceArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceInsertStringRecordsOfOneDeviceArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertStringRecordsOfOneDeviceReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertStringRecordsOfOneDevice_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertStringRecordsOfOneDeviceArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertStringRecordsOfOneDeviceResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertStringRecordsOfOneDeviceResult() *TSIServiceInsertStringRecordsOfOneDeviceResult {
  return &TSIServiceInsertStringRecordsOfOneDeviceResult{}
}

var TSIServiceInsertStringRecordsOfOneDeviceResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertStringRecordsOfOneDeviceResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceInsertStringRecordsOfOneDeviceResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceInsertStringRecordsOfOneDeviceResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertStringRecordsOfOneDevice_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceInsertStringRecordsOfOneDeviceResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertStringRecordsOfOneDeviceResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceInsertStringRecordsArgs struct {
  Req *TSInsertStringRecordsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceInsertStringRecordsArgs() *TSIServiceInsertStringRecordsArgs {
  return &TSIServiceInsertStringRecordsArgs{}
}

var TSIServiceInsertStringRecordsArgs_Req_DEFAULT *TSInsertStringRecordsReq
func (p *TSIServiceInsertStringRecordsArgs) GetReq() *TSInsertStringRecordsReq {
  if !p.IsSetReq() {
    return TSIServiceInsertStringRecordsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceInsertStringRecordsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceInsertStringRecordsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertStringRecordsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertStringRecords_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertStringRecordsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceInsertStringRecordsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertStringRecordsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceInsertStringRecordsResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceInsertStringRecordsResult() *TSIServiceInsertStringRecordsResult {
  return &TSIServiceInsertStringRecordsResult{}
}

var TSIServiceInsertStringRecordsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceInsertStringRecordsResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceInsertStringRecordsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceInsertStringRecordsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceInsertStringRecordsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceInsertStringRecordsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertStringRecords_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceInsertStringRecordsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceInsertStringRecordsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceInsertStringRecordsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertTabletArgs struct {
  Req *TSInsertTabletReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertTabletArgs() *TSIServiceTestInsertTabletArgs {
  return &TSIServiceTestInsertTabletArgs{}
}

var TSIServiceTestInsertTabletArgs_Req_DEFAULT *TSInsertTabletReq
func (p *TSIServiceTestInsertTabletArgs) GetReq() *TSInsertTabletReq {
  if !p.IsSetReq() {
    return TSIServiceTestInsertTabletArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceTestInsertTabletArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceTestInsertTabletArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertTabletArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertTabletReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceTestInsertTabletArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertTablet_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertTabletArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceTestInsertTabletArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertTabletArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertTabletResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertTabletResult() *TSIServiceTestInsertTabletResult {
  return &TSIServiceTestInsertTabletResult{}
}

var TSIServiceTestInsertTabletResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertTabletResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceTestInsertTabletResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceTestInsertTabletResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceTestInsertTabletResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertTabletResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceTestInsertTabletResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertTablet_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertTabletResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceTestInsertTabletResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertTabletResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertTabletsArgs struct {
  Req *TSInsertTabletsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertTabletsArgs() *TSIServiceTestInsertTabletsArgs {
  return &TSIServiceTestInsertTabletsArgs{}
}

var TSIServiceTestInsertTabletsArgs_Req_DEFAULT *TSInsertTabletsReq
func (p *TSIServiceTestInsertTabletsArgs) GetReq() *TSInsertTabletsReq {
  if !p.IsSetReq() {
    return TSIServiceTestInsertTabletsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceTestInsertTabletsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceTestInsertTabletsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertTabletsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertTabletsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceTestInsertTabletsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertTablets_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertTabletsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceTestInsertTabletsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertTabletsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertTabletsResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertTabletsResult() *TSIServiceTestInsertTabletsResult {
  return &TSIServiceTestInsertTabletsResult{}
}

var TSIServiceTestInsertTabletsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertTabletsResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceTestInsertTabletsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceTestInsertTabletsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceTestInsertTabletsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertTabletsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceTestInsertTabletsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertTablets_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertTabletsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceTestInsertTabletsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertTabletsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertRecordArgs struct {
  Req *TSInsertRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertRecordArgs() *TSIServiceTestInsertRecordArgs {
  return &TSIServiceTestInsertRecordArgs{}
}

var TSIServiceTestInsertRecordArgs_Req_DEFAULT *TSInsertRecordReq
func (p *TSIServiceTestInsertRecordArgs) GetReq() *TSInsertRecordReq {
  if !p.IsSetReq() {
    return TSIServiceTestInsertRecordArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceTestInsertRecordArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceTestInsertRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertRecordReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertRecord_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceTestInsertRecordArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertRecordResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertRecordResult() *TSIServiceTestInsertRecordResult {
  return &TSIServiceTestInsertRecordResult{}
}

var TSIServiceTestInsertRecordResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertRecordResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceTestInsertRecordResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceTestInsertRecordResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceTestInsertRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertRecord_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceTestInsertRecordResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertStringRecordArgs struct {
  Req *TSInsertStringRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertStringRecordArgs() *TSIServiceTestInsertStringRecordArgs {
  return &TSIServiceTestInsertStringRecordArgs{}
}

var TSIServiceTestInsertStringRecordArgs_Req_DEFAULT *TSInsertStringRecordReq
func (p *TSIServiceTestInsertStringRecordArgs) GetReq() *TSInsertStringRecordReq {
  if !p.IsSetReq() {
    return TSIServiceTestInsertStringRecordArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceTestInsertStringRecordArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceTestInsertStringRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertStringRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertStringRecordReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceTestInsertStringRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertStringRecord_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertStringRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceTestInsertStringRecordArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertStringRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertStringRecordResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertStringRecordResult() *TSIServiceTestInsertStringRecordResult {
  return &TSIServiceTestInsertStringRecordResult{}
}

var TSIServiceTestInsertStringRecordResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertStringRecordResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceTestInsertStringRecordResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceTestInsertStringRecordResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceTestInsertStringRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertStringRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceTestInsertStringRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertStringRecord_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertStringRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceTestInsertStringRecordResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertStringRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertRecordsArgs struct {
  Req *TSInsertRecordsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertRecordsArgs() *TSIServiceTestInsertRecordsArgs {
  return &TSIServiceTestInsertRecordsArgs{}
}

var TSIServiceTestInsertRecordsArgs_Req_DEFAULT *TSInsertRecordsReq
func (p *TSIServiceTestInsertRecordsArgs) GetReq() *TSInsertRecordsReq {
  if !p.IsSetReq() {
    return TSIServiceTestInsertRecordsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceTestInsertRecordsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceTestInsertRecordsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertRecordsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertRecords_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertRecordsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceTestInsertRecordsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertRecordsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertRecordsResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertRecordsResult() *TSIServiceTestInsertRecordsResult {
  return &TSIServiceTestInsertRecordsResult{}
}

var TSIServiceTestInsertRecordsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertRecordsResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceTestInsertRecordsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceTestInsertRecordsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceTestInsertRecordsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertRecords_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertRecordsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceTestInsertRecordsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertRecordsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertRecordsOfOneDeviceArgs struct {
  Req *TSInsertRecordsOfOneDeviceReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertRecordsOfOneDeviceArgs() *TSIServiceTestInsertRecordsOfOneDeviceArgs {
  return &TSIServiceTestInsertRecordsOfOneDeviceArgs{}
}

var TSIServiceTestInsertRecordsOfOneDeviceArgs_Req_DEFAULT *TSInsertRecordsOfOneDeviceReq
func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) GetReq() *TSInsertRecordsOfOneDeviceReq {
  if !p.IsSetReq() {
    return TSIServiceTestInsertRecordsOfOneDeviceArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertRecordsOfOneDeviceReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertRecordsOfOneDevice_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertRecordsOfOneDeviceArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertRecordsOfOneDeviceResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertRecordsOfOneDeviceResult() *TSIServiceTestInsertRecordsOfOneDeviceResult {
  return &TSIServiceTestInsertRecordsOfOneDeviceResult{}
}

var TSIServiceTestInsertRecordsOfOneDeviceResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceTestInsertRecordsOfOneDeviceResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertRecordsOfOneDevice_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceTestInsertRecordsOfOneDeviceResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertRecordsOfOneDeviceResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceTestInsertStringRecordsArgs struct {
  Req *TSInsertStringRecordsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceTestInsertStringRecordsArgs() *TSIServiceTestInsertStringRecordsArgs {
  return &TSIServiceTestInsertStringRecordsArgs{}
}

var TSIServiceTestInsertStringRecordsArgs_Req_DEFAULT *TSInsertStringRecordsReq
func (p *TSIServiceTestInsertStringRecordsArgs) GetReq() *TSInsertStringRecordsReq {
  if !p.IsSetReq() {
    return TSIServiceTestInsertStringRecordsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceTestInsertStringRecordsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceTestInsertStringRecordsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertStringRecordsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertStringRecordsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceTestInsertStringRecordsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertStringRecords_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertStringRecordsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceTestInsertStringRecordsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertStringRecordsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceTestInsertStringRecordsResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceTestInsertStringRecordsResult() *TSIServiceTestInsertStringRecordsResult {
  return &TSIServiceTestInsertStringRecordsResult{}
}

var TSIServiceTestInsertStringRecordsResult_Success_DEFAULT *TSStatus
func (p *TSIServiceTestInsertStringRecordsResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceTestInsertStringRecordsResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceTestInsertStringRecordsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceTestInsertStringRecordsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceTestInsertStringRecordsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceTestInsertStringRecordsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "testInsertStringRecords_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceTestInsertStringRecordsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceTestInsertStringRecordsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceTestInsertStringRecordsResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceDeleteDataArgs struct {
  Req *TSDeleteDataReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceDeleteDataArgs() *TSIServiceDeleteDataArgs {
  return &TSIServiceDeleteDataArgs{}
}

var TSIServiceDeleteDataArgs_Req_DEFAULT *TSDeleteDataReq
func (p *TSIServiceDeleteDataArgs) GetReq() *TSDeleteDataReq {
  if !p.IsSetReq() {
    return TSIServiceDeleteDataArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceDeleteDataArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceDeleteDataArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceDeleteDataArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSDeleteDataReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceDeleteDataArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteData_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceDeleteDataArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceDeleteDataArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceDeleteDataArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceDeleteDataResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceDeleteDataResult() *TSIServiceDeleteDataResult {
  return &TSIServiceDeleteDataResult{}
}

var TSIServiceDeleteDataResult_Success_DEFAULT *TSStatus
func (p *TSIServiceDeleteDataResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceDeleteDataResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceDeleteDataResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceDeleteDataResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceDeleteDataResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceDeleteDataResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteData_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceDeleteDataResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceDeleteDataResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceDeleteDataResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteRawDataQueryArgs struct {
  Req *TSRawDataQueryReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteRawDataQueryArgs() *TSIServiceExecuteRawDataQueryArgs {
  return &TSIServiceExecuteRawDataQueryArgs{}
}

var TSIServiceExecuteRawDataQueryArgs_Req_DEFAULT *TSRawDataQueryReq
func (p *TSIServiceExecuteRawDataQueryArgs) GetReq() *TSRawDataQueryReq {
  if !p.IsSetReq() {
    return TSIServiceExecuteRawDataQueryArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceExecuteRawDataQueryArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceExecuteRawDataQueryArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteRawDataQueryArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSRawDataQueryReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceExecuteRawDataQueryArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeRawDataQuery_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteRawDataQueryArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceExecuteRawDataQueryArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteRawDataQueryArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteRawDataQueryResult struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteRawDataQueryResult() *TSIServiceExecuteRawDataQueryResult {
  return &TSIServiceExecuteRawDataQueryResult{}
}

var TSIServiceExecuteRawDataQueryResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteRawDataQueryResult) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return TSIServiceExecuteRawDataQueryResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceExecuteRawDataQueryResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceExecuteRawDataQueryResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteRawDataQueryResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceExecuteRawDataQueryResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeRawDataQuery_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteRawDataQueryResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceExecuteRawDataQueryResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteRawDataQueryResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceExecuteLastDataQueryArgs struct {
  Req *TSLastDataQueryReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceExecuteLastDataQueryArgs() *TSIServiceExecuteLastDataQueryArgs {
  return &TSIServiceExecuteLastDataQueryArgs{}
}

var TSIServiceExecuteLastDataQueryArgs_Req_DEFAULT *TSLastDataQueryReq
func (p *TSIServiceExecuteLastDataQueryArgs) GetReq() *TSLastDataQueryReq {
  if !p.IsSetReq() {
    return TSIServiceExecuteLastDataQueryArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceExecuteLastDataQueryArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceExecuteLastDataQueryArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteLastDataQueryArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSLastDataQueryReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceExecuteLastDataQueryArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeLastDataQuery_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteLastDataQueryArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceExecuteLastDataQueryArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteLastDataQueryArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceExecuteLastDataQueryResult struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceExecuteLastDataQueryResult() *TSIServiceExecuteLastDataQueryResult {
  return &TSIServiceExecuteLastDataQueryResult{}
}

var TSIServiceExecuteLastDataQueryResult_Success_DEFAULT *TSExecuteStatementResp
func (p *TSIServiceExecuteLastDataQueryResult) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return TSIServiceExecuteLastDataQueryResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceExecuteLastDataQueryResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceExecuteLastDataQueryResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceExecuteLastDataQueryResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceExecuteLastDataQueryResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeLastDataQuery_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceExecuteLastDataQueryResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceExecuteLastDataQueryResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceExecuteLastDataQueryResult(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSIServiceRequestStatementIdArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
}

func NewTSIServiceRequestStatementIdArgs() *TSIServiceRequestStatementIdArgs {
  return &TSIServiceRequestStatementIdArgs{}
}


func (p *TSIServiceRequestStatementIdArgs) GetSessionId() int64 {
  return p.SessionId
}
func (p *TSIServiceRequestStatementIdArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceRequestStatementIdArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSIServiceRequestStatementIdArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "requestStatementId_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceRequestStatementIdArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSIServiceRequestStatementIdArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceRequestStatementIdArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceRequestStatementIdResult struct {
  Success *int64 `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceRequestStatementIdResult() *TSIServiceRequestStatementIdResult {
  return &TSIServiceRequestStatementIdResult{}
}

var TSIServiceRequestStatementIdResult_Success_DEFAULT int64
func (p *TSIServiceRequestStatementIdResult) GetSuccess() int64 {
  if !p.IsSetSuccess() {
    return TSIServiceRequestStatementIdResult_Success_DEFAULT
  }
return *p.Success
}
func (p *TSIServiceRequestStatementIdResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceRequestStatementIdResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceRequestStatementIdResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 0: ", err)
} else {
  p.Success = &v
}
  return nil
}

func (p *TSIServiceRequestStatementIdResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "requestStatementId_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceRequestStatementIdResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.I64, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Success)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.success (0) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceRequestStatementIdResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceRequestStatementIdResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceCreateSchemaTemplateArgs struct {
  Req *TSCreateSchemaTemplateReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceCreateSchemaTemplateArgs() *TSIServiceCreateSchemaTemplateArgs {
  return &TSIServiceCreateSchemaTemplateArgs{}
}

var TSIServiceCreateSchemaTemplateArgs_Req_DEFAULT *TSCreateSchemaTemplateReq
func (p *TSIServiceCreateSchemaTemplateArgs) GetReq() *TSCreateSchemaTemplateReq {
  if !p.IsSetReq() {
    return TSIServiceCreateSchemaTemplateArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceCreateSchemaTemplateArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceCreateSchemaTemplateArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCreateSchemaTemplateArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCreateSchemaTemplateReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceCreateSchemaTemplateArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createSchemaTemplate_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCreateSchemaTemplateArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceCreateSchemaTemplateArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCreateSchemaTemplateArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceCreateSchemaTemplateResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceCreateSchemaTemplateResult() *TSIServiceCreateSchemaTemplateResult {
  return &TSIServiceCreateSchemaTemplateResult{}
}

var TSIServiceCreateSchemaTemplateResult_Success_DEFAULT *TSStatus
func (p *TSIServiceCreateSchemaTemplateResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceCreateSchemaTemplateResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceCreateSchemaTemplateResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceCreateSchemaTemplateResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceCreateSchemaTemplateResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceCreateSchemaTemplateResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createSchemaTemplate_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceCreateSchemaTemplateResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceCreateSchemaTemplateResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceCreateSchemaTemplateResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceAppendSchemaTemplateArgs struct {
  Req *TSAppendSchemaTemplateReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceAppendSchemaTemplateArgs() *TSIServiceAppendSchemaTemplateArgs {
  return &TSIServiceAppendSchemaTemplateArgs{}
}

var TSIServiceAppendSchemaTemplateArgs_Req_DEFAULT *TSAppendSchemaTemplateReq
func (p *TSIServiceAppendSchemaTemplateArgs) GetReq() *TSAppendSchemaTemplateReq {
  if !p.IsSetReq() {
    return TSIServiceAppendSchemaTemplateArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceAppendSchemaTemplateArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceAppendSchemaTemplateArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceAppendSchemaTemplateArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSAppendSchemaTemplateReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceAppendSchemaTemplateArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "appendSchemaTemplate_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceAppendSchemaTemplateArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceAppendSchemaTemplateArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceAppendSchemaTemplateArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceAppendSchemaTemplateResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceAppendSchemaTemplateResult() *TSIServiceAppendSchemaTemplateResult {
  return &TSIServiceAppendSchemaTemplateResult{}
}

var TSIServiceAppendSchemaTemplateResult_Success_DEFAULT *TSStatus
func (p *TSIServiceAppendSchemaTemplateResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceAppendSchemaTemplateResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceAppendSchemaTemplateResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceAppendSchemaTemplateResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceAppendSchemaTemplateResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceAppendSchemaTemplateResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "appendSchemaTemplate_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceAppendSchemaTemplateResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceAppendSchemaTemplateResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceAppendSchemaTemplateResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServicePruneSchemaTemplateArgs struct {
  Req *TSPruneSchemaTemplateReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServicePruneSchemaTemplateArgs() *TSIServicePruneSchemaTemplateArgs {
  return &TSIServicePruneSchemaTemplateArgs{}
}

var TSIServicePruneSchemaTemplateArgs_Req_DEFAULT *TSPruneSchemaTemplateReq
func (p *TSIServicePruneSchemaTemplateArgs) GetReq() *TSPruneSchemaTemplateReq {
  if !p.IsSetReq() {
    return TSIServicePruneSchemaTemplateArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServicePruneSchemaTemplateArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServicePruneSchemaTemplateArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServicePruneSchemaTemplateArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSPruneSchemaTemplateReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServicePruneSchemaTemplateArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "pruneSchemaTemplate_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServicePruneSchemaTemplateArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServicePruneSchemaTemplateArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServicePruneSchemaTemplateArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServicePruneSchemaTemplateResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServicePruneSchemaTemplateResult() *TSIServicePruneSchemaTemplateResult {
  return &TSIServicePruneSchemaTemplateResult{}
}

var TSIServicePruneSchemaTemplateResult_Success_DEFAULT *TSStatus
func (p *TSIServicePruneSchemaTemplateResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServicePruneSchemaTemplateResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServicePruneSchemaTemplateResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServicePruneSchemaTemplateResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServicePruneSchemaTemplateResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServicePruneSchemaTemplateResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "pruneSchemaTemplate_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServicePruneSchemaTemplateResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServicePruneSchemaTemplateResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServicePruneSchemaTemplateResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceQuerySchemaTemplateArgs struct {
  Req *TSQueryTemplateReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceQuerySchemaTemplateArgs() *TSIServiceQuerySchemaTemplateArgs {
  return &TSIServiceQuerySchemaTemplateArgs{}
}

var TSIServiceQuerySchemaTemplateArgs_Req_DEFAULT *TSQueryTemplateReq
func (p *TSIServiceQuerySchemaTemplateArgs) GetReq() *TSQueryTemplateReq {
  if !p.IsSetReq() {
    return TSIServiceQuerySchemaTemplateArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceQuerySchemaTemplateArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceQuerySchemaTemplateArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceQuerySchemaTemplateArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSQueryTemplateReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceQuerySchemaTemplateArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "querySchemaTemplate_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceQuerySchemaTemplateArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceQuerySchemaTemplateArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceQuerySchemaTemplateArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceQuerySchemaTemplateResult struct {
  Success *TSQueryTemplateResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceQuerySchemaTemplateResult() *TSIServiceQuerySchemaTemplateResult {
  return &TSIServiceQuerySchemaTemplateResult{}
}

var TSIServiceQuerySchemaTemplateResult_Success_DEFAULT *TSQueryTemplateResp
func (p *TSIServiceQuerySchemaTemplateResult) GetSuccess() *TSQueryTemplateResp {
  if !p.IsSetSuccess() {
    return TSIServiceQuerySchemaTemplateResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceQuerySchemaTemplateResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceQuerySchemaTemplateResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceQuerySchemaTemplateResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSQueryTemplateResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *TSIServiceQuerySchemaTemplateResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "querySchemaTemplate_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceQuerySchemaTemplateResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *TSIServiceQuerySchemaTemplateResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceQuerySchemaTemplateResult(%+v)", *p)
}

// Attributes:
//  - Req
type TSIServiceSetSchemaTemplateArgs struct {
  Req *TSSetSchemaTemplateReq `thrift:"req,1" db:"req" json:"req"`
}

func NewTSIServiceSetSchemaTemplateArgs() *TSIServiceSetSchemaTemplateArgs {
  return &TSIServiceSetSchemaTemplateArgs{}
}

var TSIServiceSetSchemaTemplateArgs_Req_DEFAULT *TSSetSchemaTemplateReq
func (p *TSIServiceSetSchemaTemplateArgs) GetReq() *TSSetSchemaTemplateReq {
  if !p.IsSetReq() {
    return TSIServiceSetSchemaTemplateArgs_Req_DEFAULT
  }
return p.Req
}
func (p *TSIServiceSetSchemaTemplateArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *TSIServiceSetSchemaTemplateArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *TSIServiceSetSchemaTemplateArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSSetSchemaTemplateReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *TSIServiceSetSchemaTemplateArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setSchemaTemplate_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSIServiceSetSchemaTemplateArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *TSIServiceSetSchemaTemplateArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSIServiceSetSchemaTemplateArgs(%+v)", *p)
}

// Attributes:
//  - Success
type TSIServiceSetSchemaTemplateResult struct {
  Success *TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewTSIServiceSetSchemaTemplateResult() *TSIServiceSetSchemaTemplateResult {
  return &TSIServiceSetSchemaTemplateResult{}
}

var TSIServiceSetSchemaTemplateResult_Success_DEFAULT *TSStatus
func (p *TSIServiceSetSchemaTemplateResult) GetSuccess() *TSStatus {
  if !p.IsSetSuccess() {
    return TSIServiceSetSchemaTemplateResult_Success_DEFAULT
  }
return p.Success
}
func (p *TSIServiceSetSchemaTemplateResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *TSIServiceSetSchemaTemplateResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId,