// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"rpc"
)

var _ = rpc.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  TSOpenSessionResp openSession(TSOpenSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeSession(TSCloseSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeBatchStatement(TSExecuteBatchStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResults(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus cancelOperation(TSCancelOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeOperation(TSCloseOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSGetSystemStatusResp getSystemStatus(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSGetTimeZoneResp getTimeZone(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus setTimeZone(TSSetTimeZoneReq req)")
  fmt.Fprintln(os.Stderr, "  ServerProperties getProperties()")
  fmt.Fprintln(os.Stderr, "  TSStatus setStorageGroup(i64 sessionId, string storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseries(TSCreateTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteTimeseries(i64 sessionId,  path)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteStorageGroups(i64 sessionId,  storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteData(TSDeleteDataReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  i64 requestStatementId(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus setUsingTemplate(TSSetUsingTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus unsetUsingTemplate(i64 sessionId, string templateName, string prefixPath)")
  fmt.Fprintln(os.Stderr, "  TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeOperationSync(TSOperationSyncWriteReq req)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := rpc.NewTSIServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "openSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "OpenSession requires 1 args")
      flag.Usage()
    }
    arg314 := flag.Arg(1)
    mbTrans315 := thrift.NewTMemoryBufferLen(len(arg314))
    defer mbTrans315.Close()
    _, err316 := mbTrans315.WriteString(arg314)
    if err316 != nil {
      Usage()
      return
    }
    factory317 := thrift.NewTJSONProtocolFactory()
    jsProt318 := factory317.GetProtocol(mbTrans315)
    argvalue0 := rpc.NewTSOpenSessionReq()
    err319 := argvalue0.Read(context.Background(), jsProt318)
    if err319 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.OpenSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseSession requires 1 args")
      flag.Usage()
    }
    arg320 := flag.Arg(1)
    mbTrans321 := thrift.NewTMemoryBufferLen(len(arg320))
    defer mbTrans321.Close()
    _, err322 := mbTrans321.WriteString(arg320)
    if err322 != nil {
      Usage()
      return
    }
    factory323 := thrift.NewTJSONProtocolFactory()
    jsProt324 := factory323.GetProtocol(mbTrans321)
    argvalue0 := rpc.NewTSCloseSessionReq()
    err325 := argvalue0.Read(context.Background(), jsProt324)
    if err325 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatement requires 1 args")
      flag.Usage()
    }
    arg326 := flag.Arg(1)
    mbTrans327 := thrift.NewTMemoryBufferLen(len(arg326))
    defer mbTrans327.Close()
    _, err328 := mbTrans327.WriteString(arg326)
    if err328 != nil {
      Usage()
      return
    }
    factory329 := thrift.NewTJSONProtocolFactory()
    jsProt330 := factory329.GetProtocol(mbTrans327)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err331 := argvalue0.Read(context.Background(), jsProt330)
    if err331 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeBatchStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteBatchStatement requires 1 args")
      flag.Usage()
    }
    arg332 := flag.Arg(1)
    mbTrans333 := thrift.NewTMemoryBufferLen(len(arg332))
    defer mbTrans333.Close()
    _, err334 := mbTrans333.WriteString(arg332)
    if err334 != nil {
      Usage()
      return
    }
    factory335 := thrift.NewTJSONProtocolFactory()
    jsProt336 := factory335.GetProtocol(mbTrans333)
    argvalue0 := rpc.NewTSExecuteBatchStatementReq()
    err337 := argvalue0.Read(context.Background(), jsProt336)
    if err337 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteBatchStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeQueryStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatement requires 1 args")
      flag.Usage()
    }
    arg338 := flag.Arg(1)
    mbTrans339 := thrift.NewTMemoryBufferLen(len(arg338))
    defer mbTrans339.Close()
    _, err340 := mbTrans339.WriteString(arg338)
    if err340 != nil {
      Usage()
      return
    }
    factory341 := thrift.NewTJSONProtocolFactory()
    jsProt342 := factory341.GetProtocol(mbTrans339)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err343 := argvalue0.Read(context.Background(), jsProt342)
    if err343 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatement requires 1 args")
      flag.Usage()
    }
    arg344 := flag.Arg(1)
    mbTrans345 := thrift.NewTMemoryBufferLen(len(arg344))
    defer mbTrans345.Close()
    _, err346 := mbTrans345.WriteString(arg344)
    if err346 != nil {
      Usage()
      return
    }
    factory347 := thrift.NewTJSONProtocolFactory()
    jsProt348 := factory347.GetProtocol(mbTrans345)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err349 := argvalue0.Read(context.Background(), jsProt348)
    if err349 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResults":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResults requires 1 args")
      flag.Usage()
    }
    arg350 := flag.Arg(1)
    mbTrans351 := thrift.NewTMemoryBufferLen(len(arg350))
    defer mbTrans351.Close()
    _, err352 := mbTrans351.WriteString(arg350)
    if err352 != nil {
      Usage()
      return
    }
    factory353 := thrift.NewTJSONProtocolFactory()
    jsProt354 := factory353.GetProtocol(mbTrans351)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err355 := argvalue0.Read(context.Background(), jsProt354)
    if err355 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResults(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchMetadata":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchMetadata requires 1 args")
      flag.Usage()
    }
    arg356 := flag.Arg(1)
    mbTrans357 := thrift.NewTMemoryBufferLen(len(arg356))
    defer mbTrans357.Close()
    _, err358 := mbTrans357.WriteString(arg356)
    if err358 != nil {
      Usage()
      return
    }
    factory359 := thrift.NewTJSONProtocolFactory()
    jsProt360 := factory359.GetProtocol(mbTrans357)
    argvalue0 := rpc.NewTSFetchMetadataReq()
    err361 := argvalue0.Read(context.Background(), jsProt360)
    if err361 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchMetadata(context.Background(), value0))
    fmt.Print("\n")
    break
  case "cancelOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CancelOperation requires 1 args")
      flag.Usage()
    }
    arg362 := flag.Arg(1)
    mbTrans363 := thrift.NewTMemoryBufferLen(len(arg362))
    defer mbTrans363.Close()
    _, err364 := mbTrans363.WriteString(arg362)
    if err364 != nil {
      Usage()
      return
    }
    factory365 := thrift.NewTJSONProtocolFactory()
    jsProt366 := factory365.GetProtocol(mbTrans363)
    argvalue0 := rpc.NewTSCancelOperationReq()
    err367 := argvalue0.Read(context.Background(), jsProt366)
    if err367 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CancelOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseOperation requires 1 args")
      flag.Usage()
    }
    arg368 := flag.Arg(1)
    mbTrans369 := thrift.NewTMemoryBufferLen(len(arg368))
    defer mbTrans369.Close()
    _, err370 := mbTrans369.WriteString(arg368)
    if err370 != nil {
      Usage()
      return
    }
    factory371 := thrift.NewTJSONProtocolFactory()
    jsProt372 := factory371.GetProtocol(mbTrans369)
    argvalue0 := rpc.NewTSCloseOperationReq()
    err373 := argvalue0.Read(context.Background(), jsProt372)
    if err373 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getSystemStatus":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetSystemStatus requires 1 args")
      flag.Usage()
    }
    argvalue0, err374 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err374 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetSystemStatus(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetTimeZone requires 1 args")
      flag.Usage()
    }
    argvalue0, err375 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err375 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetTimeZone requires 1 args")
      flag.Usage()
    }
    arg376 := flag.Arg(1)
    mbTrans377 := thrift.NewTMemoryBufferLen(len(arg376))
    defer mbTrans377.Close()
    _, err378 := mbTrans377.WriteString(arg376)
    if err378 != nil {
      Usage()
      return
    }
    factory379 := thrift.NewTJSONProtocolFactory()
    jsProt380 := factory379.GetProtocol(mbTrans377)
    argvalue0 := rpc.NewTSSetTimeZoneReq()
    err381 := argvalue0.Read(context.Background(), jsProt380)
    if err381 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getProperties":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetProperties requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetProperties(context.Background()))
    fmt.Print("\n")
    break
  case "setStorageGroup":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SetStorageGroup requires 2 args")
      flag.Usage()
    }
    argvalue0, err382 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err382 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.SetStorageGroup(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "createTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseries requires 1 args")
      flag.Usage()
    }
    arg384 := flag.Arg(1)
    mbTrans385 := thrift.NewTMemoryBufferLen(len(arg384))
    defer mbTrans385.Close()
    _, err386 := mbTrans385.WriteString(arg384)
    if err386 != nil {
      Usage()
      return
    }
    factory387 := thrift.NewTJSONProtocolFactory()
    jsProt388 := factory387.GetProtocol(mbTrans385)
    argvalue0 := rpc.NewTSCreateTimeseriesReq()
    err389 := argvalue0.Read(context.Background(), jsProt388)
    if err389 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createAlignedTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateAlignedTimeseries requires 1 args")
      flag.Usage()
    }
    arg390 := flag.Arg(1)
    mbTrans391 := thrift.NewTMemoryBufferLen(len(arg390))
    defer mbTrans391.Close()
    _, err392 := mbTrans391.WriteString(arg390)
    if err392 != nil {
      Usage()
      return
    }
    factory393 := thrift.NewTJSONProtocolFactory()
    jsProt394 := factory393.GetProtocol(mbTrans391)
    argvalue0 := rpc.NewTSCreateAlignedTimeseriesReq()
    err395 := argvalue0.Read(context.Background(), jsProt394)
    if err395 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateAlignedTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createMultiTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateMultiTimeseries requires 1 args")
      flag.Usage()
    }
    arg396 := flag.Arg(1)
    mbTrans397 := thrift.NewTMemoryBufferLen(len(arg396))
    defer mbTrans397.Close()
    _, err398 := mbTrans397.WriteString(arg396)
    if err398 != nil {
      Usage()
      return
    }
    factory399 := thrift.NewTJSONProtocolFactory()
    jsProt400 := factory399.GetProtocol(mbTrans397)
    argvalue0 := rpc.NewTSCreateMultiTimeseriesReq()
    err401 := argvalue0.Read(context.Background(), jsProt400)
    if err401 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateMultiTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteTimeseries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteTimeseries requires 2 args")
      flag.Usage()
    }
    argvalue0, err402 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err402 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg403 := flag.Arg(2)
    mbTrans404 := thrift.NewTMemoryBufferLen(len(arg403))
    defer mbTrans404.Close()
    _, err405 := mbTrans404.WriteString(arg403)
    if err405 != nil { 
      Usage()
      return
    }
    factory406 := thrift.NewTJSONProtocolFactory()
    jsProt407 := factory406.GetProtocol(mbTrans404)
    containerStruct1 := rpc.NewTSIServiceDeleteTimeseriesArgs()
    err408 := containerStruct1.ReadField2(context.Background(), jsProt407)
    if err408 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    fmt.Print(client.DeleteTimeseries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "deleteStorageGroups":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteStorageGroups requires 2 args")
      flag.Usage()
    }
    argvalue0, err409 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err409 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg410 := flag.Arg(2)
    mbTrans411 := thrift.NewTMemoryBufferLen(len(arg410))
    defer mbTrans411.Close()
    _, err412 := mbTrans411.WriteString(arg410)
    if err412 != nil { 
      Usage()
      return
    }
    factory413 := thrift.NewTJSONProtocolFactory()
    jsProt414 := factory413.GetProtocol(mbTrans411)
    containerStruct1 := rpc.NewTSIServiceDeleteStorageGroupsArgs()
    err415 := containerStruct1.ReadField2(context.Background(), jsProt414)
    if err415 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.StorageGroup
    value1 := argvalue1
    fmt.Print(client.DeleteStorageGroups(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "insertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecord requires 1 args")
      flag.Usage()
    }
    arg416 := flag.Arg(1)
    mbTrans417 := thrift.NewTMemoryBufferLen(len(arg416))
    defer mbTrans417.Close()
    _, err418 := mbTrans417.WriteString(arg416)
    if err418 != nil {
      Usage()
      return
    }
    factory419 := thrift.NewTJSONProtocolFactory()
    jsProt420 := factory419.GetProtocol(mbTrans417)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err421 := argvalue0.Read(context.Background(), jsProt420)
    if err421 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg422 := flag.Arg(1)
    mbTrans423 := thrift.NewTMemoryBufferLen(len(arg422))
    defer mbTrans423.Close()
    _, err424 := mbTrans423.WriteString(arg422)
    if err424 != nil {
      Usage()
      return
    }
    factory425 := thrift.NewTJSONProtocolFactory()
    jsProt426 := factory425.GetProtocol(mbTrans423)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err427 := argvalue0.Read(context.Background(), jsProt426)
    if err427 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablet requires 1 args")
      flag.Usage()
    }
    arg428 := flag.Arg(1)
    mbTrans429 := thrift.NewTMemoryBufferLen(len(arg428))
    defer mbTrans429.Close()
    _, err430 := mbTrans429.WriteString(arg428)
    if err430 != nil {
      Usage()
      return
    }
    factory431 := thrift.NewTJSONProtocolFactory()
    jsProt432 := factory431.GetProtocol(mbTrans429)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err433 := argvalue0.Read(context.Background(), jsProt432)
    if err433 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablets requires 1 args")
      flag.Usage()
    }
    arg434 := flag.Arg(1)
    mbTrans435 := thrift.NewTMemoryBufferLen(len(arg434))
    defer mbTrans435.Close()
    _, err436 := mbTrans435.WriteString(arg434)
    if err436 != nil {
      Usage()
      return
    }
    factory437 := thrift.NewTJSONProtocolFactory()
    jsProt438 := factory437.GetProtocol(mbTrans435)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err439 := argvalue0.Read(context.Background(), jsProt438)
    if err439 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecords requires 1 args")
      flag.Usage()
    }
    arg440 := flag.Arg(1)
    mbTrans441 := thrift.NewTMemoryBufferLen(len(arg440))
    defer mbTrans441.Close()
    _, err442 := mbTrans441.WriteString(arg440)
    if err442 != nil {
      Usage()
      return
    }
    factory443 := thrift.NewTJSONProtocolFactory()
    jsProt444 := factory443.GetProtocol(mbTrans441)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err445 := argvalue0.Read(context.Background(), jsProt444)
    if err445 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg446 := flag.Arg(1)
    mbTrans447 := thrift.NewTMemoryBufferLen(len(arg446))
    defer mbTrans447.Close()
    _, err448 := mbTrans447.WriteString(arg446)
    if err448 != nil {
      Usage()
      return
    }
    factory449 := thrift.NewTJSONProtocolFactory()
    jsProt450 := factory449.GetProtocol(mbTrans447)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err451 := argvalue0.Read(context.Background(), jsProt450)
    if err451 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg452 := flag.Arg(1)
    mbTrans453 := thrift.NewTMemoryBufferLen(len(arg452))
    defer mbTrans453.Close()
    _, err454 := mbTrans453.WriteString(arg452)
    if err454 != nil {
      Usage()
      return
    }
    factory455 := thrift.NewTJSONProtocolFactory()
    jsProt456 := factory455.GetProtocol(mbTrans453)
    argvalue0 := rpc.NewTSInsertStringRecordsOfOneDeviceReq()
    err457 := argvalue0.Read(context.Background(), jsProt456)
    if err457 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg458 := flag.Arg(1)
    mbTrans459 := thrift.NewTMemoryBufferLen(len(arg458))
    defer mbTrans459.Close()
    _, err460 := mbTrans459.WriteString(arg458)
    if err460 != nil {
      Usage()
      return
    }
    factory461 := thrift.NewTJSONProtocolFactory()
    jsProt462 := factory461.GetProtocol(mbTrans459)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err463 := argvalue0.Read(context.Background(), jsProt462)
    if err463 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablet requires 1 args")
      flag.Usage()
    }
    arg464 := flag.Arg(1)
    mbTrans465 := thrift.NewTMemoryBufferLen(len(arg464))
    defer mbTrans465.Close()
    _, err466 := mbTrans465.WriteString(arg464)
    if err466 != nil {
      Usage()
      return
    }
    factory467 := thrift.NewTJSONProtocolFactory()
    jsProt468 := factory467.GetProtocol(mbTrans465)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err469 := argvalue0.Read(context.Background(), jsProt468)
    if err469 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablets requires 1 args")
      flag.Usage()
    }
    arg470 := flag.Arg(1)
    mbTrans471 := thrift.NewTMemoryBufferLen(len(arg470))
    defer mbTrans471.Close()
    _, err472 := mbTrans471.WriteString(arg470)
    if err472 != nil {
      Usage()
      return
    }
    factory473 := thrift.NewTJSONProtocolFactory()
    jsProt474 := factory473.GetProtocol(mbTrans471)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err475 := argvalue0.Read(context.Background(), jsProt474)
    if err475 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecord requires 1 args")
      flag.Usage()
    }
    arg476 := flag.Arg(1)
    mbTrans477 := thrift.NewTMemoryBufferLen(len(arg476))
    defer mbTrans477.Close()
    _, err478 := mbTrans477.WriteString(arg476)
    if err478 != nil {
      Usage()
      return
    }
    factory479 := thrift.NewTJSONProtocolFactory()
    jsProt480 := factory479.GetProtocol(mbTrans477)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err481 := argvalue0.Read(context.Background(), jsProt480)
    if err481 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg482 := flag.Arg(1)
    mbTrans483 := thrift.NewTMemoryBufferLen(len(arg482))
    defer mbTrans483.Close()
    _, err484 := mbTrans483.WriteString(arg482)
    if err484 != nil {
      Usage()
      return
    }
    factory485 := thrift.NewTJSONProtocolFactory()
    jsProt486 := factory485.GetProtocol(mbTrans483)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err487 := argvalue0.Read(context.Background(), jsProt486)
    if err487 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecords requires 1 args")
      flag.Usage()
    }
    arg488 := flag.Arg(1)
    mbTrans489 := thrift.NewTMemoryBufferLen(len(arg488))
    defer mbTrans489.Close()
    _, err490 := mbTrans489.WriteString(arg488)
    if err490 != nil {
      Usage()
      return
    }
    factory491 := thrift.NewTJSONProtocolFactory()
    jsProt492 := factory491.GetProtocol(mbTrans489)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err493 := argvalue0.Read(context.Background(), jsProt492)
    if err493 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg494 := flag.Arg(1)
    mbTrans495 := thrift.NewTMemoryBufferLen(len(arg494))
    defer mbTrans495.Close()
    _, err496 := mbTrans495.WriteString(arg494)
    if err496 != nil {
      Usage()
      return
    }
    factory497 := thrift.NewTJSONProtocolFactory()
    jsProt498 := factory497.GetProtocol(mbTrans495)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err499 := argvalue0.Read(context.Background(), jsProt498)
    if err499 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg500 := flag.Arg(1)
    mbTrans501 := thrift.NewTMemoryBufferLen(len(arg500))
    defer mbTrans501.Close()
    _, err502 := mbTrans501.WriteString(arg500)
    if err502 != nil {
      Usage()
      return
    }
    factory503 := thrift.NewTJSONProtocolFactory()
    jsProt504 := factory503.GetProtocol(mbTrans501)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err505 := argvalue0.Read(context.Background(), jsProt504)
    if err505 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DeleteData requires 1 args")
      flag.Usage()
    }
    arg506 := flag.Arg(1)
    mbTrans507 := thrift.NewTMemoryBufferLen(len(arg506))
    defer mbTrans507.Close()
    _, err508 := mbTrans507.WriteString(arg506)
    if err508 != nil {
      Usage()
      return
    }
    factory509 := thrift.NewTJSONProtocolFactory()
    jsProt510 := factory509.GetProtocol(mbTrans507)
    argvalue0 := rpc.NewTSDeleteDataReq()
    err511 := argvalue0.Read(context.Background(), jsProt510)
    if err511 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DeleteData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQuery requires 1 args")
      flag.Usage()
    }
    arg512 := flag.Arg(1)
    mbTrans513 := thrift.NewTMemoryBufferLen(len(arg512))
    defer mbTrans513.Close()
    _, err514 := mbTrans513.WriteString(arg512)
    if err514 != nil {
      Usage()
      return
    }
    factory515 := thrift.NewTJSONProtocolFactory()
    jsProt516 := factory515.GetProtocol(mbTrans513)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err517 := argvalue0.Read(context.Background(), jsProt516)
    if err517 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQuery requires 1 args")
      flag.Usage()
    }
    arg518 := flag.Arg(1)
    mbTrans519 := thrift.NewTMemoryBufferLen(len(arg518))
    defer mbTrans519.Close()
    _, err520 := mbTrans519.WriteString(arg518)
    if err520 != nil {
      Usage()
      return
    }
    factory521 := thrift.NewTJSONProtocolFactory()
    jsProt522 := factory521.GetProtocol(mbTrans519)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err523 := argvalue0.Read(context.Background(), jsProt522)
    if err523 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestStatementId":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestStatementId requires 1 args")
      flag.Usage()
    }
    argvalue0, err524 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err524 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestStatementId(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg525 := flag.Arg(1)
    mbTrans526 := thrift.NewTMemoryBufferLen(len(arg525))
    defer mbTrans526.Close()
    _, err527 := mbTrans526.WriteString(arg525)
    if err527 != nil {
      Usage()
      return
    }
    factory528 := thrift.NewTJSONProtocolFactory()
    jsProt529 := factory528.GetProtocol(mbTrans526)
    argvalue0 := rpc.NewTSCreateSchemaTemplateReq()
    err530 := argvalue0.Read(context.Background(), jsProt529)
    if err530 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg531 := flag.Arg(1)
    mbTrans532 := thrift.NewTMemoryBufferLen(len(arg531))
    defer mbTrans532.Close()
    _, err533 := mbTrans532.WriteString(arg531)
    if err533 != nil {
      Usage()
      return
    }
    factory534 := thrift.NewTJSONProtocolFactory()
    jsProt535 := factory534.GetProtocol(mbTrans532)
    argvalue0 := rpc.NewTSAppendSchemaTemplateReq()
    err536 := argvalue0.Read(context.Background(), jsProt535)
    if err536 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pruneSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PruneSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg537 := flag.Arg(1)
    mbTrans538 := thrift.NewTMemoryBufferLen(len(arg537))
    defer mbTrans538.Close()
    _, err539 := mbTrans538.WriteString(arg537)
    if err539 != nil {
      Usage()
      return
    }
    factory540 := thrift.NewTJSONProtocolFactory()
    jsProt541 := factory540.GetProtocol(mbTrans538)
    argvalue0 := rpc.NewTSPruneSchemaTemplateReq()
    err542 := argvalue0.Read(context.Background(), jsProt541)
    if err542 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PruneSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "querySchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg543 := flag.Arg(1)
    mbTrans544 := thrift.NewTMemoryBufferLen(len(arg543))
    defer mbTrans544.Close()
    _, err545 := mbTrans544.WriteString(arg543)
    if err545 != nil {
      Usage()
      return
    }
    factory546 := thrift.NewTJSONProtocolFactory()
    jsProt547 := factory546.GetProtocol(mbTrans544)
    argvalue0 := rpc.NewTSQueryTemplateReq()
    err548 := argvalue0.Read(context.Background(), jsProt547)
    if err548 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg549 := flag.Arg(1)
    mbTrans550 := thrift.NewTMemoryBufferLen(len(arg549))
    defer mbTrans550.Close()
    _, err551 := mbTrans550.WriteString(arg549)
    if err551 != nil {
      Usage()
      return
    }
    factory552 := thrift.NewTJSONProtocolFactory()
    jsProt553 := factory552.GetProtocol(mbTrans550)
    argvalue0 := rpc.NewTSSetSchemaTemplateReq()
    err554 := argvalue0.Read(context.Background(), jsProt553)
    if err554 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "unsetSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "UnsetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg555 := flag.Arg(1)
    mbTrans556 := thrift.NewTMemoryBufferLen(len(arg555))
    defer mbTrans556.Close()
    _, err557 := mbTrans556.WriteString(arg555)
    if err557 != nil {
      Usage()
      return
    }
    factory558 := thrift.NewTJSONProtocolFactory()
    jsProt559 := factory558.GetProtocol(mbTrans556)
    argvalue0 := rpc.NewTSUnsetSchemaTemplateReq()
    err560 := argvalue0.Read(context.Background(), jsProt559)
    if err560 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.UnsetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setUsingTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetUsingTemplate requires 1 args")
      flag.Usage()
    }
    arg561 := flag.Arg(1)
    mbTrans562 := thrift.NewTMemoryBufferLen(len(arg561))
    defer mbTrans562.Close()
    _, err563 := mbTrans562.WriteString(arg561)
    if err563 != nil {
      Usage()
      return
    }
    factory564 := thrift.NewTJSONProtocolFactory()
    jsProt565 := factory564.GetProtocol(mbTrans562)
    argvalue0 := rpc.NewTSSetUsingTemplateReq()
    err566 := argvalue0.Read(context.Background(), jsProt565)
    if err566 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetUsingTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "unsetUsingTemplate":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "UnsetUsingTemplate requires 3 args")
      flag.Usage()
    }
    argvalue0, err567 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err567 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    argvalue2 := flag.Arg(3)
    value2 := argvalue2
    fmt.Print(client.UnsetUsingTemplate(context.Background(), value0, value1, value2))
    fmt.Print("\n")
    break
  case "dropSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DropSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg570 := flag.Arg(1)
    mbTrans571 := thrift.NewTMemoryBufferLen(len(arg570))
    defer mbTrans571.Close()
    _, err572 := mbTrans571.WriteString(arg570)
    if err572 != nil {
      Usage()
      return
    }
    factory573 := thrift.NewTJSONProtocolFactory()
    jsProt574 := factory573.GetProtocol(mbTrans571)
    argvalue0 := rpc.NewTSDropSchemaTemplateReq()
    err575 := argvalue0.Read(context.Background(), jsProt574)
    if err575 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DropSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeOperationSync":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteOperationSync requires 1 args")
      flag.Usage()
    }
    arg576 := flag.Arg(1)
    mbTrans577 := thrift.NewTMemoryBufferLen(len(arg576))
    defer mbTrans577.Close()
    _, err578 := mbTrans577.WriteString(arg576)
    if err578 != nil {
      Usage()
      return
    }
    factory579 := thrift.NewTJSONProtocolFactory()
    jsProt580 := factory579.GetProtocol(mbTrans577)
    argvalue0 := rpc.NewTSOperationSyncWriteReq()
    err581 := argvalue0.Read(context.Background(), jsProt580)
    if err581 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteOperationSync(context.Background(), value0))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
