// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package rpc

import(
	"bytes"
	"context"
	"database/sql/driver"
	"errors"
	"fmt"
	"time"
	"github.com/apache/thrift/lib/go/thrift"
	"common"

)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = time.Now
var _ = bytes.Equal

var _ = common.GoUnusedProtection__
type TSProtocolVersion int64
const (
  TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1 TSProtocolVersion = 0
  TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2 TSProtocolVersion = 1
  TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3 TSProtocolVersion = 2
)

func (p TSProtocolVersion) String() string {
  switch p {
  case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1: return "IOTDB_SERVICE_PROTOCOL_V1"
  case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2: return "IOTDB_SERVICE_PROTOCOL_V2"
  case TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3: return "IOTDB_SERVICE_PROTOCOL_V3"
  }
  return "<UNSET>"
}

func TSProtocolVersionFromString(s string) (TSProtocolVersion, error) {
  switch s {
  case "IOTDB_SERVICE_PROTOCOL_V1": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V1, nil 
  case "IOTDB_SERVICE_PROTOCOL_V2": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V2, nil 
  case "IOTDB_SERVICE_PROTOCOL_V3": return TSProtocolVersion_IOTDB_SERVICE_PROTOCOL_V3, nil 
  }
  return TSProtocolVersion(0), fmt.Errorf("not a valid TSProtocolVersion string")
}


func TSProtocolVersionPtr(v TSProtocolVersion) *TSProtocolVersion { return &v }

func (p TSProtocolVersion) MarshalText() ([]byte, error) {
return []byte(p.String()), nil
}

func (p *TSProtocolVersion) UnmarshalText(text []byte) error {
q, err := TSProtocolVersionFromString(string(text))
if (err != nil) {
return err
}
*p = q
return nil
}

func (p *TSProtocolVersion) Scan(value interface{}) error {
v, ok := value.(int64)
if !ok {
return errors.New("Scan value is not int64")
}
*p = TSProtocolVersion(v)
return nil
}

func (p * TSProtocolVersion) Value() (driver.Value, error) {
  if p == nil {
    return nil, nil
  }
return int64(*p), nil
}
type TSConnectionType int64
const (
  TSConnectionType_THRIFT_BASED TSConnectionType = 0
  TSConnectionType_MQTT_BASED TSConnectionType = 1
  TSConnectionType_INTERNAL TSConnectionType = 2
)

func (p TSConnectionType) String() string {
  switch p {
  case TSConnectionType_THRIFT_BASED: return "THRIFT_BASED"
  case TSConnectionType_MQTT_BASED: return "MQTT_BASED"
  case TSConnectionType_INTERNAL: return "INTERNAL"
  }
  return "<UNSET>"
}

func TSConnectionTypeFromString(s string) (TSConnectionType, error) {
  switch s {
  case "THRIFT_BASED": return TSConnectionType_THRIFT_BASED, nil 
  case "MQTT_BASED": return TSConnectionType_MQTT_BASED, nil 
  case "INTERNAL": return TSConnectionType_INTERNAL, nil 
  }
  return TSConnectionType(0), fmt.Errorf("not a valid TSConnectionType string")
}


func TSConnectionTypePtr(v TSConnectionType) *TSConnectionType { return &v }

func (p TSConnectionType) MarshalText() ([]byte, error) {
return []byte(p.String()), nil
}

func (p *TSConnectionType) UnmarshalText(text []byte) error {
q, err := TSConnectionTypeFromString(string(text))
if (err != nil) {
return err
}
*p = q
return nil
}

func (p *TSConnectionType) Scan(value interface{}) error {
v, ok := value.(int64)
if !ok {
return errors.New("Scan value is not int64")
}
*p = TSConnectionType(v)
return nil
}

func (p * TSConnectionType) Value() (driver.Value, error) {
  if p == nil {
    return nil, nil
  }
return int64(*p), nil
}
// Attributes:
//  - Time
//  - ValueList
//  - BitmapList
type TSQueryDataSet struct {
  Time []byte `thrift:"time,1,required" db:"time" json:"time"`
  ValueList [][]byte `thrift:"valueList,2,required" db:"valueList" json:"valueList"`
  BitmapList [][]byte `thrift:"bitmapList,3,required" db:"bitmapList" json:"bitmapList"`
}

func NewTSQueryDataSet() *TSQueryDataSet {
  return &TSQueryDataSet{}
}


func (p *TSQueryDataSet) GetTime() []byte {
  return p.Time
}

func (p *TSQueryDataSet) GetValueList() [][]byte {
  return p.ValueList
}

func (p *TSQueryDataSet) GetBitmapList() [][]byte {
  return p.BitmapList
}
func (p *TSQueryDataSet) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTime bool = false;
  var issetValueList bool = false;
  var issetBitmapList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetValueList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetBitmapList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Time is not set"));
  }
  if !issetValueList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValueList is not set"));
  }
  if !issetBitmapList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field BitmapList is not set"));
  }
  return nil
}

func (p *TSQueryDataSet)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Time = v
}
  return nil
}

func (p *TSQueryDataSet)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValueList =  tSlice
  for i := 0; i < size; i ++ {
var _elem0 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem0 = v
}
    p.ValueList = append(p.ValueList, _elem0)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryDataSet)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.BitmapList =  tSlice
  for i := 0; i < size; i ++ {
var _elem1 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem1 = v
}
    p.BitmapList = append(p.BitmapList, _elem1)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryDataSet) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSQueryDataSet"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSQueryDataSet) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "time", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:time: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Time); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.time (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:time: ", p), err) }
  return err
}

func (p *TSQueryDataSet) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valueList", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:valueList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValueList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValueList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:valueList: ", p), err) }
  return err
}

func (p *TSQueryDataSet) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "bitmapList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:bitmapList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.BitmapList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.BitmapList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:bitmapList: ", p), err) }
  return err
}

func (p *TSQueryDataSet) Equals(other *TSQueryDataSet) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if bytes.Compare(p.Time, other.Time) != 0 { return false }
  if len(p.ValueList) != len(other.ValueList) { return false }
  for i, _tgt := range p.ValueList {
    _src2 := other.ValueList[i]
    if bytes.Compare(_tgt, _src2) != 0 { return false }
  }
  if len(p.BitmapList) != len(other.BitmapList) { return false }
  for i, _tgt := range p.BitmapList {
    _src3 := other.BitmapList[i]
    if bytes.Compare(_tgt, _src3) != 0 { return false }
  }
  return true
}

func (p *TSQueryDataSet) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSQueryDataSet(%+v)", *p)
}

// Attributes:
//  - TimeList
//  - ValueList
type TSQueryNonAlignDataSet struct {
  TimeList [][]byte `thrift:"timeList,1,required" db:"timeList" json:"timeList"`
  ValueList [][]byte `thrift:"valueList,2,required" db:"valueList" json:"valueList"`
}

func NewTSQueryNonAlignDataSet() *TSQueryNonAlignDataSet {
  return &TSQueryNonAlignDataSet{}
}


func (p *TSQueryNonAlignDataSet) GetTimeList() [][]byte {
  return p.TimeList
}

func (p *TSQueryNonAlignDataSet) GetValueList() [][]byte {
  return p.ValueList
}
func (p *TSQueryNonAlignDataSet) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetTimeList bool = false;
  var issetValueList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetTimeList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetValueList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetTimeList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeList is not set"));
  }
  if !issetValueList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValueList is not set"));
  }
  return nil
}

func (p *TSQueryNonAlignDataSet)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.TimeList =  tSlice
  for i := 0; i < size; i ++ {
var _elem4 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem4 = v
}
    p.TimeList = append(p.TimeList, _elem4)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryNonAlignDataSet)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValueList =  tSlice
  for i := 0; i < size; i ++ {
var _elem5 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem5 = v
}
    p.ValueList = append(p.ValueList, _elem5)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryNonAlignDataSet) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSQueryNonAlignDataSet"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSQueryNonAlignDataSet) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timeList", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:timeList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.TimeList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.TimeList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:timeList: ", p), err) }
  return err
}

func (p *TSQueryNonAlignDataSet) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valueList", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:valueList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValueList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValueList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:valueList: ", p), err) }
  return err
}

func (p *TSQueryNonAlignDataSet) Equals(other *TSQueryNonAlignDataSet) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.TimeList) != len(other.TimeList) { return false }
  for i, _tgt := range p.TimeList {
    _src6 := other.TimeList[i]
    if bytes.Compare(_tgt, _src6) != 0 { return false }
  }
  if len(p.ValueList) != len(other.ValueList) { return false }
  for i, _tgt := range p.ValueList {
    _src7 := other.ValueList[i]
    if bytes.Compare(_tgt, _src7) != 0 { return false }
  }
  return true
}

func (p *TSQueryNonAlignDataSet) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSQueryNonAlignDataSet(%+v)", *p)
}

// Attributes:
//  - ActivityList
//  - ElapsedTimeList
//  - SeriesPathNum
//  - SeqFileNum
//  - UnSeqFileNum
//  - SequenceChunkNum
//  - SequenceChunkPointNum
//  - UnsequenceChunkNum
//  - UnsequenceChunkPointNum
//  - TotalPageNum
//  - OverlappedPageNum
type TSTracingInfo struct {
  ActivityList []string `thrift:"activityList,1,required" db:"activityList" json:"activityList"`
  ElapsedTimeList []int64 `thrift:"elapsedTimeList,2,required" db:"elapsedTimeList" json:"elapsedTimeList"`
  SeriesPathNum *int32 `thrift:"seriesPathNum,3" db:"seriesPathNum" json:"seriesPathNum,omitempty"`
  SeqFileNum *int32 `thrift:"seqFileNum,4" db:"seqFileNum" json:"seqFileNum,omitempty"`
  UnSeqFileNum *int32 `thrift:"unSeqFileNum,5" db:"unSeqFileNum" json:"unSeqFileNum,omitempty"`
  SequenceChunkNum *int32 `thrift:"sequenceChunkNum,6" db:"sequenceChunkNum" json:"sequenceChunkNum,omitempty"`
  SequenceChunkPointNum *int64 `thrift:"sequenceChunkPointNum,7" db:"sequenceChunkPointNum" json:"sequenceChunkPointNum,omitempty"`
  UnsequenceChunkNum *int32 `thrift:"unsequenceChunkNum,8" db:"unsequenceChunkNum" json:"unsequenceChunkNum,omitempty"`
  UnsequenceChunkPointNum *int64 `thrift:"unsequenceChunkPointNum,9" db:"unsequenceChunkPointNum" json:"unsequenceChunkPointNum,omitempty"`
  TotalPageNum *int32 `thrift:"totalPageNum,10" db:"totalPageNum" json:"totalPageNum,omitempty"`
  OverlappedPageNum *int32 `thrift:"overlappedPageNum,11" db:"overlappedPageNum" json:"overlappedPageNum,omitempty"`
}

func NewTSTracingInfo() *TSTracingInfo {
  return &TSTracingInfo{}
}


func (p *TSTracingInfo) GetActivityList() []string {
  return p.ActivityList
}

func (p *TSTracingInfo) GetElapsedTimeList() []int64 {
  return p.ElapsedTimeList
}
var TSTracingInfo_SeriesPathNum_DEFAULT int32
func (p *TSTracingInfo) GetSeriesPathNum() int32 {
  if !p.IsSetSeriesPathNum() {
    return TSTracingInfo_SeriesPathNum_DEFAULT
  }
return *p.SeriesPathNum
}
var TSTracingInfo_SeqFileNum_DEFAULT int32
func (p *TSTracingInfo) GetSeqFileNum() int32 {
  if !p.IsSetSeqFileNum() {
    return TSTracingInfo_SeqFileNum_DEFAULT
  }
return *p.SeqFileNum
}
var TSTracingInfo_UnSeqFileNum_DEFAULT int32
func (p *TSTracingInfo) GetUnSeqFileNum() int32 {
  if !p.IsSetUnSeqFileNum() {
    return TSTracingInfo_UnSeqFileNum_DEFAULT
  }
return *p.UnSeqFileNum
}
var TSTracingInfo_SequenceChunkNum_DEFAULT int32
func (p *TSTracingInfo) GetSequenceChunkNum() int32 {
  if !p.IsSetSequenceChunkNum() {
    return TSTracingInfo_SequenceChunkNum_DEFAULT
  }
return *p.SequenceChunkNum
}
var TSTracingInfo_SequenceChunkPointNum_DEFAULT int64
func (p *TSTracingInfo) GetSequenceChunkPointNum() int64 {
  if !p.IsSetSequenceChunkPointNum() {
    return TSTracingInfo_SequenceChunkPointNum_DEFAULT
  }
return *p.SequenceChunkPointNum
}
var TSTracingInfo_UnsequenceChunkNum_DEFAULT int32
func (p *TSTracingInfo) GetUnsequenceChunkNum() int32 {
  if !p.IsSetUnsequenceChunkNum() {
    return TSTracingInfo_UnsequenceChunkNum_DEFAULT
  }
return *p.UnsequenceChunkNum
}
var TSTracingInfo_UnsequenceChunkPointNum_DEFAULT int64
func (p *TSTracingInfo) GetUnsequenceChunkPointNum() int64 {
  if !p.IsSetUnsequenceChunkPointNum() {
    return TSTracingInfo_UnsequenceChunkPointNum_DEFAULT
  }
return *p.UnsequenceChunkPointNum
}
var TSTracingInfo_TotalPageNum_DEFAULT int32
func (p *TSTracingInfo) GetTotalPageNum() int32 {
  if !p.IsSetTotalPageNum() {
    return TSTracingInfo_TotalPageNum_DEFAULT
  }
return *p.TotalPageNum
}
var TSTracingInfo_OverlappedPageNum_DEFAULT int32
func (p *TSTracingInfo) GetOverlappedPageNum() int32 {
  if !p.IsSetOverlappedPageNum() {
    return TSTracingInfo_OverlappedPageNum_DEFAULT
  }
return *p.OverlappedPageNum
}
func (p *TSTracingInfo) IsSetSeriesPathNum() bool {
  return p.SeriesPathNum != nil
}

func (p *TSTracingInfo) IsSetSeqFileNum() bool {
  return p.SeqFileNum != nil
}

func (p *TSTracingInfo) IsSetUnSeqFileNum() bool {
  return p.UnSeqFileNum != nil
}

func (p *TSTracingInfo) IsSetSequenceChunkNum() bool {
  return p.SequenceChunkNum != nil
}

func (p *TSTracingInfo) IsSetSequenceChunkPointNum() bool {
  return p.SequenceChunkPointNum != nil
}

func (p *TSTracingInfo) IsSetUnsequenceChunkNum() bool {
  return p.UnsequenceChunkNum != nil
}

func (p *TSTracingInfo) IsSetUnsequenceChunkPointNum() bool {
  return p.UnsequenceChunkPointNum != nil
}

func (p *TSTracingInfo) IsSetTotalPageNum() bool {
  return p.TotalPageNum != nil
}

func (p *TSTracingInfo) IsSetOverlappedPageNum() bool {
  return p.OverlappedPageNum != nil
}

func (p *TSTracingInfo) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetActivityList bool = false;
  var issetElapsedTimeList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetActivityList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetElapsedTimeList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 11:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField11(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetActivityList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ActivityList is not set"));
  }
  if !issetElapsedTimeList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ElapsedTimeList is not set"));
  }
  return nil
}

func (p *TSTracingInfo)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.ActivityList =  tSlice
  for i := 0; i < size; i ++ {
var _elem8 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem8 = v
}
    p.ActivityList = append(p.ActivityList, _elem8)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSTracingInfo)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.ElapsedTimeList =  tSlice
  for i := 0; i < size; i ++ {
var _elem9 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem9 = v
}
    p.ElapsedTimeList = append(p.ElapsedTimeList, _elem9)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSTracingInfo)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.SeriesPathNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.SeqFileNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.UnSeqFileNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.SequenceChunkNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.SequenceChunkPointNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.UnsequenceChunkNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.UnsequenceChunkPointNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 10: ", err)
} else {
  p.TotalPageNum = &v
}
  return nil
}

func (p *TSTracingInfo)  ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 11: ", err)
} else {
  p.OverlappedPageNum = &v
}
  return nil
}

func (p *TSTracingInfo) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSTracingInfo"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
    if err := p.writeField11(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSTracingInfo) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "activityList", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:activityList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ActivityList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ActivityList {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:activityList: ", p), err) }
  return err
}

func (p *TSTracingInfo) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "elapsedTimeList", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:elapsedTimeList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.ElapsedTimeList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ElapsedTimeList {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:elapsedTimeList: ", p), err) }
  return err
}

func (p *TSTracingInfo) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSeriesPathNum() {
    if err := oprot.WriteFieldBegin(ctx, "seriesPathNum", thrift.I32, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:seriesPathNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.SeriesPathNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.seriesPathNum (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:seriesPathNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSeqFileNum() {
    if err := oprot.WriteFieldBegin(ctx, "seqFileNum", thrift.I32, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:seqFileNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.SeqFileNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.seqFileNum (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:seqFileNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetUnSeqFileNum() {
    if err := oprot.WriteFieldBegin(ctx, "unSeqFileNum", thrift.I32, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:unSeqFileNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.UnSeqFileNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.unSeqFileNum (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:unSeqFileNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSequenceChunkNum() {
    if err := oprot.WriteFieldBegin(ctx, "sequenceChunkNum", thrift.I32, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:sequenceChunkNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.SequenceChunkNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.sequenceChunkNum (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:sequenceChunkNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSequenceChunkPointNum() {
    if err := oprot.WriteFieldBegin(ctx, "sequenceChunkPointNum", thrift.I64, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:sequenceChunkPointNum: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.SequenceChunkPointNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.sequenceChunkPointNum (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:sequenceChunkPointNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetUnsequenceChunkNum() {
    if err := oprot.WriteFieldBegin(ctx, "unsequenceChunkNum", thrift.I32, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:unsequenceChunkNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.UnsequenceChunkNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.unsequenceChunkNum (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:unsequenceChunkNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetUnsequenceChunkPointNum() {
    if err := oprot.WriteFieldBegin(ctx, "unsequenceChunkPointNum", thrift.I64, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:unsequenceChunkPointNum: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.UnsequenceChunkPointNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.unsequenceChunkPointNum (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:unsequenceChunkPointNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTotalPageNum() {
    if err := oprot.WriteFieldBegin(ctx, "totalPageNum", thrift.I32, 10); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:totalPageNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.TotalPageNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.totalPageNum (10) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 10:totalPageNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetOverlappedPageNum() {
    if err := oprot.WriteFieldBegin(ctx, "overlappedPageNum", thrift.I32, 11); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:overlappedPageNum: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.OverlappedPageNum)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.overlappedPageNum (11) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 11:overlappedPageNum: ", p), err) }
  }
  return err
}

func (p *TSTracingInfo) Equals(other *TSTracingInfo) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.ActivityList) != len(other.ActivityList) { return false }
  for i, _tgt := range p.ActivityList {
    _src10 := other.ActivityList[i]
    if _tgt != _src10 { return false }
  }
  if len(p.ElapsedTimeList) != len(other.ElapsedTimeList) { return false }
  for i, _tgt := range p.ElapsedTimeList {
    _src11 := other.ElapsedTimeList[i]
    if _tgt != _src11 { return false }
  }
  if p.SeriesPathNum != other.SeriesPathNum {
    if p.SeriesPathNum == nil || other.SeriesPathNum == nil {
      return false
    }
    if (*p.SeriesPathNum) != (*other.SeriesPathNum) { return false }
  }
  if p.SeqFileNum != other.SeqFileNum {
    if p.SeqFileNum == nil || other.SeqFileNum == nil {
      return false
    }
    if (*p.SeqFileNum) != (*other.SeqFileNum) { return false }
  }
  if p.UnSeqFileNum != other.UnSeqFileNum {
    if p.UnSeqFileNum == nil || other.UnSeqFileNum == nil {
      return false
    }
    if (*p.UnSeqFileNum) != (*other.UnSeqFileNum) { return false }
  }
  if p.SequenceChunkNum != other.SequenceChunkNum {
    if p.SequenceChunkNum == nil || other.SequenceChunkNum == nil {
      return false
    }
    if (*p.SequenceChunkNum) != (*other.SequenceChunkNum) { return false }
  }
  if p.SequenceChunkPointNum != other.SequenceChunkPointNum {
    if p.SequenceChunkPointNum == nil || other.SequenceChunkPointNum == nil {
      return false
    }
    if (*p.SequenceChunkPointNum) != (*other.SequenceChunkPointNum) { return false }
  }
  if p.UnsequenceChunkNum != other.UnsequenceChunkNum {
    if p.UnsequenceChunkNum == nil || other.UnsequenceChunkNum == nil {
      return false
    }
    if (*p.UnsequenceChunkNum) != (*other.UnsequenceChunkNum) { return false }
  }
  if p.UnsequenceChunkPointNum != other.UnsequenceChunkPointNum {
    if p.UnsequenceChunkPointNum == nil || other.UnsequenceChunkPointNum == nil {
      return false
    }
    if (*p.UnsequenceChunkPointNum) != (*other.UnsequenceChunkPointNum) { return false }
  }
  if p.TotalPageNum != other.TotalPageNum {
    if p.TotalPageNum == nil || other.TotalPageNum == nil {
      return false
    }
    if (*p.TotalPageNum) != (*other.TotalPageNum) { return false }
  }
  if p.OverlappedPageNum != other.OverlappedPageNum {
    if p.OverlappedPageNum == nil || other.OverlappedPageNum == nil {
      return false
    }
    if (*p.OverlappedPageNum) != (*other.OverlappedPageNum) { return false }
  }
  return true
}

func (p *TSTracingInfo) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSTracingInfo(%+v)", *p)
}

// Attributes:
//  - Status
//  - QueryId
//  - Columns
//  - OperationType
//  - IgnoreTimeStamp
//  - DataTypeList
//  - QueryDataSet
//  - NonAlignQueryDataSet
//  - ColumnNameIndexMap
//  - SgColumns
//  - AliasColumns
//  - TracingInfo
//  - QueryResult_
//  - MoreData
type TSExecuteStatementResp struct {
  Status *common.TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  QueryId *int64 `thrift:"queryId,2" db:"queryId" json:"queryId,omitempty"`
  Columns []string `thrift:"columns,3" db:"columns" json:"columns,omitempty"`
  OperationType *string `thrift:"operationType,4" db:"operationType" json:"operationType,omitempty"`
  IgnoreTimeStamp *bool `thrift:"ignoreTimeStamp,5" db:"ignoreTimeStamp" json:"ignoreTimeStamp,omitempty"`
  DataTypeList []string `thrift:"dataTypeList,6" db:"dataTypeList" json:"dataTypeList,omitempty"`
  QueryDataSet *TSQueryDataSet `thrift:"queryDataSet,7" db:"queryDataSet" json:"queryDataSet,omitempty"`
  NonAlignQueryDataSet *TSQueryNonAlignDataSet `thrift:"nonAlignQueryDataSet,8" db:"nonAlignQueryDataSet" json:"nonAlignQueryDataSet,omitempty"`
  ColumnNameIndexMap map[string]int32 `thrift:"columnNameIndexMap,9" db:"columnNameIndexMap" json:"columnNameIndexMap,omitempty"`
  SgColumns []string `thrift:"sgColumns,10" db:"sgColumns" json:"sgColumns,omitempty"`
  AliasColumns []int8 `thrift:"aliasColumns,11" db:"aliasColumns" json:"aliasColumns,omitempty"`
  TracingInfo *TSTracingInfo `thrift:"tracingInfo,12" db:"tracingInfo" json:"tracingInfo,omitempty"`
  QueryResult_ [][]byte `thrift:"queryResult,13" db:"queryResult" json:"queryResult,omitempty"`
  MoreData *bool `thrift:"moreData,14" db:"moreData" json:"moreData,omitempty"`
}

func NewTSExecuteStatementResp() *TSExecuteStatementResp {
  return &TSExecuteStatementResp{}
}

var TSExecuteStatementResp_Status_DEFAULT *common.TSStatus
func (p *TSExecuteStatementResp) GetStatus() *common.TSStatus {
  if !p.IsSetStatus() {
    return TSExecuteStatementResp_Status_DEFAULT
  }
return p.Status
}
var TSExecuteStatementResp_QueryId_DEFAULT int64
func (p *TSExecuteStatementResp) GetQueryId() int64 {
  if !p.IsSetQueryId() {
    return TSExecuteStatementResp_QueryId_DEFAULT
  }
return *p.QueryId
}
var TSExecuteStatementResp_Columns_DEFAULT []string

func (p *TSExecuteStatementResp) GetColumns() []string {
  return p.Columns
}
var TSExecuteStatementResp_OperationType_DEFAULT string
func (p *TSExecuteStatementResp) GetOperationType() string {
  if !p.IsSetOperationType() {
    return TSExecuteStatementResp_OperationType_DEFAULT
  }
return *p.OperationType
}
var TSExecuteStatementResp_IgnoreTimeStamp_DEFAULT bool
func (p *TSExecuteStatementResp) GetIgnoreTimeStamp() bool {
  if !p.IsSetIgnoreTimeStamp() {
    return TSExecuteStatementResp_IgnoreTimeStamp_DEFAULT
  }
return *p.IgnoreTimeStamp
}
var TSExecuteStatementResp_DataTypeList_DEFAULT []string

func (p *TSExecuteStatementResp) GetDataTypeList() []string {
  return p.DataTypeList
}
var TSExecuteStatementResp_QueryDataSet_DEFAULT *TSQueryDataSet
func (p *TSExecuteStatementResp) GetQueryDataSet() *TSQueryDataSet {
  if !p.IsSetQueryDataSet() {
    return TSExecuteStatementResp_QueryDataSet_DEFAULT
  }
return p.QueryDataSet
}
var TSExecuteStatementResp_NonAlignQueryDataSet_DEFAULT *TSQueryNonAlignDataSet
func (p *TSExecuteStatementResp) GetNonAlignQueryDataSet() *TSQueryNonAlignDataSet {
  if !p.IsSetNonAlignQueryDataSet() {
    return TSExecuteStatementResp_NonAlignQueryDataSet_DEFAULT
  }
return p.NonAlignQueryDataSet
}
var TSExecuteStatementResp_ColumnNameIndexMap_DEFAULT map[string]int32

func (p *TSExecuteStatementResp) GetColumnNameIndexMap() map[string]int32 {
  return p.ColumnNameIndexMap
}
var TSExecuteStatementResp_SgColumns_DEFAULT []string

func (p *TSExecuteStatementResp) GetSgColumns() []string {
  return p.SgColumns
}
var TSExecuteStatementResp_AliasColumns_DEFAULT []int8

func (p *TSExecuteStatementResp) GetAliasColumns() []int8 {
  return p.AliasColumns
}
var TSExecuteStatementResp_TracingInfo_DEFAULT *TSTracingInfo
func (p *TSExecuteStatementResp) GetTracingInfo() *TSTracingInfo {
  if !p.IsSetTracingInfo() {
    return TSExecuteStatementResp_TracingInfo_DEFAULT
  }
return p.TracingInfo
}
var TSExecuteStatementResp_QueryResult__DEFAULT [][]byte

func (p *TSExecuteStatementResp) GetQueryResult_() [][]byte {
  return p.QueryResult_
}
var TSExecuteStatementResp_MoreData_DEFAULT bool
func (p *TSExecuteStatementResp) GetMoreData() bool {
  if !p.IsSetMoreData() {
    return TSExecuteStatementResp_MoreData_DEFAULT
  }
return *p.MoreData
}
func (p *TSExecuteStatementResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSExecuteStatementResp) IsSetQueryId() bool {
  return p.QueryId != nil
}

func (p *TSExecuteStatementResp) IsSetColumns() bool {
  return p.Columns != nil
}

func (p *TSExecuteStatementResp) IsSetOperationType() bool {
  return p.OperationType != nil
}

func (p *TSExecuteStatementResp) IsSetIgnoreTimeStamp() bool {
  return p.IgnoreTimeStamp != nil
}

func (p *TSExecuteStatementResp) IsSetDataTypeList() bool {
  return p.DataTypeList != nil
}

func (p *TSExecuteStatementResp) IsSetQueryDataSet() bool {
  return p.QueryDataSet != nil
}

func (p *TSExecuteStatementResp) IsSetNonAlignQueryDataSet() bool {
  return p.NonAlignQueryDataSet != nil
}

func (p *TSExecuteStatementResp) IsSetColumnNameIndexMap() bool {
  return p.ColumnNameIndexMap != nil
}

func (p *TSExecuteStatementResp) IsSetSgColumns() bool {
  return p.SgColumns != nil
}

func (p *TSExecuteStatementResp) IsSetAliasColumns() bool {
  return p.AliasColumns != nil
}

func (p *TSExecuteStatementResp) IsSetTracingInfo() bool {
  return p.TracingInfo != nil
}

func (p *TSExecuteStatementResp) IsSetQueryResult_() bool {
  return p.QueryResult_ != nil
}

func (p *TSExecuteStatementResp) IsSetMoreData() bool {
  return p.MoreData != nil
}

func (p *TSExecuteStatementResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 11:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField11(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 12:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField12(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 13:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField13(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 14:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField14(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &common.TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryId = &v
}
  return nil
}

func (p *TSExecuteStatementResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Columns =  tSlice
  for i := 0; i < size; i ++ {
var _elem12 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem12 = v
}
    p.Columns = append(p.Columns, _elem12)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.OperationType = &v
}
  return nil
}

func (p *TSExecuteStatementResp)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.IgnoreTimeStamp = &v
}
  return nil
}

func (p *TSExecuteStatementResp)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.DataTypeList =  tSlice
  for i := 0; i < size; i ++ {
var _elem13 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem13 = v
}
    p.DataTypeList = append(p.DataTypeList, _elem13)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  p.QueryDataSet = &TSQueryDataSet{}
  if err := p.QueryDataSet.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.QueryDataSet), err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  p.NonAlignQueryDataSet = &TSQueryNonAlignDataSet{}
  if err := p.NonAlignQueryDataSet.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.NonAlignQueryDataSet), err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]int32, size)
  p.ColumnNameIndexMap =  tMap
  for i := 0; i < size; i ++ {
var _key14 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key14 = v
}
var _val15 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val15 = v
}
    p.ColumnNameIndexMap[_key14] = _val15
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.SgColumns =  tSlice
  for i := 0; i < size; i ++ {
var _elem16 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem16 = v
}
    p.SgColumns = append(p.SgColumns, _elem16)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int8, 0, size)
  p.AliasColumns =  tSlice
  for i := 0; i < size; i ++ {
var _elem17 int8
    if v, err := iprot.ReadByte(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := int8(v)
    _elem17 = temp
}
    p.AliasColumns = append(p.AliasColumns, _elem17)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField12(ctx context.Context, iprot thrift.TProtocol) error {
  p.TracingInfo = &TSTracingInfo{}
  if err := p.TracingInfo.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.TracingInfo), err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField13(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.QueryResult_ =  tSlice
  for i := 0; i < size; i ++ {
var _elem18 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem18 = v
}
    p.QueryResult_ = append(p.QueryResult_, _elem18)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteStatementResp)  ReadField14(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 14: ", err)
} else {
  p.MoreData = &v
}
  return nil
}

func (p *TSExecuteStatementResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSExecuteStatementResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
    if err := p.writeField11(ctx, oprot); err != nil { return err }
    if err := p.writeField12(ctx, oprot); err != nil { return err }
    if err := p.writeField13(ctx, oprot); err != nil { return err }
    if err := p.writeField14(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSExecuteStatementResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSExecuteStatementResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryId() {
    if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.QueryId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetColumns() {
    if err := oprot.WriteFieldBegin(ctx, "columns", thrift.LIST, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columns: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Columns)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Columns {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columns: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetOperationType() {
    if err := oprot.WriteFieldBegin(ctx, "operationType", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:operationType: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.OperationType)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.operationType (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:operationType: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIgnoreTimeStamp() {
    if err := oprot.WriteFieldBegin(ctx, "ignoreTimeStamp", thrift.BOOL, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:ignoreTimeStamp: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IgnoreTimeStamp)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.ignoreTimeStamp (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:ignoreTimeStamp: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetDataTypeList() {
    if err := oprot.WriteFieldBegin(ctx, "dataTypeList", thrift.LIST, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:dataTypeList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.DataTypeList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.DataTypeList {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:dataTypeList: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryDataSet() {
    if err := oprot.WriteFieldBegin(ctx, "queryDataSet", thrift.STRUCT, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:queryDataSet: ", p), err) }
    if err := p.QueryDataSet.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.QueryDataSet), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:queryDataSet: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetNonAlignQueryDataSet() {
    if err := oprot.WriteFieldBegin(ctx, "nonAlignQueryDataSet", thrift.STRUCT, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:nonAlignQueryDataSet: ", p), err) }
    if err := p.NonAlignQueryDataSet.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.NonAlignQueryDataSet), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:nonAlignQueryDataSet: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetColumnNameIndexMap() {
    if err := oprot.WriteFieldBegin(ctx, "columnNameIndexMap", thrift.MAP, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:columnNameIndexMap: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.I32, len(p.ColumnNameIndexMap)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.ColumnNameIndexMap {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteI32(ctx, int32(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:columnNameIndexMap: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSgColumns() {
    if err := oprot.WriteFieldBegin(ctx, "sgColumns", thrift.LIST, 10); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:sgColumns: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.SgColumns)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.SgColumns {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 10:sgColumns: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetAliasColumns() {
    if err := oprot.WriteFieldBegin(ctx, "aliasColumns", thrift.LIST, 11); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:aliasColumns: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.BYTE, len(p.AliasColumns)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.AliasColumns {
      if err := oprot.WriteByte(ctx, int8(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 11:aliasColumns: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField12(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTracingInfo() {
    if err := oprot.WriteFieldBegin(ctx, "tracingInfo", thrift.STRUCT, 12); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 12:tracingInfo: ", p), err) }
    if err := p.TracingInfo.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.TracingInfo), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 12:tracingInfo: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField13(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryResult_() {
    if err := oprot.WriteFieldBegin(ctx, "queryResult", thrift.LIST, 13); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 13:queryResult: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.QueryResult_)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.QueryResult_ {
      if err := oprot.WriteBinary(ctx, v); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 13:queryResult: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) writeField14(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMoreData() {
    if err := oprot.WriteFieldBegin(ctx, "moreData", thrift.BOOL, 14); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 14:moreData: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.MoreData)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.moreData (14) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 14:moreData: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementResp) Equals(other *TSExecuteStatementResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.QueryId != other.QueryId {
    if p.QueryId == nil || other.QueryId == nil {
      return false
    }
    if (*p.QueryId) != (*other.QueryId) { return false }
  }
  if len(p.Columns) != len(other.Columns) { return false }
  for i, _tgt := range p.Columns {
    _src19 := other.Columns[i]
    if _tgt != _src19 { return false }
  }
  if p.OperationType != other.OperationType {
    if p.OperationType == nil || other.OperationType == nil {
      return false
    }
    if (*p.OperationType) != (*other.OperationType) { return false }
  }
  if p.IgnoreTimeStamp != other.IgnoreTimeStamp {
    if p.IgnoreTimeStamp == nil || other.IgnoreTimeStamp == nil {
      return false
    }
    if (*p.IgnoreTimeStamp) != (*other.IgnoreTimeStamp) { return false }
  }
  if len(p.DataTypeList) != len(other.DataTypeList) { return false }
  for i, _tgt := range p.DataTypeList {
    _src20 := other.DataTypeList[i]
    if _tgt != _src20 { return false }
  }
  if !p.QueryDataSet.Equals(other.QueryDataSet) { return false }
  if !p.NonAlignQueryDataSet.Equals(other.NonAlignQueryDataSet) { return false }
  if len(p.ColumnNameIndexMap) != len(other.ColumnNameIndexMap) { return false }
  for k, _tgt := range p.ColumnNameIndexMap {
    _src21 := other.ColumnNameIndexMap[k]
    if _tgt != _src21 { return false }
  }
  if len(p.SgColumns) != len(other.SgColumns) { return false }
  for i, _tgt := range p.SgColumns {
    _src22 := other.SgColumns[i]
    if _tgt != _src22 { return false }
  }
  if len(p.AliasColumns) != len(other.AliasColumns) { return false }
  for i, _tgt := range p.AliasColumns {
    _src23 := other.AliasColumns[i]
    if _tgt != _src23 { return false }
  }
  if !p.TracingInfo.Equals(other.TracingInfo) { return false }
  if len(p.QueryResult_) != len(other.QueryResult_) { return false }
  for i, _tgt := range p.QueryResult_ {
    _src24 := other.QueryResult_[i]
    if bytes.Compare(_tgt, _src24) != 0 { return false }
  }
  if p.MoreData != other.MoreData {
    if p.MoreData == nil || other.MoreData == nil {
      return false
    }
    if (*p.MoreData) != (*other.MoreData) { return false }
  }
  return true
}

func (p *TSExecuteStatementResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSExecuteStatementResp(%+v)", *p)
}

// Attributes:
//  - Status
//  - ServerProtocolVersion
//  - SessionId
//  - Configuration
type TSOpenSessionResp struct {
  Status *common.TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  ServerProtocolVersion TSProtocolVersion `thrift:"serverProtocolVersion,2,required" db:"serverProtocolVersion" json:"serverProtocolVersion"`
  SessionId *int64 `thrift:"sessionId,3" db:"sessionId" json:"sessionId,omitempty"`
  Configuration map[string]string `thrift:"configuration,4" db:"configuration" json:"configuration,omitempty"`
}

func NewTSOpenSessionResp() *TSOpenSessionResp {
  return &TSOpenSessionResp{
ServerProtocolVersion: 0,
}
}

var TSOpenSessionResp_Status_DEFAULT *common.TSStatus
func (p *TSOpenSessionResp) GetStatus() *common.TSStatus {
  if !p.IsSetStatus() {
    return TSOpenSessionResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSOpenSessionResp) GetServerProtocolVersion() TSProtocolVersion {
  return p.ServerProtocolVersion
}
var TSOpenSessionResp_SessionId_DEFAULT int64
func (p *TSOpenSessionResp) GetSessionId() int64 {
  if !p.IsSetSessionId() {
    return TSOpenSessionResp_SessionId_DEFAULT
  }
return *p.SessionId
}
var TSOpenSessionResp_Configuration_DEFAULT map[string]string

func (p *TSOpenSessionResp) GetConfiguration() map[string]string {
  return p.Configuration
}
func (p *TSOpenSessionResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSOpenSessionResp) IsSetSessionId() bool {
  return p.SessionId != nil
}

func (p *TSOpenSessionResp) IsSetConfiguration() bool {
  return p.Configuration != nil
}

func (p *TSOpenSessionResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetServerProtocolVersion bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetServerProtocolVersion = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetServerProtocolVersion{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ServerProtocolVersion is not set"));
  }
  return nil
}

func (p *TSOpenSessionResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &common.TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSOpenSessionResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  temp := TSProtocolVersion(v)
  p.ServerProtocolVersion = temp
}
  return nil
}

func (p *TSOpenSessionResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.SessionId = &v
}
  return nil
}

func (p *TSOpenSessionResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Configuration =  tMap
  for i := 0; i < size; i ++ {
var _key25 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key25 = v
}
var _val26 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val26 = v
}
    p.Configuration[_key25] = _val26
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSOpenSessionResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSOpenSessionResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSOpenSessionResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSOpenSessionResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "serverProtocolVersion", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:serverProtocolVersion: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.ServerProtocolVersion)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.serverProtocolVersion (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:serverProtocolVersion: ", p), err) }
  return err
}

func (p *TSOpenSessionResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSessionId() {
    if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:sessionId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.SessionId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.sessionId (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:sessionId: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetConfiguration() {
    if err := oprot.WriteFieldBegin(ctx, "configuration", thrift.MAP, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:configuration: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Configuration)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Configuration {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:configuration: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionResp) Equals(other *TSOpenSessionResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.ServerProtocolVersion != other.ServerProtocolVersion { return false }
  if p.SessionId != other.SessionId {
    if p.SessionId == nil || other.SessionId == nil {
      return false
    }
    if (*p.SessionId) != (*other.SessionId) { return false }
  }
  if len(p.Configuration) != len(other.Configuration) { return false }
  for k, _tgt := range p.Configuration {
    _src27 := other.Configuration[k]
    if _tgt != _src27 { return false }
  }
  return true
}

func (p *TSOpenSessionResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSOpenSessionResp(%+v)", *p)
}

// Attributes:
//  - ClientProtocol
//  - ZoneId
//  - Username
//  - Password
//  - Configuration
type TSOpenSessionReq struct {
  ClientProtocol TSProtocolVersion `thrift:"client_protocol,1,required" db:"client_protocol" json:"client_protocol"`
  ZoneId string `thrift:"zoneId,2,required" db:"zoneId" json:"zoneId"`
  Username string `thrift:"username,3,required" db:"username" json:"username"`
  Password *string `thrift:"password,4" db:"password" json:"password,omitempty"`
  Configuration map[string]string `thrift:"configuration,5" db:"configuration" json:"configuration,omitempty"`
}

func NewTSOpenSessionReq() *TSOpenSessionReq {
  return &TSOpenSessionReq{
ClientProtocol: 2,
}
}


func (p *TSOpenSessionReq) GetClientProtocol() TSProtocolVersion {
  return p.ClientProtocol
}

func (p *TSOpenSessionReq) GetZoneId() string {
  return p.ZoneId
}

func (p *TSOpenSessionReq) GetUsername() string {
  return p.Username
}
var TSOpenSessionReq_Password_DEFAULT string
func (p *TSOpenSessionReq) GetPassword() string {
  if !p.IsSetPassword() {
    return TSOpenSessionReq_Password_DEFAULT
  }
return *p.Password
}
var TSOpenSessionReq_Configuration_DEFAULT map[string]string

func (p *TSOpenSessionReq) GetConfiguration() map[string]string {
  return p.Configuration
}
func (p *TSOpenSessionReq) IsSetPassword() bool {
  return p.Password != nil
}

func (p *TSOpenSessionReq) IsSetConfiguration() bool {
  return p.Configuration != nil
}

func (p *TSOpenSessionReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetClientProtocol bool = false;
  var issetZoneId bool = false;
  var issetUsername bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetClientProtocol = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetZoneId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetUsername = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetClientProtocol{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ClientProtocol is not set"));
  }
  if !issetZoneId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ZoneId is not set"));
  }
  if !issetUsername{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Username is not set"));
  }
  return nil
}

func (p *TSOpenSessionReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  temp := TSProtocolVersion(v)
  p.ClientProtocol = temp
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.ZoneId = v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Username = v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Password = &v
}
  return nil
}

func (p *TSOpenSessionReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Configuration =  tMap
  for i := 0; i < size; i ++ {
var _key28 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key28 = v
}
var _val29 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val29 = v
}
    p.Configuration[_key28] = _val29
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSOpenSessionReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSOpenSessionReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSOpenSessionReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "client_protocol", thrift.I32, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:client_protocol: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.ClientProtocol)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.client_protocol (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:client_protocol: ", p), err) }
  return err
}

func (p *TSOpenSessionReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "zoneId", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:zoneId: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ZoneId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.zoneId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:zoneId: ", p), err) }
  return err
}

func (p *TSOpenSessionReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "username", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:username: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Username)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.username (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:username: ", p), err) }
  return err
}

func (p *TSOpenSessionReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetPassword() {
    if err := oprot.WriteFieldBegin(ctx, "password", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:password: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Password)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.password (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:password: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetConfiguration() {
    if err := oprot.WriteFieldBegin(ctx, "configuration", thrift.MAP, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:configuration: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Configuration)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Configuration {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:configuration: ", p), err) }
  }
  return err
}

func (p *TSOpenSessionReq) Equals(other *TSOpenSessionReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.ClientProtocol != other.ClientProtocol { return false }
  if p.ZoneId != other.ZoneId { return false }
  if p.Username != other.Username { return false }
  if p.Password != other.Password {
    if p.Password == nil || other.Password == nil {
      return false
    }
    if (*p.Password) != (*other.Password) { return false }
  }
  if len(p.Configuration) != len(other.Configuration) { return false }
  for k, _tgt := range p.Configuration {
    _src30 := other.Configuration[k]
    if _tgt != _src30 { return false }
  }
  return true
}

func (p *TSOpenSessionReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSOpenSessionReq(%+v)", *p)
}

// Attributes:
//  - SessionId
type TSCloseSessionReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
}

func NewTSCloseSessionReq() *TSCloseSessionReq {
  return &TSCloseSessionReq{}
}


func (p *TSCloseSessionReq) GetSessionId() int64 {
  return p.SessionId
}
func (p *TSCloseSessionReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  return nil
}

func (p *TSCloseSessionReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCloseSessionReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCloseSessionReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCloseSessionReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCloseSessionReq) Equals(other *TSCloseSessionReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  return true
}

func (p *TSCloseSessionReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCloseSessionReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statement
//  - StatementId
//  - FetchSize
//  - Timeout
//  - EnableRedirectQuery
//  - JdbcQuery
type TSExecuteStatementReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Statement string `thrift:"statement,2,required" db:"statement" json:"statement"`
  StatementId int64 `thrift:"statementId,3,required" db:"statementId" json:"statementId"`
  FetchSize *int32 `thrift:"fetchSize,4" db:"fetchSize" json:"fetchSize,omitempty"`
  Timeout *int64 `thrift:"timeout,5" db:"timeout" json:"timeout,omitempty"`
  EnableRedirectQuery *bool `thrift:"enableRedirectQuery,6" db:"enableRedirectQuery" json:"enableRedirectQuery,omitempty"`
  JdbcQuery *bool `thrift:"jdbcQuery,7" db:"jdbcQuery" json:"jdbcQuery,omitempty"`
}

func NewTSExecuteStatementReq() *TSExecuteStatementReq {
  return &TSExecuteStatementReq{}
}


func (p *TSExecuteStatementReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSExecuteStatementReq) GetStatement() string {
  return p.Statement
}

func (p *TSExecuteStatementReq) GetStatementId() int64 {
  return p.StatementId
}
var TSExecuteStatementReq_FetchSize_DEFAULT int32
func (p *TSExecuteStatementReq) GetFetchSize() int32 {
  if !p.IsSetFetchSize() {
    return TSExecuteStatementReq_FetchSize_DEFAULT
  }
return *p.FetchSize
}
var TSExecuteStatementReq_Timeout_DEFAULT int64
func (p *TSExecuteStatementReq) GetTimeout() int64 {
  if !p.IsSetTimeout() {
    return TSExecuteStatementReq_Timeout_DEFAULT
  }
return *p.Timeout
}
var TSExecuteStatementReq_EnableRedirectQuery_DEFAULT bool
func (p *TSExecuteStatementReq) GetEnableRedirectQuery() bool {
  if !p.IsSetEnableRedirectQuery() {
    return TSExecuteStatementReq_EnableRedirectQuery_DEFAULT
  }
return *p.EnableRedirectQuery
}
var TSExecuteStatementReq_JdbcQuery_DEFAULT bool
func (p *TSExecuteStatementReq) GetJdbcQuery() bool {
  if !p.IsSetJdbcQuery() {
    return TSExecuteStatementReq_JdbcQuery_DEFAULT
  }
return *p.JdbcQuery
}
func (p *TSExecuteStatementReq) IsSetFetchSize() bool {
  return p.FetchSize != nil
}

func (p *TSExecuteStatementReq) IsSetTimeout() bool {
  return p.Timeout != nil
}

func (p *TSExecuteStatementReq) IsSetEnableRedirectQuery() bool {
  return p.EnableRedirectQuery != nil
}

func (p *TSExecuteStatementReq) IsSetJdbcQuery() bool {
  return p.JdbcQuery != nil
}

func (p *TSExecuteStatementReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetStatement bool = false;
  var issetStatementId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetStatement = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetStatementId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetStatement{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statement is not set"));
  }
  if !issetStatementId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
  }
  return nil
}

func (p *TSExecuteStatementReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Statement = v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.StatementId = v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.FetchSize = &v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Timeout = &v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.EnableRedirectQuery = &v
}
  return nil
}

func (p *TSExecuteStatementReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.JdbcQuery = &v
}
  return nil
}

func (p *TSExecuteStatementReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSExecuteStatementReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSExecuteStatementReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSExecuteStatementReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statement", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statement: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Statement)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statement (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statement: ", p), err) }
  return err
}

func (p *TSExecuteStatementReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:statementId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statementId (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:statementId: ", p), err) }
  return err
}

func (p *TSExecuteStatementReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFetchSize() {
    if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:fetchSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.fetchSize (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:fetchSize: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeout() {
    if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timeout: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeout (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timeout: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetEnableRedirectQuery() {
    if err := oprot.WriteFieldBegin(ctx, "enableRedirectQuery", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:enableRedirectQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.EnableRedirectQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.enableRedirectQuery (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:enableRedirectQuery: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetJdbcQuery() {
    if err := oprot.WriteFieldBegin(ctx, "jdbcQuery", thrift.BOOL, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:jdbcQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.JdbcQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.jdbcQuery (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:jdbcQuery: ", p), err) }
  }
  return err
}

func (p *TSExecuteStatementReq) Equals(other *TSExecuteStatementReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Statement != other.Statement { return false }
  if p.StatementId != other.StatementId { return false }
  if p.FetchSize != other.FetchSize {
    if p.FetchSize == nil || other.FetchSize == nil {
      return false
    }
    if (*p.FetchSize) != (*other.FetchSize) { return false }
  }
  if p.Timeout != other.Timeout {
    if p.Timeout == nil || other.Timeout == nil {
      return false
    }
    if (*p.Timeout) != (*other.Timeout) { return false }
  }
  if p.EnableRedirectQuery != other.EnableRedirectQuery {
    if p.EnableRedirectQuery == nil || other.EnableRedirectQuery == nil {
      return false
    }
    if (*p.EnableRedirectQuery) != (*other.EnableRedirectQuery) { return false }
  }
  if p.JdbcQuery != other.JdbcQuery {
    if p.JdbcQuery == nil || other.JdbcQuery == nil {
      return false
    }
    if (*p.JdbcQuery) != (*other.JdbcQuery) { return false }
  }
  return true
}

func (p *TSExecuteStatementReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSExecuteStatementReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statements
type TSExecuteBatchStatementReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Statements []string `thrift:"statements,2,required" db:"statements" json:"statements"`
}

func NewTSExecuteBatchStatementReq() *TSExecuteBatchStatementReq {
  return &TSExecuteBatchStatementReq{}
}


func (p *TSExecuteBatchStatementReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSExecuteBatchStatementReq) GetStatements() []string {
  return p.Statements
}
func (p *TSExecuteBatchStatementReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetStatements bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetStatements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetStatements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statements is not set"));
  }
  return nil
}

func (p *TSExecuteBatchStatementReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSExecuteBatchStatementReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Statements =  tSlice
  for i := 0; i < size; i ++ {
var _elem31 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem31 = v
}
    p.Statements = append(p.Statements, _elem31)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSExecuteBatchStatementReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSExecuteBatchStatementReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSExecuteBatchStatementReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSExecuteBatchStatementReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statements", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Statements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Statements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statements: ", p), err) }
  return err
}

func (p *TSExecuteBatchStatementReq) Equals(other *TSExecuteBatchStatementReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Statements) != len(other.Statements) { return false }
  for i, _tgt := range p.Statements {
    _src32 := other.Statements[i]
    if _tgt != _src32 { return false }
  }
  return true
}

func (p *TSExecuteBatchStatementReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSExecuteBatchStatementReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
type TSGetOperationStatusReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  QueryId int64 `thrift:"queryId,2,required" db:"queryId" json:"queryId"`
}

func NewTSGetOperationStatusReq() *TSGetOperationStatusReq {
  return &TSGetOperationStatusReq{}
}


func (p *TSGetOperationStatusReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSGetOperationStatusReq) GetQueryId() int64 {
  return p.QueryId
}
func (p *TSGetOperationStatusReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetQueryId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  return nil
}

func (p *TSGetOperationStatusReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSGetOperationStatusReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryId = v
}
  return nil
}

func (p *TSGetOperationStatusReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSGetOperationStatusReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSGetOperationStatusReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSGetOperationStatusReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
  return err
}

func (p *TSGetOperationStatusReq) Equals(other *TSGetOperationStatusReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.QueryId != other.QueryId { return false }
  return true
}

func (p *TSGetOperationStatusReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSGetOperationStatusReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
type TSCancelOperationReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  QueryId int64 `thrift:"queryId,2,required" db:"queryId" json:"queryId"`
}

func NewTSCancelOperationReq() *TSCancelOperationReq {
  return &TSCancelOperationReq{}
}


func (p *TSCancelOperationReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCancelOperationReq) GetQueryId() int64 {
  return p.QueryId
}
func (p *TSCancelOperationReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetQueryId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  return nil
}

func (p *TSCancelOperationReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCancelOperationReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryId = v
}
  return nil
}

func (p *TSCancelOperationReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCancelOperationReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCancelOperationReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCancelOperationReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
  return err
}

func (p *TSCancelOperationReq) Equals(other *TSCancelOperationReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.QueryId != other.QueryId { return false }
  return true
}

func (p *TSCancelOperationReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCancelOperationReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - QueryId
//  - StatementId
type TSCloseOperationReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  QueryId *int64 `thrift:"queryId,2" db:"queryId" json:"queryId,omitempty"`
  StatementId *int64 `thrift:"statementId,3" db:"statementId" json:"statementId,omitempty"`
}

func NewTSCloseOperationReq() *TSCloseOperationReq {
  return &TSCloseOperationReq{}
}


func (p *TSCloseOperationReq) GetSessionId() int64 {
  return p.SessionId
}
var TSCloseOperationReq_QueryId_DEFAULT int64
func (p *TSCloseOperationReq) GetQueryId() int64 {
  if !p.IsSetQueryId() {
    return TSCloseOperationReq_QueryId_DEFAULT
  }
return *p.QueryId
}
var TSCloseOperationReq_StatementId_DEFAULT int64
func (p *TSCloseOperationReq) GetStatementId() int64 {
  if !p.IsSetStatementId() {
    return TSCloseOperationReq_StatementId_DEFAULT
  }
return *p.StatementId
}
func (p *TSCloseOperationReq) IsSetQueryId() bool {
  return p.QueryId != nil
}

func (p *TSCloseOperationReq) IsSetStatementId() bool {
  return p.StatementId != nil
}

func (p *TSCloseOperationReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  return nil
}

func (p *TSCloseOperationReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCloseOperationReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryId = &v
}
  return nil
}

func (p *TSCloseOperationReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.StatementId = &v
}
  return nil
}

func (p *TSCloseOperationReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCloseOperationReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCloseOperationReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCloseOperationReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryId() {
    if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.QueryId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.queryId (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryId: ", p), err) }
  }
  return err
}

func (p *TSCloseOperationReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetStatementId() {
    if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:statementId: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.StatementId)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.statementId (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:statementId: ", p), err) }
  }
  return err
}

func (p *TSCloseOperationReq) Equals(other *TSCloseOperationReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.QueryId != other.QueryId {
    if p.QueryId == nil || other.QueryId == nil {
      return false
    }
    if (*p.QueryId) != (*other.QueryId) { return false }
  }
  if p.StatementId != other.StatementId {
    if p.StatementId == nil || other.StatementId == nil {
      return false
    }
    if (*p.StatementId) != (*other.StatementId) { return false }
  }
  return true
}

func (p *TSCloseOperationReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCloseOperationReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Statement
//  - FetchSize
//  - QueryId
//  - IsAlign
//  - Timeout
type TSFetchResultsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Statement string `thrift:"statement,2,required" db:"statement" json:"statement"`
  FetchSize int32 `thrift:"fetchSize,3,required" db:"fetchSize" json:"fetchSize"`
  QueryId int64 `thrift:"queryId,4,required" db:"queryId" json:"queryId"`
  IsAlign bool `thrift:"isAlign,5,required" db:"isAlign" json:"isAlign"`
  Timeout *int64 `thrift:"timeout,6" db:"timeout" json:"timeout,omitempty"`
}

func NewTSFetchResultsReq() *TSFetchResultsReq {
  return &TSFetchResultsReq{}
}


func (p *TSFetchResultsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSFetchResultsReq) GetStatement() string {
  return p.Statement
}

func (p *TSFetchResultsReq) GetFetchSize() int32 {
  return p.FetchSize
}

func (p *TSFetchResultsReq) GetQueryId() int64 {
  return p.QueryId
}

func (p *TSFetchResultsReq) GetIsAlign() bool {
  return p.IsAlign
}
var TSFetchResultsReq_Timeout_DEFAULT int64
func (p *TSFetchResultsReq) GetTimeout() int64 {
  if !p.IsSetTimeout() {
    return TSFetchResultsReq_Timeout_DEFAULT
  }
return *p.Timeout
}
func (p *TSFetchResultsReq) IsSetTimeout() bool {
  return p.Timeout != nil
}

func (p *TSFetchResultsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetStatement bool = false;
  var issetFetchSize bool = false;
  var issetQueryId bool = false;
  var issetIsAlign bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetStatement = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetFetchSize = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetQueryId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetIsAlign = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetStatement{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Statement is not set"));
  }
  if !issetFetchSize{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FetchSize is not set"));
  }
  if !issetQueryId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryId is not set"));
  }
  if !issetIsAlign{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAlign is not set"));
  }
  return nil
}

func (p *TSFetchResultsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Statement = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.FetchSize = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.QueryId = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.IsAlign = v
}
  return nil
}

func (p *TSFetchResultsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.Timeout = &v
}
  return nil
}

func (p *TSFetchResultsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSFetchResultsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSFetchResultsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statement", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statement: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Statement)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statement (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statement: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:fetchSize: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.FetchSize)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.fetchSize (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:fetchSize: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryId", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.QueryId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryId (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryId: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "isAlign", thrift.BOOL, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:isAlign: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.IsAlign)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.isAlign (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:isAlign: ", p), err) }
  return err
}

func (p *TSFetchResultsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeout() {
    if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:timeout: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeout (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:timeout: ", p), err) }
  }
  return err
}

func (p *TSFetchResultsReq) Equals(other *TSFetchResultsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Statement != other.Statement { return false }
  if p.FetchSize != other.FetchSize { return false }
  if p.QueryId != other.QueryId { return false }
  if p.IsAlign != other.IsAlign { return false }
  if p.Timeout != other.Timeout {
    if p.Timeout == nil || other.Timeout == nil {
      return false
    }
    if (*p.Timeout) != (*other.Timeout) { return false }
  }
  return true
}

func (p *TSFetchResultsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSFetchResultsReq(%+v)", *p)
}

// Attributes:
//  - Status
//  - HasResultSet
//  - IsAlign
//  - QueryDataSet
//  - NonAlignQueryDataSet
//  - QueryResult_
//  - MoreData
type TSFetchResultsResp struct {
  Status *common.TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  HasResultSet bool `thrift:"hasResultSet,2,required" db:"hasResultSet" json:"hasResultSet"`
  IsAlign bool `thrift:"isAlign,3,required" db:"isAlign" json:"isAlign"`
  QueryDataSet *TSQueryDataSet `thrift:"queryDataSet,4" db:"queryDataSet" json:"queryDataSet,omitempty"`
  NonAlignQueryDataSet *TSQueryNonAlignDataSet `thrift:"nonAlignQueryDataSet,5" db:"nonAlignQueryDataSet" json:"nonAlignQueryDataSet,omitempty"`
  QueryResult_ [][]byte `thrift:"queryResult,6" db:"queryResult" json:"queryResult,omitempty"`
  MoreData *bool `thrift:"moreData,7" db:"moreData" json:"moreData,omitempty"`
}

func NewTSFetchResultsResp() *TSFetchResultsResp {
  return &TSFetchResultsResp{}
}

var TSFetchResultsResp_Status_DEFAULT *common.TSStatus
func (p *TSFetchResultsResp) GetStatus() *common.TSStatus {
  if !p.IsSetStatus() {
    return TSFetchResultsResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSFetchResultsResp) GetHasResultSet() bool {
  return p.HasResultSet
}

func (p *TSFetchResultsResp) GetIsAlign() bool {
  return p.IsAlign
}
var TSFetchResultsResp_QueryDataSet_DEFAULT *TSQueryDataSet
func (p *TSFetchResultsResp) GetQueryDataSet() *TSQueryDataSet {
  if !p.IsSetQueryDataSet() {
    return TSFetchResultsResp_QueryDataSet_DEFAULT
  }
return p.QueryDataSet
}
var TSFetchResultsResp_NonAlignQueryDataSet_DEFAULT *TSQueryNonAlignDataSet
func (p *TSFetchResultsResp) GetNonAlignQueryDataSet() *TSQueryNonAlignDataSet {
  if !p.IsSetNonAlignQueryDataSet() {
    return TSFetchResultsResp_NonAlignQueryDataSet_DEFAULT
  }
return p.NonAlignQueryDataSet
}
var TSFetchResultsResp_QueryResult__DEFAULT [][]byte

func (p *TSFetchResultsResp) GetQueryResult_() [][]byte {
  return p.QueryResult_
}
var TSFetchResultsResp_MoreData_DEFAULT bool
func (p *TSFetchResultsResp) GetMoreData() bool {
  if !p.IsSetMoreData() {
    return TSFetchResultsResp_MoreData_DEFAULT
  }
return *p.MoreData
}
func (p *TSFetchResultsResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSFetchResultsResp) IsSetQueryDataSet() bool {
  return p.QueryDataSet != nil
}

func (p *TSFetchResultsResp) IsSetNonAlignQueryDataSet() bool {
  return p.NonAlignQueryDataSet != nil
}

func (p *TSFetchResultsResp) IsSetQueryResult_() bool {
  return p.QueryResult_ != nil
}

func (p *TSFetchResultsResp) IsSetMoreData() bool {
  return p.MoreData != nil
}

func (p *TSFetchResultsResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetHasResultSet bool = false;
  var issetIsAlign bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetHasResultSet = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetIsAlign = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetHasResultSet{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field HasResultSet is not set"));
  }
  if !issetIsAlign{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAlign is not set"));
  }
  return nil
}

func (p *TSFetchResultsResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &common.TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSFetchResultsResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.HasResultSet = v
}
  return nil
}

func (p *TSFetchResultsResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.IsAlign = v
}
  return nil
}

func (p *TSFetchResultsResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  p.QueryDataSet = &TSQueryDataSet{}
  if err := p.QueryDataSet.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.QueryDataSet), err)
  }
  return nil
}

func (p *TSFetchResultsResp)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  p.NonAlignQueryDataSet = &TSQueryNonAlignDataSet{}
  if err := p.NonAlignQueryDataSet.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.NonAlignQueryDataSet), err)
  }
  return nil
}

func (p *TSFetchResultsResp)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.QueryResult_ =  tSlice
  for i := 0; i < size; i ++ {
var _elem33 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem33 = v
}
    p.QueryResult_ = append(p.QueryResult_, _elem33)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSFetchResultsResp)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.MoreData = &v
}
  return nil
}

func (p *TSFetchResultsResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSFetchResultsResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSFetchResultsResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSFetchResultsResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "hasResultSet", thrift.BOOL, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:hasResultSet: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.HasResultSet)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.hasResultSet (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:hasResultSet: ", p), err) }
  return err
}

func (p *TSFetchResultsResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "isAlign", thrift.BOOL, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:isAlign: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.IsAlign)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.isAlign (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:isAlign: ", p), err) }
  return err
}

func (p *TSFetchResultsResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryDataSet() {
    if err := oprot.WriteFieldBegin(ctx, "queryDataSet", thrift.STRUCT, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:queryDataSet: ", p), err) }
    if err := p.QueryDataSet.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.QueryDataSet), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:queryDataSet: ", p), err) }
  }
  return err
}

func (p *TSFetchResultsResp) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetNonAlignQueryDataSet() {
    if err := oprot.WriteFieldBegin(ctx, "nonAlignQueryDataSet", thrift.STRUCT, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:nonAlignQueryDataSet: ", p), err) }
    if err := p.NonAlignQueryDataSet.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.NonAlignQueryDataSet), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:nonAlignQueryDataSet: ", p), err) }
  }
  return err
}

func (p *TSFetchResultsResp) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetQueryResult_() {
    if err := oprot.WriteFieldBegin(ctx, "queryResult", thrift.LIST, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:queryResult: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.QueryResult_)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.QueryResult_ {
      if err := oprot.WriteBinary(ctx, v); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:queryResult: ", p), err) }
  }
  return err
}

func (p *TSFetchResultsResp) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMoreData() {
    if err := oprot.WriteFieldBegin(ctx, "moreData", thrift.BOOL, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:moreData: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.MoreData)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.moreData (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:moreData: ", p), err) }
  }
  return err
}

func (p *TSFetchResultsResp) Equals(other *TSFetchResultsResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.HasResultSet != other.HasResultSet { return false }
  if p.IsAlign != other.IsAlign { return false }
  if !p.QueryDataSet.Equals(other.QueryDataSet) { return false }
  if !p.NonAlignQueryDataSet.Equals(other.NonAlignQueryDataSet) { return false }
  if len(p.QueryResult_) != len(other.QueryResult_) { return false }
  for i, _tgt := range p.QueryResult_ {
    _src34 := other.QueryResult_[i]
    if bytes.Compare(_tgt, _src34) != 0 { return false }
  }
  if p.MoreData != other.MoreData {
    if p.MoreData == nil || other.MoreData == nil {
      return false
    }
    if (*p.MoreData) != (*other.MoreData) { return false }
  }
  return true
}

func (p *TSFetchResultsResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSFetchResultsResp(%+v)", *p)
}

// Attributes:
//  - Status
//  - MetadataInJson
//  - ColumnsList
//  - DataType
type TSFetchMetadataResp struct {
  Status *common.TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  MetadataInJson *string `thrift:"metadataInJson,2" db:"metadataInJson" json:"metadataInJson,omitempty"`
  ColumnsList []string `thrift:"columnsList,3" db:"columnsList" json:"columnsList,omitempty"`
  DataType *string `thrift:"dataType,4" db:"dataType" json:"dataType,omitempty"`
}

func NewTSFetchMetadataResp() *TSFetchMetadataResp {
  return &TSFetchMetadataResp{}
}

var TSFetchMetadataResp_Status_DEFAULT *common.TSStatus
func (p *TSFetchMetadataResp) GetStatus() *common.TSStatus {
  if !p.IsSetStatus() {
    return TSFetchMetadataResp_Status_DEFAULT
  }
return p.Status
}
var TSFetchMetadataResp_MetadataInJson_DEFAULT string
func (p *TSFetchMetadataResp) GetMetadataInJson() string {
  if !p.IsSetMetadataInJson() {
    return TSFetchMetadataResp_MetadataInJson_DEFAULT
  }
return *p.MetadataInJson
}
var TSFetchMetadataResp_ColumnsList_DEFAULT []string

func (p *TSFetchMetadataResp) GetColumnsList() []string {
  return p.ColumnsList
}
var TSFetchMetadataResp_DataType_DEFAULT string
func (p *TSFetchMetadataResp) GetDataType() string {
  if !p.IsSetDataType() {
    return TSFetchMetadataResp_DataType_DEFAULT
  }
return *p.DataType
}
func (p *TSFetchMetadataResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSFetchMetadataResp) IsSetMetadataInJson() bool {
  return p.MetadataInJson != nil
}

func (p *TSFetchMetadataResp) IsSetColumnsList() bool {
  return p.ColumnsList != nil
}

func (p *TSFetchMetadataResp) IsSetDataType() bool {
  return p.DataType != nil
}

func (p *TSFetchMetadataResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  return nil
}

func (p *TSFetchMetadataResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &common.TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSFetchMetadataResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.MetadataInJson = &v
}
  return nil
}

func (p *TSFetchMetadataResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.ColumnsList =  tSlice
  for i := 0; i < size; i ++ {
var _elem35 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem35 = v
}
    p.ColumnsList = append(p.ColumnsList, _elem35)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSFetchMetadataResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.DataType = &v
}
  return nil
}

func (p *TSFetchMetadataResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSFetchMetadataResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSFetchMetadataResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSFetchMetadataResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMetadataInJson() {
    if err := oprot.WriteFieldBegin(ctx, "metadataInJson", thrift.STRING, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:metadataInJson: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.MetadataInJson)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.metadataInJson (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:metadataInJson: ", p), err) }
  }
  return err
}

func (p *TSFetchMetadataResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetColumnsList() {
    if err := oprot.WriteFieldBegin(ctx, "columnsList", thrift.LIST, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columnsList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ColumnsList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.ColumnsList {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columnsList: ", p), err) }
  }
  return err
}

func (p *TSFetchMetadataResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetDataType() {
    if err := oprot.WriteFieldBegin(ctx, "dataType", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:dataType: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.DataType)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.dataType (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:dataType: ", p), err) }
  }
  return err
}

func (p *TSFetchMetadataResp) Equals(other *TSFetchMetadataResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.MetadataInJson != other.MetadataInJson {
    if p.MetadataInJson == nil || other.MetadataInJson == nil {
      return false
    }
    if (*p.MetadataInJson) != (*other.MetadataInJson) { return false }
  }
  if len(p.ColumnsList) != len(other.ColumnsList) { return false }
  for i, _tgt := range p.ColumnsList {
    _src36 := other.ColumnsList[i]
    if _tgt != _src36 { return false }
  }
  if p.DataType != other.DataType {
    if p.DataType == nil || other.DataType == nil {
      return false
    }
    if (*p.DataType) != (*other.DataType) { return false }
  }
  return true
}

func (p *TSFetchMetadataResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSFetchMetadataResp(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Type
//  - ColumnPath
type TSFetchMetadataReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Type string `thrift:"type,2,required" db:"type" json:"type"`
  ColumnPath *string `thrift:"columnPath,3" db:"columnPath" json:"columnPath,omitempty"`
}

func NewTSFetchMetadataReq() *TSFetchMetadataReq {
  return &TSFetchMetadataReq{}
}


func (p *TSFetchMetadataReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSFetchMetadataReq) GetType() string {
  return p.Type
}
var TSFetchMetadataReq_ColumnPath_DEFAULT string
func (p *TSFetchMetadataReq) GetColumnPath() string {
  if !p.IsSetColumnPath() {
    return TSFetchMetadataReq_ColumnPath_DEFAULT
  }
return *p.ColumnPath
}
func (p *TSFetchMetadataReq) IsSetColumnPath() bool {
  return p.ColumnPath != nil
}

func (p *TSFetchMetadataReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetType bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Type is not set"));
  }
  return nil
}

func (p *TSFetchMetadataReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSFetchMetadataReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Type = v
}
  return nil
}

func (p *TSFetchMetadataReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.ColumnPath = &v
}
  return nil
}

func (p *TSFetchMetadataReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSFetchMetadataReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSFetchMetadataReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSFetchMetadataReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "type", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:type: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Type)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.type (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:type: ", p), err) }
  return err
}

func (p *TSFetchMetadataReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetColumnPath() {
    if err := oprot.WriteFieldBegin(ctx, "columnPath", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:columnPath: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.ColumnPath)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.columnPath (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:columnPath: ", p), err) }
  }
  return err
}

func (p *TSFetchMetadataReq) Equals(other *TSFetchMetadataReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Type != other.Type { return false }
  if p.ColumnPath != other.ColumnPath {
    if p.ColumnPath == nil || other.ColumnPath == nil {
      return false
    }
    if (*p.ColumnPath) != (*other.ColumnPath) { return false }
  }
  return true
}

func (p *TSFetchMetadataReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSFetchMetadataReq(%+v)", *p)
}

// Attributes:
//  - Status
//  - TimeZone
type TSGetTimeZoneResp struct {
  Status *common.TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  TimeZone string `thrift:"timeZone,2,required" db:"timeZone" json:"timeZone"`
}

func NewTSGetTimeZoneResp() *TSGetTimeZoneResp {
  return &TSGetTimeZoneResp{}
}

var TSGetTimeZoneResp_Status_DEFAULT *common.TSStatus
func (p *TSGetTimeZoneResp) GetStatus() *common.TSStatus {
  if !p.IsSetStatus() {
    return TSGetTimeZoneResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSGetTimeZoneResp) GetTimeZone() string {
  return p.TimeZone
}
func (p *TSGetTimeZoneResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSGetTimeZoneResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetTimeZone bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetTimeZone = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetTimeZone{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeZone is not set"));
  }
  return nil
}

func (p *TSGetTimeZoneResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &common.TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSGetTimeZoneResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TimeZone = v
}
  return nil
}

func (p *TSGetTimeZoneResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSGetTimeZoneResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSGetTimeZoneResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSGetTimeZoneResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timeZone", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeZone: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TimeZone)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timeZone (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeZone: ", p), err) }
  return err
}

func (p *TSGetTimeZoneResp) Equals(other *TSGetTimeZoneResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.TimeZone != other.TimeZone { return false }
  return true
}

func (p *TSGetTimeZoneResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSGetTimeZoneResp(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - TimeZone
type TSSetTimeZoneReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  TimeZone string `thrift:"timeZone,2,required" db:"timeZone" json:"timeZone"`
}

func NewTSSetTimeZoneReq() *TSSetTimeZoneReq {
  return &TSSetTimeZoneReq{}
}


func (p *TSSetTimeZoneReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSSetTimeZoneReq) GetTimeZone() string {
  return p.TimeZone
}
func (p *TSSetTimeZoneReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetTimeZone bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetTimeZone = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetTimeZone{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimeZone is not set"));
  }
  return nil
}

func (p *TSSetTimeZoneReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSSetTimeZoneReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TimeZone = v
}
  return nil
}

func (p *TSSetTimeZoneReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSSetTimeZoneReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSSetTimeZoneReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSSetTimeZoneReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timeZone", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:timeZone: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TimeZone)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timeZone (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:timeZone: ", p), err) }
  return err
}

func (p *TSSetTimeZoneReq) Equals(other *TSSetTimeZoneReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.TimeZone != other.TimeZone { return false }
  return true
}

func (p *TSSetTimeZoneReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSSetTimeZoneReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - Measurements
//  - Values
//  - Timestamp
//  - IsAligned
type TSInsertRecordReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
  Values []byte `thrift:"values,4,required" db:"values" json:"values"`
  Timestamp int64 `thrift:"timestamp,5,required" db:"timestamp" json:"timestamp"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertRecordReq() *TSInsertRecordReq {
  return &TSInsertRecordReq{}
}


func (p *TSInsertRecordReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertRecordReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertRecordReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSInsertRecordReq) GetValues() []byte {
  return p.Values
}

func (p *TSInsertRecordReq) GetTimestamp() int64 {
  return p.Timestamp
}
var TSInsertRecordReq_IsAligned_DEFAULT bool
func (p *TSInsertRecordReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertRecordReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertRecordReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertRecordReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurements bool = false;
  var issetValues bool = false;
  var issetTimestamp bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValues = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamp = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetValues{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
  }
  if !issetTimestamp{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamp is not set"));
  }
  return nil
}

func (p *TSInsertRecordReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertRecordReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertRecordReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem37 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem37 = v
}
    p.Measurements = append(p.Measurements, _elem37)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Values = v
}
  return nil
}

func (p *TSInsertRecordReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Timestamp = v
}
  return nil
}

func (p *TSInsertRecordReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertRecordReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertRecordReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertRecordReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "values", thrift.STRING, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Values); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.values (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamp", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamp: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Timestamp)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timestamp (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamp: ", p), err) }
  return err
}

func (p *TSInsertRecordReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertRecordReq) Equals(other *TSInsertRecordReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src38 := other.Measurements[i]
    if _tgt != _src38 { return false }
  }
  if bytes.Compare(p.Values, other.Values) != 0 { return false }
  if p.Timestamp != other.Timestamp { return false }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertRecordReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertRecordReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - Measurements
//  - Values
//  - Timestamp
//  - IsAligned
//  - Timeout
type TSInsertStringRecordReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
  Values []string `thrift:"values,4,required" db:"values" json:"values"`
  Timestamp int64 `thrift:"timestamp,5,required" db:"timestamp" json:"timestamp"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
  Timeout *int64 `thrift:"timeout,7" db:"timeout" json:"timeout,omitempty"`
}

func NewTSInsertStringRecordReq() *TSInsertStringRecordReq {
  return &TSInsertStringRecordReq{}
}


func (p *TSInsertStringRecordReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertStringRecordReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertStringRecordReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSInsertStringRecordReq) GetValues() []string {
  return p.Values
}

func (p *TSInsertStringRecordReq) GetTimestamp() int64 {
  return p.Timestamp
}
var TSInsertStringRecordReq_IsAligned_DEFAULT bool
func (p *TSInsertStringRecordReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertStringRecordReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
var TSInsertStringRecordReq_Timeout_DEFAULT int64
func (p *TSInsertStringRecordReq) GetTimeout() int64 {
  if !p.IsSetTimeout() {
    return TSInsertStringRecordReq_Timeout_DEFAULT
  }
return *p.Timeout
}
func (p *TSInsertStringRecordReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertStringRecordReq) IsSetTimeout() bool {
  return p.Timeout != nil
}

func (p *TSInsertStringRecordReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurements bool = false;
  var issetValues bool = false;
  var issetTimestamp bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValues = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamp = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetValues{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
  }
  if !issetTimestamp{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamp is not set"));
  }
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem39 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem39 = v
}
    p.Measurements = append(p.Measurements, _elem39)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Values =  tSlice
  for i := 0; i < size; i ++ {
var _elem40 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem40 = v
}
    p.Values = append(p.Values, _elem40)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Timestamp = v
}
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertStringRecordReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.Timeout = &v
}
  return nil
}

func (p *TSInsertStringRecordReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertStringRecordReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertStringRecordReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "values", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Values)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Values {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamp", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamp: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Timestamp)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timestamp (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamp: ", p), err) }
  return err
}

func (p *TSInsertStringRecordReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertStringRecordReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeout() {
    if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:timeout: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeout (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:timeout: ", p), err) }
  }
  return err
}

func (p *TSInsertStringRecordReq) Equals(other *TSInsertStringRecordReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src41 := other.Measurements[i]
    if _tgt != _src41 { return false }
  }
  if len(p.Values) != len(other.Values) { return false }
  for i, _tgt := range p.Values {
    _src42 := other.Values[i]
    if _tgt != _src42 { return false }
  }
  if p.Timestamp != other.Timestamp { return false }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  if p.Timeout != other.Timeout {
    if p.Timeout == nil || other.Timeout == nil {
      return false
    }
    if (*p.Timeout) != (*other.Timeout) { return false }
  }
  return true
}

func (p *TSInsertStringRecordReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertStringRecordReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - Measurements
//  - Values
//  - Timestamps
//  - Types
//  - Size
//  - IsAligned
type TSInsertTabletReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
  Values []byte `thrift:"values,4,required" db:"values" json:"values"`
  Timestamps []byte `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  Types []int32 `thrift:"types,6,required" db:"types" json:"types"`
  Size int32 `thrift:"size,7,required" db:"size" json:"size"`
  IsAligned *bool `thrift:"isAligned,8" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertTabletReq() *TSInsertTabletReq {
  return &TSInsertTabletReq{}
}


func (p *TSInsertTabletReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertTabletReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertTabletReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSInsertTabletReq) GetValues() []byte {
  return p.Values
}

func (p *TSInsertTabletReq) GetTimestamps() []byte {
  return p.Timestamps
}

func (p *TSInsertTabletReq) GetTypes() []int32 {
  return p.Types
}

func (p *TSInsertTabletReq) GetSize() int32 {
  return p.Size
}
var TSInsertTabletReq_IsAligned_DEFAULT bool
func (p *TSInsertTabletReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertTabletReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertTabletReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertTabletReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurements bool = false;
  var issetValues bool = false;
  var issetTimestamps bool = false;
  var issetTypes bool = false;
  var issetSize bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValues = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetSize = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetValues{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Values is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  if !issetTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Types is not set"));
  }
  if !issetSize{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Size is not set"));
  }
  return nil
}

func (p *TSInsertTabletReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem43 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem43 = v
}
    p.Measurements = append(p.Measurements, _elem43)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Values = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Timestamps = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Types =  tSlice
  for i := 0; i < size; i ++ {
var _elem44 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem44 = v
}
    p.Types = append(p.Types, _elem44)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.Size = v
}
  return nil
}

func (p *TSInsertTabletReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertTabletReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertTabletReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertTabletReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "values", thrift.STRING, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:values: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Values); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.values (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:values: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.STRING, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.Timestamps); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timestamps (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "types", thrift.LIST, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:types: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Types)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Types {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:types: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "size", thrift.I32, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:size: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Size)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.size (7) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:size: ", p), err) }
  return err
}

func (p *TSInsertTabletReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertTabletReq) Equals(other *TSInsertTabletReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src45 := other.Measurements[i]
    if _tgt != _src45 { return false }
  }
  if bytes.Compare(p.Values, other.Values) != 0 { return false }
  if bytes.Compare(p.Timestamps, other.Timestamps) != 0 { return false }
  if len(p.Types) != len(other.Types) { return false }
  for i, _tgt := range p.Types {
    _src46 := other.Types[i]
    if _tgt != _src46 { return false }
  }
  if p.Size != other.Size { return false }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertTabletReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertTabletReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPaths
//  - MeasurementsList
//  - ValuesList
//  - TimestampsList
//  - TypesList
//  - SizeList
//  - IsAligned
type TSInsertTabletsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPaths []string `thrift:"prefixPaths,2,required" db:"prefixPaths" json:"prefixPaths"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  TimestampsList [][]byte `thrift:"timestampsList,5,required" db:"timestampsList" json:"timestampsList"`
  TypesList [][]int32 `thrift:"typesList,6,required" db:"typesList" json:"typesList"`
  SizeList []int32 `thrift:"sizeList,7,required" db:"sizeList" json:"sizeList"`
  IsAligned *bool `thrift:"isAligned,8" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertTabletsReq() *TSInsertTabletsReq {
  return &TSInsertTabletsReq{}
}


func (p *TSInsertTabletsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertTabletsReq) GetPrefixPaths() []string {
  return p.PrefixPaths
}

func (p *TSInsertTabletsReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertTabletsReq) GetValuesList() [][]byte {
  return p.ValuesList
}

func (p *TSInsertTabletsReq) GetTimestampsList() [][]byte {
  return p.TimestampsList
}

func (p *TSInsertTabletsReq) GetTypesList() [][]int32 {
  return p.TypesList
}

func (p *TSInsertTabletsReq) GetSizeList() []int32 {
  return p.SizeList
}
var TSInsertTabletsReq_IsAligned_DEFAULT bool
func (p *TSInsertTabletsReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertTabletsReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertTabletsReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertTabletsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPaths bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestampsList bool = false;
  var issetTypesList bool = false;
  var issetSizeList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestampsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetTypesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetSizeList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPaths is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestampsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimestampsList is not set"));
  }
  if !issetTypesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TypesList is not set"));
  }
  if !issetSizeList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SizeList is not set"));
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertTabletsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PrefixPaths =  tSlice
  for i := 0; i < size; i ++ {
var _elem47 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem47 = v
}
    p.PrefixPaths = append(p.PrefixPaths, _elem47)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem48 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem49 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem49 = v
}
      _elem48 = append(_elem48, _elem49)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem48)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
var _elem50 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem50 = v
}
    p.ValuesList = append(p.ValuesList, _elem50)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.TimestampsList =  tSlice
  for i := 0; i < size; i ++ {
var _elem51 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem51 = v
}
    p.TimestampsList = append(p.TimestampsList, _elem51)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]int32, 0, size)
  p.TypesList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]int32, 0, size)
    _elem52 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem53 int32
      if v, err := iprot.ReadI32(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem53 = v
}
      _elem52 = append(_elem52, _elem53)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.TypesList = append(p.TypesList, _elem52)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.SizeList =  tSlice
  for i := 0; i < size; i ++ {
var _elem54 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem54 = v
}
    p.SizeList = append(p.SizeList, _elem54)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertTabletsReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertTabletsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertTabletsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertTabletsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPaths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPaths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PrefixPaths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PrefixPaths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPaths: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestampsList", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestampsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.TimestampsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.TimestampsList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestampsList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "typesList", thrift.LIST, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:typesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.TypesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.TypesList {
    if err := oprot.WriteListBegin(ctx, thrift.I32, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteI32(ctx, int32(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:typesList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sizeList", thrift.LIST, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:sizeList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.SizeList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.SizeList {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:sizeList: ", p), err) }
  return err
}

func (p *TSInsertTabletsReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertTabletsReq) Equals(other *TSInsertTabletsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.PrefixPaths) != len(other.PrefixPaths) { return false }
  for i, _tgt := range p.PrefixPaths {
    _src55 := other.PrefixPaths[i]
    if _tgt != _src55 { return false }
  }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src56 := other.MeasurementsList[i]
    if len(_tgt) != len(_src56) { return false }
    for i, _tgt := range _tgt {
      _src57 := _src56[i]
      if _tgt != _src57 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src58 := other.ValuesList[i]
    if bytes.Compare(_tgt, _src58) != 0 { return false }
  }
  if len(p.TimestampsList) != len(other.TimestampsList) { return false }
  for i, _tgt := range p.TimestampsList {
    _src59 := other.TimestampsList[i]
    if bytes.Compare(_tgt, _src59) != 0 { return false }
  }
  if len(p.TypesList) != len(other.TypesList) { return false }
  for i, _tgt := range p.TypesList {
    _src60 := other.TypesList[i]
    if len(_tgt) != len(_src60) { return false }
    for i, _tgt := range _tgt {
      _src61 := _src60[i]
      if _tgt != _src61 { return false }
    }
  }
  if len(p.SizeList) != len(other.SizeList) { return false }
  for i, _tgt := range p.SizeList {
    _src62 := other.SizeList[i]
    if _tgt != _src62 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertTabletsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertTabletsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPaths
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
//  - IsAligned
type TSInsertRecordsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPaths []string `thrift:"prefixPaths,2,required" db:"prefixPaths" json:"prefixPaths"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertRecordsReq() *TSInsertRecordsReq {
  return &TSInsertRecordsReq{}
}


func (p *TSInsertRecordsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertRecordsReq) GetPrefixPaths() []string {
  return p.PrefixPaths
}

func (p *TSInsertRecordsReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertRecordsReq) GetValuesList() [][]byte {
  return p.ValuesList
}

func (p *TSInsertRecordsReq) GetTimestamps() []int64 {
  return p.Timestamps
}
var TSInsertRecordsReq_IsAligned_DEFAULT bool
func (p *TSInsertRecordsReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertRecordsReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertRecordsReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertRecordsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPaths bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestamps bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPaths is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertRecordsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PrefixPaths =  tSlice
  for i := 0; i < size; i ++ {
var _elem63 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem63 = v
}
    p.PrefixPaths = append(p.PrefixPaths, _elem63)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem64 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem65 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem65 = v
}
      _elem64 = append(_elem64, _elem65)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem64)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
var _elem66 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem66 = v
}
    p.ValuesList = append(p.ValuesList, _elem66)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem67 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem67 = v
}
    p.Timestamps = append(p.Timestamps, _elem67)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertRecordsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertRecordsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertRecordsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPaths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPaths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PrefixPaths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PrefixPaths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPaths: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertRecordsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertRecordsReq) Equals(other *TSInsertRecordsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.PrefixPaths) != len(other.PrefixPaths) { return false }
  for i, _tgt := range p.PrefixPaths {
    _src68 := other.PrefixPaths[i]
    if _tgt != _src68 { return false }
  }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src69 := other.MeasurementsList[i]
    if len(_tgt) != len(_src69) { return false }
    for i, _tgt := range _tgt {
      _src70 := _src69[i]
      if _tgt != _src70 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src71 := other.ValuesList[i]
    if bytes.Compare(_tgt, _src71) != 0 { return false }
  }
  if len(p.Timestamps) != len(other.Timestamps) { return false }
  for i, _tgt := range p.Timestamps {
    _src72 := other.Timestamps[i]
    if _tgt != _src72 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertRecordsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertRecordsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
//  - IsAligned
type TSInsertRecordsOfOneDeviceReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]byte `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertRecordsOfOneDeviceReq() *TSInsertRecordsOfOneDeviceReq {
  return &TSInsertRecordsOfOneDeviceReq{}
}


func (p *TSInsertRecordsOfOneDeviceReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertRecordsOfOneDeviceReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertRecordsOfOneDeviceReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertRecordsOfOneDeviceReq) GetValuesList() [][]byte {
  return p.ValuesList
}

func (p *TSInsertRecordsOfOneDeviceReq) GetTimestamps() []int64 {
  return p.Timestamps
}
var TSInsertRecordsOfOneDeviceReq_IsAligned_DEFAULT bool
func (p *TSInsertRecordsOfOneDeviceReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertRecordsOfOneDeviceReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertRecordsOfOneDeviceReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertRecordsOfOneDeviceReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestamps bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem73 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem74 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem74 = v
}
      _elem73 = append(_elem73, _elem74)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem73)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]byte, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
var _elem75 []byte
    if v, err := iprot.ReadBinary(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem75 = v
}
    p.ValuesList = append(p.ValuesList, _elem75)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem76 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem76 = v
}
    p.Timestamps = append(p.Timestamps, _elem76)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertRecordsOfOneDeviceReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteBinary(ctx, v); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertRecordsOfOneDeviceReq) Equals(other *TSInsertRecordsOfOneDeviceReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src77 := other.MeasurementsList[i]
    if len(_tgt) != len(_src77) { return false }
    for i, _tgt := range _tgt {
      _src78 := _src77[i]
      if _tgt != _src78 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src79 := other.ValuesList[i]
    if bytes.Compare(_tgt, _src79) != 0 { return false }
  }
  if len(p.Timestamps) != len(other.Timestamps) { return false }
  for i, _tgt := range p.Timestamps {
    _src80 := other.Timestamps[i]
    if _tgt != _src80 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertRecordsOfOneDeviceReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertRecordsOfOneDeviceReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
//  - IsAligned
type TSInsertStringRecordsOfOneDeviceReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]string `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertStringRecordsOfOneDeviceReq() *TSInsertStringRecordsOfOneDeviceReq {
  return &TSInsertStringRecordsOfOneDeviceReq{}
}


func (p *TSInsertStringRecordsOfOneDeviceReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertStringRecordsOfOneDeviceReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSInsertStringRecordsOfOneDeviceReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertStringRecordsOfOneDeviceReq) GetValuesList() [][]string {
  return p.ValuesList
}

func (p *TSInsertStringRecordsOfOneDeviceReq) GetTimestamps() []int64 {
  return p.Timestamps
}
var TSInsertStringRecordsOfOneDeviceReq_IsAligned_DEFAULT bool
func (p *TSInsertStringRecordsOfOneDeviceReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertStringRecordsOfOneDeviceReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertStringRecordsOfOneDeviceReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestamps bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem81 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem82 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem82 = v
}
      _elem81 = append(_elem81, _elem82)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem81)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem83 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem84 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem84 = v
}
      _elem83 = append(_elem83, _elem84)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.ValuesList = append(p.ValuesList, _elem83)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem85 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem85 = v
}
    p.Timestamps = append(p.Timestamps, _elem85)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertStringRecordsOfOneDeviceReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertStringRecordsOfOneDeviceReq) Equals(other *TSInsertStringRecordsOfOneDeviceReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src86 := other.MeasurementsList[i]
    if len(_tgt) != len(_src86) { return false }
    for i, _tgt := range _tgt {
      _src87 := _src86[i]
      if _tgt != _src87 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src88 := other.ValuesList[i]
    if len(_tgt) != len(_src88) { return false }
    for i, _tgt := range _tgt {
      _src89 := _src88[i]
      if _tgt != _src89 { return false }
    }
  }
  if len(p.Timestamps) != len(other.Timestamps) { return false }
  for i, _tgt := range p.Timestamps {
    _src90 := other.Timestamps[i]
    if _tgt != _src90 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertStringRecordsOfOneDeviceReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertStringRecordsOfOneDeviceReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPaths
//  - MeasurementsList
//  - ValuesList
//  - Timestamps
//  - IsAligned
type TSInsertStringRecordsReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPaths []string `thrift:"prefixPaths,2,required" db:"prefixPaths" json:"prefixPaths"`
  MeasurementsList [][]string `thrift:"measurementsList,3,required" db:"measurementsList" json:"measurementsList"`
  ValuesList [][]string `thrift:"valuesList,4,required" db:"valuesList" json:"valuesList"`
  Timestamps []int64 `thrift:"timestamps,5,required" db:"timestamps" json:"timestamps"`
  IsAligned *bool `thrift:"isAligned,6" db:"isAligned" json:"isAligned,omitempty"`
}

func NewTSInsertStringRecordsReq() *TSInsertStringRecordsReq {
  return &TSInsertStringRecordsReq{}
}


func (p *TSInsertStringRecordsReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSInsertStringRecordsReq) GetPrefixPaths() []string {
  return p.PrefixPaths
}

func (p *TSInsertStringRecordsReq) GetMeasurementsList() [][]string {
  return p.MeasurementsList
}

func (p *TSInsertStringRecordsReq) GetValuesList() [][]string {
  return p.ValuesList
}

func (p *TSInsertStringRecordsReq) GetTimestamps() []int64 {
  return p.Timestamps
}
var TSInsertStringRecordsReq_IsAligned_DEFAULT bool
func (p *TSInsertStringRecordsReq) GetIsAligned() bool {
  if !p.IsSetIsAligned() {
    return TSInsertStringRecordsReq_IsAligned_DEFAULT
  }
return *p.IsAligned
}
func (p *TSInsertStringRecordsReq) IsSetIsAligned() bool {
  return p.IsAligned != nil
}

func (p *TSInsertStringRecordsReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPaths bool = false;
  var issetMeasurementsList bool = false;
  var issetValuesList bool = false;
  var issetTimestamps bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurementsList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetValuesList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetTimestamps = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPaths is not set"));
  }
  if !issetMeasurementsList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field MeasurementsList is not set"));
  }
  if !issetValuesList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ValuesList is not set"));
  }
  if !issetTimestamps{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Timestamps is not set"));
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.PrefixPaths =  tSlice
  for i := 0; i < size; i ++ {
var _elem91 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem91 = v
}
    p.PrefixPaths = append(p.PrefixPaths, _elem91)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.MeasurementsList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem92 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem93 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem93 = v
}
      _elem92 = append(_elem92, _elem93)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.MeasurementsList = append(p.MeasurementsList, _elem92)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([][]string, 0, size)
  p.ValuesList =  tSlice
  for i := 0; i < size; i ++ {
    _, size, err := iprot.ReadListBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading list begin: ", err)
    }
    tSlice := make([]string, 0, size)
    _elem94 :=  tSlice
    for i := 0; i < size; i ++ {
var _elem95 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _elem95 = v
}
      _elem94 = append(_elem94, _elem95)
    }
    if err := iprot.ReadListEnd(ctx); err != nil {
      return thrift.PrependError("error reading list end: ", err)
    }
    p.ValuesList = append(p.ValuesList, _elem94)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int64, 0, size)
  p.Timestamps =  tSlice
  for i := 0; i < size; i ++ {
var _elem96 int64
    if v, err := iprot.ReadI64(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem96 = v
}
    p.Timestamps = append(p.Timestamps, _elem96)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSInsertStringRecordsReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.IsAligned = &v
}
  return nil
}

func (p *TSInsertStringRecordsReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSInsertStringRecordsReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSInsertStringRecordsReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPaths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPaths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.PrefixPaths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.PrefixPaths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPaths: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurementsList", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurementsList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.MeasurementsList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.MeasurementsList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurementsList: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "valuesList", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:valuesList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.LIST, len(p.ValuesList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ValuesList {
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(v)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range v {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:valuesList: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestamps", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:timestamps: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I64, len(p.Timestamps)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Timestamps {
    if err := oprot.WriteI64(ctx, int64(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:timestamps: ", p), err) }
  return err
}

func (p *TSInsertStringRecordsReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsAligned() {
    if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:isAligned: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsAligned)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isAligned (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:isAligned: ", p), err) }
  }
  return err
}

func (p *TSInsertStringRecordsReq) Equals(other *TSInsertStringRecordsReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.PrefixPaths) != len(other.PrefixPaths) { return false }
  for i, _tgt := range p.PrefixPaths {
    _src97 := other.PrefixPaths[i]
    if _tgt != _src97 { return false }
  }
  if len(p.MeasurementsList) != len(other.MeasurementsList) { return false }
  for i, _tgt := range p.MeasurementsList {
    _src98 := other.MeasurementsList[i]
    if len(_tgt) != len(_src98) { return false }
    for i, _tgt := range _tgt {
      _src99 := _src98[i]
      if _tgt != _src99 { return false }
    }
  }
  if len(p.ValuesList) != len(other.ValuesList) { return false }
  for i, _tgt := range p.ValuesList {
    _src100 := other.ValuesList[i]
    if len(_tgt) != len(_src100) { return false }
    for i, _tgt := range _tgt {
      _src101 := _src100[i]
      if _tgt != _src101 { return false }
    }
  }
  if len(p.Timestamps) != len(other.Timestamps) { return false }
  for i, _tgt := range p.Timestamps {
    _src102 := other.Timestamps[i]
    if _tgt != _src102 { return false }
  }
  if p.IsAligned != other.IsAligned {
    if p.IsAligned == nil || other.IsAligned == nil {
      return false
    }
    if (*p.IsAligned) != (*other.IsAligned) { return false }
  }
  return true
}

func (p *TSInsertStringRecordsReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSInsertStringRecordsReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - StartTime
//  - EndTime
type TSDeleteDataReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
  StartTime int64 `thrift:"startTime,3,required" db:"startTime" json:"startTime"`
  EndTime int64 `thrift:"endTime,4,required" db:"endTime" json:"endTime"`
}

func NewTSDeleteDataReq() *TSDeleteDataReq {
  return &TSDeleteDataReq{}
}


func (p *TSDeleteDataReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSDeleteDataReq) GetPaths() []string {
  return p.Paths
}

func (p *TSDeleteDataReq) GetStartTime() int64 {
  return p.StartTime
}

func (p *TSDeleteDataReq) GetEndTime() int64 {
  return p.EndTime
}
func (p *TSDeleteDataReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPaths bool = false;
  var issetStartTime bool = false;
  var issetEndTime bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetStartTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetEndTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetStartTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StartTime is not set"));
  }
  if !issetEndTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EndTime is not set"));
  }
  return nil
}

func (p *TSDeleteDataReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSDeleteDataReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem103 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem103 = v
}
    p.Paths = append(p.Paths, _elem103)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSDeleteDataReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.StartTime = v
}
  return nil
}

func (p *TSDeleteDataReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.EndTime = v
}
  return nil
}

func (p *TSDeleteDataReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSDeleteDataReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDeleteDataReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSDeleteDataReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSDeleteDataReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:startTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startTime (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:startTime: ", p), err) }
  return err
}

func (p *TSDeleteDataReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:endTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.endTime (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:endTime: ", p), err) }
  return err
}

func (p *TSDeleteDataReq) Equals(other *TSDeleteDataReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src104 := other.Paths[i]
    if _tgt != _src104 { return false }
  }
  if p.StartTime != other.StartTime { return false }
  if p.EndTime != other.EndTime { return false }
  return true
}

func (p *TSDeleteDataReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDeleteDataReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Path
//  - DataType
//  - Encoding
//  - Compressor
//  - Props
//  - Tags
//  - Attributes
//  - MeasurementAlias
type TSCreateTimeseriesReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Path string `thrift:"path,2,required" db:"path" json:"path"`
  DataType int32 `thrift:"dataType,3,required" db:"dataType" json:"dataType"`
  Encoding int32 `thrift:"encoding,4,required" db:"encoding" json:"encoding"`
  Compressor int32 `thrift:"compressor,5,required" db:"compressor" json:"compressor"`
  Props map[string]string `thrift:"props,6" db:"props" json:"props,omitempty"`
  Tags map[string]string `thrift:"tags,7" db:"tags" json:"tags,omitempty"`
  Attributes map[string]string `thrift:"attributes,8" db:"attributes" json:"attributes,omitempty"`
  MeasurementAlias *string `thrift:"measurementAlias,9" db:"measurementAlias" json:"measurementAlias,omitempty"`
}

func NewTSCreateTimeseriesReq() *TSCreateTimeseriesReq {
  return &TSCreateTimeseriesReq{}
}


func (p *TSCreateTimeseriesReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateTimeseriesReq) GetPath() string {
  return p.Path
}

func (p *TSCreateTimeseriesReq) GetDataType() int32 {
  return p.DataType
}

func (p *TSCreateTimeseriesReq) GetEncoding() int32 {
  return p.Encoding
}

func (p *TSCreateTimeseriesReq) GetCompressor() int32 {
  return p.Compressor
}
var TSCreateTimeseriesReq_Props_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetProps() map[string]string {
  return p.Props
}
var TSCreateTimeseriesReq_Tags_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetTags() map[string]string {
  return p.Tags
}
var TSCreateTimeseriesReq_Attributes_DEFAULT map[string]string

func (p *TSCreateTimeseriesReq) GetAttributes() map[string]string {
  return p.Attributes
}
var TSCreateTimeseriesReq_MeasurementAlias_DEFAULT string
func (p *TSCreateTimeseriesReq) GetMeasurementAlias() string {
  if !p.IsSetMeasurementAlias() {
    return TSCreateTimeseriesReq_MeasurementAlias_DEFAULT
  }
return *p.MeasurementAlias
}
func (p *TSCreateTimeseriesReq) IsSetProps() bool {
  return p.Props != nil
}

func (p *TSCreateTimeseriesReq) IsSetTags() bool {
  return p.Tags != nil
}

func (p *TSCreateTimeseriesReq) IsSetAttributes() bool {
  return p.Attributes != nil
}

func (p *TSCreateTimeseriesReq) IsSetMeasurementAlias() bool {
  return p.MeasurementAlias != nil
}

func (p *TSCreateTimeseriesReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPath bool = false;
  var issetDataType bool = false;
  var issetEncoding bool = false;
  var issetCompressor bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetDataType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetEncoding = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetCompressor = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.MAP {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  if !issetDataType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataType is not set"));
  }
  if !issetEncoding{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encoding is not set"));
  }
  if !issetCompressor{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressor is not set"));
  }
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.DataType = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Encoding = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.Compressor = v
}
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Props =  tMap
  for i := 0; i < size; i ++ {
var _key105 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key105 = v
}
var _val106 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val106 = v
}
    p.Props[_key105] = _val106
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Tags =  tMap
  for i := 0; i < size; i ++ {
var _key107 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key107 = v
}
var _val108 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val108 = v
}
    p.Tags[_key107] = _val108
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, _, size, err := iprot.ReadMapBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
  }
  tMap := make(map[string]string, size)
  p.Attributes =  tMap
  for i := 0; i < size; i ++ {
var _key109 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _key109 = v
}
var _val110 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _val110 = v
}
    p.Attributes[_key109] = _val110
  }
  if err := iprot.ReadMapEnd(ctx); err != nil {
    return thrift.PrependError("error reading map end: ", err)
  }
  return nil
}

func (p *TSCreateTimeseriesReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.MeasurementAlias = &v
}
  return nil
}

func (p *TSCreateTimeseriesReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateTimeseriesReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateTimeseriesReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataType", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:dataType: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.DataType)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.dataType (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:dataType: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "encoding", thrift.I32, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:encoding: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Encoding)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.encoding (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:encoding: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "compressor", thrift.I32, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:compressor: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Compressor)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.compressor (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:compressor: ", p), err) }
  return err
}

func (p *TSCreateTimeseriesReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetProps() {
    if err := oprot.WriteFieldBegin(ctx, "props", thrift.MAP, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:props: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Props)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Props {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:props: ", p), err) }
  }
  return err
}

func (p *TSCreateTimeseriesReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTags() {
    if err := oprot.WriteFieldBegin(ctx, "tags", thrift.MAP, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:tags: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Tags)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Tags {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:tags: ", p), err) }
  }
  return err
}

func (p *TSCreateTimeseriesReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetAttributes() {
    if err := oprot.WriteFieldBegin(ctx, "attributes", thrift.MAP, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:attributes: ", p), err) }
    if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Attributes)); err != nil {
      return thrift.PrependError("error writing map begin: ", err)
    }
    for k, v := range p.Attributes {
      if err := oprot.WriteString(ctx, string(k)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteMapEnd(ctx); err != nil {
      return thrift.PrependError("error writing map end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:attributes: ", p), err) }
  }
  return err
}

func (p *TSCreateTimeseriesReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurementAlias() {
    if err := oprot.WriteFieldBegin(ctx, "measurementAlias", thrift.STRING, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:measurementAlias: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.MeasurementAlias)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.measurementAlias (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:measurementAlias: ", p), err) }
  }
  return err
}

func (p *TSCreateTimeseriesReq) Equals(other *TSCreateTimeseriesReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Path != other.Path { return false }
  if p.DataType != other.DataType { return false }
  if p.Encoding != other.Encoding { return false }
  if p.Compressor != other.Compressor { return false }
  if len(p.Props) != len(other.Props) { return false }
  for k, _tgt := range p.Props {
    _src111 := other.Props[k]
    if _tgt != _src111 { return false }
  }
  if len(p.Tags) != len(other.Tags) { return false }
  for k, _tgt := range p.Tags {
    _src112 := other.Tags[k]
    if _tgt != _src112 { return false }
  }
  if len(p.Attributes) != len(other.Attributes) { return false }
  for k, _tgt := range p.Attributes {
    _src113 := other.Attributes[k]
    if _tgt != _src113 { return false }
  }
  if p.MeasurementAlias != other.MeasurementAlias {
    if p.MeasurementAlias == nil || other.MeasurementAlias == nil {
      return false
    }
    if (*p.MeasurementAlias) != (*other.MeasurementAlias) { return false }
  }
  return true
}

func (p *TSCreateTimeseriesReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateTimeseriesReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - Measurements
//  - DataTypes
//  - Encodings
//  - Compressors
//  - MeasurementAlias
//  - TagsList
//  - AttributesList
type TSCreateAlignedTimeseriesReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  Measurements []string `thrift:"measurements,3,required" db:"measurements" json:"measurements"`
  DataTypes []int32 `thrift:"dataTypes,4,required" db:"dataTypes" json:"dataTypes"`
  Encodings []int32 `thrift:"encodings,5,required" db:"encodings" json:"encodings"`
  Compressors []int32 `thrift:"compressors,6,required" db:"compressors" json:"compressors"`
  MeasurementAlias []string `thrift:"measurementAlias,7" db:"measurementAlias" json:"measurementAlias,omitempty"`
  TagsList []map[string]string `thrift:"tagsList,8" db:"tagsList" json:"tagsList,omitempty"`
  AttributesList []map[string]string `thrift:"attributesList,9" db:"attributesList" json:"attributesList,omitempty"`
}

func NewTSCreateAlignedTimeseriesReq() *TSCreateAlignedTimeseriesReq {
  return &TSCreateAlignedTimeseriesReq{}
}


func (p *TSCreateAlignedTimeseriesReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateAlignedTimeseriesReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSCreateAlignedTimeseriesReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSCreateAlignedTimeseriesReq) GetDataTypes() []int32 {
  return p.DataTypes
}

func (p *TSCreateAlignedTimeseriesReq) GetEncodings() []int32 {
  return p.Encodings
}

func (p *TSCreateAlignedTimeseriesReq) GetCompressors() []int32 {
  return p.Compressors
}
var TSCreateAlignedTimeseriesReq_MeasurementAlias_DEFAULT []string

func (p *TSCreateAlignedTimeseriesReq) GetMeasurementAlias() []string {
  return p.MeasurementAlias
}
var TSCreateAlignedTimeseriesReq_TagsList_DEFAULT []map[string]string

func (p *TSCreateAlignedTimeseriesReq) GetTagsList() []map[string]string {
  return p.TagsList
}
var TSCreateAlignedTimeseriesReq_AttributesList_DEFAULT []map[string]string

func (p *TSCreateAlignedTimeseriesReq) GetAttributesList() []map[string]string {
  return p.AttributesList
}
func (p *TSCreateAlignedTimeseriesReq) IsSetMeasurementAlias() bool {
  return p.MeasurementAlias != nil
}

func (p *TSCreateAlignedTimeseriesReq) IsSetTagsList() bool {
  return p.TagsList != nil
}

func (p *TSCreateAlignedTimeseriesReq) IsSetAttributesList() bool {
  return p.AttributesList != nil
}

func (p *TSCreateAlignedTimeseriesReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetMeasurements bool = false;
  var issetDataTypes bool = false;
  var issetEncodings bool = false;
  var issetCompressors bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetDataTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetEncodings = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetCompressors = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetDataTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypes is not set"));
  }
  if !issetEncodings{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encodings is not set"));
  }
  if !issetCompressors{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressors is not set"));
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem114 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem114 = v
}
    p.Measurements = append(p.Measurements, _elem114)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.DataTypes =  tSlice
  for i := 0; i < size; i ++ {
var _elem115 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem115 = v
}
    p.DataTypes = append(p.DataTypes, _elem115)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Encodings =  tSlice
  for i := 0; i < size; i ++ {
var _elem116 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem116 = v
}
    p.Encodings = append(p.Encodings, _elem116)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Compressors =  tSlice
  for i := 0; i < size; i ++ {
var _elem117 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem117 = v
}
    p.Compressors = append(p.Compressors, _elem117)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.MeasurementAlias =  tSlice
  for i := 0; i < size; i ++ {
var _elem118 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem118 = v
}
    p.MeasurementAlias = append(p.MeasurementAlias, _elem118)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]map[string]string, 0, size)
  p.TagsList =  tSlice
  for i := 0; i < size; i ++ {
    _, _, size, err := iprot.ReadMapBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading map begin: ", err)
    }
    tMap := make(map[string]string, size)
    _elem119 :=  tMap
    for i := 0; i < size; i ++ {
var _key120 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _key120 = v
}
var _val121 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _val121 = v
}
      _elem119[_key120] = _val121
    }
    if err := iprot.ReadMapEnd(ctx); err != nil {
      return thrift.PrependError("error reading map end: ", err)
    }
    p.TagsList = append(p.TagsList, _elem119)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]map[string]string, 0, size)
  p.AttributesList =  tSlice
  for i := 0; i < size; i ++ {
    _, _, size, err := iprot.ReadMapBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading map begin: ", err)
    }
    tMap := make(map[string]string, size)
    _elem122 :=  tMap
    for i := 0; i < size; i ++ {
var _key123 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _key123 = v
}
var _val124 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _val124 = v
}
      _elem122[_key123] = _val124
    }
    if err := iprot.ReadMapEnd(ctx); err != nil {
      return thrift.PrependError("error reading map end: ", err)
    }
    p.AttributesList = append(p.AttributesList, _elem122)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateAlignedTimeseriesReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateAlignedTimeseriesReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:measurements: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypes", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:dataTypes: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypes)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypes {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:dataTypes: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "encodings", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:encodings: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Encodings)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Encodings {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:encodings: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "compressors", thrift.LIST, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:compressors: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Compressors)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Compressors {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:compressors: ", p), err) }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurementAlias() {
    if err := oprot.WriteFieldBegin(ctx, "measurementAlias", thrift.LIST, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:measurementAlias: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.MeasurementAlias)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.MeasurementAlias {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:measurementAlias: ", p), err) }
  }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTagsList() {
    if err := oprot.WriteFieldBegin(ctx, "tagsList", thrift.LIST, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:tagsList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.TagsList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.TagsList {
      if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
        return thrift.PrependError("error writing map begin: ", err)
      }
      for k, v := range v {
        if err := oprot.WriteString(ctx, string(k)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
        if err := oprot.WriteString(ctx, string(v)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      }
      if err := oprot.WriteMapEnd(ctx); err != nil {
        return thrift.PrependError("error writing map end: ", err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:tagsList: ", p), err) }
  }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetAttributesList() {
    if err := oprot.WriteFieldBegin(ctx, "attributesList", thrift.LIST, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:attributesList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.AttributesList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.AttributesList {
      if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
        return thrift.PrependError("error writing map begin: ", err)
      }
      for k, v := range v {
        if err := oprot.WriteString(ctx, string(k)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
        if err := oprot.WriteString(ctx, string(v)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      }
      if err := oprot.WriteMapEnd(ctx); err != nil {
        return thrift.PrependError("error writing map end: ", err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:attributesList: ", p), err) }
  }
  return err
}

func (p *TSCreateAlignedTimeseriesReq) Equals(other *TSCreateAlignedTimeseriesReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src125 := other.Measurements[i]
    if _tgt != _src125 { return false }
  }
  if len(p.DataTypes) != len(other.DataTypes) { return false }
  for i, _tgt := range p.DataTypes {
    _src126 := other.DataTypes[i]
    if _tgt != _src126 { return false }
  }
  if len(p.Encodings) != len(other.Encodings) { return false }
  for i, _tgt := range p.Encodings {
    _src127 := other.Encodings[i]
    if _tgt != _src127 { return false }
  }
  if len(p.Compressors) != len(other.Compressors) { return false }
  for i, _tgt := range p.Compressors {
    _src128 := other.Compressors[i]
    if _tgt != _src128 { return false }
  }
  if len(p.MeasurementAlias) != len(other.MeasurementAlias) { return false }
  for i, _tgt := range p.MeasurementAlias {
    _src129 := other.MeasurementAlias[i]
    if _tgt != _src129 { return false }
  }
  if len(p.TagsList) != len(other.TagsList) { return false }
  for i, _tgt := range p.TagsList {
    _src130 := other.TagsList[i]
    if len(_tgt) != len(_src130) { return false }
    for k, _tgt := range _tgt {
      _src131 := _src130[k]
      if _tgt != _src131 { return false }
    }
  }
  if len(p.AttributesList) != len(other.AttributesList) { return false }
  for i, _tgt := range p.AttributesList {
    _src132 := other.AttributesList[i]
    if len(_tgt) != len(_src132) { return false }
    for k, _tgt := range _tgt {
      _src133 := _src132[k]
      if _tgt != _src133 { return false }
    }
  }
  return true
}

func (p *TSCreateAlignedTimeseriesReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateAlignedTimeseriesReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - FetchSize
//  - StartTime
//  - EndTime
//  - StatementId
//  - EnableRedirectQuery
//  - JdbcQuery
//  - Timeout
//  - LegalPathNodes
type TSRawDataQueryReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
  FetchSize *int32 `thrift:"fetchSize,3" db:"fetchSize" json:"fetchSize,omitempty"`
  StartTime int64 `thrift:"startTime,4,required" db:"startTime" json:"startTime"`
  EndTime int64 `thrift:"endTime,5,required" db:"endTime" json:"endTime"`
  StatementId int64 `thrift:"statementId,6,required" db:"statementId" json:"statementId"`
  EnableRedirectQuery *bool `thrift:"enableRedirectQuery,7" db:"enableRedirectQuery" json:"enableRedirectQuery,omitempty"`
  JdbcQuery *bool `thrift:"jdbcQuery,8" db:"jdbcQuery" json:"jdbcQuery,omitempty"`
  Timeout *int64 `thrift:"timeout,9" db:"timeout" json:"timeout,omitempty"`
  LegalPathNodes *bool `thrift:"legalPathNodes,10" db:"legalPathNodes" json:"legalPathNodes,omitempty"`
}

func NewTSRawDataQueryReq() *TSRawDataQueryReq {
  return &TSRawDataQueryReq{}
}


func (p *TSRawDataQueryReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSRawDataQueryReq) GetPaths() []string {
  return p.Paths
}
var TSRawDataQueryReq_FetchSize_DEFAULT int32
func (p *TSRawDataQueryReq) GetFetchSize() int32 {
  if !p.IsSetFetchSize() {
    return TSRawDataQueryReq_FetchSize_DEFAULT
  }
return *p.FetchSize
}

func (p *TSRawDataQueryReq) GetStartTime() int64 {
  return p.StartTime
}

func (p *TSRawDataQueryReq) GetEndTime() int64 {
  return p.EndTime
}

func (p *TSRawDataQueryReq) GetStatementId() int64 {
  return p.StatementId
}
var TSRawDataQueryReq_EnableRedirectQuery_DEFAULT bool
func (p *TSRawDataQueryReq) GetEnableRedirectQuery() bool {
  if !p.IsSetEnableRedirectQuery() {
    return TSRawDataQueryReq_EnableRedirectQuery_DEFAULT
  }
return *p.EnableRedirectQuery
}
var TSRawDataQueryReq_JdbcQuery_DEFAULT bool
func (p *TSRawDataQueryReq) GetJdbcQuery() bool {
  if !p.IsSetJdbcQuery() {
    return TSRawDataQueryReq_JdbcQuery_DEFAULT
  }
return *p.JdbcQuery
}
var TSRawDataQueryReq_Timeout_DEFAULT int64
func (p *TSRawDataQueryReq) GetTimeout() int64 {
  if !p.IsSetTimeout() {
    return TSRawDataQueryReq_Timeout_DEFAULT
  }
return *p.Timeout
}
var TSRawDataQueryReq_LegalPathNodes_DEFAULT bool
func (p *TSRawDataQueryReq) GetLegalPathNodes() bool {
  if !p.IsSetLegalPathNodes() {
    return TSRawDataQueryReq_LegalPathNodes_DEFAULT
  }
return *p.LegalPathNodes
}
func (p *TSRawDataQueryReq) IsSetFetchSize() bool {
  return p.FetchSize != nil
}

func (p *TSRawDataQueryReq) IsSetEnableRedirectQuery() bool {
  return p.EnableRedirectQuery != nil
}

func (p *TSRawDataQueryReq) IsSetJdbcQuery() bool {
  return p.JdbcQuery != nil
}

func (p *TSRawDataQueryReq) IsSetTimeout() bool {
  return p.Timeout != nil
}

func (p *TSRawDataQueryReq) IsSetLegalPathNodes() bool {
  return p.LegalPathNodes != nil
}

func (p *TSRawDataQueryReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPaths bool = false;
  var issetStartTime bool = false;
  var issetEndTime bool = false;
  var issetStatementId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetStartTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetEndTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetStatementId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetStartTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StartTime is not set"));
  }
  if !issetEndTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field EndTime is not set"));
  }
  if !issetStatementId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
  }
  return nil
}

func (p *TSRawDataQueryReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem134 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem134 = v
}
    p.Paths = append(p.Paths, _elem134)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSRawDataQueryReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.FetchSize = &v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.StartTime = v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.EndTime = v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.StatementId = v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.EnableRedirectQuery = &v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.JdbcQuery = &v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.Timeout = &v
}
  return nil
}

func (p *TSRawDataQueryReq)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 10: ", err)
} else {
  p.LegalPathNodes = &v
}
  return nil
}

func (p *TSRawDataQueryReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSRawDataQueryReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSRawDataQueryReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFetchSize() {
    if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:fetchSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.fetchSize (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:fetchSize: ", p), err) }
  }
  return err
}

func (p *TSRawDataQueryReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:startTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startTime (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:startTime: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:endTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.EndTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.endTime (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:endTime: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:statementId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statementId (6) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:statementId: ", p), err) }
  return err
}

func (p *TSRawDataQueryReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetEnableRedirectQuery() {
    if err := oprot.WriteFieldBegin(ctx, "enableRedirectQuery", thrift.BOOL, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:enableRedirectQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.EnableRedirectQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.enableRedirectQuery (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:enableRedirectQuery: ", p), err) }
  }
  return err
}

func (p *TSRawDataQueryReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetJdbcQuery() {
    if err := oprot.WriteFieldBegin(ctx, "jdbcQuery", thrift.BOOL, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:jdbcQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.JdbcQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.jdbcQuery (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:jdbcQuery: ", p), err) }
  }
  return err
}

func (p *TSRawDataQueryReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeout() {
    if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:timeout: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeout (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:timeout: ", p), err) }
  }
  return err
}

func (p *TSRawDataQueryReq) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetLegalPathNodes() {
    if err := oprot.WriteFieldBegin(ctx, "legalPathNodes", thrift.BOOL, 10); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:legalPathNodes: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.LegalPathNodes)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.legalPathNodes (10) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 10:legalPathNodes: ", p), err) }
  }
  return err
}

func (p *TSRawDataQueryReq) Equals(other *TSRawDataQueryReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src135 := other.Paths[i]
    if _tgt != _src135 { return false }
  }
  if p.FetchSize != other.FetchSize {
    if p.FetchSize == nil || other.FetchSize == nil {
      return false
    }
    if (*p.FetchSize) != (*other.FetchSize) { return false }
  }
  if p.StartTime != other.StartTime { return false }
  if p.EndTime != other.EndTime { return false }
  if p.StatementId != other.StatementId { return false }
  if p.EnableRedirectQuery != other.EnableRedirectQuery {
    if p.EnableRedirectQuery == nil || other.EnableRedirectQuery == nil {
      return false
    }
    if (*p.EnableRedirectQuery) != (*other.EnableRedirectQuery) { return false }
  }
  if p.JdbcQuery != other.JdbcQuery {
    if p.JdbcQuery == nil || other.JdbcQuery == nil {
      return false
    }
    if (*p.JdbcQuery) != (*other.JdbcQuery) { return false }
  }
  if p.Timeout != other.Timeout {
    if p.Timeout == nil || other.Timeout == nil {
      return false
    }
    if (*p.Timeout) != (*other.Timeout) { return false }
  }
  if p.LegalPathNodes != other.LegalPathNodes {
    if p.LegalPathNodes == nil || other.LegalPathNodes == nil {
      return false
    }
    if (*p.LegalPathNodes) != (*other.LegalPathNodes) { return false }
  }
  return true
}

func (p *TSRawDataQueryReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSRawDataQueryReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - FetchSize
//  - Time
//  - StatementId
//  - EnableRedirectQuery
//  - JdbcQuery
//  - Timeout
//  - LegalPathNodes
type TSLastDataQueryReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
  FetchSize *int32 `thrift:"fetchSize,3" db:"fetchSize" json:"fetchSize,omitempty"`
  Time int64 `thrift:"time,4,required" db:"time" json:"time"`
  StatementId int64 `thrift:"statementId,5,required" db:"statementId" json:"statementId"`
  EnableRedirectQuery *bool `thrift:"enableRedirectQuery,6" db:"enableRedirectQuery" json:"enableRedirectQuery,omitempty"`
  JdbcQuery *bool `thrift:"jdbcQuery,7" db:"jdbcQuery" json:"jdbcQuery,omitempty"`
  Timeout *int64 `thrift:"timeout,8" db:"timeout" json:"timeout,omitempty"`
  LegalPathNodes *bool `thrift:"legalPathNodes,9" db:"legalPathNodes" json:"legalPathNodes,omitempty"`
}

func NewTSLastDataQueryReq() *TSLastDataQueryReq {
  return &TSLastDataQueryReq{}
}


func (p *TSLastDataQueryReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSLastDataQueryReq) GetPaths() []string {
  return p.Paths
}
var TSLastDataQueryReq_FetchSize_DEFAULT int32
func (p *TSLastDataQueryReq) GetFetchSize() int32 {
  if !p.IsSetFetchSize() {
    return TSLastDataQueryReq_FetchSize_DEFAULT
  }
return *p.FetchSize
}

func (p *TSLastDataQueryReq) GetTime() int64 {
  return p.Time
}

func (p *TSLastDataQueryReq) GetStatementId() int64 {
  return p.StatementId
}
var TSLastDataQueryReq_EnableRedirectQuery_DEFAULT bool
func (p *TSLastDataQueryReq) GetEnableRedirectQuery() bool {
  if !p.IsSetEnableRedirectQuery() {
    return TSLastDataQueryReq_EnableRedirectQuery_DEFAULT
  }
return *p.EnableRedirectQuery
}
var TSLastDataQueryReq_JdbcQuery_DEFAULT bool
func (p *TSLastDataQueryReq) GetJdbcQuery() bool {
  if !p.IsSetJdbcQuery() {
    return TSLastDataQueryReq_JdbcQuery_DEFAULT
  }
return *p.JdbcQuery
}
var TSLastDataQueryReq_Timeout_DEFAULT int64
func (p *TSLastDataQueryReq) GetTimeout() int64 {
  if !p.IsSetTimeout() {
    return TSLastDataQueryReq_Timeout_DEFAULT
  }
return *p.Timeout
}
var TSLastDataQueryReq_LegalPathNodes_DEFAULT bool
func (p *TSLastDataQueryReq) GetLegalPathNodes() bool {
  if !p.IsSetLegalPathNodes() {
    return TSLastDataQueryReq_LegalPathNodes_DEFAULT
  }
return *p.LegalPathNodes
}
func (p *TSLastDataQueryReq) IsSetFetchSize() bool {
  return p.FetchSize != nil
}

func (p *TSLastDataQueryReq) IsSetEnableRedirectQuery() bool {
  return p.EnableRedirectQuery != nil
}

func (p *TSLastDataQueryReq) IsSetJdbcQuery() bool {
  return p.JdbcQuery != nil
}

func (p *TSLastDataQueryReq) IsSetTimeout() bool {
  return p.Timeout != nil
}

func (p *TSLastDataQueryReq) IsSetLegalPathNodes() bool {
  return p.LegalPathNodes != nil
}

func (p *TSLastDataQueryReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPaths bool = false;
  var issetTime bool = false;
  var issetStatementId bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetStatementId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Time is not set"));
  }
  if !issetStatementId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
  }
  return nil
}

func (p *TSLastDataQueryReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem136 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem136 = v
}
    p.Paths = append(p.Paths, _elem136)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSLastDataQueryReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.FetchSize = &v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Time = v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.StatementId = v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.EnableRedirectQuery = &v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.JdbcQuery = &v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.Timeout = &v
}
  return nil
}

func (p *TSLastDataQueryReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.LegalPathNodes = &v
}
  return nil
}

func (p *TSLastDataQueryReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSLastDataQueryReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSLastDataQueryReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSLastDataQueryReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSLastDataQueryReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFetchSize() {
    if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:fetchSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.fetchSize (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:fetchSize: ", p), err) }
  }
  return err
}

func (p *TSLastDataQueryReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "time", thrift.I64, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:time: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.Time)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.time (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:time: ", p), err) }
  return err
}

func (p *TSLastDataQueryReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:statementId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statementId (5) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:statementId: ", p), err) }
  return err
}

func (p *TSLastDataQueryReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetEnableRedirectQuery() {
    if err := oprot.WriteFieldBegin(ctx, "enableRedirectQuery", thrift.BOOL, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:enableRedirectQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.EnableRedirectQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.enableRedirectQuery (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:enableRedirectQuery: ", p), err) }
  }
  return err
}

func (p *TSLastDataQueryReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetJdbcQuery() {
    if err := oprot.WriteFieldBegin(ctx, "jdbcQuery", thrift.BOOL, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:jdbcQuery: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.JdbcQuery)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.jdbcQuery (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:jdbcQuery: ", p), err) }
  }
  return err
}

func (p *TSLastDataQueryReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeout() {
    if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:timeout: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeout (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:timeout: ", p), err) }
  }
  return err
}

func (p *TSLastDataQueryReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetLegalPathNodes() {
    if err := oprot.WriteFieldBegin(ctx, "legalPathNodes", thrift.BOOL, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:legalPathNodes: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.LegalPathNodes)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.legalPathNodes (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:legalPathNodes: ", p), err) }
  }
  return err
}

func (p *TSLastDataQueryReq) Equals(other *TSLastDataQueryReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src137 := other.Paths[i]
    if _tgt != _src137 { return false }
  }
  if p.FetchSize != other.FetchSize {
    if p.FetchSize == nil || other.FetchSize == nil {
      return false
    }
    if (*p.FetchSize) != (*other.FetchSize) { return false }
  }
  if p.Time != other.Time { return false }
  if p.StatementId != other.StatementId { return false }
  if p.EnableRedirectQuery != other.EnableRedirectQuery {
    if p.EnableRedirectQuery == nil || other.EnableRedirectQuery == nil {
      return false
    }
    if (*p.EnableRedirectQuery) != (*other.EnableRedirectQuery) { return false }
  }
  if p.JdbcQuery != other.JdbcQuery {
    if p.JdbcQuery == nil || other.JdbcQuery == nil {
      return false
    }
    if (*p.JdbcQuery) != (*other.JdbcQuery) { return false }
  }
  if p.Timeout != other.Timeout {
    if p.Timeout == nil || other.Timeout == nil {
      return false
    }
    if (*p.Timeout) != (*other.Timeout) { return false }
  }
  if p.LegalPathNodes != other.LegalPathNodes {
    if p.LegalPathNodes == nil || other.LegalPathNodes == nil {
      return false
    }
    if (*p.LegalPathNodes) != (*other.LegalPathNodes) { return false }
  }
  return true
}

func (p *TSLastDataQueryReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSLastDataQueryReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - StatementId
//  - Paths
//  - Aggregations
//  - StartTime
//  - EndTime
//  - Interval
//  - SlidingStep
//  - FetchSize
//  - Timeout
//  - LegalPathNodes
type TSAggregationQueryReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  StatementId int64 `thrift:"statementId,2,required" db:"statementId" json:"statementId"`
  Paths []string `thrift:"paths,3,required" db:"paths" json:"paths"`
  Aggregations []common.TAggregationType `thrift:"aggregations,4,required" db:"aggregations" json:"aggregations"`
  StartTime *int64 `thrift:"startTime,5" db:"startTime" json:"startTime,omitempty"`
  EndTime *int64 `thrift:"endTime,6" db:"endTime" json:"endTime,omitempty"`
  Interval *int64 `thrift:"interval,7" db:"interval" json:"interval,omitempty"`
  SlidingStep *int64 `thrift:"slidingStep,8" db:"slidingStep" json:"slidingStep,omitempty"`
  FetchSize *int32 `thrift:"fetchSize,9" db:"fetchSize" json:"fetchSize,omitempty"`
  Timeout *int64 `thrift:"timeout,10" db:"timeout" json:"timeout,omitempty"`
  LegalPathNodes *bool `thrift:"legalPathNodes,11" db:"legalPathNodes" json:"legalPathNodes,omitempty"`
}

func NewTSAggregationQueryReq() *TSAggregationQueryReq {
  return &TSAggregationQueryReq{}
}


func (p *TSAggregationQueryReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSAggregationQueryReq) GetStatementId() int64 {
  return p.StatementId
}

func (p *TSAggregationQueryReq) GetPaths() []string {
  return p.Paths
}

func (p *TSAggregationQueryReq) GetAggregations() []common.TAggregationType {
  return p.Aggregations
}
var TSAggregationQueryReq_StartTime_DEFAULT int64
func (p *TSAggregationQueryReq) GetStartTime() int64 {
  if !p.IsSetStartTime() {
    return TSAggregationQueryReq_StartTime_DEFAULT
  }
return *p.StartTime
}
var TSAggregationQueryReq_EndTime_DEFAULT int64
func (p *TSAggregationQueryReq) GetEndTime() int64 {
  if !p.IsSetEndTime() {
    return TSAggregationQueryReq_EndTime_DEFAULT
  }
return *p.EndTime
}
var TSAggregationQueryReq_Interval_DEFAULT int64
func (p *TSAggregationQueryReq) GetInterval() int64 {
  if !p.IsSetInterval() {
    return TSAggregationQueryReq_Interval_DEFAULT
  }
return *p.Interval
}
var TSAggregationQueryReq_SlidingStep_DEFAULT int64
func (p *TSAggregationQueryReq) GetSlidingStep() int64 {
  if !p.IsSetSlidingStep() {
    return TSAggregationQueryReq_SlidingStep_DEFAULT
  }
return *p.SlidingStep
}
var TSAggregationQueryReq_FetchSize_DEFAULT int32
func (p *TSAggregationQueryReq) GetFetchSize() int32 {
  if !p.IsSetFetchSize() {
    return TSAggregationQueryReq_FetchSize_DEFAULT
  }
return *p.FetchSize
}
var TSAggregationQueryReq_Timeout_DEFAULT int64
func (p *TSAggregationQueryReq) GetTimeout() int64 {
  if !p.IsSetTimeout() {
    return TSAggregationQueryReq_Timeout_DEFAULT
  }
return *p.Timeout
}
var TSAggregationQueryReq_LegalPathNodes_DEFAULT bool
func (p *TSAggregationQueryReq) GetLegalPathNodes() bool {
  if !p.IsSetLegalPathNodes() {
    return TSAggregationQueryReq_LegalPathNodes_DEFAULT
  }
return *p.LegalPathNodes
}
func (p *TSAggregationQueryReq) IsSetStartTime() bool {
  return p.StartTime != nil
}

func (p *TSAggregationQueryReq) IsSetEndTime() bool {
  return p.EndTime != nil
}

func (p *TSAggregationQueryReq) IsSetInterval() bool {
  return p.Interval != nil
}

func (p *TSAggregationQueryReq) IsSetSlidingStep() bool {
  return p.SlidingStep != nil
}

func (p *TSAggregationQueryReq) IsSetFetchSize() bool {
  return p.FetchSize != nil
}

func (p *TSAggregationQueryReq) IsSetTimeout() bool {
  return p.Timeout != nil
}

func (p *TSAggregationQueryReq) IsSetLegalPathNodes() bool {
  return p.LegalPathNodes != nil
}

func (p *TSAggregationQueryReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetStatementId bool = false;
  var issetPaths bool = false;
  var issetAggregations bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetStatementId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetAggregations = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 11:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField11(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetStatementId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StatementId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetAggregations{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Aggregations is not set"));
  }
  return nil
}

func (p *TSAggregationQueryReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSAggregationQueryReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.StatementId = v
}
  return nil
}

func (p *TSAggregationQueryReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem138 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem138 = v
}
    p.Paths = append(p.Paths, _elem138)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAggregationQueryReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]common.TAggregationType, 0, size)
  p.Aggregations =  tSlice
  for i := 0; i < size; i ++ {
var _elem139 common.TAggregationType
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    temp := common.TAggregationType(v)
    _elem139 = temp
}
    p.Aggregations = append(p.Aggregations, _elem139)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAggregationQueryReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.StartTime = &v
}
  return nil
}

func (p *TSAggregationQueryReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.EndTime = &v
}
  return nil
}

func (p *TSAggregationQueryReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.Interval = &v
}
  return nil
}

func (p *TSAggregationQueryReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.SlidingStep = &v
}
  return nil
}

func (p *TSAggregationQueryReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.FetchSize = &v
}
  return nil
}

func (p *TSAggregationQueryReq)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 10: ", err)
} else {
  p.Timeout = &v
}
  return nil
}

func (p *TSAggregationQueryReq)  ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 11: ", err)
} else {
  p.LegalPathNodes = &v
}
  return nil
}

func (p *TSAggregationQueryReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSAggregationQueryReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
    if err := p.writeField11(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSAggregationQueryReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSAggregationQueryReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "statementId", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:statementId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StatementId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.statementId (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:statementId: ", p), err) }
  return err
}

func (p *TSAggregationQueryReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:paths: ", p), err) }
  return err
}

func (p *TSAggregationQueryReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "aggregations", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:aggregations: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Aggregations)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Aggregations {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:aggregations: ", p), err) }
  return err
}

func (p *TSAggregationQueryReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetStartTime() {
    if err := oprot.WriteFieldBegin(ctx, "startTime", thrift.I64, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:startTime: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.StartTime)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.startTime (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:startTime: ", p), err) }
  }
  return err
}

func (p *TSAggregationQueryReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetEndTime() {
    if err := oprot.WriteFieldBegin(ctx, "endTime", thrift.I64, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:endTime: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.EndTime)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.endTime (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:endTime: ", p), err) }
  }
  return err
}

func (p *TSAggregationQueryReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetInterval() {
    if err := oprot.WriteFieldBegin(ctx, "interval", thrift.I64, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:interval: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Interval)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.interval (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:interval: ", p), err) }
  }
  return err
}

func (p *TSAggregationQueryReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSlidingStep() {
    if err := oprot.WriteFieldBegin(ctx, "slidingStep", thrift.I64, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:slidingStep: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.SlidingStep)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.slidingStep (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:slidingStep: ", p), err) }
  }
  return err
}

func (p *TSAggregationQueryReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetFetchSize() {
    if err := oprot.WriteFieldBegin(ctx, "fetchSize", thrift.I32, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:fetchSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.FetchSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.fetchSize (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:fetchSize: ", p), err) }
  }
  return err
}

func (p *TSAggregationQueryReq) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTimeout() {
    if err := oprot.WriteFieldBegin(ctx, "timeout", thrift.I64, 10); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:timeout: ", p), err) }
    if err := oprot.WriteI64(ctx, int64(*p.Timeout)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.timeout (10) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 10:timeout: ", p), err) }
  }
  return err
}

func (p *TSAggregationQueryReq) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetLegalPathNodes() {
    if err := oprot.WriteFieldBegin(ctx, "legalPathNodes", thrift.BOOL, 11); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:legalPathNodes: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.LegalPathNodes)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.legalPathNodes (11) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 11:legalPathNodes: ", p), err) }
  }
  return err
}

func (p *TSAggregationQueryReq) Equals(other *TSAggregationQueryReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.StatementId != other.StatementId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src140 := other.Paths[i]
    if _tgt != _src140 { return false }
  }
  if len(p.Aggregations) != len(other.Aggregations) { return false }
  for i, _tgt := range p.Aggregations {
    _src141 := other.Aggregations[i]
    if _tgt != _src141 { return false }
  }
  if p.StartTime != other.StartTime {
    if p.StartTime == nil || other.StartTime == nil {
      return false
    }
    if (*p.StartTime) != (*other.StartTime) { return false }
  }
  if p.EndTime != other.EndTime {
    if p.EndTime == nil || other.EndTime == nil {
      return false
    }
    if (*p.EndTime) != (*other.EndTime) { return false }
  }
  if p.Interval != other.Interval {
    if p.Interval == nil || other.Interval == nil {
      return false
    }
    if (*p.Interval) != (*other.Interval) { return false }
  }
  if p.SlidingStep != other.SlidingStep {
    if p.SlidingStep == nil || other.SlidingStep == nil {
      return false
    }
    if (*p.SlidingStep) != (*other.SlidingStep) { return false }
  }
  if p.FetchSize != other.FetchSize {
    if p.FetchSize == nil || other.FetchSize == nil {
      return false
    }
    if (*p.FetchSize) != (*other.FetchSize) { return false }
  }
  if p.Timeout != other.Timeout {
    if p.Timeout == nil || other.Timeout == nil {
      return false
    }
    if (*p.Timeout) != (*other.Timeout) { return false }
  }
  if p.LegalPathNodes != other.LegalPathNodes {
    if p.LegalPathNodes == nil || other.LegalPathNodes == nil {
      return false
    }
    if (*p.LegalPathNodes) != (*other.LegalPathNodes) { return false }
  }
  return true
}

func (p *TSAggregationQueryReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSAggregationQueryReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Paths
//  - DataTypes
//  - Encodings
//  - Compressors
//  - PropsList
//  - TagsList
//  - AttributesList
//  - MeasurementAliasList
type TSCreateMultiTimeseriesReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Paths []string `thrift:"paths,2,required" db:"paths" json:"paths"`
  DataTypes []int32 `thrift:"dataTypes,3,required" db:"dataTypes" json:"dataTypes"`
  Encodings []int32 `thrift:"encodings,4,required" db:"encodings" json:"encodings"`
  Compressors []int32 `thrift:"compressors,5,required" db:"compressors" json:"compressors"`
  PropsList []map[string]string `thrift:"propsList,6" db:"propsList" json:"propsList,omitempty"`
  TagsList []map[string]string `thrift:"tagsList,7" db:"tagsList" json:"tagsList,omitempty"`
  AttributesList []map[string]string `thrift:"attributesList,8" db:"attributesList" json:"attributesList,omitempty"`
  MeasurementAliasList []string `thrift:"measurementAliasList,9" db:"measurementAliasList" json:"measurementAliasList,omitempty"`
}

func NewTSCreateMultiTimeseriesReq() *TSCreateMultiTimeseriesReq {
  return &TSCreateMultiTimeseriesReq{}
}


func (p *TSCreateMultiTimeseriesReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateMultiTimeseriesReq) GetPaths() []string {
  return p.Paths
}

func (p *TSCreateMultiTimeseriesReq) GetDataTypes() []int32 {
  return p.DataTypes
}

func (p *TSCreateMultiTimeseriesReq) GetEncodings() []int32 {
  return p.Encodings
}

func (p *TSCreateMultiTimeseriesReq) GetCompressors() []int32 {
  return p.Compressors
}
var TSCreateMultiTimeseriesReq_PropsList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetPropsList() []map[string]string {
  return p.PropsList
}
var TSCreateMultiTimeseriesReq_TagsList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetTagsList() []map[string]string {
  return p.TagsList
}
var TSCreateMultiTimeseriesReq_AttributesList_DEFAULT []map[string]string

func (p *TSCreateMultiTimeseriesReq) GetAttributesList() []map[string]string {
  return p.AttributesList
}
var TSCreateMultiTimeseriesReq_MeasurementAliasList_DEFAULT []string

func (p *TSCreateMultiTimeseriesReq) GetMeasurementAliasList() []string {
  return p.MeasurementAliasList
}
func (p *TSCreateMultiTimeseriesReq) IsSetPropsList() bool {
  return p.PropsList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetTagsList() bool {
  return p.TagsList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetAttributesList() bool {
  return p.AttributesList != nil
}

func (p *TSCreateMultiTimeseriesReq) IsSetMeasurementAliasList() bool {
  return p.MeasurementAliasList != nil
}

func (p *TSCreateMultiTimeseriesReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPaths bool = false;
  var issetDataTypes bool = false;
  var issetEncodings bool = false;
  var issetCompressors bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPaths = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetDataTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetEncodings = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetCompressors = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPaths{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Paths is not set"));
  }
  if !issetDataTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypes is not set"));
  }
  if !issetEncodings{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encodings is not set"));
  }
  if !issetCompressors{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressors is not set"));
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Paths =  tSlice
  for i := 0; i < size; i ++ {
var _elem142 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem142 = v
}
    p.Paths = append(p.Paths, _elem142)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.DataTypes =  tSlice
  for i := 0; i < size; i ++ {
var _elem143 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem143 = v
}
    p.DataTypes = append(p.DataTypes, _elem143)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Encodings =  tSlice
  for i := 0; i < size; i ++ {
var _elem144 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem144 = v
}
    p.Encodings = append(p.Encodings, _elem144)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Compressors =  tSlice
  for i := 0; i < size; i ++ {
var _elem145 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem145 = v
}
    p.Compressors = append(p.Compressors, _elem145)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]map[string]string, 0, size)
  p.PropsList =  tSlice
  for i := 0; i < size; i ++ {
    _, _, size, err := iprot.ReadMapBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading map begin: ", err)
    }
    tMap := make(map[string]string, size)
    _elem146 :=  tMap
    for i := 0; i < size; i ++ {
var _key147 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _key147 = v
}
var _val148 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _val148 = v
}
      _elem146[_key147] = _val148
    }
    if err := iprot.ReadMapEnd(ctx); err != nil {
      return thrift.PrependError("error reading map end: ", err)
    }
    p.PropsList = append(p.PropsList, _elem146)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]map[string]string, 0, size)
  p.TagsList =  tSlice
  for i := 0; i < size; i ++ {
    _, _, size, err := iprot.ReadMapBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading map begin: ", err)
    }
    tMap := make(map[string]string, size)
    _elem149 :=  tMap
    for i := 0; i < size; i ++ {
var _key150 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _key150 = v
}
var _val151 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _val151 = v
}
      _elem149[_key150] = _val151
    }
    if err := iprot.ReadMapEnd(ctx); err != nil {
      return thrift.PrependError("error reading map end: ", err)
    }
    p.TagsList = append(p.TagsList, _elem149)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]map[string]string, 0, size)
  p.AttributesList =  tSlice
  for i := 0; i < size; i ++ {
    _, _, size, err := iprot.ReadMapBegin(ctx)
    if err != nil {
      return thrift.PrependError("error reading map begin: ", err)
    }
    tMap := make(map[string]string, size)
    _elem152 :=  tMap
    for i := 0; i < size; i ++ {
var _key153 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _key153 = v
}
var _val154 string
      if v, err := iprot.ReadString(ctx); err != nil {
      return thrift.PrependError("error reading field 0: ", err)
} else {
      _val154 = v
}
      _elem152[_key153] = _val154
    }
    if err := iprot.ReadMapEnd(ctx); err != nil {
      return thrift.PrependError("error reading map end: ", err)
    }
    p.AttributesList = append(p.AttributesList, _elem152)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.MeasurementAliasList =  tSlice
  for i := 0; i < size; i ++ {
var _elem155 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem155 = v
}
    p.MeasurementAliasList = append(p.MeasurementAliasList, _elem155)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSCreateMultiTimeseriesReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateMultiTimeseriesReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateMultiTimeseriesReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "paths", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:paths: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Paths)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Paths {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:paths: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypes", thrift.LIST, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:dataTypes: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypes)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypes {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:dataTypes: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "encodings", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:encodings: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Encodings)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Encodings {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:encodings: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "compressors", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:compressors: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Compressors)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Compressors {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:compressors: ", p), err) }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetPropsList() {
    if err := oprot.WriteFieldBegin(ctx, "propsList", thrift.LIST, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:propsList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.PropsList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.PropsList {
      if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
        return thrift.PrependError("error writing map begin: ", err)
      }
      for k, v := range v {
        if err := oprot.WriteString(ctx, string(k)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
        if err := oprot.WriteString(ctx, string(v)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      }
      if err := oprot.WriteMapEnd(ctx); err != nil {
        return thrift.PrependError("error writing map end: ", err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:propsList: ", p), err) }
  }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetTagsList() {
    if err := oprot.WriteFieldBegin(ctx, "tagsList", thrift.LIST, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:tagsList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.TagsList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.TagsList {
      if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
        return thrift.PrependError("error writing map begin: ", err)
      }
      for k, v := range v {
        if err := oprot.WriteString(ctx, string(k)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
        if err := oprot.WriteString(ctx, string(v)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      }
      if err := oprot.WriteMapEnd(ctx); err != nil {
        return thrift.PrependError("error writing map end: ", err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:tagsList: ", p), err) }
  }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetAttributesList() {
    if err := oprot.WriteFieldBegin(ctx, "attributesList", thrift.LIST, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:attributesList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.AttributesList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.AttributesList {
      if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
        return thrift.PrependError("error writing map begin: ", err)
      }
      for k, v := range v {
        if err := oprot.WriteString(ctx, string(k)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
        if err := oprot.WriteString(ctx, string(v)); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
      }
      if err := oprot.WriteMapEnd(ctx); err != nil {
        return thrift.PrependError("error writing map end: ", err)
      }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:attributesList: ", p), err) }
  }
  return err
}

func (p *TSCreateMultiTimeseriesReq) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurementAliasList() {
    if err := oprot.WriteFieldBegin(ctx, "measurementAliasList", thrift.LIST, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:measurementAliasList: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.MeasurementAliasList)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.MeasurementAliasList {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:measurementAliasList: ", p), err) }
  }
  return err
}

func (p *TSCreateMultiTimeseriesReq) Equals(other *TSCreateMultiTimeseriesReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.Paths) != len(other.Paths) { return false }
  for i, _tgt := range p.Paths {
    _src156 := other.Paths[i]
    if _tgt != _src156 { return false }
  }
  if len(p.DataTypes) != len(other.DataTypes) { return false }
  for i, _tgt := range p.DataTypes {
    _src157 := other.DataTypes[i]
    if _tgt != _src157 { return false }
  }
  if len(p.Encodings) != len(other.Encodings) { return false }
  for i, _tgt := range p.Encodings {
    _src158 := other.Encodings[i]
    if _tgt != _src158 { return false }
  }
  if len(p.Compressors) != len(other.Compressors) { return false }
  for i, _tgt := range p.Compressors {
    _src159 := other.Compressors[i]
    if _tgt != _src159 { return false }
  }
  if len(p.PropsList) != len(other.PropsList) { return false }
  for i, _tgt := range p.PropsList {
    _src160 := other.PropsList[i]
    if len(_tgt) != len(_src160) { return false }
    for k, _tgt := range _tgt {
      _src161 := _src160[k]
      if _tgt != _src161 { return false }
    }
  }
  if len(p.TagsList) != len(other.TagsList) { return false }
  for i, _tgt := range p.TagsList {
    _src162 := other.TagsList[i]
    if len(_tgt) != len(_src162) { return false }
    for k, _tgt := range _tgt {
      _src163 := _src162[k]
      if _tgt != _src163 { return false }
    }
  }
  if len(p.AttributesList) != len(other.AttributesList) { return false }
  for i, _tgt := range p.AttributesList {
    _src164 := other.AttributesList[i]
    if len(_tgt) != len(_src164) { return false }
    for k, _tgt := range _tgt {
      _src165 := _src164[k]
      if _tgt != _src165 { return false }
    }
  }
  if len(p.MeasurementAliasList) != len(other.MeasurementAliasList) { return false }
  for i, _tgt := range p.MeasurementAliasList {
    _src166 := other.MeasurementAliasList[i]
    if _tgt != _src166 { return false }
  }
  return true
}

func (p *TSCreateMultiTimeseriesReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateMultiTimeseriesReq(%+v)", *p)
}

// Attributes:
//  - Version
//  - SupportedTimeAggregationOperations
//  - TimestampPrecision
//  - MaxConcurrentClientNum
//  - WatermarkSecretKey
//  - WatermarkBitString
//  - WatermarkParamMarkRate
//  - WatermarkParamMaxRightBit
//  - ThriftMaxFrameSize
//  - IsReadOnly
//  - BuildInfo
type ServerProperties struct {
  Version string `thrift:"version,1,required" db:"version" json:"version"`
  SupportedTimeAggregationOperations []string `thrift:"supportedTimeAggregationOperations,2,required" db:"supportedTimeAggregationOperations" json:"supportedTimeAggregationOperations"`
  TimestampPrecision string `thrift:"timestampPrecision,3,required" db:"timestampPrecision" json:"timestampPrecision"`
  MaxConcurrentClientNum int32 `thrift:"maxConcurrentClientNum,4" db:"maxConcurrentClientNum" json:"maxConcurrentClientNum"`
  WatermarkSecretKey *string `thrift:"watermarkSecretKey,5" db:"watermarkSecretKey" json:"watermarkSecretKey,omitempty"`
  WatermarkBitString *string `thrift:"watermarkBitString,6" db:"watermarkBitString" json:"watermarkBitString,omitempty"`
  WatermarkParamMarkRate *int32 `thrift:"watermarkParamMarkRate,7" db:"watermarkParamMarkRate" json:"watermarkParamMarkRate,omitempty"`
  WatermarkParamMaxRightBit *int32 `thrift:"watermarkParamMaxRightBit,8" db:"watermarkParamMaxRightBit" json:"watermarkParamMaxRightBit,omitempty"`
  ThriftMaxFrameSize *int32 `thrift:"thriftMaxFrameSize,9" db:"thriftMaxFrameSize" json:"thriftMaxFrameSize,omitempty"`
  IsReadOnly *bool `thrift:"isReadOnly,10" db:"isReadOnly" json:"isReadOnly,omitempty"`
  BuildInfo *string `thrift:"buildInfo,11" db:"buildInfo" json:"buildInfo,omitempty"`
}

func NewServerProperties() *ServerProperties {
  return &ServerProperties{}
}


func (p *ServerProperties) GetVersion() string {
  return p.Version
}

func (p *ServerProperties) GetSupportedTimeAggregationOperations() []string {
  return p.SupportedTimeAggregationOperations
}

func (p *ServerProperties) GetTimestampPrecision() string {
  return p.TimestampPrecision
}

func (p *ServerProperties) GetMaxConcurrentClientNum() int32 {
  return p.MaxConcurrentClientNum
}
var ServerProperties_WatermarkSecretKey_DEFAULT string
func (p *ServerProperties) GetWatermarkSecretKey() string {
  if !p.IsSetWatermarkSecretKey() {
    return ServerProperties_WatermarkSecretKey_DEFAULT
  }
return *p.WatermarkSecretKey
}
var ServerProperties_WatermarkBitString_DEFAULT string
func (p *ServerProperties) GetWatermarkBitString() string {
  if !p.IsSetWatermarkBitString() {
    return ServerProperties_WatermarkBitString_DEFAULT
  }
return *p.WatermarkBitString
}
var ServerProperties_WatermarkParamMarkRate_DEFAULT int32
func (p *ServerProperties) GetWatermarkParamMarkRate() int32 {
  if !p.IsSetWatermarkParamMarkRate() {
    return ServerProperties_WatermarkParamMarkRate_DEFAULT
  }
return *p.WatermarkParamMarkRate
}
var ServerProperties_WatermarkParamMaxRightBit_DEFAULT int32
func (p *ServerProperties) GetWatermarkParamMaxRightBit() int32 {
  if !p.IsSetWatermarkParamMaxRightBit() {
    return ServerProperties_WatermarkParamMaxRightBit_DEFAULT
  }
return *p.WatermarkParamMaxRightBit
}
var ServerProperties_ThriftMaxFrameSize_DEFAULT int32
func (p *ServerProperties) GetThriftMaxFrameSize() int32 {
  if !p.IsSetThriftMaxFrameSize() {
    return ServerProperties_ThriftMaxFrameSize_DEFAULT
  }
return *p.ThriftMaxFrameSize
}
var ServerProperties_IsReadOnly_DEFAULT bool
func (p *ServerProperties) GetIsReadOnly() bool {
  if !p.IsSetIsReadOnly() {
    return ServerProperties_IsReadOnly_DEFAULT
  }
return *p.IsReadOnly
}
var ServerProperties_BuildInfo_DEFAULT string
func (p *ServerProperties) GetBuildInfo() string {
  if !p.IsSetBuildInfo() {
    return ServerProperties_BuildInfo_DEFAULT
  }
return *p.BuildInfo
}
func (p *ServerProperties) IsSetWatermarkSecretKey() bool {
  return p.WatermarkSecretKey != nil
}

func (p *ServerProperties) IsSetWatermarkBitString() bool {
  return p.WatermarkBitString != nil
}

func (p *ServerProperties) IsSetWatermarkParamMarkRate() bool {
  return p.WatermarkParamMarkRate != nil
}

func (p *ServerProperties) IsSetWatermarkParamMaxRightBit() bool {
  return p.WatermarkParamMaxRightBit != nil
}

func (p *ServerProperties) IsSetThriftMaxFrameSize() bool {
  return p.ThriftMaxFrameSize != nil
}

func (p *ServerProperties) IsSetIsReadOnly() bool {
  return p.IsReadOnly != nil
}

func (p *ServerProperties) IsSetBuildInfo() bool {
  return p.BuildInfo != nil
}

func (p *ServerProperties) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetVersion bool = false;
  var issetSupportedTimeAggregationOperations bool = false;
  var issetTimestampPrecision bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetVersion = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetSupportedTimeAggregationOperations = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetTimestampPrecision = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 8:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField8(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 9:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField9(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 10:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField10(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 11:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField11(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetVersion{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Version is not set"));
  }
  if !issetSupportedTimeAggregationOperations{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SupportedTimeAggregationOperations is not set"));
  }
  if !issetTimestampPrecision{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TimestampPrecision is not set"));
  }
  return nil
}

func (p *ServerProperties)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.Version = v
}
  return nil
}

func (p *ServerProperties)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.SupportedTimeAggregationOperations =  tSlice
  for i := 0; i < size; i ++ {
var _elem167 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem167 = v
}
    p.SupportedTimeAggregationOperations = append(p.SupportedTimeAggregationOperations, _elem167)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *ServerProperties)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.TimestampPrecision = v
}
  return nil
}

func (p *ServerProperties)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.MaxConcurrentClientNum = v
}
  return nil
}

func (p *ServerProperties)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 5: ", err)
} else {
  p.WatermarkSecretKey = &v
}
  return nil
}

func (p *ServerProperties)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 6: ", err)
} else {
  p.WatermarkBitString = &v
}
  return nil
}

func (p *ServerProperties)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 7: ", err)
} else {
  p.WatermarkParamMarkRate = &v
}
  return nil
}

func (p *ServerProperties)  ReadField8(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 8: ", err)
} else {
  p.WatermarkParamMaxRightBit = &v
}
  return nil
}

func (p *ServerProperties)  ReadField9(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 9: ", err)
} else {
  p.ThriftMaxFrameSize = &v
}
  return nil
}

func (p *ServerProperties)  ReadField10(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 10: ", err)
} else {
  p.IsReadOnly = &v
}
  return nil
}

func (p *ServerProperties)  ReadField11(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 11: ", err)
} else {
  p.BuildInfo = &v
}
  return nil
}

func (p *ServerProperties) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "ServerProperties"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
    if err := p.writeField8(ctx, oprot); err != nil { return err }
    if err := p.writeField9(ctx, oprot); err != nil { return err }
    if err := p.writeField10(ctx, oprot); err != nil { return err }
    if err := p.writeField11(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *ServerProperties) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "version", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:version: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Version)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.version (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:version: ", p), err) }
  return err
}

func (p *ServerProperties) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "supportedTimeAggregationOperations", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:supportedTimeAggregationOperations: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.SupportedTimeAggregationOperations)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.SupportedTimeAggregationOperations {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:supportedTimeAggregationOperations: ", p), err) }
  return err
}

func (p *ServerProperties) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "timestampPrecision", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:timestampPrecision: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TimestampPrecision)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.timestampPrecision (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:timestampPrecision: ", p), err) }
  return err
}

func (p *ServerProperties) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "maxConcurrentClientNum", thrift.I32, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:maxConcurrentClientNum: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.MaxConcurrentClientNum)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.maxConcurrentClientNum (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:maxConcurrentClientNum: ", p), err) }
  return err
}

func (p *ServerProperties) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetWatermarkSecretKey() {
    if err := oprot.WriteFieldBegin(ctx, "watermarkSecretKey", thrift.STRING, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:watermarkSecretKey: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.WatermarkSecretKey)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.watermarkSecretKey (5) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:watermarkSecretKey: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetWatermarkBitString() {
    if err := oprot.WriteFieldBegin(ctx, "watermarkBitString", thrift.STRING, 6); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:watermarkBitString: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.WatermarkBitString)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.watermarkBitString (6) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 6:watermarkBitString: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetWatermarkParamMarkRate() {
    if err := oprot.WriteFieldBegin(ctx, "watermarkParamMarkRate", thrift.I32, 7); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:watermarkParamMarkRate: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.WatermarkParamMarkRate)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.watermarkParamMarkRate (7) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 7:watermarkParamMarkRate: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField8(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetWatermarkParamMaxRightBit() {
    if err := oprot.WriteFieldBegin(ctx, "watermarkParamMaxRightBit", thrift.I32, 8); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 8:watermarkParamMaxRightBit: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.WatermarkParamMaxRightBit)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.watermarkParamMaxRightBit (8) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 8:watermarkParamMaxRightBit: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField9(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetThriftMaxFrameSize() {
    if err := oprot.WriteFieldBegin(ctx, "thriftMaxFrameSize", thrift.I32, 9); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 9:thriftMaxFrameSize: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.ThriftMaxFrameSize)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.thriftMaxFrameSize (9) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 9:thriftMaxFrameSize: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField10(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetIsReadOnly() {
    if err := oprot.WriteFieldBegin(ctx, "isReadOnly", thrift.BOOL, 10); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 10:isReadOnly: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.IsReadOnly)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.isReadOnly (10) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 10:isReadOnly: ", p), err) }
  }
  return err
}

func (p *ServerProperties) writeField11(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetBuildInfo() {
    if err := oprot.WriteFieldBegin(ctx, "buildInfo", thrift.STRING, 11); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 11:buildInfo: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.BuildInfo)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.buildInfo (11) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 11:buildInfo: ", p), err) }
  }
  return err
}

func (p *ServerProperties) Equals(other *ServerProperties) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.Version != other.Version { return false }
  if len(p.SupportedTimeAggregationOperations) != len(other.SupportedTimeAggregationOperations) { return false }
  for i, _tgt := range p.SupportedTimeAggregationOperations {
    _src168 := other.SupportedTimeAggregationOperations[i]
    if _tgt != _src168 { return false }
  }
  if p.TimestampPrecision != other.TimestampPrecision { return false }
  if p.MaxConcurrentClientNum != other.MaxConcurrentClientNum { return false }
  if p.WatermarkSecretKey != other.WatermarkSecretKey {
    if p.WatermarkSecretKey == nil || other.WatermarkSecretKey == nil {
      return false
    }
    if (*p.WatermarkSecretKey) != (*other.WatermarkSecretKey) { return false }
  }
  if p.WatermarkBitString != other.WatermarkBitString {
    if p.WatermarkBitString == nil || other.WatermarkBitString == nil {
      return false
    }
    if (*p.WatermarkBitString) != (*other.WatermarkBitString) { return false }
  }
  if p.WatermarkParamMarkRate != other.WatermarkParamMarkRate {
    if p.WatermarkParamMarkRate == nil || other.WatermarkParamMarkRate == nil {
      return false
    }
    if (*p.WatermarkParamMarkRate) != (*other.WatermarkParamMarkRate) { return false }
  }
  if p.WatermarkParamMaxRightBit != other.WatermarkParamMaxRightBit {
    if p.WatermarkParamMaxRightBit == nil || other.WatermarkParamMaxRightBit == nil {
      return false
    }
    if (*p.WatermarkParamMaxRightBit) != (*other.WatermarkParamMaxRightBit) { return false }
  }
  if p.ThriftMaxFrameSize != other.ThriftMaxFrameSize {
    if p.ThriftMaxFrameSize == nil || other.ThriftMaxFrameSize == nil {
      return false
    }
    if (*p.ThriftMaxFrameSize) != (*other.ThriftMaxFrameSize) { return false }
  }
  if p.IsReadOnly != other.IsReadOnly {
    if p.IsReadOnly == nil || other.IsReadOnly == nil {
      return false
    }
    if (*p.IsReadOnly) != (*other.IsReadOnly) { return false }
  }
  if p.BuildInfo != other.BuildInfo {
    if p.BuildInfo == nil || other.BuildInfo == nil {
      return false
    }
    if (*p.BuildInfo) != (*other.BuildInfo) { return false }
  }
  return true
}

func (p *ServerProperties) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("ServerProperties(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - TemplateName
//  - PrefixPath
type TSSetSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  TemplateName string `thrift:"templateName,2,required" db:"templateName" json:"templateName"`
  PrefixPath string `thrift:"prefixPath,3,required" db:"prefixPath" json:"prefixPath"`
}

func NewTSSetSchemaTemplateReq() *TSSetSchemaTemplateReq {
  return &TSSetSchemaTemplateReq{}
}


func (p *TSSetSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSSetSchemaTemplateReq) GetTemplateName() string {
  return p.TemplateName
}

func (p *TSSetSchemaTemplateReq) GetPrefixPath() string {
  return p.PrefixPath
}
func (p *TSSetSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetTemplateName bool = false;
  var issetPrefixPath bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetTemplateName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetTemplateName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TemplateName is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  return nil
}

func (p *TSSetSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSSetSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TemplateName = v
}
  return nil
}

func (p *TSSetSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSSetSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSSetSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSSetSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSSetSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "templateName", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:templateName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TemplateName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.templateName (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:templateName: ", p), err) }
  return err
}

func (p *TSSetSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:prefixPath: ", p), err) }
  return err
}

func (p *TSSetSchemaTemplateReq) Equals(other *TSSetSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.TemplateName != other.TemplateName { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  return true
}

func (p *TSSetSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSSetSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Name
//  - SerializedTemplate
type TSCreateSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Name string `thrift:"name,2,required" db:"name" json:"name"`
  SerializedTemplate []byte `thrift:"serializedTemplate,3,required" db:"serializedTemplate" json:"serializedTemplate"`
}

func NewTSCreateSchemaTemplateReq() *TSCreateSchemaTemplateReq {
  return &TSCreateSchemaTemplateReq{}
}


func (p *TSCreateSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSCreateSchemaTemplateReq) GetName() string {
  return p.Name
}

func (p *TSCreateSchemaTemplateReq) GetSerializedTemplate() []byte {
  return p.SerializedTemplate
}
func (p *TSCreateSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetName bool = false;
  var issetSerializedTemplate bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetSerializedTemplate = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"));
  }
  if !issetSerializedTemplate{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SerializedTemplate is not set"));
  }
  return nil
}

func (p *TSCreateSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSCreateSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Name = v
}
  return nil
}

func (p *TSCreateSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBinary(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.SerializedTemplate = v
}
  return nil
}

func (p *TSCreateSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSCreateSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSCreateSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSCreateSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:name: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.name (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:name: ", p), err) }
  return err
}

func (p *TSCreateSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "serializedTemplate", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:serializedTemplate: ", p), err) }
  if err := oprot.WriteBinary(ctx, p.SerializedTemplate); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.serializedTemplate (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:serializedTemplate: ", p), err) }
  return err
}

func (p *TSCreateSchemaTemplateReq) Equals(other *TSCreateSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Name != other.Name { return false }
  if bytes.Compare(p.SerializedTemplate, other.SerializedTemplate) != 0 { return false }
  return true
}

func (p *TSCreateSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSCreateSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Name
//  - IsAligned
//  - Measurements
//  - DataTypes
//  - Encodings
//  - Compressors
type TSAppendSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Name string `thrift:"name,2,required" db:"name" json:"name"`
  IsAligned bool `thrift:"isAligned,3,required" db:"isAligned" json:"isAligned"`
  Measurements []string `thrift:"measurements,4,required" db:"measurements" json:"measurements"`
  DataTypes []int32 `thrift:"dataTypes,5,required" db:"dataTypes" json:"dataTypes"`
  Encodings []int32 `thrift:"encodings,6,required" db:"encodings" json:"encodings"`
  Compressors []int32 `thrift:"compressors,7,required" db:"compressors" json:"compressors"`
}

func NewTSAppendSchemaTemplateReq() *TSAppendSchemaTemplateReq {
  return &TSAppendSchemaTemplateReq{}
}


func (p *TSAppendSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSAppendSchemaTemplateReq) GetName() string {
  return p.Name
}

func (p *TSAppendSchemaTemplateReq) GetIsAligned() bool {
  return p.IsAligned
}

func (p *TSAppendSchemaTemplateReq) GetMeasurements() []string {
  return p.Measurements
}

func (p *TSAppendSchemaTemplateReq) GetDataTypes() []int32 {
  return p.DataTypes
}

func (p *TSAppendSchemaTemplateReq) GetEncodings() []int32 {
  return p.Encodings
}

func (p *TSAppendSchemaTemplateReq) GetCompressors() []int32 {
  return p.Compressors
}
func (p *TSAppendSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetName bool = false;
  var issetIsAligned bool = false;
  var issetMeasurements bool = false;
  var issetDataTypes bool = false;
  var issetEncodings bool = false;
  var issetCompressors bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetIsAligned = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetMeasurements = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
        issetDataTypes = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 6:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField6(ctx, iprot); err != nil {
          return err
        }
        issetEncodings = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 7:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField7(ctx, iprot); err != nil {
          return err
        }
        issetCompressors = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"));
  }
  if !issetIsAligned{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field IsAligned is not set"));
  }
  if !issetMeasurements{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Measurements is not set"));
  }
  if !issetDataTypes{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DataTypes is not set"));
  }
  if !issetEncodings{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Encodings is not set"));
  }
  if !issetCompressors{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Compressors is not set"));
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Name = v
}
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.IsAligned = v
}
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem169 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem169 = v
}
    p.Measurements = append(p.Measurements, _elem169)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.DataTypes =  tSlice
  for i := 0; i < size; i ++ {
var _elem170 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem170 = v
}
    p.DataTypes = append(p.DataTypes, _elem170)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField6(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Encodings =  tSlice
  for i := 0; i < size; i ++ {
var _elem171 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem171 = v
}
    p.Encodings = append(p.Encodings, _elem171)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq)  ReadField7(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]int32, 0, size)
  p.Compressors =  tSlice
  for i := 0; i < size; i ++ {
var _elem172 int32
    if v, err := iprot.ReadI32(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem172 = v
}
    p.Compressors = append(p.Compressors, _elem172)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSAppendSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSAppendSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
    if err := p.writeField6(ctx, oprot); err != nil { return err }
    if err := p.writeField7(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSAppendSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:name: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.name (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:name: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "isAligned", thrift.BOOL, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:isAligned: ", p), err) }
  if err := oprot.WriteBool(ctx, bool(p.IsAligned)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.isAligned (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:isAligned: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:measurements: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Measurements {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:measurements: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "dataTypes", thrift.LIST, 5); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:dataTypes: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.DataTypes)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DataTypes {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 5:dataTypes: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField6(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "encodings", thrift.LIST, 6); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 6:encodings: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Encodings)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Encodings {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 6:encodings: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) writeField7(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "compressors", thrift.LIST, 7); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 7:compressors: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.I32, len(p.Compressors)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Compressors {
    if err := oprot.WriteI32(ctx, int32(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 7:compressors: ", p), err) }
  return err
}

func (p *TSAppendSchemaTemplateReq) Equals(other *TSAppendSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Name != other.Name { return false }
  if p.IsAligned != other.IsAligned { return false }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src173 := other.Measurements[i]
    if _tgt != _src173 { return false }
  }
  if len(p.DataTypes) != len(other.DataTypes) { return false }
  for i, _tgt := range p.DataTypes {
    _src174 := other.DataTypes[i]
    if _tgt != _src174 { return false }
  }
  if len(p.Encodings) != len(other.Encodings) { return false }
  for i, _tgt := range p.Encodings {
    _src175 := other.Encodings[i]
    if _tgt != _src175 { return false }
  }
  if len(p.Compressors) != len(other.Compressors) { return false }
  for i, _tgt := range p.Compressors {
    _src176 := other.Compressors[i]
    if _tgt != _src176 { return false }
  }
  return true
}

func (p *TSAppendSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSAppendSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Name
//  - Path
type TSPruneSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Name string `thrift:"name,2,required" db:"name" json:"name"`
  Path string `thrift:"path,3,required" db:"path" json:"path"`
}

func NewTSPruneSchemaTemplateReq() *TSPruneSchemaTemplateReq {
  return &TSPruneSchemaTemplateReq{}
}


func (p *TSPruneSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSPruneSchemaTemplateReq) GetName() string {
  return p.Name
}

func (p *TSPruneSchemaTemplateReq) GetPath() string {
  return p.Path
}
func (p *TSPruneSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetName bool = false;
  var issetPath bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"));
  }
  if !issetPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Path is not set"));
  }
  return nil
}

func (p *TSPruneSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSPruneSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Name = v
}
  return nil
}

func (p *TSPruneSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Path = v
}
  return nil
}

func (p *TSPruneSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSPruneSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSPruneSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSPruneSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:name: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.name (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:name: ", p), err) }
  return err
}

func (p *TSPruneSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:path: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Path)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.path (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:path: ", p), err) }
  return err
}

func (p *TSPruneSchemaTemplateReq) Equals(other *TSPruneSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Name != other.Name { return false }
  if p.Path != other.Path { return false }
  return true
}

func (p *TSPruneSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSPruneSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Name
//  - QueryType
//  - Measurement
type TSQueryTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  Name string `thrift:"name,2,required" db:"name" json:"name"`
  QueryType int32 `thrift:"queryType,3,required" db:"queryType" json:"queryType"`
  Measurement *string `thrift:"measurement,4" db:"measurement" json:"measurement,omitempty"`
}

func NewTSQueryTemplateReq() *TSQueryTemplateReq {
  return &TSQueryTemplateReq{}
}


func (p *TSQueryTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSQueryTemplateReq) GetName() string {
  return p.Name
}

func (p *TSQueryTemplateReq) GetQueryType() int32 {
  return p.QueryType
}
var TSQueryTemplateReq_Measurement_DEFAULT string
func (p *TSQueryTemplateReq) GetMeasurement() string {
  if !p.IsSetMeasurement() {
    return TSQueryTemplateReq_Measurement_DEFAULT
  }
return *p.Measurement
}
func (p *TSQueryTemplateReq) IsSetMeasurement() bool {
  return p.Measurement != nil
}

func (p *TSQueryTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetName bool = false;
  var issetQueryType bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetQueryType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Name is not set"));
  }
  if !issetQueryType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryType is not set"));
  }
  return nil
}

func (p *TSQueryTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSQueryTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.Name = v
}
  return nil
}

func (p *TSQueryTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.QueryType = v
}
  return nil
}

func (p *TSQueryTemplateReq)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Measurement = &v
}
  return nil
}

func (p *TSQueryTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSQueryTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSQueryTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSQueryTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:name: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.name (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:name: ", p), err) }
  return err
}

func (p *TSQueryTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryType", thrift.I32, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:queryType: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.QueryType)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryType (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:queryType: ", p), err) }
  return err
}

func (p *TSQueryTemplateReq) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurement() {
    if err := oprot.WriteFieldBegin(ctx, "measurement", thrift.STRING, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:measurement: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.Measurement)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.measurement (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:measurement: ", p), err) }
  }
  return err
}

func (p *TSQueryTemplateReq) Equals(other *TSQueryTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.Name != other.Name { return false }
  if p.QueryType != other.QueryType { return false }
  if p.Measurement != other.Measurement {
    if p.Measurement == nil || other.Measurement == nil {
      return false
    }
    if (*p.Measurement) != (*other.Measurement) { return false }
  }
  return true
}

func (p *TSQueryTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSQueryTemplateReq(%+v)", *p)
}

// Attributes:
//  - Status
//  - QueryType
//  - Result_
//  - Count
//  - Measurements
type TSQueryTemplateResp struct {
  Status *common.TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  QueryType int32 `thrift:"queryType,2,required" db:"queryType" json:"queryType"`
  Result_ *bool `thrift:"result,3" db:"result" json:"result,omitempty"`
  Count *int32 `thrift:"count,4" db:"count" json:"count,omitempty"`
  Measurements []string `thrift:"measurements,5" db:"measurements" json:"measurements,omitempty"`
}

func NewTSQueryTemplateResp() *TSQueryTemplateResp {
  return &TSQueryTemplateResp{}
}

var TSQueryTemplateResp_Status_DEFAULT *common.TSStatus
func (p *TSQueryTemplateResp) GetStatus() *common.TSStatus {
  if !p.IsSetStatus() {
    return TSQueryTemplateResp_Status_DEFAULT
  }
return p.Status
}

func (p *TSQueryTemplateResp) GetQueryType() int32 {
  return p.QueryType
}
var TSQueryTemplateResp_Result__DEFAULT bool
func (p *TSQueryTemplateResp) GetResult_() bool {
  if !p.IsSetResult_() {
    return TSQueryTemplateResp_Result__DEFAULT
  }
return *p.Result_
}
var TSQueryTemplateResp_Count_DEFAULT int32
func (p *TSQueryTemplateResp) GetCount() int32 {
  if !p.IsSetCount() {
    return TSQueryTemplateResp_Count_DEFAULT
  }
return *p.Count
}
var TSQueryTemplateResp_Measurements_DEFAULT []string

func (p *TSQueryTemplateResp) GetMeasurements() []string {
  return p.Measurements
}
func (p *TSQueryTemplateResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSQueryTemplateResp) IsSetResult_() bool {
  return p.Result_ != nil
}

func (p *TSQueryTemplateResp) IsSetCount() bool {
  return p.Count != nil
}

func (p *TSQueryTemplateResp) IsSetMeasurements() bool {
  return p.Measurements != nil
}

func (p *TSQueryTemplateResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;
  var issetQueryType bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetQueryType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 5:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField5(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  if !issetQueryType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field QueryType is not set"));
  }
  return nil
}

func (p *TSQueryTemplateResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &common.TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSQueryTemplateResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.QueryType = v
}
  return nil
}

func (p *TSQueryTemplateResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Result_ = &v
}
  return nil
}

func (p *TSQueryTemplateResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Count = &v
}
  return nil
}

func (p *TSQueryTemplateResp)  ReadField5(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Measurements =  tSlice
  for i := 0; i < size; i ++ {
var _elem177 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem177 = v
}
    p.Measurements = append(p.Measurements, _elem177)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSQueryTemplateResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSQueryTemplateResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
    if err := p.writeField5(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSQueryTemplateResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSQueryTemplateResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "queryType", thrift.I32, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:queryType: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.QueryType)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.queryType (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:queryType: ", p), err) }
  return err
}

func (p *TSQueryTemplateResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetResult_() {
    if err := oprot.WriteFieldBegin(ctx, "result", thrift.BOOL, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:result: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.Result_)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.result (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:result: ", p), err) }
  }
  return err
}

func (p *TSQueryTemplateResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetCount() {
    if err := oprot.WriteFieldBegin(ctx, "count", thrift.I32, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:count: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.Count)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.count (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:count: ", p), err) }
  }
  return err
}

func (p *TSQueryTemplateResp) writeField5(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetMeasurements() {
    if err := oprot.WriteFieldBegin(ctx, "measurements", thrift.LIST, 5); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 5:measurements: ", p), err) }
    if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Measurements)); err != nil {
      return thrift.PrependError("error writing list begin: ", err)
    }
    for _, v := range p.Measurements {
      if err := oprot.WriteString(ctx, string(v)); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
    }
    if err := oprot.WriteListEnd(ctx); err != nil {
      return thrift.PrependError("error writing list end: ", err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 5:measurements: ", p), err) }
  }
  return err
}

func (p *TSQueryTemplateResp) Equals(other *TSQueryTemplateResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.QueryType != other.QueryType { return false }
  if p.Result_ != other.Result_ {
    if p.Result_ == nil || other.Result_ == nil {
      return false
    }
    if (*p.Result_) != (*other.Result_) { return false }
  }
  if p.Count != other.Count {
    if p.Count == nil || other.Count == nil {
      return false
    }
    if (*p.Count) != (*other.Count) { return false }
  }
  if len(p.Measurements) != len(other.Measurements) { return false }
  for i, _tgt := range p.Measurements {
    _src178 := other.Measurements[i]
    if _tgt != _src178 { return false }
  }
  return true
}

func (p *TSQueryTemplateResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSQueryTemplateResp(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - PrefixPath
//  - TemplateName
type TSUnsetSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  PrefixPath string `thrift:"prefixPath,2,required" db:"prefixPath" json:"prefixPath"`
  TemplateName string `thrift:"templateName,3,required" db:"templateName" json:"templateName"`
}

func NewTSUnsetSchemaTemplateReq() *TSUnsetSchemaTemplateReq {
  return &TSUnsetSchemaTemplateReq{}
}


func (p *TSUnsetSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSUnsetSchemaTemplateReq) GetPrefixPath() string {
  return p.PrefixPath
}

func (p *TSUnsetSchemaTemplateReq) GetTemplateName() string {
  return p.TemplateName
}
func (p *TSUnsetSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetPrefixPath bool = false;
  var issetTemplateName bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetPrefixPath = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetTemplateName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetPrefixPath{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PrefixPath is not set"));
  }
  if !issetTemplateName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TemplateName is not set"));
  }
  return nil
}

func (p *TSUnsetSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSUnsetSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.PrefixPath = v
}
  return nil
}

func (p *TSUnsetSchemaTemplateReq)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.TemplateName = v
}
  return nil
}

func (p *TSUnsetSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSUnsetSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSUnsetSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSUnsetSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "prefixPath", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:prefixPath: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PrefixPath)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.prefixPath (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:prefixPath: ", p), err) }
  return err
}

func (p *TSUnsetSchemaTemplateReq) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "templateName", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:templateName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TemplateName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.templateName (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:templateName: ", p), err) }
  return err
}

func (p *TSUnsetSchemaTemplateReq) Equals(other *TSUnsetSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.PrefixPath != other.PrefixPath { return false }
  if p.TemplateName != other.TemplateName { return false }
  return true
}

func (p *TSUnsetSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSUnsetSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - TemplateName
type TSDropSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  TemplateName string `thrift:"templateName,2,required" db:"templateName" json:"templateName"`
}

func NewTSDropSchemaTemplateReq() *TSDropSchemaTemplateReq {
  return &TSDropSchemaTemplateReq{}
}


func (p *TSDropSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TSDropSchemaTemplateReq) GetTemplateName() string {
  return p.TemplateName
}
func (p *TSDropSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetTemplateName bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetTemplateName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetTemplateName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field TemplateName is not set"));
  }
  return nil
}

func (p *TSDropSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TSDropSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.TemplateName = v
}
  return nil
}

func (p *TSDropSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSDropSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSDropSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TSDropSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "templateName", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:templateName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.TemplateName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.templateName (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:templateName: ", p), err) }
  return err
}

func (p *TSDropSchemaTemplateReq) Equals(other *TSDropSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if p.TemplateName != other.TemplateName { return false }
  return true
}

func (p *TSDropSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSDropSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - DevicePathList
type TCreateTimeseriesUsingSchemaTemplateReq struct {
  SessionId int64 `thrift:"sessionId,1,required" db:"sessionId" json:"sessionId"`
  DevicePathList []string `thrift:"devicePathList,2,required" db:"devicePathList" json:"devicePathList"`
}

func NewTCreateTimeseriesUsingSchemaTemplateReq() *TCreateTimeseriesUsingSchemaTemplateReq {
  return &TCreateTimeseriesUsingSchemaTemplateReq{}
}


func (p *TCreateTimeseriesUsingSchemaTemplateReq) GetSessionId() int64 {
  return p.SessionId
}

func (p *TCreateTimeseriesUsingSchemaTemplateReq) GetDevicePathList() []string {
  return p.DevicePathList
}
func (p *TCreateTimeseriesUsingSchemaTemplateReq) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetSessionId bool = false;
  var issetDevicePathList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetSessionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetDevicePathList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetSessionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field SessionId is not set"));
  }
  if !issetDevicePathList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field DevicePathList is not set"));
  }
  return nil
}

func (p *TCreateTimeseriesUsingSchemaTemplateReq)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *TCreateTimeseriesUsingSchemaTemplateReq)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.DevicePathList =  tSlice
  for i := 0; i < size; i ++ {
var _elem179 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem179 = v
}
    p.DevicePathList = append(p.DevicePathList, _elem179)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TCreateTimeseriesUsingSchemaTemplateReq) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TCreateTimeseriesUsingSchemaTemplateReq"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TCreateTimeseriesUsingSchemaTemplateReq) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *TCreateTimeseriesUsingSchemaTemplateReq) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "devicePathList", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:devicePathList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.DevicePathList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.DevicePathList {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:devicePathList: ", p), err) }
  return err
}

func (p *TCreateTimeseriesUsingSchemaTemplateReq) Equals(other *TCreateTimeseriesUsingSchemaTemplateReq) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.SessionId != other.SessionId { return false }
  if len(p.DevicePathList) != len(other.DevicePathList) { return false }
  for i, _tgt := range p.DevicePathList {
    _src180 := other.DevicePathList[i]
    if _tgt != _src180 { return false }
  }
  return true
}

func (p *TCreateTimeseriesUsingSchemaTemplateReq) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TCreateTimeseriesUsingSchemaTemplateReq(%+v)", *p)
}

// Attributes:
//  - PipeName
//  - CreateTime
//  - Version
//  - Database
type TSyncIdentityInfo struct {
  PipeName string `thrift:"pipeName,1,required" db:"pipeName" json:"pipeName"`
  CreateTime int64 `thrift:"createTime,2,required" db:"createTime" json:"createTime"`
  Version string `thrift:"version,3,required" db:"version" json:"version"`
  Database string `thrift:"database,4,required" db:"database" json:"database"`
}

func NewTSyncIdentityInfo() *TSyncIdentityInfo {
  return &TSyncIdentityInfo{}
}


func (p *TSyncIdentityInfo) GetPipeName() string {
  return p.PipeName
}

func (p *TSyncIdentityInfo) GetCreateTime() int64 {
  return p.CreateTime
}

func (p *TSyncIdentityInfo) GetVersion() string {
  return p.Version
}

func (p *TSyncIdentityInfo) GetDatabase() string {
  return p.Database
}
func (p *TSyncIdentityInfo) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetPipeName bool = false;
  var issetCreateTime bool = false;
  var issetVersion bool = false;
  var issetDatabase bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetPipeName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetCreateTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetVersion = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetDatabase = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetPipeName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field PipeName is not set"));
  }
  if !issetCreateTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field CreateTime is not set"));
  }
  if !issetVersion{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Version is not set"));
  }
  if !issetDatabase{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Database is not set"));
  }
  return nil
}

func (p *TSyncIdentityInfo)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.PipeName = v
}
  return nil
}

func (p *TSyncIdentityInfo)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.CreateTime = v
}
  return nil
}

func (p *TSyncIdentityInfo)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.Version = v
}
  return nil
}

func (p *TSyncIdentityInfo)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.Database = v
}
  return nil
}

func (p *TSyncIdentityInfo) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSyncIdentityInfo"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSyncIdentityInfo) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "pipeName", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:pipeName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.PipeName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.pipeName (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:pipeName: ", p), err) }
  return err
}

func (p *TSyncIdentityInfo) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "createTime", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:createTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.CreateTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.createTime (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:createTime: ", p), err) }
  return err
}

func (p *TSyncIdentityInfo) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "version", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:version: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Version)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.version (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:version: ", p), err) }
  return err
}

func (p *TSyncIdentityInfo) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "database", thrift.STRING, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:database: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.Database)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.database (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:database: ", p), err) }
  return err
}

func (p *TSyncIdentityInfo) Equals(other *TSyncIdentityInfo) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.PipeName != other.PipeName { return false }
  if p.CreateTime != other.CreateTime { return false }
  if p.Version != other.Version { return false }
  if p.Database != other.Database { return false }
  return true
}

func (p *TSyncIdentityInfo) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSyncIdentityInfo(%+v)", *p)
}

// Attributes:
//  - FileName
//  - StartIndex
type TSyncTransportMetaInfo struct {
  FileName string `thrift:"fileName,1,required" db:"fileName" json:"fileName"`
  StartIndex int64 `thrift:"startIndex,2,required" db:"startIndex" json:"startIndex"`
}

func NewTSyncTransportMetaInfo() *TSyncTransportMetaInfo {
  return &TSyncTransportMetaInfo{}
}


func (p *TSyncTransportMetaInfo) GetFileName() string {
  return p.FileName
}

func (p *TSyncTransportMetaInfo) GetStartIndex() int64 {
  return p.StartIndex
}
func (p *TSyncTransportMetaInfo) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetFileName bool = false;
  var issetStartIndex bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetFileName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetStartIndex = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetFileName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field FileName is not set"));
  }
  if !issetStartIndex{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field StartIndex is not set"));
  }
  return nil
}

func (p *TSyncTransportMetaInfo)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.FileName = v
}
  return nil
}

func (p *TSyncTransportMetaInfo)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.StartIndex = v
}
  return nil
}

func (p *TSyncTransportMetaInfo) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSyncTransportMetaInfo"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSyncTransportMetaInfo) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "fileName", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:fileName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.FileName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.fileName (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:fileName: ", p), err) }
  return err
}

func (p *TSyncTransportMetaInfo) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "startIndex", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:startIndex: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.StartIndex)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.startIndex (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:startIndex: ", p), err) }
  return err
}

func (p *TSyncTransportMetaInfo) Equals(other *TSyncTransportMetaInfo) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.FileName != other.FileName { return false }
  if p.StartIndex != other.StartIndex { return false }
  return true
}

func (p *TSyncTransportMetaInfo) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSyncTransportMetaInfo(%+v)", *p)
}

// Attributes:
//  - Status
//  - EnableOperationSync
//  - SecondaryAddress
//  - SecondaryPort
type TSBackupConfigurationResp struct {
  Status *common.TSStatus `thrift:"status,1,required" db:"status" json:"status"`
  EnableOperationSync *bool `thrift:"enableOperationSync,2" db:"enableOperationSync" json:"enableOperationSync,omitempty"`
  SecondaryAddress *string `thrift:"secondaryAddress,3" db:"secondaryAddress" json:"secondaryAddress,omitempty"`
  SecondaryPort *int32 `thrift:"secondaryPort,4" db:"secondaryPort" json:"secondaryPort,omitempty"`
}

func NewTSBackupConfigurationResp() *TSBackupConfigurationResp {
  return &TSBackupConfigurationResp{}
}

var TSBackupConfigurationResp_Status_DEFAULT *common.TSStatus
func (p *TSBackupConfigurationResp) GetStatus() *common.TSStatus {
  if !p.IsSetStatus() {
    return TSBackupConfigurationResp_Status_DEFAULT
  }
return p.Status
}
var TSBackupConfigurationResp_EnableOperationSync_DEFAULT bool
func (p *TSBackupConfigurationResp) GetEnableOperationSync() bool {
  if !p.IsSetEnableOperationSync() {
    return TSBackupConfigurationResp_EnableOperationSync_DEFAULT
  }
return *p.EnableOperationSync
}
var TSBackupConfigurationResp_SecondaryAddress_DEFAULT string
func (p *TSBackupConfigurationResp) GetSecondaryAddress() string {
  if !p.IsSetSecondaryAddress() {
    return TSBackupConfigurationResp_SecondaryAddress_DEFAULT
  }
return *p.SecondaryAddress
}
var TSBackupConfigurationResp_SecondaryPort_DEFAULT int32
func (p *TSBackupConfigurationResp) GetSecondaryPort() int32 {
  if !p.IsSetSecondaryPort() {
    return TSBackupConfigurationResp_SecondaryPort_DEFAULT
  }
return *p.SecondaryPort
}
func (p *TSBackupConfigurationResp) IsSetStatus() bool {
  return p.Status != nil
}

func (p *TSBackupConfigurationResp) IsSetEnableOperationSync() bool {
  return p.EnableOperationSync != nil
}

func (p *TSBackupConfigurationResp) IsSetSecondaryAddress() bool {
  return p.SecondaryAddress != nil
}

func (p *TSBackupConfigurationResp) IsSetSecondaryPort() bool {
  return p.SecondaryPort != nil
}

func (p *TSBackupConfigurationResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetStatus bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetStatus = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.BOOL {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetStatus{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Status is not set"));
  }
  return nil
}

func (p *TSBackupConfigurationResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Status = &common.TSStatus{}
  if err := p.Status.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
  }
  return nil
}

func (p *TSBackupConfigurationResp)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadBool(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.EnableOperationSync = &v
}
  return nil
}

func (p *TSBackupConfigurationResp)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.SecondaryAddress = &v
}
  return nil
}

func (p *TSBackupConfigurationResp)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  p.SecondaryPort = &v
}
  return nil
}

func (p *TSBackupConfigurationResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSBackupConfigurationResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSBackupConfigurationResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err) }
  if err := p.Status.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err) }
  return err
}

func (p *TSBackupConfigurationResp) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetEnableOperationSync() {
    if err := oprot.WriteFieldBegin(ctx, "enableOperationSync", thrift.BOOL, 2); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:enableOperationSync: ", p), err) }
    if err := oprot.WriteBool(ctx, bool(*p.EnableOperationSync)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.enableOperationSync (2) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 2:enableOperationSync: ", p), err) }
  }
  return err
}

func (p *TSBackupConfigurationResp) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSecondaryAddress() {
    if err := oprot.WriteFieldBegin(ctx, "secondaryAddress", thrift.STRING, 3); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:secondaryAddress: ", p), err) }
    if err := oprot.WriteString(ctx, string(*p.SecondaryAddress)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.secondaryAddress (3) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 3:secondaryAddress: ", p), err) }
  }
  return err
}

func (p *TSBackupConfigurationResp) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSecondaryPort() {
    if err := oprot.WriteFieldBegin(ctx, "secondaryPort", thrift.I32, 4); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:secondaryPort: ", p), err) }
    if err := oprot.WriteI32(ctx, int32(*p.SecondaryPort)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T.secondaryPort (4) field write error: ", p), err) }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 4:secondaryPort: ", p), err) }
  }
  return err
}

func (p *TSBackupConfigurationResp) Equals(other *TSBackupConfigurationResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if !p.Status.Equals(other.Status) { return false }
  if p.EnableOperationSync != other.EnableOperationSync {
    if p.EnableOperationSync == nil || other.EnableOperationSync == nil {
      return false
    }
    if (*p.EnableOperationSync) != (*other.EnableOperationSync) { return false }
  }
  if p.SecondaryAddress != other.SecondaryAddress {
    if p.SecondaryAddress == nil || other.SecondaryAddress == nil {
      return false
    }
    if (*p.SecondaryAddress) != (*other.SecondaryAddress) { return false }
  }
  if p.SecondaryPort != other.SecondaryPort {
    if p.SecondaryPort == nil || other.SecondaryPort == nil {
      return false
    }
    if (*p.SecondaryPort) != (*other.SecondaryPort) { return false }
  }
  return true
}

func (p *TSBackupConfigurationResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSBackupConfigurationResp(%+v)", *p)
}

// Attributes:
//  - UserName
//  - LogInTime
//  - ConnectionId
//  - Type
type TSConnectionInfo struct {
  UserName string `thrift:"userName,1,required" db:"userName" json:"userName"`
  LogInTime int64 `thrift:"logInTime,2,required" db:"logInTime" json:"logInTime"`
  ConnectionId string `thrift:"connectionId,3,required" db:"connectionId" json:"connectionId"`
  Type TSConnectionType `thrift:"type,4,required" db:"type" json:"type"`
}

func NewTSConnectionInfo() *TSConnectionInfo {
  return &TSConnectionInfo{}
}


func (p *TSConnectionInfo) GetUserName() string {
  return p.UserName
}

func (p *TSConnectionInfo) GetLogInTime() int64 {
  return p.LogInTime
}

func (p *TSConnectionInfo) GetConnectionId() string {
  return p.ConnectionId
}

func (p *TSConnectionInfo) GetType() TSConnectionType {
  return p.Type
}
func (p *TSConnectionInfo) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetUserName bool = false;
  var issetLogInTime bool = false;
  var issetConnectionId bool = false;
  var issetType bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetUserName = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
        issetLogInTime = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 3:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField3(ctx, iprot); err != nil {
          return err
        }
        issetConnectionId = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 4:
      if fieldTypeId == thrift.I32 {
        if err := p.ReadField4(ctx, iprot); err != nil {
          return err
        }
        issetType = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetUserName{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field UserName is not set"));
  }
  if !issetLogInTime{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field LogInTime is not set"));
  }
  if !issetConnectionId{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ConnectionId is not set"));
  }
  if !issetType{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field Type is not set"));
  }
  return nil
}

func (p *TSConnectionInfo)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.UserName = v
}
  return nil
}

func (p *TSConnectionInfo)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.LogInTime = v
}
  return nil
}

func (p *TSConnectionInfo)  ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 3: ", err)
} else {
  p.ConnectionId = v
}
  return nil
}

func (p *TSConnectionInfo)  ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI32(ctx); err != nil {
  return thrift.PrependError("error reading field 4: ", err)
} else {
  temp := TSConnectionType(v)
  p.Type = temp
}
  return nil
}

func (p *TSConnectionInfo) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSConnectionInfo"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
    if err := p.writeField3(ctx, oprot); err != nil { return err }
    if err := p.writeField4(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSConnectionInfo) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "userName", thrift.STRING, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:userName: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.UserName)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.userName (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:userName: ", p), err) }
  return err
}

func (p *TSConnectionInfo) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "logInTime", thrift.I64, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:logInTime: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.LogInTime)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.logInTime (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:logInTime: ", p), err) }
  return err
}

func (p *TSConnectionInfo) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "connectionId", thrift.STRING, 3); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:connectionId: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.ConnectionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.connectionId (3) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 3:connectionId: ", p), err) }
  return err
}

func (p *TSConnectionInfo) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "type", thrift.I32, 4); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:type: ", p), err) }
  if err := oprot.WriteI32(ctx, int32(p.Type)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.type (4) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 4:type: ", p), err) }
  return err
}

func (p *TSConnectionInfo) Equals(other *TSConnectionInfo) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if p.UserName != other.UserName { return false }
  if p.LogInTime != other.LogInTime { return false }
  if p.ConnectionId != other.ConnectionId { return false }
  if p.Type != other.Type { return false }
  return true
}

func (p *TSConnectionInfo) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSConnectionInfo(%+v)", *p)
}

// Attributes:
//  - ConnectionInfoList
type TSConnectionInfoResp struct {
  ConnectionInfoList []*TSConnectionInfo `thrift:"connectionInfoList,1,required" db:"connectionInfoList" json:"connectionInfoList"`
}

func NewTSConnectionInfoResp() *TSConnectionInfoResp {
  return &TSConnectionInfoResp{}
}


func (p *TSConnectionInfoResp) GetConnectionInfoList() []*TSConnectionInfo {
  return p.ConnectionInfoList
}
func (p *TSConnectionInfoResp) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }

  var issetConnectionInfoList bool = false;

  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
        issetConnectionInfoList = true
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  if !issetConnectionInfoList{
    return thrift.NewTProtocolExceptionWithType(thrift.INVALID_DATA, fmt.Errorf("Required field ConnectionInfoList is not set"));
  }
  return nil
}

func (p *TSConnectionInfoResp)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]*TSConnectionInfo, 0, size)
  p.ConnectionInfoList =  tSlice
  for i := 0; i < size; i ++ {
    _elem181 := &TSConnectionInfo{}
    if err := _elem181.Read(ctx, iprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _elem181), err)
    }
    p.ConnectionInfoList = append(p.ConnectionInfoList, _elem181)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *TSConnectionInfoResp) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "TSConnectionInfoResp"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *TSConnectionInfoResp) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "connectionInfoList", thrift.LIST, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:connectionInfoList: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRUCT, len(p.ConnectionInfoList)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.ConnectionInfoList {
    if err := v.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
    }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:connectionInfoList: ", p), err) }
  return err
}

func (p *TSConnectionInfoResp) Equals(other *TSConnectionInfoResp) bool {
  if p == other {
    return true
  } else if p == nil || other == nil {
    return false
  }
  if len(p.ConnectionInfoList) != len(other.ConnectionInfoList) { return false }
  for i, _tgt := range p.ConnectionInfoList {
    _src182 := other.ConnectionInfoList[i]
    if !_tgt.Equals(_src182) { return false }
  }
  return true
}

func (p *TSConnectionInfoResp) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("TSConnectionInfoResp(%+v)", *p)
}

type IClientRPCService interface {
  // Parameters:
  //  - Req
  ExecuteQueryStatementV2(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteUpdateStatementV2(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteStatementV2(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteRawDataQueryV2(ctx context.Context, req *TSRawDataQueryReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteLastDataQueryV2(ctx context.Context, req *TSLastDataQueryReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteAggregationQueryV2(ctx context.Context, req *TSAggregationQueryReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  FetchResultsV2(ctx context.Context, req *TSFetchResultsReq) (_r *TSFetchResultsResp, _err error)
  // Parameters:
  //  - Req
  OpenSession(ctx context.Context, req *TSOpenSessionReq) (_r *TSOpenSessionResp, _err error)
  // Parameters:
  //  - Req
  CloseSession(ctx context.Context, req *TSCloseSessionReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  ExecuteStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteBatchStatement(ctx context.Context, req *TSExecuteBatchStatementReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  ExecuteQueryStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteUpdateStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  FetchResults(ctx context.Context, req *TSFetchResultsReq) (_r *TSFetchResultsResp, _err error)
  // Parameters:
  //  - Req
  FetchMetadata(ctx context.Context, req *TSFetchMetadataReq) (_r *TSFetchMetadataResp, _err error)
  // Parameters:
  //  - Req
  CancelOperation(ctx context.Context, req *TSCancelOperationReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  CloseOperation(ctx context.Context, req *TSCloseOperationReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - SessionId
  GetTimeZone(ctx context.Context, sessionId int64) (_r *TSGetTimeZoneResp, _err error)
  // Parameters:
  //  - Req
  SetTimeZone(ctx context.Context, req *TSSetTimeZoneReq) (_r *common.TSStatus, _err error)
  GetProperties(ctx context.Context) (_r *ServerProperties, _err error)
  // Parameters:
  //  - SessionId
  //  - StorageGroup
  SetStorageGroup(ctx context.Context, sessionId int64, storageGroup string) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  CreateTimeseries(ctx context.Context, req *TSCreateTimeseriesReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  CreateAlignedTimeseries(ctx context.Context, req *TSCreateAlignedTimeseriesReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  CreateMultiTimeseries(ctx context.Context, req *TSCreateMultiTimeseriesReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - SessionId
  //  - Path
  DeleteTimeseries(ctx context.Context, sessionId int64, path []string) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - SessionId
  //  - StorageGroup
  DeleteStorageGroups(ctx context.Context, sessionId int64, storageGroup []string) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertStringRecordsOfOneDevice(ctx context.Context, req *TSInsertStringRecordsOfOneDeviceReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  InsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  TestInsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  DeleteData(ctx context.Context, req *TSDeleteDataReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  ExecuteRawDataQuery(ctx context.Context, req *TSRawDataQueryReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteLastDataQuery(ctx context.Context, req *TSLastDataQueryReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - Req
  ExecuteAggregationQuery(ctx context.Context, req *TSAggregationQueryReq) (_r *TSExecuteStatementResp, _err error)
  // Parameters:
  //  - SessionId
  RequestStatementId(ctx context.Context, sessionId int64) (_r int64, _err error)
  // Parameters:
  //  - Req
  CreateSchemaTemplate(ctx context.Context, req *TSCreateSchemaTemplateReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  AppendSchemaTemplate(ctx context.Context, req *TSAppendSchemaTemplateReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  PruneSchemaTemplate(ctx context.Context, req *TSPruneSchemaTemplateReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  QuerySchemaTemplate(ctx context.Context, req *TSQueryTemplateReq) (_r *TSQueryTemplateResp, _err error)
  // Parameters:
  //  - Req
  SetSchemaTemplate(ctx context.Context, req *TSSetSchemaTemplateReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  UnsetSchemaTemplate(ctx context.Context, req *TSUnsetSchemaTemplateReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  DropSchemaTemplate(ctx context.Context, req *TSDropSchemaTemplateReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Req
  CreateTimeseriesUsingSchemaTemplate(ctx context.Context, req *TCreateTimeseriesUsingSchemaTemplateReq) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Info
  Handshake(ctx context.Context, info *TSyncIdentityInfo) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - Buff
  SendPipeData(ctx context.Context, buff []byte) (_r *common.TSStatus, _err error)
  // Parameters:
  //  - MetaInfo
  //  - Buff
  SendFile(ctx context.Context, metaInfo *TSyncTransportMetaInfo, buff []byte) (_r *common.TSStatus, _err error)
  GetBackupConfiguration(ctx context.Context) (_r *TSBackupConfigurationResp, _err error)
  FetchAllConnectionsInfo(ctx context.Context) (_r *TSConnectionInfoResp, _err error)
}

type IClientRPCServiceClient struct {
  c thrift.TClient
  meta thrift.ResponseMeta
}

func NewIClientRPCServiceClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *IClientRPCServiceClient {
  return &IClientRPCServiceClient{
    c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
  }
}

func NewIClientRPCServiceClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *IClientRPCServiceClient {
  return &IClientRPCServiceClient{
    c: thrift.NewTStandardClient(iprot, oprot),
  }
}

func NewIClientRPCServiceClient(c thrift.TClient) *IClientRPCServiceClient {
  return &IClientRPCServiceClient{
    c: c,
  }
}

func (p *IClientRPCServiceClient) Client_() thrift.TClient {
  return p.c
}

func (p *IClientRPCServiceClient) LastResponseMeta_() thrift.ResponseMeta {
  return p.meta
}

func (p *IClientRPCServiceClient) SetLastResponseMeta_(meta thrift.ResponseMeta) {
  p.meta = meta
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteQueryStatementV2(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args183 IClientRPCServiceExecuteQueryStatementV2Args
  _args183.Req = req
  var _result185 IClientRPCServiceExecuteQueryStatementV2Result
  var _meta184 thrift.ResponseMeta
  _meta184, _err = p.Client_().Call(ctx, "executeQueryStatementV2", &_args183, &_result185)
  p.SetLastResponseMeta_(_meta184)
  if _err != nil {
    return
  }
  return _result185.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteUpdateStatementV2(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args186 IClientRPCServiceExecuteUpdateStatementV2Args
  _args186.Req = req
  var _result188 IClientRPCServiceExecuteUpdateStatementV2Result
  var _meta187 thrift.ResponseMeta
  _meta187, _err = p.Client_().Call(ctx, "executeUpdateStatementV2", &_args186, &_result188)
  p.SetLastResponseMeta_(_meta187)
  if _err != nil {
    return
  }
  return _result188.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteStatementV2(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args189 IClientRPCServiceExecuteStatementV2Args
  _args189.Req = req
  var _result191 IClientRPCServiceExecuteStatementV2Result
  var _meta190 thrift.ResponseMeta
  _meta190, _err = p.Client_().Call(ctx, "executeStatementV2", &_args189, &_result191)
  p.SetLastResponseMeta_(_meta190)
  if _err != nil {
    return
  }
  return _result191.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteRawDataQueryV2(ctx context.Context, req *TSRawDataQueryReq) (_r *TSExecuteStatementResp, _err error) {
  var _args192 IClientRPCServiceExecuteRawDataQueryV2Args
  _args192.Req = req
  var _result194 IClientRPCServiceExecuteRawDataQueryV2Result
  var _meta193 thrift.ResponseMeta
  _meta193, _err = p.Client_().Call(ctx, "executeRawDataQueryV2", &_args192, &_result194)
  p.SetLastResponseMeta_(_meta193)
  if _err != nil {
    return
  }
  return _result194.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteLastDataQueryV2(ctx context.Context, req *TSLastDataQueryReq) (_r *TSExecuteStatementResp, _err error) {
  var _args195 IClientRPCServiceExecuteLastDataQueryV2Args
  _args195.Req = req
  var _result197 IClientRPCServiceExecuteLastDataQueryV2Result
  var _meta196 thrift.ResponseMeta
  _meta196, _err = p.Client_().Call(ctx, "executeLastDataQueryV2", &_args195, &_result197)
  p.SetLastResponseMeta_(_meta196)
  if _err != nil {
    return
  }
  return _result197.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteAggregationQueryV2(ctx context.Context, req *TSAggregationQueryReq) (_r *TSExecuteStatementResp, _err error) {
  var _args198 IClientRPCServiceExecuteAggregationQueryV2Args
  _args198.Req = req
  var _result200 IClientRPCServiceExecuteAggregationQueryV2Result
  var _meta199 thrift.ResponseMeta
  _meta199, _err = p.Client_().Call(ctx, "executeAggregationQueryV2", &_args198, &_result200)
  p.SetLastResponseMeta_(_meta199)
  if _err != nil {
    return
  }
  return _result200.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) FetchResultsV2(ctx context.Context, req *TSFetchResultsReq) (_r *TSFetchResultsResp, _err error) {
  var _args201 IClientRPCServiceFetchResultsV2Args
  _args201.Req = req
  var _result203 IClientRPCServiceFetchResultsV2Result
  var _meta202 thrift.ResponseMeta
  _meta202, _err = p.Client_().Call(ctx, "fetchResultsV2", &_args201, &_result203)
  p.SetLastResponseMeta_(_meta202)
  if _err != nil {
    return
  }
  return _result203.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) OpenSession(ctx context.Context, req *TSOpenSessionReq) (_r *TSOpenSessionResp, _err error) {
  var _args204 IClientRPCServiceOpenSessionArgs
  _args204.Req = req
  var _result206 IClientRPCServiceOpenSessionResult
  var _meta205 thrift.ResponseMeta
  _meta205, _err = p.Client_().Call(ctx, "openSession", &_args204, &_result206)
  p.SetLastResponseMeta_(_meta205)
  if _err != nil {
    return
  }
  return _result206.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) CloseSession(ctx context.Context, req *TSCloseSessionReq) (_r *common.TSStatus, _err error) {
  var _args207 IClientRPCServiceCloseSessionArgs
  _args207.Req = req
  var _result209 IClientRPCServiceCloseSessionResult
  var _meta208 thrift.ResponseMeta
  _meta208, _err = p.Client_().Call(ctx, "closeSession", &_args207, &_result209)
  p.SetLastResponseMeta_(_meta208)
  if _err != nil {
    return
  }
  return _result209.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args210 IClientRPCServiceExecuteStatementArgs
  _args210.Req = req
  var _result212 IClientRPCServiceExecuteStatementResult
  var _meta211 thrift.ResponseMeta
  _meta211, _err = p.Client_().Call(ctx, "executeStatement", &_args210, &_result212)
  p.SetLastResponseMeta_(_meta211)
  if _err != nil {
    return
  }
  return _result212.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteBatchStatement(ctx context.Context, req *TSExecuteBatchStatementReq) (_r *common.TSStatus, _err error) {
  var _args213 IClientRPCServiceExecuteBatchStatementArgs
  _args213.Req = req
  var _result215 IClientRPCServiceExecuteBatchStatementResult
  var _meta214 thrift.ResponseMeta
  _meta214, _err = p.Client_().Call(ctx, "executeBatchStatement", &_args213, &_result215)
  p.SetLastResponseMeta_(_meta214)
  if _err != nil {
    return
  }
  return _result215.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteQueryStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args216 IClientRPCServiceExecuteQueryStatementArgs
  _args216.Req = req
  var _result218 IClientRPCServiceExecuteQueryStatementResult
  var _meta217 thrift.ResponseMeta
  _meta217, _err = p.Client_().Call(ctx, "executeQueryStatement", &_args216, &_result218)
  p.SetLastResponseMeta_(_meta217)
  if _err != nil {
    return
  }
  return _result218.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteUpdateStatement(ctx context.Context, req *TSExecuteStatementReq) (_r *TSExecuteStatementResp, _err error) {
  var _args219 IClientRPCServiceExecuteUpdateStatementArgs
  _args219.Req = req
  var _result221 IClientRPCServiceExecuteUpdateStatementResult
  var _meta220 thrift.ResponseMeta
  _meta220, _err = p.Client_().Call(ctx, "executeUpdateStatement", &_args219, &_result221)
  p.SetLastResponseMeta_(_meta220)
  if _err != nil {
    return
  }
  return _result221.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) FetchResults(ctx context.Context, req *TSFetchResultsReq) (_r *TSFetchResultsResp, _err error) {
  var _args222 IClientRPCServiceFetchResultsArgs
  _args222.Req = req
  var _result224 IClientRPCServiceFetchResultsResult
  var _meta223 thrift.ResponseMeta
  _meta223, _err = p.Client_().Call(ctx, "fetchResults", &_args222, &_result224)
  p.SetLastResponseMeta_(_meta223)
  if _err != nil {
    return
  }
  return _result224.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) FetchMetadata(ctx context.Context, req *TSFetchMetadataReq) (_r *TSFetchMetadataResp, _err error) {
  var _args225 IClientRPCServiceFetchMetadataArgs
  _args225.Req = req
  var _result227 IClientRPCServiceFetchMetadataResult
  var _meta226 thrift.ResponseMeta
  _meta226, _err = p.Client_().Call(ctx, "fetchMetadata", &_args225, &_result227)
  p.SetLastResponseMeta_(_meta226)
  if _err != nil {
    return
  }
  return _result227.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) CancelOperation(ctx context.Context, req *TSCancelOperationReq) (_r *common.TSStatus, _err error) {
  var _args228 IClientRPCServiceCancelOperationArgs
  _args228.Req = req
  var _result230 IClientRPCServiceCancelOperationResult
  var _meta229 thrift.ResponseMeta
  _meta229, _err = p.Client_().Call(ctx, "cancelOperation", &_args228, &_result230)
  p.SetLastResponseMeta_(_meta229)
  if _err != nil {
    return
  }
  return _result230.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) CloseOperation(ctx context.Context, req *TSCloseOperationReq) (_r *common.TSStatus, _err error) {
  var _args231 IClientRPCServiceCloseOperationArgs
  _args231.Req = req
  var _result233 IClientRPCServiceCloseOperationResult
  var _meta232 thrift.ResponseMeta
  _meta232, _err = p.Client_().Call(ctx, "closeOperation", &_args231, &_result233)
  p.SetLastResponseMeta_(_meta232)
  if _err != nil {
    return
  }
  return _result233.GetSuccess(), nil
}

// Parameters:
//  - SessionId
func (p *IClientRPCServiceClient) GetTimeZone(ctx context.Context, sessionId int64) (_r *TSGetTimeZoneResp, _err error) {
  var _args234 IClientRPCServiceGetTimeZoneArgs
  _args234.SessionId = sessionId
  var _result236 IClientRPCServiceGetTimeZoneResult
  var _meta235 thrift.ResponseMeta
  _meta235, _err = p.Client_().Call(ctx, "getTimeZone", &_args234, &_result236)
  p.SetLastResponseMeta_(_meta235)
  if _err != nil {
    return
  }
  return _result236.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) SetTimeZone(ctx context.Context, req *TSSetTimeZoneReq) (_r *common.TSStatus, _err error) {
  var _args237 IClientRPCServiceSetTimeZoneArgs
  _args237.Req = req
  var _result239 IClientRPCServiceSetTimeZoneResult
  var _meta238 thrift.ResponseMeta
  _meta238, _err = p.Client_().Call(ctx, "setTimeZone", &_args237, &_result239)
  p.SetLastResponseMeta_(_meta238)
  if _err != nil {
    return
  }
  return _result239.GetSuccess(), nil
}

func (p *IClientRPCServiceClient) GetProperties(ctx context.Context) (_r *ServerProperties, _err error) {
  var _args240 IClientRPCServiceGetPropertiesArgs
  var _result242 IClientRPCServiceGetPropertiesResult
  var _meta241 thrift.ResponseMeta
  _meta241, _err = p.Client_().Call(ctx, "getProperties", &_args240, &_result242)
  p.SetLastResponseMeta_(_meta241)
  if _err != nil {
    return
  }
  return _result242.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - StorageGroup
func (p *IClientRPCServiceClient) SetStorageGroup(ctx context.Context, sessionId int64, storageGroup string) (_r *common.TSStatus, _err error) {
  var _args243 IClientRPCServiceSetStorageGroupArgs
  _args243.SessionId = sessionId
  _args243.StorageGroup = storageGroup
  var _result245 IClientRPCServiceSetStorageGroupResult
  var _meta244 thrift.ResponseMeta
  _meta244, _err = p.Client_().Call(ctx, "setStorageGroup", &_args243, &_result245)
  p.SetLastResponseMeta_(_meta244)
  if _err != nil {
    return
  }
  return _result245.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) CreateTimeseries(ctx context.Context, req *TSCreateTimeseriesReq) (_r *common.TSStatus, _err error) {
  var _args246 IClientRPCServiceCreateTimeseriesArgs
  _args246.Req = req
  var _result248 IClientRPCServiceCreateTimeseriesResult
  var _meta247 thrift.ResponseMeta
  _meta247, _err = p.Client_().Call(ctx, "createTimeseries", &_args246, &_result248)
  p.SetLastResponseMeta_(_meta247)
  if _err != nil {
    return
  }
  return _result248.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) CreateAlignedTimeseries(ctx context.Context, req *TSCreateAlignedTimeseriesReq) (_r *common.TSStatus, _err error) {
  var _args249 IClientRPCServiceCreateAlignedTimeseriesArgs
  _args249.Req = req
  var _result251 IClientRPCServiceCreateAlignedTimeseriesResult
  var _meta250 thrift.ResponseMeta
  _meta250, _err = p.Client_().Call(ctx, "createAlignedTimeseries", &_args249, &_result251)
  p.SetLastResponseMeta_(_meta250)
  if _err != nil {
    return
  }
  return _result251.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) CreateMultiTimeseries(ctx context.Context, req *TSCreateMultiTimeseriesReq) (_r *common.TSStatus, _err error) {
  var _args252 IClientRPCServiceCreateMultiTimeseriesArgs
  _args252.Req = req
  var _result254 IClientRPCServiceCreateMultiTimeseriesResult
  var _meta253 thrift.ResponseMeta
  _meta253, _err = p.Client_().Call(ctx, "createMultiTimeseries", &_args252, &_result254)
  p.SetLastResponseMeta_(_meta253)
  if _err != nil {
    return
  }
  return _result254.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - Path
func (p *IClientRPCServiceClient) DeleteTimeseries(ctx context.Context, sessionId int64, path []string) (_r *common.TSStatus, _err error) {
  var _args255 IClientRPCServiceDeleteTimeseriesArgs
  _args255.SessionId = sessionId
  _args255.Path = path
  var _result257 IClientRPCServiceDeleteTimeseriesResult
  var _meta256 thrift.ResponseMeta
  _meta256, _err = p.Client_().Call(ctx, "deleteTimeseries", &_args255, &_result257)
  p.SetLastResponseMeta_(_meta256)
  if _err != nil {
    return
  }
  return _result257.GetSuccess(), nil
}

// Parameters:
//  - SessionId
//  - StorageGroup
func (p *IClientRPCServiceClient) DeleteStorageGroups(ctx context.Context, sessionId int64, storageGroup []string) (_r *common.TSStatus, _err error) {
  var _args258 IClientRPCServiceDeleteStorageGroupsArgs
  _args258.SessionId = sessionId
  _args258.StorageGroup = storageGroup
  var _result260 IClientRPCServiceDeleteStorageGroupsResult
  var _meta259 thrift.ResponseMeta
  _meta259, _err = p.Client_().Call(ctx, "deleteStorageGroups", &_args258, &_result260)
  p.SetLastResponseMeta_(_meta259)
  if _err != nil {
    return
  }
  return _result260.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) InsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *common.TSStatus, _err error) {
  var _args261 IClientRPCServiceInsertRecordArgs
  _args261.Req = req
  var _result263 IClientRPCServiceInsertRecordResult
  var _meta262 thrift.ResponseMeta
  _meta262, _err = p.Client_().Call(ctx, "insertRecord", &_args261, &_result263)
  p.SetLastResponseMeta_(_meta262)
  if _err != nil {
    return
  }
  return _result263.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) InsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *common.TSStatus, _err error) {
  var _args264 IClientRPCServiceInsertStringRecordArgs
  _args264.Req = req
  var _result266 IClientRPCServiceInsertStringRecordResult
  var _meta265 thrift.ResponseMeta
  _meta265, _err = p.Client_().Call(ctx, "insertStringRecord", &_args264, &_result266)
  p.SetLastResponseMeta_(_meta265)
  if _err != nil {
    return
  }
  return _result266.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) InsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *common.TSStatus, _err error) {
  var _args267 IClientRPCServiceInsertTabletArgs
  _args267.Req = req
  var _result269 IClientRPCServiceInsertTabletResult
  var _meta268 thrift.ResponseMeta
  _meta268, _err = p.Client_().Call(ctx, "insertTablet", &_args267, &_result269)
  p.SetLastResponseMeta_(_meta268)
  if _err != nil {
    return
  }
  return _result269.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) InsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *common.TSStatus, _err error) {
  var _args270 IClientRPCServiceInsertTabletsArgs
  _args270.Req = req
  var _result272 IClientRPCServiceInsertTabletsResult
  var _meta271 thrift.ResponseMeta
  _meta271, _err = p.Client_().Call(ctx, "insertTablets", &_args270, &_result272)
  p.SetLastResponseMeta_(_meta271)
  if _err != nil {
    return
  }
  return _result272.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) InsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *common.TSStatus, _err error) {
  var _args273 IClientRPCServiceInsertRecordsArgs
  _args273.Req = req
  var _result275 IClientRPCServiceInsertRecordsResult
  var _meta274 thrift.ResponseMeta
  _meta274, _err = p.Client_().Call(ctx, "insertRecords", &_args273, &_result275)
  p.SetLastResponseMeta_(_meta274)
  if _err != nil {
    return
  }
  return _result275.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) InsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *common.TSStatus, _err error) {
  var _args276 IClientRPCServiceInsertRecordsOfOneDeviceArgs
  _args276.Req = req
  var _result278 IClientRPCServiceInsertRecordsOfOneDeviceResult
  var _meta277 thrift.ResponseMeta
  _meta277, _err = p.Client_().Call(ctx, "insertRecordsOfOneDevice", &_args276, &_result278)
  p.SetLastResponseMeta_(_meta277)
  if _err != nil {
    return
  }
  return _result278.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) InsertStringRecordsOfOneDevice(ctx context.Context, req *TSInsertStringRecordsOfOneDeviceReq) (_r *common.TSStatus, _err error) {
  var _args279 IClientRPCServiceInsertStringRecordsOfOneDeviceArgs
  _args279.Req = req
  var _result281 IClientRPCServiceInsertStringRecordsOfOneDeviceResult
  var _meta280 thrift.ResponseMeta
  _meta280, _err = p.Client_().Call(ctx, "insertStringRecordsOfOneDevice", &_args279, &_result281)
  p.SetLastResponseMeta_(_meta280)
  if _err != nil {
    return
  }
  return _result281.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) InsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *common.TSStatus, _err error) {
  var _args282 IClientRPCServiceInsertStringRecordsArgs
  _args282.Req = req
  var _result284 IClientRPCServiceInsertStringRecordsResult
  var _meta283 thrift.ResponseMeta
  _meta283, _err = p.Client_().Call(ctx, "insertStringRecords", &_args282, &_result284)
  p.SetLastResponseMeta_(_meta283)
  if _err != nil {
    return
  }
  return _result284.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) TestInsertTablet(ctx context.Context, req *TSInsertTabletReq) (_r *common.TSStatus, _err error) {
  var _args285 IClientRPCServiceTestInsertTabletArgs
  _args285.Req = req
  var _result287 IClientRPCServiceTestInsertTabletResult
  var _meta286 thrift.ResponseMeta
  _meta286, _err = p.Client_().Call(ctx, "testInsertTablet", &_args285, &_result287)
  p.SetLastResponseMeta_(_meta286)
  if _err != nil {
    return
  }
  return _result287.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) TestInsertTablets(ctx context.Context, req *TSInsertTabletsReq) (_r *common.TSStatus, _err error) {
  var _args288 IClientRPCServiceTestInsertTabletsArgs
  _args288.Req = req
  var _result290 IClientRPCServiceTestInsertTabletsResult
  var _meta289 thrift.ResponseMeta
  _meta289, _err = p.Client_().Call(ctx, "testInsertTablets", &_args288, &_result290)
  p.SetLastResponseMeta_(_meta289)
  if _err != nil {
    return
  }
  return _result290.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) TestInsertRecord(ctx context.Context, req *TSInsertRecordReq) (_r *common.TSStatus, _err error) {
  var _args291 IClientRPCServiceTestInsertRecordArgs
  _args291.Req = req
  var _result293 IClientRPCServiceTestInsertRecordResult
  var _meta292 thrift.ResponseMeta
  _meta292, _err = p.Client_().Call(ctx, "testInsertRecord", &_args291, &_result293)
  p.SetLastResponseMeta_(_meta292)
  if _err != nil {
    return
  }
  return _result293.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) TestInsertStringRecord(ctx context.Context, req *TSInsertStringRecordReq) (_r *common.TSStatus, _err error) {
  var _args294 IClientRPCServiceTestInsertStringRecordArgs
  _args294.Req = req
  var _result296 IClientRPCServiceTestInsertStringRecordResult
  var _meta295 thrift.ResponseMeta
  _meta295, _err = p.Client_().Call(ctx, "testInsertStringRecord", &_args294, &_result296)
  p.SetLastResponseMeta_(_meta295)
  if _err != nil {
    return
  }
  return _result296.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) TestInsertRecords(ctx context.Context, req *TSInsertRecordsReq) (_r *common.TSStatus, _err error) {
  var _args297 IClientRPCServiceTestInsertRecordsArgs
  _args297.Req = req
  var _result299 IClientRPCServiceTestInsertRecordsResult
  var _meta298 thrift.ResponseMeta
  _meta298, _err = p.Client_().Call(ctx, "testInsertRecords", &_args297, &_result299)
  p.SetLastResponseMeta_(_meta298)
  if _err != nil {
    return
  }
  return _result299.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) TestInsertRecordsOfOneDevice(ctx context.Context, req *TSInsertRecordsOfOneDeviceReq) (_r *common.TSStatus, _err error) {
  var _args300 IClientRPCServiceTestInsertRecordsOfOneDeviceArgs
  _args300.Req = req
  var _result302 IClientRPCServiceTestInsertRecordsOfOneDeviceResult
  var _meta301 thrift.ResponseMeta
  _meta301, _err = p.Client_().Call(ctx, "testInsertRecordsOfOneDevice", &_args300, &_result302)
  p.SetLastResponseMeta_(_meta301)
  if _err != nil {
    return
  }
  return _result302.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) TestInsertStringRecords(ctx context.Context, req *TSInsertStringRecordsReq) (_r *common.TSStatus, _err error) {
  var _args303 IClientRPCServiceTestInsertStringRecordsArgs
  _args303.Req = req
  var _result305 IClientRPCServiceTestInsertStringRecordsResult
  var _meta304 thrift.ResponseMeta
  _meta304, _err = p.Client_().Call(ctx, "testInsertStringRecords", &_args303, &_result305)
  p.SetLastResponseMeta_(_meta304)
  if _err != nil {
    return
  }
  return _result305.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) DeleteData(ctx context.Context, req *TSDeleteDataReq) (_r *common.TSStatus, _err error) {
  var _args306 IClientRPCServiceDeleteDataArgs
  _args306.Req = req
  var _result308 IClientRPCServiceDeleteDataResult
  var _meta307 thrift.ResponseMeta
  _meta307, _err = p.Client_().Call(ctx, "deleteData", &_args306, &_result308)
  p.SetLastResponseMeta_(_meta307)
  if _err != nil {
    return
  }
  return _result308.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteRawDataQuery(ctx context.Context, req *TSRawDataQueryReq) (_r *TSExecuteStatementResp, _err error) {
  var _args309 IClientRPCServiceExecuteRawDataQueryArgs
  _args309.Req = req
  var _result311 IClientRPCServiceExecuteRawDataQueryResult
  var _meta310 thrift.ResponseMeta
  _meta310, _err = p.Client_().Call(ctx, "executeRawDataQuery", &_args309, &_result311)
  p.SetLastResponseMeta_(_meta310)
  if _err != nil {
    return
  }
  return _result311.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteLastDataQuery(ctx context.Context, req *TSLastDataQueryReq) (_r *TSExecuteStatementResp, _err error) {
  var _args312 IClientRPCServiceExecuteLastDataQueryArgs
  _args312.Req = req
  var _result314 IClientRPCServiceExecuteLastDataQueryResult
  var _meta313 thrift.ResponseMeta
  _meta313, _err = p.Client_().Call(ctx, "executeLastDataQuery", &_args312, &_result314)
  p.SetLastResponseMeta_(_meta313)
  if _err != nil {
    return
  }
  return _result314.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) ExecuteAggregationQuery(ctx context.Context, req *TSAggregationQueryReq) (_r *TSExecuteStatementResp, _err error) {
  var _args315 IClientRPCServiceExecuteAggregationQueryArgs
  _args315.Req = req
  var _result317 IClientRPCServiceExecuteAggregationQueryResult
  var _meta316 thrift.ResponseMeta
  _meta316, _err = p.Client_().Call(ctx, "executeAggregationQuery", &_args315, &_result317)
  p.SetLastResponseMeta_(_meta316)
  if _err != nil {
    return
  }
  return _result317.GetSuccess(), nil
}

// Parameters:
//  - SessionId
func (p *IClientRPCServiceClient) RequestStatementId(ctx context.Context, sessionId int64) (_r int64, _err error) {
  var _args318 IClientRPCServiceRequestStatementIdArgs
  _args318.SessionId = sessionId
  var _result320 IClientRPCServiceRequestStatementIdResult
  var _meta319 thrift.ResponseMeta
  _meta319, _err = p.Client_().Call(ctx, "requestStatementId", &_args318, &_result320)
  p.SetLastResponseMeta_(_meta319)
  if _err != nil {
    return
  }
  return _result320.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) CreateSchemaTemplate(ctx context.Context, req *TSCreateSchemaTemplateReq) (_r *common.TSStatus, _err error) {
  var _args321 IClientRPCServiceCreateSchemaTemplateArgs
  _args321.Req = req
  var _result323 IClientRPCServiceCreateSchemaTemplateResult
  var _meta322 thrift.ResponseMeta
  _meta322, _err = p.Client_().Call(ctx, "createSchemaTemplate", &_args321, &_result323)
  p.SetLastResponseMeta_(_meta322)
  if _err != nil {
    return
  }
  return _result323.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) AppendSchemaTemplate(ctx context.Context, req *TSAppendSchemaTemplateReq) (_r *common.TSStatus, _err error) {
  var _args324 IClientRPCServiceAppendSchemaTemplateArgs
  _args324.Req = req
  var _result326 IClientRPCServiceAppendSchemaTemplateResult
  var _meta325 thrift.ResponseMeta
  _meta325, _err = p.Client_().Call(ctx, "appendSchemaTemplate", &_args324, &_result326)
  p.SetLastResponseMeta_(_meta325)
  if _err != nil {
    return
  }
  return _result326.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) PruneSchemaTemplate(ctx context.Context, req *TSPruneSchemaTemplateReq) (_r *common.TSStatus, _err error) {
  var _args327 IClientRPCServicePruneSchemaTemplateArgs
  _args327.Req = req
  var _result329 IClientRPCServicePruneSchemaTemplateResult
  var _meta328 thrift.ResponseMeta
  _meta328, _err = p.Client_().Call(ctx, "pruneSchemaTemplate", &_args327, &_result329)
  p.SetLastResponseMeta_(_meta328)
  if _err != nil {
    return
  }
  return _result329.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) QuerySchemaTemplate(ctx context.Context, req *TSQueryTemplateReq) (_r *TSQueryTemplateResp, _err error) {
  var _args330 IClientRPCServiceQuerySchemaTemplateArgs
  _args330.Req = req
  var _result332 IClientRPCServiceQuerySchemaTemplateResult
  var _meta331 thrift.ResponseMeta
  _meta331, _err = p.Client_().Call(ctx, "querySchemaTemplate", &_args330, &_result332)
  p.SetLastResponseMeta_(_meta331)
  if _err != nil {
    return
  }
  return _result332.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) SetSchemaTemplate(ctx context.Context, req *TSSetSchemaTemplateReq) (_r *common.TSStatus, _err error) {
  var _args333 IClientRPCServiceSetSchemaTemplateArgs
  _args333.Req = req
  var _result335 IClientRPCServiceSetSchemaTemplateResult
  var _meta334 thrift.ResponseMeta
  _meta334, _err = p.Client_().Call(ctx, "setSchemaTemplate", &_args333, &_result335)
  p.SetLastResponseMeta_(_meta334)
  if _err != nil {
    return
  }
  return _result335.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) UnsetSchemaTemplate(ctx context.Context, req *TSUnsetSchemaTemplateReq) (_r *common.TSStatus, _err error) {
  var _args336 IClientRPCServiceUnsetSchemaTemplateArgs
  _args336.Req = req
  var _result338 IClientRPCServiceUnsetSchemaTemplateResult
  var _meta337 thrift.ResponseMeta
  _meta337, _err = p.Client_().Call(ctx, "unsetSchemaTemplate", &_args336, &_result338)
  p.SetLastResponseMeta_(_meta337)
  if _err != nil {
    return
  }
  return _result338.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) DropSchemaTemplate(ctx context.Context, req *TSDropSchemaTemplateReq) (_r *common.TSStatus, _err error) {
  var _args339 IClientRPCServiceDropSchemaTemplateArgs
  _args339.Req = req
  var _result341 IClientRPCServiceDropSchemaTemplateResult
  var _meta340 thrift.ResponseMeta
  _meta340, _err = p.Client_().Call(ctx, "dropSchemaTemplate", &_args339, &_result341)
  p.SetLastResponseMeta_(_meta340)
  if _err != nil {
    return
  }
  return _result341.GetSuccess(), nil
}

// Parameters:
//  - Req
func (p *IClientRPCServiceClient) CreateTimeseriesUsingSchemaTemplate(ctx context.Context, req *TCreateTimeseriesUsingSchemaTemplateReq) (_r *common.TSStatus, _err error) {
  var _args342 IClientRPCServiceCreateTimeseriesUsingSchemaTemplateArgs
  _args342.Req = req
  var _result344 IClientRPCServiceCreateTimeseriesUsingSchemaTemplateResult
  var _meta343 thrift.ResponseMeta
  _meta343, _err = p.Client_().Call(ctx, "createTimeseriesUsingSchemaTemplate", &_args342, &_result344)
  p.SetLastResponseMeta_(_meta343)
  if _err != nil {
    return
  }
  return _result344.GetSuccess(), nil
}

// Parameters:
//  - Info
func (p *IClientRPCServiceClient) Handshake(ctx context.Context, info *TSyncIdentityInfo) (_r *common.TSStatus, _err error) {
  var _args345 IClientRPCServiceHandshakeArgs
  _args345.Info = info
  var _result347 IClientRPCServiceHandshakeResult
  var _meta346 thrift.ResponseMeta
  _meta346, _err = p.Client_().Call(ctx, "handshake", &_args345, &_result347)
  p.SetLastResponseMeta_(_meta346)
  if _err != nil {
    return
  }
  return _result347.GetSuccess(), nil
}

// Parameters:
//  - Buff
func (p *IClientRPCServiceClient) SendPipeData(ctx context.Context, buff []byte) (_r *common.TSStatus, _err error) {
  var _args348 IClientRPCServiceSendPipeDataArgs
  _args348.Buff = buff
  var _result350 IClientRPCServiceSendPipeDataResult
  var _meta349 thrift.ResponseMeta
  _meta349, _err = p.Client_().Call(ctx, "sendPipeData", &_args348, &_result350)
  p.SetLastResponseMeta_(_meta349)
  if _err != nil {
    return
  }
  return _result350.GetSuccess(), nil
}

// Parameters:
//  - MetaInfo
//  - Buff
func (p *IClientRPCServiceClient) SendFile(ctx context.Context, metaInfo *TSyncTransportMetaInfo, buff []byte) (_r *common.TSStatus, _err error) {
  var _args351 IClientRPCServiceSendFileArgs
  _args351.MetaInfo = metaInfo
  _args351.Buff = buff
  var _result353 IClientRPCServiceSendFileResult
  var _meta352 thrift.ResponseMeta
  _meta352, _err = p.Client_().Call(ctx, "sendFile", &_args351, &_result353)
  p.SetLastResponseMeta_(_meta352)
  if _err != nil {
    return
  }
  return _result353.GetSuccess(), nil
}

func (p *IClientRPCServiceClient) GetBackupConfiguration(ctx context.Context) (_r *TSBackupConfigurationResp, _err error) {
  var _args354 IClientRPCServiceGetBackupConfigurationArgs
  var _result356 IClientRPCServiceGetBackupConfigurationResult
  var _meta355 thrift.ResponseMeta
  _meta355, _err = p.Client_().Call(ctx, "getBackupConfiguration", &_args354, &_result356)
  p.SetLastResponseMeta_(_meta355)
  if _err != nil {
    return
  }
  return _result356.GetSuccess(), nil
}

func (p *IClientRPCServiceClient) FetchAllConnectionsInfo(ctx context.Context) (_r *TSConnectionInfoResp, _err error) {
  var _args357 IClientRPCServiceFetchAllConnectionsInfoArgs
  var _result359 IClientRPCServiceFetchAllConnectionsInfoResult
  var _meta358 thrift.ResponseMeta
  _meta358, _err = p.Client_().Call(ctx, "fetchAllConnectionsInfo", &_args357, &_result359)
  p.SetLastResponseMeta_(_meta358)
  if _err != nil {
    return
  }
  return _result359.GetSuccess(), nil
}

type IClientRPCServiceProcessor struct {
  processorMap map[string]thrift.TProcessorFunction
  handler IClientRPCService
}

func (p *IClientRPCServiceProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
  p.processorMap[key] = processor
}

func (p *IClientRPCServiceProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
  processor, ok = p.processorMap[key]
  return processor, ok
}

func (p *IClientRPCServiceProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
  return p.processorMap
}

func NewIClientRPCServiceProcessor(handler IClientRPCService) *IClientRPCServiceProcessor {

  self360 := &IClientRPCServiceProcessor{handler:handler, processorMap:make(map[string]thrift.TProcessorFunction)}
  self360.processorMap["executeQueryStatementV2"] = &iClientRPCServiceProcessorExecuteQueryStatementV2{handler:handler}
  self360.processorMap["executeUpdateStatementV2"] = &iClientRPCServiceProcessorExecuteUpdateStatementV2{handler:handler}
  self360.processorMap["executeStatementV2"] = &iClientRPCServiceProcessorExecuteStatementV2{handler:handler}
  self360.processorMap["executeRawDataQueryV2"] = &iClientRPCServiceProcessorExecuteRawDataQueryV2{handler:handler}
  self360.processorMap["executeLastDataQueryV2"] = &iClientRPCServiceProcessorExecuteLastDataQueryV2{handler:handler}
  self360.processorMap["executeAggregationQueryV2"] = &iClientRPCServiceProcessorExecuteAggregationQueryV2{handler:handler}
  self360.processorMap["fetchResultsV2"] = &iClientRPCServiceProcessorFetchResultsV2{handler:handler}
  self360.processorMap["openSession"] = &iClientRPCServiceProcessorOpenSession{handler:handler}
  self360.processorMap["closeSession"] = &iClientRPCServiceProcessorCloseSession{handler:handler}
  self360.processorMap["executeStatement"] = &iClientRPCServiceProcessorExecuteStatement{handler:handler}
  self360.processorMap["executeBatchStatement"] = &iClientRPCServiceProcessorExecuteBatchStatement{handler:handler}
  self360.processorMap["executeQueryStatement"] = &iClientRPCServiceProcessorExecuteQueryStatement{handler:handler}
  self360.processorMap["executeUpdateStatement"] = &iClientRPCServiceProcessorExecuteUpdateStatement{handler:handler}
  self360.processorMap["fetchResults"] = &iClientRPCServiceProcessorFetchResults{handler:handler}
  self360.processorMap["fetchMetadata"] = &iClientRPCServiceProcessorFetchMetadata{handler:handler}
  self360.processorMap["cancelOperation"] = &iClientRPCServiceProcessorCancelOperation{handler:handler}
  self360.processorMap["closeOperation"] = &iClientRPCServiceProcessorCloseOperation{handler:handler}
  self360.processorMap["getTimeZone"] = &iClientRPCServiceProcessorGetTimeZone{handler:handler}
  self360.processorMap["setTimeZone"] = &iClientRPCServiceProcessorSetTimeZone{handler:handler}
  self360.processorMap["getProperties"] = &iClientRPCServiceProcessorGetProperties{handler:handler}
  self360.processorMap["setStorageGroup"] = &iClientRPCServiceProcessorSetStorageGroup{handler:handler}
  self360.processorMap["createTimeseries"] = &iClientRPCServiceProcessorCreateTimeseries{handler:handler}
  self360.processorMap["createAlignedTimeseries"] = &iClientRPCServiceProcessorCreateAlignedTimeseries{handler:handler}
  self360.processorMap["createMultiTimeseries"] = &iClientRPCServiceProcessorCreateMultiTimeseries{handler:handler}
  self360.processorMap["deleteTimeseries"] = &iClientRPCServiceProcessorDeleteTimeseries{handler:handler}
  self360.processorMap["deleteStorageGroups"] = &iClientRPCServiceProcessorDeleteStorageGroups{handler:handler}
  self360.processorMap["insertRecord"] = &iClientRPCServiceProcessorInsertRecord{handler:handler}
  self360.processorMap["insertStringRecord"] = &iClientRPCServiceProcessorInsertStringRecord{handler:handler}
  self360.processorMap["insertTablet"] = &iClientRPCServiceProcessorInsertTablet{handler:handler}
  self360.processorMap["insertTablets"] = &iClientRPCServiceProcessorInsertTablets{handler:handler}
  self360.processorMap["insertRecords"] = &iClientRPCServiceProcessorInsertRecords{handler:handler}
  self360.processorMap["insertRecordsOfOneDevice"] = &iClientRPCServiceProcessorInsertRecordsOfOneDevice{handler:handler}
  self360.processorMap["insertStringRecordsOfOneDevice"] = &iClientRPCServiceProcessorInsertStringRecordsOfOneDevice{handler:handler}
  self360.processorMap["insertStringRecords"] = &iClientRPCServiceProcessorInsertStringRecords{handler:handler}
  self360.processorMap["testInsertTablet"] = &iClientRPCServiceProcessorTestInsertTablet{handler:handler}
  self360.processorMap["testInsertTablets"] = &iClientRPCServiceProcessorTestInsertTablets{handler:handler}
  self360.processorMap["testInsertRecord"] = &iClientRPCServiceProcessorTestInsertRecord{handler:handler}
  self360.processorMap["testInsertStringRecord"] = &iClientRPCServiceProcessorTestInsertStringRecord{handler:handler}
  self360.processorMap["testInsertRecords"] = &iClientRPCServiceProcessorTestInsertRecords{handler:handler}
  self360.processorMap["testInsertRecordsOfOneDevice"] = &iClientRPCServiceProcessorTestInsertRecordsOfOneDevice{handler:handler}
  self360.processorMap["testInsertStringRecords"] = &iClientRPCServiceProcessorTestInsertStringRecords{handler:handler}
  self360.processorMap["deleteData"] = &iClientRPCServiceProcessorDeleteData{handler:handler}
  self360.processorMap["executeRawDataQuery"] = &iClientRPCServiceProcessorExecuteRawDataQuery{handler:handler}
  self360.processorMap["executeLastDataQuery"] = &iClientRPCServiceProcessorExecuteLastDataQuery{handler:handler}
  self360.processorMap["executeAggregationQuery"] = &iClientRPCServiceProcessorExecuteAggregationQuery{handler:handler}
  self360.processorMap["requestStatementId"] = &iClientRPCServiceProcessorRequestStatementId{handler:handler}
  self360.processorMap["createSchemaTemplate"] = &iClientRPCServiceProcessorCreateSchemaTemplate{handler:handler}
  self360.processorMap["appendSchemaTemplate"] = &iClientRPCServiceProcessorAppendSchemaTemplate{handler:handler}
  self360.processorMap["pruneSchemaTemplate"] = &iClientRPCServiceProcessorPruneSchemaTemplate{handler:handler}
  self360.processorMap["querySchemaTemplate"] = &iClientRPCServiceProcessorQuerySchemaTemplate{handler:handler}
  self360.processorMap["setSchemaTemplate"] = &iClientRPCServiceProcessorSetSchemaTemplate{handler:handler}
  self360.processorMap["unsetSchemaTemplate"] = &iClientRPCServiceProcessorUnsetSchemaTemplate{handler:handler}
  self360.processorMap["dropSchemaTemplate"] = &iClientRPCServiceProcessorDropSchemaTemplate{handler:handler}
  self360.processorMap["createTimeseriesUsingSchemaTemplate"] = &iClientRPCServiceProcessorCreateTimeseriesUsingSchemaTemplate{handler:handler}
  self360.processorMap["handshake"] = &iClientRPCServiceProcessorHandshake{handler:handler}
  self360.processorMap["sendPipeData"] = &iClientRPCServiceProcessorSendPipeData{handler:handler}
  self360.processorMap["sendFile"] = &iClientRPCServiceProcessorSendFile{handler:handler}
  self360.processorMap["getBackupConfiguration"] = &iClientRPCServiceProcessorGetBackupConfiguration{handler:handler}
  self360.processorMap["fetchAllConnectionsInfo"] = &iClientRPCServiceProcessorFetchAllConnectionsInfo{handler:handler}
return self360
}

func (p *IClientRPCServiceProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  name, _, seqId, err2 := iprot.ReadMessageBegin(ctx)
  if err2 != nil { return false, thrift.WrapTException(err2) }
  if processor, ok := p.GetProcessorFunction(name); ok {
    return processor.Process(ctx, seqId, iprot, oprot)
  }
  iprot.Skip(ctx, thrift.STRUCT)
  iprot.ReadMessageEnd(ctx)
  x361 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function " + name)
  oprot.WriteMessageBegin(ctx, name, thrift.EXCEPTION, seqId)
  x361.Write(ctx, oprot)
  oprot.WriteMessageEnd(ctx)
  oprot.Flush(ctx)
  return false, x361

}

type iClientRPCServiceProcessorExecuteQueryStatementV2 struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteQueryStatementV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteQueryStatementV2Args{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeQueryStatementV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteQueryStatementV2Result{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteQueryStatementV2(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeQueryStatementV2: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeQueryStatementV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeQueryStatementV2", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteUpdateStatementV2 struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteUpdateStatementV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteUpdateStatementV2Args{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeUpdateStatementV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteUpdateStatementV2Result{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteUpdateStatementV2(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeUpdateStatementV2: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeUpdateStatementV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeUpdateStatementV2", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteStatementV2 struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteStatementV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteStatementV2Args{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeStatementV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteStatementV2Result{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteStatementV2(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeStatementV2: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeStatementV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeStatementV2", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteRawDataQueryV2 struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteRawDataQueryV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteRawDataQueryV2Args{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeRawDataQueryV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteRawDataQueryV2Result{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteRawDataQueryV2(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeRawDataQueryV2: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeRawDataQueryV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeRawDataQueryV2", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteLastDataQueryV2 struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteLastDataQueryV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteLastDataQueryV2Args{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeLastDataQueryV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteLastDataQueryV2Result{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteLastDataQueryV2(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeLastDataQueryV2: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeLastDataQueryV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeLastDataQueryV2", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteAggregationQueryV2 struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteAggregationQueryV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteAggregationQueryV2Args{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeAggregationQueryV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteAggregationQueryV2Result{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteAggregationQueryV2(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeAggregationQueryV2: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeAggregationQueryV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeAggregationQueryV2", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorFetchResultsV2 struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorFetchResultsV2) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceFetchResultsV2Args{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchResultsV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceFetchResultsV2Result{}
  var retval *TSFetchResultsResp
  if retval, err2 = p.handler.FetchResultsV2(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchResultsV2: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchResultsV2", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchResultsV2", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorOpenSession struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorOpenSession) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceOpenSessionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "openSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceOpenSessionResult{}
  var retval *TSOpenSessionResp
  if retval, err2 = p.handler.OpenSession(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing openSession: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "openSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "openSession", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorCloseSession struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorCloseSession) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceCloseSessionArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "closeSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceCloseSessionResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.CloseSession(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing closeSession: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "closeSession", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "closeSession", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteStatement struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteStatementArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteStatementResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteStatement(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeStatement: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeStatement", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteBatchStatement struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteBatchStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteBatchStatementArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteBatchStatementResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.ExecuteBatchStatement(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeBatchStatement: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeBatchStatement", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteQueryStatement struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteQueryStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteQueryStatementArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteQueryStatementResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteQueryStatement(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeQueryStatement: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeQueryStatement", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteUpdateStatement struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteUpdateStatement) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteUpdateStatementArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteUpdateStatementResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteUpdateStatement(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeUpdateStatement: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeUpdateStatement", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorFetchResults struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorFetchResults) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceFetchResultsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchResults", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceFetchResultsResult{}
  var retval *TSFetchResultsResp
  if retval, err2 = p.handler.FetchResults(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchResults: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchResults", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchResults", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorFetchMetadata struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorFetchMetadata) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceFetchMetadataArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceFetchMetadataResult{}
  var retval *TSFetchMetadataResp
  if retval, err2 = p.handler.FetchMetadata(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchMetadata: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchMetadata", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorCancelOperation struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorCancelOperation) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceCancelOperationArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceCancelOperationResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.CancelOperation(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing cancelOperation: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "cancelOperation", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorCloseOperation struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorCloseOperation) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceCloseOperationArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "closeOperation", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceCloseOperationResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.CloseOperation(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing closeOperation: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "closeOperation", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "closeOperation", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorGetTimeZone struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorGetTimeZone) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceGetTimeZoneArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceGetTimeZoneResult{}
  var retval *TSGetTimeZoneResp
  if retval, err2 = p.handler.GetTimeZone(ctx, args.SessionId); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getTimeZone: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getTimeZone", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorSetTimeZone struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorSetTimeZone) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceSetTimeZoneArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceSetTimeZoneResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.SetTimeZone(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setTimeZone: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "setTimeZone", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorGetProperties struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorGetProperties) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceGetPropertiesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getProperties", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceGetPropertiesResult{}
  var retval *ServerProperties
  if retval, err2 = p.handler.GetProperties(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getProperties: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getProperties", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getProperties", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorSetStorageGroup struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorSetStorageGroup) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceSetStorageGroupArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceSetStorageGroupResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.SetStorageGroup(ctx, args.SessionId, args.StorageGroup); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setStorageGroup: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "setStorageGroup", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorCreateTimeseries struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorCreateTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceCreateTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceCreateTimeseriesResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.CreateTimeseries(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorCreateAlignedTimeseries struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorCreateAlignedTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceCreateAlignedTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createAlignedTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceCreateAlignedTimeseriesResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.CreateAlignedTimeseries(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createAlignedTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createAlignedTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createAlignedTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorCreateMultiTimeseries struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorCreateMultiTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceCreateMultiTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceCreateMultiTimeseriesResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.CreateMultiTimeseries(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createMultiTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createMultiTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorDeleteTimeseries struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorDeleteTimeseries) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceDeleteTimeseriesArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceDeleteTimeseriesResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.DeleteTimeseries(ctx, args.SessionId, args.Path); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteTimeseries: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "deleteTimeseries", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorDeleteStorageGroups struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorDeleteStorageGroups) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceDeleteStorageGroupsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceDeleteStorageGroupsResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.DeleteStorageGroups(ctx, args.SessionId, args.StorageGroup); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteStorageGroups: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "deleteStorageGroups", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorInsertRecord struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorInsertRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceInsertRecordArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceInsertRecordResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.InsertRecord(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecord: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertRecord", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorInsertStringRecord struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorInsertStringRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceInsertStringRecordArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceInsertStringRecordResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.InsertStringRecord(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertStringRecord: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertStringRecord", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorInsertTablet struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorInsertTablet) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceInsertTabletArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertTablet", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceInsertTabletResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.InsertTablet(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertTablet: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertTablet", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertTablet", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorInsertTablets struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorInsertTablets) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceInsertTabletsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertTablets", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceInsertTabletsResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.InsertTablets(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertTablets: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertTablets", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertTablets", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorInsertRecords struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorInsertRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceInsertRecordsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceInsertRecordsResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.InsertRecords(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecords: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertRecords", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorInsertRecordsOfOneDevice struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorInsertRecordsOfOneDevice) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceInsertRecordsOfOneDeviceArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceInsertRecordsOfOneDeviceResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.InsertRecordsOfOneDevice(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertRecordsOfOneDevice: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertRecordsOfOneDevice", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorInsertStringRecordsOfOneDevice struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorInsertStringRecordsOfOneDevice) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceInsertStringRecordsOfOneDeviceArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceInsertStringRecordsOfOneDeviceResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.InsertStringRecordsOfOneDevice(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertStringRecordsOfOneDevice: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertStringRecordsOfOneDevice", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorInsertStringRecords struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorInsertStringRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceInsertStringRecordsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceInsertStringRecordsResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.InsertStringRecords(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing insertStringRecords: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "insertStringRecords", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorTestInsertTablet struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorTestInsertTablet) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceTestInsertTabletArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceTestInsertTabletResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.TestInsertTablet(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertTablet: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertTablet", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorTestInsertTablets struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorTestInsertTablets) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceTestInsertTabletsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceTestInsertTabletsResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.TestInsertTablets(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertTablets: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertTablets", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorTestInsertRecord struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorTestInsertRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceTestInsertRecordArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceTestInsertRecordResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.TestInsertRecord(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecord: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecord", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorTestInsertStringRecord struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorTestInsertStringRecord) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceTestInsertStringRecordArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceTestInsertStringRecordResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.TestInsertStringRecord(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertStringRecord: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertStringRecord", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorTestInsertRecords struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorTestInsertRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceTestInsertRecordsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceTestInsertRecordsResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.TestInsertRecords(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecords: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecords", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorTestInsertRecordsOfOneDevice struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorTestInsertRecordsOfOneDevice) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceTestInsertRecordsOfOneDeviceArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceTestInsertRecordsOfOneDeviceResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.TestInsertRecordsOfOneDevice(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertRecordsOfOneDevice: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertRecordsOfOneDevice", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorTestInsertStringRecords struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorTestInsertStringRecords) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceTestInsertStringRecordsArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceTestInsertStringRecordsResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.TestInsertStringRecords(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing testInsertStringRecords: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "testInsertStringRecords", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorDeleteData struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorDeleteData) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceDeleteDataArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteData", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceDeleteDataResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.DeleteData(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deleteData: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "deleteData", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "deleteData", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteRawDataQuery struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteRawDataQuery) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteRawDataQueryArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteRawDataQueryResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteRawDataQuery(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeRawDataQuery: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeRawDataQuery", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteLastDataQuery struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteLastDataQuery) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteLastDataQueryArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeLastDataQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteLastDataQueryResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteLastDataQuery(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeLastDataQuery: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeLastDataQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeLastDataQuery", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorExecuteAggregationQuery struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorExecuteAggregationQuery) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceExecuteAggregationQueryArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "executeAggregationQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceExecuteAggregationQueryResult{}
  var retval *TSExecuteStatementResp
  if retval, err2 = p.handler.ExecuteAggregationQuery(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing executeAggregationQuery: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "executeAggregationQuery", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "executeAggregationQuery", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorRequestStatementId struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorRequestStatementId) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceRequestStatementIdArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceRequestStatementIdResult{}
  var retval int64
  if retval, err2 = p.handler.RequestStatementId(ctx, args.SessionId); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing requestStatementId: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = &retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "requestStatementId", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorCreateSchemaTemplate struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorCreateSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceCreateSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceCreateSchemaTemplateResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.CreateSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorAppendSchemaTemplate struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorAppendSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceAppendSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "appendSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceAppendSchemaTemplateResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.AppendSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing appendSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "appendSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "appendSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorPruneSchemaTemplate struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorPruneSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServicePruneSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "pruneSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServicePruneSchemaTemplateResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.PruneSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing pruneSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "pruneSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "pruneSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorQuerySchemaTemplate struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorQuerySchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceQuerySchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "querySchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceQuerySchemaTemplateResult{}
  var retval *TSQueryTemplateResp
  if retval, err2 = p.handler.QuerySchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing querySchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "querySchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "querySchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorSetSchemaTemplate struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorSetSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceSetSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "setSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceSetSchemaTemplateResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.SetSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing setSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "setSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "setSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorUnsetSchemaTemplate struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorUnsetSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceUnsetSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "unsetSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceUnsetSchemaTemplateResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.UnsetSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing unsetSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "unsetSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "unsetSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorDropSchemaTemplate struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorDropSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceDropSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "dropSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceDropSchemaTemplateResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.DropSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing dropSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "dropSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "dropSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorCreateTimeseriesUsingSchemaTemplate struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorCreateTimeseriesUsingSchemaTemplate) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceCreateTimeseriesUsingSchemaTemplateArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "createTimeseriesUsingSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceCreateTimeseriesUsingSchemaTemplateResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.CreateTimeseriesUsingSchemaTemplate(ctx, args.Req); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing createTimeseriesUsingSchemaTemplate: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "createTimeseriesUsingSchemaTemplate", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "createTimeseriesUsingSchemaTemplate", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorHandshake struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorHandshake) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceHandshakeArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "handshake", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceHandshakeResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.Handshake(ctx, args.Info); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing handshake: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "handshake", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "handshake", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorSendPipeData struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorSendPipeData) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceSendPipeDataArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "sendPipeData", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceSendPipeDataResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.SendPipeData(ctx, args.Buff); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing sendPipeData: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "sendPipeData", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "sendPipeData", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorSendFile struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorSendFile) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceSendFileArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "sendFile", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceSendFileResult{}
  var retval *common.TSStatus
  if retval, err2 = p.handler.SendFile(ctx, args.MetaInfo, args.Buff); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing sendFile: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "sendFile", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "sendFile", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorGetBackupConfiguration struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorGetBackupConfiguration) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceGetBackupConfigurationArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "getBackupConfiguration", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceGetBackupConfigurationResult{}
  var retval *TSBackupConfigurationResp
  if retval, err2 = p.handler.GetBackupConfiguration(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getBackupConfiguration: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "getBackupConfiguration", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "getBackupConfiguration", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}

type iClientRPCServiceProcessorFetchAllConnectionsInfo struct {
  handler IClientRPCService
}

func (p *iClientRPCServiceProcessorFetchAllConnectionsInfo) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
  args := IClientRPCServiceFetchAllConnectionsInfoArgs{}
  var err2 error
  if err2 = args.Read(ctx, iprot); err2 != nil {
    iprot.ReadMessageEnd(ctx)
    x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchAllConnectionsInfo", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return false, thrift.WrapTException(err2)
  }
  iprot.ReadMessageEnd(ctx)

  tickerCancel := func() {}
  // Start a goroutine to do server side connectivity check.
  if thrift.ServerConnectivityCheckInterval > 0 {
    var cancel context.CancelFunc
    ctx, cancel = context.WithCancel(ctx)
    defer cancel()
    var tickerCtx context.Context
    tickerCtx, tickerCancel = context.WithCancel(context.Background())
    defer tickerCancel()
    go func(ctx context.Context, cancel context.CancelFunc) {
      ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
      defer ticker.Stop()
      for {
        select {
        case <-ctx.Done():
          return
        case <-ticker.C:
          if !iprot.Transport().IsOpen() {
            cancel()
            return
          }
        }
      }
    }(tickerCtx, cancel)
  }

  result := IClientRPCServiceFetchAllConnectionsInfoResult{}
  var retval *TSConnectionInfoResp
  if retval, err2 = p.handler.FetchAllConnectionsInfo(ctx); err2 != nil {
    tickerCancel()
    if err2 == thrift.ErrAbandonRequest {
      return false, thrift.WrapTException(err2)
    }
    x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing fetchAllConnectionsInfo: " + err2.Error())
    oprot.WriteMessageBegin(ctx, "fetchAllConnectionsInfo", thrift.EXCEPTION, seqId)
    x.Write(ctx, oprot)
    oprot.WriteMessageEnd(ctx)
    oprot.Flush(ctx)
    return true, thrift.WrapTException(err2)
  } else {
    result.Success = retval
  }
  tickerCancel()
  if err2 = oprot.WriteMessageBegin(ctx, "fetchAllConnectionsInfo", thrift.REPLY, seqId); err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
    err = thrift.WrapTException(err2)
  }
  if err != nil {
    return
  }
  return true, err
}


// HELPER FUNCTIONS AND STRUCTURES

// Attributes:
//  - Req
type IClientRPCServiceExecuteQueryStatementV2Args struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteQueryStatementV2Args() *IClientRPCServiceExecuteQueryStatementV2Args {
  return &IClientRPCServiceExecuteQueryStatementV2Args{}
}

var IClientRPCServiceExecuteQueryStatementV2Args_Req_DEFAULT *TSExecuteStatementReq
func (p *IClientRPCServiceExecuteQueryStatementV2Args) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteQueryStatementV2Args_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteQueryStatementV2Args) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteQueryStatementV2Args) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementV2Args)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementV2Args) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeQueryStatementV2_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementV2Args) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteQueryStatementV2Args) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteQueryStatementV2Args(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteQueryStatementV2Result struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteQueryStatementV2Result() *IClientRPCServiceExecuteQueryStatementV2Result {
  return &IClientRPCServiceExecuteQueryStatementV2Result{}
}

var IClientRPCServiceExecuteQueryStatementV2Result_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteQueryStatementV2Result) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteQueryStatementV2Result_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteQueryStatementV2Result) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteQueryStatementV2Result) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementV2Result)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementV2Result) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeQueryStatementV2_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementV2Result) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteQueryStatementV2Result) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteQueryStatementV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteUpdateStatementV2Args struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteUpdateStatementV2Args() *IClientRPCServiceExecuteUpdateStatementV2Args {
  return &IClientRPCServiceExecuteUpdateStatementV2Args{}
}

var IClientRPCServiceExecuteUpdateStatementV2Args_Req_DEFAULT *TSExecuteStatementReq
func (p *IClientRPCServiceExecuteUpdateStatementV2Args) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteUpdateStatementV2Args_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteUpdateStatementV2Args) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Args) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Args)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Args) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeUpdateStatementV2_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Args) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Args) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteUpdateStatementV2Args(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteUpdateStatementV2Result struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteUpdateStatementV2Result() *IClientRPCServiceExecuteUpdateStatementV2Result {
  return &IClientRPCServiceExecuteUpdateStatementV2Result{}
}

var IClientRPCServiceExecuteUpdateStatementV2Result_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteUpdateStatementV2Result) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteUpdateStatementV2Result_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteUpdateStatementV2Result) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Result) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Result)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Result) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeUpdateStatementV2_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Result) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteUpdateStatementV2Result) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteUpdateStatementV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteStatementV2Args struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteStatementV2Args() *IClientRPCServiceExecuteStatementV2Args {
  return &IClientRPCServiceExecuteStatementV2Args{}
}

var IClientRPCServiceExecuteStatementV2Args_Req_DEFAULT *TSExecuteStatementReq
func (p *IClientRPCServiceExecuteStatementV2Args) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteStatementV2Args_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteStatementV2Args) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteStatementV2Args) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteStatementV2Args)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteStatementV2Args) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeStatementV2_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteStatementV2Args) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteStatementV2Args) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteStatementV2Args(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteStatementV2Result struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteStatementV2Result() *IClientRPCServiceExecuteStatementV2Result {
  return &IClientRPCServiceExecuteStatementV2Result{}
}

var IClientRPCServiceExecuteStatementV2Result_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteStatementV2Result) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteStatementV2Result_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteStatementV2Result) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteStatementV2Result) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteStatementV2Result)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteStatementV2Result) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeStatementV2_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteStatementV2Result) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteStatementV2Result) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteStatementV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteRawDataQueryV2Args struct {
  Req *TSRawDataQueryReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteRawDataQueryV2Args() *IClientRPCServiceExecuteRawDataQueryV2Args {
  return &IClientRPCServiceExecuteRawDataQueryV2Args{}
}

var IClientRPCServiceExecuteRawDataQueryV2Args_Req_DEFAULT *TSRawDataQueryReq
func (p *IClientRPCServiceExecuteRawDataQueryV2Args) GetReq() *TSRawDataQueryReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteRawDataQueryV2Args_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteRawDataQueryV2Args) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Args) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Args)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSRawDataQueryReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Args) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeRawDataQueryV2_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Args) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Args) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteRawDataQueryV2Args(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteRawDataQueryV2Result struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteRawDataQueryV2Result() *IClientRPCServiceExecuteRawDataQueryV2Result {
  return &IClientRPCServiceExecuteRawDataQueryV2Result{}
}

var IClientRPCServiceExecuteRawDataQueryV2Result_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteRawDataQueryV2Result) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteRawDataQueryV2Result_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteRawDataQueryV2Result) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Result) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Result)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Result) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeRawDataQueryV2_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Result) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteRawDataQueryV2Result) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteRawDataQueryV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteLastDataQueryV2Args struct {
  Req *TSLastDataQueryReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteLastDataQueryV2Args() *IClientRPCServiceExecuteLastDataQueryV2Args {
  return &IClientRPCServiceExecuteLastDataQueryV2Args{}
}

var IClientRPCServiceExecuteLastDataQueryV2Args_Req_DEFAULT *TSLastDataQueryReq
func (p *IClientRPCServiceExecuteLastDataQueryV2Args) GetReq() *TSLastDataQueryReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteLastDataQueryV2Args_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteLastDataQueryV2Args) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Args) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Args)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSLastDataQueryReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Args) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeLastDataQueryV2_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Args) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Args) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteLastDataQueryV2Args(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteLastDataQueryV2Result struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteLastDataQueryV2Result() *IClientRPCServiceExecuteLastDataQueryV2Result {
  return &IClientRPCServiceExecuteLastDataQueryV2Result{}
}

var IClientRPCServiceExecuteLastDataQueryV2Result_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteLastDataQueryV2Result) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteLastDataQueryV2Result_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteLastDataQueryV2Result) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Result) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Result)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Result) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeLastDataQueryV2_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Result) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteLastDataQueryV2Result) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteLastDataQueryV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteAggregationQueryV2Args struct {
  Req *TSAggregationQueryReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteAggregationQueryV2Args() *IClientRPCServiceExecuteAggregationQueryV2Args {
  return &IClientRPCServiceExecuteAggregationQueryV2Args{}
}

var IClientRPCServiceExecuteAggregationQueryV2Args_Req_DEFAULT *TSAggregationQueryReq
func (p *IClientRPCServiceExecuteAggregationQueryV2Args) GetReq() *TSAggregationQueryReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteAggregationQueryV2Args_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteAggregationQueryV2Args) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Args) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Args)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSAggregationQueryReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Args) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeAggregationQueryV2_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Args) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Args) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteAggregationQueryV2Args(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteAggregationQueryV2Result struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteAggregationQueryV2Result() *IClientRPCServiceExecuteAggregationQueryV2Result {
  return &IClientRPCServiceExecuteAggregationQueryV2Result{}
}

var IClientRPCServiceExecuteAggregationQueryV2Result_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteAggregationQueryV2Result) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteAggregationQueryV2Result_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteAggregationQueryV2Result) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Result) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Result)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Result) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeAggregationQueryV2_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Result) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteAggregationQueryV2Result) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteAggregationQueryV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceFetchResultsV2Args struct {
  Req *TSFetchResultsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceFetchResultsV2Args() *IClientRPCServiceFetchResultsV2Args {
  return &IClientRPCServiceFetchResultsV2Args{}
}

var IClientRPCServiceFetchResultsV2Args_Req_DEFAULT *TSFetchResultsReq
func (p *IClientRPCServiceFetchResultsV2Args) GetReq() *TSFetchResultsReq {
  if !p.IsSetReq() {
    return IClientRPCServiceFetchResultsV2Args_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceFetchResultsV2Args) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceFetchResultsV2Args) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchResultsV2Args)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSFetchResultsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchResultsV2Args) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchResultsV2_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceFetchResultsV2Args) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceFetchResultsV2Args) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceFetchResultsV2Args(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceFetchResultsV2Result struct {
  Success *TSFetchResultsResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceFetchResultsV2Result() *IClientRPCServiceFetchResultsV2Result {
  return &IClientRPCServiceFetchResultsV2Result{}
}

var IClientRPCServiceFetchResultsV2Result_Success_DEFAULT *TSFetchResultsResp
func (p *IClientRPCServiceFetchResultsV2Result) GetSuccess() *TSFetchResultsResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceFetchResultsV2Result_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceFetchResultsV2Result) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceFetchResultsV2Result) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchResultsV2Result)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSFetchResultsResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchResultsV2Result) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchResultsV2_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceFetchResultsV2Result) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceFetchResultsV2Result) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceFetchResultsV2Result(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceOpenSessionArgs struct {
  Req *TSOpenSessionReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceOpenSessionArgs() *IClientRPCServiceOpenSessionArgs {
  return &IClientRPCServiceOpenSessionArgs{}
}

var IClientRPCServiceOpenSessionArgs_Req_DEFAULT *TSOpenSessionReq
func (p *IClientRPCServiceOpenSessionArgs) GetReq() *TSOpenSessionReq {
  if !p.IsSetReq() {
    return IClientRPCServiceOpenSessionArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceOpenSessionArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceOpenSessionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceOpenSessionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSOpenSessionReq{
  ClientProtocol:   2,
}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceOpenSessionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "openSession_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceOpenSessionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceOpenSessionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceOpenSessionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceOpenSessionResult struct {
  Success *TSOpenSessionResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceOpenSessionResult() *IClientRPCServiceOpenSessionResult {
  return &IClientRPCServiceOpenSessionResult{}
}

var IClientRPCServiceOpenSessionResult_Success_DEFAULT *TSOpenSessionResp
func (p *IClientRPCServiceOpenSessionResult) GetSuccess() *TSOpenSessionResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceOpenSessionResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceOpenSessionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceOpenSessionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceOpenSessionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSOpenSessionResp{
  ServerProtocolVersion:   0,
}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceOpenSessionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "openSession_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceOpenSessionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceOpenSessionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceOpenSessionResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceCloseSessionArgs struct {
  Req *TSCloseSessionReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceCloseSessionArgs() *IClientRPCServiceCloseSessionArgs {
  return &IClientRPCServiceCloseSessionArgs{}
}

var IClientRPCServiceCloseSessionArgs_Req_DEFAULT *TSCloseSessionReq
func (p *IClientRPCServiceCloseSessionArgs) GetReq() *TSCloseSessionReq {
  if !p.IsSetReq() {
    return IClientRPCServiceCloseSessionArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceCloseSessionArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceCloseSessionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCloseSessionArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCloseSessionReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceCloseSessionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeSession_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCloseSessionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceCloseSessionArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCloseSessionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceCloseSessionResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceCloseSessionResult() *IClientRPCServiceCloseSessionResult {
  return &IClientRPCServiceCloseSessionResult{}
}

var IClientRPCServiceCloseSessionResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceCloseSessionResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceCloseSessionResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceCloseSessionResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceCloseSessionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCloseSessionResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceCloseSessionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeSession_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCloseSessionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceCloseSessionResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCloseSessionResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteStatementArgs struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteStatementArgs() *IClientRPCServiceExecuteStatementArgs {
  return &IClientRPCServiceExecuteStatementArgs{}
}

var IClientRPCServiceExecuteStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *IClientRPCServiceExecuteStatementArgs) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteStatementArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteStatementArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeStatement_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteStatementArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteStatementResult struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteStatementResult() *IClientRPCServiceExecuteStatementResult {
  return &IClientRPCServiceExecuteStatementResult{}
}

var IClientRPCServiceExecuteStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteStatementResult) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteStatementResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteStatementResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeStatement_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteStatementResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteBatchStatementArgs struct {
  Req *TSExecuteBatchStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteBatchStatementArgs() *IClientRPCServiceExecuteBatchStatementArgs {
  return &IClientRPCServiceExecuteBatchStatementArgs{}
}

var IClientRPCServiceExecuteBatchStatementArgs_Req_DEFAULT *TSExecuteBatchStatementReq
func (p *IClientRPCServiceExecuteBatchStatementArgs) GetReq() *TSExecuteBatchStatementReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteBatchStatementArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteBatchStatementArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteBatchStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteBatchStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteBatchStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteBatchStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeBatchStatement_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteBatchStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteBatchStatementArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteBatchStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteBatchStatementResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteBatchStatementResult() *IClientRPCServiceExecuteBatchStatementResult {
  return &IClientRPCServiceExecuteBatchStatementResult{}
}

var IClientRPCServiceExecuteBatchStatementResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceExecuteBatchStatementResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteBatchStatementResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteBatchStatementResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteBatchStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteBatchStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteBatchStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeBatchStatement_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteBatchStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteBatchStatementResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteBatchStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteQueryStatementArgs struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteQueryStatementArgs() *IClientRPCServiceExecuteQueryStatementArgs {
  return &IClientRPCServiceExecuteQueryStatementArgs{}
}

var IClientRPCServiceExecuteQueryStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *IClientRPCServiceExecuteQueryStatementArgs) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteQueryStatementArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteQueryStatementArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteQueryStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeQueryStatement_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteQueryStatementArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteQueryStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteQueryStatementResult struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteQueryStatementResult() *IClientRPCServiceExecuteQueryStatementResult {
  return &IClientRPCServiceExecuteQueryStatementResult{}
}

var IClientRPCServiceExecuteQueryStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteQueryStatementResult) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteQueryStatementResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteQueryStatementResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteQueryStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeQueryStatement_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteQueryStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteQueryStatementResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteQueryStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceExecuteUpdateStatementArgs struct {
  Req *TSExecuteStatementReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceExecuteUpdateStatementArgs() *IClientRPCServiceExecuteUpdateStatementArgs {
  return &IClientRPCServiceExecuteUpdateStatementArgs{}
}

var IClientRPCServiceExecuteUpdateStatementArgs_Req_DEFAULT *TSExecuteStatementReq
func (p *IClientRPCServiceExecuteUpdateStatementArgs) GetReq() *TSExecuteStatementReq {
  if !p.IsSetReq() {
    return IClientRPCServiceExecuteUpdateStatementArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceExecuteUpdateStatementArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceExecuteUpdateStatementArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSExecuteStatementReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeUpdateStatement_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceExecuteUpdateStatementArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteUpdateStatementArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceExecuteUpdateStatementResult struct {
  Success *TSExecuteStatementResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceExecuteUpdateStatementResult() *IClientRPCServiceExecuteUpdateStatementResult {
  return &IClientRPCServiceExecuteUpdateStatementResult{}
}

var IClientRPCServiceExecuteUpdateStatementResult_Success_DEFAULT *TSExecuteStatementResp
func (p *IClientRPCServiceExecuteUpdateStatementResult) GetSuccess() *TSExecuteStatementResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceExecuteUpdateStatementResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceExecuteUpdateStatementResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceExecuteUpdateStatementResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSExecuteStatementResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "executeUpdateStatement_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceExecuteUpdateStatementResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceExecuteUpdateStatementResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceExecuteUpdateStatementResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceFetchResultsArgs struct {
  Req *TSFetchResultsReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceFetchResultsArgs() *IClientRPCServiceFetchResultsArgs {
  return &IClientRPCServiceFetchResultsArgs{}
}

var IClientRPCServiceFetchResultsArgs_Req_DEFAULT *TSFetchResultsReq
func (p *IClientRPCServiceFetchResultsArgs) GetReq() *TSFetchResultsReq {
  if !p.IsSetReq() {
    return IClientRPCServiceFetchResultsArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceFetchResultsArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceFetchResultsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchResultsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSFetchResultsReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchResultsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchResults_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceFetchResultsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceFetchResultsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceFetchResultsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceFetchResultsResult struct {
  Success *TSFetchResultsResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceFetchResultsResult() *IClientRPCServiceFetchResultsResult {
  return &IClientRPCServiceFetchResultsResult{}
}

var IClientRPCServiceFetchResultsResult_Success_DEFAULT *TSFetchResultsResp
func (p *IClientRPCServiceFetchResultsResult) GetSuccess() *TSFetchResultsResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceFetchResultsResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceFetchResultsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceFetchResultsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchResultsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSFetchResultsResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchResultsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchResults_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceFetchResultsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceFetchResultsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceFetchResultsResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceFetchMetadataArgs struct {
  Req *TSFetchMetadataReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceFetchMetadataArgs() *IClientRPCServiceFetchMetadataArgs {
  return &IClientRPCServiceFetchMetadataArgs{}
}

var IClientRPCServiceFetchMetadataArgs_Req_DEFAULT *TSFetchMetadataReq
func (p *IClientRPCServiceFetchMetadataArgs) GetReq() *TSFetchMetadataReq {
  if !p.IsSetReq() {
    return IClientRPCServiceFetchMetadataArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceFetchMetadataArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceFetchMetadataArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchMetadataArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSFetchMetadataReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchMetadataArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchMetadata_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceFetchMetadataArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceFetchMetadataArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceFetchMetadataArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceFetchMetadataResult struct {
  Success *TSFetchMetadataResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceFetchMetadataResult() *IClientRPCServiceFetchMetadataResult {
  return &IClientRPCServiceFetchMetadataResult{}
}

var IClientRPCServiceFetchMetadataResult_Success_DEFAULT *TSFetchMetadataResp
func (p *IClientRPCServiceFetchMetadataResult) GetSuccess() *TSFetchMetadataResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceFetchMetadataResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceFetchMetadataResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceFetchMetadataResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchMetadataResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSFetchMetadataResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceFetchMetadataResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "fetchMetadata_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceFetchMetadataResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceFetchMetadataResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceFetchMetadataResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceCancelOperationArgs struct {
  Req *TSCancelOperationReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceCancelOperationArgs() *IClientRPCServiceCancelOperationArgs {
  return &IClientRPCServiceCancelOperationArgs{}
}

var IClientRPCServiceCancelOperationArgs_Req_DEFAULT *TSCancelOperationReq
func (p *IClientRPCServiceCancelOperationArgs) GetReq() *TSCancelOperationReq {
  if !p.IsSetReq() {
    return IClientRPCServiceCancelOperationArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceCancelOperationArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceCancelOperationArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCancelOperationArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCancelOperationReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceCancelOperationArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "cancelOperation_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCancelOperationArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceCancelOperationArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCancelOperationArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceCancelOperationResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceCancelOperationResult() *IClientRPCServiceCancelOperationResult {
  return &IClientRPCServiceCancelOperationResult{}
}

var IClientRPCServiceCancelOperationResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceCancelOperationResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceCancelOperationResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceCancelOperationResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceCancelOperationResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCancelOperationResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceCancelOperationResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "cancelOperation_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCancelOperationResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceCancelOperationResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCancelOperationResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceCloseOperationArgs struct {
  Req *TSCloseOperationReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceCloseOperationArgs() *IClientRPCServiceCloseOperationArgs {
  return &IClientRPCServiceCloseOperationArgs{}
}

var IClientRPCServiceCloseOperationArgs_Req_DEFAULT *TSCloseOperationReq
func (p *IClientRPCServiceCloseOperationArgs) GetReq() *TSCloseOperationReq {
  if !p.IsSetReq() {
    return IClientRPCServiceCloseOperationArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceCloseOperationArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceCloseOperationArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCloseOperationArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCloseOperationReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceCloseOperationArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeOperation_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCloseOperationArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceCloseOperationArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCloseOperationArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceCloseOperationResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceCloseOperationResult() *IClientRPCServiceCloseOperationResult {
  return &IClientRPCServiceCloseOperationResult{}
}

var IClientRPCServiceCloseOperationResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceCloseOperationResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceCloseOperationResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceCloseOperationResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceCloseOperationResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCloseOperationResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceCloseOperationResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "closeOperation_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCloseOperationResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceCloseOperationResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCloseOperationResult(%+v)", *p)
}

// Attributes:
//  - SessionId
type IClientRPCServiceGetTimeZoneArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
}

func NewIClientRPCServiceGetTimeZoneArgs() *IClientRPCServiceGetTimeZoneArgs {
  return &IClientRPCServiceGetTimeZoneArgs{}
}


func (p *IClientRPCServiceGetTimeZoneArgs) GetSessionId() int64 {
  return p.SessionId
}
func (p *IClientRPCServiceGetTimeZoneArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceGetTimeZoneArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *IClientRPCServiceGetTimeZoneArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getTimeZone_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceGetTimeZoneArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *IClientRPCServiceGetTimeZoneArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceGetTimeZoneArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceGetTimeZoneResult struct {
  Success *TSGetTimeZoneResp `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceGetTimeZoneResult() *IClientRPCServiceGetTimeZoneResult {
  return &IClientRPCServiceGetTimeZoneResult{}
}

var IClientRPCServiceGetTimeZoneResult_Success_DEFAULT *TSGetTimeZoneResp
func (p *IClientRPCServiceGetTimeZoneResult) GetSuccess() *TSGetTimeZoneResp {
  if !p.IsSetSuccess() {
    return IClientRPCServiceGetTimeZoneResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceGetTimeZoneResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceGetTimeZoneResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceGetTimeZoneResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &TSGetTimeZoneResp{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceGetTimeZoneResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getTimeZone_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceGetTimeZoneResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceGetTimeZoneResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceGetTimeZoneResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceSetTimeZoneArgs struct {
  Req *TSSetTimeZoneReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceSetTimeZoneArgs() *IClientRPCServiceSetTimeZoneArgs {
  return &IClientRPCServiceSetTimeZoneArgs{}
}

var IClientRPCServiceSetTimeZoneArgs_Req_DEFAULT *TSSetTimeZoneReq
func (p *IClientRPCServiceSetTimeZoneArgs) GetReq() *TSSetTimeZoneReq {
  if !p.IsSetReq() {
    return IClientRPCServiceSetTimeZoneArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceSetTimeZoneArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceSetTimeZoneArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceSetTimeZoneArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSSetTimeZoneReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceSetTimeZoneArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setTimeZone_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceSetTimeZoneArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceSetTimeZoneArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceSetTimeZoneArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceSetTimeZoneResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceSetTimeZoneResult() *IClientRPCServiceSetTimeZoneResult {
  return &IClientRPCServiceSetTimeZoneResult{}
}

var IClientRPCServiceSetTimeZoneResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceSetTimeZoneResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceSetTimeZoneResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceSetTimeZoneResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceSetTimeZoneResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceSetTimeZoneResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceSetTimeZoneResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setTimeZone_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceSetTimeZoneResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceSetTimeZoneResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceSetTimeZoneResult(%+v)", *p)
}

type IClientRPCServiceGetPropertiesArgs struct {
}

func NewIClientRPCServiceGetPropertiesArgs() *IClientRPCServiceGetPropertiesArgs {
  return &IClientRPCServiceGetPropertiesArgs{}
}

func (p *IClientRPCServiceGetPropertiesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    if err := iprot.Skip(ctx, fieldTypeId); err != nil {
      return err
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceGetPropertiesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getProperties_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceGetPropertiesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceGetPropertiesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceGetPropertiesResult struct {
  Success *ServerProperties `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceGetPropertiesResult() *IClientRPCServiceGetPropertiesResult {
  return &IClientRPCServiceGetPropertiesResult{}
}

var IClientRPCServiceGetPropertiesResult_Success_DEFAULT *ServerProperties
func (p *IClientRPCServiceGetPropertiesResult) GetSuccess() *ServerProperties {
  if !p.IsSetSuccess() {
    return IClientRPCServiceGetPropertiesResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceGetPropertiesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceGetPropertiesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceGetPropertiesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &ServerProperties{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceGetPropertiesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "getProperties_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceGetPropertiesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceGetPropertiesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceGetPropertiesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - StorageGroup
type IClientRPCServiceSetStorageGroupArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
  StorageGroup string `thrift:"storageGroup,2" db:"storageGroup" json:"storageGroup"`
}

func NewIClientRPCServiceSetStorageGroupArgs() *IClientRPCServiceSetStorageGroupArgs {
  return &IClientRPCServiceSetStorageGroupArgs{}
}


func (p *IClientRPCServiceSetStorageGroupArgs) GetSessionId() int64 {
  return p.SessionId
}

func (p *IClientRPCServiceSetStorageGroupArgs) GetStorageGroup() string {
  return p.StorageGroup
}
func (p *IClientRPCServiceSetStorageGroupArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.STRING {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceSetStorageGroupArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *IClientRPCServiceSetStorageGroupArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadString(ctx); err != nil {
  return thrift.PrependError("error reading field 2: ", err)
} else {
  p.StorageGroup = v
}
  return nil
}

func (p *IClientRPCServiceSetStorageGroupArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setStorageGroup_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceSetStorageGroupArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *IClientRPCServiceSetStorageGroupArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "storageGroup", thrift.STRING, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:storageGroup: ", p), err) }
  if err := oprot.WriteString(ctx, string(p.StorageGroup)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.storageGroup (2) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:storageGroup: ", p), err) }
  return err
}

func (p *IClientRPCServiceSetStorageGroupArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceSetStorageGroupArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceSetStorageGroupResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceSetStorageGroupResult() *IClientRPCServiceSetStorageGroupResult {
  return &IClientRPCServiceSetStorageGroupResult{}
}

var IClientRPCServiceSetStorageGroupResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceSetStorageGroupResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceSetStorageGroupResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceSetStorageGroupResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceSetStorageGroupResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceSetStorageGroupResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceSetStorageGroupResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "setStorageGroup_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceSetStorageGroupResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceSetStorageGroupResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceSetStorageGroupResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceCreateTimeseriesArgs struct {
  Req *TSCreateTimeseriesReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceCreateTimeseriesArgs() *IClientRPCServiceCreateTimeseriesArgs {
  return &IClientRPCServiceCreateTimeseriesArgs{}
}

var IClientRPCServiceCreateTimeseriesArgs_Req_DEFAULT *TSCreateTimeseriesReq
func (p *IClientRPCServiceCreateTimeseriesArgs) GetReq() *TSCreateTimeseriesReq {
  if !p.IsSetReq() {
    return IClientRPCServiceCreateTimeseriesArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceCreateTimeseriesArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceCreateTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCreateTimeseriesReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCreateTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceCreateTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCreateTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceCreateTimeseriesResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceCreateTimeseriesResult() *IClientRPCServiceCreateTimeseriesResult {
  return &IClientRPCServiceCreateTimeseriesResult{}
}

var IClientRPCServiceCreateTimeseriesResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceCreateTimeseriesResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceCreateTimeseriesResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceCreateTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceCreateTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCreateTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceCreateTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCreateTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceCreateAlignedTimeseriesArgs struct {
  Req *TSCreateAlignedTimeseriesReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceCreateAlignedTimeseriesArgs() *IClientRPCServiceCreateAlignedTimeseriesArgs {
  return &IClientRPCServiceCreateAlignedTimeseriesArgs{}
}

var IClientRPCServiceCreateAlignedTimeseriesArgs_Req_DEFAULT *TSCreateAlignedTimeseriesReq
func (p *IClientRPCServiceCreateAlignedTimeseriesArgs) GetReq() *TSCreateAlignedTimeseriesReq {
  if !p.IsSetReq() {
    return IClientRPCServiceCreateAlignedTimeseriesArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceCreateAlignedTimeseriesArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceCreateAlignedTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateAlignedTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCreateAlignedTimeseriesReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateAlignedTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createAlignedTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCreateAlignedTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceCreateAlignedTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCreateAlignedTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceCreateAlignedTimeseriesResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceCreateAlignedTimeseriesResult() *IClientRPCServiceCreateAlignedTimeseriesResult {
  return &IClientRPCServiceCreateAlignedTimeseriesResult{}
}

var IClientRPCServiceCreateAlignedTimeseriesResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceCreateAlignedTimeseriesResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceCreateAlignedTimeseriesResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceCreateAlignedTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceCreateAlignedTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateAlignedTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateAlignedTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createAlignedTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCreateAlignedTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceCreateAlignedTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCreateAlignedTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceCreateMultiTimeseriesArgs struct {
  Req *TSCreateMultiTimeseriesReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceCreateMultiTimeseriesArgs() *IClientRPCServiceCreateMultiTimeseriesArgs {
  return &IClientRPCServiceCreateMultiTimeseriesArgs{}
}

var IClientRPCServiceCreateMultiTimeseriesArgs_Req_DEFAULT *TSCreateMultiTimeseriesReq
func (p *IClientRPCServiceCreateMultiTimeseriesArgs) GetReq() *TSCreateMultiTimeseriesReq {
  if !p.IsSetReq() {
    return IClientRPCServiceCreateMultiTimeseriesArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceCreateMultiTimeseriesArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceCreateMultiTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateMultiTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSCreateMultiTimeseriesReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateMultiTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createMultiTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCreateMultiTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceCreateMultiTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCreateMultiTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceCreateMultiTimeseriesResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceCreateMultiTimeseriesResult() *IClientRPCServiceCreateMultiTimeseriesResult {
  return &IClientRPCServiceCreateMultiTimeseriesResult{}
}

var IClientRPCServiceCreateMultiTimeseriesResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceCreateMultiTimeseriesResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceCreateMultiTimeseriesResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceCreateMultiTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceCreateMultiTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateMultiTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceCreateMultiTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "createMultiTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceCreateMultiTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceCreateMultiTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceCreateMultiTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - Path
type IClientRPCServiceDeleteTimeseriesArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
  Path []string `thrift:"path,2" db:"path" json:"path"`
}

func NewIClientRPCServiceDeleteTimeseriesArgs() *IClientRPCServiceDeleteTimeseriesArgs {
  return &IClientRPCServiceDeleteTimeseriesArgs{}
}


func (p *IClientRPCServiceDeleteTimeseriesArgs) GetSessionId() int64 {
  return p.SessionId
}

func (p *IClientRPCServiceDeleteTimeseriesArgs) GetPath() []string {
  return p.Path
}
func (p *IClientRPCServiceDeleteTimeseriesArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceDeleteTimeseriesArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *IClientRPCServiceDeleteTimeseriesArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.Path =  tSlice
  for i := 0; i < size; i ++ {
var _elem362 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem362 = v
}
    p.Path = append(p.Path, _elem362)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *IClientRPCServiceDeleteTimeseriesArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteTimeseries_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceDeleteTimeseriesArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *IClientRPCServiceDeleteTimeseriesArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "path", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:path: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.Path)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.Path {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:path: ", p), err) }
  return err
}

func (p *IClientRPCServiceDeleteTimeseriesArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceDeleteTimeseriesArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceDeleteTimeseriesResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceDeleteTimeseriesResult() *IClientRPCServiceDeleteTimeseriesResult {
  return &IClientRPCServiceDeleteTimeseriesResult{}
}

var IClientRPCServiceDeleteTimeseriesResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceDeleteTimeseriesResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceDeleteTimeseriesResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceDeleteTimeseriesResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceDeleteTimeseriesResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceDeleteTimeseriesResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceDeleteTimeseriesResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteTimeseries_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceDeleteTimeseriesResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceDeleteTimeseriesResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceDeleteTimeseriesResult(%+v)", *p)
}

// Attributes:
//  - SessionId
//  - StorageGroup
type IClientRPCServiceDeleteStorageGroupsArgs struct {
  SessionId int64 `thrift:"sessionId,1" db:"sessionId" json:"sessionId"`
  StorageGroup []string `thrift:"storageGroup,2" db:"storageGroup" json:"storageGroup"`
}

func NewIClientRPCServiceDeleteStorageGroupsArgs() *IClientRPCServiceDeleteStorageGroupsArgs {
  return &IClientRPCServiceDeleteStorageGroupsArgs{}
}


func (p *IClientRPCServiceDeleteStorageGroupsArgs) GetSessionId() int64 {
  return p.SessionId
}

func (p *IClientRPCServiceDeleteStorageGroupsArgs) GetStorageGroup() []string {
  return p.StorageGroup
}
func (p *IClientRPCServiceDeleteStorageGroupsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.I64 {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    case 2:
      if fieldTypeId == thrift.LIST {
        if err := p.ReadField2(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceDeleteStorageGroupsArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  if v, err := iprot.ReadI64(ctx); err != nil {
  return thrift.PrependError("error reading field 1: ", err)
} else {
  p.SessionId = v
}
  return nil
}

func (p *IClientRPCServiceDeleteStorageGroupsArgs)  ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
  _, size, err := iprot.ReadListBegin(ctx)
  if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
  }
  tSlice := make([]string, 0, size)
  p.StorageGroup =  tSlice
  for i := 0; i < size; i ++ {
var _elem363 string
    if v, err := iprot.ReadString(ctx); err != nil {
    return thrift.PrependError("error reading field 0: ", err)
} else {
    _elem363 = v
}
    p.StorageGroup = append(p.StorageGroup, _elem363)
  }
  if err := iprot.ReadListEnd(ctx); err != nil {
    return thrift.PrependError("error reading list end: ", err)
  }
  return nil
}

func (p *IClientRPCServiceDeleteStorageGroupsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteStorageGroups_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
    if err := p.writeField2(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceDeleteStorageGroupsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "sessionId", thrift.I64, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sessionId: ", p), err) }
  if err := oprot.WriteI64(ctx, int64(p.SessionId)); err != nil {
  return thrift.PrependError(fmt.Sprintf("%T.sessionId (1) field write error: ", p), err) }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sessionId: ", p), err) }
  return err
}

func (p *IClientRPCServiceDeleteStorageGroupsArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "storageGroup", thrift.LIST, 2); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:storageGroup: ", p), err) }
  if err := oprot.WriteListBegin(ctx, thrift.STRING, len(p.StorageGroup)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
  }
  for _, v := range p.StorageGroup {
    if err := oprot.WriteString(ctx, string(v)); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err) }
  }
  if err := oprot.WriteListEnd(ctx); err != nil {
    return thrift.PrependError("error writing list end: ", err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 2:storageGroup: ", p), err) }
  return err
}

func (p *IClientRPCServiceDeleteStorageGroupsArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceDeleteStorageGroupsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceDeleteStorageGroupsResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceDeleteStorageGroupsResult() *IClientRPCServiceDeleteStorageGroupsResult {
  return &IClientRPCServiceDeleteStorageGroupsResult{}
}

var IClientRPCServiceDeleteStorageGroupsResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceDeleteStorageGroupsResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceDeleteStorageGroupsResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceDeleteStorageGroupsResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceDeleteStorageGroupsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceDeleteStorageGroupsResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceDeleteStorageGroupsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "deleteStorageGroups_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceDeleteStorageGroupsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceDeleteStorageGroupsResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceDeleteStorageGroupsResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceInsertRecordArgs struct {
  Req *TSInsertRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceInsertRecordArgs() *IClientRPCServiceInsertRecordArgs {
  return &IClientRPCServiceInsertRecordArgs{}
}

var IClientRPCServiceInsertRecordArgs_Req_DEFAULT *TSInsertRecordReq
func (p *IClientRPCServiceInsertRecordArgs) GetReq() *TSInsertRecordReq {
  if !p.IsSetReq() {
    return IClientRPCServiceInsertRecordArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceInsertRecordArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceInsertRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceInsertRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertRecordReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceInsertRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertRecord_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceInsertRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceInsertRecordArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceInsertRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceInsertRecordResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceInsertRecordResult() *IClientRPCServiceInsertRecordResult {
  return &IClientRPCServiceInsertRecordResult{}
}

var IClientRPCServiceInsertRecordResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceInsertRecordResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceInsertRecordResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceInsertRecordResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceInsertRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceInsertRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
  }
  return nil
}

func (p *IClientRPCServiceInsertRecordResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertRecord_result"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField0(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceInsertRecordResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if p.IsSetSuccess() {
    if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err) }
    if err := p.Success.Write(ctx, oprot); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
    }
    if err := oprot.WriteFieldEnd(ctx); err != nil {
      return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err) }
  }
  return err
}

func (p *IClientRPCServiceInsertRecordResult) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceInsertRecordResult(%+v)", *p)
}

// Attributes:
//  - Req
type IClientRPCServiceInsertStringRecordArgs struct {
  Req *TSInsertStringRecordReq `thrift:"req,1" db:"req" json:"req"`
}

func NewIClientRPCServiceInsertStringRecordArgs() *IClientRPCServiceInsertStringRecordArgs {
  return &IClientRPCServiceInsertStringRecordArgs{}
}

var IClientRPCServiceInsertStringRecordArgs_Req_DEFAULT *TSInsertStringRecordReq
func (p *IClientRPCServiceInsertStringRecordArgs) GetReq() *TSInsertStringRecordReq {
  if !p.IsSetReq() {
    return IClientRPCServiceInsertStringRecordArgs_Req_DEFAULT
  }
return p.Req
}
func (p *IClientRPCServiceInsertStringRecordArgs) IsSetReq() bool {
  return p.Req != nil
}

func (p *IClientRPCServiceInsertStringRecordArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 1:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField1(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceInsertStringRecordArgs)  ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
  p.Req = &TSInsertStringRecordReq{}
  if err := p.Req.Read(ctx, iprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Req), err)
  }
  return nil
}

func (p *IClientRPCServiceInsertStringRecordArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
  if err := oprot.WriteStructBegin(ctx, "insertStringRecord_args"); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err) }
  if p != nil {
    if err := p.writeField1(ctx, oprot); err != nil { return err }
  }
  if err := oprot.WriteFieldStop(ctx); err != nil {
    return thrift.PrependError("write field stop error: ", err) }
  if err := oprot.WriteStructEnd(ctx); err != nil {
    return thrift.PrependError("write struct stop error: ", err) }
  return nil
}

func (p *IClientRPCServiceInsertStringRecordArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
  if err := oprot.WriteFieldBegin(ctx, "req", thrift.STRUCT, 1); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:req: ", p), err) }
  if err := p.Req.Write(ctx, oprot); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Req), err)
  }
  if err := oprot.WriteFieldEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T write field end error 1:req: ", p), err) }
  return err
}

func (p *IClientRPCServiceInsertStringRecordArgs) String() string {
  if p == nil {
    return "<nil>"
  }
  return fmt.Sprintf("IClientRPCServiceInsertStringRecordArgs(%+v)", *p)
}

// Attributes:
//  - Success
type IClientRPCServiceInsertStringRecordResult struct {
  Success *common.TSStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewIClientRPCServiceInsertStringRecordResult() *IClientRPCServiceInsertStringRecordResult {
  return &IClientRPCServiceInsertStringRecordResult{}
}

var IClientRPCServiceInsertStringRecordResult_Success_DEFAULT *common.TSStatus
func (p *IClientRPCServiceInsertStringRecordResult) GetSuccess() *common.TSStatus {
  if !p.IsSetSuccess() {
    return IClientRPCServiceInsertStringRecordResult_Success_DEFAULT
  }
return p.Success
}
func (p *IClientRPCServiceInsertStringRecordResult) IsSetSuccess() bool {
  return p.Success != nil
}

func (p *IClientRPCServiceInsertStringRecordResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
  if _, err := iprot.ReadStructBegin(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
  }


  for {
    _, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
    if err != nil {
      return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
    }
    if fieldTypeId == thrift.STOP { break; }
    switch fieldId {
    case 0:
      if fieldTypeId == thrift.STRUCT {
        if err := p.ReadField0(ctx, iprot); err != nil {
          return err
        }
      } else {
        if err := iprot.Skip(ctx, fieldTypeId); err != nil {
          return err
        }
      }
    default:
      if err := iprot.Skip(ctx, fieldTypeId); err != nil {
        return err
      }
    }
    if err := iprot.ReadFieldEnd(ctx); err != nil {
      return err
    }
  }
  if err := iprot.ReadStructEnd(ctx); err != nil {
    return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
  }
  return nil
}

func (p *IClientRPCServiceInsertStringRecordResult)  ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
  p.Success = &common.TSStatus{}
  if err := p.Success.