// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"common"
	"rpc"
)

var _ = common.GoUnusedProtection__
var _ = rpc.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQueryV2(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQueryV2(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeAggregationQueryV2(TSAggregationQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResultsV2(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSOpenSessionResp openSession(TSOpenSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeSession(TSCloseSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeBatchStatement(TSExecuteBatchStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResults(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus cancelOperation(TSCancelOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeOperation(TSCloseOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSGetTimeZoneResp getTimeZone(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus setTimeZone(TSSetTimeZoneReq req)")
  fmt.Fprintln(os.Stderr, "  ServerProperties getProperties()")
  fmt.Fprintln(os.Stderr, "  TSStatus setStorageGroup(i64 sessionId, string storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseries(TSCreateTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteTimeseries(i64 sessionId,  path)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteStorageGroups(i64 sessionId,  storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteData(TSDeleteDataReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeAggregationQuery(TSAggregationQueryReq req)")
  fmt.Fprintln(os.Stderr, "  i64 requestStatementId(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseriesUsingSchemaTemplate(TCreateTimeseriesUsingSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus handshake(TSyncIdentityInfo info)")
  fmt.Fprintln(os.Stderr, "  TSStatus sendPipeData(string buff)")
  fmt.Fprintln(os.Stderr, "  TSStatus sendFile(TSyncTransportMetaInfo metaInfo, string buff)")
  fmt.Fprintln(os.Stderr, "  TSBackupConfigurationResp getBackupConfiguration()")
  fmt.Fprintln(os.Stderr, "  TSConnectionInfoResp fetchAllConnectionsInfo()")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := rpc.NewIClientRPCServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "executeQueryStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatementV2 requires 1 args")
      flag.Usage()
    }
    arg364 := flag.Arg(1)
    mbTrans365 := thrift.NewTMemoryBufferLen(len(arg364))
    defer mbTrans365.Close()
    _, err366 := mbTrans365.WriteString(arg364)
    if err366 != nil {
      Usage()
      return
    }
    factory367 := thrift.NewTJSONProtocolFactory()
    jsProt368 := factory367.GetProtocol(mbTrans365)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err369 := argvalue0.Read(context.Background(), jsProt368)
    if err369 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatementV2 requires 1 args")
      flag.Usage()
    }
    arg370 := flag.Arg(1)
    mbTrans371 := thrift.NewTMemoryBufferLen(len(arg370))
    defer mbTrans371.Close()
    _, err372 := mbTrans371.WriteString(arg370)
    if err372 != nil {
      Usage()
      return
    }
    factory373 := thrift.NewTJSONProtocolFactory()
    jsProt374 := factory373.GetProtocol(mbTrans371)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err375 := argvalue0.Read(context.Background(), jsProt374)
    if err375 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatementV2 requires 1 args")
      flag.Usage()
    }
    arg376 := flag.Arg(1)
    mbTrans377 := thrift.NewTMemoryBufferLen(len(arg376))
    defer mbTrans377.Close()
    _, err378 := mbTrans377.WriteString(arg376)
    if err378 != nil {
      Usage()
      return
    }
    factory379 := thrift.NewTJSONProtocolFactory()
    jsProt380 := factory379.GetProtocol(mbTrans377)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err381 := argvalue0.Read(context.Background(), jsProt380)
    if err381 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQueryV2 requires 1 args")
      flag.Usage()
    }
    arg382 := flag.Arg(1)
    mbTrans383 := thrift.NewTMemoryBufferLen(len(arg382))
    defer mbTrans383.Close()
    _, err384 := mbTrans383.WriteString(arg382)
    if err384 != nil {
      Usage()
      return
    }
    factory385 := thrift.NewTJSONProtocolFactory()
    jsProt386 := factory385.GetProtocol(mbTrans383)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err387 := argvalue0.Read(context.Background(), jsProt386)
    if err387 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQueryV2 requires 1 args")
      flag.Usage()
    }
    arg388 := flag.Arg(1)
    mbTrans389 := thrift.NewTMemoryBufferLen(len(arg388))
    defer mbTrans389.Close()
    _, err390 := mbTrans389.WriteString(arg388)
    if err390 != nil {
      Usage()
      return
    }
    factory391 := thrift.NewTJSONProtocolFactory()
    jsProt392 := factory391.GetProtocol(mbTrans389)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err393 := argvalue0.Read(context.Background(), jsProt392)
    if err393 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeAggregationQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteAggregationQueryV2 requires 1 args")
      flag.Usage()
    }
    arg394 := flag.Arg(1)
    mbTrans395 := thrift.NewTMemoryBufferLen(len(arg394))
    defer mbTrans395.Close()
    _, err396 := mbTrans395.WriteString(arg394)
    if err396 != nil {
      Usage()
      return
    }
    factory397 := thrift.NewTJSONProtocolFactory()
    jsProt398 := factory397.GetProtocol(mbTrans395)
    argvalue0 := rpc.NewTSAggregationQueryReq()
    err399 := argvalue0.Read(context.Background(), jsProt398)
    if err399 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteAggregationQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResultsV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResultsV2 requires 1 args")
      flag.Usage()
    }
    arg400 := flag.Arg(1)
    mbTrans401 := thrift.NewTMemoryBufferLen(len(arg400))
    defer mbTrans401.Close()
    _, err402 := mbTrans401.WriteString(arg400)
    if err402 != nil {
      Usage()
      return
    }
    factory403 := thrift.NewTJSONProtocolFactory()
    jsProt404 := factory403.GetProtocol(mbTrans401)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err405 := argvalue0.Read(context.Background(), jsProt404)
    if err405 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResultsV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "openSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "OpenSession requires 1 args")
      flag.Usage()
    }
    arg406 := flag.Arg(1)
    mbTrans407 := thrift.NewTMemoryBufferLen(len(arg406))
    defer mbTrans407.Close()
    _, err408 := mbTrans407.WriteString(arg406)
    if err408 != nil {
      Usage()
      return
    }
    factory409 := thrift.NewTJSONProtocolFactory()
    jsProt410 := factory409.GetProtocol(mbTrans407)
    argvalue0 := rpc.NewTSOpenSessionReq()
    err411 := argvalue0.Read(context.Background(), jsProt410)
    if err411 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.OpenSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseSession requires 1 args")
      flag.Usage()
    }
    arg412 := flag.Arg(1)
    mbTrans413 := thrift.NewTMemoryBufferLen(len(arg412))
    defer mbTrans413.Close()
    _, err414 := mbTrans413.WriteString(arg412)
    if err414 != nil {
      Usage()
      return
    }
    factory415 := thrift.NewTJSONProtocolFactory()
    jsProt416 := factory415.GetProtocol(mbTrans413)
    argvalue0 := rpc.NewTSCloseSessionReq()
    err417 := argvalue0.Read(context.Background(), jsProt416)
    if err417 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatement requires 1 args")
      flag.Usage()
    }
    arg418 := flag.Arg(1)
    mbTrans419 := thrift.NewTMemoryBufferLen(len(arg418))
    defer mbTrans419.Close()
    _, err420 := mbTrans419.WriteString(arg418)
    if err420 != nil {
      Usage()
      return
    }
    factory421 := thrift.NewTJSONProtocolFactory()
    jsProt422 := factory421.GetProtocol(mbTrans419)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err423 := argvalue0.Read(context.Background(), jsProt422)
    if err423 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeBatchStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteBatchStatement requires 1 args")
      flag.Usage()
    }
    arg424 := flag.Arg(1)
    mbTrans425 := thrift.NewTMemoryBufferLen(len(arg424))
    defer mbTrans425.Close()
    _, err426 := mbTrans425.WriteString(arg424)
    if err426 != nil {
      Usage()
      return
    }
    factory427 := thrift.NewTJSONProtocolFactory()
    jsProt428 := factory427.GetProtocol(mbTrans425)
    argvalue0 := rpc.NewTSExecuteBatchStatementReq()
    err429 := argvalue0.Read(context.Background(), jsProt428)
    if err429 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteBatchStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeQueryStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatement requires 1 args")
      flag.Usage()
    }
    arg430 := flag.Arg(1)
    mbTrans431 := thrift.NewTMemoryBufferLen(len(arg430))
    defer mbTrans431.Close()
    _, err432 := mbTrans431.WriteString(arg430)
    if err432 != nil {
      Usage()
      return
    }
    factory433 := thrift.NewTJSONProtocolFactory()
    jsProt434 := factory433.GetProtocol(mbTrans431)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err435 := argvalue0.Read(context.Background(), jsProt434)
    if err435 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatement requires 1 args")
      flag.Usage()
    }
    arg436 := flag.Arg(1)
    mbTrans437 := thrift.NewTMemoryBufferLen(len(arg436))
    defer mbTrans437.Close()
    _, err438 := mbTrans437.WriteString(arg436)
    if err438 != nil {
      Usage()
      return
    }
    factory439 := thrift.NewTJSONProtocolFactory()
    jsProt440 := factory439.GetProtocol(mbTrans437)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err441 := argvalue0.Read(context.Background(), jsProt440)
    if err441 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResults":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResults requires 1 args")
      flag.Usage()
    }
    arg442 := flag.Arg(1)
    mbTrans443 := thrift.NewTMemoryBufferLen(len(arg442))
    defer mbTrans443.Close()
    _, err444 := mbTrans443.WriteString(arg442)
    if err444 != nil {
      Usage()
      return
    }
    factory445 := thrift.NewTJSONProtocolFactory()
    jsProt446 := factory445.GetProtocol(mbTrans443)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err447 := argvalue0.Read(context.Background(), jsProt446)
    if err447 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResults(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchMetadata":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchMetadata requires 1 args")
      flag.Usage()
    }
    arg448 := flag.Arg(1)
    mbTrans449 := thrift.NewTMemoryBufferLen(len(arg448))
    defer mbTrans449.Close()
    _, err450 := mbTrans449.WriteString(arg448)
    if err450 != nil {
      Usage()
      return
    }
    factory451 := thrift.NewTJSONProtocolFactory()
    jsProt452 := factory451.GetProtocol(mbTrans449)
    argvalue0 := rpc.NewTSFetchMetadataReq()
    err453 := argvalue0.Read(context.Background(), jsProt452)
    if err453 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchMetadata(context.Background(), value0))
    fmt.Print("\n")
    break
  case "cancelOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CancelOperation requires 1 args")
      flag.Usage()
    }
    arg454 := flag.Arg(1)
    mbTrans455 := thrift.NewTMemoryBufferLen(len(arg454))
    defer mbTrans455.Close()
    _, err456 := mbTrans455.WriteString(arg454)
    if err456 != nil {
      Usage()
      return
    }
    factory457 := thrift.NewTJSONProtocolFactory()
    jsProt458 := factory457.GetProtocol(mbTrans455)
    argvalue0 := rpc.NewTSCancelOperationReq()
    err459 := argvalue0.Read(context.Background(), jsProt458)
    if err459 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CancelOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseOperation requires 1 args")
      flag.Usage()
    }
    arg460 := flag.Arg(1)
    mbTrans461 := thrift.NewTMemoryBufferLen(len(arg460))
    defer mbTrans461.Close()
    _, err462 := mbTrans461.WriteString(arg460)
    if err462 != nil {
      Usage()
      return
    }
    factory463 := thrift.NewTJSONProtocolFactory()
    jsProt464 := factory463.GetProtocol(mbTrans461)
    argvalue0 := rpc.NewTSCloseOperationReq()
    err465 := argvalue0.Read(context.Background(), jsProt464)
    if err465 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetTimeZone requires 1 args")
      flag.Usage()
    }
    argvalue0, err466 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err466 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetTimeZone requires 1 args")
      flag.Usage()
    }
    arg467 := flag.Arg(1)
    mbTrans468 := thrift.NewTMemoryBufferLen(len(arg467))
    defer mbTrans468.Close()
    _, err469 := mbTrans468.WriteString(arg467)
    if err469 != nil {
      Usage()
      return
    }
    factory470 := thrift.NewTJSONProtocolFactory()
    jsProt471 := factory470.GetProtocol(mbTrans468)
    argvalue0 := rpc.NewTSSetTimeZoneReq()
    err472 := argvalue0.Read(context.Background(), jsProt471)
    if err472 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getProperties":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetProperties requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetProperties(context.Background()))
    fmt.Print("\n")
    break
  case "setStorageGroup":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SetStorageGroup requires 2 args")
      flag.Usage()
    }
    argvalue0, err473 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err473 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.SetStorageGroup(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "createTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseries requires 1 args")
      flag.Usage()
    }
    arg475 := flag.Arg(1)
    mbTrans476 := thrift.NewTMemoryBufferLen(len(arg475))
    defer mbTrans476.Close()
    _, err477 := mbTrans476.WriteString(arg475)
    if err477 != nil {
      Usage()
      return
    }
    factory478 := thrift.NewTJSONProtocolFactory()
    jsProt479 := factory478.GetProtocol(mbTrans476)
    argvalue0 := rpc.NewTSCreateTimeseriesReq()
    err480 := argvalue0.Read(context.Background(), jsProt479)
    if err480 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createAlignedTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateAlignedTimeseries requires 1 args")
      flag.Usage()
    }
    arg481 := flag.Arg(1)
    mbTrans482 := thrift.NewTMemoryBufferLen(len(arg481))
    defer mbTrans482.Close()
    _, err483 := mbTrans482.WriteString(arg481)
    if err483 != nil {
      Usage()
      return
    }
    factory484 := thrift.NewTJSONProtocolFactory()
    jsProt485 := factory484.GetProtocol(mbTrans482)
    argvalue0 := rpc.NewTSCreateAlignedTimeseriesReq()
    err486 := argvalue0.Read(context.Background(), jsProt485)
    if err486 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateAlignedTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createMultiTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateMultiTimeseries requires 1 args")
      flag.Usage()
    }
    arg487 := flag.Arg(1)
    mbTrans488 := thrift.NewTMemoryBufferLen(len(arg487))
    defer mbTrans488.Close()
    _, err489 := mbTrans488.WriteString(arg487)
    if err489 != nil {
      Usage()
      return
    }
    factory490 := thrift.NewTJSONProtocolFactory()
    jsProt491 := factory490.GetProtocol(mbTrans488)
    argvalue0 := rpc.NewTSCreateMultiTimeseriesReq()
    err492 := argvalue0.Read(context.Background(), jsProt491)
    if err492 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateMultiTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteTimeseries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteTimeseries requires 2 args")
      flag.Usage()
    }
    argvalue0, err493 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err493 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg494 := flag.Arg(2)
    mbTrans495 := thrift.NewTMemoryBufferLen(len(arg494))
    defer mbTrans495.Close()
    _, err496 := mbTrans495.WriteString(arg494)
    if err496 != nil { 
      Usage()
      return
    }
    factory497 := thrift.NewTJSONProtocolFactory()
    jsProt498 := factory497.GetProtocol(mbTrans495)
    containerStruct1 := rpc.NewIClientRPCServiceDeleteTimeseriesArgs()
    err499 := containerStruct1.ReadField2(context.Background(), jsProt498)
    if err499 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    fmt.Print(client.DeleteTimeseries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "deleteStorageGroups":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteStorageGroups requires 2 args")
      flag.Usage()
    }
    argvalue0, err500 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err500 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg501 := flag.Arg(2)
    mbTrans502 := thrift.NewTMemoryBufferLen(len(arg501))
    defer mbTrans502.Close()
    _, err503 := mbTrans502.WriteString(arg501)
    if err503 != nil { 
      Usage()
      return
    }
    factory504 := thrift.NewTJSONProtocolFactory()
    jsProt505 := factory504.GetProtocol(mbTrans502)
    containerStruct1 := rpc.NewIClientRPCServiceDeleteStorageGroupsArgs()
    err506 := containerStruct1.ReadField2(context.Background(), jsProt505)
    if err506 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.StorageGroup
    value1 := argvalue1
    fmt.Print(client.DeleteStorageGroups(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "insertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecord requires 1 args")
      flag.Usage()
    }
    arg507 := flag.Arg(1)
    mbTrans508 := thrift.NewTMemoryBufferLen(len(arg507))
    defer mbTrans508.Close()
    _, err509 := mbTrans508.WriteString(arg507)
    if err509 != nil {
      Usage()
      return
    }
    factory510 := thrift.NewTJSONProtocolFactory()
    jsProt511 := factory510.GetProtocol(mbTrans508)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err512 := argvalue0.Read(context.Background(), jsProt511)
    if err512 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg513 := flag.Arg(1)
    mbTrans514 := thrift.NewTMemoryBufferLen(len(arg513))
    defer mbTrans514.Close()
    _, err515 := mbTrans514.WriteString(arg513)
    if err515 != nil {
      Usage()
      return
    }
    factory516 := thrift.NewTJSONProtocolFactory()
    jsProt517 := factory516.GetProtocol(mbTrans514)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err518 := argvalue0.Read(context.Background(), jsProt517)
    if err518 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablet requires 1 args")
      flag.Usage()
    }
    arg519 := flag.Arg(1)
    mbTrans520 := thrift.NewTMemoryBufferLen(len(arg519))
    defer mbTrans520.Close()
    _, err521 := mbTrans520.WriteString(arg519)
    if err521 != nil {
      Usage()
      return
    }
    factory522 := thrift.NewTJSONProtocolFactory()
    jsProt523 := factory522.GetProtocol(mbTrans520)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err524 := argvalue0.Read(context.Background(), jsProt523)
    if err524 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablets requires 1 args")
      flag.Usage()
    }
    arg525 := flag.Arg(1)
    mbTrans526 := thrift.NewTMemoryBufferLen(len(arg525))
    defer mbTrans526.Close()
    _, err527 := mbTrans526.WriteString(arg525)
    if err527 != nil {
      Usage()
      return
    }
    factory528 := thrift.NewTJSONProtocolFactory()
    jsProt529 := factory528.GetProtocol(mbTrans526)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err530 := argvalue0.Read(context.Background(), jsProt529)
    if err530 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecords requires 1 args")
      flag.Usage()
    }
    arg531 := flag.Arg(1)
    mbTrans532 := thrift.NewTMemoryBufferLen(len(arg531))
    defer mbTrans532.Close()
    _, err533 := mbTrans532.WriteString(arg531)
    if err533 != nil {
      Usage()
      return
    }
    factory534 := thrift.NewTJSONProtocolFactory()
    jsProt535 := factory534.GetProtocol(mbTrans532)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err536 := argvalue0.Read(context.Background(), jsProt535)
    if err536 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg537 := flag.Arg(1)
    mbTrans538 := thrift.NewTMemoryBufferLen(len(arg537))
    defer mbTrans538.Close()
    _, err539 := mbTrans538.WriteString(arg537)
    if err539 != nil {
      Usage()
      return
    }
    factory540 := thrift.NewTJSONProtocolFactory()
    jsProt541 := factory540.GetProtocol(mbTrans538)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err542 := argvalue0.Read(context.Background(), jsProt541)
    if err542 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg543 := flag.Arg(1)
    mbTrans544 := thrift.NewTMemoryBufferLen(len(arg543))
    defer mbTrans544.Close()
    _, err545 := mbTrans544.WriteString(arg543)
    if err545 != nil {
      Usage()
      return
    }
    factory546 := thrift.NewTJSONProtocolFactory()
    jsProt547 := factory546.GetProtocol(mbTrans544)
    argvalue0 := rpc.NewTSInsertStringRecordsOfOneDeviceReq()
    err548 := argvalue0.Read(context.Background(), jsProt547)
    if err548 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg549 := flag.Arg(1)
    mbTrans550 := thrift.NewTMemoryBufferLen(len(arg549))
    defer mbTrans550.Close()
    _, err551 := mbTrans550.WriteString(arg549)
    if err551 != nil {
      Usage()
      return
    }
    factory552 := thrift.NewTJSONProtocolFactory()
    jsProt553 := factory552.GetProtocol(mbTrans550)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err554 := argvalue0.Read(context.Background(), jsProt553)
    if err554 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablet requires 1 args")
      flag.Usage()
    }
    arg555 := flag.Arg(1)
    mbTrans556 := thrift.NewTMemoryBufferLen(len(arg555))
    defer mbTrans556.Close()
    _, err557 := mbTrans556.WriteString(arg555)
    if err557 != nil {
      Usage()
      return
    }
    factory558 := thrift.NewTJSONProtocolFactory()
    jsProt559 := factory558.GetProtocol(mbTrans556)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err560 := argvalue0.Read(context.Background(), jsProt559)
    if err560 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablets requires 1 args")
      flag.Usage()
    }
    arg561 := flag.Arg(1)
    mbTrans562 := thrift.NewTMemoryBufferLen(len(arg561))
    defer mbTrans562.Close()
    _, err563 := mbTrans562.WriteString(arg561)
    if err563 != nil {
      Usage()
      return
    }
    factory564 := thrift.NewTJSONProtocolFactory()
    jsProt565 := factory564.GetProtocol(mbTrans562)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err566 := argvalue0.Read(context.Background(), jsProt565)
    if err566 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecord requires 1 args")
      flag.Usage()
    }
    arg567 := flag.Arg(1)
    mbTrans568 := thrift.NewTMemoryBufferLen(len(arg567))
    defer mbTrans568.Close()
    _, err569 := mbTrans568.WriteString(arg567)
    if err569 != nil {
      Usage()
      return
    }
    factory570 := thrift.NewTJSONProtocolFactory()
    jsProt571 := factory570.GetProtocol(mbTrans568)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err572 := argvalue0.Read(context.Background(), jsProt571)
    if err572 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg573 := flag.Arg(1)
    mbTrans574 := thrift.NewTMemoryBufferLen(len(arg573))
    defer mbTrans574.Close()
    _, err575 := mbTrans574.WriteString(arg573)
    if err575 != nil {
      Usage()
      return
    }
    factory576 := thrift.NewTJSONProtocolFactory()
    jsProt577 := factory576.GetProtocol(mbTrans574)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err578 := argvalue0.Read(context.Background(), jsProt577)
    if err578 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecords requires 1 args")
      flag.Usage()
    }
    arg579 := flag.Arg(1)
    mbTrans580 := thrift.NewTMemoryBufferLen(len(arg579))
    defer mbTrans580.Close()
    _, err581 := mbTrans580.WriteString(arg579)
    if err581 != nil {
      Usage()
      return
    }
    factory582 := thrift.NewTJSONProtocolFactory()
    jsProt583 := factory582.GetProtocol(mbTrans580)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err584 := argvalue0.Read(context.Background(), jsProt583)
    if err584 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg585 := flag.Arg(1)
    mbTrans586 := thrift.NewTMemoryBufferLen(len(arg585))
    defer mbTrans586.Close()
    _, err587 := mbTrans586.WriteString(arg585)
    if err587 != nil {
      Usage()
      return
    }
    factory588 := thrift.NewTJSONProtocolFactory()
    jsProt589 := factory588.GetProtocol(mbTrans586)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err590 := argvalue0.Read(context.Background(), jsProt589)
    if err590 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg591 := flag.Arg(1)
    mbTrans592 := thrift.NewTMemoryBufferLen(len(arg591))
    defer mbTrans592.Close()
    _, err593 := mbTrans592.WriteString(arg591)
    if err593 != nil {
      Usage()
      return
    }
    factory594 := thrift.NewTJSONProtocolFactory()
    jsProt595 := factory594.GetProtocol(mbTrans592)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err596 := argvalue0.Read(context.Background(), jsProt595)
    if err596 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DeleteData requires 1 args")
      flag.Usage()
    }
    arg597 := flag.Arg(1)
    mbTrans598 := thrift.NewTMemoryBufferLen(len(arg597))
    defer mbTrans598.Close()
    _, err599 := mbTrans598.WriteString(arg597)
    if err599 != nil {
      Usage()
      return
    }
    factory600 := thrift.NewTJSONProtocolFactory()
    jsProt601 := factory600.GetProtocol(mbTrans598)
    argvalue0 := rpc.NewTSDeleteDataReq()
    err602 := argvalue0.Read(context.Background(), jsProt601)
    if err602 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DeleteData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQuery requires 1 args")
      flag.Usage()
    }
    arg603 := flag.Arg(1)
    mbTrans604 := thrift.NewTMemoryBufferLen(len(arg603))
    defer mbTrans604.Close()
    _, err605 := mbTrans604.WriteString(arg603)
    if err605 != nil {
      Usage()
      return
    }
    factory606 := thrift.NewTJSONProtocolFactory()
    jsProt607 := factory606.GetProtocol(mbTrans604)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err608 := argvalue0.Read(context.Background(), jsProt607)
    if err608 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQuery requires 1 args")
      flag.Usage()
    }
    arg609 := flag.Arg(1)
    mbTrans610 := thrift.NewTMemoryBufferLen(len(arg609))
    defer mbTrans610.Close()
    _, err611 := mbTrans610.WriteString(arg609)
    if err611 != nil {
      Usage()
      return
    }
    factory612 := thrift.NewTJSONProtocolFactory()
    jsProt613 := factory612.GetProtocol(mbTrans610)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err614 := argvalue0.Read(context.Background(), jsProt613)
    if err614 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeAggregationQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteAggregationQuery requires 1 args")
      flag.Usage()
    }
    arg615 := flag.Arg(1)
    mbTrans616 := thrift.NewTMemoryBufferLen(len(arg615))
    defer mbTrans616.Close()
    _, err617 := mbTrans616.WriteString(arg615)
    if err617 != nil {
      Usage()
      return
    }
    factory618 := thrift.NewTJSONProtocolFactory()
    jsProt619 := factory618.GetProtocol(mbTrans616)
    argvalue0 := rpc.NewTSAggregationQueryReq()
    err620 := argvalue0.Read(context.Background(), jsProt619)
    if err620 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteAggregationQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestStatementId":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestStatementId requires 1 args")
      flag.Usage()
    }
    argvalue0, err621 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err621 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestStatementId(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg622 := flag.Arg(1)
    mbTrans623 := thrift.NewTMemoryBufferLen(len(arg622))
    defer mbTrans623.Close()
    _, err624 := mbTrans623.WriteString(arg622)
    if err624 != nil {
      Usage()
      return
    }
    factory625 := thrift.NewTJSONProtocolFactory()
    jsProt626 := factory625.GetProtocol(mbTrans623)
    argvalue0 := rpc.NewTSCreateSchemaTemplateReq()
    err627 := argvalue0.Read(context.Background(), jsProt626)
    if err627 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg628 := flag.Arg(1)
    mbTrans629 := thrift.NewTMemoryBufferLen(len(arg628))
    defer mbTrans629.Close()
    _, err630 := mbTrans629.WriteString(arg628)
    if err630 != nil {
      Usage()
      return
    }
    factory631 := thrift.NewTJSONProtocolFactory()
    jsProt632 := factory631.GetProtocol(mbTrans629)
    argvalue0 := rpc.NewTSAppendSchemaTemplateReq()
    err633 := argvalue0.Read(context.Background(), jsProt632)
    if err633 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pruneSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PruneSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg634 := flag.Arg(1)
    mbTrans635 := thrift.NewTMemoryBufferLen(len(arg634))
    defer mbTrans635.Close()
    _, err636 := mbTrans635.WriteString(arg634)
    if err636 != nil {
      Usage()
      return
    }
    factory637 := thrift.NewTJSONProtocolFactory()
    jsProt638 := factory637.GetProtocol(mbTrans635)
    argvalue0 := rpc.NewTSPruneSchemaTemplateReq()
    err639 := argvalue0.Read(context.Background(), jsProt638)
    if err639 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PruneSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "querySchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg640 := flag.Arg(1)
    mbTrans641 := thrift.NewTMemoryBufferLen(len(arg640))
    defer mbTrans641.Close()
    _, err642 := mbTrans641.WriteString(arg640)
    if err642 != nil {
      Usage()
      return
    }
    factory643 := thrift.NewTJSONProtocolFactory()
    jsProt644 := factory643.GetProtocol(mbTrans641)
    argvalue0 := rpc.NewTSQueryTemplateReq()
    err645 := argvalue0.Read(context.Background(), jsProt644)
    if err645 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg646 := flag.Arg(1)
    mbTrans647 := thrift.NewTMemoryBufferLen(len(arg646))
    defer mbTrans647.Close()
    _, err648 := mbTrans647.WriteString(arg646)
    if err648 != nil {
      Usage()
      return
    }
    factory649 := thrift.NewTJSONProtocolFactory()
    jsProt650 := factory649.GetProtocol(mbTrans647)
    argvalue0 := rpc.NewTSSetSchemaTemplateReq()
    err651 := argvalue0.Read(context.Background(), jsProt650)
    if err651 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "unsetSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "UnsetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg652 := flag.Arg(1)
    mbTrans653 := thrift.NewTMemoryBufferLen(len(arg652))
    defer mbTrans653.Close()
    _, err654 := mbTrans653.WriteString(arg652)
    if err654 != nil {
      Usage()
      return
    }
    factory655 := thrift.NewTJSONProtocolFactory()
    jsProt656 := factory655.GetProtocol(mbTrans653)
    argvalue0 := rpc.NewTSUnsetSchemaTemplateReq()
    err657 := argvalue0.Read(context.Background(), jsProt656)
    if err657 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.UnsetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "dropSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DropSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg658 := flag.Arg(1)
    mbTrans659 := thrift.NewTMemoryBufferLen(len(arg658))
    defer mbTrans659.Close()
    _, err660 := mbTrans659.WriteString(arg658)
    if err660 != nil {
      Usage()
      return
    }
    factory661 := thrift.NewTJSONProtocolFactory()
    jsProt662 := factory661.GetProtocol(mbTrans659)
    argvalue0 := rpc.NewTSDropSchemaTemplateReq()
    err663 := argvalue0.Read(context.Background(), jsProt662)
    if err663 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DropSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createTimeseriesUsingSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseriesUsingSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg664 := flag.Arg(1)
    mbTrans665 := thrift.NewTMemoryBufferLen(len(arg664))
    defer mbTrans665.Close()
    _, err666 := mbTrans665.WriteString(arg664)
    if err666 != nil {
      Usage()
      return
    }
    factory667 := thrift.NewTJSONProtocolFactory()
    jsProt668 := factory667.GetProtocol(mbTrans665)
    argvalue0 := rpc.NewTCreateTimeseriesUsingSchemaTemplateReq()
    err669 := argvalue0.Read(context.Background(), jsProt668)
    if err669 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseriesUsingSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "handshake":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Handshake requires 1 args")
      flag.Usage()
    }
    arg670 := flag.Arg(1)
    mbTrans671 := thrift.NewTMemoryBufferLen(len(arg670))
    defer mbTrans671.Close()
    _, err672 := mbTrans671.WriteString(arg670)
    if err672 != nil {
      Usage()
      return
    }
    factory673 := thrift.NewTJSONProtocolFactory()
    jsProt674 := factory673.GetProtocol(mbTrans671)
    argvalue0 := rpc.NewTSyncIdentityInfo()
    err675 := argvalue0.Read(context.Background(), jsProt674)
    if err675 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.Handshake(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendPipeData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendPipeData requires 1 args")
      flag.Usage()
    }
    argvalue0 := []byte(flag.Arg(1))
    value0 := argvalue0
    fmt.Print(client.SendPipeData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendFile":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SendFile requires 2 args")
      flag.Usage()
    }
    arg677 := flag.Arg(1)
    mbTrans678 := thrift.NewTMemoryBufferLen(len(arg677))
    defer mbTrans678.Close()
    _, err679 := mbTrans678.WriteString(arg677)
    if err679 != nil {
      Usage()
      return
    }
    factory680 := thrift.NewTJSONProtocolFactory()
    jsProt681 := factory680.GetProtocol(mbTrans678)
    argvalue0 := rpc.NewTSyncTransportMetaInfo()
    err682 := argvalue0.Read(context.Background(), jsProt681)
    if err682 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := []byte(flag.Arg(2))
    value1 := argvalue1
    fmt.Print(client.SendFile(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "getBackupConfiguration":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetBackupConfiguration requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetBackupConfiguration(context.Background()))
    fmt.Print("\n")
    break
  case "fetchAllConnectionsInfo":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "FetchAllConnectionsInfo requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.FetchAllConnectionsInfo(context.Background()))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
