// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"common"
	"rpc"
)

var _ = common.GoUnusedProtection__
var _ = rpc.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQueryV2(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQueryV2(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeFastLastDataQueryForOneDeviceV2(TSFastLastDataQueryForOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeAggregationQueryV2(TSAggregationQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeGroupByQueryIntervalQuery(TSGroupByQueryIntervalReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResultsV2(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSOpenSessionResp openSession(TSOpenSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeSession(TSCloseSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeBatchStatement(TSExecuteBatchStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResults(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus cancelOperation(TSCancelOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeOperation(TSCloseOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSGetTimeZoneResp getTimeZone(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus setTimeZone(TSSetTimeZoneReq req)")
  fmt.Fprintln(os.Stderr, "  ServerProperties getProperties()")
  fmt.Fprintln(os.Stderr, "  TSStatus setStorageGroup(i64 sessionId, string storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseries(TSCreateTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteTimeseries(i64 sessionId,  path)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteStorageGroups(i64 sessionId,  storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteData(TSDeleteDataReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeAggregationQuery(TSAggregationQueryReq req)")
  fmt.Fprintln(os.Stderr, "  i64 requestStatementId(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseriesUsingSchemaTemplate(TCreateTimeseriesUsingSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus handshake(TSyncIdentityInfo info)")
  fmt.Fprintln(os.Stderr, "  TSStatus sendPipeData(string buff)")
  fmt.Fprintln(os.Stderr, "  TSStatus sendFile(TSyncTransportMetaInfo metaInfo, string buff)")
  fmt.Fprintln(os.Stderr, "  TPipeTransferResp pipeTransfer(TPipeTransferReq req)")
  fmt.Fprintln(os.Stderr, "  TSBackupConfigurationResp getBackupConfiguration()")
  fmt.Fprintln(os.Stderr, "  TSConnectionInfoResp fetchAllConnectionsInfo()")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := rpc.NewIClientRPCServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "executeQueryStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatementV2 requires 1 args")
      flag.Usage()
    }
    arg375 := flag.Arg(1)
    mbTrans376 := thrift.NewTMemoryBufferLen(len(arg375))
    defer mbTrans376.Close()
    _, err377 := mbTrans376.WriteString(arg375)
    if err377 != nil {
      Usage()
      return
    }
    factory378 := thrift.NewTJSONProtocolFactory()
    jsProt379 := factory378.GetProtocol(mbTrans376)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err380 := argvalue0.Read(context.Background(), jsProt379)
    if err380 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatementV2 requires 1 args")
      flag.Usage()
    }
    arg381 := flag.Arg(1)
    mbTrans382 := thrift.NewTMemoryBufferLen(len(arg381))
    defer mbTrans382.Close()
    _, err383 := mbTrans382.WriteString(arg381)
    if err383 != nil {
      Usage()
      return
    }
    factory384 := thrift.NewTJSONProtocolFactory()
    jsProt385 := factory384.GetProtocol(mbTrans382)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err386 := argvalue0.Read(context.Background(), jsProt385)
    if err386 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatementV2 requires 1 args")
      flag.Usage()
    }
    arg387 := flag.Arg(1)
    mbTrans388 := thrift.NewTMemoryBufferLen(len(arg387))
    defer mbTrans388.Close()
    _, err389 := mbTrans388.WriteString(arg387)
    if err389 != nil {
      Usage()
      return
    }
    factory390 := thrift.NewTJSONProtocolFactory()
    jsProt391 := factory390.GetProtocol(mbTrans388)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err392 := argvalue0.Read(context.Background(), jsProt391)
    if err392 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQueryV2 requires 1 args")
      flag.Usage()
    }
    arg393 := flag.Arg(1)
    mbTrans394 := thrift.NewTMemoryBufferLen(len(arg393))
    defer mbTrans394.Close()
    _, err395 := mbTrans394.WriteString(arg393)
    if err395 != nil {
      Usage()
      return
    }
    factory396 := thrift.NewTJSONProtocolFactory()
    jsProt397 := factory396.GetProtocol(mbTrans394)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err398 := argvalue0.Read(context.Background(), jsProt397)
    if err398 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQueryV2 requires 1 args")
      flag.Usage()
    }
    arg399 := flag.Arg(1)
    mbTrans400 := thrift.NewTMemoryBufferLen(len(arg399))
    defer mbTrans400.Close()
    _, err401 := mbTrans400.WriteString(arg399)
    if err401 != nil {
      Usage()
      return
    }
    factory402 := thrift.NewTJSONProtocolFactory()
    jsProt403 := factory402.GetProtocol(mbTrans400)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err404 := argvalue0.Read(context.Background(), jsProt403)
    if err404 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeFastLastDataQueryForOneDeviceV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteFastLastDataQueryForOneDeviceV2 requires 1 args")
      flag.Usage()
    }
    arg405 := flag.Arg(1)
    mbTrans406 := thrift.NewTMemoryBufferLen(len(arg405))
    defer mbTrans406.Close()
    _, err407 := mbTrans406.WriteString(arg405)
    if err407 != nil {
      Usage()
      return
    }
    factory408 := thrift.NewTJSONProtocolFactory()
    jsProt409 := factory408.GetProtocol(mbTrans406)
    argvalue0 := rpc.NewTSFastLastDataQueryForOneDeviceReq()
    err410 := argvalue0.Read(context.Background(), jsProt409)
    if err410 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteFastLastDataQueryForOneDeviceV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeAggregationQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteAggregationQueryV2 requires 1 args")
      flag.Usage()
    }
    arg411 := flag.Arg(1)
    mbTrans412 := thrift.NewTMemoryBufferLen(len(arg411))
    defer mbTrans412.Close()
    _, err413 := mbTrans412.WriteString(arg411)
    if err413 != nil {
      Usage()
      return
    }
    factory414 := thrift.NewTJSONProtocolFactory()
    jsProt415 := factory414.GetProtocol(mbTrans412)
    argvalue0 := rpc.NewTSAggregationQueryReq()
    err416 := argvalue0.Read(context.Background(), jsProt415)
    if err416 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteAggregationQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeGroupByQueryIntervalQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteGroupByQueryIntervalQuery requires 1 args")
      flag.Usage()
    }
    arg417 := flag.Arg(1)
    mbTrans418 := thrift.NewTMemoryBufferLen(len(arg417))
    defer mbTrans418.Close()
    _, err419 := mbTrans418.WriteString(arg417)
    if err419 != nil {
      Usage()
      return
    }
    factory420 := thrift.NewTJSONProtocolFactory()
    jsProt421 := factory420.GetProtocol(mbTrans418)
    argvalue0 := rpc.NewTSGroupByQueryIntervalReq()
    err422 := argvalue0.Read(context.Background(), jsProt421)
    if err422 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteGroupByQueryIntervalQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResultsV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResultsV2 requires 1 args")
      flag.Usage()
    }
    arg423 := flag.Arg(1)
    mbTrans424 := thrift.NewTMemoryBufferLen(len(arg423))
    defer mbTrans424.Close()
    _, err425 := mbTrans424.WriteString(arg423)
    if err425 != nil {
      Usage()
      return
    }
    factory426 := thrift.NewTJSONProtocolFactory()
    jsProt427 := factory426.GetProtocol(mbTrans424)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err428 := argvalue0.Read(context.Background(), jsProt427)
    if err428 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResultsV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "openSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "OpenSession requires 1 args")
      flag.Usage()
    }
    arg429 := flag.Arg(1)
    mbTrans430 := thrift.NewTMemoryBufferLen(len(arg429))
    defer mbTrans430.Close()
    _, err431 := mbTrans430.WriteString(arg429)
    if err431 != nil {
      Usage()
      return
    }
    factory432 := thrift.NewTJSONProtocolFactory()
    jsProt433 := factory432.GetProtocol(mbTrans430)
    argvalue0 := rpc.NewTSOpenSessionReq()
    err434 := argvalue0.Read(context.Background(), jsProt433)
    if err434 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.OpenSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseSession requires 1 args")
      flag.Usage()
    }
    arg435 := flag.Arg(1)
    mbTrans436 := thrift.NewTMemoryBufferLen(len(arg435))
    defer mbTrans436.Close()
    _, err437 := mbTrans436.WriteString(arg435)
    if err437 != nil {
      Usage()
      return
    }
    factory438 := thrift.NewTJSONProtocolFactory()
    jsProt439 := factory438.GetProtocol(mbTrans436)
    argvalue0 := rpc.NewTSCloseSessionReq()
    err440 := argvalue0.Read(context.Background(), jsProt439)
    if err440 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatement requires 1 args")
      flag.Usage()
    }
    arg441 := flag.Arg(1)
    mbTrans442 := thrift.NewTMemoryBufferLen(len(arg441))
    defer mbTrans442.Close()
    _, err443 := mbTrans442.WriteString(arg441)
    if err443 != nil {
      Usage()
      return
    }
    factory444 := thrift.NewTJSONProtocolFactory()
    jsProt445 := factory444.GetProtocol(mbTrans442)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err446 := argvalue0.Read(context.Background(), jsProt445)
    if err446 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeBatchStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteBatchStatement requires 1 args")
      flag.Usage()
    }
    arg447 := flag.Arg(1)
    mbTrans448 := thrift.NewTMemoryBufferLen(len(arg447))
    defer mbTrans448.Close()
    _, err449 := mbTrans448.WriteString(arg447)
    if err449 != nil {
      Usage()
      return
    }
    factory450 := thrift.NewTJSONProtocolFactory()
    jsProt451 := factory450.GetProtocol(mbTrans448)
    argvalue0 := rpc.NewTSExecuteBatchStatementReq()
    err452 := argvalue0.Read(context.Background(), jsProt451)
    if err452 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteBatchStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeQueryStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatement requires 1 args")
      flag.Usage()
    }
    arg453 := flag.Arg(1)
    mbTrans454 := thrift.NewTMemoryBufferLen(len(arg453))
    defer mbTrans454.Close()
    _, err455 := mbTrans454.WriteString(arg453)
    if err455 != nil {
      Usage()
      return
    }
    factory456 := thrift.NewTJSONProtocolFactory()
    jsProt457 := factory456.GetProtocol(mbTrans454)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err458 := argvalue0.Read(context.Background(), jsProt457)
    if err458 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatement requires 1 args")
      flag.Usage()
    }
    arg459 := flag.Arg(1)
    mbTrans460 := thrift.NewTMemoryBufferLen(len(arg459))
    defer mbTrans460.Close()
    _, err461 := mbTrans460.WriteString(arg459)
    if err461 != nil {
      Usage()
      return
    }
    factory462 := thrift.NewTJSONProtocolFactory()
    jsProt463 := factory462.GetProtocol(mbTrans460)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err464 := argvalue0.Read(context.Background(), jsProt463)
    if err464 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResults":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResults requires 1 args")
      flag.Usage()
    }
    arg465 := flag.Arg(1)
    mbTrans466 := thrift.NewTMemoryBufferLen(len(arg465))
    defer mbTrans466.Close()
    _, err467 := mbTrans466.WriteString(arg465)
    if err467 != nil {
      Usage()
      return
    }
    factory468 := thrift.NewTJSONProtocolFactory()
    jsProt469 := factory468.GetProtocol(mbTrans466)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err470 := argvalue0.Read(context.Background(), jsProt469)
    if err470 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResults(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchMetadata":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchMetadata requires 1 args")
      flag.Usage()
    }
    arg471 := flag.Arg(1)
    mbTrans472 := thrift.NewTMemoryBufferLen(len(arg471))
    defer mbTrans472.Close()
    _, err473 := mbTrans472.WriteString(arg471)
    if err473 != nil {
      Usage()
      return
    }
    factory474 := thrift.NewTJSONProtocolFactory()
    jsProt475 := factory474.GetProtocol(mbTrans472)
    argvalue0 := rpc.NewTSFetchMetadataReq()
    err476 := argvalue0.Read(context.Background(), jsProt475)
    if err476 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchMetadata(context.Background(), value0))
    fmt.Print("\n")
    break
  case "cancelOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CancelOperation requires 1 args")
      flag.Usage()
    }
    arg477 := flag.Arg(1)
    mbTrans478 := thrift.NewTMemoryBufferLen(len(arg477))
    defer mbTrans478.Close()
    _, err479 := mbTrans478.WriteString(arg477)
    if err479 != nil {
      Usage()
      return
    }
    factory480 := thrift.NewTJSONProtocolFactory()
    jsProt481 := factory480.GetProtocol(mbTrans478)
    argvalue0 := rpc.NewTSCancelOperationReq()
    err482 := argvalue0.Read(context.Background(), jsProt481)
    if err482 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CancelOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseOperation requires 1 args")
      flag.Usage()
    }
    arg483 := flag.Arg(1)
    mbTrans484 := thrift.NewTMemoryBufferLen(len(arg483))
    defer mbTrans484.Close()
    _, err485 := mbTrans484.WriteString(arg483)
    if err485 != nil {
      Usage()
      return
    }
    factory486 := thrift.NewTJSONProtocolFactory()
    jsProt487 := factory486.GetProtocol(mbTrans484)
    argvalue0 := rpc.NewTSCloseOperationReq()
    err488 := argvalue0.Read(context.Background(), jsProt487)
    if err488 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetTimeZone requires 1 args")
      flag.Usage()
    }
    argvalue0, err489 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err489 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetTimeZone requires 1 args")
      flag.Usage()
    }
    arg490 := flag.Arg(1)
    mbTrans491 := thrift.NewTMemoryBufferLen(len(arg490))
    defer mbTrans491.Close()
    _, err492 := mbTrans491.WriteString(arg490)
    if err492 != nil {
      Usage()
      return
    }
    factory493 := thrift.NewTJSONProtocolFactory()
    jsProt494 := factory493.GetProtocol(mbTrans491)
    argvalue0 := rpc.NewTSSetTimeZoneReq()
    err495 := argvalue0.Read(context.Background(), jsProt494)
    if err495 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getProperties":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetProperties requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetProperties(context.Background()))
    fmt.Print("\n")
    break
  case "setStorageGroup":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SetStorageGroup requires 2 args")
      flag.Usage()
    }
    argvalue0, err496 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err496 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.SetStorageGroup(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "createTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseries requires 1 args")
      flag.Usage()
    }
    arg498 := flag.Arg(1)
    mbTrans499 := thrift.NewTMemoryBufferLen(len(arg498))
    defer mbTrans499.Close()
    _, err500 := mbTrans499.WriteString(arg498)
    if err500 != nil {
      Usage()
      return
    }
    factory501 := thrift.NewTJSONProtocolFactory()
    jsProt502 := factory501.GetProtocol(mbTrans499)
    argvalue0 := rpc.NewTSCreateTimeseriesReq()
    err503 := argvalue0.Read(context.Background(), jsProt502)
    if err503 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createAlignedTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateAlignedTimeseries requires 1 args")
      flag.Usage()
    }
    arg504 := flag.Arg(1)
    mbTrans505 := thrift.NewTMemoryBufferLen(len(arg504))
    defer mbTrans505.Close()
    _, err506 := mbTrans505.WriteString(arg504)
    if err506 != nil {
      Usage()
      return
    }
    factory507 := thrift.NewTJSONProtocolFactory()
    jsProt508 := factory507.GetProtocol(mbTrans505)
    argvalue0 := rpc.NewTSCreateAlignedTimeseriesReq()
    err509 := argvalue0.Read(context.Background(), jsProt508)
    if err509 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateAlignedTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createMultiTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateMultiTimeseries requires 1 args")
      flag.Usage()
    }
    arg510 := flag.Arg(1)
    mbTrans511 := thrift.NewTMemoryBufferLen(len(arg510))
    defer mbTrans511.Close()
    _, err512 := mbTrans511.WriteString(arg510)
    if err512 != nil {
      Usage()
      return
    }
    factory513 := thrift.NewTJSONProtocolFactory()
    jsProt514 := factory513.GetProtocol(mbTrans511)
    argvalue0 := rpc.NewTSCreateMultiTimeseriesReq()
    err515 := argvalue0.Read(context.Background(), jsProt514)
    if err515 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateMultiTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteTimeseries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteTimeseries requires 2 args")
      flag.Usage()
    }
    argvalue0, err516 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err516 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg517 := flag.Arg(2)
    mbTrans518 := thrift.NewTMemoryBufferLen(len(arg517))
    defer mbTrans518.Close()
    _, err519 := mbTrans518.WriteString(arg517)
    if err519 != nil { 
      Usage()
      return
    }
    factory520 := thrift.NewTJSONProtocolFactory()
    jsProt521 := factory520.GetProtocol(mbTrans518)
    containerStruct1 := rpc.NewIClientRPCServiceDeleteTimeseriesArgs()
    err522 := containerStruct1.ReadField2(context.Background(), jsProt521)
    if err522 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    fmt.Print(client.DeleteTimeseries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "deleteStorageGroups":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteStorageGroups requires 2 args")
      flag.Usage()
    }
    argvalue0, err523 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err523 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg524 := flag.Arg(2)
    mbTrans525 := thrift.NewTMemoryBufferLen(len(arg524))
    defer mbTrans525.Close()
    _, err526 := mbTrans525.WriteString(arg524)
    if err526 != nil { 
      Usage()
      return
    }
    factory527 := thrift.NewTJSONProtocolFactory()
    jsProt528 := factory527.GetProtocol(mbTrans525)
    containerStruct1 := rpc.NewIClientRPCServiceDeleteStorageGroupsArgs()
    err529 := containerStruct1.ReadField2(context.Background(), jsProt528)
    if err529 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.StorageGroup
    value1 := argvalue1
    fmt.Print(client.DeleteStorageGroups(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "insertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecord requires 1 args")
      flag.Usage()
    }
    arg530 := flag.Arg(1)
    mbTrans531 := thrift.NewTMemoryBufferLen(len(arg530))
    defer mbTrans531.Close()
    _, err532 := mbTrans531.WriteString(arg530)
    if err532 != nil {
      Usage()
      return
    }
    factory533 := thrift.NewTJSONProtocolFactory()
    jsProt534 := factory533.GetProtocol(mbTrans531)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err535 := argvalue0.Read(context.Background(), jsProt534)
    if err535 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg536 := flag.Arg(1)
    mbTrans537 := thrift.NewTMemoryBufferLen(len(arg536))
    defer mbTrans537.Close()
    _, err538 := mbTrans537.WriteString(arg536)
    if err538 != nil {
      Usage()
      return
    }
    factory539 := thrift.NewTJSONProtocolFactory()
    jsProt540 := factory539.GetProtocol(mbTrans537)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err541 := argvalue0.Read(context.Background(), jsProt540)
    if err541 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablet requires 1 args")
      flag.Usage()
    }
    arg542 := flag.Arg(1)
    mbTrans543 := thrift.NewTMemoryBufferLen(len(arg542))
    defer mbTrans543.Close()
    _, err544 := mbTrans543.WriteString(arg542)
    if err544 != nil {
      Usage()
      return
    }
    factory545 := thrift.NewTJSONProtocolFactory()
    jsProt546 := factory545.GetProtocol(mbTrans543)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err547 := argvalue0.Read(context.Background(), jsProt546)
    if err547 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablets requires 1 args")
      flag.Usage()
    }
    arg548 := flag.Arg(1)
    mbTrans549 := thrift.NewTMemoryBufferLen(len(arg548))
    defer mbTrans549.Close()
    _, err550 := mbTrans549.WriteString(arg548)
    if err550 != nil {
      Usage()
      return
    }
    factory551 := thrift.NewTJSONProtocolFactory()
    jsProt552 := factory551.GetProtocol(mbTrans549)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err553 := argvalue0.Read(context.Background(), jsProt552)
    if err553 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecords requires 1 args")
      flag.Usage()
    }
    arg554 := flag.Arg(1)
    mbTrans555 := thrift.NewTMemoryBufferLen(len(arg554))
    defer mbTrans555.Close()
    _, err556 := mbTrans555.WriteString(arg554)
    if err556 != nil {
      Usage()
      return
    }
    factory557 := thrift.NewTJSONProtocolFactory()
    jsProt558 := factory557.GetProtocol(mbTrans555)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err559 := argvalue0.Read(context.Background(), jsProt558)
    if err559 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg560 := flag.Arg(1)
    mbTrans561 := thrift.NewTMemoryBufferLen(len(arg560))
    defer mbTrans561.Close()
    _, err562 := mbTrans561.WriteString(arg560)
    if err562 != nil {
      Usage()
      return
    }
    factory563 := thrift.NewTJSONProtocolFactory()
    jsProt564 := factory563.GetProtocol(mbTrans561)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err565 := argvalue0.Read(context.Background(), jsProt564)
    if err565 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg566 := flag.Arg(1)
    mbTrans567 := thrift.NewTMemoryBufferLen(len(arg566))
    defer mbTrans567.Close()
    _, err568 := mbTrans567.WriteString(arg566)
    if err568 != nil {
      Usage()
      return
    }
    factory569 := thrift.NewTJSONProtocolFactory()
    jsProt570 := factory569.GetProtocol(mbTrans567)
    argvalue0 := rpc.NewTSInsertStringRecordsOfOneDeviceReq()
    err571 := argvalue0.Read(context.Background(), jsProt570)
    if err571 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg572 := flag.Arg(1)
    mbTrans573 := thrift.NewTMemoryBufferLen(len(arg572))
    defer mbTrans573.Close()
    _, err574 := mbTrans573.WriteString(arg572)
    if err574 != nil {
      Usage()
      return
    }
    factory575 := thrift.NewTJSONProtocolFactory()
    jsProt576 := factory575.GetProtocol(mbTrans573)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err577 := argvalue0.Read(context.Background(), jsProt576)
    if err577 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablet requires 1 args")
      flag.Usage()
    }
    arg578 := flag.Arg(1)
    mbTrans579 := thrift.NewTMemoryBufferLen(len(arg578))
    defer mbTrans579.Close()
    _, err580 := mbTrans579.WriteString(arg578)
    if err580 != nil {
      Usage()
      return
    }
    factory581 := thrift.NewTJSONProtocolFactory()
    jsProt582 := factory581.GetProtocol(mbTrans579)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err583 := argvalue0.Read(context.Background(), jsProt582)
    if err583 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablets requires 1 args")
      flag.Usage()
    }
    arg584 := flag.Arg(1)
    mbTrans585 := thrift.NewTMemoryBufferLen(len(arg584))
    defer mbTrans585.Close()
    _, err586 := mbTrans585.WriteString(arg584)
    if err586 != nil {
      Usage()
      return
    }
    factory587 := thrift.NewTJSONProtocolFactory()
    jsProt588 := factory587.GetProtocol(mbTrans585)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err589 := argvalue0.Read(context.Background(), jsProt588)
    if err589 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecord requires 1 args")
      flag.Usage()
    }
    arg590 := flag.Arg(1)
    mbTrans591 := thrift.NewTMemoryBufferLen(len(arg590))
    defer mbTrans591.Close()
    _, err592 := mbTrans591.WriteString(arg590)
    if err592 != nil {
      Usage()
      return
    }
    factory593 := thrift.NewTJSONProtocolFactory()
    jsProt594 := factory593.GetProtocol(mbTrans591)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err595 := argvalue0.Read(context.Background(), jsProt594)
    if err595 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg596 := flag.Arg(1)
    mbTrans597 := thrift.NewTMemoryBufferLen(len(arg596))
    defer mbTrans597.Close()
    _, err598 := mbTrans597.WriteString(arg596)
    if err598 != nil {
      Usage()
      return
    }
    factory599 := thrift.NewTJSONProtocolFactory()
    jsProt600 := factory599.GetProtocol(mbTrans597)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err601 := argvalue0.Read(context.Background(), jsProt600)
    if err601 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecords requires 1 args")
      flag.Usage()
    }
    arg602 := flag.Arg(1)
    mbTrans603 := thrift.NewTMemoryBufferLen(len(arg602))
    defer mbTrans603.Close()
    _, err604 := mbTrans603.WriteString(arg602)
    if err604 != nil {
      Usage()
      return
    }
    factory605 := thrift.NewTJSONProtocolFactory()
    jsProt606 := factory605.GetProtocol(mbTrans603)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err607 := argvalue0.Read(context.Background(), jsProt606)
    if err607 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg608 := flag.Arg(1)
    mbTrans609 := thrift.NewTMemoryBufferLen(len(arg608))
    defer mbTrans609.Close()
    _, err610 := mbTrans609.WriteString(arg608)
    if err610 != nil {
      Usage()
      return
    }
    factory611 := thrift.NewTJSONProtocolFactory()
    jsProt612 := factory611.GetProtocol(mbTrans609)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err613 := argvalue0.Read(context.Background(), jsProt612)
    if err613 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg614 := flag.Arg(1)
    mbTrans615 := thrift.NewTMemoryBufferLen(len(arg614))
    defer mbTrans615.Close()
    _, err616 := mbTrans615.WriteString(arg614)
    if err616 != nil {
      Usage()
      return
    }
    factory617 := thrift.NewTJSONProtocolFactory()
    jsProt618 := factory617.GetProtocol(mbTrans615)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err619 := argvalue0.Read(context.Background(), jsProt618)
    if err619 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DeleteData requires 1 args")
      flag.Usage()
    }
    arg620 := flag.Arg(1)
    mbTrans621 := thrift.NewTMemoryBufferLen(len(arg620))
    defer mbTrans621.Close()
    _, err622 := mbTrans621.WriteString(arg620)
    if err622 != nil {
      Usage()
      return
    }
    factory623 := thrift.NewTJSONProtocolFactory()
    jsProt624 := factory623.GetProtocol(mbTrans621)
    argvalue0 := rpc.NewTSDeleteDataReq()
    err625 := argvalue0.Read(context.Background(), jsProt624)
    if err625 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DeleteData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQuery requires 1 args")
      flag.Usage()
    }
    arg626 := flag.Arg(1)
    mbTrans627 := thrift.NewTMemoryBufferLen(len(arg626))
    defer mbTrans627.Close()
    _, err628 := mbTrans627.WriteString(arg626)
    if err628 != nil {
      Usage()
      return
    }
    factory629 := thrift.NewTJSONProtocolFactory()
    jsProt630 := factory629.GetProtocol(mbTrans627)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err631 := argvalue0.Read(context.Background(), jsProt630)
    if err631 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQuery requires 1 args")
      flag.Usage()
    }
    arg632 := flag.Arg(1)
    mbTrans633 := thrift.NewTMemoryBufferLen(len(arg632))
    defer mbTrans633.Close()
    _, err634 := mbTrans633.WriteString(arg632)
    if err634 != nil {
      Usage()
      return
    }
    factory635 := thrift.NewTJSONProtocolFactory()
    jsProt636 := factory635.GetProtocol(mbTrans633)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err637 := argvalue0.Read(context.Background(), jsProt636)
    if err637 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeAggregationQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteAggregationQuery requires 1 args")
      flag.Usage()
    }
    arg638 := flag.Arg(1)
    mbTrans639 := thrift.NewTMemoryBufferLen(len(arg638))
    defer mbTrans639.Close()
    _, err640 := mbTrans639.WriteString(arg638)
    if err640 != nil {
      Usage()
      return
    }
    factory641 := thrift.NewTJSONProtocolFactory()
    jsProt642 := factory641.GetProtocol(mbTrans639)
    argvalue0 := rpc.NewTSAggregationQueryReq()
    err643 := argvalue0.Read(context.Background(), jsProt642)
    if err643 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteAggregationQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestStatementId":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestStatementId requires 1 args")
      flag.Usage()
    }
    argvalue0, err644 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err644 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestStatementId(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg645 := flag.Arg(1)
    mbTrans646 := thrift.NewTMemoryBufferLen(len(arg645))
    defer mbTrans646.Close()
    _, err647 := mbTrans646.WriteString(arg645)
    if err647 != nil {
      Usage()
      return
    }
    factory648 := thrift.NewTJSONProtocolFactory()
    jsProt649 := factory648.GetProtocol(mbTrans646)
    argvalue0 := rpc.NewTSCreateSchemaTemplateReq()
    err650 := argvalue0.Read(context.Background(), jsProt649)
    if err650 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg651 := flag.Arg(1)
    mbTrans652 := thrift.NewTMemoryBufferLen(len(arg651))
    defer mbTrans652.Close()
    _, err653 := mbTrans652.WriteString(arg651)
    if err653 != nil {
      Usage()
      return
    }
    factory654 := thrift.NewTJSONProtocolFactory()
    jsProt655 := factory654.GetProtocol(mbTrans652)
    argvalue0 := rpc.NewTSAppendSchemaTemplateReq()
    err656 := argvalue0.Read(context.Background(), jsProt655)
    if err656 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pruneSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PruneSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg657 := flag.Arg(1)
    mbTrans658 := thrift.NewTMemoryBufferLen(len(arg657))
    defer mbTrans658.Close()
    _, err659 := mbTrans658.WriteString(arg657)
    if err659 != nil {
      Usage()
      return
    }
    factory660 := thrift.NewTJSONProtocolFactory()
    jsProt661 := factory660.GetProtocol(mbTrans658)
    argvalue0 := rpc.NewTSPruneSchemaTemplateReq()
    err662 := argvalue0.Read(context.Background(), jsProt661)
    if err662 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PruneSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "querySchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg663 := flag.Arg(1)
    mbTrans664 := thrift.NewTMemoryBufferLen(len(arg663))
    defer mbTrans664.Close()
    _, err665 := mbTrans664.WriteString(arg663)
    if err665 != nil {
      Usage()
      return
    }
    factory666 := thrift.NewTJSONProtocolFactory()
    jsProt667 := factory666.GetProtocol(mbTrans664)
    argvalue0 := rpc.NewTSQueryTemplateReq()
    err668 := argvalue0.Read(context.Background(), jsProt667)
    if err668 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg669 := flag.Arg(1)
    mbTrans670 := thrift.NewTMemoryBufferLen(len(arg669))
    defer mbTrans670.Close()
    _, err671 := mbTrans670.WriteString(arg669)
    if err671 != nil {
      Usage()
      return
    }
    factory672 := thrift.NewTJSONProtocolFactory()
    jsProt673 := factory672.GetProtocol(mbTrans670)
    argvalue0 := rpc.NewTSSetSchemaTemplateReq()
    err674 := argvalue0.Read(context.Background(), jsProt673)
    if err674 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "unsetSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "UnsetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg675 := flag.Arg(1)
    mbTrans676 := thrift.NewTMemoryBufferLen(len(arg675))
    defer mbTrans676.Close()
    _, err677 := mbTrans676.WriteString(arg675)
    if err677 != nil {
      Usage()
      return
    }
    factory678 := thrift.NewTJSONProtocolFactory()
    jsProt679 := factory678.GetProtocol(mbTrans676)
    argvalue0 := rpc.NewTSUnsetSchemaTemplateReq()
    err680 := argvalue0.Read(context.Background(), jsProt679)
    if err680 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.UnsetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "dropSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DropSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg681 := flag.Arg(1)
    mbTrans682 := thrift.NewTMemoryBufferLen(len(arg681))
    defer mbTrans682.Close()
    _, err683 := mbTrans682.WriteString(arg681)
    if err683 != nil {
      Usage()
      return
    }
    factory684 := thrift.NewTJSONProtocolFactory()
    jsProt685 := factory684.GetProtocol(mbTrans682)
    argvalue0 := rpc.NewTSDropSchemaTemplateReq()
    err686 := argvalue0.Read(context.Background(), jsProt685)
    if err686 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DropSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createTimeseriesUsingSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseriesUsingSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg687 := flag.Arg(1)
    mbTrans688 := thrift.NewTMemoryBufferLen(len(arg687))
    defer mbTrans688.Close()
    _, err689 := mbTrans688.WriteString(arg687)
    if err689 != nil {
      Usage()
      return
    }
    factory690 := thrift.NewTJSONProtocolFactory()
    jsProt691 := factory690.GetProtocol(mbTrans688)
    argvalue0 := rpc.NewTCreateTimeseriesUsingSchemaTemplateReq()
    err692 := argvalue0.Read(context.Background(), jsProt691)
    if err692 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseriesUsingSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "handshake":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Handshake requires 1 args")
      flag.Usage()
    }
    arg693 := flag.Arg(1)
    mbTrans694 := thrift.NewTMemoryBufferLen(len(arg693))
    defer mbTrans694.Close()
    _, err695 := mbTrans694.WriteString(arg693)
    if err695 != nil {
      Usage()
      return
    }
    factory696 := thrift.NewTJSONProtocolFactory()
    jsProt697 := factory696.GetProtocol(mbTrans694)
    argvalue0 := rpc.NewTSyncIdentityInfo()
    err698 := argvalue0.Read(context.Background(), jsProt697)
    if err698 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.Handshake(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendPipeData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendPipeData requires 1 args")
      flag.Usage()
    }
    argvalue0 := []byte(flag.Arg(1))
    value0 := argvalue0
    fmt.Print(client.SendPipeData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendFile":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SendFile requires 2 args")
      flag.Usage()
    }
    arg700 := flag.Arg(1)
    mbTrans701 := thrift.NewTMemoryBufferLen(len(arg700))
    defer mbTrans701.Close()
    _, err702 := mbTrans701.WriteString(arg700)
    if err702 != nil {
      Usage()
      return
    }
    factory703 := thrift.NewTJSONProtocolFactory()
    jsProt704 := factory703.GetProtocol(mbTrans701)
    argvalue0 := rpc.NewTSyncTransportMetaInfo()
    err705 := argvalue0.Read(context.Background(), jsProt704)
    if err705 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := []byte(flag.Arg(2))
    value1 := argvalue1
    fmt.Print(client.SendFile(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "pipeTransfer":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PipeTransfer requires 1 args")
      flag.Usage()
    }
    arg707 := flag.Arg(1)
    mbTrans708 := thrift.NewTMemoryBufferLen(len(arg707))
    defer mbTrans708.Close()
    _, err709 := mbTrans708.WriteString(arg707)
    if err709 != nil {
      Usage()
      return
    }
    factory710 := thrift.NewTJSONProtocolFactory()
    jsProt711 := factory710.GetProtocol(mbTrans708)
    argvalue0 := rpc.NewTPipeTransferReq()
    err712 := argvalue0.Read(context.Background(), jsProt711)
    if err712 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PipeTransfer(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getBackupConfiguration":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetBackupConfiguration requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetBackupConfiguration(context.Background()))
    fmt.Print("\n")
    break
  case "fetchAllConnectionsInfo":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "FetchAllConnectionsInfo requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.FetchAllConnectionsInfo(context.Background()))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
