// Code generated by Thrift Compiler (0.14.1). DO NOT EDIT.

package main

import (
	"context"
	"flag"
	"fmt"
	"math"
	"net"
	"net/url"
	"os"
	"strconv"
	"strings"
	"github.com/apache/thrift/lib/go/thrift"
	"github.com/apache/iotdb-client-go/common"
	"github.com/apache/iotdb-client-go/rpc"
)

var _ = common.GoUnusedProtection__
var _ = rpc.GoUnusedProtection__

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatementV2(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQueryV2(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQueryV2(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeFastLastDataQueryForOneDeviceV2(TSFastLastDataQueryForOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeAggregationQueryV2(TSAggregationQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeGroupByQueryIntervalQuery(TSGroupByQueryIntervalReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResultsV2(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSOpenSessionResp openSession(TSOpenSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeSession(TSCloseSessionReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus executeBatchStatement(TSExecuteBatchStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchResultsResp fetchResults(TSFetchResultsReq req)")
  fmt.Fprintln(os.Stderr, "  TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus cancelOperation(TSCancelOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus closeOperation(TSCloseOperationReq req)")
  fmt.Fprintln(os.Stderr, "  TSGetTimeZoneResp getTimeZone(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus setTimeZone(TSSetTimeZoneReq req)")
  fmt.Fprintln(os.Stderr, "  ServerProperties getProperties()")
  fmt.Fprintln(os.Stderr, "  TSStatus setStorageGroup(i64 sessionId, string storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseries(TSCreateTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createAlignedTimeseries(TSCreateAlignedTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteTimeseries(i64 sessionId,  path)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteStorageGroups(i64 sessionId,  storageGroup)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus insertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablet(TSInsertTabletReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertTablets(TSInsertTabletsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecord(TSInsertRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecord(TSInsertStringRecordReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecords(TSInsertRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus testInsertStringRecords(TSInsertStringRecordsReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus deleteData(TSDeleteDataReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeLastDataQuery(TSLastDataQueryReq req)")
  fmt.Fprintln(os.Stderr, "  TSExecuteStatementResp executeAggregationQuery(TSAggregationQueryReq req)")
  fmt.Fprintln(os.Stderr, "  i64 requestStatementId(i64 sessionId)")
  fmt.Fprintln(os.Stderr, "  TSStatus createSchemaTemplate(TSCreateSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus appendSchemaTemplate(TSAppendSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus pruneSchemaTemplate(TSPruneSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TShowConfigurationTemplateResp showConfigurationTemplate()")
  fmt.Fprintln(os.Stderr, "  TShowConfigurationResp showConfiguration(i32 nodeId)")
  fmt.Fprintln(os.Stderr, "  TSStatus setSchemaTemplate(TSSetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus unsetSchemaTemplate(TSUnsetSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus dropSchemaTemplate(TSDropSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus createTimeseriesUsingSchemaTemplate(TCreateTimeseriesUsingSchemaTemplateReq req)")
  fmt.Fprintln(os.Stderr, "  TSStatus handshake(TSyncIdentityInfo info)")
  fmt.Fprintln(os.Stderr, "  TSStatus sendPipeData(string buff)")
  fmt.Fprintln(os.Stderr, "  TSStatus sendFile(TSyncTransportMetaInfo metaInfo, string buff)")
  fmt.Fprintln(os.Stderr, "  TPipeTransferResp pipeTransfer(TPipeTransferReq req)")
  fmt.Fprintln(os.Stderr, "  TPipeSubscribeResp pipeSubscribe(TPipeSubscribeReq req)")
  fmt.Fprintln(os.Stderr, "  TSBackupConfigurationResp getBackupConfiguration()")
  fmt.Fprintln(os.Stderr, "  TSConnectionInfoResp fetchAllConnectionsInfo()")
  fmt.Fprintln(os.Stderr, "  TSStatus testConnectionEmptyRPC()")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

type httpHeaders map[string]string

func (h httpHeaders) String() string {
  var m map[string]string = h
  return fmt.Sprintf("%s", m)
}

func (h httpHeaders) Set(value string) error {
  parts := strings.Split(value, ": ")
  if len(parts) != 2 {
    return fmt.Errorf("header should be of format 'Key: Value'")
  }
  h[parts[0]] = parts[1]
  return nil
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  headers := make(httpHeaders)
  var parsedUrl *url.URL
  var trans thrift.TTransport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host and port")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Var(headers, "H", "Headers to set on the http(s) request (e.g. -H \"Key: Value\")")
  flag.Parse()
  
  if len(urlString) > 0 {
    var err error
    parsedUrl, err = url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http" || parsedUrl.Scheme == "https"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewTHttpClient(parsedUrl.String())
    if len(headers) > 0 {
      httptrans := trans.(*thrift.THttpClient)
      for key, value := range headers {
        httptrans.SetHeader(key, value)
      }
    }
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewTSocket(net.JoinHostPort(host, portStr))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewTFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.TProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewTCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewTSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewTJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewTBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  iprot := protocolFactory.GetProtocol(trans)
  oprot := protocolFactory.GetProtocol(trans)
  client := rpc.NewIClientRPCServiceClient(thrift.NewTStandardClient(iprot, oprot))
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "executeQueryStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatementV2 requires 1 args")
      flag.Usage()
    }
    arg395 := flag.Arg(1)
    mbTrans396 := thrift.NewTMemoryBufferLen(len(arg395))
    defer mbTrans396.Close()
    _, err397 := mbTrans396.WriteString(arg395)
    if err397 != nil {
      Usage()
      return
    }
    factory398 := thrift.NewTJSONProtocolFactory()
    jsProt399 := factory398.GetProtocol(mbTrans396)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err400 := argvalue0.Read(context.Background(), jsProt399)
    if err400 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatementV2 requires 1 args")
      flag.Usage()
    }
    arg401 := flag.Arg(1)
    mbTrans402 := thrift.NewTMemoryBufferLen(len(arg401))
    defer mbTrans402.Close()
    _, err403 := mbTrans402.WriteString(arg401)
    if err403 != nil {
      Usage()
      return
    }
    factory404 := thrift.NewTJSONProtocolFactory()
    jsProt405 := factory404.GetProtocol(mbTrans402)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err406 := argvalue0.Read(context.Background(), jsProt405)
    if err406 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatementV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatementV2 requires 1 args")
      flag.Usage()
    }
    arg407 := flag.Arg(1)
    mbTrans408 := thrift.NewTMemoryBufferLen(len(arg407))
    defer mbTrans408.Close()
    _, err409 := mbTrans408.WriteString(arg407)
    if err409 != nil {
      Usage()
      return
    }
    factory410 := thrift.NewTJSONProtocolFactory()
    jsProt411 := factory410.GetProtocol(mbTrans408)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err412 := argvalue0.Read(context.Background(), jsProt411)
    if err412 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatementV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQueryV2 requires 1 args")
      flag.Usage()
    }
    arg413 := flag.Arg(1)
    mbTrans414 := thrift.NewTMemoryBufferLen(len(arg413))
    defer mbTrans414.Close()
    _, err415 := mbTrans414.WriteString(arg413)
    if err415 != nil {
      Usage()
      return
    }
    factory416 := thrift.NewTJSONProtocolFactory()
    jsProt417 := factory416.GetProtocol(mbTrans414)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err418 := argvalue0.Read(context.Background(), jsProt417)
    if err418 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQueryV2 requires 1 args")
      flag.Usage()
    }
    arg419 := flag.Arg(1)
    mbTrans420 := thrift.NewTMemoryBufferLen(len(arg419))
    defer mbTrans420.Close()
    _, err421 := mbTrans420.WriteString(arg419)
    if err421 != nil {
      Usage()
      return
    }
    factory422 := thrift.NewTJSONProtocolFactory()
    jsProt423 := factory422.GetProtocol(mbTrans420)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err424 := argvalue0.Read(context.Background(), jsProt423)
    if err424 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeFastLastDataQueryForOneDeviceV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteFastLastDataQueryForOneDeviceV2 requires 1 args")
      flag.Usage()
    }
    arg425 := flag.Arg(1)
    mbTrans426 := thrift.NewTMemoryBufferLen(len(arg425))
    defer mbTrans426.Close()
    _, err427 := mbTrans426.WriteString(arg425)
    if err427 != nil {
      Usage()
      return
    }
    factory428 := thrift.NewTJSONProtocolFactory()
    jsProt429 := factory428.GetProtocol(mbTrans426)
    argvalue0 := rpc.NewTSFastLastDataQueryForOneDeviceReq()
    err430 := argvalue0.Read(context.Background(), jsProt429)
    if err430 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteFastLastDataQueryForOneDeviceV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeAggregationQueryV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteAggregationQueryV2 requires 1 args")
      flag.Usage()
    }
    arg431 := flag.Arg(1)
    mbTrans432 := thrift.NewTMemoryBufferLen(len(arg431))
    defer mbTrans432.Close()
    _, err433 := mbTrans432.WriteString(arg431)
    if err433 != nil {
      Usage()
      return
    }
    factory434 := thrift.NewTJSONProtocolFactory()
    jsProt435 := factory434.GetProtocol(mbTrans432)
    argvalue0 := rpc.NewTSAggregationQueryReq()
    err436 := argvalue0.Read(context.Background(), jsProt435)
    if err436 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteAggregationQueryV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeGroupByQueryIntervalQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteGroupByQueryIntervalQuery requires 1 args")
      flag.Usage()
    }
    arg437 := flag.Arg(1)
    mbTrans438 := thrift.NewTMemoryBufferLen(len(arg437))
    defer mbTrans438.Close()
    _, err439 := mbTrans438.WriteString(arg437)
    if err439 != nil {
      Usage()
      return
    }
    factory440 := thrift.NewTJSONProtocolFactory()
    jsProt441 := factory440.GetProtocol(mbTrans438)
    argvalue0 := rpc.NewTSGroupByQueryIntervalReq()
    err442 := argvalue0.Read(context.Background(), jsProt441)
    if err442 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteGroupByQueryIntervalQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResultsV2":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResultsV2 requires 1 args")
      flag.Usage()
    }
    arg443 := flag.Arg(1)
    mbTrans444 := thrift.NewTMemoryBufferLen(len(arg443))
    defer mbTrans444.Close()
    _, err445 := mbTrans444.WriteString(arg443)
    if err445 != nil {
      Usage()
      return
    }
    factory446 := thrift.NewTJSONProtocolFactory()
    jsProt447 := factory446.GetProtocol(mbTrans444)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err448 := argvalue0.Read(context.Background(), jsProt447)
    if err448 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResultsV2(context.Background(), value0))
    fmt.Print("\n")
    break
  case "openSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "OpenSession requires 1 args")
      flag.Usage()
    }
    arg449 := flag.Arg(1)
    mbTrans450 := thrift.NewTMemoryBufferLen(len(arg449))
    defer mbTrans450.Close()
    _, err451 := mbTrans450.WriteString(arg449)
    if err451 != nil {
      Usage()
      return
    }
    factory452 := thrift.NewTJSONProtocolFactory()
    jsProt453 := factory452.GetProtocol(mbTrans450)
    argvalue0 := rpc.NewTSOpenSessionReq()
    err454 := argvalue0.Read(context.Background(), jsProt453)
    if err454 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.OpenSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeSession":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseSession requires 1 args")
      flag.Usage()
    }
    arg455 := flag.Arg(1)
    mbTrans456 := thrift.NewTMemoryBufferLen(len(arg455))
    defer mbTrans456.Close()
    _, err457 := mbTrans456.WriteString(arg455)
    if err457 != nil {
      Usage()
      return
    }
    factory458 := thrift.NewTJSONProtocolFactory()
    jsProt459 := factory458.GetProtocol(mbTrans456)
    argvalue0 := rpc.NewTSCloseSessionReq()
    err460 := argvalue0.Read(context.Background(), jsProt459)
    if err460 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseSession(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteStatement requires 1 args")
      flag.Usage()
    }
    arg461 := flag.Arg(1)
    mbTrans462 := thrift.NewTMemoryBufferLen(len(arg461))
    defer mbTrans462.Close()
    _, err463 := mbTrans462.WriteString(arg461)
    if err463 != nil {
      Usage()
      return
    }
    factory464 := thrift.NewTJSONProtocolFactory()
    jsProt465 := factory464.GetProtocol(mbTrans462)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err466 := argvalue0.Read(context.Background(), jsProt465)
    if err466 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeBatchStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteBatchStatement requires 1 args")
      flag.Usage()
    }
    arg467 := flag.Arg(1)
    mbTrans468 := thrift.NewTMemoryBufferLen(len(arg467))
    defer mbTrans468.Close()
    _, err469 := mbTrans468.WriteString(arg467)
    if err469 != nil {
      Usage()
      return
    }
    factory470 := thrift.NewTJSONProtocolFactory()
    jsProt471 := factory470.GetProtocol(mbTrans468)
    argvalue0 := rpc.NewTSExecuteBatchStatementReq()
    err472 := argvalue0.Read(context.Background(), jsProt471)
    if err472 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteBatchStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeQueryStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteQueryStatement requires 1 args")
      flag.Usage()
    }
    arg473 := flag.Arg(1)
    mbTrans474 := thrift.NewTMemoryBufferLen(len(arg473))
    defer mbTrans474.Close()
    _, err475 := mbTrans474.WriteString(arg473)
    if err475 != nil {
      Usage()
      return
    }
    factory476 := thrift.NewTJSONProtocolFactory()
    jsProt477 := factory476.GetProtocol(mbTrans474)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err478 := argvalue0.Read(context.Background(), jsProt477)
    if err478 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteQueryStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeUpdateStatement":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteUpdateStatement requires 1 args")
      flag.Usage()
    }
    arg479 := flag.Arg(1)
    mbTrans480 := thrift.NewTMemoryBufferLen(len(arg479))
    defer mbTrans480.Close()
    _, err481 := mbTrans480.WriteString(arg479)
    if err481 != nil {
      Usage()
      return
    }
    factory482 := thrift.NewTJSONProtocolFactory()
    jsProt483 := factory482.GetProtocol(mbTrans480)
    argvalue0 := rpc.NewTSExecuteStatementReq()
    err484 := argvalue0.Read(context.Background(), jsProt483)
    if err484 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteUpdateStatement(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchResults":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchResults requires 1 args")
      flag.Usage()
    }
    arg485 := flag.Arg(1)
    mbTrans486 := thrift.NewTMemoryBufferLen(len(arg485))
    defer mbTrans486.Close()
    _, err487 := mbTrans486.WriteString(arg485)
    if err487 != nil {
      Usage()
      return
    }
    factory488 := thrift.NewTJSONProtocolFactory()
    jsProt489 := factory488.GetProtocol(mbTrans486)
    argvalue0 := rpc.NewTSFetchResultsReq()
    err490 := argvalue0.Read(context.Background(), jsProt489)
    if err490 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchResults(context.Background(), value0))
    fmt.Print("\n")
    break
  case "fetchMetadata":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "FetchMetadata requires 1 args")
      flag.Usage()
    }
    arg491 := flag.Arg(1)
    mbTrans492 := thrift.NewTMemoryBufferLen(len(arg491))
    defer mbTrans492.Close()
    _, err493 := mbTrans492.WriteString(arg491)
    if err493 != nil {
      Usage()
      return
    }
    factory494 := thrift.NewTJSONProtocolFactory()
    jsProt495 := factory494.GetProtocol(mbTrans492)
    argvalue0 := rpc.NewTSFetchMetadataReq()
    err496 := argvalue0.Read(context.Background(), jsProt495)
    if err496 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.FetchMetadata(context.Background(), value0))
    fmt.Print("\n")
    break
  case "cancelOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CancelOperation requires 1 args")
      flag.Usage()
    }
    arg497 := flag.Arg(1)
    mbTrans498 := thrift.NewTMemoryBufferLen(len(arg497))
    defer mbTrans498.Close()
    _, err499 := mbTrans498.WriteString(arg497)
    if err499 != nil {
      Usage()
      return
    }
    factory500 := thrift.NewTJSONProtocolFactory()
    jsProt501 := factory500.GetProtocol(mbTrans498)
    argvalue0 := rpc.NewTSCancelOperationReq()
    err502 := argvalue0.Read(context.Background(), jsProt501)
    if err502 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CancelOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "closeOperation":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CloseOperation requires 1 args")
      flag.Usage()
    }
    arg503 := flag.Arg(1)
    mbTrans504 := thrift.NewTMemoryBufferLen(len(arg503))
    defer mbTrans504.Close()
    _, err505 := mbTrans504.WriteString(arg503)
    if err505 != nil {
      Usage()
      return
    }
    factory506 := thrift.NewTJSONProtocolFactory()
    jsProt507 := factory506.GetProtocol(mbTrans504)
    argvalue0 := rpc.NewTSCloseOperationReq()
    err508 := argvalue0.Read(context.Background(), jsProt507)
    if err508 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CloseOperation(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetTimeZone requires 1 args")
      flag.Usage()
    }
    argvalue0, err509 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err509 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setTimeZone":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetTimeZone requires 1 args")
      flag.Usage()
    }
    arg510 := flag.Arg(1)
    mbTrans511 := thrift.NewTMemoryBufferLen(len(arg510))
    defer mbTrans511.Close()
    _, err512 := mbTrans511.WriteString(arg510)
    if err512 != nil {
      Usage()
      return
    }
    factory513 := thrift.NewTJSONProtocolFactory()
    jsProt514 := factory513.GetProtocol(mbTrans511)
    argvalue0 := rpc.NewTSSetTimeZoneReq()
    err515 := argvalue0.Read(context.Background(), jsProt514)
    if err515 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetTimeZone(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getProperties":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetProperties requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetProperties(context.Background()))
    fmt.Print("\n")
    break
  case "setStorageGroup":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SetStorageGroup requires 2 args")
      flag.Usage()
    }
    argvalue0, err516 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err516 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := flag.Arg(2)
    value1 := argvalue1
    fmt.Print(client.SetStorageGroup(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "createTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseries requires 1 args")
      flag.Usage()
    }
    arg518 := flag.Arg(1)
    mbTrans519 := thrift.NewTMemoryBufferLen(len(arg518))
    defer mbTrans519.Close()
    _, err520 := mbTrans519.WriteString(arg518)
    if err520 != nil {
      Usage()
      return
    }
    factory521 := thrift.NewTJSONProtocolFactory()
    jsProt522 := factory521.GetProtocol(mbTrans519)
    argvalue0 := rpc.NewTSCreateTimeseriesReq()
    err523 := argvalue0.Read(context.Background(), jsProt522)
    if err523 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createAlignedTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateAlignedTimeseries requires 1 args")
      flag.Usage()
    }
    arg524 := flag.Arg(1)
    mbTrans525 := thrift.NewTMemoryBufferLen(len(arg524))
    defer mbTrans525.Close()
    _, err526 := mbTrans525.WriteString(arg524)
    if err526 != nil {
      Usage()
      return
    }
    factory527 := thrift.NewTJSONProtocolFactory()
    jsProt528 := factory527.GetProtocol(mbTrans525)
    argvalue0 := rpc.NewTSCreateAlignedTimeseriesReq()
    err529 := argvalue0.Read(context.Background(), jsProt528)
    if err529 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateAlignedTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createMultiTimeseries":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateMultiTimeseries requires 1 args")
      flag.Usage()
    }
    arg530 := flag.Arg(1)
    mbTrans531 := thrift.NewTMemoryBufferLen(len(arg530))
    defer mbTrans531.Close()
    _, err532 := mbTrans531.WriteString(arg530)
    if err532 != nil {
      Usage()
      return
    }
    factory533 := thrift.NewTJSONProtocolFactory()
    jsProt534 := factory533.GetProtocol(mbTrans531)
    argvalue0 := rpc.NewTSCreateMultiTimeseriesReq()
    err535 := argvalue0.Read(context.Background(), jsProt534)
    if err535 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateMultiTimeseries(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteTimeseries":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteTimeseries requires 2 args")
      flag.Usage()
    }
    argvalue0, err536 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err536 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg537 := flag.Arg(2)
    mbTrans538 := thrift.NewTMemoryBufferLen(len(arg537))
    defer mbTrans538.Close()
    _, err539 := mbTrans538.WriteString(arg537)
    if err539 != nil { 
      Usage()
      return
    }
    factory540 := thrift.NewTJSONProtocolFactory()
    jsProt541 := factory540.GetProtocol(mbTrans538)
    containerStruct1 := rpc.NewIClientRPCServiceDeleteTimeseriesArgs()
    err542 := containerStruct1.ReadField2(context.Background(), jsProt541)
    if err542 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.Path
    value1 := argvalue1
    fmt.Print(client.DeleteTimeseries(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "deleteStorageGroups":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "DeleteStorageGroups requires 2 args")
      flag.Usage()
    }
    argvalue0, err543 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err543 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    arg544 := flag.Arg(2)
    mbTrans545 := thrift.NewTMemoryBufferLen(len(arg544))
    defer mbTrans545.Close()
    _, err546 := mbTrans545.WriteString(arg544)
    if err546 != nil { 
      Usage()
      return
    }
    factory547 := thrift.NewTJSONProtocolFactory()
    jsProt548 := factory547.GetProtocol(mbTrans545)
    containerStruct1 := rpc.NewIClientRPCServiceDeleteStorageGroupsArgs()
    err549 := containerStruct1.ReadField2(context.Background(), jsProt548)
    if err549 != nil {
      Usage()
      return
    }
    argvalue1 := containerStruct1.StorageGroup
    value1 := argvalue1
    fmt.Print(client.DeleteStorageGroups(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "insertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecord requires 1 args")
      flag.Usage()
    }
    arg550 := flag.Arg(1)
    mbTrans551 := thrift.NewTMemoryBufferLen(len(arg550))
    defer mbTrans551.Close()
    _, err552 := mbTrans551.WriteString(arg550)
    if err552 != nil {
      Usage()
      return
    }
    factory553 := thrift.NewTJSONProtocolFactory()
    jsProt554 := factory553.GetProtocol(mbTrans551)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err555 := argvalue0.Read(context.Background(), jsProt554)
    if err555 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg556 := flag.Arg(1)
    mbTrans557 := thrift.NewTMemoryBufferLen(len(arg556))
    defer mbTrans557.Close()
    _, err558 := mbTrans557.WriteString(arg556)
    if err558 != nil {
      Usage()
      return
    }
    factory559 := thrift.NewTJSONProtocolFactory()
    jsProt560 := factory559.GetProtocol(mbTrans557)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err561 := argvalue0.Read(context.Background(), jsProt560)
    if err561 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablet requires 1 args")
      flag.Usage()
    }
    arg562 := flag.Arg(1)
    mbTrans563 := thrift.NewTMemoryBufferLen(len(arg562))
    defer mbTrans563.Close()
    _, err564 := mbTrans563.WriteString(arg562)
    if err564 != nil {
      Usage()
      return
    }
    factory565 := thrift.NewTJSONProtocolFactory()
    jsProt566 := factory565.GetProtocol(mbTrans563)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err567 := argvalue0.Read(context.Background(), jsProt566)
    if err567 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertTablets requires 1 args")
      flag.Usage()
    }
    arg568 := flag.Arg(1)
    mbTrans569 := thrift.NewTMemoryBufferLen(len(arg568))
    defer mbTrans569.Close()
    _, err570 := mbTrans569.WriteString(arg568)
    if err570 != nil {
      Usage()
      return
    }
    factory571 := thrift.NewTJSONProtocolFactory()
    jsProt572 := factory571.GetProtocol(mbTrans569)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err573 := argvalue0.Read(context.Background(), jsProt572)
    if err573 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecords requires 1 args")
      flag.Usage()
    }
    arg574 := flag.Arg(1)
    mbTrans575 := thrift.NewTMemoryBufferLen(len(arg574))
    defer mbTrans575.Close()
    _, err576 := mbTrans575.WriteString(arg574)
    if err576 != nil {
      Usage()
      return
    }
    factory577 := thrift.NewTJSONProtocolFactory()
    jsProt578 := factory577.GetProtocol(mbTrans575)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err579 := argvalue0.Read(context.Background(), jsProt578)
    if err579 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg580 := flag.Arg(1)
    mbTrans581 := thrift.NewTMemoryBufferLen(len(arg580))
    defer mbTrans581.Close()
    _, err582 := mbTrans581.WriteString(arg580)
    if err582 != nil {
      Usage()
      return
    }
    factory583 := thrift.NewTJSONProtocolFactory()
    jsProt584 := factory583.GetProtocol(mbTrans581)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err585 := argvalue0.Read(context.Background(), jsProt584)
    if err585 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg586 := flag.Arg(1)
    mbTrans587 := thrift.NewTMemoryBufferLen(len(arg586))
    defer mbTrans587.Close()
    _, err588 := mbTrans587.WriteString(arg586)
    if err588 != nil {
      Usage()
      return
    }
    factory589 := thrift.NewTJSONProtocolFactory()
    jsProt590 := factory589.GetProtocol(mbTrans587)
    argvalue0 := rpc.NewTSInsertStringRecordsOfOneDeviceReq()
    err591 := argvalue0.Read(context.Background(), jsProt590)
    if err591 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "insertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "InsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg592 := flag.Arg(1)
    mbTrans593 := thrift.NewTMemoryBufferLen(len(arg592))
    defer mbTrans593.Close()
    _, err594 := mbTrans593.WriteString(arg592)
    if err594 != nil {
      Usage()
      return
    }
    factory595 := thrift.NewTJSONProtocolFactory()
    jsProt596 := factory595.GetProtocol(mbTrans593)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err597 := argvalue0.Read(context.Background(), jsProt596)
    if err597 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.InsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablet":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablet requires 1 args")
      flag.Usage()
    }
    arg598 := flag.Arg(1)
    mbTrans599 := thrift.NewTMemoryBufferLen(len(arg598))
    defer mbTrans599.Close()
    _, err600 := mbTrans599.WriteString(arg598)
    if err600 != nil {
      Usage()
      return
    }
    factory601 := thrift.NewTJSONProtocolFactory()
    jsProt602 := factory601.GetProtocol(mbTrans599)
    argvalue0 := rpc.NewTSInsertTabletReq()
    err603 := argvalue0.Read(context.Background(), jsProt602)
    if err603 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablet(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertTablets":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertTablets requires 1 args")
      flag.Usage()
    }
    arg604 := flag.Arg(1)
    mbTrans605 := thrift.NewTMemoryBufferLen(len(arg604))
    defer mbTrans605.Close()
    _, err606 := mbTrans605.WriteString(arg604)
    if err606 != nil {
      Usage()
      return
    }
    factory607 := thrift.NewTJSONProtocolFactory()
    jsProt608 := factory607.GetProtocol(mbTrans605)
    argvalue0 := rpc.NewTSInsertTabletsReq()
    err609 := argvalue0.Read(context.Background(), jsProt608)
    if err609 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertTablets(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecord requires 1 args")
      flag.Usage()
    }
    arg610 := flag.Arg(1)
    mbTrans611 := thrift.NewTMemoryBufferLen(len(arg610))
    defer mbTrans611.Close()
    _, err612 := mbTrans611.WriteString(arg610)
    if err612 != nil {
      Usage()
      return
    }
    factory613 := thrift.NewTJSONProtocolFactory()
    jsProt614 := factory613.GetProtocol(mbTrans611)
    argvalue0 := rpc.NewTSInsertRecordReq()
    err615 := argvalue0.Read(context.Background(), jsProt614)
    if err615 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecord":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecord requires 1 args")
      flag.Usage()
    }
    arg616 := flag.Arg(1)
    mbTrans617 := thrift.NewTMemoryBufferLen(len(arg616))
    defer mbTrans617.Close()
    _, err618 := mbTrans617.WriteString(arg616)
    if err618 != nil {
      Usage()
      return
    }
    factory619 := thrift.NewTJSONProtocolFactory()
    jsProt620 := factory619.GetProtocol(mbTrans617)
    argvalue0 := rpc.NewTSInsertStringRecordReq()
    err621 := argvalue0.Read(context.Background(), jsProt620)
    if err621 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecord(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecords requires 1 args")
      flag.Usage()
    }
    arg622 := flag.Arg(1)
    mbTrans623 := thrift.NewTMemoryBufferLen(len(arg622))
    defer mbTrans623.Close()
    _, err624 := mbTrans623.WriteString(arg622)
    if err624 != nil {
      Usage()
      return
    }
    factory625 := thrift.NewTJSONProtocolFactory()
    jsProt626 := factory625.GetProtocol(mbTrans623)
    argvalue0 := rpc.NewTSInsertRecordsReq()
    err627 := argvalue0.Read(context.Background(), jsProt626)
    if err627 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertRecordsOfOneDevice":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertRecordsOfOneDevice requires 1 args")
      flag.Usage()
    }
    arg628 := flag.Arg(1)
    mbTrans629 := thrift.NewTMemoryBufferLen(len(arg628))
    defer mbTrans629.Close()
    _, err630 := mbTrans629.WriteString(arg628)
    if err630 != nil {
      Usage()
      return
    }
    factory631 := thrift.NewTJSONProtocolFactory()
    jsProt632 := factory631.GetProtocol(mbTrans629)
    argvalue0 := rpc.NewTSInsertRecordsOfOneDeviceReq()
    err633 := argvalue0.Read(context.Background(), jsProt632)
    if err633 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertRecordsOfOneDevice(context.Background(), value0))
    fmt.Print("\n")
    break
  case "testInsertStringRecords":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "TestInsertStringRecords requires 1 args")
      flag.Usage()
    }
    arg634 := flag.Arg(1)
    mbTrans635 := thrift.NewTMemoryBufferLen(len(arg634))
    defer mbTrans635.Close()
    _, err636 := mbTrans635.WriteString(arg634)
    if err636 != nil {
      Usage()
      return
    }
    factory637 := thrift.NewTJSONProtocolFactory()
    jsProt638 := factory637.GetProtocol(mbTrans635)
    argvalue0 := rpc.NewTSInsertStringRecordsReq()
    err639 := argvalue0.Read(context.Background(), jsProt638)
    if err639 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.TestInsertStringRecords(context.Background(), value0))
    fmt.Print("\n")
    break
  case "deleteData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DeleteData requires 1 args")
      flag.Usage()
    }
    arg640 := flag.Arg(1)
    mbTrans641 := thrift.NewTMemoryBufferLen(len(arg640))
    defer mbTrans641.Close()
    _, err642 := mbTrans641.WriteString(arg640)
    if err642 != nil {
      Usage()
      return
    }
    factory643 := thrift.NewTJSONProtocolFactory()
    jsProt644 := factory643.GetProtocol(mbTrans641)
    argvalue0 := rpc.NewTSDeleteDataReq()
    err645 := argvalue0.Read(context.Background(), jsProt644)
    if err645 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DeleteData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeRawDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteRawDataQuery requires 1 args")
      flag.Usage()
    }
    arg646 := flag.Arg(1)
    mbTrans647 := thrift.NewTMemoryBufferLen(len(arg646))
    defer mbTrans647.Close()
    _, err648 := mbTrans647.WriteString(arg646)
    if err648 != nil {
      Usage()
      return
    }
    factory649 := thrift.NewTJSONProtocolFactory()
    jsProt650 := factory649.GetProtocol(mbTrans647)
    argvalue0 := rpc.NewTSRawDataQueryReq()
    err651 := argvalue0.Read(context.Background(), jsProt650)
    if err651 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteRawDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeLastDataQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteLastDataQuery requires 1 args")
      flag.Usage()
    }
    arg652 := flag.Arg(1)
    mbTrans653 := thrift.NewTMemoryBufferLen(len(arg652))
    defer mbTrans653.Close()
    _, err654 := mbTrans653.WriteString(arg652)
    if err654 != nil {
      Usage()
      return
    }
    factory655 := thrift.NewTJSONProtocolFactory()
    jsProt656 := factory655.GetProtocol(mbTrans653)
    argvalue0 := rpc.NewTSLastDataQueryReq()
    err657 := argvalue0.Read(context.Background(), jsProt656)
    if err657 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteLastDataQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "executeAggregationQuery":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ExecuteAggregationQuery requires 1 args")
      flag.Usage()
    }
    arg658 := flag.Arg(1)
    mbTrans659 := thrift.NewTMemoryBufferLen(len(arg658))
    defer mbTrans659.Close()
    _, err660 := mbTrans659.WriteString(arg658)
    if err660 != nil {
      Usage()
      return
    }
    factory661 := thrift.NewTJSONProtocolFactory()
    jsProt662 := factory661.GetProtocol(mbTrans659)
    argvalue0 := rpc.NewTSAggregationQueryReq()
    err663 := argvalue0.Read(context.Background(), jsProt662)
    if err663 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.ExecuteAggregationQuery(context.Background(), value0))
    fmt.Print("\n")
    break
  case "requestStatementId":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "RequestStatementId requires 1 args")
      flag.Usage()
    }
    argvalue0, err664 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err664 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.RequestStatementId(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg665 := flag.Arg(1)
    mbTrans666 := thrift.NewTMemoryBufferLen(len(arg665))
    defer mbTrans666.Close()
    _, err667 := mbTrans666.WriteString(arg665)
    if err667 != nil {
      Usage()
      return
    }
    factory668 := thrift.NewTJSONProtocolFactory()
    jsProt669 := factory668.GetProtocol(mbTrans666)
    argvalue0 := rpc.NewTSCreateSchemaTemplateReq()
    err670 := argvalue0.Read(context.Background(), jsProt669)
    if err670 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "appendSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "AppendSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg671 := flag.Arg(1)
    mbTrans672 := thrift.NewTMemoryBufferLen(len(arg671))
    defer mbTrans672.Close()
    _, err673 := mbTrans672.WriteString(arg671)
    if err673 != nil {
      Usage()
      return
    }
    factory674 := thrift.NewTJSONProtocolFactory()
    jsProt675 := factory674.GetProtocol(mbTrans672)
    argvalue0 := rpc.NewTSAppendSchemaTemplateReq()
    err676 := argvalue0.Read(context.Background(), jsProt675)
    if err676 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.AppendSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pruneSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PruneSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg677 := flag.Arg(1)
    mbTrans678 := thrift.NewTMemoryBufferLen(len(arg677))
    defer mbTrans678.Close()
    _, err679 := mbTrans678.WriteString(arg677)
    if err679 != nil {
      Usage()
      return
    }
    factory680 := thrift.NewTJSONProtocolFactory()
    jsProt681 := factory680.GetProtocol(mbTrans678)
    argvalue0 := rpc.NewTSPruneSchemaTemplateReq()
    err682 := argvalue0.Read(context.Background(), jsProt681)
    if err682 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PruneSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "querySchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "QuerySchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg683 := flag.Arg(1)
    mbTrans684 := thrift.NewTMemoryBufferLen(len(arg683))
    defer mbTrans684.Close()
    _, err685 := mbTrans684.WriteString(arg683)
    if err685 != nil {
      Usage()
      return
    }
    factory686 := thrift.NewTJSONProtocolFactory()
    jsProt687 := factory686.GetProtocol(mbTrans684)
    argvalue0 := rpc.NewTSQueryTemplateReq()
    err688 := argvalue0.Read(context.Background(), jsProt687)
    if err688 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.QuerySchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "showConfigurationTemplate":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "ShowConfigurationTemplate requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.ShowConfigurationTemplate(context.Background()))
    fmt.Print("\n")
    break
  case "showConfiguration":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "ShowConfiguration requires 1 args")
      flag.Usage()
    }
    tmp0, err689 := (strconv.Atoi(flag.Arg(1)))
    if err689 != nil {
      Usage()
      return
    }
    argvalue0 := int32(tmp0)
    value0 := argvalue0
    fmt.Print(client.ShowConfiguration(context.Background(), value0))
    fmt.Print("\n")
    break
  case "setSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg690 := flag.Arg(1)
    mbTrans691 := thrift.NewTMemoryBufferLen(len(arg690))
    defer mbTrans691.Close()
    _, err692 := mbTrans691.WriteString(arg690)
    if err692 != nil {
      Usage()
      return
    }
    factory693 := thrift.NewTJSONProtocolFactory()
    jsProt694 := factory693.GetProtocol(mbTrans691)
    argvalue0 := rpc.NewTSSetSchemaTemplateReq()
    err695 := argvalue0.Read(context.Background(), jsProt694)
    if err695 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.SetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "unsetSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "UnsetSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg696 := flag.Arg(1)
    mbTrans697 := thrift.NewTMemoryBufferLen(len(arg696))
    defer mbTrans697.Close()
    _, err698 := mbTrans697.WriteString(arg696)
    if err698 != nil {
      Usage()
      return
    }
    factory699 := thrift.NewTJSONProtocolFactory()
    jsProt700 := factory699.GetProtocol(mbTrans697)
    argvalue0 := rpc.NewTSUnsetSchemaTemplateReq()
    err701 := argvalue0.Read(context.Background(), jsProt700)
    if err701 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.UnsetSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "dropSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "DropSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg702 := flag.Arg(1)
    mbTrans703 := thrift.NewTMemoryBufferLen(len(arg702))
    defer mbTrans703.Close()
    _, err704 := mbTrans703.WriteString(arg702)
    if err704 != nil {
      Usage()
      return
    }
    factory705 := thrift.NewTJSONProtocolFactory()
    jsProt706 := factory705.GetProtocol(mbTrans703)
    argvalue0 := rpc.NewTSDropSchemaTemplateReq()
    err707 := argvalue0.Read(context.Background(), jsProt706)
    if err707 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.DropSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "createTimeseriesUsingSchemaTemplate":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "CreateTimeseriesUsingSchemaTemplate requires 1 args")
      flag.Usage()
    }
    arg708 := flag.Arg(1)
    mbTrans709 := thrift.NewTMemoryBufferLen(len(arg708))
    defer mbTrans709.Close()
    _, err710 := mbTrans709.WriteString(arg708)
    if err710 != nil {
      Usage()
      return
    }
    factory711 := thrift.NewTJSONProtocolFactory()
    jsProt712 := factory711.GetProtocol(mbTrans709)
    argvalue0 := rpc.NewTCreateTimeseriesUsingSchemaTemplateReq()
    err713 := argvalue0.Read(context.Background(), jsProt712)
    if err713 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.CreateTimeseriesUsingSchemaTemplate(context.Background(), value0))
    fmt.Print("\n")
    break
  case "handshake":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "Handshake requires 1 args")
      flag.Usage()
    }
    arg714 := flag.Arg(1)
    mbTrans715 := thrift.NewTMemoryBufferLen(len(arg714))
    defer mbTrans715.Close()
    _, err716 := mbTrans715.WriteString(arg714)
    if err716 != nil {
      Usage()
      return
    }
    factory717 := thrift.NewTJSONProtocolFactory()
    jsProt718 := factory717.GetProtocol(mbTrans715)
    argvalue0 := rpc.NewTSyncIdentityInfo()
    err719 := argvalue0.Read(context.Background(), jsProt718)
    if err719 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.Handshake(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendPipeData":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "SendPipeData requires 1 args")
      flag.Usage()
    }
    argvalue0 := []byte(flag.Arg(1))
    value0 := argvalue0
    fmt.Print(client.SendPipeData(context.Background(), value0))
    fmt.Print("\n")
    break
  case "sendFile":
    if flag.NArg() - 1 != 2 {
      fmt.Fprintln(os.Stderr, "SendFile requires 2 args")
      flag.Usage()
    }
    arg721 := flag.Arg(1)
    mbTrans722 := thrift.NewTMemoryBufferLen(len(arg721))
    defer mbTrans722.Close()
    _, err723 := mbTrans722.WriteString(arg721)
    if err723 != nil {
      Usage()
      return
    }
    factory724 := thrift.NewTJSONProtocolFactory()
    jsProt725 := factory724.GetProtocol(mbTrans722)
    argvalue0 := rpc.NewTSyncTransportMetaInfo()
    err726 := argvalue0.Read(context.Background(), jsProt725)
    if err726 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1 := []byte(flag.Arg(2))
    value1 := argvalue1
    fmt.Print(client.SendFile(context.Background(), value0, value1))
    fmt.Print("\n")
    break
  case "pipeTransfer":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PipeTransfer requires 1 args")
      flag.Usage()
    }
    arg728 := flag.Arg(1)
    mbTrans729 := thrift.NewTMemoryBufferLen(len(arg728))
    defer mbTrans729.Close()
    _, err730 := mbTrans729.WriteString(arg728)
    if err730 != nil {
      Usage()
      return
    }
    factory731 := thrift.NewTJSONProtocolFactory()
    jsProt732 := factory731.GetProtocol(mbTrans729)
    argvalue0 := rpc.NewTPipeTransferReq()
    err733 := argvalue0.Read(context.Background(), jsProt732)
    if err733 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PipeTransfer(context.Background(), value0))
    fmt.Print("\n")
    break
  case "pipeSubscribe":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "PipeSubscribe requires 1 args")
      flag.Usage()
    }
    arg734 := flag.Arg(1)
    mbTrans735 := thrift.NewTMemoryBufferLen(len(arg734))
    defer mbTrans735.Close()
    _, err736 := mbTrans735.WriteString(arg734)
    if err736 != nil {
      Usage()
      return
    }
    factory737 := thrift.NewTJSONProtocolFactory()
    jsProt738 := factory737.GetProtocol(mbTrans735)
    argvalue0 := rpc.NewTPipeSubscribeReq()
    err739 := argvalue0.Read(context.Background(), jsProt738)
    if err739 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.PipeSubscribe(context.Background(), value0))
    fmt.Print("\n")
    break
  case "getBackupConfiguration":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetBackupConfiguration requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetBackupConfiguration(context.Background()))
    fmt.Print("\n")
    break
  case "fetchAllConnectionsInfo":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "FetchAllConnectionsInfo requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.FetchAllConnectionsInfo(context.Background()))
    fmt.Print("\n")
    break
  case "testConnectionEmptyRPC":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "TestConnectionEmptyRPC requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.TestConnectionEmptyRPC(context.Background()))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
