/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.pipe.config.constant.PipeConnectorConstant;
import org.apache.iotdb.commons.pipe.connector.PipeReceiverStatusHandler;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IoTDBConnector
implements PipeConnector {
    private static final String PARSE_URL_ERROR_FORMATTER = "Exception occurred while parsing node urls from target servers: {}";
    private static final String PARSE_URL_ERROR_MESSAGE = "Error occurred while parsing node urls from target servers, please check the specified 'host':'port' or 'node-urls'";
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBConnector.class);
    protected final List<TEndPoint> nodeUrls = new ArrayList<TEndPoint>();
    protected String loadBalanceStrategy;
    protected boolean isTabletBatchModeEnabled = true;
    protected PipeReceiverStatusHandler receiverStatusHandler;

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] != false || ((Boolean)args[1] != false || (Boolean)args[2] != false) && (Boolean)args[3] != false || (Boolean)args[4] != false || ((Boolean)args[5] != false || (Boolean)args[6] != false) && (Boolean)args[7] != false, String.format("One of %s, %s:%s, %s, %s:%s must be specified", "connector.node-urls", "connector.host", "connector.port", "sink.node-urls", "sink.host", "sink.port"), new Object[]{parameters.hasAttribute("connector.node-urls"), parameters.hasAttribute("connector.ip"), parameters.hasAttribute("connector.host"), parameters.hasAttribute("connector.port"), parameters.hasAttribute("sink.node-urls"), parameters.hasAttribute("sink.ip"), parameters.hasAttribute("sink.host"), parameters.hasAttribute("sink.port")});
        this.loadBalanceStrategy = parameters.getStringOrDefault(Arrays.asList("connector.load-balance-strategy", "sink.load-balance-strategy"), "round-robin").trim().toLowerCase();
        validator.validate(arg -> PipeConnectorConstant.CONNECTOR_LOAD_BALANCE_STRATEGY_SET.contains(this.loadBalanceStrategy), String.format("Load balance strategy should be one of %s, but got %s.", PipeConnectorConstant.CONNECTOR_LOAD_BALANCE_STRATEGY_SET, this.loadBalanceStrategy), (Object)this.loadBalanceStrategy);
        validator.validate(arg -> arg.equals("retry") || arg.equals("ignore"), String.format("The value of key %s or %s must be either 'retry' or 'ignore'.", "connector.exception.conflict.resolve-strategy", "sink.exception.conflict.resolve-strategy"), (Object)parameters.getStringOrDefault(Arrays.asList("connector.exception.conflict.resolve-strategy", "sink.exception.conflict.resolve-strategy"), "retry").trim().toLowerCase());
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        this.nodeUrls.clear();
        this.nodeUrls.addAll(this.parseNodeUrls(parameters));
        LOGGER.info("IoTDBConnector nodeUrls: {}", this.nodeUrls);
        this.isTabletBatchModeEnabled = parameters.getBooleanOrDefault(Arrays.asList("connector.batch.enable", "sink.batch.enable"), true);
        LOGGER.info("IoTDBConnector isTabletBatchModeEnabled: {}", (Object)this.isTabletBatchModeEnabled);
        this.receiverStatusHandler = new PipeReceiverStatusHandler(parameters.getStringOrDefault(Arrays.asList("connector.exception.conflict.resolve-strategy", "sink.exception.conflict.resolve-strategy"), "retry").trim().equalsIgnoreCase("retry"), parameters.getLongOrDefault(Arrays.asList("connector.exception.conflict.retry-max-time-seconds", "sink.exception.conflict.retry-max-time-seconds"), 60L), parameters.getBooleanOrDefault(Arrays.asList("connector.exception.conflict.record-ignored-data", "sink.exception.conflict.record-ignored-data"), true), parameters.getLongOrDefault(Arrays.asList("connector.exception.others.retry-max-time-seconds", "sink.exception.others.retry-max-time-seconds"), -1L), parameters.getBooleanOrDefault(Arrays.asList("connector.exception.others.record-ignored-data", "sink.exception.others.record-ignored-data"), true));
    }

    protected LinkedHashSet<TEndPoint> parseNodeUrls(PipeParameters parameters) throws PipeParameterNotValidException {
        LinkedHashSet<TEndPoint> givenNodeUrls = new LinkedHashSet<TEndPoint>(this.nodeUrls);
        try {
            if (parameters.hasAttribute("connector.ip") && parameters.hasAttribute("connector.port")) {
                givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"connector.ip"}), parameters.getIntByKeys(new String[]{"connector.port"}).intValue()));
            }
            if (parameters.hasAttribute("sink.ip") && parameters.hasAttribute("sink.port")) {
                givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"sink.ip"}), parameters.getIntByKeys(new String[]{"sink.port"}).intValue()));
            }
            if (parameters.hasAttribute("connector.host") && parameters.hasAttribute("connector.port")) {
                givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"connector.host"}), parameters.getIntByKeys(new String[]{"connector.port"}).intValue()));
            }
            if (parameters.hasAttribute("sink.host") && parameters.hasAttribute("sink.port")) {
                givenNodeUrls.add(new TEndPoint(parameters.getStringByKeys(new String[]{"sink.host"}), parameters.getIntByKeys(new String[]{"sink.port"}).intValue()));
            }
            if (parameters.hasAttribute("connector.node-urls")) {
                givenNodeUrls.addAll(NodeUrlUtils.parseTEndPointUrls(Arrays.asList(parameters.getStringByKeys(new String[]{"connector.node-urls"}).split(","))));
            }
            if (parameters.hasAttribute("sink.node-urls")) {
                givenNodeUrls.addAll(NodeUrlUtils.parseTEndPointUrls(Arrays.asList(parameters.getStringByKeys(new String[]{"sink.node-urls"}).split(","))));
            }
        }
        catch (Exception e) {
            LOGGER.warn(PARSE_URL_ERROR_FORMATTER, (Object)e.toString());
            throw new PipeParameterNotValidException(PARSE_URL_ERROR_MESSAGE);
        }
        this.checkNodeUrls(givenNodeUrls);
        return givenNodeUrls;
    }

    private void checkNodeUrls(Set<TEndPoint> nodeUrls) throws PipeParameterNotValidException {
        for (TEndPoint nodeUrl : nodeUrls) {
            if (Objects.isNull(nodeUrl.ip) || nodeUrl.ip.isEmpty()) {
                LOGGER.warn(PARSE_URL_ERROR_FORMATTER, (Object)"host cannot be empty");
                throw new PipeParameterNotValidException(PARSE_URL_ERROR_MESSAGE);
            }
            if (nodeUrl.port != 0) continue;
            LOGGER.warn(PARSE_URL_ERROR_FORMATTER, (Object)"port cannot be empty");
            throw new PipeParameterNotValidException(PARSE_URL_ERROR_MESSAGE);
        }
    }

    public PipeReceiverStatusHandler statusHandler() {
        return this.receiverStatusHandler;
    }
}

