/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.queue.listening;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.iotdb.commons.pipe.datastructure.queue.ConcurrentIterableLinkedQueue;
import org.apache.iotdb.commons.pipe.datastructure.queue.serializer.PlainQueueSerializer;
import org.apache.iotdb.commons.pipe.datastructure.queue.serializer.QueueSerializer;
import org.apache.iotdb.commons.pipe.datastructure.queue.serializer.QueueSerializerType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializableListeningQueue<E>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSerializableListeningQueue.class);
    private final QueueSerializerType serializerType;
    private final EnumMap<QueueSerializerType, Supplier<QueueSerializer<E>>> serializers = new EnumMap(QueueSerializerType.class);
    protected final ConcurrentIterableLinkedQueue<E> queue = new ConcurrentIterableLinkedQueue();
    protected final AtomicBoolean isClosed = new AtomicBoolean(true);

    protected AbstractSerializableListeningQueue(QueueSerializerType serializerType) {
        this.serializerType = serializerType;
        this.serializers.put(QueueSerializerType.PLAIN, PlainQueueSerializer::new);
    }

    protected synchronized boolean tryListen(E element) {
        if (this.isClosed.get()) {
            return false;
        }
        this.queue.add(element);
        return true;
    }

    public synchronized long removeBefore(long newFirstIndex) {
        try (ConcurrentIterableLinkedQueue.DynamicIterator iterator = this.queue.iterateFromEarliest();){
            while (iterator.getNextIndex() < newFirstIndex) {
                Object element = iterator.next(0L);
                if (Objects.isNull(element)) {
                    break;
                }
                this.releaseResource(element);
            }
        }
        return this.queue.tryRemoveBefore(newFirstIndex);
    }

    public synchronized boolean isGivenNextIndexValid(long nextIndex) {
        return this.queue.isNextIndexValid(nextIndex);
    }

    public synchronized ConcurrentIterableLinkedQueue.DynamicIterator newIterator(long nextIndex) {
        return this.queue.iterateFrom(nextIndex);
    }

    public synchronized void returnIterator(ConcurrentIterableLinkedQueue.DynamicIterator iterator) {
        iterator.close();
    }

    public synchronized boolean serializeToFile(File snapshotName) throws IOException {
        File snapshotFile = new File(String.valueOf(snapshotName));
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to serialize to file, because file {} is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
            ReadWriteIOUtils.write((Boolean)this.isClosed.get(), (OutputStream)fileOutputStream);
            ReadWriteIOUtils.write((byte)this.serializerType.getType(), (OutputStream)fileOutputStream);
            if (this.serializers.containsKey((Object)this.serializerType)) {
                boolean bl = this.serializers.get((Object)this.serializerType).get().writeQueueToFile(fileOutputStream, this.queue, this::serializeToByteBuffer);
                return bl;
            }
            throw new UnsupportedOperationException("Unknown serializer type: " + this.serializerType.getType());
        }
    }

    public synchronized void deserializeFromFile(File snapshotName) throws IOException {
        block7: {
            File snapshotFile = new File(String.valueOf(snapshotName));
            if (!snapshotFile.exists() || !snapshotFile.isFile()) {
                LOGGER.error("Failed to deserialize from file, file {} does not exist.", (Object)snapshotFile.getAbsolutePath());
                return;
            }
            this.queue.clear();
            try (FileInputStream inputStream = new FileInputStream(snapshotFile);){
                this.isClosed.set(ReadWriteIOUtils.readBool((InputStream)inputStream));
                QueueSerializerType type = QueueSerializerType.deserialize(ReadWriteIOUtils.readByte((InputStream)inputStream));
                if (this.serializers.containsKey((Object)type)) {
                    this.serializers.get((Object)type).get().loadQueueFromFile(inputStream, this.queue, this::deserializeFromByteBuffer);
                    break block7;
                }
                throw new UnsupportedOperationException("Unknown serializer type: " + type.getType());
            }
        }
    }

    protected abstract ByteBuffer serializeToByteBuffer(E var1);

    protected abstract E deserializeFromByteBuffer(ByteBuffer var1);

    public synchronized void open() {
        this.isClosed.set(false);
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed.set(true);
        try (ConcurrentIterableLinkedQueue.DynamicIterator iterator = this.queue.iterateFromEarliest();){
            Object element;
            while (!Objects.isNull(element = iterator.next(0L))) {
                this.releaseResource(element);
            }
        }
        this.queue.clear();
    }

    protected abstract void releaseResource(E var1);

    public synchronized boolean isOpened() {
        return !this.isClosed.get();
    }
}

