/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.progress;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCommitMetrics;
import org.apache.iotdb.commons.pipe.progress.PipeEventCommitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCommitManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCommitManager.class);
    private final Map<String, PipeEventCommitter> eventCommitterMap = new ConcurrentHashMap<String, PipeEventCommitter>();

    public void register(String pipeName, long creationTime, int regionId, String pipePluginName) {
        if (pipeName == null || pipePluginName == null) {
            return;
        }
        String committerKey = PipeEventCommitManager.generateCommitterKey(pipeName, creationTime, regionId);
        if (this.eventCommitterMap.containsKey(committerKey)) {
            LOGGER.warn("Pipe with same name is already registered on this data region, overwriting: {}", (Object)committerKey);
        }
        PipeEventCommitter eventCommitter = new PipeEventCommitter(pipeName, creationTime, regionId);
        this.eventCommitterMap.put(committerKey, eventCommitter);
        PipeEventCommitMetrics.getInstance().register(eventCommitter, committerKey);
        LOGGER.info("Pipe committer registered for pipe on data region: {}", (Object)committerKey);
    }

    public void deregister(String pipeName, long creationTime, int regionId) {
        String committerKey = PipeEventCommitManager.generateCommitterKey(pipeName, creationTime, regionId);
        this.eventCommitterMap.remove(committerKey);
        PipeEventCommitMetrics.getInstance().deregister(committerKey);
        LOGGER.info("Pipe committer deregistered for pipe on data region: {}", (Object)committerKey);
    }

    public void enrichWithCommitterKeyAndCommitId(EnrichedEvent event, long creationTime, int regionId) {
        if (event == null || event.getPipeName() == null || !event.needToCommit()) {
            return;
        }
        String committerKey = PipeEventCommitManager.generateCommitterKey(event.getPipeName(), creationTime, regionId);
        PipeEventCommitter committer = this.eventCommitterMap.get(committerKey);
        if (committer == null) {
            return;
        }
        event.setCommitterKeyAndCommitId(committerKey, committer.generateCommitId());
    }

    public void commit(EnrichedEvent event, String committerKey) {
        if (event == null || !event.needToCommit() || event.getCommitId() <= -1L || committerKey == null) {
            return;
        }
        PipeEventCommitter committer = this.eventCommitterMap.get(committerKey);
        if (committer == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("missing PipeEventCommitter({}) when commit event: {}, stack trace: {}", new Object[]{committerKey, event.coreReportMessage(), Thread.currentThread().getStackTrace()});
            }
            return;
        }
        committer.commit(event);
    }

    private static String generateCommitterKey(String pipeName, long creationTime, int regionId) {
        return String.format("%s_%s_%s", pipeName, regionId, creationTime);
    }

    private PipeEventCommitManager() {
    }

    public static PipeEventCommitManager getInstance() {
        return PipeEventCommitManagerHolder.INSTANCE;
    }

    private static class PipeEventCommitManagerHolder {
        private static final PipeEventCommitManager INSTANCE = new PipeEventCommitManager();

        private PipeEventCommitManagerHolder() {
        }
    }
}

