/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public enum MNodeType {
    ROOT(0, "ROOT"),
    SG_INTERNAL(1, "SG INTERNAL"),
    STORAGE_GROUP(2, "DATABASE"),
    INTERNAL(3, "INTERNAL"),
    DEVICE(4, "DEVICE"),
    MEASUREMENT(5, "TIMESERIES"),
    UNIMPLEMENT(6, "");

    private final byte nodeType;
    private final String typeName;

    private MNodeType(byte nodeType, String typeName) {
        this.nodeType = nodeType;
        this.typeName = typeName;
    }

    public static MNodeType getMNodeType(byte type) {
        switch (type) {
            case 0: {
                return ROOT;
            }
            case 1: {
                return SG_INTERNAL;
            }
            case 2: {
                return STORAGE_GROUP;
            }
            case 3: {
                return INTERNAL;
            }
            case 4: {
                return DEVICE;
            }
            case 5: {
                return MEASUREMENT;
            }
            case 6: {
                return UNIMPLEMENT;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((byte)this.nodeType, (ByteBuffer)buffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((byte)this.nodeType, (OutputStream)stream);
    }

    public byte getNodeType() {
        return this.nodeType;
    }

    public String getNodeTypeName() {
        return this.typeName;
    }
}

