/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.config;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TopicConfig
extends PipeParameters {
    public TopicConfig() {
        super(Collections.emptyMap());
    }

    public TopicConfig(Map<String, String> attributes) {
        super(attributes);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Map)this.attributes, (OutputStream)stream);
    }

    public static TopicConfig deserialize(ByteBuffer buffer) {
        return new TopicConfig(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
    }

    public Map<String, String> getAttributesWithSourcePathOrPattern() {
        if (this.attributes.containsKey("pattern")) {
            return Collections.singletonMap("pattern", (String)this.attributes.get("pattern"));
        }
        return Collections.singletonMap("path", this.attributes.getOrDefault("path", "root.**"));
    }

    public Map<String, String> getAttributesWithTimeRange(long creationTime) {
        HashMap<String, String> attributesWithTimeRange = new HashMap<String, String>();
        String startTime = this.attributes.getOrDefault("start-time", String.valueOf(Long.MIN_VALUE));
        if ("now".equals(startTime)) {
            attributesWithTimeRange.put("start-time", String.valueOf(creationTime));
        } else {
            attributesWithTimeRange.put("start-time", startTime);
        }
        String endTime = this.attributes.getOrDefault("end-time", String.valueOf(Long.MAX_VALUE));
        if ("now".equals(endTime)) {
            attributesWithTimeRange.put("end-time", String.valueOf(creationTime));
        } else {
            attributesWithTimeRange.put("end-time", endTime);
        }
        return attributesWithTimeRange;
    }

    public Map<String, String> getAttributesWithProcessorPrefix() {
        HashMap<String, String> attributesWithProcessorPrefix = new HashMap<String, String>();
        this.attributes.forEach((key, value) -> {
            if (key.toLowerCase().startsWith("processor")) {
                attributesWithProcessorPrefix.put((String)key, (String)value);
            }
        });
        return attributesWithProcessorPrefix;
    }
}

