/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribePollReq
extends TPipeSubscribeReq {
    private transient Set<String> topicNames = new HashSet<String>();
    private transient long timeoutMs;

    public Set<String> getTopicNames() {
        return this.topicNames;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public static PipeSubscribePollReq toTPipeSubscribeReq(Set<String> topicNames, long timeoutMs) throws IOException {
        PipeSubscribePollReq req = new PipeSubscribePollReq();
        req.topicNames = topicNames;
        req.timeoutMs = timeoutMs;
        req.version = PipeSubscribeRequestVersion.VERSION_1.getVersion();
        req.type = PipeSubscribeRequestType.POLL.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            ReadWriteIOUtils.writeObjectSet(topicNames, (DataOutputStream)outputStream);
            ReadWriteIOUtils.write((long)timeoutMs, (OutputStream)outputStream);
            req.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return req;
    }

    public static PipeSubscribePollReq fromTPipeSubscribeReq(TPipeSubscribeReq pollReq) {
        PipeSubscribePollReq req = new PipeSubscribePollReq();
        if (Objects.nonNull(pollReq.body) && pollReq.body.hasRemaining()) {
            req.topicNames = ReadWriteIOUtils.readObjectSet((ByteBuffer)pollReq.body);
            req.timeoutMs = ReadWriteIOUtils.readLong((ByteBuffer)pollReq.body);
        }
        req.version = pollReq.version;
        req.type = pollReq.type;
        req.body = pollReq.body;
        return req;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribePollReq that = (PipeSubscribePollReq)((Object)obj);
        return Objects.equals(this.topicNames, that.topicNames) && this.timeoutMs == that.timeoutMs && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.topicNames, this.timeoutMs, this.version, this.type, this.body);
    }
}

