/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkGroupHeader {
    private static final byte MARKER = 0;
    private final IDeviceID deviceID;
    private final int serializedSize;

    public ChunkGroupHeader(IDeviceID deviceID) {
        this.deviceID = deviceID;
        this.serializedSize = this.getSerializedSize(deviceID);
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    private int getSerializedSize(IDeviceID deviceID) {
        int length = ((PlainDeviceID)deviceID).toStringID().getBytes(TSFileConfig.STRING_CHARSET).length;
        return 1 + ReadWriteForEncodingUtils.varIntSize(length) + length;
    }

    public static ChunkGroupHeader deserializeFrom(InputStream inputStream, boolean markerRead) throws IOException {
        String deviceID;
        byte marker;
        if (!markerRead && (marker = (byte)inputStream.read()) != 0) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        if ((deviceID = ReadWriteIOUtils.readVarIntString(inputStream)) == null || deviceID.isEmpty()) {
            throw new IOException("DeviceId is empty");
        }
        return new ChunkGroupHeader(new PlainDeviceID(deviceID));
    }

    public static ChunkGroupHeader deserializeFrom(TsFileInput input, long offset, boolean markerRead) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        String deviceID = input.readVarIntString(offsetVar);
        return new ChunkGroupHeader(new PlainDeviceID(deviceID));
    }

    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int length = 0;
        length += ReadWriteIOUtils.write((byte)0, outputStream);
        return length += ReadWriteIOUtils.writeVar(((PlainDeviceID)this.deviceID).toStringID(), outputStream);
    }

    public String toString() {
        return "ChunkGroupHeader{deviceID='" + ((PlainDeviceID)this.deviceID).toStringID() + '\'' + ", serializedSize=" + this.serializedSize + '}';
    }
}

