/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.block.column;

import java.util.Arrays;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnUtil;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;

public class TimeColumnBuilder
implements ColumnBuilder {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(TimeColumnBuilder.class);
    private final ColumnBuilderStatus columnBuilderStatus;
    private boolean initialized;
    private final int initialEntryCount;
    private int positionCount;
    private long[] values = new long[0];
    private long retainedSizeInBytes;

    public TimeColumnBuilder(ColumnBuilderStatus columnBuilderStatus, int expectedEntries) {
        this.columnBuilderStatus = columnBuilderStatus;
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    public ColumnBuilder writeLong(long value) {
        if (this.values.length <= this.positionCount) {
            this.growCapacity();
        }
        this.values[this.positionCount] = value;
        ++this.positionCount;
        if (this.columnBuilderStatus != null) {
            this.columnBuilderStatus.addBytes(8);
        }
        return this;
    }

    public ColumnBuilder writeObject(Object value) {
        if (value instanceof Long) {
            this.writeLong((Long)value);
            return this;
        }
        throw new UnSupportedDataTypeException("LongColumn only support Long data type");
    }

    public ColumnBuilder write(Column column, int index) {
        return this.writeLong(column.getLong(index));
    }

    public ColumnBuilder appendNull() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ColumnBuilder appendNull(int nullCount) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Column build() {
        return new TimeColumn(0, this.positionCount, this.values);
    }

    public TSDataType getDataType() {
        return TSDataType.INT64;
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public ColumnBuilder newColumnBuilderLike(ColumnBuilderStatus columnBuilderStatus) {
        return new TimeColumnBuilder(columnBuilderStatus, ColumnUtil.calculateBlockResetSize(this.positionCount));
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public long getTime(int position) {
        this.checkReadablePosition(position);
        return this.values[position];
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = ColumnUtil.calculateNewArraySize(this.values.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.values = Arrays.copyOf(this.values, newSize);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + RamUsageEstimator.sizeOf((long[])this.values);
        if (this.columnBuilderStatus != null) {
            this.retainedSizeInBytes += ColumnBuilderStatus.INSTANCE_SIZE;
        }
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

