/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl;

import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.ocm.exception.IncorrectAtomicTypeException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;

public class BooleanTypeConverterImpl
implements AtomicTypeConverter {
    public Value getValue(ValueFactory valueFactory, Object propValue) {
        if (propValue == null) {
            return null;
        }
        boolean value = (Boolean)propValue;
        return valueFactory.createValue(value);
    }

    public Object getObject(Value value) {
        try {
            return new Boolean(value.getBoolean());
        }
        catch (Exception e) {
            throw new IncorrectAtomicTypeException("Impossible to convert the value : " + value.toString(), e);
        }
    }

    public String getXPathQueryValue(ValueFactory valueFactory, Object object) {
        return (Boolean)object != false ? "true()" : "false()";
    }
}

