/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.collectionconverter.impl;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableCollection;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjectsUtil;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.jackrabbit.ocm.manager.enumconverter.EnumTypeConverter;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;

public class EnumCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    private EnumTypeConverter enumConverter = new EnumTypeConverter();

    public EnumCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        try {
            if (objects == null) {
                return;
            }
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            Value[] values = new Value[objects.getSize()];
            ValueFactory valueFactory = session.getValueFactory();
            Iterator collectionIterator = objects.getIterator();
            for (int i = 0; i < objects.getSize(); ++i) {
                Object fieldValue = collectionIterator.next();
                values[i] = this.enumConverter.getValue(valueFactory, fieldValue);
            }
            parentNode.setProperty(jcrName, values);
        }
        catch (ValueFormatException vfe) {
            throw new ObjectContentManagerException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), vfe);
        }
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableObjects objects) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (parentNode.hasProperty(jcrName)) {
            parentNode.setProperty(jcrName, (Value[])null);
        }
        if (objects == null) {
            return;
        }
        Value[] values = new Value[objects.getSize()];
        ValueFactory valueFactory = session.getValueFactory();
        int i = 0;
        Iterator collectionIterator = objects.getIterator();
        while (collectionIterator.hasNext()) {
            Object fieldValue = collectionIterator.next();
            values[i] = this.enumConverter.getValue(valueFactory, fieldValue);
            ++i;
        }
        parentNode.setProperty(jcrName, values);
    }

    protected ManageableObjects doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        try {
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            if (!parentNode.hasProperty(jcrName)) {
                return null;
            }
            Property property = parentNode.getProperty(jcrName);
            Value[] values = property.getValues();
            if (values == null || values.length <= 0) {
                return null;
            }
            ManageableObjects objects = ManageableObjectsUtil.getManageableObjects(collectionFieldClass);
            for (int i = 0; i < values.length; ++i) {
                ((ManageableCollection)objects).addObject(this.enumConverter.getObject(values[i]));
            }
            return objects;
        }
        catch (ValueFormatException vfe) {
            throw new ObjectContentManagerException("Cannot get the collection field : " + collectionDescriptor.getFieldName() + "for class " + collectionDescriptor.getClassDescriptor().getClassName(), vfe);
        }
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        return !parentNode.hasProperty(jcrName);
    }
}

