/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.objectconverter.impl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.proxy.InvocationHandler;
import org.apache.jackrabbit.ocm.manager.objectconverter.impl.OcmProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLazyLoader
implements InvocationHandler,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractLazyLoader.class);
    private Object target = null;
    private boolean initialized = false;

    protected Object getTarget() {
        if (!this.initialized) {
            this.target = this.fetchTarget();
            this.initialized = true;
            if (log.isDebugEnabled()) {
                log.debug("Target loaded");
            }
        }
        return this.target;
    }

    protected abstract Object fetchTarget();

    public boolean isInitialized() {
        return this.initialized;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!(proxy instanceof OcmProxy)) {
            throw new IllegalArgumentException("proxy should implement OcmProxy");
        }
        if (args.length == 0) {
            if (method.getName().equals("isInitialized")) {
                return this.isInitialized();
            }
            if (method.getName().equals("fetch")) {
                this.getTarget();
                return null;
            }
        }
        Object returnValue = null;
        if (Modifier.isPublic(method.getModifiers())) {
            if (!method.getDeclaringClass().isInstance(this.getTarget())) {
                throw new ClassCastException(this.getTarget().getClass().getName());
            }
            returnValue = method.invoke(this.getTarget(), args);
        } else {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            returnValue = method.invoke(this.getTarget(), args);
        }
        return returnValue == this.getTarget() ? proxy : returnValue;
    }
}

