/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.objectconverter.impl;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.ocm.manager.beanconverter.BeanConverter;
import org.apache.jackrabbit.ocm.manager.objectconverter.impl.AbstractLazyLoader;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanLazyLoader
extends AbstractLazyLoader {
    private volatile BeanConverter beanConverter;
    private volatile Session session;
    private volatile Node parentNode;
    private volatile BeanDescriptor beanDescriptor;
    private volatile ClassDescriptor beanClassDescriptor;
    private volatile Class<?> beanClass;
    private volatile Object parent;

    public BeanLazyLoader(BeanConverter beanConverter, Session session, Node parentNode, BeanDescriptor beanDescriptor, ClassDescriptor beanClassDescriptor, Class<?> beanClass, Object parent) {
        this.beanConverter = beanConverter;
        this.session = session;
        this.parentNode = parentNode;
        this.beanDescriptor = beanDescriptor;
        this.beanClassDescriptor = beanClassDescriptor;
        this.beanClass = beanClass;
        this.parent = parent;
    }

    @Override
    protected Object fetchTarget() {
        if (this.isInitialized()) {
            throw new IllegalStateException("Proxy already initialized");
        }
        if (this.session == null) {
            throw new IllegalStateException("Session null, probably because bean was serialized. Impossible to lazy load.");
        }
        Object target = this.beanConverter.getObject(this.session, this.parentNode, this.beanDescriptor, this.beanClassDescriptor, this.beanClass, this.parent);
        this.clean();
        return target;
    }

    private void clean() {
        this.beanConverter = null;
        this.session = null;
        this.parentNode = null;
        this.beanDescriptor = null;
        this.beanClassDescriptor = null;
        this.parent = null;
    }
}

