/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.objectconverter.impl;

import java.lang.reflect.Modifier;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.ocm.exception.IncorrectPersistentClassException;
import org.apache.jackrabbit.ocm.exception.JcrMappingException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverterProvider;
import org.apache.jackrabbit.ocm.manager.beanconverter.BeanConverter;
import org.apache.jackrabbit.ocm.manager.cache.ObjectCache;
import org.apache.jackrabbit.ocm.manager.cache.impl.RequestObjectCacheImpl;
import org.apache.jackrabbit.ocm.manager.collectionconverter.CollectionConverter;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjects;
import org.apache.jackrabbit.ocm.manager.collectionconverter.ManageableObjectsUtil;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.DefaultCollectionConverterImpl;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.ManageableCollectionImpl;
import org.apache.jackrabbit.ocm.manager.collectionconverter.impl.ManageableMapImpl;
import org.apache.jackrabbit.ocm.manager.impl.ObjectContentManagerUtil;
import org.apache.jackrabbit.ocm.manager.objectconverter.ObjectConverter;
import org.apache.jackrabbit.ocm.manager.objectconverter.ProxyManager;
import org.apache.jackrabbit.ocm.manager.objectconverter.impl.ProxyManagerImpl;
import org.apache.jackrabbit.ocm.manager.objectconverter.impl.SimpleFieldsHelper;
import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.BeanDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.CollectionDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;
import org.apache.jackrabbit.ocm.repository.NodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectConverterImpl
implements ObjectConverter {
    private static final String DEFAULT_BEAN_CONVERTER = "org.apache.jackrabbit.ocm.manager.beanconverter.impl.DefaultBeanConverterImpl";
    private static final Logger log = LoggerFactory.getLogger(ObjectConverterImpl.class);
    private Mapper mapper;
    protected AtomicTypeConverterProvider atomicTypeConverterProvider;
    private ProxyManager proxyManager;
    private SimpleFieldsHelper simpleFieldsHelp;
    private ObjectCache requestObjectCache;

    public ObjectConverterImpl() {
    }

    public ObjectConverterImpl(Mapper mapper, AtomicTypeConverterProvider converterProvider) {
        this.mapper = mapper;
        this.atomicTypeConverterProvider = converterProvider;
        this.proxyManager = new ProxyManagerImpl();
        this.simpleFieldsHelp = new SimpleFieldsHelper(this.atomicTypeConverterProvider);
        this.requestObjectCache = new RequestObjectCacheImpl();
    }

    public ObjectConverterImpl(Mapper mapper, AtomicTypeConverterProvider converterProvider, ProxyManager proxyManager, ObjectCache requestObjectCache) {
        this.mapper = mapper;
        this.atomicTypeConverterProvider = converterProvider;
        this.proxyManager = proxyManager;
        this.simpleFieldsHelp = new SimpleFieldsHelper(this.atomicTypeConverterProvider);
        this.requestObjectCache = requestObjectCache;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setAtomicTypeConverterProvider(AtomicTypeConverterProvider converterProvider) {
        this.atomicTypeConverterProvider = converterProvider;
    }

    public void insert(Session session, Object object) {
        String path = this.getPath(session, object);
        try {
            String parentPath = NodeUtil.getParentPath(path);
            String nodeName = NodeUtil.getNodeName(path);
            Node parentNode = session.getNode(parentPath);
            this.insert(session, parentNode, nodeName, object);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Impossible to insert the object at '" + path + "'", pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to insert the object at '" + path + "'", re);
        }
    }

    public void insert(Session session, Node parentNode, String nodeName, Object object) {
        Node objectNode;
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(object.getClass());
        String jcrType = classDescriptor.getJcrType();
        if (jcrType == null || jcrType.equals("")) {
            jcrType = "nt:unstructured";
        }
        try {
            objectNode = parentNode.addNode(nodeName, jcrType);
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Unknown node type " + jcrType + " for mapped class " + object.getClass(), nsnte);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException("Cannot create new node of type " + jcrType + " from mapped class " + object.getClass(), re);
        }
        String[] mixinTypes = classDescriptor.getJcrMixinTypes();
        String mixinTypeName = null;
        try {
            if (null != classDescriptor.getJcrMixinTypes()) {
                for (int i = 0; i < mixinTypes.length; ++i) {
                    mixinTypeName = mixinTypes[i].trim();
                    objectNode.addMixin(mixinTypeName);
                }
            }
            if (!classDescriptor.hasDiscriminator() && classDescriptor.hasInterfaces()) {
                for (String interfaceName : classDescriptor.getImplements()) {
                    ClassDescriptor interfaceDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(interfaceName));
                    objectNode.addMixin(interfaceDescriptor.getJcrType().trim());
                }
            }
            if (classDescriptor.hasDiscriminator()) {
                this.addDiscriminatorProperty(object, objectNode);
            }
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Unknown mixin type " + mixinTypeName + " for mapped class " + object.getClass(), nsnte);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new ObjectContentManagerException("Cannot create new node of type " + jcrType + " from mapped class " + object.getClass(), re);
        }
        this.simpleFieldsHelp.storeSimpleFields(session, object, classDescriptor, objectNode);
        this.insertBeanFields(session, object, classDescriptor, objectNode);
        this.insertCollectionFields(session, object, classDescriptor, objectNode);
        this.simpleFieldsHelp.refreshUuidPath(session, classDescriptor, objectNode, object);
    }

    private void addDiscriminatorProperty(Object object, Node objectNode) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, javax.jcr.RepositoryException, ValueFormatException {
        try {
            objectNode.setProperty("ocm_classname", ReflectionUtils.getBeanClass(object).getName());
        }
        catch (Exception e) {
            String mixinTypeName = "ocm:discriminator";
            objectNode.addMixin(mixinTypeName);
            objectNode.setProperty("ocm_classname", ReflectionUtils.getBeanClass(object).getName());
        }
    }

    public void update(Session session, Object object) {
        String path = this.getPath(session, object);
        try {
            String parentPath = NodeUtil.getParentPath(path);
            String nodeName = NodeUtil.getNodeName(path);
            Node parentNode = session.getNode(parentPath);
            this.update(session, parentNode, nodeName, object);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Impossible to update the object at '" + path + "'", pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to update the object at '" + path + "'", re);
        }
    }

    public void update(Session session, String uuId, Object object) {
        try {
            ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.getBeanClass(object));
            Node objectNode = session.getNodeByIdentifier(uuId);
            this.update(session, objectNode, object);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Impossible to update the object with UUID: " + uuId, pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to update the object with UUID: " + uuId, re);
        }
    }

    public void update(Session session, Node objectNode, Object object) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.getBeanClass(object));
        this.checkNodeType(session, classDescriptor);
        this.checkCompatiblePrimaryNodeTypes(session, objectNode, classDescriptor, false);
        this.simpleFieldsHelp.storeSimpleFields(session, object, classDescriptor, objectNode);
        this.updateBeanFields(session, object, classDescriptor, objectNode);
        this.updateCollectionFields(session, object, classDescriptor, objectNode);
        this.simpleFieldsHelp.refreshUuidPath(session, classDescriptor, objectNode, object);
    }

    public void update(Session session, Node parentNode, String nodeName, Object object) {
        try {
            ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.getBeanClass(object));
            Node objectNode = this.getNode(parentNode, classDescriptor, nodeName, object);
            this.update(session, objectNode, object);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Impossible to update the object: " + nodeName + " at node : " + parentNode, pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to update the object: " + nodeName + " at node : " + parentNode, re);
        }
    }

    private Node getNode(Node parentNode, ClassDescriptor classDescriptor, String nodeName, Object object) throws javax.jcr.RepositoryException {
        if (parentNode == null) {
            return null;
        }
        NodeIterator nodes = parentNode.getNodes(nodeName);
        if (nodes.getSize() == 1L) {
            return nodes.nextNode();
        }
        if (classDescriptor.hasUUIdField()) {
            String currentItemUuid;
            String uuidFieldName = classDescriptor.getUuidFieldDescriptor().getFieldName();
            Object objUuid = ReflectionUtils.getNestedProperty(object, uuidFieldName);
            String string = currentItemUuid = objUuid == null ? null : objUuid.toString();
            if (currentItemUuid != null) {
                return parentNode.getSession().getNodeByIdentifier(currentItemUuid);
            }
            throw new NullPointerException("Cannot locate the node to update since there is no UUID provided even though, " + classDescriptor.getClassName() + " has been mapped with a UUID field , " + uuidFieldName);
        }
        return parentNode.getNode(nodeName);
    }

    public Object getObject(Session session, String path) {
        try {
            ClassDescriptor classDescriptor;
            if (!session.nodeExists(path)) {
                return null;
            }
            if (this.requestObjectCache.isCached(path)) {
                return this.requestObjectCache.getObject(path);
            }
            Node node = session.getNode(path);
            if (node.hasProperty("ocm_classname")) {
                String className = node.getProperty("ocm_classname").getValue().getString();
                classDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(className));
            } else {
                String nodeType = node.getPrimaryNodeType().getName();
                if (nodeType.equals("nt:frozenNode")) {
                    nodeType = node.getProperty("jcr:frozenPrimaryType").getString();
                }
                classDescriptor = this.mapper.getClassDescriptorByNodeType(nodeType);
            }
            if (null == classDescriptor) {
                throw new JcrMappingException("Impossible to find the classdescriptor for " + path + ". There is no discriminator and associated  JCR node type");
            }
            Object object = ReflectionUtils.newInstance(classDescriptor.getClassName());
            if (!this.requestObjectCache.isCached(path)) {
                this.requestObjectCache.cache(path, object);
            }
            this.simpleFieldsHelp.retrieveSimpleFields(session, classDescriptor, node, object);
            this.retrieveBeanFields(session, classDescriptor, node, object, false);
            this.retrieveCollectionFields(session, classDescriptor, node, object, false);
            return object;
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Impossible to get the object at " + path, pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to get the object at " + path, re);
        }
    }

    public Object getObject(Session session, Class clazz, String path) {
        try {
            Class alternativeClazz;
            String nodeType;
            if (!session.nodeExists(path)) {
                return null;
            }
            if (this.requestObjectCache.isCached(path)) {
                return this.requestObjectCache.getObject(path);
            }
            ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
            this.checkNodeType(session, classDescriptor);
            Node node = session.getNode(path);
            if (!classDescriptor.isInterface()) {
                node = this.getActualNode(session, node);
                this.checkCompatiblePrimaryNodeTypes(session, node, classDescriptor, true);
            }
            ClassDescriptor alternativeDescriptor = null;
            if (classDescriptor.usesNodeTypePerHierarchyStrategy()) {
                if (node.hasProperty("ocm_classname")) {
                    String className = node.getProperty("ocm_classname").getValue().getString();
                    alternativeDescriptor = this.getClassDescriptor(ReflectionUtils.forName(className));
                }
            } else if (classDescriptor.usesNodeTypePerConcreteClassStrategy() && !(nodeType = node.getPrimaryNodeType().getName()).equals(classDescriptor.getJcrType()) && (alternativeDescriptor = classDescriptor.getDescendantClassDescriptor(nodeType)) == null) {
                alternativeDescriptor = this.mapper.getClassDescriptorByNodeType(nodeType);
            }
            if (alternativeDescriptor != null && clazz.isAssignableFrom(alternativeClazz = ReflectionUtils.forName(alternativeDescriptor.getClassName()))) {
                clazz = alternativeClazz;
                classDescriptor = alternativeDescriptor;
            }
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                throw new JcrMappingException("Cannot instantiate non-concrete class " + clazz.getName() + " for node " + path + " of type " + node.getPrimaryNodeType().getName());
            }
            Object object = ReflectionUtils.newInstance(classDescriptor.getClassName());
            if (!this.requestObjectCache.isCached(path)) {
                this.requestObjectCache.cache(path, object);
            }
            this.simpleFieldsHelp.retrieveSimpleFields(session, classDescriptor, node, object);
            this.retrieveBeanFields(session, classDescriptor, node, object, false);
            this.retrieveCollectionFields(session, classDescriptor, node, object, false);
            return object;
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Impossible to get the object at " + path, pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to get the object at " + path, re);
        }
    }

    public void retrieveAllMappedAttributes(Session session, Object object) {
        String path = null;
        try {
            ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
            String pathFieldName = classDescriptor.getPathFieldDescriptor().getFieldName();
            path = (String)ReflectionUtils.getNestedProperty(object, pathFieldName);
            Node node = session.getNode(path);
            this.retrieveBeanFields(session, classDescriptor, node, object, true);
            this.retrieveCollectionFields(session, classDescriptor, node, object, true);
        }
        catch (PathNotFoundException pnfe) {
            throw new ObjectContentManagerException("Impossible to get the object at " + path, pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to get the object at " + path, re);
        }
    }

    public void retrieveMappedAttribute(Session session, Object object, String attributeName) {
        block5: {
            String path = null;
            ClassDescriptor classDescriptor = null;
            try {
                classDescriptor = this.getClassDescriptor(object.getClass());
                String pathFieldName = classDescriptor.getPathFieldDescriptor().getFieldName();
                path = (String)ReflectionUtils.getNestedProperty(object, pathFieldName);
                Node node = session.getNode(path);
                BeanDescriptor beanDescriptor = classDescriptor.getBeanDescriptor(attributeName);
                if (beanDescriptor != null) {
                    this.retrieveBeanField(session, beanDescriptor, node, object, true);
                    break block5;
                }
                CollectionDescriptor collectionDescriptor = classDescriptor.getCollectionDescriptor(attributeName);
                if (collectionDescriptor != null) {
                    this.retrieveCollectionField(session, collectionDescriptor, node, object, true);
                    break block5;
                }
                throw new ObjectContentManagerException("Impossible to retrieve the mapped attribute. The attribute '" + attributeName + "'  is not a bean or a collection for the class : " + classDescriptor.getClassName());
            }
            catch (PathNotFoundException pnfe) {
                throw new ObjectContentManagerException("Impossible to get the object at " + path, pnfe);
            }
            catch (javax.jcr.RepositoryException re) {
                throw new RepositoryException("Impossible to get the object at " + path, re);
            }
        }
    }

    private void checkNodeType(Session session, ClassDescriptor classDescriptor) {
        String jcrTypeName = null;
        try {
            if (classDescriptor.isInterface()) {
                String[] mixinTypes = classDescriptor.getJcrMixinTypes();
                for (int i = 0; i < mixinTypes.length; ++i) {
                    jcrTypeName = mixinTypes[i];
                    session.getWorkspace().getNodeTypeManager().getNodeType(jcrTypeName);
                }
            } else {
                jcrTypeName = classDescriptor.getJcrType();
                if (jcrTypeName != null && !jcrTypeName.equals("")) {
                    session.getWorkspace().getNodeTypeManager().getNodeType(jcrTypeName);
                }
            }
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Mapping for class '" + classDescriptor.getClassName() + "' use unknown primary or mixin node type '" + jcrTypeName + "'");
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException(re);
        }
    }

    private void checkCompatiblePrimaryNodeTypes(Session session, Node node, ClassDescriptor classDescriptor, boolean checkVersionNode) {
        try {
            NodeType nodeType = node.getPrimaryNodeType();
            boolean compatible = this.checkCompatibleNodeTypes(nodeType, classDescriptor);
            if (!compatible && checkVersionNode && "nt:frozenNode".equals(nodeType.getName())) {
                NodeTypeManager ntMgr = session.getWorkspace().getNodeTypeManager();
                nodeType = ntMgr.getNodeType(node.getProperty("jcr:frozenPrimaryType").getString());
                compatible = this.checkCompatibleNodeTypes(nodeType, classDescriptor);
            }
            if (!compatible) {
                throw new ObjectContentManagerException("Cannot map object of type '" + classDescriptor.getClassName() + "'. Node type '" + node.getPrimaryNodeType().getName() + "' does not match descriptor node type '" + classDescriptor.getJcrType() + "'");
            }
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException(re);
        }
    }

    private boolean checkCompatibleNodeTypes(NodeType nodeType, ClassDescriptor descriptor) {
        if (descriptor.getJcrType() == null || descriptor.getJcrType().equals("")) {
            return true;
        }
        if (nodeType.getName().equals(descriptor.getJcrType())) {
            return true;
        }
        NodeType[] superTypes = nodeType.getSupertypes();
        for (int i = 0; i < superTypes.length; ++i) {
            if (!superTypes[i].getName().equals(descriptor.getJcrType())) continue;
            return true;
        }
        return false;
    }

    public String getPath(Session session, Object object) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(object.getClass());
        FieldDescriptor pathFieldDescriptor = classDescriptor.getPathFieldDescriptor();
        if (pathFieldDescriptor == null) {
            throw new JcrMappingException("Class of type: " + object.getClass().getName() + " has no path mapping. Maybe attribute path=\"true\" for a field element of this class in mapping descriptor is missing " + " or maybe it is defined in an ancestor class which has no mapping descriptor.");
        }
        String pathField = pathFieldDescriptor.getFieldName();
        return (String)ReflectionUtils.getNestedProperty(object, pathField);
    }

    private void retrieveBeanFields(Session session, ClassDescriptor classDescriptor, Node node, Object object, boolean forceToRetrieve) {
        for (BeanDescriptor beanDescriptor : classDescriptor.getBeanDescriptors()) {
            this.retrieveBeanField(session, beanDescriptor, node, object, forceToRetrieve);
        }
    }

    private void retrieveBeanField(Session session, BeanDescriptor beanDescriptor, Node node, Object object, boolean forceToRetrieve) {
        if (!beanDescriptor.isAutoRetrieve() && !forceToRetrieve) {
            return;
        }
        String beanName = beanDescriptor.getFieldName();
        String beanPath = ObjectContentManagerUtil.getPath(session, beanDescriptor, node);
        Object bean = null;
        if (this.requestObjectCache.isCached(beanPath)) {
            bean = this.requestObjectCache.getObject(beanPath);
            ReflectionUtils.setNestedProperty(object, beanName, bean);
        } else {
            Class beanClass = ReflectionUtils.getPropertyType(object, beanName);
            String converterClassName = null;
            converterClassName = null == beanDescriptor.getConverter() || "".equals(beanDescriptor.getConverter()) ? DEFAULT_BEAN_CONVERTER : beanDescriptor.getConverter();
            Object[] param = new Object[]{this.mapper, this, this.atomicTypeConverterProvider};
            BeanConverter beanConverter = (BeanConverter)ReflectionUtils.invokeConstructor(converterClassName, param);
            if (beanDescriptor.isProxy()) {
                block9: {
                    if (beanDescriptor.getJcrType() != null && !"".equals(beanDescriptor.getJcrType())) {
                        try {
                            String className = this.mapper.getClassDescriptorByNodeType(beanDescriptor.getJcrType()).getClassName();
                            if (log.isDebugEnabled()) {
                                log.debug("a mapped jcrType has been specified, switching from <" + beanClass + "> to <" + ReflectionUtils.forName(className));
                            }
                            beanClass = ReflectionUtils.forName(className);
                        }
                        catch (IncorrectPersistentClassException e) {
                            if (!log.isDebugEnabled()) break block9;
                            log.debug(beanDescriptor.getClassDescriptor().getJcrType() + " is not mapped");
                        }
                    }
                }
                bean = this.proxyManager.createBeanProxy(beanConverter, beanConverter.getPath(session, beanDescriptor, node), session, node, beanDescriptor, this.mapper.getClassDescriptorByClass(beanClass), beanClass, bean);
            } else {
                bean = beanConverter.getObject(session, node, beanDescriptor, this.mapper.getClassDescriptorByClass(beanClass), beanClass, bean);
            }
            this.requestObjectCache.cache(beanPath, bean);
            ReflectionUtils.setNestedProperty(object, beanName, bean);
        }
    }

    private void retrieveCollectionFields(Session session, ClassDescriptor classDescriptor, Node parentNode, Object object, boolean forceToRetrieve) {
        for (CollectionDescriptor collectionDescriptor : classDescriptor.getCollectionDescriptors()) {
            this.retrieveCollectionField(session, collectionDescriptor, parentNode, object, forceToRetrieve);
        }
    }

    private void retrieveCollectionField(Session session, CollectionDescriptor collectionDescriptor, Node parentNode, Object object, boolean forceToRetrieve) {
        if (!collectionDescriptor.isAutoRetrieve() && !forceToRetrieve) {
            return;
        }
        CollectionConverter collectionConverter = this.getCollectionConverter(session, collectionDescriptor);
        Class collectionFieldClass = ReflectionUtils.getPropertyType(object, collectionDescriptor.getFieldName());
        if (collectionDescriptor.isProxy()) {
            Object proxy = this.proxyManager.createCollectionProxy(session, collectionConverter, parentNode, collectionDescriptor, collectionFieldClass);
            ReflectionUtils.setNestedProperty(object, collectionDescriptor.getFieldName(), proxy);
        } else {
            ManageableObjects objects = collectionConverter.getCollection(session, parentNode, collectionDescriptor, collectionFieldClass);
            if (objects == null) {
                ReflectionUtils.setNestedProperty(object, collectionDescriptor.getFieldName(), null);
            } else if (!objects.getClass().equals(ManageableCollectionImpl.class) && !objects.getClass().equals(ManageableMapImpl.class)) {
                ReflectionUtils.setNestedProperty(object, collectionDescriptor.getFieldName(), objects);
            } else {
                ReflectionUtils.setNestedProperty(object, collectionDescriptor.getFieldName(), objects.getObjects());
            }
        }
    }

    private void insertBeanFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        for (BeanDescriptor beanDescriptor : classDescriptor.getBeanDescriptors()) {
            Object bean;
            if (!beanDescriptor.isAutoInsert() || (bean = ReflectionUtils.getNestedProperty(object, beanDescriptor.getFieldName())) == null) continue;
            String converterClassName = null;
            converterClassName = null == beanDescriptor.getConverter() || "".equals(beanDescriptor.getConverter()) ? DEFAULT_BEAN_CONVERTER : beanDescriptor.getConverter();
            Object[] param = new Object[]{this.mapper, this, this.atomicTypeConverterProvider};
            BeanConverter beanConverter = (BeanConverter)ReflectionUtils.invokeConstructor(converterClassName, param);
            beanConverter.insert(session, objectNode, beanDescriptor, this.mapper.getClassDescriptorByClass(bean.getClass()), bean, classDescriptor, object);
        }
    }

    private void updateBeanFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        for (BeanDescriptor beanDescriptor : classDescriptor.getBeanDescriptors()) {
            if (!beanDescriptor.isAutoUpdate()) continue;
            Object bean = ReflectionUtils.getNestedProperty(object, beanDescriptor.getFieldName());
            String converterClassName = null;
            converterClassName = null == beanDescriptor.getConverter() || "".equals(beanDescriptor.getConverter()) ? DEFAULT_BEAN_CONVERTER : beanDescriptor.getConverter();
            Object[] param = new Object[]{this.mapper, this, this.atomicTypeConverterProvider};
            BeanConverter beanConverter = (BeanConverter)ReflectionUtils.invokeConstructor(converterClassName, param);
            Class beanClass = ReflectionUtils.getPropertyType(object, beanDescriptor.getFieldName());
            if (bean == null) {
                beanConverter.remove(session, objectNode, beanDescriptor, this.mapper.getClassDescriptorByClass(beanClass), bean, classDescriptor, object);
                continue;
            }
            beanConverter.update(session, objectNode, beanDescriptor, this.mapper.getClassDescriptorByClass(beanClass), bean, classDescriptor, object);
        }
    }

    private void insertCollectionFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        for (CollectionDescriptor collectionDescriptor : classDescriptor.getCollectionDescriptors()) {
            if (!collectionDescriptor.isAutoInsert()) continue;
            CollectionConverter collectionConverter = this.getCollectionConverter(session, collectionDescriptor);
            Object collection = ReflectionUtils.getNestedProperty(object, collectionDescriptor.getFieldName());
            ManageableObjects manageableCollection = ManageableObjectsUtil.getManageableObjects(collection);
            collectionConverter.insertCollection(session, objectNode, collectionDescriptor, manageableCollection);
        }
    }

    private void updateCollectionFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        for (CollectionDescriptor collectionDescriptor : classDescriptor.getCollectionDescriptors()) {
            if (!collectionDescriptor.isAutoUpdate()) continue;
            CollectionConverter collectionConverter = this.getCollectionConverter(session, collectionDescriptor);
            Object collection = ReflectionUtils.getNestedProperty(object, collectionDescriptor.getFieldName());
            ManageableObjects manageableCollection = ManageableObjectsUtil.getManageableObjects(collection);
            collectionConverter.updateCollection(session, objectNode, collectionDescriptor, manageableCollection);
        }
    }

    public CollectionConverter getCollectionConverter(Session session, CollectionDescriptor collectionDescriptor) {
        String className = collectionDescriptor.getCollectionConverter();
        Map atomicTypeConverters = this.atomicTypeConverterProvider.getAtomicTypeConverters();
        if (className == null) {
            return new DefaultCollectionConverterImpl(atomicTypeConverters, this, this.mapper);
        }
        return (CollectionConverter)ReflectionUtils.invokeConstructor(className, new Object[]{atomicTypeConverters, this, this.mapper});
    }

    private ClassDescriptor getClassDescriptor(Class beanClass) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(beanClass);
        if (null == classDescriptor) {
            throw new JcrMappingException("Class of type: " + beanClass.getName() + " is not JCR persistable. Maybe element 'class-descriptor' for this type in mapping file is missing");
        }
        return classDescriptor;
    }

    private Node getActualNode(Session session, Node node) throws javax.jcr.RepositoryException {
        NodeType type = node.getPrimaryNodeType();
        if (type.getName().equals("nt:versionedChild")) {
            String uuid = node.getProperty("jcr:childVersionHistory").getValue().getString();
            Node actualNode = session.getNodeByIdentifier(uuid);
            String name = actualNode.getName();
            actualNode = session.getNodeByIdentifier(name);
            return actualNode;
        }
        return node;
    }
}

