/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.manager.objectconverter.impl;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.ocm.exception.ObjectContentManagerException;
import org.apache.jackrabbit.ocm.exception.RepositoryException;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverter;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.AtomicTypeConverterProvider;
import org.apache.jackrabbit.ocm.manager.atomictypeconverter.impl.NullTypeConverterImpl;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.mapper.model.FieldDescriptor;
import org.apache.jackrabbit.ocm.reflection.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFieldsHelper {
    private static final Logger log = LoggerFactory.getLogger(SimpleFieldsHelper.class);
    private static final AtomicTypeConverter NULL_CONVERTER = new NullTypeConverterImpl();
    private AtomicTypeConverterProvider atomicTypeConverterProvider;

    public SimpleFieldsHelper(AtomicTypeConverterProvider converterProvider) {
        this.atomicTypeConverterProvider = converterProvider;
    }

    public Object retrieveSimpleFields(Session session, ClassDescriptor classDescriptor, Node node, Object object) {
        Object initializedBean = object;
        try {
            Iterator fieldDescriptorIterator = classDescriptor.getFieldDescriptors().iterator();
            if (classDescriptor.usesNodeTypePerHierarchyStrategy() && classDescriptor.hasDiscriminator() && !node.hasProperty("ocm_classname")) {
                throw new ObjectContentManagerException("Class '" + classDescriptor.getClassName() + "' has not a discriminator property.");
            }
            while (fieldDescriptorIterator.hasNext()) {
                FieldDescriptor fieldDescriptor = (FieldDescriptor)fieldDescriptorIterator.next();
                String fieldName = fieldDescriptor.getFieldName();
                String propertyName = fieldDescriptor.getJcrName();
                if (fieldDescriptor.isPath()) {
                    if (null == initializedBean) {
                        initializedBean = ReflectionUtils.newInstance(classDescriptor.getClassName());
                    }
                    ReflectionUtils.setNestedProperty(initializedBean, fieldName, node.getPath());
                    continue;
                }
                if (fieldDescriptor.isUuid()) {
                    if (null == initializedBean) {
                        initializedBean = ReflectionUtils.newInstance(classDescriptor.getClassName());
                    }
                    ReflectionUtils.setNestedProperty(initializedBean, fieldName, node.getIdentifier());
                    continue;
                }
                initializedBean = this.retrieveSimpleField(classDescriptor, node, initializedBean, fieldDescriptor, fieldName, propertyName);
            }
        }
        catch (ValueFormatException vfe) {
            throw new ObjectContentManagerException("Cannot retrieve properties of object " + object + " from node " + node, vfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot retrieve properties of object " + object + " from node " + node, re);
        }
        return initializedBean;
    }

    public Object refreshUuidPath(Session session, ClassDescriptor classDescriptor, Node node, Object object) {
        Object initializedBean = object;
        try {
            FieldDescriptor uuidField;
            if (initializedBean == null) {
                return null;
            }
            FieldDescriptor pathField = classDescriptor.getPathFieldDescriptor();
            if (pathField != null) {
                ReflectionUtils.setNestedProperty(initializedBean, pathField.getFieldName(), node.getPath());
            }
            if ((uuidField = classDescriptor.getUuidFieldDescriptor()) != null) {
                ReflectionUtils.setNestedProperty(initializedBean, uuidField.getFieldName(), node.getIdentifier());
            }
        }
        catch (ValueFormatException vfe) {
            throw new ObjectContentManagerException("Cannot retrieve properties of object " + object + " from node " + node, vfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot retrieve properties of object " + object + " from node " + node, re);
        }
        return initializedBean;
    }

    private Object retrieveSimpleField(ClassDescriptor classDescriptor, Node node, Object initializedBean, FieldDescriptor fieldDescriptor, String fieldName, String propertyName) throws javax.jcr.RepositoryException, ValueFormatException, PathNotFoundException {
        Value propValue;
        if (node.hasProperty(propertyName)) {
            propValue = node.getProperty(propertyName).getValue();
        } else if (fieldDescriptor.getJcrDefaultValue() != null) {
            ValueFactory vf = node.getSession().getValueFactory();
            propValue = vf.createValue(fieldDescriptor.getJcrDefaultValue());
        } else {
            PropertyDefinition propDef = this.getPropertyDefinition(node, propertyName);
            if (propDef != null && propDef.getDefaultValues() != null && propDef.getDefaultValues().length == 1) {
                log.debug("retrieveSimpleField: Use default value from property definition for missing mapped property " + propertyName + " of class '" + classDescriptor.getClassName() + "'");
                propValue = propDef.getDefaultValues()[0];
            } else {
                log.debug("retrieveSimpleField: No default value available for missing mapped property " + propertyName + " of class '" + classDescriptor.getClassName() + "'");
                propValue = null;
            }
        }
        if (initializedBean == null) {
            if (propValue == null) {
                return null;
            }
            initializedBean = ReflectionUtils.newInstance(classDescriptor.getClassName());
        }
        AtomicTypeConverter converter = this.getAtomicTypeConverter(fieldDescriptor, initializedBean, fieldName);
        Object fieldValue = propValue != null ? converter.getObject(propValue) : null;
        ReflectionUtils.setNestedProperty(initializedBean, fieldName, fieldValue);
        return initializedBean;
    }

    public void storeSimpleFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        try {
            ValueFactory valueFactory = session.getValueFactory();
            for (FieldDescriptor fieldDescriptor : classDescriptor.getFieldDescriptors()) {
                String fieldName = fieldDescriptor.getFieldName();
                String jcrName = fieldDescriptor.getJcrName();
                if (fieldDescriptor.isPath() || fieldDescriptor.isUuid()) continue;
                this.storeSimpleField(object, objectNode, valueFactory, fieldDescriptor, fieldName, jcrName);
            }
        }
        catch (ValueFormatException vfe) {
            throw new ObjectContentManagerException("Cannot persist properties of object " + object + ". Value format exception.", vfe);
        }
        catch (VersionException ve) {
            throw new ObjectContentManagerException("Cannot persist properties of object " + object + ". Versioning exception.", ve);
        }
        catch (LockException le) {
            throw new ObjectContentManagerException("Cannot persist properties of object " + object + " on locked node.", le);
        }
        catch (ConstraintViolationException cve) {
            throw new ObjectContentManagerException("Cannot persist properties of object " + object + ". Constraint violation.", cve);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot persist properties of object " + object, re);
        }
    }

    private void storeSimpleField(Object object, Node objectNode, ValueFactory valueFactory, FieldDescriptor fieldDescriptor, String fieldName, String jcrName) throws javax.jcr.RepositoryException, PathNotFoundException, ValueFormatException, VersionException, LockException, ConstraintViolationException {
        boolean protectedProperty = this.isProtectedProperty(objectNode, fieldDescriptor, jcrName);
        if (!protectedProperty) {
            Object fieldValue = ReflectionUtils.getNestedProperty(object, fieldName);
            String defaultValue = fieldDescriptor.getJcrDefaultValue();
            if (fieldValue == null && defaultValue != null) {
                ReflectionUtils.setNestedProperty(object, fieldName, defaultValue);
                fieldValue = ReflectionUtils.getNestedProperty(object, fieldName);
            }
            AtomicTypeConverter converter = this.getAtomicTypeConverter(fieldDescriptor, object, fieldName);
            Value value = converter.getValue(valueFactory, fieldValue);
            this.checkProperty(objectNode, fieldDescriptor, value);
            objectNode.setProperty(jcrName, value);
        }
    }

    private boolean isProtectedProperty(Node objectNode, FieldDescriptor fieldDescriptor, String jcrName) throws javax.jcr.RepositoryException, PathNotFoundException {
        if (fieldDescriptor.isJcrProtected()) {
            return true;
        }
        if (objectNode.hasProperty(jcrName)) {
            return objectNode.getProperty(jcrName).getDefinition().isProtected();
        }
        PropertyDefinition definition = this.getPropertyDefinition(objectNode, jcrName);
        if (definition != null) {
            return definition.isProtected();
        }
        return false;
    }

    private void checkProperty(Node objectNode, FieldDescriptor fieldDescriptor, Value value) throws javax.jcr.RepositoryException {
        PropertyDefinition definition;
        if (value == null && (definition = this.getPropertyDefinition(objectNode, fieldDescriptor.getJcrName())) != null && definition.isMandatory() && !definition.isAutoCreated()) {
            throw new ObjectContentManagerException("Class of type:" + fieldDescriptor.getClassDescriptor().getClassName() + " has property: " + fieldDescriptor.getFieldName() + " declared as JCR property: " + fieldDescriptor.getJcrName() + " This property is mandatory but property in bean has value null");
        }
    }

    private AtomicTypeConverter getAtomicTypeConverter(FieldDescriptor fd, Object object, String fieldName) {
        Class fieldTypeClass = null;
        String atomicTypeConverterClass = fd.getConverter();
        if (null != atomicTypeConverterClass) {
            return (AtomicTypeConverter)ReflectionUtils.newInstance(atomicTypeConverterClass);
        }
        if (null != object) {
            fieldTypeClass = ReflectionUtils.getPropertyType(object, fieldName);
        }
        if (null != fieldTypeClass) {
            return this.atomicTypeConverterProvider.getAtomicTypeConverter(fieldTypeClass);
        }
        return NULL_CONVERTER;
    }

    private PropertyDefinition getPropertyDefinition(NodeType nodeType, String propertyName) {
        PropertyDefinition[] pd = nodeType.getPropertyDefinitions();
        PropertyDefinition candidate = null;
        for (int i = 0; i < pd.length; ++i) {
            if (pd[i].isMultiple()) continue;
            if (propertyName.equals(pd[i].getName())) {
                return pd[i];
            }
            if (pd[i].getName() != null || candidate != null) continue;
            candidate = pd[i];
        }
        return candidate;
    }

    private PropertyDefinition getPropertyDefinition(Node node, String propertyName) throws javax.jcr.RepositoryException {
        NodeType nt = node.getPrimaryNodeType();
        PropertyDefinition propDef = this.getPropertyDefinition(nt, propertyName);
        if (propDef != null && propDef.getName() != null) {
            return propDef;
        }
        NodeType[] mixins = node.getMixinNodeTypes();
        for (int i = 0; mixins != null && i < mixins.length; ++i) {
            PropertyDefinition candidate = this.getPropertyDefinition(mixins[i], propertyName);
            if (candidate != null && candidate.getName() != null) {
                return propDef;
            }
            if (propDef != null) continue;
            propDef = candidate;
        }
        return propDef;
    }
}

