/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.ocm.query.impl;

import org.apache.jackrabbit.ocm.mapper.Mapper;
import org.apache.jackrabbit.ocm.mapper.model.ClassDescriptor;
import org.apache.jackrabbit.ocm.query.Filter;
import org.apache.jackrabbit.ocm.query.Query;

public class QueryImpl
implements Query {
    private Filter filter;
    ClassDescriptor classDescriptor;
    private static final String ORDER_BY_STRING = "order by ";
    private String jcrExpression = "";

    public QueryImpl(Filter filter, Mapper mapper) {
        this.filter = filter;
        this.classDescriptor = mapper.getClassDescriptorByClass(filter.getFilterClass());
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void addOrderByDescending(String fieldNameAttribute) {
        this.addExpression("@" + this.getJcrFieldName(fieldNameAttribute) + " descending");
    }

    public void addOrderByAscending(String fieldNameAttribute) {
        this.addExpression("@" + this.getJcrFieldName(fieldNameAttribute) + " ascending");
    }

    public void addJCRExpression(String jcrExpression) {
        this.addExpression(jcrExpression);
    }

    private void addExpression(String jcrExpression) {
        this.jcrExpression = this.jcrExpression.equals("") ? this.jcrExpression + jcrExpression : this.jcrExpression + " , " + jcrExpression;
    }

    public String getOrderByExpression() {
        if (this.jcrExpression.equals("")) {
            return "";
        }
        if (this.jcrExpression.contains(ORDER_BY_STRING)) {
            return this.jcrExpression;
        }
        return ORDER_BY_STRING + this.jcrExpression;
    }

    private String getJcrFieldName(String fieldAttribute) {
        return this.classDescriptor.getJcrName(fieldAttribute);
    }
}

