/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.filevault.maven.packaging.impl.StringFilterSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public class SubPackage {
    @Parameter
    private final StringFilterSet groupId = new StringFilterSet();
    @Parameter
    private final StringFilterSet artifactId = new StringFilterSet();
    @Parameter
    private ScopeArtifactFilter scope;
    @Parameter
    private String type;
    @Parameter
    private String classifier;
    @Parameter
    private boolean filter;
    @Parameter
    private boolean excludeTransitive;

    public void setGroupId(String groupId) {
        this.groupId.addEntries(groupId);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId.addEntries(artifactId);
    }

    public void setScope(String scope) {
        this.scope = new ScopeArtifactFilter(scope);
    }

    public void setAddFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setExcludeTransitive(boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
    }

    public boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    public List<Artifact> getMatchingArtifacts(MavenProject project) {
        Set deps = this.excludeTransitive ? project.getDependencyArtifacts() : project.getArtifacts();
        ArrayList<Artifact> matches = new ArrayList<Artifact>();
        for (Object dep : deps) {
            Artifact artifact = (Artifact)dep;
            if (!this.groupId.contains(artifact.getGroupId()) || !this.artifactId.contains(artifact.getArtifactId()) || this.scope != null && !this.scope.include(artifact) || this.type != null && !this.type.equals(artifact.getType()) || this.classifier != null && !this.classifier.equals(artifact.getClassifier())) continue;
            matches.add(artifact);
        }
        return matches;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Sub Packages: ");
        if (this.groupId != null) {
            builder.append("groupId=").append(this.groupId).append(",");
        }
        if (this.artifactId != null) {
            builder.append("artifactId=").append(this.artifactId).append(",");
        }
        if (this.scope != null) {
            builder.append("scope=").append(this.scope).append(",");
        }
        builder.append("filter=").append(this.filter);
        builder.append(",excludeTransitive=").append(this.excludeTransitive);
        return builder.toString();
    }
}

