/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.filevault.maven.packaging.ContentPackageArchiver;
import org.apache.jackrabbit.filevault.maven.packaging.Dependency;
import org.apache.jackrabbit.filevault.maven.packaging.DependencyValidator;
import org.apache.jackrabbit.filevault.maven.packaging.Embedded;
import org.apache.jackrabbit.filevault.maven.packaging.FileValidator;
import org.apache.jackrabbit.filevault.maven.packaging.PackageDependency;
import org.apache.jackrabbit.filevault.maven.packaging.PackageId;
import org.apache.jackrabbit.filevault.maven.packaging.SubPackage;
import org.apache.jackrabbit.filevault.maven.packaging.impl.DefaultWorkspaceFilter;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PackageType;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PathFilterSet;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PlatformNameFormat;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class VaultMojo
extends AbstractMojo {
    private static final String JCR_ROOT = "jcr_root/";
    private static final String VAULT_DIR = "META-INF/vault";
    public static final String PROPERTIES_FILE = "META-INF/vault/properties.xml";
    public static final String FILTER_FILE = "META-INF/vault/filter.xml";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String PACKAGE_TYPE = "zip";
    private static final String PACKAGE_EXT = ".zip";
    public static final String MF_KEY_PACKAGE_TYPE = "Content-Package-Type";
    public static final String MF_KEY_PACKAGE_ID = "Content-Package-Id";
    private static final String MF_KEY_PACKAGE_DEPENDENCIES = "Content-Package-Dependencies";
    public static final String MF_KEY_PACKAGE_ROOTS = "Content-Package-Roots";
    private static final String MF_KEY_PACKAGE_DESC = "Content-Package-Description";
    private static final String MF_KEY_IMPORT_PACKAGE = "Import-Package";
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Deprecated
    @Parameter
    private File builtContentDirectory;
    @Parameter(property="vault.jcrRootSourceDirectory", required=true, defaultValue="${project.basedir}/jcr_root,${project.basedir}/src/main/jcr_root,${project.basedir}/src/main/content/jcr_root,${project.basedir}/src/content/jcr_root,${project.build.outputDirectory}")
    private File[] jcrRootSourceDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(property="vault.finalName", defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private File filterSource;
    @Parameter(defaultValue="${project.build.directory}/vault-work", required=true)
    private File workDirectory;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter(property="vault.prefix")
    private String prefix;
    @Parameter(property="vault.group", defaultValue="${project.groupId}", required=true)
    private String group;
    @Parameter(property="vault.name", defaultValue="${project.artifactId}", required=true)
    private String name;
    @Parameter(property="vault.version", defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(property="vault.requiresRoot", defaultValue="false", required=true)
    private boolean requiresRoot;
    @Parameter(property="vault.allowIndexDefinitions", defaultValue="false", required=true)
    private boolean allowIndexDefinitions;
    @Parameter(property="vault.failOnDependencyErrors", defaultValue="true", required=true)
    private boolean failOnDependencyErrors;
    @Parameter(property="vault.failOnEmptyFilter", defaultValue="true", required=true)
    private boolean failOnEmptyFilter;
    @Parameter(property="vault.excludes", defaultValue="**/.vlt,**/.vltignore,**/.DS_Store", required=true)
    private String[] excludes;
    @Parameter(property="vault.embeddedTarget")
    private String embeddedTarget;
    @Parameter
    private Embedded[] embeddeds = new Embedded[0];
    @Parameter(property="vault.failOnMissingEmbed", defaultValue="false", required=true)
    private boolean failOnMissingEmbed;
    @Parameter(property="vault.packageType")
    private PackageType packageType;
    @Parameter(property="vault.importPackage", defaultValue="-org.apache.sling.scripting.sightly.compiler.expression.nodes,-org.apache.sling.scripting.sightly.java.compiler,-org.apache.sling.scripting.sightly.render")
    private String importPackage;
    @Parameter
    private final DefaultWorkspaceFilter filters = new DefaultWorkspaceFilter();
    @Parameter
    private Dependency[] dependencies = new Dependency[0];
    @Parameter
    private Dependency[] repositoryStructurePackages = new Dependency[0];
    private String dependenciesString;
    @Parameter
    private SubPackage[] subPackages = new SubPackage[0];
    @Parameter(property="vault.generatedImportPackage", defaultValue="${project.build.directory}/vault-generated-import.txt")
    private File generatedImportPackage;
    @Parameter
    private final Properties properties = new Properties();

    public void setPackageType(String type) throws MojoFailureException {
        try {
            this.packageType = PackageType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Invalid package type specified: " + type + ".\nMust be empty or one of 'application', 'content', 'container', 'mixed'");
        }
    }

    @Nonnull
    private FileSet createFileSet(@Nonnull File directory, @Nonnull String prefix) {
        return (FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)directory).prefixed(prefix)).includeExclude(null, this.excludes)).includeEmptyDirs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.prefix == null) {
            this.prefix = "";
        } else if (!this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
        File vaultDir = new File(this.workDirectory, VAULT_DIR);
        File finalFile = new File(this.outputDirectory, this.finalName + PACKAGE_EXT);
        try {
            vaultDir.mkdirs();
            Map<String, File> embeddedFiles = this.copyEmbeddeds();
            embeddedFiles.putAll(this.copySubPackages());
            this.computePackageFilters(vaultDir);
            this.validatePackageType();
            this.computeImportPackage();
            this.computeDependencies();
            if (this.packageType == PackageType.APPLICATION) {
                this.validateDependencies();
            } else {
                this.getLog().info((CharSequence)("Ignoring dependency validation due to non-application package type: " + (Object)((Object)this.packageType)));
            }
            Properties vaultProperties = this.computeProperties();
            FileOutputStream fos = new FileOutputStream(new File(vaultDir, "properties.xml"));
            vaultProperties.storeToXML(fos, this.project.getName());
            this.copyFile("/vault/config.xml", new File(vaultDir, "config.xml"));
            this.copyFile("/vault/settings.xml", new File(vaultDir, "settings.xml"));
            ContentPackageArchiver contentPackageArchiver = new ContentPackageArchiver();
            contentPackageArchiver.setIncludeEmptyDirs(true);
            contentPackageArchiver.addFileSet(this.createFileSet(this.workDirectory, ""));
            File jcrSourceDirectory = null;
            if (this.builtContentDirectory != null) {
                this.getLog().warn((CharSequence)"The 'builtContentDirectory' is deprecated. Please use the new 'jcrRootSourceDirectory' instead.");
                jcrSourceDirectory = this.builtContentDirectory;
            } else {
                for (File dir : this.jcrRootSourceDirectory) {
                    if (!dir.exists() || !dir.isDirectory()) continue;
                    jcrSourceDirectory = dir;
                    break;
                }
            }
            if (jcrSourceDirectory != null) {
                this.getLog().info((CharSequence)("packaging content from " + jcrSourceDirectory.getPath()));
            }
            if (jcrSourceDirectory != null && jcrSourceDirectory.exists()) {
                List<PathFilterSet> filterSets = this.filters.getFilterSets();
                if (filterSets.isEmpty()) {
                    contentPackageArchiver.addFileSet(this.createFileSet(jcrSourceDirectory, FileUtils.normalize((String)(JCR_ROOT + this.prefix))));
                } else {
                    for (PathFilterSet filterSet : filterSets) {
                        String relPath = PlatformNameFormat.getPlatformPath(filterSet.getRoot());
                        String rootPath = FileUtils.normalize((String)(JCR_ROOT + this.prefix + relPath));
                        if (embeddedFiles.containsKey(rootPath)) continue;
                        File fullCoverage = new File(jcrSourceDirectory, relPath + ".xml");
                        if (fullCoverage.isFile()) {
                            rootPath = FileUtils.normalize((String)(JCR_ROOT + this.prefix + relPath + ".xml"));
                            contentPackageArchiver.addFile(fullCoverage, rootPath);
                            continue;
                        }
                        File rootDirectory = new File(jcrSourceDirectory, relPath);
                        while (!(rootDirectory.exists() && rootDirectory.isDirectory() || jcrSourceDirectory.equals(rootDirectory))) {
                            rootDirectory = rootDirectory.getParentFile();
                            relPath = StringUtils.chomp((String)relPath, (String)"/");
                        }
                        if (jcrSourceDirectory.equals(rootDirectory)) continue;
                        rootPath = FileUtils.normalize((String)(JCR_ROOT + this.prefix + relPath));
                        contentPackageArchiver.addFileSet(this.createFileSet(rootDirectory, rootPath + "/"));
                    }
                }
            }
            for (Map.Entry entry : embeddedFiles.entrySet()) {
                contentPackageArchiver.addFile((File)entry.getValue(), (String)entry.getKey());
            }
            if (!this.allowIndexDefinitions) {
                FileValidator fileValidator = new FileValidator();
                this.getLog().info((CharSequence)"Scanning files for oak index definitions.");
                for (ArchiveEntry entry : contentPackageArchiver.getFiles().values()) {
                    if (entry.getType() != 1) continue;
                    InputStream in = null;
                    try {
                        in = entry.getInputStream();
                        fileValidator.lookupIndexDefinitionInArtifact(in, entry.getName());
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                if (fileValidator.isContainingIndexDef) {
                    this.getLog().error((CharSequence)fileValidator.getMessageWithPathsOfIndexDef());
                    throw new MojoExecutionException("Package should not contain index definitions, because 'allowIndexDefinitions=false'.");
                }
            }
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver((JarArchiver)contentPackageArchiver);
            mavenArchiver.setOutputFile(finalFile);
            mavenArchiver.createArchive(null, this.project, this.getMavenArchiveConfiguration(vaultProperties));
            Artifact artifact = this.project.getArtifact();
            artifact.setFile(finalFile);
            artifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler(PACKAGE_TYPE));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), e);
        }
    }

    private void computePackageFilters(File vaultMetaDir) throws IOException, MojoExecutionException {
        File filterFile = new File(vaultMetaDir, "filter.xml");
        if (filterFile.exists() && filterFile.lastModified() != 0L) {
            if (!this.filters.getFilterSets().isEmpty()) {
                this.getLog().error((CharSequence)"Refuse to merge inline filters and non-sourced filter.xml. If this is intended, specify the filter.xml via the 'filterSource' property.");
                throw new MojoExecutionException("conflicting filters.");
            }
            this.filters.load(filterFile);
            this.getLog().warn((CharSequence)"The project is using a filter.xml provided via the resource plugin.");
            this.getLog().warn((CharSequence)"This is deprecated and might no longer be supported in future versions.");
            this.getLog().warn((CharSequence)"Use the 'filterSource' property to specify the filter or use inline filters.");
            return;
        }
        if (filterFile.exists() && filterFile.lastModified() == 0L) {
            try {
                Files.delete(filterFile.toPath());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Unable to delete previously generated filter.xml. re-run the goals with a clean setup.");
                throw new MojoExecutionException("Unable to delete file.", (Exception)e);
            }
        }
        DefaultWorkspaceFilter sourceFilters = new DefaultWorkspaceFilter();
        if (this.filterSource != null && this.filterSource.exists()) {
            this.getLog().info((CharSequence)("Loading filter from " + this.filterSource.getPath()));
            sourceFilters.load(this.filterSource);
            if (!this.filters.getFilterSets().isEmpty()) {
                this.getLog().info((CharSequence)"Merging inline filters.");
                sourceFilters.merge(this.filters);
            }
            this.filters.getFilterSets().clear();
            this.filters.getFilterSets().addAll(sourceFilters.getFilterSets());
            sourceFilters = new DefaultWorkspaceFilter();
            sourceFilters.load(this.filterSource);
            sourceFilters.generateSource();
        }
        if (this.filters.getFilterSets().isEmpty() && this.prefix.length() > 0) {
            this.addWorkspaceFilter(this.prefix);
        }
        if (this.filters.getFilterSets().isEmpty()) {
            if (this.failOnEmptyFilter) {
                String msg = "No workspace filter defined (failOnEmptyFilter=true)";
                this.getLog().error((CharSequence)"No workspace filter defined (failOnEmptyFilter=true)");
                throw new MojoExecutionException("No workspace filter defined (failOnEmptyFilter=true)");
            }
            this.getLog().warn((CharSequence)"No workspace filter defined. Package import might have unexpected results.");
        }
        if (this.filterSource != null && sourceFilters.getSourceAsString().equals(this.filters.getSourceAsString())) {
            FileUtils.copyFile((File)this.filterSource, (File)filterFile);
        } else {
            this.getLog().info((CharSequence)"Generating filter.xml from plugin configuration");
            FileUtils.fileWrite((String)filterFile.getAbsolutePath(), (String)this.filters.getSourceAsString());
        }
        if (!filterFile.setLastModified(0L)) {
            this.getLog().warn((CharSequence)"Unable to set last modified of filters file. make sure to clean the project before next run.");
        }
    }

    private void computeDependencies() throws IOException {
        if (this.dependencies.length > 0) {
            this.dependenciesString = PackageDependency.toString(Dependency.resolve(this.project, this.getLog(), this.dependencies));
        }
        Dependency.resolve(this.project, this.getLog(), this.repositoryStructurePackages);
    }

    private void validateDependencies() throws MojoExecutionException {
        List<String> errors = new DependencyValidator().addDependencies(this.dependencies).addDependencies(this.repositoryStructurePackages).setFilters(this.filters).validate().getErrors();
        if (errors.size() > 0) {
            String msg = String.format("%d error(s) detected during dependency analysis.", errors.size());
            if (this.failOnDependencyErrors) {
                this.getLog().error((CharSequence)msg);
                for (String error : errors) {
                    this.getLog().error((CharSequence)error);
                }
                throw new MojoExecutionException(msg);
            }
            this.getLog().warn((CharSequence)msg);
            for (String error : errors) {
                this.getLog().warn((CharSequence)error);
            }
        } else {
            this.getLog().info((CharSequence)"All dependencies satisfied.");
        }
    }

    private void computeImportPackage() throws IOException {
        String importPackageStr;
        TreeMap importParams = new TreeMap();
        if (this.generatedImportPackage.exists() && (importPackageStr = FileUtils.fileRead((File)this.generatedImportPackage)).length() > 0) {
            importParams.putAll(new Parameters(importPackageStr));
        }
        if (this.importPackage != null) {
            this.getLog().debug((CharSequence)("merging analyzer-packages with:\n" + this.importPackage + "\n"));
            for (Map.Entry entry : new Parameters(this.importPackage).entrySet()) {
                boolean delete = false;
                String pkg = (String)entry.getKey();
                if ("-*".equals(pkg)) {
                    importParams.clear();
                    continue;
                }
                if (pkg.charAt(0) == '-') {
                    pkg = pkg.substring(1);
                    delete = true;
                }
                if (pkg.endsWith("*")) {
                    String pkgDot = pkg.substring(0, pkg.length() - 1);
                    if (!pkgDot.endsWith(".")) {
                        pkg = pkgDot;
                        pkgDot = pkg + ".";
                    }
                    Iterator iter = importParams.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry e = iter.next();
                        String pkgName = (String)e.getKey();
                        if (!pkgName.equals(pkg) && !pkgName.startsWith(pkgDot)) continue;
                        if (delete) {
                            iter.remove();
                            continue;
                        }
                        e.setValue(entry.getValue());
                    }
                    continue;
                }
                if (delete) {
                    importParams.remove(pkg);
                    continue;
                }
                importParams.put(pkg, entry.getValue());
            }
        }
        this.importPackage = Processor.printClauses(importParams);
        if (!this.importPackage.isEmpty()) {
            this.getLog().info((CharSequence)"Merged detected packages from analyzer with 'importPackage':");
            for (Map.Entry e : importParams.entrySet()) {
                StringBuilder report = new StringBuilder();
                report.append("  ").append((String)e.getKey());
                try {
                    Processor.printClause((Map)((Map)e.getValue()), (StringBuilder)report);
                }
                catch (IOException e1) {
                    throw new IllegalStateException("Internal error while generating report", e1);
                }
                this.getLog().info((CharSequence)report);
            }
            this.getLog().info((CharSequence)"");
        }
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration(Properties vaultProperties) throws IOException {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setManifest(new ManifestConfiguration());
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
            this.archive.getManifest().setAddDefaultSpecificationEntries(false);
            this.archive.getManifest().setAddDefaultImplementationEntries(true);
            PackageId id = new PackageId(this.group, this.name, this.version);
            this.archive.addManifestEntry(MF_KEY_PACKAGE_TYPE, this.packageType.name().toLowerCase());
            this.archive.addManifestEntry(MF_KEY_PACKAGE_ID, id.toString());
            this.archive.addManifestEntry(MF_KEY_PACKAGE_DESC, vaultProperties.getProperty("description", ""));
            if (this.dependenciesString != null && this.dependenciesString.length() > 0) {
                this.archive.addManifestEntry(MF_KEY_PACKAGE_DEPENDENCIES, this.dependenciesString);
            }
            TreeSet<String> rts = new TreeSet<String>();
            for (PathFilterSet p : this.filters.getFilterSets()) {
                rts.add(p.getRoot());
            }
            Object[] roots = rts.toArray(new String[rts.size()]);
            Arrays.sort(roots);
            this.archive.addManifestEntry(MF_KEY_PACKAGE_ROOTS, StringUtils.join((Object[])roots, (String)","));
            if (StringUtils.isNotEmpty((String)this.importPackage)) {
                this.archive.addManifestEntry(MF_KEY_IMPORT_PACKAGE, StringUtils.deleteWhitespace((String)this.importPackage));
            }
        }
        return this.archive;
    }

    private Properties computeProperties() {
        Properties props = new Properties();
        String description = this.project.getDescription();
        if (description == null && (description = this.project.getName()) == null) {
            description = this.project.getArtifactId();
        }
        props.put("description", description);
        for (Object o : this.properties.keySet()) {
            if (this.properties.get(o) != null) continue;
            this.properties.put(o, "");
        }
        props.putAll((Map<?, ?>)this.properties);
        props.put("group", this.group);
        props.put("name", this.name);
        props.put("version", this.version);
        props.put("groupId", this.project.getGroupId());
        props.put("artifactId", this.project.getArtifactId());
        if (this.dependenciesString != null && this.dependenciesString.length() > 0) {
            props.put("dependencies", this.dependenciesString);
        }
        if (!props.containsKey("createdBy")) {
            props.put("createdBy", System.getProperty("user.name"));
        }
        props.put("created", DATE_FORMAT.format(new Date()));
        props.put("requiresRoot", String.valueOf(this.requiresRoot));
        props.put("allowIndexDefinitions", String.valueOf(this.allowIndexDefinitions));
        props.put("packageType", this.packageType.name().toLowerCase());
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String source, File target) throws IOException {
        if (target.exists()) {
            return;
        }
        target.getParentFile().mkdirs();
        InputStream ins = ((Object)((Object)this)).getClass().getResourceAsStream(source);
        if (ins != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(target);
                IOUtil.copy((InputStream)ins, (OutputStream)out);
            }
            finally {
                IOUtil.close((InputStream)ins);
                IOUtil.close((OutputStream)out);
            }
        }
    }

    private Map<String, File> copyEmbeddeds() throws IOException, MojoFailureException {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (Embedded emb : this.embeddeds) {
            String targetPath;
            List<Artifact> artifacts = emb.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                if (this.failOnMissingEmbed) {
                    throw new MojoFailureException("Embedded artifact specified " + emb + ", but no matching dependency artifact found. Add the missing dependency or fix the embed definition.");
                }
                this.getLog().warn((CharSequence)("No matching artifacts for " + emb));
                continue;
            }
            if (emb.getDestFileName() != null && artifacts.size() > 1) {
                this.getLog().warn((CharSequence)("destFileName defined but several artifacts match for " + emb));
            }
            if ((targetPath = emb.getTarget()) == null && (targetPath = this.embeddedTarget) == null) {
                String loc = this.prefix.length() == 0 ? "/apps/" : this.prefix;
                targetPath = loc + "bundles/install/";
                this.getLog().info((CharSequence)("No target path set on " + emb + "; assuming default " + targetPath));
            }
            targetPath = this.makeAbsolutePath(targetPath);
            targetPath = JCR_ROOT + targetPath;
            if (!(targetPath = FileUtils.normalize((String)targetPath)).endsWith("/")) {
                targetPath = targetPath + "/";
            }
            this.getLog().info((CharSequence)("Embedding --- " + emb + " ---"));
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                String destFileName = emb.getDestFileName();
                if (destFileName == null) {
                    destFileName = source.getName();
                }
                String targetPathName = targetPath + destFileName;
                String targetNodePathName = targetPathName.substring(JCR_ROOT.length() - 1);
                fileMap.put(targetPathName, source);
                this.getLog().info((CharSequence)String.format("Embedding %s (from %s) -> %s", artifact.getId(), source.getAbsolutePath(), targetPathName));
                if (!emb.isFilter()) continue;
                this.addWorkspaceFilter(targetNodePathName);
            }
        }
        return fileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, File> copySubPackages() throws IOException {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (SubPackage pack : this.subPackages) {
            List<Artifact> artifacts = pack.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                this.getLog().warn((CharSequence)("No matching artifacts for " + pack));
                continue;
            }
            this.getLog().info((CharSequence)("Embedding --- " + pack + " ---"));
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                ZipFile zip = null;
                InputStream in = null;
                Properties props = new Properties();
                try {
                    zip = new ZipFile(source, 1);
                    ZipEntry e = zip.getEntry(PROPERTIES_FILE);
                    if (e == null) {
                        this.getLog().error((CharSequence)"Package does not contain properties.xml");
                        throw new IOException("properties.xml missing");
                    }
                    in = zip.getInputStream(e);
                    props.loadFromXML(in);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    if (zip != null) {
                        zip.close();
                    }
                    throw throwable;
                }
                IOUtil.close((InputStream)in);
                if (zip != null) {
                    zip.close();
                }
                PackageId pid = new PackageId(props.getProperty("group"), props.getProperty("name"), props.getProperty("version"));
                String targetNodePathName = pid.getInstallationPath() + PACKAGE_EXT;
                String targetPathName = "jcr_root" + targetNodePathName;
                fileMap.put(targetPathName, source);
                this.getLog().info((CharSequence)("Embedding " + artifact.getId() + " -> " + targetPathName));
                if (!pack.isFilter()) continue;
                this.addWorkspaceFilter(targetNodePathName);
            }
        }
        return fileMap;
    }

    private void addWorkspaceFilter(String filterRoot) {
        this.filters.add(new PathFilterSet(filterRoot));
    }

    private String makeAbsolutePath(String relPath) {
        String absPath;
        if (!relPath.startsWith("/")) {
            absPath = (this.prefix.length() == 0 ? "/" : this.prefix) + relPath;
            this.getLog().info((CharSequence)("Relative path resolved to " + absPath));
        } else {
            absPath = relPath;
        }
        return absPath;
    }

    private void validatePackageType() throws MojoFailureException {
        if (this.packageType == null) {
            boolean hasApps = false;
            boolean hasOther = false;
            for (PathFilterSet p : this.filters.getFilterSets()) {
                if (p.isCleanUp()) continue;
                String root = p.getRoot();
                if ("/apps".equals(root) || root.startsWith("/apps/") || "/libs".equals(root) || root.startsWith("/libs/")) {
                    hasApps = true;
                    continue;
                }
                hasOther = true;
            }
            this.packageType = hasApps && !hasOther ? PackageType.APPLICATION : (hasOther && !hasApps ? PackageType.CONTENT : PackageType.MIXED);
        }
    }
}

