/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.filevault.maven.packaging.Dependency;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PackageInfo;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;

public class DependencyValidator {
    private List<Dependency> dependencies = new LinkedList<Dependency>();
    private DefaultWorkspaceFilter filters;
    private List<String> errors = new LinkedList<String>();
    private Set<String> validRoots = new HashSet<String>(Arrays.asList("", "/", "/libs", "/apps", "/etc", "/var", "/tmp", "/content"));

    public DependencyValidator addDependencies(Dependency ... dependencies) {
        this.dependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    public DependencyValidator addRepositoryStructure(Dependency ... structures) {
        for (Dependency dep : structures) {
            PackageInfo info = dep.getInfo();
            if (info == null) {
                String msg = String.format("Dependency '%s' is not using maven coordinates and cannot be used for analysis.", dep.getPackageDependency());
                this.errors.add(msg);
                continue;
            }
            for (PathFilterSet set : info.getFilter().getFilterSets()) {
                String root = set.getRoot();
                this.validRoots.add(root);
            }
        }
        return this;
    }

    public DependencyValidator setFilters(DefaultWorkspaceFilter filters) {
        this.filters = filters;
        return this;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public DependencyValidator validate() {
        HashMap<Object, Dependency> roots = new HashMap<Object, Dependency>();
        for (Dependency dep : this.dependencies) {
            PackageInfo info = dep.getInfo();
            if (info == null) {
                String msg = String.format("Dependency '%s' is not using maven coordinates and cannot be used for analysis.", dep.getPackageDependency());
                this.errors.add(msg);
                continue;
            }
            for (PathFilterSet set : info.getFilter().getFilterSets()) {
                String root = set.getRoot();
                Dependency existing = (Dependency)roots.get(root);
                if (existing != null) {
                    String msg = String.format("Dependency '%s' defines same filter root '%s' as dependency '%s'", dep.getPackageDependency(), root, existing.getPackageDependency());
                    this.errors.add(msg);
                }
                roots.put(root, dep);
            }
        }
        HashSet<String> ancestors = new HashSet<String>();
        for (PathFilterSet set : this.filters.getFilterSets()) {
            String root;
            if ("cleanup".equals(set.getType()) || this.validRoots.contains(root = StringUtils.substringBeforeLast((String)set.getRoot(), (String)"/")) || this.filters.contains(root)) continue;
            ancestors.add(root);
        }
        for (String root : ancestors) {
            String isCovered = null;
            boolean isContained = false;
            for (Dependency dep : roots.values()) {
                DefaultWorkspaceFilter filter = dep.getInfo().getFilter();
                if (filter.contains(root)) {
                    isContained = true;
                }
                if (!filter.covers(root)) continue;
                isCovered = dep.getPackageDependency().toString();
            }
            if (isContained) continue;
            String msg = isCovered == null ? String.format("Filter root's ancestor '%s' is not covered by any of the specified dependencies.", root) : String.format("Filter root's ancestor '%s' is covered by '%s' but excluded by its patterns.", root, isCovered);
            this.errors.add(msg);
        }
        return this;
    }
}

