/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.filevault.maven.packaging.Filters;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractPackageMojo
extends AbstractMojo {
    static final String JCR_ROOT = "jcr_root/";
    private static final String PROPERTIES_EMBEDDEDFILESMAP_KEY = "embeddedfiles.map";
    private static final String VAULT_DIR = "META-INF/vault";
    public static final String PROPERTIES_FILE = "META-INF/vault/properties.xml";
    public static final String FILTER_FILE = "META-INF/vault/filter.xml";
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="vault.prefix")
    String prefix = "";
    @Parameter(defaultValue="${project.build.directory}/vault-work", required=true)
    File workDirectory;
    @Parameter(property="vault.metaInfVaultDirectory", required=true, defaultValue="${project.basedir}/META-INF/vault,${project.basedir}/src/main/META-INF/vault,${project.basedir}/src/main/content/META-INF/vault,${project.basedir}/src/content/META-INF/vault")
    File[] metaInfVaultDirectory;
    @Parameter(property="vault.allowIndexDefinitions", defaultValue="false", required=true)
    boolean allowIndexDefinitions;
    @Parameter(property="vault.packageType")
    protected PackageType packageType;

    public void setPrefix(String prefix) {
        if (prefix == null) {
            prefix = "";
        } else if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        this.prefix = prefix;
    }

    public void setPackageType(String type) throws MojoFailureException {
        try {
            this.packageType = PackageType.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Invalid package type specified: " + type + ".\nMust be empty or one of 'application', 'content', 'container', 'mixed'");
        }
    }

    void setEmbeddedFilesMap(Map<String, File> embeddedFiles) {
        this.getPluginContext().put(PROPERTIES_EMBEDDEDFILESMAP_KEY, embeddedFiles);
    }

    Map<String, File> getEmbeddedFilesMap() {
        Object value = this.getPluginContext().get(PROPERTIES_EMBEDDEDFILESMAP_KEY);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalStateException("The Maven property embeddedfiles.map is not containing a Map but rather " + value.getClass());
    }

    File getVaultDir() {
        return new File(this.workDirectory, VAULT_DIR);
    }

    File getMetaInfDir() {
        File metaInfDirectory = null;
        for (File dir : this.metaInfVaultDirectory) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            metaInfDirectory = dir;
            break;
        }
        if (metaInfDirectory != null) {
            this.getLog().info((CharSequence)("using meta-inf/vault from " + metaInfDirectory.getPath()));
        }
        return metaInfDirectory;
    }

    File getManifestFile() {
        return new File(this.workDirectory, "META-INF/MANIFEST.MF");
    }

    File getFilterFile() {
        return new File(this.getVaultDir(), "filter.xml");
    }

    Filters loadFilterFile() throws IOException, ConfigurationException {
        Filters filters = new Filters();
        filters.load(this.getFilterFile());
        return filters;
    }

    static File getFirstExistingDirectory(File[] directories) {
        for (File dir : directories) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            return dir;
        }
        return null;
    }
}

