/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.filevault.maven.packaging.Embedded;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.maven.MavenLogger;
import org.codehaus.mojo.animal_sniffer.maven.Signature;

@Mojo(name="check-signature", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CheckSignatureMojo
extends AbstractMojo {
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private Embedded[] embeddeds = new Embedded[0];
    @Parameter(property="vault.failOnMissingEmbed", defaultValue="false", required=true)
    private boolean failOnMissingEmbed;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    private List classpathElements;
    @Parameter
    private String[] ignores;
    @Parameter(property="localRepository", readonly=true)
    private ArtifactRepository localRepository;
    @Component
    private ArtifactResolver resolver;
    @Parameter
    private Signature signature;
    @Parameter(property="vault.checksignature.skip", defaultValue="false")
    private boolean skipCheckSignature;

    private Set<String> buildPackageList() throws IOException {
        ClassListBuilder plb = new ClassListBuilder((Logger)new MavenLogger(this.getLog()));
        for (Object classpathElement : this.classpathElements) {
            String path = (String)classpathElement;
            plb.process(new File(path));
        }
        return plb.getPackages();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipCheckSignature) {
            this.getLog().info((CharSequence)"Skipping signature check.");
            return;
        }
        if (this.signature == null) {
            this.getLog().info((CharSequence)"No signature defined. Skipping signature check.");
            return;
        }
        try {
            this.getLog().info((CharSequence)("Checking unresolved references to " + this.signature));
            Artifact a = this.signature.createArtifact(this.artifactFactory);
            this.resolver.resolve(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
            Set<String> ignoredPackages = this.buildPackageList();
            if (this.ignores != null) {
                for (String ignore : this.ignores) {
                    if (ignore == null) continue;
                    ignoredPackages.add(ignore.replace('.', '/'));
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)ignoredPackages.toString());
            }
            SignatureChecker signatureChecker = new SignatureChecker((InputStream)new FileInputStream(a.getFile()), ignoredPackages, (Logger)new MavenLogger(this.getLog()));
            signatureChecker.setCheckJars(true);
            signatureChecker.setSourcePath(Collections.singletonList(new File(this.project.getBuild().getSourceDirectory())));
            signatureChecker.process(this.getEmbeddeds().toArray(new File[0]));
            if (signatureChecker.isSignatureBroken()) {
                throw new MojoFailureException("Signature errors found. Verify them and put @IgnoreJRERequirement on them.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check signatures", (Exception)e);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to obtain signature: " + this.signature, (Exception)((Object)e));
        }
    }

    private Collection<File> getEmbeddeds() throws MojoFailureException {
        HashSet<File> files = new HashSet<File>();
        for (Embedded emb : this.embeddeds) {
            Collection<Artifact> artifacts = emb.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                if (this.failOnMissingEmbed) {
                    throw new MojoFailureException("Embedded artifact specified " + emb + ", but no matching dependency artifact found. Add the missing dependency or fix the embed definition.");
                }
                this.getLog().warn((CharSequence)("No matching artifacts for " + emb));
                continue;
            }
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                files.add(source);
            }
        }
        return files;
    }
}

