/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Processor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractPackageMojo;
import org.apache.jackrabbit.filevault.maven.packaging.Dependency;
import org.apache.jackrabbit.filevault.maven.packaging.Embedded;
import org.apache.jackrabbit.filevault.maven.packaging.Filters;
import org.apache.jackrabbit.filevault.maven.packaging.SubPackage;
import org.apache.jackrabbit.filevault.maven.packaging.impl.DependencyValidator;
import org.apache.jackrabbit.filevault.maven.packaging.impl.PackageDependency;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-metadata", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateMetadataMojo
extends AbstractPackageMojo {
    private final DateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final String MF_KEY_PACKAGE_TYPE = "Content-Package-Type";
    public static final String MF_KEY_PACKAGE_ID = "Content-Package-Id";
    public static final String MF_KEY_PACKAGE_DEPENDENCIES = "Content-Package-Dependencies";
    public static final String MF_KEY_PACKAGE_ROOTS = "Content-Package-Roots";
    public static final String MF_KEY_PACKAGE_DESC = "Content-Package-Description";
    public static final String MF_KEY_IMPORT_PACKAGE = "Import-Package";
    @Component
    private BuildContext buildContext;
    @Component(hint="default")
    private ArtifactRepositoryLayout embedArtifactLayout;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="vault.group", defaultValue="${project.groupId}", required=true)
    private String group;
    @Parameter(property="vault.name", defaultValue="${project.artifactId}", required=true)
    private String name;
    @Parameter(property="vault.version", defaultValue="${project.version}", required=true)
    private String version;
    @Parameter
    private final Filters filters = new Filters();
    @Parameter
    private File filterSource;
    @Parameter(property="vault.failOnEmptyFilter", defaultValue="true", required=true)
    private boolean failOnEmptyFilter;
    @Parameter
    private final Properties properties = new Properties();
    @Parameter
    private Dependency[] dependencies = new Dependency[0];
    @Parameter(property="vault.failOnDependencyErrors", defaultValue="true", required=true)
    private boolean failOnDependencyErrors;
    @Parameter(property="vault.acHandling", alias="acHandling", required=false)
    private AccessControlHandling accessControlHandling;
    @Parameter(property="vault.requiresRoot", defaultValue="false", required=true)
    private boolean requiresRoot;
    @Parameter(property="vault.importPackage", defaultValue="-org.apache.sling.scripting.sightly.compiler.expression.nodes,-org.apache.sling.scripting.sightly.java.compiler,-org.apache.sling.scripting.sightly.render")
    private String importPackage;
    @Parameter(property="vault.embeddedTarget")
    private String embeddedTarget;
    @Parameter
    private Embedded[] embeddeds = new Embedded[0];
    @Parameter(property="vault.failOnMissingEmbed", defaultValue="false", required=true)
    private boolean failOnMissingEmbed;
    @Parameter
    private SubPackage[] subPackages = new SubPackage[0];
    @Parameter
    private Dependency[] repositoryStructurePackages = new Dependency[0];
    @Parameter(property="vault.generatedImportPackage", defaultValue="${project.build.directory}/vault-generated-import.txt")
    private File generatedImportPackage;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter
    private File thumbnailImage;

    public void setAccessControlHandling(String type) throws MojoFailureException {
        try {
            this.accessControlHandling = AccessControlHandling.valueOf((String)type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("Invalid accessControlHandling specified: " + type + ".\nMust be empty or one of '" + StringUtils.join((Object[])AccessControlHandling.values(), (String)"','") + "'.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.buildContext.isIncremental()) {
            this.getLog().debug((CharSequence)"Incremental build");
            if (this.filterSource == null) {
                this.getLog().debug((CharSequence)"No file change would be relevant therefore cancelling build");
                return;
            }
            if (!this.buildContext.hasDelta(this.filterSource)) {
                this.getLog().debug((CharSequence)("'" + this.filterSource + "' unchanged therefore cancelling build"));
                return;
            }
            this.getLog().debug((CharSequence)("Detecting a change on '" + this.filterSource + "' therefore not cancelling build"));
        }
        File vaultDir = this.getVaultDir();
        vaultDir.mkdirs();
        GenerateMetadataMojo.getArtifactWorkDirectoryLookup(this.getPluginContext()).put(this.getModuleArtifactKey(this.project.getArtifact()), this.workDirectory);
        try {
            Map<String, File> embeddedFiles = this.getEmbeddeds();
            embeddedFiles.putAll(this.getSubPackages());
            this.setEmbeddedFilesMap(embeddedFiles);
            File metaInfDirectory = this.getMetaInfDir();
            this.computePackageFilters(metaInfDirectory);
            this.computeImportPackage();
            String dependenciesString = this.computeDependencies();
            this.validatePackageType();
            if (this.packageType == PackageType.APPLICATION) {
                this.validateDependencies();
            } else {
                this.getLog().info((CharSequence)("Ignoring dependency validation due to non-application package type: " + this.packageType));
            }
            Properties vaultProperties = this.computeProperties(dependenciesString);
            FileOutputStream fos = new FileOutputStream(new File(vaultDir, "properties.xml"));
            vaultProperties.storeToXML(fos, this.project.getName());
            this.copyFile("/vault/config.xml", new File(vaultDir, "config.xml"));
            this.copyFile("/vault/settings.xml", new File(vaultDir, "settings.xml"));
            if (this.thumbnailImage != null && this.thumbnailImage.exists()) {
                File vaultDefinitionFolder = new File(vaultDir, "definition");
                if (!vaultDefinitionFolder.exists()) {
                    vaultDefinitionFolder.mkdir();
                }
                this.copyFile("/vault/definition/.content.xml", new File(vaultDefinitionFolder, ".content.xml"));
                FileUtils.copyFile((File)this.thumbnailImage, (File)new File(vaultDefinitionFolder, "thumbnail.png"));
            }
            MavenArchiver mavenArchiver = new MavenArchiver();
            Manifest manifest = mavenArchiver.getManifest(this.session, this.project, this.getMavenArchiveConfiguration(vaultProperties, dependenciesString));
            try (FileOutputStream out = new FileOutputStream(this.getManifestFile());){
                manifest.write(out);
                return;
            }
        }
        catch (IOException | DependencyResolutionRequiredException | ManifestException e) {
            throw new MojoExecutionException(e.toString(), (Exception)e);
        }
    }

    private void computePackageFilters(File vaultMetaDir) throws IOException, MojoExecutionException {
        File metaFilterFile;
        File filterFile = this.getFilterFile();
        if (filterFile.exists() && filterFile.lastModified() != 0L) {
            if (!this.filters.getFilterSets().isEmpty()) {
                this.getLog().error((CharSequence)"Refuse to merge inline filters and non-sourced filter.xml. If this is intended, specify the filter.xml via the 'filterSource' property.");
                throw new MojoExecutionException("conflicting filters.");
            }
            try {
                this.filters.load(filterFile);
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
            this.getLog().warn((CharSequence)"The project is using a filter.xml provided via the resource plugin.");
            this.getLog().warn((CharSequence)"This is deprecated and might no longer be supported in future versions.");
            this.getLog().warn((CharSequence)"Use the 'filterSource' property to specify the filter or use inline filters.");
            return;
        }
        if (filterFile.exists() && filterFile.lastModified() == 0L) {
            try {
                Files.delete(filterFile.toPath());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Unable to delete previously generated filter.xml. re-run the goals with a clean setup.");
                throw new MojoExecutionException("Unable to delete file.", (Exception)e);
            }
        }
        if (vaultMetaDir != null && (metaFilterFile = new File(vaultMetaDir, "filter.xml")).exists()) {
            if (this.filterSource != null && !this.filterSource.equals(metaFilterFile)) {
                this.getLog().error((CharSequence)"Project contains filter.xml in META-INF/vault but also specifies a filter source.");
                throw new MojoExecutionException("conflicting filters.");
            }
            this.filterSource = metaFilterFile;
        }
        DefaultWorkspaceFilter sourceFilters = new DefaultWorkspaceFilter();
        if (this.filterSource != null && this.filterSource.exists()) {
            this.getLog().info((CharSequence)("Loading filter from " + this.filterSource.getPath()));
            try {
                sourceFilters.load(this.filterSource);
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
            if (!this.filters.getFilterSets().isEmpty()) {
                this.getLog().info((CharSequence)"Merging inline filters.");
                this.mergeFilters(sourceFilters, this.filters);
            }
            sourceFilters.resetSource();
            try (InputStream serializedFilters = sourceFilters.getSource();){
                this.filters.load(serializedFilters);
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("cloning filters failed.", e);
            }
            sourceFilters = new DefaultWorkspaceFilter();
            try {
                sourceFilters.load(this.filterSource);
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
            sourceFilters.resetSource();
        }
        if (this.filters.getFilterSets().isEmpty() && this.prefix.length() > 0) {
            this.addWorkspaceFilter(this.prefix);
        }
        if (this.filters.getFilterSets().isEmpty()) {
            if (this.failOnEmptyFilter) {
                String msg = "No workspace filter defined (failOnEmptyFilter=true)";
                this.getLog().error((CharSequence)"No workspace filter defined (failOnEmptyFilter=true)");
                throw new MojoExecutionException("No workspace filter defined (failOnEmptyFilter=true)");
            }
            this.getLog().warn((CharSequence)"No workspace filter defined. Package import might have unexpected results.");
        }
        if (this.filterSource != null && sourceFilters.getSourceAsString().equals(this.filters.getSourceAsString())) {
            FileUtils.copyFile((File)this.filterSource, (File)filterFile);
        } else {
            this.getLog().info((CharSequence)"Generating filter.xml from plugin configuration");
            FileUtils.fileWrite((String)filterFile.getAbsolutePath(), (String)this.filters.getSourceAsString());
        }
        if (!filterFile.setLastModified(0L)) {
            this.getLog().warn((CharSequence)"Unable to set last modified of filters file. make sure to clean the project before next run.");
        }
    }

    private void mergeFilters(DefaultWorkspaceFilter dst, DefaultWorkspaceFilter src) {
        for (PathFilterSet fs : src.getFilterSets()) {
            for (PathFilterSet mfs : dst.getFilterSets()) {
                if (!mfs.getRoot().equals(fs.getRoot())) continue;
                throw new IllegalArgumentException("Merging of equal filter roots not allowed for: " + fs.getRoot());
            }
            dst.add(fs);
        }
    }

    private void validateDependencies() throws MojoExecutionException {
        List<String> errors = new DependencyValidator().addDependencies(this.dependencies).addRepositoryStructure(this.repositoryStructurePackages).setFilters(this.filters).validate().getErrors();
        if (errors.size() > 0) {
            String msg = String.format("%d error(s) detected during dependency analysis.", errors.size());
            if (this.failOnDependencyErrors) {
                this.getLog().error((CharSequence)msg);
                for (String error : errors) {
                    this.getLog().error((CharSequence)error);
                }
                throw new MojoExecutionException(msg);
            }
            this.getLog().warn((CharSequence)msg);
            for (String error : errors) {
                this.getLog().warn((CharSequence)error);
            }
        } else {
            this.getLog().info((CharSequence)"All dependencies satisfied.");
        }
    }

    private void computeImportPackage() throws IOException {
        String importPackageStr;
        TreeMap importParams = new TreeMap();
        if (this.generatedImportPackage.exists() && (importPackageStr = FileUtils.fileRead((File)this.generatedImportPackage)).length() > 0) {
            importParams.putAll(new Parameters(importPackageStr));
        }
        if (this.importPackage != null) {
            this.getLog().debug((CharSequence)("merging analyzer-packages with:\n" + this.importPackage + "\n"));
            for (Map.Entry entry : new Parameters(this.importPackage).entrySet()) {
                boolean delete = false;
                String pkg = (String)entry.getKey();
                if ("-*".equals(pkg)) {
                    importParams.clear();
                    continue;
                }
                if (pkg.charAt(0) == '-') {
                    pkg = pkg.substring(1);
                    delete = true;
                }
                if (pkg.endsWith("*")) {
                    String pkgDot = pkg.substring(0, pkg.length() - 1);
                    if (!pkgDot.endsWith(".")) {
                        pkg = pkgDot;
                        pkgDot = pkg + ".";
                    }
                    Iterator iter = importParams.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry e = iter.next();
                        String pkgName = (String)e.getKey();
                        if (!pkgName.equals(pkg) && !pkgName.startsWith(pkgDot)) continue;
                        if (delete) {
                            iter.remove();
                            continue;
                        }
                        e.setValue(entry.getValue());
                    }
                    continue;
                }
                if (delete) {
                    importParams.remove(pkg);
                    continue;
                }
                importParams.put(pkg, entry.getValue());
            }
        }
        this.importPackage = Processor.printClauses(importParams);
        if (!this.importPackage.isEmpty()) {
            this.getLog().info((CharSequence)"Merged detected packages from analyzer with 'importPackage':");
            for (Map.Entry e : importParams.entrySet()) {
                StringBuilder report = new StringBuilder();
                report.append("  ").append((String)e.getKey());
                try {
                    Processor.printClause((Map)((Map)e.getValue()), (StringBuilder)report);
                }
                catch (IOException e1) {
                    throw new IllegalStateException("Internal error while generating report", e1);
                }
                this.getLog().info((CharSequence)report);
            }
            this.getLog().info((CharSequence)"");
        }
    }

    private String computeDependencies() throws IOException {
        String dependenciesString = null;
        if (this.dependencies.length > 0) {
            dependenciesString = PackageDependency.toString(Dependency.resolve(this.project, this.getLog(), this.dependencies));
        }
        Dependency.resolve(this.project, this.getLog(), this.repositoryStructurePackages);
        return dependenciesString;
    }

    static final String escapeManifestValue(String value) {
        return value.replaceAll("\n", "\n ").replaceAll("\r(?!\n)", "\r ");
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration(Properties vaultProperties, String dependenciesString) throws IOException {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setManifest(new ManifestConfiguration());
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
            this.archive.getManifest().setAddDefaultSpecificationEntries(false);
            this.archive.getManifest().setAddDefaultImplementationEntries(true);
            PackageId id = new PackageId(this.group, this.name, this.version);
            this.archive.addManifestEntry(MF_KEY_PACKAGE_TYPE, GenerateMetadataMojo.escapeManifestValue(this.packageType.name().toLowerCase()));
            this.archive.addManifestEntry(MF_KEY_PACKAGE_ID, GenerateMetadataMojo.escapeManifestValue(id.toString()));
            this.archive.addManifestEntry(MF_KEY_PACKAGE_DESC, GenerateMetadataMojo.escapeManifestValue(vaultProperties.getProperty("description", "")));
            if (dependenciesString != null && dependenciesString.length() > 0) {
                this.archive.addManifestEntry(MF_KEY_PACKAGE_DEPENDENCIES, GenerateMetadataMojo.escapeManifestValue(dependenciesString));
            }
            TreeSet<String> rts = new TreeSet<String>();
            for (PathFilterSet p : this.filters.getFilterSets()) {
                rts.add(p.getRoot());
            }
            Object[] roots = rts.toArray(new String[rts.size()]);
            Arrays.sort(roots);
            this.archive.addManifestEntry(MF_KEY_PACKAGE_ROOTS, GenerateMetadataMojo.escapeManifestValue(StringUtils.join((Object[])roots, (String)",")));
            if (StringUtils.isNotEmpty((String)this.importPackage)) {
                this.archive.addManifestEntry(MF_KEY_IMPORT_PACKAGE, GenerateMetadataMojo.escapeManifestValue(StringUtils.deleteWhitespace((String)this.importPackage)));
            }
        }
        return this.archive;
    }

    private Properties computeProperties(String dependenciesString) {
        Properties props = new Properties();
        String description = this.project.getDescription();
        if (description == null && (description = this.project.getName()) == null) {
            description = this.project.getArtifactId();
        }
        props.put("description", description);
        for (Object o : this.properties.keySet()) {
            if (this.properties.get(o) != null) continue;
            this.properties.put(o, "");
        }
        props.putAll((Map<?, ?>)this.properties);
        props.put("group", this.group);
        props.put("name", this.name);
        props.put("version", this.version);
        props.put("groupId", this.project.getGroupId());
        props.put("artifactId", this.project.getArtifactId());
        if (dependenciesString != null && dependenciesString.length() > 0) {
            props.put("dependencies", dependenciesString);
        }
        if (!props.containsKey("createdBy")) {
            props.put("createdBy", System.getProperty("user.name"));
        }
        props.put("created", this.iso8601DateFormat.format(new Date()));
        props.put("requiresRoot", String.valueOf(this.requiresRoot));
        props.put("allowIndexDefinitions", String.valueOf(this.allowIndexDefinitions));
        props.put("packageType", this.packageType.name().toLowerCase());
        if (this.accessControlHandling != null) {
            props.put("acHandling", this.accessControlHandling.name().toLowerCase());
        }
        return props;
    }

    private Map<String, File> getEmbeddeds() throws MojoFailureException {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (Embedded emb : this.embeddeds) {
            String targetPath;
            Collection<Artifact> artifacts = emb.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                if (this.failOnMissingEmbed) {
                    throw new MojoFailureException("Embedded artifact specified " + emb + ", but no matching dependency artifact found. Add the missing dependency or fix the embed definition.");
                }
                this.getLog().warn((CharSequence)("No matching artifacts for " + emb));
                continue;
            }
            if (emb.getDestFileName() != null && artifacts.size() > 1) {
                this.getLog().warn((CharSequence)("destFileName defined but several artifacts match for " + emb));
            }
            if ((targetPath = emb.getTarget()) == null && (targetPath = this.embeddedTarget) == null) {
                String loc = this.prefix.length() == 0 ? "/apps/" : this.prefix;
                targetPath = loc + "bundles/install/";
                this.getLog().info((CharSequence)("No target path set on " + emb + "; assuming default " + targetPath));
            }
            targetPath = this.makeAbsolutePath(targetPath);
            targetPath = "jcr_root/" + targetPath;
            if (!(targetPath = FileUtils.normalize((String)targetPath)).endsWith("/")) {
                targetPath = targetPath + "/";
            }
            this.getLog().info((CharSequence)("Embedding --- " + emb + " ---"));
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                String destFileName = emb.getDestFileName();
                if (destFileName == null) {
                    if (!source.isDirectory()) {
                        destFileName = source.getName();
                    } else {
                        String layoutBaseName = Text.getName((String)this.embedArtifactLayout.pathOf(artifact));
                        MavenProject peerModule = this.findModuleForArtifact(artifact);
                        if (peerModule != null) {
                            Artifact attached = peerModule.getArtifact();
                            String defaultFinalName = attached.getArtifactId() + "-" + attached.getVersion();
                            String peerFinalName = peerModule.getBuild().getFinalName();
                            if (peerFinalName != null) {
                                destFileName = peerFinalName + layoutBaseName.substring(defaultFinalName.length());
                            }
                        }
                        if (destFileName == null) {
                            destFileName = layoutBaseName;
                        }
                    }
                }
                String targetPathName = targetPath + destFileName;
                String targetNodePathName = targetPathName.substring("jcr_root/".length() - 1);
                this.getLog().info((CharSequence)String.format("Embedding %s (from %s) -> %s", artifact.getId(), source.getAbsolutePath(), targetPathName));
                fileMap.put(targetPathName, source);
                if (!emb.isFilter()) continue;
                this.addWorkspaceFilter(targetNodePathName);
            }
        }
        return fileMap;
    }

    static Map<String, File> getArtifactWorkDirectoryLookup(Map pluginContext) {
        String workDirectoryLookupKey = "workDirectoryLookup";
        if (!pluginContext.containsKey("workDirectoryLookup")) {
            pluginContext.put("workDirectoryLookup", new ConcurrentHashMap());
        }
        return (Map)pluginContext.get("workDirectoryLookup");
    }

    MavenProject findModuleForArtifact(Artifact artifact) {
        for (MavenProject otherProject : this.session.getProjects()) {
            if (otherProject == this.project) continue;
            Artifact otherArtifact = otherProject.getArtifact();
            if (!this.getModuleArtifactKey(artifact).equals(this.getModuleArtifactKey(otherArtifact))) continue;
            return otherProject;
        }
        return null;
    }

    String getModuleArtifactKey(Artifact artifact) {
        return this.embedArtifactLayout.pathOf(artifact);
    }

    private Map<String, File> getSubPackages() throws MojoFailureException {
        String propsRelPath = "META-INF/vault/properties.xml";
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (SubPackage pack : this.subPackages) {
            Collection<Artifact> artifacts = pack.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                this.getLog().warn((CharSequence)("No matching artifacts for sub package " + pack));
                continue;
            }
            this.getLog().info((CharSequence)("Embedding --- " + pack + " ---"));
            for (Artifact artifact : artifacts) {
                File source;
                Properties props;
                block37: {
                    Serializable propsXml;
                    props = new Properties();
                    source = artifact.getFile();
                    if (source.isDirectory()) {
                        PluginDescriptor pluginDescriptor;
                        File otherWorkDirectory = null;
                        MavenProject otherProject = this.findModuleForArtifact(artifact);
                        if (otherProject != null && (pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor")) != null) {
                            Map otherContext = this.session.getPluginContext(pluginDescriptor, otherProject);
                            otherWorkDirectory = GenerateMetadataMojo.getArtifactWorkDirectoryLookup(otherContext).get(this.getModuleArtifactKey(artifact));
                        }
                        if (otherWorkDirectory == null) {
                            otherWorkDirectory = source;
                        }
                        propsXml = new File(otherWorkDirectory, "META-INF/vault/properties.xml");
                        try (FileInputStream input = new FileInputStream((File)propsXml);){
                            props.loadFromXML(input);
                            break block37;
                        }
                        catch (IOException e) {
                            throw new MojoFailureException("Could not read META-INF/vault/properties.xml from directory '" + otherWorkDirectory + "' to extract metadata: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    InputStream in = null;
                    try {
                        ZipFile zip = new ZipFile(source, 1);
                        propsXml = null;
                        try {
                            ZipEntry e = zip.getEntry("META-INF/vault/properties.xml");
                            if (e == null) {
                                throw new IOException("Package does not contain 'META-INF/vault/properties.xml'");
                            }
                            in = zip.getInputStream(e);
                            props.loadFromXML(in);
                        }
                        catch (Throwable throwable) {
                            propsXml = throwable;
                            throw throwable;
                        }
                        finally {
                            if (zip != null) {
                                if (propsXml != null) {
                                    try {
                                        zip.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)propsXml).addSuppressed(throwable);
                                    }
                                } else {
                                    zip.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        try {
                            throw new MojoFailureException("Could not open subpackage '" + source + "' to extract metadata: " + e.getMessage(), (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(in);
                            throw throwable;
                        }
                    }
                    IOUtil.close((InputStream)in);
                }
                PackageId pid = new PackageId(props.getProperty("group"), props.getProperty("name"), props.getProperty("version"));
                String targetNodePathName = pid.getInstallationPath() + ".zip";
                String targetPathName = "jcr_root" + targetNodePathName;
                this.getLog().info((CharSequence)String.format("Embedding %s (from %s) -> %s", artifact.getId(), source.getAbsolutePath(), targetPathName));
                fileMap.put(targetPathName, source);
                if (!pack.isFilter()) continue;
                this.addWorkspaceFilter(targetNodePathName);
            }
        }
        return fileMap;
    }

    private void addWorkspaceFilter(String filterRoot) {
        this.filters.add(new PathFilterSet(filterRoot));
    }

    private String makeAbsolutePath(String relPath) {
        String absPath;
        if (!relPath.startsWith("/")) {
            absPath = (this.prefix.length() == 0 ? "/" : this.prefix) + relPath;
            this.getLog().info((CharSequence)("Relative path resolved to " + absPath));
        } else {
            absPath = relPath;
        }
        return absPath;
    }

    private void validatePackageType() throws MojoFailureException {
        if (this.packageType == null) {
            boolean hasApps = false;
            boolean hasOther = false;
            for (PathFilterSet p : this.filters.getFilterSets()) {
                if ("cleanup".equals(p.getType())) continue;
                String root = p.getRoot();
                if ("/apps".equals(root) || root.startsWith("/apps/") || "/libs".equals(root) || root.startsWith("/libs/")) {
                    hasApps = true;
                    continue;
                }
                hasOther = true;
            }
            this.packageType = hasApps && !hasOther ? PackageType.APPLICATION : (hasOther && !hasApps ? PackageType.CONTENT : PackageType.MIXED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String source, File target) throws IOException {
        if (target.exists()) {
            return;
        }
        target.getParentFile().mkdirs();
        InputStream ins = ((Object)((Object)this)).getClass().getResourceAsStream(source);
        if (ins != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(target);
                IOUtil.copy((InputStream)ins, (OutputStream)out);
            }
            finally {
                IOUtil.close((InputStream)ins);
                IOUtil.close((OutputStream)out);
            }
        }
    }
}

