/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.filevault.maven.packaging.AbstractPackageMojo;
import org.apache.jackrabbit.filevault.maven.packaging.ContentPackageArchiver;
import org.apache.jackrabbit.filevault.maven.packaging.Filters;
import org.apache.jackrabbit.filevault.maven.packaging.impl.FileValidator;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class VaultMojo
extends AbstractPackageMojo {
    private static final String PACKAGE_TYPE = "zip";
    private static final String PACKAGE_EXT = ".zip";
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Deprecated
    @Parameter
    private File builtContentDirectory;
    @Parameter(property="vault.jcrRootSourceDirectory", required=true, defaultValue="${project.basedir}/jcr_root,${project.basedir}/src/main/jcr_root,${project.basedir}/src/main/content/jcr_root,${project.basedir}/src/content/jcr_root,${project.build.outputDirectory}")
    private File[] jcrRootSourceDirectory;
    @Parameter(property="vault.failOnUncoveredSourceFiles", required=true, defaultValue="false")
    private boolean failOnUncoveredSourceFiles;
    @Parameter(property="vault.failOnDuplicateEntries", required=true, defaultValue="true")
    private boolean failOnDuplicateEntries;
    @Parameter(property="vault.finalName", defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter
    private MavenArchiveConfiguration archive;
    @Parameter(property="vault.excludes", defaultValue="**/.vlt,**/.vltignore", required=true)
    private String[] excludes;

    @Nonnull
    private FileSet createFileSet(@Nonnull File directory, @Nonnull String prefix) {
        return this.createFileSet(directory, prefix, null);
    }

    @Nonnull
    private FileSet createFileSet(@Nonnull File directory, @Nonnull String prefix, List<String> additionalExcludes) {
        LinkedList<String> excludes = new LinkedList<String>(Arrays.asList(this.excludes));
        if (additionalExcludes != null) {
            excludes.addAll(additionalExcludes);
        }
        return (FileSet)((DefaultFileSet)((DefaultFileSet)DefaultFileSet.fileSet((File)directory).prefixed(prefix)).includeExclude(null, excludes.toArray(new String[0]))).includeEmptyDirs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        File finalFile = new File(this.outputDirectory, this.finalName + PACKAGE_EXT);
        try {
            File jcrSourceDirectory;
            File metaInfDirectory = this.getMetaInfDir();
            if (this.builtContentDirectory != null) {
                this.getLog().warn((CharSequence)"The 'builtContentDirectory' is deprecated. Please use the new 'jcrRootSourceDirectory' instead.");
                jcrSourceDirectory = this.builtContentDirectory;
            } else {
                jcrSourceDirectory = VaultMojo.getFirstExistingDirectory(this.jcrRootSourceDirectory);
            }
            if (jcrSourceDirectory != null) {
                this.getLog().info((CharSequence)("packaging content from " + jcrSourceDirectory.getPath()));
            }
            Filters filters = this.loadFilterFile();
            Map<String, File> embeddedFiles = this.getEmbeddedFilesMap();
            ContentPackageArchiver contentPackageArchiver = new ContentPackageArchiver();
            if (this.failOnDuplicateEntries) {
                contentPackageArchiver.setDuplicateBehavior("fail");
            }
            contentPackageArchiver.setIncludeEmptyDirs(true);
            if (metaInfDirectory != null) {
                contentPackageArchiver.addFileSet(this.createFileSet(metaInfDirectory, "META-INF/vault/", Collections.singletonList("filter.xml")));
            }
            Collection<File> workDirectoryFilesNotYetExistingInArchive = this.getUncoveredFiles(this.workDirectory, "", contentPackageArchiver.getFiles().keySet(), Collections.singletonList("META-INF/MANIFEST.MF"));
            for (File file : workDirectoryFilesNotYetExistingInArchive) {
                contentPackageArchiver.addFile(file, this.workDirectory.toPath().relativize(file.toPath()).toString());
            }
            for (Map.Entry entry : embeddedFiles.entrySet()) {
                contentPackageArchiver.addFile((File)entry.getValue(), (String)entry.getKey());
            }
            if (jcrSourceDirectory != null && jcrSourceDirectory.exists()) {
                Collection<File> collection;
                List filterSets = filters.getFilterSets();
                if (filterSets.isEmpty()) {
                    contentPackageArchiver.addFileSet(this.createFileSet(jcrSourceDirectory, FileUtils.normalize((String)("jcr_root/" + this.prefix))));
                } else {
                    for (Object filterSet : filterSets) {
                        String relPath = PlatformNameFormat.getPlatformPath((String)filterSet.getRoot());
                        String rootPath = FileUtils.normalize((String)("jcr_root/" + this.prefix + relPath));
                        if (embeddedFiles.containsKey(rootPath)) continue;
                        File fullCoverage = new File(jcrSourceDirectory, relPath + ".xml");
                        if (fullCoverage.isFile()) {
                            rootPath = FileUtils.normalize((String)("jcr_root/" + this.prefix + relPath + ".xml"));
                            contentPackageArchiver.addFile(fullCoverage, rootPath);
                            continue;
                        }
                        boolean isFilterRootDirectory = true;
                        File rootDirectory = new File(jcrSourceDirectory, relPath);
                        while (!(rootDirectory.exists() && rootDirectory.isDirectory() || jcrSourceDirectory.equals(rootDirectory) || fullCoverage.isFile())) {
                            rootDirectory = rootDirectory.getParentFile();
                            relPath = StringUtils.chomp((String)relPath, (String)"/");
                            fullCoverage = new File(rootDirectory, relPath + ".xml");
                            isFilterRootDirectory = false;
                        }
                        if (fullCoverage.isFile()) {
                            rootPath = FileUtils.normalize((String)("jcr_root/" + this.prefix + relPath + ".xml"));
                            contentPackageArchiver.addFile(fullCoverage, rootPath);
                            continue;
                        }
                        rootPath = FileUtils.normalize((String)("jcr_root/" + this.prefix + relPath));
                        if (isFilterRootDirectory) {
                            contentPackageArchiver.addFileSet(this.createFileSet(rootDirectory, rootPath + "/"));
                            continue;
                        }
                        contentPackageArchiver.addFileSet(this.createFileSet(rootDirectory, rootPath + "/", Collections.singletonList("%regex[^(?!\\.content\\.xml).*]")));
                    }
                }
                if (this.failOnDuplicateEntries) {
                    try {
                        ResourceIterator resourceIterator = contentPackageArchiver.getResources();
                        while (resourceIterator.hasNext()) {
                            resourceIterator.next();
                        }
                    }
                    catch (ArchiverException archiverException) {
                        if (archiverException.getMessage() != null && archiverException.getMessage().startsWith("Duplicate file")) {
                            throw new MojoFailureException("Found duplicate files in content package, most probably you have overlapping filter roots or you embed a file which is already there in 'jcrRootSourceDirectory'. For details check the nested exception!", (Throwable)archiverException);
                        }
                        throw archiverException;
                    }
                }
                if (!(collection = this.getUncoveredFiles(jcrSourceDirectory, "jcr_root/" + this.prefix, contentPackageArchiver.getFiles().keySet(), null)).isEmpty()) {
                    for (File uncoveredFile : collection) {
                        this.getLog().warn((CharSequence)("File " + uncoveredFile + " not covered by a filter rule and therefore not contained in the resulting package"));
                    }
                    if (this.failOnUncoveredSourceFiles) {
                        throw new MojoFailureException("The following files are not covered by a filter rule: \n" + StringUtils.join(collection.iterator(), (String)",\n"));
                    }
                }
            }
            if (!this.allowIndexDefinitions) {
                FileValidator fileValidator = new FileValidator();
                this.getLog().info((CharSequence)"Scanning files for oak index definitions.");
                for (ArchiveEntry entry : contentPackageArchiver.getFiles().values()) {
                    if (entry.getType() != 1) continue;
                    InputStream in = null;
                    try {
                        in = entry.getInputStream();
                        String sanitizedFileName = FilenameUtils.separatorsToUnix((String)entry.getName());
                        fileValidator.lookupIndexDefinitionInArtifact(in, sanitizedFileName);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                if (fileValidator.isContainingIndexDef) {
                    this.getLog().error((CharSequence)fileValidator.getMessageWithPathsOfIndexDef());
                    throw new MojoExecutionException("Package should not contain index definitions, because 'allowIndexDefinitions=false'.");
                }
            }
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver((JarArchiver)contentPackageArchiver);
            mavenArchiver.setOutputFile(finalFile);
            mavenArchiver.createArchive(null, this.project, this.getMavenArchiveConfiguration(this.getManifestFile()));
            Artifact artifact = this.project.getArtifact();
            artifact.setFile(finalFile);
            artifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler(PACKAGE_TYPE));
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.toString(), e);
        }
    }

    private Collection<File> getUncoveredFiles(File sourceDirectory, String prefix, Collection<String> entryNames, List<String> additionalExcludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        LinkedList<String> excludes = new LinkedList<String>(Arrays.asList(this.excludes));
        if (additionalExcludes != null) {
            excludes.addAll(additionalExcludes);
        }
        scanner.setExcludes(excludes.toArray(new String[0]));
        scanner.addDefaultExcludes();
        scanner.scan();
        return this.getUncoveredFiles(sourceDirectory, scanner.getIncludedFiles(), prefix, entryNames);
    }

    private Collection<File> getUncoveredFiles(File sourceDirectory, String[] relativeSourceFileNames, String prefix, Collection<String> entryNames) {
        ArrayList<File> uncoveredFiles = new ArrayList<File>();
        for (String relativeSourceFileName : relativeSourceFileNames) {
            if (entryNames.contains(prefix + relativeSourceFileName)) continue;
            uncoveredFiles.add(new File(sourceDirectory, relativeSourceFileName));
        }
        return uncoveredFiles;
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration(File manifestFile) {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
        }
        this.archive.setManifestFile(manifestFile);
        return this.archive;
    }
}

